/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-02 09:43:42
 * @LastEditTime: 2021-04-27 14:30:22
 * @LastModifyUser: 
 * @Remark: 
 */
function BusinessModelFolder() {
    var me = this;
    this.folderID = null;
    this.folderName = null;
    this.folderParentID = null;
    this.organizationID = null;
    this.businessModelType = null;
    this.createUserID = $AppVars.gUser.userID;
    this.createUserName = $AppVars.gUser.userName;
    this.createDate = (new Date()).getTime();
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };

    this.getItemByID = function (folderID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelFoldersPath + "/" + folderID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
}

function BusinessModelFolders() {
    var me = this;
    this.count = 0;
    this.aryBusinessModelFolders = [];
    this.dicBusinessModelFolders = {};

    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryBusinessModelFolders[indexOrKey];
        } else {
            return this.dicBusinessModelFolders[indexOrKey];
        }
    };
    this.add = function (businessModelFolder) {
        this.aryBusinessModelFolders.push(businessModelFolder);
        this.dicBusinessModelFolders[businessModelFolder.folderID] = businessModelFolder;
        this.count = this.aryBusinessModelFolders.length;
    };
    this.remove = function (businessModelFolder) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryBusinessModelFolders[i].folderID == businessModelFolder.folderID) {
                k = i;
                break;
            }
        }
        this.aryBusinessModelFolders.splice(k, 1);
        delete this.dicBusinessModelFolders[businessModelFolder.folderID];
        this.count = this.aryBusinessModelFolders.length;
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelFoldersPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setBusinessModelFolders(data.items);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getItemsByType = function (businessModelType, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelFoldersPath + "?businessModelType=" + businessModelType;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setBusinessModelFolders(data.items);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.addItem = function (folder, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelFoldersPath;
        var obj = JSON.stringify(folder);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                var folderID = request.getResponseHeader('location').split('/businessModelFolders/')[1];
                folder.folderID = folderID;
                me.add(folder);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (folder, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelFoldersPath + "/" + folder.folderID;
        var obj = JSON.stringify(folder);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (folderID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelFoldersPath + "/" + folderID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(folderID));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setBusinessModelFolders(data) {
        me.count = 0;
        me.aryBusinessModelFolders = [];
        me.dicBusinessModelFolders = {};
        for (var i = 0; i < data.length; i++) {
            var businessModelFolder = new BusinessModelFolder();
            businessModelFolder.init(data[i]);
            me.add(businessModelFolder);
        }
    }
}

function BmPublish(){
    var me = this;
    this.businessModelID = null;
    this.organizationID = null;
    this.publishType = null;
    this.publishStatus = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.bmpDestinationOrganizations = new BmpDestinationOrganizations();

    this.init = function (options) {
        for (var key in options) {
            if (key == "bmpDestinationOrganizations") {
                this[key].setBmpDestinationOrganizations(options[key]);
            } else {
                this[key] = options[key];
            }
        }
    };

    this.getItemByID = function (asyncOrSync, succ, fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bmPublishesPath + "/" + this.businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
}

function BmPublishes(){
    var me = this;
    this.count = 0;
    this.aryBmPublishes = [];
    this.dicBmPublishes = {};

    this.add = function (bmPublish) {
        this.aryBmPublishes.push(bmPublish);
        this.dicBmPublishes[bmPublish.businessModelID] = bmPublish;
        this.count = this.aryBmPublishes.length;
    };
    this.remove = function (bmPublish) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryBmPublishes[i].businessModelID == bmPublish.businessModelID) {
                k = i;
                break;
            }
        }
        this.aryBmPublishes.splice(k, 1);
        delete this.dicBmPublishes[bmPublish.businessModelID];
        this.count = this.aryBmPublishes.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryBmPublishes[indexOrKey];
        } else {
            return this.dicBmPublishes[indexOrKey];
        }
    };
    this.addItem = function (businessModel, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bmPublishesPath;
        var obj = JSON.stringify(businessModel);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (bmPublish, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bmPublishesPath + "/" + bmPublish.businessModelID;
        var obj = JSON.stringify(bmPublish);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getItems = function (asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.bmPublishesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setBmPublishes(data.items);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setBmPublishes(data) {
        me.count = 0;
        me.aryBmPublishes = [];
        me.dicBmPublishes = {};
        for (var i = 0; i < data.length; i++) {
            var bmPublish = new BmPublish();
            bmPublish.init(data[i]);
            me.add(bmPublish);
        }
    }
}

function BmpDestinationOrganization(){
    this.businessModelID = null;
    this.destinationOrganizationID = null;

    this.init = function (options) {
        for (var key in options) {
            this[key] = options[key];
        }
    };
}

function BmpDestinationOrganizations(){
    var me = this;
    this.count = 0;
    this.aryBmpDestinationOrganizations = [];
    this.dicBmpDestinationOrganizations = {};

    this.add = function (bmpDestinationOrganization) {
        this.aryBmpDestinationOrganizations.push(bmpDestinationOrganization);
        this.dicBmpDestinationOrganizations[bmpDestinationOrganization.destinationOrganizationID] = bmpDestinationOrganization;
        this.count = this.aryBmpDestinationOrganizations.length;
    };
    this.remove = function (bmpDestinationOrganization) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryBmpDestinationOrganizations[i].destinationOrganizationID == bmpDestinationOrganization.destinationOrganizationID) {
                k = i;
                break;
            }
        }
        this.aryBmpDestinationOrganizations.splice(k, 1);
        delete this.dicBmpDestinationOrganizations[bmpDestinationOrganization.destinationOrganizationID];
        this.count = this.aryBmpDestinationOrganizations.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryBmpDestinationOrganizations[indexOrKey];
        } else {
            return this.dicBmpDestinationOrganizations[indexOrKey];
        }
    };
    this.setBmpDestinationOrganizations = function(data) {
        me.count = 0;
        me.aryBmpDestinationOrganizations = [];
        me.dicBmpDestinationOrganizations = {};
        for (var i = 0; i < data.length; i++) {
            var bmpDestinationOrganization = new BmpDestinationOrganization();
            bmpDestinationOrganization.init(data[i]);
            me.add(bmpDestinationOrganization);
        }
    }
}

function BusinessModel(){
    this.businessModelID = null;
    this.businessModelName = null;
    this.businessModelType = null;
    this.folderID = null;
    this.description = null;
    this.dataSourceID = null;
    this.dataSourceName = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = null;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.sourceType = null;
    this.sourceBusinessModelID = null;
    this.sourceOrganizationID = null;
    this.sourceOrganizationName = null;
    this.publishStatus = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function BusinessModels(){
    var me = this;
    this.count = 0;
    this.aryBusinessModels = [];
    this.dicBusinessModels = {};

    this.add = function (businessModel) {
        this.aryBusinessModels.push(businessModel);
        this.dicBusinessModels[businessModel.businessModelID] = businessModel;
        this.count = this.aryBusinessModels.length;
    };
    this.remove = function (businessModel) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryBusinessModels[i].businessModelID==businessModel.businessModelID){
                k = i;
                break;
            }
        }
        this.aryBusinessModels.splice(k,1);
        delete this.dicBusinessModels[businessModel.businessModelID];
        this.count = this.aryBusinessModels.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryBusinessModels[indexOrKey];
        }else{
            return this.dicBusinessModels[indexOrKey];
        }
    };
    this.addItem = function(businessModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath;
        var obj = JSON.stringify(businessModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(businessModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "/" + businessModel.businessModelID;
        var obj = JSON.stringify(businessModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(businessModel.businessModelID).businessModelName = businessModel.businessModelName;
                me.item(businessModel.businessModelID).description = businessModel.description;
                me.item(businessModel.businessModelID).databaseLinkID = businessModel.databaseLinkID;
                me.item(businessModel.businessModelID).databaseLinkName = businessModel.databaseLinkName;
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    }
    this.deleteItem = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "/" + businessModelID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID="+moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.setBusinessModels(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getUsedCount = function(dataSourceID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "/count?dataSourceID="+dataSourceID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.property);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.setBusinessModels = function(data){
        me.count = 0;
        me.aryBusinessModels = [];
        me.dicBusinessModels = {};
        for(var i = 0; i < data.length; i++){
            var businessModel = new BusinessModel();
            businessModel.init(data[i]);
            me.add(businessModel);
        }
    }
}

function RelationModel(){
    var me = this;
    BusinessModel.call(this);

    this.relationDiagramFolders = [];
    this.relationDiagrams = [];
    this.businessObjectFolders = new BusinessObjectFolders();
    this.businessObjects = new BusinessObjects();
    this.queryTableRestrictions = [];

    this.init = function(options){
        for(var key in options){
            if(key == "businessObjectFolders"){
                this[key].setBusinessObjectFolders(options[key]);
            }else if(key == "businessObjects"){
                this[key].setBusinessObjects(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };

    this.initByModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath + "/" + businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

}

function RelationModels(){
    var me = this;
    this.count = 0;
    this.aryRelationModels = [];
    this.dicRelationModels = {};

    this.add = function (relationModel) {
        this.aryRelationModels.push(relationModel);
        this.dicRelationModels[relationModel.businessModelID] = relationModel;
        this.count = this.aryRelationModels.length;
    };
    this.remove = function (relationModel) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryRelationModels[i].businessModelID==relationModel.businessModelID){
                k = i;
                break;
            }
        }
        this.aryRelationModels.splice(k,1);
        delete this.dicRelationModels[relationModel.businessModelID];
        this.count = this.aryRelationModels.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryRelationModels[indexOrKey];
        }else{
            return this.dicRelationModels[indexOrKey];
        }
    };
    this.addItem = function(relationModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath;
        var obj = JSON.stringify(relationModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var businessModelID = request.getResponseHeader('location').split('/relationModels/')[1];
                succ(businessModelID);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(relationModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath + "/" + relationModel.businessModelID;
        var obj = JSON.stringify(relationModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(relationModel.businessModelID).relationModelName = relationModel.relationModelName;
                me.item(relationModel.businessModelID).folderID = relationModel.folderID;
                me.item(relationModel.businessModelID).description = relationModel.description;
                me.item(relationModel.businessModelID).dataSourceID = relationModel.dataSourceID;
                me.item(relationModel.businessModelID).dataSourceName = relationModel.dataSourceName;
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editSimpleProperties = function(relationModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath + "/" + relationModel.businessModelID + "/simpleProperties";
        var obj = JSON.stringify(relationModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(relationModel.businessModelID).relationModelName = relationModel.relationModelName;
                me.item(relationModel.businessModelID).folderID = relationModel.folderID;
                me.item(relationModel.businessModelID).description = relationModel.description;
                me.item(relationModel.businessModelID).dataSourceID = relationModel.dataSourceID;
                me.item(relationModel.businessModelID).dataSourceName = relationModel.dataSourceName;
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.relationModelPath + "/" + businessModelID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID="+moduleID+"&businessModelType=0";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setRelationModels(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setRelationModels(data){
        me.count = 0;
        me.aryRelationModels = [];
        me.dicRelationModels = {};
        for(var i = 0; i < data.length; i++){
            var relationModel = new RelationModel();
            relationModel.init(data[i]);
            me.add(relationModel);
        }
    }
}

function TableModel(){
    var me = this;
    BusinessModel.call(this);
    this.tableName = null;
    this.schemaName = null;
    this.businessObjects = new BusinessObjects();

    this.initByModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tableModelPath + "/" + businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(options){
        for(var key in options){
            if(key == "businessObjects"){
                this[key].setBusinessObjects(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
}

function TableModels(){
    var me = this;
    this.count = 0;
    this.aryTableModels = [];
    this.dicTableModels = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTableModels[indexOrKey];
        }else{
            return this.dicTableModels[indexOrKey];
        }
    };
    this.add = function (tableModel) {
        this.aryTableModels.push(tableModel);
        this.dicTableModels[tableModel.businessModelID] = tableModel;
        this.count = this.aryTableModels.length;
    };
    this.remove = function (tableModel) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTableModels[i].businessModelID==tableModel.businessModelID){
                k = i;
                break;
            }
        }
        this.aryTableModels.splice(k,1);
        delete this.dicTableModels[tableModel.businessModelID];
        this.count = this.aryTableModels.length;
    };
    this.addItem = function(tableModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tableModelPath;
        var obj = JSON.stringify(tableModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if (request.status == 201) {
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(tableModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tableModelPath + "/" + tableModel.businessModelID;
        var obj = JSON.stringify(tableModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(tableModel.businessModelID).initByModelID(tableModel.businessModelID,true,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessModelID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.tableModelPath + "/" + businessModelID + "?moduleID=" + moduleID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID=" + moduleID + "&businessModelType=1";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setTableModels(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setTableModels(data){
        me.count = 0;
        me.aryTableModels = [];
        me.dicTableModels = {};
        for(var i = 0; i < data.length; i++){
            var tableModel = new TableModel();
            tableModel.init(data[i]);
            me.add(tableModel);
        }
    }
}

function SqlModel(){
    var me = this;
    BusinessModel.call(this);
    this.sqlText = null;
    this.businessObjects = new BusinessObjects();

    this.initByModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.sqlModelPath + "/" + businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(options){
        for(var key in options){
            if(key == "businessObjects"){
                this[key].setBusinessObjects(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    }
}

function SqlModels(){
    var me = this;
    this.count = 0;
    this.arySqlModels = [];
    this.dicSqlModels = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.arySqlModels[indexOrKey];
        }else{
            return this.dicSqlModels[indexOrKey];
        }
    };
    this.add = function (sqlModel) {
        this.arySqlModels.push(sqlModel);
        this.dicSqlModels[sqlModel.businessModelID] = sqlModel;
        this.count = this.arySqlModels.length;
    };
    this.remove = function (sqlModel) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.arySqlModels[i].businessModelID==sqlModel.businessModelID){
                k = i;
                break;
            }
        }
        this.arySqlModels.splice(k,1);
        delete this.dicSqlModels[sqlModel.businessModelID];
        this.count = this.arySqlModels.length;
    };
    this.addItem = function(sqlModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.sqlModelPath;
        var obj = JSON.stringify(sqlModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(sqlModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.sqlModelPath + "/" + sqlModel.businessModelID;
        var obj = JSON.stringify(sqlModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(sqlModel.businessModelID).initByModelID(sqlModel.businessModelID,true,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessModelID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.sqlModelPath + "/" + businessModelID + "?moduleID=" + moduleID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID=" + moduleID + "&businessModelType=2";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setSqlModels(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setSqlModels(data){
        me.count = 0;
        me.arySqlModels = [];
        me.dicSqlModels = {};
        for(var i = 0; i < data.length; i++){
            var sqlModel = new SqlModel();
            sqlModel.init(data[i]);
            me.add(sqlModel);
        }
    }
}

function ExcelModel(){
    var me = this;
    BusinessModel.call(this);
    this.excelFileName = null;
    this.businessObjects = new BusinessObjects();

    this.initByModelID = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelModelPath + "/" + businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.init = function(options){
        for(var key in options){
            if(key == "businessObjects"){
                this[key].setBusinessObjects(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    }
}

function ExcelModels(){
    var me = this;
    this.count = 0;
    this.aryExcelModels = [];
    this.dicExcelModels = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryExcelModels[indexOrKey];
        }else{
            return this.dicExcelModels[indexOrKey];
        }
    };
    this.add = function (excelModel) {
        this.aryExcelModels.push(excelModel);
        this.dicExcelModels[excelModel.businessModelID] = excelModel;
        this.count = this.aryExcelModels.length;
    };
    this.remove = function (excelModel) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryExcelModels[i].businessModelID==excelModel.businessModelID){
                k = i;
                break;
            }
        }
        this.aryExcelModels.splice(k,1);
        delete this.dicExcelModels[excelModel.businessModelID];
        this.count = this.aryExcelModels.length;
    };
    this.addItem = function(excelModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelModelPath;
        var obj = JSON.stringify(excelModel);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(excelModel,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelModelPath + "/" + excelModel.businessModelID;
        var obj = JSON.stringify(excelModel);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(excelModel.businessModelID).initByModelID(excelModel.businessModelID,true,succ,fail);
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(businessModelID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.excelModelPath + "/" + businessModelID + "?moduleID=" + moduleID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(businessModelID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID=" + moduleID + "&businessModelType=3";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setExcelModels(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setExcelModels(data){
        me.count = 0;
        me.aryExcelModels = [];
        me.dicExcelModels = {};
        for(var i = 0; i < data.length; i++){
            var excelModel = new ExcelModel();
            excelModel.init(data[i]);
            me.add(excelModel);
        }
    }
}

function StoredProcedureModel(){
    var me = this;
    BusinessModel.call(this);

    this.storedProcedureName = null;
    this.businessObjects = new BusinessObjects();

    this.initByModelID = function (businessModelID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.storedProcedureModelPath + "/" + businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    this.init = function (options) {
        for (var key in options) {
            if (key == "businessObjects") {
                this[key].setBusinessObjects(options[key]);
            } else {
                this[key] = options[key];
            }
        }
    };
}

function StoredProcedureModels(){
    var me = this;
    this.count = 0;
    this.aryStoredProcedureModels = [];
    this.dicStoredProcedureModels = {};

    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryStoredProcedureModels[indexOrKey];
        } else {
            return this.dicStoredProcedureModels[indexOrKey];
        }
    };
    this.add = function (storedProcedureModel) {
        this.aryStoredProcedureModels.push(storedProcedureModel);
        this.dicStoredProcedureModels[storedProcedureModel.businessModelID] = storedProcedureModel;
        this.count = this.aryStoredProcedureModels.length;
    };
    this.remove = function (storedProcedureModel) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryStoredProcedureModels[i].businessModelID == storedProcedureModel.businessModelID) {
                k = i;
                break;
            }
        }
        this.aryStoredProcedureModels.splice(k, 1);
        delete this.dicStoredProcedureModels[storedProcedureModel.businessModelID];
        this.count = this.aryStoredProcedureModels.length;
    };
    this.addItem = function (storedProcedureModel, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.storedProcedureModelPath;
        var obj = JSON.stringify(storedProcedureModel);
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.editItem = function (storedProcedureModel, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.storedProcedureModelPath + "/" + storedProcedureModel.businessModelID;
        var obj = JSON.stringify(storedProcedureModel);

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.item(storedProcedureModel.businessModelID).initByModelID(storedProcedureModel.businessModelID, true, succ, fail);
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.deleteItem = function (businessModelID, moduleID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.storedProcedureModelPath + "/" + businessModelID + "?moduleID=" + moduleID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 204) {
                me.remove(me.item(businessModelID));
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getItems = function (moduleID, asyncOrSync, succ, fail) {
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.businessModelPath + "?moduleID=" + moduleID + "&businessModelType=4";
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                setStoredProcedureModels(data.items);
                succ();
            }
        };
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };

    function setStoredProcedureModels(data) {
        me.count = 0;
        me.aryStoredProcedureModels = [];
        me.dicStoredProcedureModels = {};
        for (var i = 0; i < data.length; i++) {
            var storedProcedureModel = new StoredProcedureModel();
            storedProcedureModel.init(data[i]);
            me.add(storedProcedureModel);
        }
    }
}

function BmSubscriptionController(){
    this.getSubscribedBM = function (businessModelType,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + "/BusinessModel/bmSubscriptions?businessModelType=" + businessModelType;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                succ(data.items);
            }
        };
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.getSubscriptionableBM = function (businessModelType, asyncOrSync, succ, fail){
        var url = $AppConstants.hostName + $AppConstants.port + "/BusinessModel/subscriptionableBM?businessModelType=" + businessModelType;
        var obj = "";

        var dataType = 'json';
        var succCallback = function (data, status, request) {
            if (request.status == 200) {
                succ(data.items);
            }
        };
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
    this.subscribeBusinessModel = function (businessModelID, asyncOrSync, succ, fail){
        var url = $AppConstants.hostName + $AppConstants.port + "/BusinessModel/businessModels/" + businessModelID + "/subscription";
        var obj = "";
        var dataType = 'text';
        var succCallback = function (data, status, request) {
            if (request.status == 201) {
                succ();
            }
        }
        var failCallback = function (XHR, textStatus) {

            if (XHR.readyState == 0 && !window.navigator.onLine) {
                fail("网络连接不可用。");
            } else if (textStatus == "timeout") {
                fail("请求超时。");
            } else if (XHR.status || XHR.status == 0) {
                if (!$Utils.request.isJson(XHR.responseText)) {
                    fail(XHR.status, XHR.responseText);
                } else {
                    fail(XHR.status, JSON.parse(XHR.responseText).error);
                }
            } else {
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url, obj, asyncOrSync, dataType, succCallback, failCallback);
    };
}