/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-09 09:42:02
 * @LastEditTime: 2021-05-11 09:14:18
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, form = layui.form, element = layui.element, tree = layui.tree;
    var formEditSubmit = null;
    var layerIndex = null;
    var mTableModel = null;
    var mFolders = null;
    var fieldDetailsList = [];
    var databaseLinks = new DatabaseLinks();

    var dataType = [
        {"id": 0, "name": "字符串"},
        {"id": 1, "name": "日期"},
        {"id": 2, "name": "数字"},
        {"id": 3, "name": "图像URL"},
        {"id": 4, "name": "图像二进制"},
    ];
    var objectType = [
        {"id": 0, "name": "维度"},
        {"id": 1, "name": "度量"}
    ];
    var aggregation = [
        {"id": 0, "name": "无"},
        {"id": 1, "name": "总和"},
        {"id": 2, "name": "平均"},
        {"id": 3, "name": "计数"},
        {"id": 4, "name": "最大值"},
        {"id": 5, "name": "最小值"}
    ];
    var sort = [
        {"id": 0, "name": "无排序"},
        {"id": 1, "name": "升序"},
        {"id": 2, "name": "降序"},
    ];
    
    window.initEditTableModel = function (index, tableModel, businessModelFolders,editSubmit){
        layerIndex = index;
        mTableModel = tableModel;
        formEditSubmit = editSubmit;
        mFolders = businessModelFolders;

        getBusinessObjects(tableModel);
        getDatabaseLinks();
        createTreeSelect();
        initEditTableModelForm(tableModel);
        $Utils.windowLoading.close();
    }

    function getBusinessObjects(tableModel){
        var succ = function(){};
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+tableModel.businessModelName+" 业务对象",errorStatus,msg);
        };
		mTableModel.initByModelID(tableModel.businessModelID,false,succ,fail);
    }

    function getDatabaseLinks(){
        var succ = function(){
            $Utils.loading.close();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库连接",errorStatus,msg);
		};
		databaseLinks.getItems(2,false,succ,fail);
    }

    function createTreeSelect() {
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function (node) { //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
            },
        });
        if (mTableModel.folderID == -1) {
            $(".model-window .layui-form-select").find(".layui-select-title span").html("数据表模型").end().find("input:hidden[name='folderID']").val(-1);
        } else {
            $(".model-window .layui-form-select").find(".layui-select-title span").html(mFolders.item(mTableModel.folderID).folderName).end().find("input:hidden[name='folderID']").val(mTableModel.folderID);
        }
        $(".model-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".model-window .parent-folder .layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders() {
        var index = 0;
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { title: "数据表模型", id: index, folderID: "-1", folderParentID: "0", spread: true });
        index++;
        for (var i = 0; i < mFolders.count; i++) {
            hashTable.add(mFolders.item(i).folderID, { title: mFolders.item(i).folderName, id: index, folderID: mFolders.item(i).folderID, folderParentID: mFolders.item(i).folderParentID });
            index++;
        }
        for (var i = 0; i < mFolders.count; i++) {
            var parentFolder = hashTable.getValue(mFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(mFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function initEditTableModelForm(tableModel){
        form.val("editTableModel",{
            "businessModelName": tableModel.businessModelName,
            "description": tableModel.description,
            "tableName": tableModel.tableName
        });
        $(".edit-table-model input[name=businessModelName]").focus();

        var createUserName = tableModel.createUserName || "";
        var createDate = tableModel.createDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(tableModel.createDate)) : "";
        var lastModifyUserName = tableModel.lastModifyUserName || "";
        var lastModifyDate = tableModel.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(tableModel.lastModifyDate)) : "";
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);

        loadFieldDetailsList(tableModel);

        var databaseLink = document.getElementById("databaseLink");
        for(var i = 0; i <= databaseLinks.count; i++){
            var option = document.createElement("option");
            if(i == 0){
                option.setAttribute("value",0);
                option.innerText = "请选择数据库连接";
            }else{
                option.setAttribute("value",databaseLinks.item(i-1).dataSourceID);
                if(databaseLinks.item(i-1).dataSourceID == tableModel.dataSourceID){
                    option.setAttribute("selected",true);
                }
                option.innerText = databaseLinks.item(i-1).dataSourceName;
            }
            databaseLink.appendChild(option);
        }

        form.render('select');
        initFieldDetailsListTableEvent();

        element.on('tab(modelTab)', function (data) {
            if (tableModel.sourceType == 1) {
                if (data.index == 1 || data.index == 2) {
                    layer.msg("订阅的模型不能编辑该栏目。", { icon: 2 });
                    element.tabChange("modelTab", 0);
                }

            }
        });

        form.on("submit(editModelSubmit)",function(obj){
            if(obj.field.dataSourceID === "0"){
                layer.msg("请选择数据库连接。",{icon:2});
                return false;
            }
            if(change(obj)){
                if(businessObjectTypeAndDataType(obj)){
                    layer.msg("度量的数据类型必须为数字。",{icon: 2});
                    return false;
                }else{
                    $Utils.loading.open();
                    var editTableModel = setEditSaveTableModel(obj);
                    formEditSubmit(editTableModel,layerIndex);
                }
            }else{
                layer.close(layerIndex);
            }
            return false;
        });
        
        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        $(".edit-model .edit-test-link").click(function(){
            $Utils.loading.open();
            var data = form.val("editTableModel");
            if(databaseLinks.item(data.dataSourceID)){
                formTestConnections(data);
            }else{
                layer.msg("数据库连接不存在。",{icon:2});
            }
        });
    }

    function loadFieldDetailsList(tableModel){
        var tableHead = [
            [
                {field: "columnName", title: "列名"},
                {field: "businessObjectName", title: "业务对象名称", edit: "text"},
                {field: "dataType", title: "数据类型", templet: "#selectDataType"},
                {field: "businessObjectType", title: "对象类型", templet: "#selectObjectType"},
                {field: "aggregateFunction", title: "聚合", templet: "#selectAggregation"},
                {field: "valueOrder", title: "排序", templet: "#selectSort"},
                {field: "formatString", title: "数值格式", event: "setDataFormat"}
            ]
        ];
        var tableBody = [];
        for(var i = 0; i < tableModel.businessObjects.count; i++){
            var obj = {};
            obj.columnName = tableModel.businessObjects.item(i).columnName;
            obj.businessObjectName = tableModel.businessObjects.item(i).businessObjectName;
            obj.dataType = tableModel.businessObjects.item(i).dataType;
            obj.businessObjectType = tableModel.businessObjects.item(i).businessObjectType;
            obj.aggregateFunction = setAggregateFunction(tableModel.businessObjects.item(i));
            obj.valueOrder = tableModel.businessObjects.item(i).valueOrder?(tableModel.businessObjects.item(i).valueOrder.indexOf("ASC") != -1 ? 1: 2):0;
            obj.formatString = tableModel.businessObjects.item(i).formatString;
            obj.businessObjectID = tableModel.businessObjects.item(i).businessObjectID;
            obj.businessObjectFolderID = tableModel.businessObjects.item(i).businessObjectFolderID;
            obj.aggregateAware = tableModel.businessObjects.item(i).aggregateAware;
            obj.expressionText = tableModel.businessObjects.item(i).expressionText;
            obj.expressionList = tableModel.businessObjects.item(i).expressionList;
            obj.tableNamesList = tableModel.businessObjects.item(i).tableNamesList;
            obj.sortIndex = tableModel.businessObjects.item(i).sortIndex;
            obj.visibility = tableModel.businessObjects.item(i).visibility;
            tableBody.push(obj);
        }
        fieldDetailsList = tableBody;
        table.render({
            elem: '#fieldDetailsList',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: tableHead,
            data: tableBody,
            toolbar: false,
            limit: tableBody.length,
            done: function (res, curr, count) {
                initTableSelectEvent();
            }
        });
    }

    function setAggregateFunction(businessObject){
        if(!businessObject.aggregateFunction){
            return 0;
        }else{
            if(businessObject.expressionText.indexOf("sum(") != -1){
                return 1;
            }
            if(businessObject.expressionText.indexOf("avg(") != -1){
                return 2;
            }
            if(businessObject.expressionText.indexOf("count(") != -1){
                return 3;
            }
            if(businessObject.expressionText.indexOf("max(") != -1){
                return 4;
            }
            if(businessObject.expressionText.indexOf("min(") != -1){
                return 5;
            }
        }
    }

    function initTableSelectEvent(){
        $("select[name='dataType']").html(createOptions(dataType));
        layui.each($("select[name='dataType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='businessObjectType']").html(createOptions(objectType));
        layui.each($("select[name='businessObjectType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='aggregateFunction']").html(createOptions(aggregation));
        layui.each($("select[name='aggregateFunction']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='valueOrder']").html(createOptions(sort));
        layui.each($("select[name='valueOrder']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        form.render('select');
    }

    function createOptions(dataList){
        var str = "";
        for(var i = 0; i < dataList.length; i++){
            str += "<option value="+dataList[i].id+">"+dataList[i].name+"</option>";
        }
        return str;
    }

    function initFieldDetailsListTableEvent(){
        form.on('select(dataType)', function(obj){
            debugger
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(objectType)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(aggregation)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(sort)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        
        table.on("tool(fieldDetailsList)",function(obj){
            if(obj.event == "setDataFormat"){
                getAndLoadDataFormatHtml(obj);
            }
        });
    }

    function getAndLoadDataFormatHtml(obj){
        $.ajax({
            url: "html/dataFormat/dataFormat.html",
            type: 'GET',
            success: function(data){
                loadDataFormatHtml(obj,data);
            }
        });
    }

    function loadDataFormatHtml(obj,strHtml){
        layer.open({
            type: 1,
            title: ["数值格式","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["700px","525px"],
            content: strHtml,
            success: function(layero,index){
                initDataFormat(obj,index,setDataFormatToTableCell);
            }
        });
    }

    var setDataFormatToTableCell = function(obj,dataFormatStr,index){
        obj.update({
            "formatString": dataFormatStr
        });
        layer.close(index);
    };

    function change(obj){
        if(obj.field.description != mTableModel.description){
            return true;
        }
        if(obj.field.dataSourceID != mTableModel.dataSourceID){
            return true;
        }
        if(businessObjectChange(obj)){
            return true;
        }
        return false;
    }

    function businessObjectChange(obj){
        var compareArr = transformationFieldDetailsList(obj);
        for(var i = 0; i < compareArr.length; i++){
            for(var key in mTableModel.businessObjects.item(compareArr[i].businessObjectID)){
                if(typeof mTableModel.businessObjects.item(compareArr[i].businessObjectID)[key] === "function"){ continue;}
                if(JSON.stringify(compareArr[i][key]) != JSON.stringify(mTableModel.businessObjects.item(compareArr[i].businessObjectID)[key])){
                    return true;
                }
            }
        }
        return false;
    }

    function transformationFieldDetailsList(obj){
        var compareArr = $.extend(true,[],fieldDetailsList);
        for(var i = 0; i < compareArr.length; i++){
            compareArr[i].expressionText = aggregateStr(mTableModel.tableName,compareArr[i].columnName,compareArr[i].aggregateFunction,obj);
            compareArr[i].expressionList = [compareArr[i].expressionText];
            
            compareArr[i].aggregateFunction = compareArr[i].aggregateFunction == 0?false:true;
            compareArr[i].valueOrder = compareArr[i].valueOrder==0?"":(compareArr[i].valueOrder==1?"ASC":"DESC");
        }
        return compareArr;
    }

    function aggregateStr(tableName,columnName,aggregationID,obj){
        if(aggregationID == 0){
            return tableName+"."+setColumnName(columnName,obj);
        }
        if(aggregationID == 1){
            return "sum("+tableName+"."+setColumnName(columnName,obj)+")";
        }
        if(aggregationID == 2){
            return "avg("+tableName+"."+setColumnName(columnName,obj)+")";
        }
        if(aggregationID == 3){
            return "count("+tableName+"."+setColumnName(columnName,obj)+")";
        }
        if(aggregationID == 4){
            return "max("+tableName+"."+setColumnName(columnName,obj)+")";
        }
        if(aggregationID == 5){
            return "min("+tableName+"."+setColumnName(columnName,obj)+")";
        }
    }

    function setColumnName(columnName,obj){
        if(databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("SQLServer") != -1 || databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("Access") != -1){
            columnName = "[" + columnName + "]";
        }else if(databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("Oracle") != -1 || databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("PostgreSQL") != -1 || databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("DB2") != -1){
            columnName = "\"" + columnName + "\"";
        }else if(databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("MySql") != -1 || databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("Hive") != -1){
            columnName = "`" + columnName + "`";
        }

        return columnName;
    }

    function setEditSaveTableModel(obj){
        var tableModelObj = {};
        tableModelObj.businessModelID = mTableModel.businessModelID;
        tableModelObj.businessModelType = mTableModel.businessModelType;
        tableModelObj.tableName = mTableModel.tableName;
        tableModelObj.businessModelName = obj.field.businessModelName;
        tableModelObj.folderID = obj.field.folderID;
        tableModelObj.description = obj.field.description;
        tableModelObj.dataSourceID = obj.field.dataSourceID;
        tableModelObj.dataSourceName = databaseLinks.item(obj.field.dataSourceID)?databaseLinks.item(obj.field.dataSourceID).dataSourceName:"";
        tableModelObj.businessObjects = saveBusinessObject(mTableModel.tableName,obj);
        return tableModelObj;
    }

    function businessObjectTypeAndDataType(obj){
        var compareArr = transformationFieldDetailsList(obj);
        for(var i = 0; i < compareArr.length; i++){
            if(compareArr[i].businessObjectType == 1 && compareArr[i].dataType != 2){
                return true;
            }
        }
        return false;
    }

    function saveBusinessObject(tableName,obj){
        var businessObjectsArr = [];
        for(var i = 0; i < fieldDetailsList.length; i++){
            var businessObject = new BusinessObject();
            businessObject.businessObjectID = fieldDetailsList[i].businessObjectID;
            businessObject.businessObjectName = fieldDetailsList[i].businessObjectName;
            businessObject.businessObjectType = fieldDetailsList[i].businessObjectType;
            businessObject.businessObjectFolderID = "-1";
            businessObject.dataType = fieldDetailsList[i].dataType;
            businessObject.aggregateFunction = fieldDetailsList[i].aggregateFunction == 0?false:true;
            businessObject.aggregateAware = false;
            //ASC升序   DESC降序
            businessObject.valueOrder = fieldDetailsList[i].valueOrder==0?"":(fieldDetailsList[i].valueOrder==1?"ASC":"DESC");
            businessObject.formatString = fieldDetailsList[i].formatString;
            businessObject.columnName = fieldDetailsList[i].columnName;
            //表名.列名
            businessObject.expressionText = aggregateStr(tableName,fieldDetailsList[i].columnName,fieldDetailsList[i].aggregateFunction,obj);
            businessObject.expressionList = [businessObject.expressionText];
            businessObject.tableNamesList = [[tableName]];
            businessObject.sortIndex = i;
            businessObjectsArr.push(businessObject);
        }
        return businessObjectsArr;
    }
    
    function formTestConnections(data){
        var parameters = "databaseTypeName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseTypeName)+"&databaseTypeVersion="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseTypeVersion)+"&databaseIP="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseIP)+"&databasePort="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databasePort)+
        "&userName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).userName)+"&password="+encodeURIComponent(databaseLinks.item(data.dataSourceID).password)+"&databaseName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseName);
        var succ = function(){
            $Utils.loading.close();
            layer.msg("连接成功！",{icon:1});
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("测试连接",errorStatus,msg);
        };
        databaseLinks.item(data.dataSourceID).testConnections(parameters,true,succ,fail);
    }
    
}();