!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, tree = layui.tree, form = layui.form;
    var layerIndex = null;
    var addSubmitForm = null;
    var mBusinessModelFolders = null;
    var addMFolderID = null;
    var databaseLinks = new DatabaseLinks();
    var tables = new Tables();
    var mTableModel = {};
    var fieldDetailsList = [];

    var dataType = [
        {"id": 0, "name": "字符串"},
        {"id": 1, "name": "日期"},
        {"id": 2, "name": "数字"},
        {"id": 3, "name": "图像URL"},
        {"id": 4, "name": "图像二进制"},
    ];
    var objectType = [
        {"id": 0, "name": "维度"},
        {"id": 1, "name": "度量"}
    ];
    var aggregation = [
        {"id": 0, "name": "无"},
        {"id": 1, "name": "总和"},
        {"id": 2, "name": "平均"},
        {"id": 3, "name": "计数"},
        {"id": 4, "name": "最大值"},
        {"id": 5, "name": "最小值"}
    ];
    var sort = [
        {"id": 0, "name": "无排序"},
        {"id": 1, "name": "升序"},
        {"id": 2, "name": "降序"},
    ];

    window.initAddTableModelForm = function (businessModelFolders, folderID, index,addSubmit){
        $Utils.windowLoading.open();
        layerIndex = index;
        addSubmitForm = addSubmit;
        mBusinessModelFolders = businessModelFolders;
        addMFolderID = folderID;

        $(".cancel").click(function(){
            layer.close(layerIndex);
        });
        initDatabaseLinkList();
    };

    function initDatabaseLinkList(){
        initDatabaseLinksTableHead();
        getAndLoadDatabaseLinksTableBody();

        table.on("radio(databaseLinkList)",function(){
            if($(".select-database-link .next-step").prop("disabled") == true){
                $(".select-database-link .next-step").attr("disabled",false);
            }
        });
    
        $(".select-database-link .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                saveSelectedDatabaseLink();
                initTableList();
            }
            return false;
        });
    }

    function initDatabaseLinksTableHead(){
        var databaseLinkTableHead = [
            [
                {type: "radio"},
                {field: "dataSourceName", title: "名称"},
                {field: "databaseTypeName", title: "数据库类型"},
                // {field: "databaseTypeVersion", title: "数据库版本"},
                {field: "createUserName",title: "创建者"},
                {field: "createDate",title: "创建时间"},
                {field: "lastModifyUserName",title: "最后修改者"},
                {field: "lastModifyDate",title: "最后修改时间"},
            ]
        ];
    
        table.render({
            elem: '#databaseLinkList',
            height: 409,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: databaseLinkTableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadDatabaseLinksTableBody(){
        var succ = function(){
            $Utils.windowLoading.close();
			loadDatabaseLinksTableBody();
		};
		var fail = function(errorStatus,msg){
            $Utils.windowLoading.close();
			$Utils.openWindow.failWindow("获取数据库连接",errorStatus,msg);
		};
		databaseLinks.getItems(2,true,succ,fail);
    }

    function loadDatabaseLinksTableBody(){
        var databaseLinksTableBody = [];
        for(var i = 0; i < databaseLinks.count; i++){
            var tempObj = {};
            for(var key in databaseLinks.item(i)){
                if(typeof databaseLinks.item(i)[key] === "function"){ continue;}
                if(key == "createDate"){
                    tempObj[key] = databaseLinks.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm",new Date(databaseLinks.item(i)[key])):"";
                }else if(key == "lastModifyDate"){
                    tempObj[key] = databaseLinks.item(i)[key]?$Utils.formatString.date("YYYY-MM-dd HH:mm",new Date(databaseLinks.item(i)[key])):"";
                }else{
                    tempObj[key] = databaseLinks.item(i)[key];
                }
            }
            databaseLinksTableBody.push(tempObj);
        }
        table.reload("databaseLinkList",{data:databaseLinksTableBody,limit:databaseLinksTableBody.length});
    }

    function saveSelectedDatabaseLink(){
        var selectedDatabaseLink = table.checkStatus("databaseLinkList").data;
        mTableModel.dataSourceID = selectedDatabaseLink[0].dataSourceID;
        mTableModel.dataSourceName = selectedDatabaseLink[0].dataSourceName;
    }

    function initTableList(){
        $(".table-list-box").html("");
        getAndLoadTableList();
        $(".select-database-link").hide();
        $(".table-list").show();
        $("#filterContent").val("");
        $(".table-list .next-step").attr("disabled",true);
        $(".table-list-box").off('click').on("click","li",function(){
            if(!$(this).hasClass("selected")){
                $(this).addClass("selected").siblings("li").removeClass("selected");
                if($(".table-list .next-step").prop("disabled") == true){
                    $(".table-list .next-step").attr("disabled",false);
                }
            }
        });
        $(".filter-button").off("click").on("click",function(){
            loadTableList($("#filterContent").val())
        });
        $(".table-list .last-step").off("click").on("click",function(){
            $(".table-list").hide();
            $(".select-database-link").show();
        });
        $(".table-list .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                mTableModel.tableName = $(".table-list-box").find("li.selected").attr("data-tablename");
                mTableModel.schemaName = $(".table-list-box").find("li.selected").attr("data-schemaname");
                initTableFields(mTableModel.tableName, mTableModel.schemaName);
            }
        });
    }

    function getAndLoadTableList(){
        var succ = function(){
            $Utils.windowLoading.close();
            loadTableList();
        };
        var fail = function(errorStatus,msg){
            $Utils.windowLoading.close();
            $Utils.openWindow.failWindow("获取数据库表",errorStatus,msg);
        };
        tables.getItems(mTableModel.dataSourceID,true,succ,fail);
    }

    function loadTableList(filterStr){
        var str = "";
        for(var i = 0; i < tables.count; i++){
            if(filterStr && tables.item(i).tableName.toUpperCase().indexOf(filterStr.toUpperCase()) != -1){
                str += "<li data-tablename=" + tables.item(i).tableName + " data-schemaname=" + tables.item(i).schemaName + "><i class='iconfont bda-verticalTable'></i><span>" + (tables.item(i).schemaName ? (tables.item(i).schemaName + "." + tables.item(i).tableName) : tables.item(i).tableName)+"</span></li>";
            }else if(!filterStr){
                str += "<li data-tablename=" + tables.item(i).tableName + " data-schemaname=" + tables.item(i).schemaName + "><i class='iconfont bda-verticalTable'></i><span>" + (tables.item(i).schemaName ? (tables.item(i).schemaName + "." + tables.item(i).tableName) : tables.item(i).tableName)+"</span></li>";
            }
        }
        $(".table-list-box").html(str);
        $(".table-list .next-step").attr("disabled",true);
    }

    function initTableFields(tableName, schemaName){
        getAndLoadTableFields(tableName, schemaName);

        $(".table-list").hide();
        $(".table-field").show();
        $(".table-field .next-step").attr("disabled",true);
        $(".table-field .filter-button").off("click").on("click",function(){
            getAndLoadDataList(tableName, schemaName);
        });
        $(".table-field .last-step").off("click").on("click",function(){
            $(".table-field").hide();
            $(".table-list").show();
        });
        $(".table-field .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                var selectTableFields = tree.getChecked('fieldCheck');
                if(selectTableFields.length){
                    $Utils.windowLoading.open();
                    initFieldDetailsList(selectTableFields,tableName);
                }else{
                    layer.msg("请至少选择一条记录。",{icon:2});
                }
            }
        });
    }

    function getAndLoadTableFields(tableName, schemaName){
        var succ = function(){
            $Utils.windowLoading.close();
            loadTableFields(tables.item(tableName));
        };
        var fail = function(errorStatus,msg){
            $Utils.windowLoading.close();
			$Utils.openWindow.failWindow("获取 "+tableName+" 字段",errorStatus,msg);
        };
        var tableNamesArr = [
            { "tableName": tableName, "schemaName": schemaName}
        ];
        // var str = encodeURIComponent(JSON.stringify(tableNamesArr));
		tables.item(tableName).initByTableName(tableNamesArr,mTableModel.dataSourceID,true,succ,fail);
    }

    function loadTableFields(tableItem){
        var tempArr = [];
        for(var i = 0; i < tableItem.tableFields.count; i++){
            var obj = {};
            obj.title = tableItem.tableFields.item(i).fieldName;
            obj.id = tableItem.tableFields.item(i).fieldName;
            obj.comment = tableItem.tableFields.item(i).comment;
            tempArr.push(obj);
        }
        var data = [{
            id: tableItem.tableName,
            title: tableItem.tableName,
            children: tempArr,
            spread: true
        }];
        tree.render({
            elem: "#tableField",
            showCheckbox: true,
            data: data,
            id: "fieldCheck",
            oncheck: function(){
                $(".table-field .next-step").attr("disabled",false);
            }
        });
    }

    function getAndLoadDataList(tableName, schemaName){
        var succ = function(data){
            loadDataList(tableName,data);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取结果集",errorStatus,msg);
        };
        tables.item(tableName).getBusinessDataByTableName(mTableModel.dataSourceID, tableName, schemaName,true,succ,fail);
    }

    function loadDataList(tableName,data){
        layer.open({
            type: 1,
            title: [tableName + "表值（前200行）","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["700px","525px"],
            content: "<div class='table-data-list'><table class='layui-hide' id='tableDataList' lay-filter='tableDataList'></table></div>",
            success: function(layero,index){
                loadTableDataList(data);
            }
        });
    }

    function loadTableDataList(data){
        var tableHead = [];
        var i = 0;
        for(var key in data[0]){
            var obj = {};
            obj.field = key;
            obj.title = key;
            obj.sort = true;
            obj.align = "center";
            tableHead.push(obj);
        }

        var tableBody = [];
        for(var i = 0; i < data.length; i++){
            var obj = {};
            for(var j = 0; j < tableHead.length; j++){
                obj[tableHead[j].title] = data[i][tableHead[j].title];
            }
            tableBody.push(obj);
        }

        table.render({
            elem: '#tableDataList',
            height: 478,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: [tableHead],
            data: tableBody,
            toolbar: false,
            limit: tableBody.length
        });
    }

    function initFieldDetailsList(selectTableFields,tableName){
        $(".table-field").hide();
        $(".field-details-list").show();
        $Utils.windowLoading.close();
        loadFieldDetailsList(selectTableFields);

        initFieldDetailsListTableEvent();
        $(".field-details-list .last-step").off("click").on("click",function(){
            $(".field-details-list").hide();
            $(".table-field").show();
        });
        $(".field-details-list .next-step").off("click").on("click",function(){
            if(businessObjectTypeAndDataType()){
                layer.msg("度量的数据类型必须为数字。",{icon: 2});
                return false;
            }else{
                $Utils.windowLoading.open();
                saveBusinessObject(tableName);
                initTableModelNameAndDescription(tableName);
            }
        });
    }

    function loadFieldDetailsList(selectTableFields){
        var tableHead = [
            [
                {field: "columnName", title: "列名"},
                {field: "businessObjectName", title: "业务对象名称", edit: "text"},
                {field: "dataType", title: "数据类型", templet: "#selectDataType"},
                {field: "businessObjectType", title: "对象类型", templet: "#selectObjectType"},
                {field: "aggregateFunction", title: "聚合", templet: "#selectAggregation"},
                {field: "valueOrder", title: "排序", templet: "#selectSort"},
                {field: "formatString", title: "数值格式", event: "setDataFormat"}
            ]
        ];
        var tableBody = [];
        for(var i = 0; i < selectTableFields[0].children.length; i++){
            var obj = {};
            obj.columnName = selectTableFields[0].children[i].title;
            obj.businessObjectName =  selectTableFields[0].children[i].title;
            obj.businessObjectName =  ($AppVars.gOrganizationSystemSettings.item("useCommentAsName")&&$AppVars.gOrganizationSystemSettings.item("useCommentAsName").systemSettingValue == 1)?(($.trim(selectTableFields[0].children[i].comment)&& ($.trim(selectTableFields[0].children[i].comment) != 0))?selectTableFields[0].children[i].comment:selectTableFields[0].children[i].title):selectTableFields[0].children[i].title;
            obj.dataType = tables.item(selectTableFields[0].title).tableFields.item(selectTableFields[0].children[i].title).dataType;
            obj.businessObjectType = obj.dataType == 2 ? 1 : 0;
            obj.aggregateFunction = 0;
            obj.valueOrder = 0;
            obj.formatString = "";
            tableBody.push(obj);
        }
        fieldDetailsList = tableBody;
        table.render({
            elem: '#fieldDetailsList',
            height: 409,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: tableHead,
            data: tableBody,
            toolbar: false,
            limit: tableBody.length,
            done: function (res, curr, count) {
                initTableSelectEvent();
            }
        });
    }

    function initTableSelectEvent(){
        $("select[name='dataType']").html(createOptions(dataType));
        layui.each($("select[name='dataType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='businessObjectType']").html(createOptions(objectType));
        layui.each($("select[name='businessObjectType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='aggregateFunction']").html(createOptions(aggregation));
        layui.each($("select[name='aggregateFunction']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='valueOrder']").html(createOptions(sort));
        layui.each($("select[name='valueOrder']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        form.render('select');
    }

    function createOptions(dataList){
        var str = "";
        for(var i = 0; i < dataList.length; i++){
            str += "<option value="+dataList[i].id+">"+dataList[i].name+"</option>";
        }
        return str;
    }

    function initFieldDetailsListTableEvent(){
        form.on('select(dataType)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(objectType)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(aggregation)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(sort)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        table.on("tool(fieldDetailsList)",function(obj){
            if(obj.event == "setDataFormat"){
                getAndLoadDataFormatHtml(obj);
            }
        });
    }

    function getAndLoadDataFormatHtml(obj){
        $.ajax({
            url: "html/dataFormat/dataFormat.html",
            type: 'GET',
            success: function(data){
                loadDataFormatHtml(obj,data);
            }
        });
    }

    function loadDataFormatHtml(obj,strHtml){
        layer.open({
            type: 1,
            title: ["数值格式","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["700px","525px"],
            content: strHtml,
            success: function(layero,index){
                initDataFormat(obj,index,setDataFormatToTableCell);
            }
        });
    }

    var setDataFormatToTableCell = function(obj,dataFormatStr,index){
        obj.update({
            "formatString": dataFormatStr
        });
        layer.close(index);
    };

    function businessObjectTypeAndDataType(){
        for(var i = 0; i < fieldDetailsList.length; i++){
            if(fieldDetailsList[i].businessObjectType == 1 && fieldDetailsList[i].dataType != 2){
                return true;
            }
        }
        return false;
    }

    function saveBusinessObject(tableName){
        var guid = new GUID();
        var businessObjectsArr = [];
        for(var i = 0; i < fieldDetailsList.length; i++){
            var businessObject = new BusinessObject();
            businessObject.businessObjectID = guid.newGUID();
            businessObject.businessObjectName = fieldDetailsList[i].businessObjectName;
            businessObject.businessObjectType = fieldDetailsList[i].businessObjectType;
            businessObject.businessObjectFolderID = "-1";
            businessObject.dataType = fieldDetailsList[i].dataType;
            businessObject.aggregateFunction = fieldDetailsList[i].aggregateFunction == 0?false:true;
            businessObject.aggregateAware = false;
            //ASC升序   DESC降序
            businessObject.valueOrder = fieldDetailsList[i].valueOrder==0?"":(fieldDetailsList[i].valueOrder==1?"ASC":"DESC");
            businessObject.formatString = fieldDetailsList[i].formatString;
            businessObject.columnName = fieldDetailsList[i].columnName;
            //表名.列名
            businessObject.expressionText = aggregateStr(tableName,fieldDetailsList[i].columnName,fieldDetailsList[i].aggregateFunction);
            businessObject.expressionList = [businessObject.expressionText];
            businessObject.tableNamesList = [[tableName]];
            businessObject.sortIndex = i;
            businessObjectsArr.push(businessObject);
        }
        mTableModel.businessObjects = businessObjectsArr;
    }

    function aggregateStr(tableName,columnName,aggregationID){
        if(aggregationID == 0){
            return tableName+"."+setColumnName(columnName);
        }
        if(aggregationID == 1){
            return "sum("+tableName+"."+setColumnName(columnName)+")";
        }
        if(aggregationID == 2){
            return "avg("+tableName+"."+setColumnName(columnName)+")";
        }
        if(aggregationID == 3){
            return "count("+tableName+"."+setColumnName(columnName)+")";
        }
        if(aggregationID == 4){
            return "max("+tableName+"."+setColumnName(columnName)+")";
        }
        if(aggregationID == 5){
            return "min("+tableName+"."+setColumnName(columnName)+")";
        }
    }

    function setColumnName(columnName){
        if(databaseLinks.item(mTableModel.dataSourceID).databaseTypeName.indexOf("SQLServer") != -1 || databaseLinks.item(mTableModel.dataSourceID).databaseTypeName.indexOf("Access") != -1){
            columnName = "[" + columnName + "]";
        }else if(databaseLinks.item(mTableModel.dataSourceID).databaseTypeName.indexOf("Oracle") != -1 || databaseLinks.item(mTableModel.dataSourceID).databaseTypeName.indexOf("PostgreSQL") != -1 || databaseLinks.item(mTableModel.dataSourceID).databaseTypeName.indexOf("DB2") != -1){
            columnName = "\"" + columnName + "\"";
        }else if(databaseLinks.item(mTableModel.dataSourceID).databaseTypeName.indexOf("MySql") != -1 || databaseLinks.item(mTableModel.dataSourceID).databaseTypeName.indexOf("Hive") != -1){
            columnName = "`" + columnName + "`";
        }

        return columnName;
    }

    function initTableModelNameAndDescription(tableName){
        $(".field-details-list").hide();
        $(".table-model-detail").show();
        $Utils.windowLoading.close();

        $(".table-model-detail input,.table-model-detail textarea").val("");
        form.val("addTableModel",{
            "businessModelName": tableName
        });
        $("#businessModelName").on("input propertychange",function(){
            if($(this).val() == ""){
                $(".table-model-detail .next-step").attr("disabled",true);
            }else{
                $(".table-model-detail .next-step").attr("disabled",false);
            }
    	});
        $(".table-model-detail .last-step").off("click").on("click",function(){
            $(".table-model-detail").hide();
            $(".field-details-list").show();
        });
        $(".table-model-detail .next-step").off("click").on("click",function(){
            saveTableModelDetail();
            addSubmitForm(mTableModel,layerIndex);
        });

        createTreeSelect();
    }

    function saveTableModelDetail(){
        var data = form.val("addTableModel");
        mTableModel.businessModelName = data.businessModelName;
        mTableModel.businessModelType = 1;
        mTableModel.folderID = data.folderID;
        mTableModel.description = data.description;
    }

    function createTreeSelect() {
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function (node) { //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
            },
        });
        if (addMFolderID == -1) {
            $(".table-model-detail .layui-form-select").find(".layui-select-title span").html("数据表模型").end().find("input:hidden[name='folderID']").val(-1);
        } else {
            $(".table-model-detail .layui-form-select").find(".layui-select-title span").html(mBusinessModelFolders.item(addMFolderID).folderName).end().find("input:hidden[name='folderID']").val(addMFolderID);
        }
        $(".table-model-detail .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".table-model-detail .layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders() {
        var index = 0;
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { title: "数据表模型", id: index, folderID: "-1", folderParentID: "0", spread: true });
        index++;
        for (var i = 0; i < mBusinessModelFolders.count; i++) {
            hashTable.add(mBusinessModelFolders.item(i).folderID, { title: mBusinessModelFolders.item(i).folderName, id: index, folderID: mBusinessModelFolders.item(i).folderID, folderParentID: mBusinessModelFolders.item(i).folderParentID });
            index++;
        }
        for (var i = 0; i < mBusinessModelFolders.count; i++) {
            var parentFolder = hashTable.getValue(mBusinessModelFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(mBusinessModelFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function GUID(){
        this.date = new Date();   /* 判断是否初始化过，如果初始化过以下代码，则以下代码将不再执行，实际中只执行一次 */
            if (typeof this.newGUID != 'function') {   /* 生成GUID码 */
                GUID.prototype.newGUID = function () {
                    this.date = new Date(); var guidStr = '';
                    sexadecimalDate = this.hexadecimal(this.getGUIDDate(), 16);
                    sexadecimalTime = this.hexadecimal(this.getGUIDTime(), 16);
                    for (var i = 0; i < 9; i++) {
                        guidStr += Math.floor(Math.random() * 16).toString(16);
                    }
                    guidStr += sexadecimalDate;
                    guidStr += sexadecimalTime;
                    while (guidStr.length < 32) {
                        guidStr += Math.floor(Math.random() * 16).toString(16);
                    }
                    return this.formatGUID(guidStr);
                }
                /* * 功能：获取当前日期的GUID格式，即8位数的日期：19700101 * 返回值：返回GUID日期格式的字条串 */
                GUID.prototype.getGUIDDate = function () {
                    return this.date.getFullYear() + this.addZero(this.date.getMonth() + 1) + this.addZero(this.date.getDay());
                }
                /* * 功能：获取当前时间的GUID格式，即8位数的时间，包括毫秒，毫秒为2位数：12300933 * 返回值：返回GUID日期格式的字条串 */
                GUID.prototype.getGUIDTime = function () {
                    return this.addZero(this.date.getHours()) + this.addZero(this.date.getMinutes()) + this.addZero(this.date.getSeconds()) + this.addZero(parseInt(this.date.getMilliseconds() / 10));
                }
                /* * 功能: 为一位数的正整数前面添加0，如果是可以转成非NaN数字的字符串也可以实现 * 参数: 参数表示准备再前面添加0的数字或可以转换成数字的字符串 * 返回值: 如果符合条件，返回添加0后的字条串类型，否则返回自身的字符串 */
                GUID.prototype.addZero = function (num) {
                    if (Number(num).toString() != 'NaN' && num >= 0 && num < 10) {
                        return '0' + Math.floor(num);
                    } else {
                        return num.toString();
                    }
                }
                /*  * 功能：将y进制的数值，转换为x进制的数值 * 参数：第1个参数表示欲转换的数值；第2个参数表示欲转换的进制；第3个参数可选，表示当前的进制数，如不写则为10 * 返回值：返回转换后的字符串 */GUID.prototype.hexadecimal = function (num, x, y) {
                    if (y != undefined) { return parseInt(num.toString(), y).toString(x); }
                    else { return parseInt(num.toString()).toString(x); }
                }
                /* * 功能：格式化32位的字符串为GUID模式的字符串 * 参数：第1个参数表示32位的字符串 * 返回值：标准GUID格式的字符串 */
                GUID.prototype.formatGUID = function (guidStr) {
                    var str1 = guidStr.slice(0, 8) + '-', str2 = guidStr.slice(8, 12) + '-', str3 = guidStr.slice(12, 16) + '-', str4 = guidStr.slice(16, 20) + '-', str5 = guidStr.slice(20);
                    return str1 + str2 + str3 + str4 + str5;
                }
            }
    }
}();