/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-04-27 10:33:37
 * @LastEditTime: 2021-04-29 17:10:46
 * @LastModifyUser: 
 * @Remark: 
 */
!function () {
    var $ = layui.jquery, table = layui.table, laypage = layui.laypage;
    var bmSubscriptionController = new BmSubscriptionController();
    var layerIndex = null, formSubmit = null, mTableBodyData = [], mSortBodyData = [], currentTableBodyData = [];
    var subScriptionBMs = new BusinessModels();
    var subscriptionableBMs = new BusinessModels();
    var mLimit = 20;
    var mCurrentPage = 1;

    window.initSubscriptionForm = function (businessModelType, index, addSubscription) {
        layerIndex = index;
        formSubmit = addSubscription;

        initSubscriptionHead();
        getSubscribedBMAndSubscriptionableBM(businessModelType);
        bindEvent();
    };

    function initSubscriptionHead() {
        var tableHead = [
            [
                { type: "checkbox" },
                { field: "businessModelName", title: "模型名称", sort: true },
                { field: "sourceOrganizationName", title: "所属组织", sort: true },
                { field: "description", title: "描述", sort: true }
            ]
        ];

        table.render({
            elem: '#subscriptionList',
            height: 370,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: tableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getSubscribedBMAndSubscriptionableBM(businessModelType) {
        var succ = function (data) {
            subScriptionBMs.setBusinessModels(data);
            getSubscriptionableBM(businessModelType);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取已订阅模型列表", errorStatus, msg);
        };
        bmSubscriptionController.getSubscribedBM(businessModelType, true, succ, fail);
    }

    function getSubscriptionableBM(businessModelType) {
        var succ = function (data) {
            subscriptionableBMs.setBusinessModels(data);
            loadModelList();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取可订阅模型列表", errorStatus, msg);
        };
        bmSubscriptionController.getSubscriptionableBM(businessModelType, true, succ, fail);
    }

    function loadModelList() {
        mTableBodyData = setTableBody();
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
        $Utils.loading.close();
    }

    function setTableBody() {
        var tableBodyData = [];
        for (var i = 0; i < subscriptionableBMs.count; i++) {
            var tempObj = {};
            for (var key in subscriptionableBMs.item(i)) {
                if (typeof subscriptionableBMs.item(i)[key] === "function") { continue; }
                tempObj[key] = subscriptionableBMs.item(i)[key];
            }
            tempObj.subscriptionType = 0;
            tableBodyData.push(tempObj);
        }
        for (var i = 0; i < subScriptionBMs.count; i++) {
            var tempObj = {};
            for (var key in subScriptionBMs.item(i)) {
                if (typeof subScriptionBMs.item(i)[key] === "function") { continue; }
                tempObj[key] = subScriptionBMs.item(i)[key];
            }
            tempObj.subscriptionType = 1;
            tableBodyData.push(tempObj);
        }
        return tableBodyData;
    }

    function setTablePage(data) {
        laypage.render({
            elem: "subscriptionPageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function (obj, first) {
                $(".subscription-top .count-page").html("显示 " + (obj.curr * obj.limit - obj.limit + 1) + " 到 " + ((obj.curr * obj.limit) > data.length ? data.length : (obj.curr * obj.limit)) + " ，共 " + data.length + " 条记录");
                mLimit = obj.limit;
                loadTableBody(data, obj);
            }
        });
    }

    function loadTableBody(tableBodyData, obj) {
        currentTableBodyData = tableBodyData.concat().splice(obj.curr * obj.limit - obj.limit, obj.limit);
        table.reload("subscriptionList", { data: currentTableBodyData, limit: currentTableBodyData.length, done: function (res){
            for (var i = 0; i < res.data.length; i++){
                if (res.data[i].subscriptionType == 1){
                    $(".subscription-list .layui-table tr[data-index=" + i + "] input[type='checkbox']").prop('disabled', true);
                    $(".subscription-list .layui-table tr[data-index=" + i + "] input[type='checkbox']").next().addClass('layui-btn-disabled');
                }
            }
        }});
    }

    function bindEvent() {
        table.on('sort(subscriptionList)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if (type === 'asc') { //升序
                thisData = $Utils.sorter(data, field);
            } else if (type === 'desc') { //降序
                thisData = $Utils.sorter(data, field, true);
            } else { //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });

        $(".search-button").click(function () {
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if (searchValue == "") {
                searchData = mTableBodyData;
            } else {
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        table.on("tool(subscriptionList)", function (obj) {
            if (obj.event == "subscribe") {
                subscribeModel(obj);
            }
        });

        $(".layui-btn-cancel").click(function () {
            layer.close(layerIndex);
        });

        $(".subscription-submit").click(function () {
            if(change()){
                submitSubscription();
            }else{
                layer.close(layerIndex);
            }
        });
    }

    function setSearchData(searchValue) {
        var tempArr = [];
        for (var i = 0; i < mTableBodyData.length; i++) {
            if (mTableBodyData[i].businessModelName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
                mTableBodyData[i].sourceOrganizationName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
                (mTableBodyData[i].description && (mTableBodyData[i].description.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))) {
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function subscribeModel(currentIDs) {
        var succ = function () {
            currentIDs.splice(0, 1);
            if (currentIDs.length > 0) {
                subscribeModel(currentIDs);
            } else {
                $Utils.loading.close();
                layer.close(layerIndex);
                layer.msg("订阅成功。", { icon: 1 });
                formSubmit();
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("订阅模型", errorStatus, msg);
        };
        bmSubscriptionController.subscribeBusinessModel(currentIDs[0], true, succ, fail);
    }

    function change(){
        var selectedArr = table.checkStatus("subscriptionList").data;
        var originalIDs = [];
        for (var i = 0; i < subScriptionBMs.count; i++){
            if(originalIDs.indexOf(subScriptionBMs.item(i).businessModelID) == -1){
                originalIDs.push(subScriptionBMs.item(i).businessModelID);
            }
        }
        var currentIDs = [];
        for(var i = 0; i < selectedArr.length; i++){
            if(selectedArr[i].subscriptionType == 0){
                currentIDs.push(selectedArr[i].businessModelID);
            }
        }

        for(var i = 0; i < currentIDs.length; i++){
            if(originalIDs.indexOf(currentIDs[i]) == -1){
                return true;
            }
        }

        return false;
    }

    function submitSubscription() {
        var selectedArr = table.checkStatus("subscriptionList").data;
        var currentIDs = [];
        for (var i = 0; i < selectedArr.length; i++) {
            if (selectedArr[i].subscriptionType == 0) {
                currentIDs.push(selectedArr[i].businessModelID);
            }
        }

        $Utils.loading.open();
        var succ = function () {
            currentIDs.splice(0,1);
            if(currentIDs.length > 0){
                subscribeModel(currentIDs);
            } else {
                $Utils.loading.close();
                layer.close(layerIndex);
                layer.msg("订阅成功。", { icon: 1 });
                formSubmit();
            }
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("订阅模型", errorStatus, msg);
        };
        bmSubscriptionController.subscribeBusinessModel(currentIDs[0], true, succ, fail);
    }

}();