/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2021-04-08 10:02:36
 * @LastEditTime: 2021-04-09 11:12:02
 * @LastModifyUser: 
 * @Remark: 
 */

!function () {
    var $ = layui.jquery, layer = layui.layer, form = layui.form;
    window.initParamValue = function (obj, index, setParamValueToTableCell) {

        bindEvent(obj, index, setParamValueToTableCell);

        if (obj.data.paramValue.indexOf("@Prompt(") != -1){
            var tempStr = obj.data.paramValue.substring(9, obj.data.paramValue.length-2);
            form.val("formWindow",{
                type: 1,
                prompt: tempStr.split("',,'")[0],
                defaultValue: tempStr.split("',,'")[1]
            });
            $(".param-value-window .type-two .layui-form-radio").trigger("click");
            $(".param-value-window input[name=prompt]").focus();
        }else{
            form.val("formWindow", {
                type: 0,
                paramValue: obj.data.paramValue
            });
            $(".param-value-window .type-one .layui-form-radio").trigger("click");
            $(".param-value-window input[name=paramValue]").focus();
        }
    };

    function bindEvent(cellObj, index, setParamValueToTableCell){
        form.on("submit(paramFormSubmit)",function(obj){
            if(obj.field.type == "0"){
                setParamValueToTableCell(cellObj, obj.field.paramValue, index);
            } else {
                setParamValueToTableCell(cellObj, $.trim($(".param-value-result").text()), index);
            }
            return false;
        });

        $(".param-value-window .layui-btn-cancel").click(function () {
            layer.close(index);
        });

        $("#defaultValueButton").click(function(){
            var valueStr = $(".param-value-window input[name='defaultValue']").val();
            getAndLoadDefaultValue(valueStr);
            return false;
        });

        $(".param-value-window input[name=prompt]").on("input propertychange", function(){
            var formData = form.val("formWindow");
            outputResults(formData.prompt, formData.defaultValue);
        });

        form.on("radio(type)", function (data) {
            if (data.value == "0") {
                $(".param-value-window .type-one input.layui-input").removeAttr("disabled");
                $(".param-value-window .type-two input.layui-input").attr("disabled","disabled");
                $(".param-value-window .type-two button").attr("disabled", "disabled");
            } else {
                $(".param-value-window .type-one input.layui-input").attr("disabled", "disabled");
                $(".param-value-window .type-two input.layui-input").removeAttr("disabled");
                $(".param-value-window .type-two button").removeAttr("disabled");
            }
        });
    }

    function getAndLoadDefaultValue(valueStr) {
        $.ajax({
            url: "/html/defaultDate/dateDefaultValue.html",
            type: 'GET',
            success: function (data) {
                loadDefaultValueHtml(data, valueStr);
            }
        });
    }

    function loadDefaultValueHtml(strHtml, valueStr) {
        layer.open({
            type: 1,
            title: ["设置日期过滤缺省值", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["480px", "360px"],
            content: strHtml,
            success: function (layero, index) {
                initDefaultValueForm(index, valueStr, setDefaultValue);
            }
        });
    }

    function outputResults(prompt, defaultValue) {
        let strText = `@Prompt('${prompt}',,'${defaultValue}')`;
        $(".param-value-result").text(strText);
    }

    var setDefaultValue = (value) => {
        let prompt = $(".param-value-window input[name='prompt']").val();
        $(".param-value-window input[name='defaultValue']").val(value);
        outputResults(prompt, value);
    }

}();