!function () {
    var $ = layui.jquery, layer = layui.layer, table = layui.table, tree = layui.tree, form = layui.form;
    var layerIndex = null;
    var addSubmitForm = null;
    var mBusinessModelFolders = null;
    var addMFolderID = null;
    var databaseLinks = new DatabaseLinks();
    var mStoredProcedureModel = {};
    var paramterDetailsList = [];
    var fieldDetailsList = [];
    var storedProcedureList = null;
    var selectedStoredProcedure = null;

    var dataType = [
        { "id": 0, "name": "字符串" },
        { "id": 1, "name": "日期" },
        { "id": 2, "name": "数字" },
        { "id": 3, "name": "图像URL" },
        { "id": 4, "name": "图像二进制" },
    ];
    var objectType = [
        { "id": 0, "name": "维度" },
        { "id": 1, "name": "度量" }
    ];
    var aggregation = [
        { "id": 0, "name": "无" }
    ];
    var sort = [
        { "id": 0, "name": "无排序" },
        { "id": 1, "name": "升序" },
        { "id": 2, "name": "降序" },
    ];

    window.initAddStoredProcedureModelForm = function (businessModelFolders, folderID, index, addSubmit) {
        $Utils.windowLoading.open();
        layerIndex = index;
        addSubmitForm = addSubmit;
        mBusinessModelFolders = businessModelFolders;
        addMFolderID = folderID;

        $(".cancel").click(function () {
            layer.close(layerIndex);
        });
        initDatabaseLinkList();
    };

    function initDatabaseLinkList() {
        initDatabaseLinksTableHead();
        getAndLoadDatabaseLinksTableBody();

        table.on("radio(databaseLinkList)", function () {
            if ($(".select-database-link .next-step").prop("disabled") == true) {
                $(".select-database-link .next-step").attr("disabled", false);
            }
        });

        $(".select-database-link .next-step").off("click").on("click", function () {
            if ($(this).prop("disabled") == false) {
                $Utils.windowLoading.open();
                saveSelectedDatabaseLink();
                initTableList();
            }
            return false;
        });
    }

    function initDatabaseLinksTableHead() {
        var databaseLinkTableHead = [
            [
                { type: "radio" },
                { field: "dataSourceName", title: "名称" },
                { field: "databaseTypeName", title: "数据库类型" },
                // {field: "databaseTypeVersion", title: "数据库版本"},
                { field: "createUserName", title: "创建者" },
                { field: "createDate", title: "创建时间" },
                { field: "lastModifyUserName", title: "最后修改者" },
                { field: "lastModifyDate", title: "最后修改时间" },
            ]
        ];

        table.render({
            elem: '#databaseLinkList',
            height: 409,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: databaseLinkTableHead,
            toolbar: false,
            limit: 10
        });
    }

    function getAndLoadDatabaseLinksTableBody() {
        var succ = function () {
            $Utils.windowLoading.close();
            loadDatabaseLinksTableBody();
        };
        var fail = function (errorStatus, msg) {
            $Utils.windowLoading.close();
            $Utils.openWindow.failWindow("获取数据库连接", errorStatus, msg);
        };
        databaseLinks.getItems(2, true, succ, fail);
    }

    function loadDatabaseLinksTableBody() {
        var databaseLinksTableBody = [];
        for (var i = 0; i < databaseLinks.count; i++) {
            var tempObj = {};
            for (var key in databaseLinks.item(i)) {
                if (typeof databaseLinks.item(i)[key] === "function") { continue; }
                if (key == "createDate") {
                    tempObj[key] = databaseLinks.item(i)[key] ? $Utils.formatString.date("YYYY-MM-dd HH:mm", new Date(databaseLinks.item(i)[key])) : "";
                } else if (key == "lastModifyDate") {
                    tempObj[key] = databaseLinks.item(i)[key] ? $Utils.formatString.date("YYYY-MM-dd HH:mm", new Date(databaseLinks.item(i)[key])) : "";
                } else {
                    tempObj[key] = databaseLinks.item(i)[key];
                }
            }
            databaseLinksTableBody.push(tempObj);
        }
        table.reload("databaseLinkList", { data: databaseLinksTableBody, limit: databaseLinksTableBody.length });
    }

    function saveSelectedDatabaseLink() {
        var selectedDatabaseLink = table.checkStatus("databaseLinkList").data;
        mStoredProcedureModel.dataSourceID = selectedDatabaseLink[0].dataSourceID;
        mStoredProcedureModel.dataSourceName = selectedDatabaseLink[0].dataSourceName;
    }

    function initTableList() {
        $(".table-list-box").html("");
        getAndLoadStoredProcedureList();
        $(".select-database-link").hide();
        $(".stored-procedure-list").show();
        $("#filterContent").val("");
        $(".stored-procedure-list .next-step").attr("disabled", true);
        $(".filter-button").off("click").on("click", function () {
            loadTableList($("#filterContent").val())
        });
        $(".stored-procedure-list .last-step").off("click").on("click", function () {
            $(".stored-procedure-list").hide();
            $(".select-database-link").show();
        });
        $(".stored-procedure-list .next-step").off("click").on("click", function () {
            if ($(this).prop("disabled") == false) {
                $Utils.windowLoading.open();
                var formData = form.val("addModel");
                mStoredProcedureModel.storedProcedureName = formData.storedProcedureName;
                selectedStoredProcedure = null;
                for(var i = 0; i < storedProcedureList.length; i++){
                    if (storedProcedureList[i].storedProcedureName == formData.storedProcedureName){
                        selectedStoredProcedure = storedProcedureList[i];
                    }
                }
                initParamters();
            }
        });
    }

    function getAndLoadStoredProcedureList() {
        var succ = function (data) {
            $Utils.windowLoading.close();
            selectedStoredProcedure = null;
            storedProcedureList = data || [];
            loadStoredProcedureList(data || []);
        };
        var fail = function (errorStatus, msg) {
            $Utils.windowLoading.close();
            $Utils.openWindow.failWindow("获取存储过程列表", errorStatus, msg);
        };
        databaseLinks.item(mStoredProcedureModel.dataSourceID).getStoredProcedures(true, succ, fail);
    }

    function loadStoredProcedureList(storedProcedures) {
        var storedProcedureName = document.getElementById("storedProcedureName");
        for (var i = 0; i < storedProcedures.length; i++) {
            var option = document.createElement("option");
            option.setAttribute("value", storedProcedures[i].storedProcedureName);
            if (i == 0) {
                option.setAttribute("selected", true);
                if ($(".stored-procedure-list .next-step").prop("disabled") == true) {
                    $(".stored-procedure-list .next-step").attr("disabled", false);
                }
            }
            option.innerText = storedProcedures[i].storedProcedureName;
            storedProcedureName.appendChild(option);
        }
        form.render("select");
    }

    function initParamters() {
        $Utils.windowLoading.close();
        $(".stored-procedure-list").hide();
        $(".paramters-list").show();
        // $(".paramters-list .next-step").attr("disabled", true);
        $(".paramters-list .last-step").off("click").on("click", function () {
            $(".paramters-list").hide();
            $(".stored-procedure-list").show();
        });
        $(".paramters-list .next-step").off("click").on("click", function () {
            if(validateParamter()){
                initSQL();
            }
        });
        loadParamtersList();
        initParamtersDetailsListTableEvent();
    }

    function loadParamtersList(){
        var tableHead = [
            [
                { field: "paramName", title: "参数名称" },
                { field: "dataType", title: "数据类型", templet: "#selectParamterDataType" },
                { field: "paramValue", title: "值", event: "setParamValue" }
            ]
        ];
        var tableBody = [];
        for (var i = 0; i < selectedStoredProcedure.storedProcedureParams.length; i++) {
            var obj = {};
            obj.paramName = selectedStoredProcedure.storedProcedureParams[i].paramName;
            obj.dataType = selectedStoredProcedure.storedProcedureParams[i].dataType;
            obj.paramValue = "";
            tableBody.push(obj);
        }
        paramterDetailsList = tableBody;
        table.render({
            elem: '#paramtersList',
            height: 409,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: tableHead,
            data: tableBody,
            toolbar: false,
            limit: tableBody.length,
            done: function (res, curr, count) {
                initParamterTableSelectEvent();
            }
        });
    }

    function initParamterTableSelectEvent(){
        $(".paramters-list select[name='paramterDataType']").html(createParamtersOptions(dataType));
        layui.each($(".paramters-list select[name='paramterDataType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        form.render('select');
    }

    function createParamtersOptions(dataList) {
        var str = "";
        for (var i = 0; i < 3; i++) {
            str += "<option value=" + dataList[i].id + ">" + dataList[i].name + "</option>";
        }
        return str;
    }

    function initParamtersDetailsListTableEvent(){
        form.on('select(paramterDataType)', function (obj) {
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            paramterDetailsList[trElem.data('index')]["dataType"] = Number(obj.value);
            form.render('select');
        });
        table.on("tool(paramtersList)", function (obj) {
            if (obj.event == "setParamValue") {
                getAndLoadParamValueHtml(obj);
            }
        });
    }

    function getAndLoadParamValueHtml(obj){
        $.ajax({
            url: "html/iBusinessModel/businessModel/storedProcedureModel/paramValue.html",
            type: 'GET',
            success: function (data) {
                loadParamValueHtml(obj, data);
            }
        });
    }

    function loadParamValueHtml(obj, strHtml){
        layer.open({
            type: 1,
            title: ["列", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["530px", "400px"],
            content: strHtml,
            success: function (layero, index) {
                initParamValue(obj, index, setParamValueToTableCell);
            }
        });
    }

    var setParamValueToTableCell = function (obj, paramValue, index){
        obj.update({
            "paramValue": paramValue
        });
        layer.close(index);
    };

    function validateParamter(){
        for (var i = 0; i < paramterDetailsList.length; i++){
            if (paramterDetailsList[i].paramValue == ""){
                layer.msg("请填写参数 " + paramterDetailsList[i].paramName + " 的值。", {icon: 2});
                return false;
            }
        }
        return true;
    }

    function initSQL(){
        $(".paramters-list").hide();
        $(".add-table-model-window .sql-content-box").show();
        $(".add-table-model-window .sql-content-box .next-step").attr("disabled", false);
        $(".add-table-model-window .sql-content-box .last-step").off("click").on("click", function () {
            $(".add-table-model-window .sql-content-box").hide();
            $(".paramters-list").show();
        });
        $(".add-table-model-window .sql-content-box .next-step").off("click").on("click", function () {
            if ($(this).prop("disabled") == false) {
                $Utils.windowLoading.open();
                getAndInitFieldDetailsList($.trim($(".add-table-model-window .sql-content").val()))
            }
        });

        loadSQLToTextarea();
        bindSQLEvent();
    }

    function loadSQLToTextarea(){
        var databaseTypeName = databaseLinks.item(mStoredProcedureModel.dataSourceID).databaseTypeName;
        if (databaseTypeName == "SQLServer"){
            loadSQLServer();
        }
        if (databaseTypeName == "MySql"){
            loadMySql();
        }
    }

    function loadSQLServer(){
        var tempArr = [];
        for (var i = 0; i < paramterDetailsList.length; i++){
            if (paramterDetailsList[i].dataType == 0){
                if (paramterDetailsList[i].paramValue.indexOf("@Prompt(") != -1) {
                    tempArr.push((paramterDetailsList[i].paramName + "='1'"));
                } else {
                    tempArr.push((paramterDetailsList[i].paramName + "='" + paramterDetailsList[i].paramValue + "'"));
                }
            }
            if (paramterDetailsList[i].dataType == 1) {
                tempArr.push((paramterDetailsList[i].paramName + "='"+ $Utils.formatString.date("", new Date()) +"'"));
            }
            if (paramterDetailsList[i].dataType == 2) {
                if (paramterDetailsList[i].paramValue.indexOf("@Prompt(") != -1) {
                    tempArr.push((paramterDetailsList[i].paramName + "=1"));
                }else{
                    tempArr.push((paramterDetailsList[i].paramName + "=" + paramterDetailsList[i].paramValue));
                }
            }
        }
        var sqlText = "exec " + mStoredProcedureModel.storedProcedureName + " " + tempArr.join(",");
        form.val("addModel",{
            sqlText: sqlText
        });
    }

    function loadMySql(){
        var tempArr = [];
        for (var i = 0; i < paramterDetailsList.length; i++) {
            if (paramterDetailsList[i].dataType == 0) {
                if (paramterDetailsList[i].paramValue.indexOf("@Prompt(") != -1) {
                    tempArr.push("'1'");
                } else {
                    tempArr.push(("'" + paramterDetailsList[i].paramValue + "'"));
                }
            }
            if (paramterDetailsList[i].dataType == 1) {
                tempArr.push(("'" + $Utils.formatString.date("", new Date()) + "'"));
            }
            if (paramterDetailsList[i].dataType == 2) {
                if (paramterDetailsList[i].paramValue.indexOf("@Prompt(") != -1) {
                    tempArr.push("1");
                } else {
                    tempArr.push(paramterDetailsList[i].paramValue);
                }
            }
        }
        var sqlText = "call " + mStoredProcedureModel.storedProcedureName + "(" + tempArr.join(",") + ")";
        form.val("addModel", {
            sqlText: sqlText
        });
    }

    function bindSQLEvent(){
        $(".add-table-model-window .analyse").off("click").on("click", function () {
            if ($(".sql-content").val().length) {
                validateSql($.trim($(".sql-content").val()))
            } else {
                layer.msg("请填写SQL语句。", { icon: 2 });
            }
        });
        $(".add-table-model-window .check-results").off("click").on("click", function () {
            if ($(".sql-content").val().length) {
                getAndLoadResults($.trim($(".sql-content").val()));
            } else {
                layer.msg("请填写SQL语句。", { icon: 2 });
            }
        });

        $(".add-table-model-window .sql-content").bind('input propertychange', function () {
            var length = $(".add-table-model-window .sql-content").val().length;
            if (length) {
                $(".add-table-model-window .sql-content-box .next-step").attr("disabled", false);
            } else {
                $(".add-table-model-window .sql-content-box .next-step").attr("disabled", true);
            }
        });
    }

    function validateSql(sqlText) {
        var succ = function () {
            layer.msg("SQL语句正确。", { icon: 1 });
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("验证SQL", errorStatus, msg);
        };
        databaseLinks.item(mStoredProcedureModel.dataSourceID).executeSQL(sqlText, true, succ, fail);
    }

    function getAndLoadResults(sqlText) {
        var succ = function (data) {
            loadDataList(data);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取结果集", errorStatus, msg);
        };
        databaseLinks.item(mStoredProcedureModel.dataSourceID).getBusinessData(sqlText, true, succ, fail);
    }

    function loadDataList(data) {
        layer.open({
            type: 1,
            title: ["结果集（前200行）", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["700px", "525px"],
            content: "<div class='table-data-list'><div class='no-data' style='line-height: 30px; text-align: center;'>无数据</div><table class='layui-hide' id='tableDataList' lay-filter='tableDataList'></table></div>",
            success: function (layero, index) {
                loadTableDataList(data);
            }
        });
    }

    function loadTableDataList(data) {
        var tableHead = [];
        var i = 0;
        if (!data.length) return;
        $(".no-data").remove();
        for (var key in data[0]) {
            var obj = {};
            obj.field = key;
            obj.title = key;
            obj.sort = true;
            obj.align = "center";
            tableHead.push(obj);
        }

        var tableBody = [];
        for (var i = 0; i < data.length; i++) {
            var obj = {};
            for (var j = 0; j < tableHead.length; j++) {
                obj[tableHead[j].title] = data[i][tableHead[j].title];
            }
            tableBody.push(obj);
        }

        table.render({
            elem: '#tableDataList',
            height: 478,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: [tableHead],
            data: tableBody,
            toolbar: false,
            limit: tableBody.length
        });
    }

    function getAndInitFieldDetailsList(sqlText) {
        var succ = function (data) {
            initFieldDetailsList(data);
        };
        var fail = function (errorStatus, msg) {
            $Utils.windowLoading.close();
            $Utils.openWindow.failWindow("获取业务对象", errorStatus, msg);
        };
        databaseLinks.item(mStoredProcedureModel.dataSourceID).getBusinessData(sqlText, true, succ, fail);
    }

    function initFieldDetailsList(data) {
        $(".sql-content-box").hide();
        $(".field-details-list").show();
        loadFieldDetailsList(data);
        initFieldDetailsListTableEvent();
        $Utils.windowLoading.close();

        $(".field-details-list .last-step").off("click").on("click", function () {
            $(".field-details-list").hide();
            $(".sql-content-box").show();
        });
        $(".field-details-list .next-step").off("click").on("click", function () {
            if (businessObjectTypeAndDataType()) {
                layer.msg("度量的数据类型必须为数字。", { icon: 2 });
                return false;
            } else {
                saveBusinessObject();
                initModelNameAndDescription();
            }
        });
    }

    function loadFieldDetailsList(data) {
        var tableHead = [
            [
                { field: "columnName", title: "列名" },
                { field: "businessObjectName", title: "业务对象名称"},
                { field: "dataType", title: "数据类型", templet: "#selectDataType" },
                { field: "businessObjectType", title: "对象类型", templet: "#selectObjectType" },
                { field: "aggregateFunction", title: "聚合", templet: "#selectAggregation" },
                { field: "valueOrder", title: "排序", templet: "#selectSort" },
                { field: "formatString", title: "数值格式", event: "setDataFormat" }
            ]
        ];
        var tableBody = [];
        if (data.length) {
            for (var key in data[0]) {
                var obj = {};
                obj.columnName = key;
                obj.businessObjectName = key;
                obj.dataType = 0;
                obj.businessObjectType = 0;
                obj.aggregateFunction = 0;
                obj.valueOrder = 0;
                obj.formatString = "";
                tableBody.push(obj);
            }
        }
        fieldDetailsList = tableBody;
        table.render({
            elem: '#fieldDetailsList',
            height: 409,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: tableHead,
            data: tableBody,
            even: true,
            toolbar: false,
            limit: tableBody.length,
            done: function (res, curr, count) {
                initTableSelectEvent();
            }
        });
    }

    function initTableSelectEvent() {
        $("select[name='dataType']").html(createOptions(dataType));
        layui.each($("select[name='dataType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='businessObjectType']").html(createOptions(objectType));
        layui.each($("select[name='businessObjectType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='aggregateFunction']").html(createOptions(aggregation));
        layui.each($("select[name='aggregateFunction']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='valueOrder']").html(createOptions(sort));
        layui.each($("select[name='valueOrder']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        form.render('select');
    }

    function createOptions(dataList) {
        var str = "";
        for (var i = 0; i < dataList.length; i++) {
            str += "<option value=" + dataList[i].id + ">" + dataList[i].name + "</option>";
        }
        return str;
    }

    function initFieldDetailsListTableEvent() {
        form.on('select(dataType)', function (obj) {
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(objectType)', function (obj) {
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(aggregation)', function (obj) {
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(sort)', function (obj) {
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        table.on("tool(fieldDetailsList)", function (obj) {
            if (obj.event == "setDataFormat") {
                getAndLoadDataFormatHtml(obj);
            }
        });
    }

    function getAndLoadDataFormatHtml(obj) {
        $.ajax({
            url: "html/dataFormat/dataFormat.html",
            type: 'GET',
            success: function (data) {
                loadDataFormatHtml(obj, data);
            }
        });
    }

    function loadDataFormatHtml(obj, strHtml) {
        layer.open({
            type: 1,
            title: ["数值格式", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["700px", "525px"],
            content: strHtml,
            success: function (layero, index) {
                initDataFormat(obj, index, setDataFormatToTableCell);
            }
        });
    }

    var setDataFormatToTableCell = function (obj, dataFormatStr, index) {
        obj.update({
            "formatString": dataFormatStr || ""
        });
        layer.close(index);
    };

    function businessObjectTypeAndDataType() {
        for (var i = 0; i < fieldDetailsList.length; i++) {
            if (fieldDetailsList[i].businessObjectType == 1 && fieldDetailsList[i].dataType != 2) {
                return true;
            }
        }
        return false;
    }

    function saveBusinessObject() {
        var guid = new GUID();
        var businessObjectsArr = [];
        for (var i = 0; i < fieldDetailsList.length; i++) {
            var businessObject = new BusinessObject();
            businessObject.businessObjectID = guid.newGUID();
            businessObject.businessObjectName = fieldDetailsList[i].businessObjectName;
            businessObject.businessObjectType = fieldDetailsList[i].businessObjectType;
            businessObject.businessObjectFolderID = "-1";
            businessObject.dataType = fieldDetailsList[i].dataType;
            businessObject.aggregateFunction = fieldDetailsList[i].aggregateFunction == 0 ? false : true;
            businessObject.aggregateAware = false;
            //ASC升序   DESC降序
            businessObject.valueOrder = fieldDetailsList[i].valueOrder == 0 ? "" : (fieldDetailsList[i].valueOrder == 1 ? "ASC" : "DESC");
            businessObject.formatString = fieldDetailsList[i].formatString;
            businessObject.columnName = fieldDetailsList[i].columnName;
            //表名.列名
            businessObject.expressionText = fieldDetailsList[i].columnName;
            businessObject.expressionList = [fieldDetailsList[i].columnName];
            businessObject.tableNamesList = [];
            businessObject.sortIndex = i;
            businessObjectsArr.push(businessObject);
        }
        for (var i = 0; i < paramterDetailsList.length; i++) {
            var businessObject = new BusinessObject();
            businessObject.businessObjectID = guid.newGUID();
            businessObject.businessObjectName = paramterDetailsList[i].paramName;
            businessObject.businessObjectType = 2;
            businessObject.businessObjectFolderID = "-1";
            businessObject.dataType = paramterDetailsList[i].dataType;
            businessObject.aggregateFunction = false;
            businessObject.aggregateAware = false;
            //ASC升序   DESC降序
            businessObject.valueOrder = "";
            businessObject.formatString = "";
            businessObject.columnName = null;
            //表名.列名
            businessObject.expressionText = paramterDetailsList[i].paramValue;
            businessObject.expressionList = [paramterDetailsList[i].paramValue];
            businessObject.tableNamesList = [];
            businessObject.sortIndex = businessObjectsArr.length + i;
            businessObjectsArr.push(businessObject);
        }
        mStoredProcedureModel.businessObjects = businessObjectsArr;
    }

    function initModelNameAndDescription() {
        $(".field-details-list").hide();
        $(".model-detail").show();
        $Utils.windowLoading.close();

        $(".model-detail input,.model-detail textarea").val("");
        $(".model-detail input").focus();
        $(".model-detail .next-step").attr("disabled", true);
        $("#businessModelName").on("input propertychange", function () {
            if ($(this).val() == "") {
                $(".model-detail .next-step").attr("disabled", true);
            } else {
                $(".model-detail .next-step").attr("disabled", false);
            }
        });
        $(".model-detail .last-step").off("click").on("click", function () {
            $(".model-detail").hide();
            $(".field-details-list").show();
        });
        $(".model-detail .next-step").off("click").on("click", function () {
            saveModelDetail();
            addSubmitForm(mStoredProcedureModel, layerIndex);
        });

        createTreeSelect();
    }

    function saveModelDetail() {
        var data = form.val("addModel");
        mStoredProcedureModel.businessModelName = data.businessModelName;
        mStoredProcedureModel.businessModelType = 4;
        mStoredProcedureModel.folderID = data.folderID;
        mStoredProcedureModel.description = data.description;
    }

    function createTreeSelect() {
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function (node) { //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
            },
        });
        if (addMFolderID == -1) {
            $(".table-model-detail .layui-form-select").find(".layui-select-title span").html("存储过程模型").end().find("input:hidden[name='folderID']").val(-1);
        } else {
            $(".table-model-detail .layui-form-select").find(".layui-select-title span").html(mBusinessModelFolders.item(addMFolderID).folderName).end().find("input:hidden[name='folderID']").val(addMFolderID);
        }
        $(".table-model-detail .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".table-model-detail .layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders() {
        var index = 0;
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { title: "存储过程模型", id: index, folderID: "-1", folderParentID: "0", spread: true });
        index++;
        for (var i = 0; i < mBusinessModelFolders.count; i++) {
            hashTable.add(mBusinessModelFolders.item(i).folderID, { title: mBusinessModelFolders.item(i).folderName, id: index, folderID: mBusinessModelFolders.item(i).folderID, folderParentID: mBusinessModelFolders.item(i).folderParentID });
            index++;
        }
        for (var i = 0; i < mBusinessModelFolders.count; i++) {
            var parentFolder = hashTable.getValue(mBusinessModelFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(mBusinessModelFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function GUID() {
        this.date = new Date();   /* 判断是否初始化过，如果初始化过以下代码，则以下代码将不再执行，实际中只执行一次 */
        if (typeof this.newGUID != 'function') {   /* 生成GUID码 */
            GUID.prototype.newGUID = function () {
                this.date = new Date(); var guidStr = '';
                sexadecimalDate = this.hexadecimal(this.getGUIDDate(), 16);
                sexadecimalTime = this.hexadecimal(this.getGUIDTime(), 16);
                for (var i = 0; i < 9; i++) {
                    guidStr += Math.floor(Math.random() * 16).toString(16);
                }
                guidStr += sexadecimalDate;
                guidStr += sexadecimalTime;
                while (guidStr.length < 32) {
                    guidStr += Math.floor(Math.random() * 16).toString(16);
                }
                return this.formatGUID(guidStr);
            }
            /* * 功能：获取当前日期的GUID格式，即8位数的日期：19700101 * 返回值：返回GUID日期格式的字条串 */
            GUID.prototype.getGUIDDate = function () {
                return this.date.getFullYear() + this.addZero(this.date.getMonth() + 1) + this.addZero(this.date.getDay());
            }
            /* * 功能：获取当前时间的GUID格式，即8位数的时间，包括毫秒，毫秒为2位数：12300933 * 返回值：返回GUID日期格式的字条串 */
            GUID.prototype.getGUIDTime = function () {
                return this.addZero(this.date.getHours()) + this.addZero(this.date.getMinutes()) + this.addZero(this.date.getSeconds()) + this.addZero(parseInt(this.date.getMilliseconds() / 10));
            }
            /* * 功能: 为一位数的正整数前面添加0，如果是可以转成非NaN数字的字符串也可以实现 * 参数: 参数表示准备再前面添加0的数字或可以转换成数字的字符串 * 返回值: 如果符合条件，返回添加0后的字条串类型，否则返回自身的字符串 */
            GUID.prototype.addZero = function (num) {
                if (Number(num).toString() != 'NaN' && num >= 0 && num < 10) {
                    return '0' + Math.floor(num);
                } else {
                    return num.toString();
                }
            }
            /*  * 功能：将y进制的数值，转换为x进制的数值 * 参数：第1个参数表示欲转换的数值；第2个参数表示欲转换的进制；第3个参数可选，表示当前的进制数，如不写则为10 * 返回值：返回转换后的字符串 */GUID.prototype.hexadecimal = function (num, x, y) {
                if (y != undefined) { return parseInt(num.toString(), y).toString(x); }
                else { return parseInt(num.toString()).toString(x); }
            }
            /* * 功能：格式化32位的字符串为GUID模式的字符串 * 参数：第1个参数表示32位的字符串 * 返回值：标准GUID格式的字符串 */
            GUID.prototype.formatGUID = function (guidStr) {
                var str1 = guidStr.slice(0, 8) + '-', str2 = guidStr.slice(8, 12) + '-', str3 = guidStr.slice(12, 16) + '-', str4 = guidStr.slice(16, 20) + '-', str5 = guidStr.slice(20);
                return str1 + str2 + str3 + str4 + str5;
            }
        }
    }
    
}();