/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-31 15:38:41
 * @LastEditTime: 2021-05-11 09:13:09
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, form = layui.form, element = layui.element, tree = layui.tree;
    var formEditSubmit = null;
    var layerIndex = null;
    var mSqlModel = null;
    var mFolders = null;
    var fieldDetailsList = [];
    var databaseLinks = new DatabaseLinks();

    var dataType = [
        {"id": 0, "name": "字符串"},
        {"id": 1, "name": "日期"},
        {"id": 2, "name": "数字"},
        {"id": 3, "name": "图像URL"},
        {"id": 4, "name": "图像二进制"},
    ];
    var objectType = [
        {"id": 0, "name": "维度"},
        {"id": 1, "name": "度量"}
    ];
    var aggregation = [
        {"id": 0, "name": "无"},
        {"id": 1, "name": "总和"},
        {"id": 2, "name": "平均"},
        {"id": 3, "name": "计数"},
        {"id": 4, "name": "最大值"},
        {"id": 5, "name": "最小值"}
    ];
    var sort = [
        {"id": 0, "name": "无排序"},
        {"id": 1, "name": "升序"},
        {"id": 2, "name": "降序"},
    ];
    
    window.initEditSqlModel = function (index, sqlModel, businessModelFolders,editSubmit){
        layerIndex = index;
        mSqlModel = sqlModel;
        formEditSubmit = editSubmit;
        mFolders = businessModelFolders;

        getBusinessObjects(sqlModel);
        getDatabaseLinks();
        createTreeSelect();
        initEditSqlModelForm(sqlModel);
        $Utils.windowLoading.close();
    }

    function getBusinessObjects(sqlModel){
        var succ = function(){};
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+sqlModel.businessModelName+" 业务对象",errorStatus,msg);
        };
		mSqlModel.initByModelID(sqlModel.businessModelID,false,succ,fail);
    }

    function getDatabaseLinks(){
        var succ = function(){
            $Utils.loading.close();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库连接",errorStatus,msg);
		};
		databaseLinks.getItems(2,false,succ,fail);
    }

    function createTreeSelect() {
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function (node) { //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
            },
        });
        if (mSqlModel.folderID == -1) {
            $(".model-window .layui-form-select").find(".layui-select-title span").html("SQL模型").end().find("input:hidden[name='folderID']").val(-1);
        } else {
            $(".model-window .layui-form-select").find(".layui-select-title span").html(mFolders.item(mSqlModel.folderID).folderName).end().find("input:hidden[name='folderID']").val(mSqlModel.folderID);
        }
        $(".model-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".model-window .parent-folder .layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders() {
        var index = 0;
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { title: "SQL模型", id: index, folderID: "-1", folderParentID: "0", spread: true });
        index++;
        for (var i = 0; i < mFolders.count; i++) {
            hashTable.add(mFolders.item(i).folderID, { title: mFolders.item(i).folderName, id: index, folderID: mFolders.item(i).folderID, folderParentID: mFolders.item(i).folderParentID });
            index++;
        }
        for (var i = 0; i < mFolders.count; i++) {
            var parentFolder = hashTable.getValue(mFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(mFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function initEditSqlModelForm(sqlModel){
        form.val("editSqlModel",{
            "businessModelName": sqlModel.businessModelName,
            "description": sqlModel.description,
            "sqlText": sqlModel.sqlText
        });

        $(".edit-sql-model input[name=businessModelName]").focus();

        var createUserName = sqlModel.createUserName || "";
        var createDate = sqlModel.createDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(sqlModel.createDate)) : "";
        var lastModifyUserName = sqlModel.lastModifyUserName || "";
        var lastModifyDate = sqlModel.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(sqlModel.lastModifyDate)) : "";
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);
        
        loadFieldDetailsTable(sqlModel);
        // loadFieldDetailsBody(sqlModel);

        var databaseLink = document.getElementById("databaseLink");
        for(var i = 0; i <= databaseLinks.count; i++){
            var option = document.createElement("option");
            if(i == 0){
                option.setAttribute("value",0);
                option.innerText = "请选择数据库连接";
            }else{
                option.setAttribute("value",databaseLinks.item(i-1).dataSourceID);
                if(databaseLinks.item(i-1).dataSourceID == sqlModel.dataSourceID){
                    option.setAttribute("selected",true);
                }
                option.innerText = databaseLinks.item(i-1).dataSourceName;
            }
            databaseLink.appendChild(option);
        }

        form.render('select');
        initFieldDetailsListTableEvent();

        element.on('tab(modelTab)', function (data) {
            if (sqlModel.sourceType == 1) {
                if (data.index == 1 || data.index == 2) {
                    layer.msg("订阅的模型不能编辑该栏目。", { icon: 2 });
                    element.tabChange("modelTab", 0);
                }

            }
        });

        form.on("submit(editModelSubmit)",function(obj){
            debugger
            if(obj.field.dataSourceID === "0"){
                layer.msg("请选择数据库连接。",{icon:2});
                return false;
            }
            if(change(obj)){
                if(businessObjectTypeAndDataType(obj)){
                    layer.msg("度量的数据类型必须为数字。",{icon: 2});
                    return false;
                }else{
                    $Utils.loading.open();
                    var editSqlModel = setEditSaveSqlModel(obj);
                    formEditSubmit(editSqlModel,layerIndex);
                }
            }else{
                layer.close(layerIndex);
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        $(".edit-model .edit-test-link").click(function(){
            $Utils.loading.open();
            var data = form.val("editSqlModel");
            if(databaseLinks.item(data.dataSourceID)){
                formTestConnections(data);
            }else{
                layer.msg("数据库连接不存在。",{icon:2});
            }
        });

        $(".analyse").off("click").on("click",function(){
            if($(".edit-sql-content").val().length){
                $Utils.loading.open();
                var data = form.val("editSqlModel");
                validateSql(data)
            }else{
                layer.msg("请填写SQL语句。",{icon:2});
            }
        });  

        $(".check-results").off("click").on("click",function(){
            if($(".edit-sql-content").val().length){
                $Utils.loading.open();
                var data = form.val("editSqlModel");
                getAndLoadResults(data);
            }else{
                layer.msg("请填写SQL语句。",{icon:2});
            }
        });

        $(".refresh-business-object").off("click").on("click",function(){
            if($(".edit-sql-content").val().length){
                $Utils.loading.open();
                var data = form.val("editSqlModel");
                getAndInitFieldDetailsList(data);
            }else{
                layer.msg("请填写SQL语句。",{icon:2});
            }
        });
    }

    function validateSql(data){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("SQL语句正确。",{icon:1});
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("验证SQL",errorStatus,msg);
        };
		databaseLinks.item(data.dataSourceID).executeSQL($.trim(data.sqlText),true,succ,fail);
    }

    function getAndLoadResults(data){
        var succ = function(data){
            $Utils.loading.close();
            loadDataList(data);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取结果集",errorStatus,msg);
        };
		databaseLinks.item(data.dataSourceID).getBusinessData($.trim(data.sqlText),true,succ,fail);
    }

    function loadDataList(data){
        layer.open({
            type: 1,
            title: ["结果集（前200行）","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["700px","525px"],
            content: "<div class='table-data-list'><table class='layui-hide' id='tableDataList' lay-filter='tableDataList'></table></div>",
            success: function(layero,index){
                loadTableDataList(data);
            }
        });
    }

    function getAndInitFieldDetailsList(data){
        var succ = function(data){
            $Utils.loading.close();
            reloadFielDetails(data);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取业务对象",errorStatus,msg);
        };
		databaseLinks.item(data.dataSourceID).getBusinessData($.trim(data.sqlText),true,succ,fail);
    }

    function reloadFielDetails(data){
        var tableBody = [];
        var guid = new GUID();
        if(data.length){
            for(var key in data[0]){
                var obj = {};
                obj.businessObjectID = guid.newGUID();
                obj.columnName = key;
                obj.businessObjectName = key;
                obj.dataType = 0;
                obj.businessObjectType = 0;
                obj.aggregateFunction = 0;
                obj.valueOrder = 0;
                obj.formatString = "";
                tableBody.push(obj);
            }
        }
        var newTableBody = [];
        for(var i = 0; i < tableBody.length; i++){
            for(var j = 0; j < fieldDetailsList.length; j++){
                if(tableBody[i].columnName == fieldDetailsList[j].columnName){
                    newTableBody.push(fieldDetailsList[j]);
                    break;
                }
            }
            j == fieldDetailsList.length && newTableBody.push(tableBody[i]);
        }
        fieldDetailsList = newTableBody;
        table.reload("fieldDetailsList",{data: newTableBody, limit: newTableBody.length});
    }

    function loadTableDataList(data){
        var tableHead = [];
        var i = 0;
        for(var key in data[0]){
            var obj = {};
            obj.field = key;
            obj.title = key;
            obj.sort = true;
            obj.align = "center";
            tableHead.push(obj);
        }

        var tableBody = [];
        for(var i = 0; i < data.length; i++){
            var obj = {};
            for(var j = 0; j < tableHead.length; j++){
                obj[tableHead[j].title] = data[i][tableHead[j].title];
            }
            tableBody.push(obj);
        }

        table.render({
            elem: '#tableDataList',
            height: 478,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: [tableHead],
            data: tableBody,
            toolbar: false,
            limit: tableBody.length
        });
    }

    function loadFieldDetailsTable(sqlModel){
        var tableHead = [
            [
                {field: "columnName", title: "列名"},
                {field: "businessObjectName", title: "业务对象名称", edit: "text"},
                {field: "dataType", title: "数据类型", templet: "#selectDataType"},
                {field: "businessObjectType", title: "对象类型", templet: "#selectObjectType"},
                {field: "aggregateFunction", title: "聚合", templet: "#selectAggregation"},
                {field: "valueOrder", title: "排序", templet: "#selectSort"},
                {field: "formatString", title: "数值格式", event: "setDataFormat"}
            ]
        ];
        var tableBody = [];
        for(var i = 0; i < sqlModel.businessObjects.count; i++){
            var obj = {};
            obj.columnName = sqlModel.businessObjects.item(i).columnName;
            obj.businessObjectName = sqlModel.businessObjects.item(i).businessObjectName;
            obj.dataType = sqlModel.businessObjects.item(i).dataType;
            obj.businessObjectType = sqlModel.businessObjects.item(i).businessObjectType;
            obj.aggregateFunction = setAggregateFunction(sqlModel.businessObjects.item(i));
            obj.valueOrder = sqlModel.businessObjects.item(i).valueOrder?(sqlModel.businessObjects.item(i).valueOrder.indexOf("ASC") != -1 ? 1: 2):0;
            obj.formatString = sqlModel.businessObjects.item(i).formatString;
            obj.businessObjectID = sqlModel.businessObjects.item(i).businessObjectID;
            obj.businessObjectFolderID = sqlModel.businessObjects.item(i).businessObjectFolderID;
            obj.aggregateAware = sqlModel.businessObjects.item(i).aggregateAware;
            obj.expressionText = sqlModel.businessObjects.item(i).expressionText;
            obj.expressionList = sqlModel.businessObjects.item(i).expressionList;
            obj.tableNamesList = sqlModel.businessObjects.item(i).tableNamesList;
            obj.sortIndex = sqlModel.businessObjects.item(i).sortIndex;
            obj.visibility = sqlModel.businessObjects.item(i).visibility;
            tableBody.push(obj);
        }
        fieldDetailsList = tableBody;
        table.render({
            elem: '#fieldDetailsList',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: tableHead,
            data: tableBody,
            limit: tableBody.length,
            toolbar: false,
            done: function (res, curr, count) {
                initTableSelectEvent();
            }
        });
    }

    function setAggregateFunction(businessObject){
        if(!businessObject.aggregateFunction){
            return 0;
        }else{
            if(businessObject.expressionText.indexOf("sum(") != -1){
                return 1;
            }
            if(businessObject.expressionText.indexOf("avg(") != -1){
                return 2;
            }
            if(businessObject.expressionText.indexOf("count(") != -1){
                return 3;
            }
            if(businessObject.expressionText.indexOf("max(") != -1){
                return 4;
            }
            if(businessObject.expressionText.indexOf("min(") != -1){
                return 5;
            }
        }
    }

    function initTableSelectEvent(){
        $("select[name='dataType']").html(createOptions(dataType));
        layui.each($("select[name='dataType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='businessObjectType']").html(createOptions(objectType));
        layui.each($("select[name='businessObjectType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='aggregateFunction']").html(createOptions(aggregation));
        layui.each($("select[name='aggregateFunction']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='valueOrder']").html(createOptions(sort));
        layui.each($("select[name='valueOrder']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        form.render('select');
    }

    function createOptions(dataList){
        var str = "";
        for(var i = 0; i < dataList.length; i++){
            str += "<option value="+dataList[i].id+">"+dataList[i].name+"</option>";
        }
        return str;
    }

    function initFieldDetailsListTableEvent(){
        form.on('select(dataType)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(objectType)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(aggregation)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(sort)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        table.on("tool(fieldDetailsList)",function(obj){
            if(obj.event == "setDataFormat"){
                getAndLoadDataFormatHtml(obj);
            }
        });
    }

    function getAndLoadDataFormatHtml(obj){
        $.ajax({
            url: "html/dataFormat/dataFormat.html",
            type: 'GET',
            success: function(data){
                loadDataFormatHtml(obj,data);
            }
        });
    }

    function loadDataFormatHtml(obj,strHtml){
        layer.open({
            type: 1,
            title: ["数值格式","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["700px","525px"],
            content: strHtml,
            success: function(layero,index){
                initDataFormat(obj,index,setDataFormatToTableCell);
            }
        });
    }

    var setDataFormatToTableCell = function(obj,dataFormatStr,index){
        obj.update({
            "formatString": dataFormatStr || ""
        });
        layer.close(index);
    };

    function change(obj){
        if(obj.field.description != mSqlModel.description){
            return true;
        }
        if (obj.field.folderID != mSqlModel.folderID) {
            return true;
        }
        if (obj.field.dataSourceID != mSqlModel.dataSourceID) {
            return true;
        }
        if(businessObjectChange(obj)){
            return true;
        }
        if(obj.field.sqlText != mSqlModel.sqlText){
            return true;
        }
        
        return false;
    }

    function businessObjectChange(obj){
        var compareArr = transformationFieldDetailsList(obj);
        for(var i = 0; i < compareArr.length; i++){
            if(!mSqlModel.businessObjects.item(compareArr[i].businessObjectID)){ return true;}
            for(var key in mSqlModel.businessObjects.item(compareArr[i].businessObjectID)){
                if(typeof mSqlModel.businessObjects.item(compareArr[i].businessObjectID)[key] === "function"){ continue;}
                if(JSON.stringify(compareArr[i][key]) != JSON.stringify(mSqlModel.businessObjects.item(compareArr[i].businessObjectID)[key])){
                    return true;
                }
            }
        }
        return false;
    }

    function transformationFieldDetailsList(obj){
        var compareArr = $.extend(true,[],fieldDetailsList);
        for(var i = 0; i < compareArr.length; i++){
            compareArr[i].expressionText = aggregateStr("T",compareArr[i].columnName,compareArr[i].aggregateFunction,obj);
            compareArr[i].expressionList = [compareArr[i].expressionText];
            
            compareArr[i].aggregateFunction = compareArr[i].aggregateFunction == 0?false:true;
            compareArr[i].valueOrder = compareArr[i].valueOrder==0?"":(compareArr[i].valueOrder==1?"ASC":"DESC");
        }
        return compareArr;
    }

    function aggregateStr(tableName,columnName,aggregationID,obj){
        if(aggregationID == 0){
            return tableName+"."+setColumnName(columnName,obj);
        }
        if(aggregationID == 1){
            return "sum("+tableName+"."+setColumnName(columnName,obj)+")";
        }
        if(aggregationID == 2){
            return "avg("+tableName+"."+setColumnName(columnName,obj)+")";
        }
        if(aggregationID == 3){
            return "count("+tableName+"."+setColumnName(columnName,obj)+")";
        }
        if(aggregationID == 4){
            return "max("+tableName+"."+setColumnName(columnName,obj)+")";
        }
        if(aggregationID == 5){
            return "min("+tableName+"."+setColumnName(columnName,obj)+")";
        }
    }

    function setColumnName(columnName,obj){
        if(databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("SQLServer") != -1 || databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("Access") != -1){
            columnName = "[" + columnName + "]";
        }else if(databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("Oracle") != -1 || databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("PostgreSQL") != -1 || databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("DB2") != -1){
            columnName = "\"" + columnName + "\"";
        }else if(databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("MySql") != -1 || databaseLinks.item(obj.field.dataSourceID).databaseTypeName.indexOf("Hive") != -1){
            columnName = "`" + columnName + "`";
        }

        return columnName;
    }

    function setEditSaveSqlModel(obj){
        var sqlModelObj = {};
        sqlModelObj.businessModelID = mSqlModel.businessModelID;
        sqlModelObj.businessModelType = mSqlModel.businessModelType;
        sqlModelObj.sqlText = obj.field.sqlText;
        sqlModelObj.businessModelName = obj.field.businessModelName;
        sqlModelObj.folderID = obj.field.folderID;
        sqlModelObj.description = obj.field.description;
        sqlModelObj.dataSourceID = obj.field.dataSourceID;
        sqlModelObj.dataSourceName = databaseLinks.item(obj.field.dataSourceID)?databaseLinks.item(obj.field.dataSourceID).dataSourceName:"";
        sqlModelObj.businessObjects = saveBusinessObject(mSqlModel.tableName,obj);
        return sqlModelObj;
    }

    function businessObjectTypeAndDataType(obj){
        var compareArr = transformationFieldDetailsList(obj);
        for(var i = 0; i < compareArr.length; i++){
            if(compareArr[i].businessObjectType == 1 && compareArr[i].dataType != 2){
                return true;
            }
        }
        return false;
    }

    function saveBusinessObject(tableName,obj){
        var businessObjectsArr = [];
        for(var i = 0; i < fieldDetailsList.length; i++){
            var businessObject = new BusinessObject();
            businessObject.businessObjectID = fieldDetailsList[i].businessObjectID;
            businessObject.businessObjectName = fieldDetailsList[i].businessObjectName;
            businessObject.businessObjectType = fieldDetailsList[i].businessObjectType;
            businessObject.businessObjectFolderID = "-1";
            businessObject.dataType = fieldDetailsList[i].dataType;
            businessObject.aggregateFunction = fieldDetailsList[i].aggregateFunction == 0?false:true;
            businessObject.aggregateAware = false;
            //ASC升序   DESC降序
            businessObject.valueOrder = fieldDetailsList[i].valueOrder==0?"":(fieldDetailsList[i].valueOrder==1?"ASC":"DESC");
            businessObject.formatString = fieldDetailsList[i].formatString;
            businessObject.columnName = fieldDetailsList[i].columnName;
            //表名.列名
            businessObject.expressionText = aggregateStr("T",fieldDetailsList[i].columnName,fieldDetailsList[i].aggregateFunction,obj);
            businessObject.expressionList = [businessObject.expressionText];
            businessObject.tableNamesList = [["T"]];
            businessObject.sortIndex = i;
            businessObjectsArr.push(businessObject);
        }
        return businessObjectsArr;
    }

    function formTestConnections(data){
        var parameters = "databaseTypeName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseTypeName)+"&databaseTypeVersion="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseTypeVersion)+"&databaseIP="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseIP)+"&databasePort="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databasePort)+
        "&userName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).userName)+"&password="+encodeURIComponent(databaseLinks.item(data.dataSourceID).password)+"&databaseName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseName);
        var succ = function(){
            $Utils.loading.close();
            layer.msg("连接成功！",{icon:1});
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("测试连接",errorStatus,msg);
        };
        databaseLinks.item(data.dataSourceID).testConnections(parameters,true,succ,fail);
    }

    function GUID(){
        this.date = new Date();   /* 判断是否初始化过，如果初始化过以下代码，则以下代码将不再执行，实际中只执行一次 */
        if (typeof this.newGUID != 'function') {   /* 生成GUID码 */
            GUID.prototype.newGUID = function () {
                this.date = new Date(); var guidStr = '';
                sexadecimalDate = this.hexadecimal(this.getGUIDDate(), 16);
                sexadecimalTime = this.hexadecimal(this.getGUIDTime(), 16);
                for (var i = 0; i < 9; i++) {
                    guidStr += Math.floor(Math.random() * 16).toString(16);
                }
                guidStr += sexadecimalDate;
                guidStr += sexadecimalTime;
                while (guidStr.length < 32) {
                    guidStr += Math.floor(Math.random() * 16).toString(16);
                }
                return this.formatGUID(guidStr);
            }
            /* * 功能：获取当前日期的GUID格式，即8位数的日期：19700101 * 返回值：返回GUID日期格式的字条串 */
            GUID.prototype.getGUIDDate = function () {
                return this.date.getFullYear() + this.addZero(this.date.getMonth() + 1) + this.addZero(this.date.getDay());
            }
            /* * 功能：获取当前时间的GUID格式，即8位数的时间，包括毫秒，毫秒为2位数：12300933 * 返回值：返回GUID日期格式的字条串 */
            GUID.prototype.getGUIDTime = function () {
                return this.addZero(this.date.getHours()) + this.addZero(this.date.getMinutes()) + this.addZero(this.date.getSeconds()) + this.addZero(parseInt(this.date.getMilliseconds() / 10));
            }
            /* * 功能: 为一位数的正整数前面添加0，如果是可以转成非NaN数字的字符串也可以实现 * 参数: 参数表示准备再前面添加0的数字或可以转换成数字的字符串 * 返回值: 如果符合条件，返回添加0后的字条串类型，否则返回自身的字符串 */
            GUID.prototype.addZero = function (num) {
                if (Number(num).toString() != 'NaN' && num >= 0 && num < 10) {
                    return '0' + Math.floor(num);
                } else {
                    return num.toString();
                }
            }
            /*  * 功能：将y进制的数值，转换为x进制的数值 * 参数：第1个参数表示欲转换的数值；第2个参数表示欲转换的进制；第3个参数可选，表示当前的进制数，如不写则为10 * 返回值：返回转换后的字符串 */GUID.prototype.hexadecimal = function (num, x, y) {
                if (y != undefined) { return parseInt(num.toString(), y).toString(x); }
                else { return parseInt(num.toString()).toString(x); }
            }
            /* * 功能：格式化32位的字符串为GUID模式的字符串 * 参数：第1个参数表示32位的字符串 * 返回值：标准GUID格式的字符串 */
            GUID.prototype.formatGUID = function (guidStr) {
                var str1 = guidStr.slice(0, 8) + '-', str2 = guidStr.slice(8, 12) + '-', str3 = guidStr.slice(12, 16) + '-', str4 = guidStr.slice(16, 20) + '-', str5 = guidStr.slice(20);
                return str1 + str2 + str3 + str4 + str5;
            }
        }
    }
    
}();