!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var relationModels = new RelationModels();
    var businessModelFolders = new BusinessModelFolders();
    var reports = new Reports();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var mFolderID = "-1";
    var isFirst = true;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var currentTableBodyData = [];

    $Utils.loading.open();
    initMain();
    
    function initMain(){
        if ($AppVars.serverEdition != 2){
            $(".group-function-button").remove();
        }
        initRelationModelTableHead();
        getAndLoadFoldersMenus();
        treeEvent();
        bindTableEvent();
    }

    function initRelationModelTableHead(){
        var relationModelTableHead = [
            [
                {type: "radio"},
                {field: "businessModelName", title: "名称", sort: true},
                { field: "folderURL", title: "所属文件夹" },
                {field: "dataSourceName", title: "数据源名称", sort: true, width: 150},
                // {field: "createUserName",title: "创建者", sort: true},
                // { field: "createDate", title: "创建时间", sort: true, width: 130, templet: function(d){
                //     if(d.createDate){
                //         return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.createDate));
                //     }else{
                //         return "";
                //     }
                // }},
                // {field: "lastModifyUserName",title: "最后修改者", sort: true},
                { field: "lastModifyDate", title: "修改时间", sort: true, width: 130, templet: function(d){
                    if (d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastModifyDate));
                    }else{
                        return "";
                    }
                }}
            ]
        ];
    
        if($AppVars.serverEdition == 2){
            var sourceType = {field: "sourceType", title: "来源", sort: true, width: 100, templet: function(d){
                if(d.sourceType == 0){
                    return "本组织创建";
                }else{
                    return "从其它组织订阅";
                }
            }};
            var publishStatus = { field: "publishStatus", title: "发布状态", width: 80, sort: true, templet: function(d){
                if (d.publishStatus == -1){
                    return "-";
                } else if (d.publishStatus == 0){
                    return "未发布";
                } else if (d.publishStatus == 1){
                    return "已发布";
                }else{
                    return "停止发布";
                }
            }};
            relationModelTableHead[0].splice(5, 0, sourceType, publishStatus);
        }

        table.render({
            elem: '#relationModel',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: relationModelTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadFoldersMenus(){
        var succ = function () {
            getModelList();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取关系模型文件夹列表", errorStatus, msg);
        };
        businessModelFolders.getItemsByType(0, true, succ, fail);
    }

    function getModelList(){
        var succ = function () {
            $Utils.loading.close();
            loadMenus();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取关系模型列表", errorStatus, msg);
        };
        relationModels.getItems(2, true, succ, fail);   // 2 为moduleID  即模块ID
    }

    function loadMenus(){
        $(".relation-model-folder > ul").html("");
        var folderArr = setFolderTree();
        for (var i = 0; i < folderArr.length; i++) {
            var str = "<li class='folder folder-hide' data-folderid=" + folderArr[i].folderID + "><div title=" + folderArr[i].name + "><i class='iconfont bda-wenjianjia'></i><span>" + folderArr[i].name + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".relation-model-folder > ul").append(str);
            if (folderArr[i].children) {
                createChildrenMenu(folderArr[i].children);
            }
        }
        if(isFirst){
            isFirst = false;
            $(".relation-model-folder > ul > li:first-child > div").trigger("click");
        }else{
            clickTargetFolderEvent();
        }
    }

    function createChildrenMenu(menuArr) {
        for (var i = 0; i < menuArr.length; i++) {
            var str = "<li class='folder folder-hide' data-folderid=" + menuArr[i].folderID + "><div title=" + menuArr[i].name + "><i class='iconfont bda-wenjianjia'></i><span>" + menuArr[i].name + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".relation-model-folder > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == menuArr[i].folderParentID) {
                    $(this).children("ul").append(str);
                }
            });
            if (menuArr[i].children) {
                createChildrenMenu(menuArr[i].children);
            }
        }
    }

    function setFolderTree() {
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { name: "关系模型", folderID: "-1", folderParentID: "-1" });
        for (var i = 0; i < businessModelFolders.count; i++) {
            hashTable.add(businessModelFolders.item(i).folderID, { name: businessModelFolders.item(i).folderName, folderID: businessModelFolders.item(i).folderID, folderParentID: businessModelFolders.item(i).folderParentID });
        }
        for (var i = 0; i < businessModelFolders.count; i++) {
            var parentFolder = hashTable.getValue(businessModelFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(businessModelFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function loadRelationModelList(folderID){
        mFolderID = folderID;
        mTableBodyData = setTableBody(folderID);
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
        $Utils.loading.close();
    }

    function setTableBody(folderID){
        var relationModelsTableBody = [];
        if(folderID == "-1"){
            for (var i = 0; i < relationModels.count; i++) {
                var tempObj = {};
                for (var key in relationModels.item(i)) {
                    if (typeof relationModels.item(i)[key] === "function") { continue; }
                    tempObj[key] = relationModels.item(i)[key];
                }
                tempObj.folderURL = setFolderURL(relationModels.item(i).folderID);
                relationModelsTableBody.push(tempObj);
            }
        }else{
            var folderIDs = getFolderIDs(folderID);
            for (var i = 0; i < relationModels.count; i++) {
                if (folderIDs.indexOf(relationModels.item(i).folderID) != -1) {
                    var tempObj = {};
                    for (var key in relationModels.item(i)) {
                        if (typeof relationModels.item(i)[key] === "function") { continue; }
                        tempObj[key] = relationModels.item(i)[key];
                    }
                    tempObj.folderURL = setFolderURL(relationModels.item(i).folderID);
                    relationModelsTableBody.push(tempObj);
                }
            }
        }
        return relationModelsTableBody;
    }

    function setFolderURL(folderID) {
        var folderURL = "";
        if (folderID == "-1") {
            return "/关系模型/";
        } else {
            folderURL = businessModelFolders.item(folderID).folderName + "/";
            folderURL = setParentFolderURL(businessModelFolders.item(folderID).folderParentID, folderURL);
            return folderURL;
        }
    }

    function setParentFolderURL(folderID, folderURL) {
        if (folderID == "-1") {
            folderURL = "/关系模型/" + folderURL
            return folderURL;
        } else {
            folderURL = businessModelFolders.item(folderID).folderName + "/" + folderURL;
            folderURL = setParentFolderURL(businessModelFolders.item(folderID).folderParentID, folderURL);
            return folderURL;
        }
    }

    function getFolderIDs(folderID) {
        var tempArr = [];
        tempArr.push(folderID);
        if (folderID == "-1") {
            return tempArr;
        } else {
            for (var i = 0; i < businessModelFolders.count; i++) {
                if (businessModelFolders.item(i).folderParentID == folderID) {
                    tempArr.push(businessModelFolders.item(i).folderID);
                    return getChildrenFolderID(businessModelFolders.item(i).folderID, tempArr);
                }
            }
            return tempArr;
        }
    }

    function getChildrenFolderID(folderID, tempArr) {
        for (var i = 0; i < businessModelFolders.count; i++) {
            if (businessModelFolders.item(i).folderParentID == folderID) {
                tempArr.push(businessModelFolders.item(i).folderID);
                return getChildrenFolderID(businessModelFolders.item(i).folderID, tempArr);
            }
        }
        return tempArr;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                mLimit = obj.limit;
                loadRelationModelTableBody(data,obj);
            }
        });
    }

    function loadRelationModelTableBody(tableBodyData,obj){
        currentTableBodyData = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("relationModel",{data:currentTableBodyData,limit:currentTableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("relationModel",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("relationModel",{height: tableBodyHeight});
        });
    }

    function treeEvent() {

        $(".relation-model-folder > ul").on("click", "div", function () {
            if ($(this).siblings("ul").is(":hidden")) {
                $(this).siblings("ul").show(200);
                $(".relation-model-folder li").removeClass("click-folder");
                $(this).parent("li").addClass("click-folder");
                $(this).find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            } else {
                $(this).siblings("ul").hide(200);
                $(this).siblings("ul").find("ul").hide(200);
                $(this).find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
                $(this).siblings("ul").find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
            }
            if ($(this).parents("ul").is(":hidden")) {
                $(this).parents("ul").show(200);
                $(this).parents("ul").siblings("div").find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            }
            $(this).parent("li").siblings("li").removeClass("click-folder");
            $(this).parent("li").siblings("li").find(".click-folder").removeClass("click-folder");
            $(this).parent("li").find(".click-folder").removeClass("click-folder");
            $(this).parent("li").addClass("click-folder");
            loadRelationModelList($(this).parent("li").attr("data-folderid"));
        });
    }

    function bindTableEvent(){
        $(".button-add .iconfont").click(function () {
            if ($(this).hasClass("sanjiao-up")) {
                $(this).removeClass("sanjiao-up");
                $(".button-add .folder-children").show();
            } else {
                $(this).addClass("sanjiao-up");
                $(".button-add .folder-children").hide();
            }
        });

        $(document).click(function (e) {
            var target = $(e.target);
            if (target.closest(".children-sanjiao").length != 0) return;
            $(".button-add .iconfont").addClass("sanjiao-up");
            $(".button-add .folder-children").hide();
        });

        table.on('sort(relationModel)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if (type === 'asc') { //升序
                thisData = $Utils.sorter(data, field);
            } else if (type === 'desc') { //降序
                thisData = $Utils.sorter(data, field, true);
            } else { //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });

        $(".search-button").click(function () {
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if (searchValue == "") {
                searchData = mTableBodyData;
            } else {
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        $(".add-folder").click(function () {
            var folder = new BusinessModelFolder();
            folder.folderParentID = mFolderID;
            folder.businessModelType = 0;
            getAndLoadFoldertForm(0, folder);
        });

        $(".add-relation-model").click(function () {
            var relationModel = new RelationModel();
            relationModel.folderID = mFolderID;
            getAndLoadRelationModelForm(0, relationModel);
        });

        $(".edit-relation-model").click(function () {
            if (table.checkStatus('relationModel').data.length) {
                var relationModel = relationModels.item(table.checkStatus('relationModel').data[0].businessModelID);
                if (relationModel.sourceType == 0){
                    openClient(relationModel.businessModelID);
                } else {
                    layer.msg("订阅的模型不能编辑。", { icon: 2 });
                }
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".attribute-relation-model").click(function () {
            if (table.checkStatus('relationModel').data.length) {
                var relationModel = relationModels.item(table.checkStatus('relationModel').data[0].businessModelID);
                getAndLoadRelationModelForm(1, relationModel);
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".attribute-folder").click(function () {
            if (mFolderID != "-1") {
                var folder = businessModelFolders.item(mFolderID);
                getAndLoadFoldertForm(1, folder);
            } else {
                layer.msg("不能修改根文件夹。", { icon: 2 });
            }
        });

        $(".delete-relation-model").click(function () {
            if (table.checkStatus('relationModel').data.length) {
                judgeIncludeModelCount();
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".delete-folder").click(function () {
            if (mFolderID != "-1") {
                if (validateFolder(mFolderID)) {
                    loadDeleteFolderWindow(mFolderID);
                }
            } else {
                layer.msg("不能删除根文件夹。", { icon: 2 });
            }
        });

        $(".refresh").click(function () {
            $Utils.loading.open();
            isFirst = true;
            getAndLoadFoldersMenus();
        });

        $(".release").click(function () {
            var selectCecord = table.checkStatus('relationModel').data;
            if (selectCecord.length > 0) {
                if (selectCecord[0].sourceType == 1) {
                    layer.msg("订阅的模型不能再次发布。", { icon: 2 });
                } else {
                    var relationModel = relationModels.item(selectCecord[0].businessModelID);
                    getAndLoadPublisherForm(relationModel);
                }
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".subscribe").click(function () {
            getAndLoadSubscriptionForm();
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].businessModelName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            mTableBodyData[i].dataSourceName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            (mTableBodyData[i].description && (mTableBodyData[i].description.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadRelationModelForm(operationType,relationModel){
        $.ajax({
            url: "html/iBusinessModel/businessModel/relationModel/relationModel.html",
            type: 'GET',
            success: function(data){
                $Utils.loading.close();
                loadRelationModelForm(operationType,relationModel,data);
            }
        });
    }

    function loadRelationModelForm(operationType,relationModel,strHtml){
        layer.open({
            type: 1,
            title: [operationType?relationModel.businessModelName+" 属性":"新增关系模型","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px","570px"],
            content: strHtml,
            success: function(layero,index){
                initRelationModelForm(operationType, relationModel, businessModelFolders,index,addSubmit,editSubmit);
            }
        });
    }

    function getAndLoadFoldertForm(operationType, folder) {
        $.ajax({
            url: "html/iBusinessModel/businessModel/folder/folder.html",
            type: 'GET',
            success: function (data) {
                loadFolderForm(operationType, folder, data);
            }
        });
    }

    function loadFolderForm(operationType, folder, strHtml) {
        layer.open({
            type: 1,
            title: [operationType ? folder.folderName + " 属性" : "新增文件夹", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                initFolderFormWindow(operationType, folder, folder.folderParentID, businessModelFolders, index, addFolderSubmit, editFolderSubmit);
            }
        });
    }

    function validateFolder(folderID) {
        for (var i = 0; i < businessModelFolders.count; i++) {
            if (businessModelFolders.item(i).folderParentID == folderID) {
                layer.msg("文件夹 " + businessModelFolders.item(i).folderName + " 包含子文件夹，不能删除。", { icon: 2 });
                return false;
            }
        }

        for (var i = 0; i < relationModels.count; i++) {
            if (relationModels.item(i).folderID == folderID) {
                layer.msg("文件夹 " + businessModelFolders.item(folderID).folderName + " 包含报表，不能删除。", { icon: 2 });
                return false;
            }
        }

        return true;
    }

    function loadDeleteFolderWindow(folderID) {
        layer.open({
            type: 0,
            title: "删除文件夹",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px", "270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 " + businessModelFolders.item(folderID).folderName + " ？</div></div>",
            btn: ["是", "否"],
            yes: function (index, layero) {
                layer.close(index);
                $Utils.loading.open();
                deleteFolder(folderID);
            }
        });
    }

    function deleteFolder(folderID) {
        var succ = function () {
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。", { icon: 1 });
            $(".menu-list li").each(function () {
                if ($(this).attr("data-folderid") == folderID) {
                    $(this).parents("li").eq(0).children("div").trigger("click");
                    $(this).remove();
                }
            });
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("删除文件夹", errorStatus, msg);
        };
        businessModelFolders.deleteItem(folderID, true, succ, fail);
    }

    function openClient(businessModelID){
        // var url = $AppConstants.projectName + "/html/relationModel/index.html?businessModelID=" + businessModelID;
        // window.open(url,businessModelID);
        var url = "yzs:// /l "+$AppVars.gLogin.loginID+" /n1 1 /i1 " + businessModelID;
        $Utils.openClient(url);
    }

    function judgeIncludeModelCount(){
        var succ = function(data){
            if(data > 0){
                var str = "当前模型已有报表引用，如果删除将导致引用此模型的报表不可用，您确定要删除该模型吗？";
                deleteWindow(str,"bda-tips");
            }else{
                var str = "是否删除关系模型 "+table.checkStatus('relationModel').data[0].businessModelName+" ？";
                deleteWindow(str,"bda-xunwen"); 
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("删除关系模型",errorStatus,msg);
		};
		reports.getUsedCount(table.checkStatus('relationModel').data[0].businessModelID,true,succ,fail);
    }

    function deleteWindow(str,className){
        layer.open({
            type: 0,
            title: "删除关系模型",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont "+className+"'></i></div><div class='fr fail-content'>"+str+"</div></div>",
            btn: ["是","否"],
            success: function(layero,index){
                $(layero).find('.layui-layer-content').css('height','137px');
            },
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteRelationModel(table.checkStatus('relationModel').data[0].businessModelID);
            }
        });
    }

    function deleteRelationModel(businessModelID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
            loadRelationModelList(mFolderID);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("删除关系模型",errorStatus,msg);
        };
        relationModels.deleteItem(businessModelID,true,succ,fail);
    }

    function getAndLoadPublisherForm(selectModel){
        $.ajax({
            url: "html/publisher/publisher.html",
            type: 'GET',
            success: function (data) {
                loadPublisherForm(selectModel, data);
            }
        });
    }
    
    function loadPublisherForm(selectModel, strHtml) {
        layer.open({
            type: 1,
            title: ["发布", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                $Utils.loading.open();
                initPublisherForm(0, selectModel, index, updateSelectModel);
            }
        });
    }

    function getAndLoadSubscriptionForm(){
        $.ajax({
            url: "html/iBusinessModel/businessModel/subscription/subscription.html",
            type: 'GET',
            success: function (data) {
                loadSubscriptionForm(data);
            }
        });
    }

    function loadSubscriptionForm(strHtml){
        layer.open({
            type: 1,
            title: ["订阅", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                $Utils.loading.open();
                initSubscriptionForm(0, index, updateList);
            }
        });
    }

    var addSubmit = function(relationModel,index){
        var succ = function(data){
            $Utils.loading.close();
            layer.close(index);
            openClient(data);
            getAndLoadFoldersMenus();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("新增关系模型",errorStatus,msg);
        };
        relationModels.addItem(relationModel,true,succ,fail);
    };

    function clickTargetFolderEvent() {
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == mFolderID) {
                $(this).children("div").trigger("click");
            }
        });
    }

    var editSubmit = function(relationModel,index){
        var businessObjectFolders = relationModel.businessObjectFolders;
        var businessObjects = relationModel.businessObjects;
        relationModel.businessObjectFolders = [];
        relationModel.businessObjects = [];
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            relationModel.businessObjectFolders = businessObjectFolders;
            relationModel.businessObjects = businessObjects;
            getAndLoadEditList(relationModel);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改关系模型",errorStatus,msg);
        };
        relationModels.editSimpleProperties(relationModel,true,succ,fail);
    };

    function getAndLoadEditList(relationModel){
        var succ = function(){
            $Utils.loading.close();
            editListItem(relationModel);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+relationModel.businessModelName+" 的属性",errorStatus,msg);
        };
        relationModel.initByModelID(relationModel.businessModelID,true,succ,fail);
    }

    function editListItem(relationModel){
        var tempTableBody = $.extend(true, [], currentTableBodyData);
        var folderIDs = getFolderIDs(mFolderID);
        for(var i = currentTableBodyData.length - 1; i >= 0; i--){
            if(currentTableBodyData[i].businessModelID == relationModel.businessModelID){
                if(folderIDs.indexOf(relationModel.folderID) != -1 || mFolderID == "-1"){
                    tempTableBody[i].relationModelName = relationModel.relationModelName;
                    currentTableBodyData[i].relationModelName = relationModel.relationModelName;
                    tempTableBody[i].folderURL = setFolderURL(relationModel.folderID);
                    currentTableBodyData[i].folderURL = setFolderURL(relationModel.folderID);
                    tempTableBody[i].description = relationModel.description;
                    currentTableBodyData[i].description = relationModel.description;
                    tempTableBody[i].publishStatus = relationModel.publishStatus;
                    currentTableBodyData[i].publishStatus = relationModel.publishStatus;
                    tempTableBody[i].LAY_CHECKED = true;
                }else{
                    currentTableBodyData.splice(i, 1);
                    tempTableBody.splice(i, 1);
                }
                break;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("relationModel",{data:tempTableBody,limit:tempTableBody.length});
    }

    var addFolderSubmit = function (folder, index) {
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            loadRelationModelList(mFolderID);
            addFolderMenu(folder);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("新增文件夹", errorStatus, msg);
        };
        businessModelFolders.addItem(folder, true, succ, fail);
    };

    function addFolderMenu(folder) {
        str = "<li class='folder folder-hide' data-folderid=" + folder.folderID + "><div title=" + folder.folderName + "><i class='iconfont bda-wenjianjia'></i><span>" + folder.folderName + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>"
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == folder.folderParentID) {
                $(this).children("ul").append(str);
            }
        });
    }

    var editFolderSubmit = function (folder, index) {
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            businessModelFolders.item(folder.folderID).init(JSON.parse(JSON.stringify(folder)));
            editFolderMenu(folder);
            loadRelationModelList(folder.folderID);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改文件夹", errorStatus, msg);
        };
        businessModelFolders.editItem(folder, true, succ, fail);
    };

    function editFolderMenu(folder) {
        var str = "";
        var isEditParent = false;
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == folder.folderID) {
                if ($(this).parents("li").eq(0).attr("data-folderid") != folder.folderParentID){
                    isEditParent = true;
                }
                $(this).children("div").attr("title",folder.folderName);
                $(this).children("div").find("span").text(folder.folderName);
                if (isEditParent) {
                    str = $(this);
                    $(this).remove();
                }
                return false;
            }
        });

        if (isEditParent) {
            $(".menu-list > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == folder.folderParentID) {
                    $(this).children("ul").append(str);
                    return false;
                }
            });

            $(".menu-list > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == folder.folderID) {
                    $(this).parents("li").children("ul").show();
                    return false;
                }
            });
        }
    }

    var updateSelectModel = function (bmPublish){
        relationModels.item(bmPublish.businessModelID).publishStatus = bmPublish.publishStatus;
        editListItem(relationModels.item(bmPublish.businessModelID));
    };

    var updateList = function () {
        $Utils.loading.open();
        getAndLoadFoldersMenus();
    };

}();