/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-30 14:31:06
 * @LastEditTime: 2021-05-11 09:12:32
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form, tree = layui.tree;
    var databaseLinks = new DatabaseLinks();
    var mOperationType = null, mRelationModel = null, formAddSubmit = null, formEditSubmit = null, layerIndex = null, mFolders = null;

    window.initRelationModelForm = function (operationType, relationModel, businessModelFolders,index,addSubmit,editSubmit){
        mOperationType = operationType;
        mRelationModel = relationModel;
        layerIndex = index;
        formAddSubmit = addSubmit;
        formEditSubmit = editSubmit;
        mFolders = businessModelFolders;

        getDatabaseLinks();
        createTreeSelect();

        var createUserName = mOperationType == 0 ? $AppVars.gUser.userName : (mRelationModel.createUserName || "");
        var createDate = mOperationType == 0 ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date()) : $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(mRelationModel.createDate));
        var lastModifyUserName = mOperationType == 0 ? "" : (mRelationModel.lastModifyUserName || "");
        var lastModifyDate = mOperationType == 0 ? "" : (mRelationModel.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(mRelationModel.lastModifyDate)) : "");
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);
        
        if(mOperationType == 0){
            initAddRelationModelForm();
        }else if(mOperationType == 1){
            initEditRelationModelForm(relationModel);
        }
        $(".relation-model-window input[name=businessModelName]").focus();
        form.render('select');

        bindElementEvent();
    }

    function getDatabaseLinks(){
        var succ = function(){
            $Utils.loading.close();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取数据库连接",errorStatus,msg);
		};
		databaseLinks.getItems(2,false,succ,fail);
    }

    function createTreeSelect() {
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function (node) { //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
            },
        });
        if (mRelationModel.folderID == -1) {
            $(".relation-model-window .layui-form-select").find(".layui-select-title span").html("关系模型").end().find("input:hidden[name='folderID']").val(-1);
        } else {
            $(".relation-model-window .layui-form-select").find(".layui-select-title span").html(mFolders.item(mRelationModel.folderID).folderName).end().find("input:hidden[name='folderID']").val(mRelationModel.folderID);
        }
        $(".relation-model-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".relation-model-window .layui-form-item").eq(1).find(".layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders() {
        var index = 0;
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { title: "关系模型", id: index, folderID: "-1", folderParentID: "0", spread: true });
        index++;
        for (var i = 0; i < mFolders.count; i++) {
            hashTable.add(mFolders.item(i).folderID, { title: mFolders.item(i).folderName, id: index, folderID: mFolders.item(i).folderID, folderParentID: mFolders.item(i).folderParentID });
            index++;
        }
        for (var i = 0; i < mFolders.count; i++) {
            var parentFolder = hashTable.getValue(mFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(mFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function initAddRelationModelForm(){
        $("input[name=modelName]").attr("disabled",false);
        var databaseLink = document.getElementById("databaseLink");
        for(var i = 0; i <= databaseLinks.count; i++){
            var option = document.createElement("option");
            if (i == 0) {
                option.setAttribute("value", 0);
                option.setAttribute("selected", true);
                option.innerText = "请选择数据库连接";
            } else {
                option.setAttribute("value", databaseLinks.item(i - 1).dataSourceID);
                option.innerText = databaseLinks.item(i-1).dataSourceName;
            }
            databaseLink.appendChild(option);
        }
    }

    function initEditRelationModelForm(relationModel){
        // $("input[name=businessModelName]").attr("disabled",true);
        form.val("formWindow",{
            "businessModelName": relationModel.businessModelName,
            "description": relationModel.description,
        });

        var databaseLink = document.getElementById("databaseLink");
        for(var i = 0; i <= databaseLinks.count; i++){
            var option = document.createElement("option");
            if(i==0){
                option.setAttribute("value",0);
                option.innerText = "请选择数据库连接";
            }else{
                option.setAttribute("value",databaseLinks.item(i-1).dataSourceID);
                if(databaseLinks.item(i-1).dataSourceID == relationModel.dataSourceID){
                    option.setAttribute("selected",true);
                }
                option.innerText = databaseLinks.item(i-1).dataSourceName;
            }
            databaseLink.appendChild(option);
        }
    }

    function bindElementEvent(){
        $(".edit-test-link").on("click",function(){
            $Utils.loading.open();
            var data = form.val("formWindow");
            if(databaseLinks.item(data.dataSourceID)){
                formTestConnections(data);
            } else {
                $Utils.loading.close();
                layer.msg("数据库连接不存在。",{icon:2});
            }
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });

        form.on('submit(formSubmit)', function(data){
            if(data.field.dataSourceID === "0"){
                layer.msg("请选择数据库连接。",{icon:2});
                return false;
            }
            $Utils.loading.open();
            if(mOperationType == 1){
                if (changed(data)) {
                    var relationModel = new RelationModel();
                    relationModel.init(JSON.parse(JSON.stringify(mRelationModel)));
                    setRelationModel(data, relationModel);
                    formEditSubmit(relationModel,layerIndex);
                }else{
                    $Utils.loading.close();
                    layer.close(layerIndex); 
                }
            }else if(mOperationType == 0){
                setRelationModel(data, mRelationModel);
                formAddSubmit(mRelationModel,layerIndex);
            }
            return false;
        });
    }

    function formTestConnections(data){
        var parameters = "databaseTypeName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseTypeName)+"&databaseTypeVersion="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseTypeVersion)+"&databaseIP="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseIP)+"&databasePort="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databasePort)+
        "&userName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).userName)+"&password="+encodeURIComponent(databaseLinks.item(data.dataSourceID).password)+"&databaseName="+encodeURIComponent(databaseLinks.item(data.dataSourceID).databaseName);
        var succ = function(){
            $Utils.loading.close();
            layer.msg("连接成功！",{icon:1});
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("测试连接",errorStatus,msg);
        };
        databaseLinks.item(data.dataSourceID).testConnections(parameters,true,succ,fail);
    }

    function setRelationModel(data,relationModel){
        relationModel.businessModelType = 0;
        relationModel.businessModelName = data.field.businessModelName;
        relationModel.folderID = data.field.folderID;
        relationModel.description = data.field.description;
        relationModel.dataSourceID = data.field.dataSourceID;
        relationModel.dataSourceName = databaseLinks.item(data.field.dataSourceID)?databaseLinks.item(data.field.dataSourceID).dataSourceName:"";
        if(mOperationType == 0){
            relationModel.relationDiagramFolders = [];
            relationModel.relationDiagrams = [];
            relationModel.businessObjectFolders = [];
            relationModel.businessObjects = [];
            relationModel.queryTableRestrictions = [];
        }
    }

    function changed(data) {
        if (mRelationModel.businessModelName != data.field.businessModelName) {
            return true
        }
        if (mRelationModel.folderID != data.field.folderID) {
            return true
        }
        if(mRelationModel.description != data.field.description){
            return true
        }
        if(mRelationModel.dataSourceID != data.field.dataSourceID){
            return true
        }
        return false;
    }
    
}();