/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-04-25 16:56:33
 * @LastEditTime: 2021-04-23 16:02:51
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, form = layui.form, tree = layui.tree;
    var mFolder = null, layerIndex = null, formAddSubmit = null, formEditSubmit = null, mOperationType = null, mFolders = null, mFolderID = null;
    
    window.initFolderFormWindow = function(operationType,folder,folderID,folders,index,addSubmit,editSubmit){
        mFolder = folder;
        layerIndex = index;
        formAddSubmit = addSubmit
        formEditSubmit = editSubmit
        mOperationType = operationType;
        mFolders = folders;
        mFolderID = folderID;

        initFolderForm(operationType,folder)
    }

    function initFolderForm(operationType,folder){
        if(operationType == 1){
            form.val("formWindow",{
                "folderName": folder.folderName
            });
        }
        form.val("formWindow",{
            "folderParentID": mFolder.folderParentID
        });
        createTreeSelect();
        form.render();
        $(".folder-window input[name=folderName]").focus();

        form.on('submit(formSubmit)', function(data){
            $Utils.loading.open();
            if(mOperationType == 1){
                if(changed(data)){
                    var folder = new ReportFolder();
                    folder.init(JSON.parse(JSON.stringify(mFolder)));
                    folder.folderName = data.field.folderName;
                    folder.folderParentID = data.field.folderParentID;
                    formEditSubmit(folder,layerIndex);
                }else{
                    $Utils.loading.close();
                    layer.close(layerIndex); 
                }
            }else if(mOperationType == 0){
                mFolder.folderName = data.field.folderName;
                mFolder.folderParentID = data.field.folderParentID;
                formAddSubmit(mFolder,layerIndex);
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });
    }

    function createTreeSelect(){
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function(node){ //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderParentID']").val(node.data.folderID);
            },
        });
        var rootName = mFolder.businessModelType == 0 ? "关系模型" : (mFolder.businessModelType == 1 ? "数据表模型" : (mFolder.businessModelType == 2 ? "SQL模型" : (mFolder.businessModelType == 3 ? "Excel模型" : "存储过程模型")));
        if(mFolderID == -1){
            $(".folder-window .layui-form-select").find(".layui-select-title span").html(rootName).end().find("input:hidden[name='folderParentIDv']").val(-1);
        }else{
            $(".folder-window .layui-form-select").find(".layui-select-title span").html(mFolders.item(mFolderID).folderName).end().find("input:hidden[name='folderParentIDs']").val(mFolders.item(mFolderID).folderID);
        }
        $(".folder-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".folder-window .layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".folder-window .layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders(){
        var tempArr = [];
        var hashTable = new HashTable();
        var rootName = mFolder.businessModelType == 0 ? "关系模型" : (mFolder.businessModelType == 1 ? "数据表模型" : (mFolder.businessModelType == 2 ? "SQL模型" : (mFolder.businessModelType == 3 ? "Excel模型" : "存储过程模型")));
        hashTable.add("-1", { title: rootName,folderID:"-1",folderParentID:"-1",spread: true});
        for(var i = 0; i < mFolders.count; i++){
            hashTable.add(mFolders.item(i).folderID,{title:mFolders.item(i).folderName,folderID:mFolders.item(i).folderID,folderParentID:mFolders.item(i).folderParentID});
        }
        for(var i = 0; i < mFolders.count; i++){
            var parentFolder = hashTable.getValue(mFolders.item(i).folderParentID);
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(mFolders.item(i).folderID));
            if(mOperationType == 1 && parentFolder.folderID == mFolder.folderID){
                parentFolder.children = [];
            }
        }
        tempArr.push(hashTable.getValue("-1"));

        for (var i = 0; i < tempArr.length; i++) {
            if (tempArr[i].folderID == mFolder.folderID) {
                tempArr.splice(i, 1);
            } else if (tempArr[i].children && tempArr[i].children.length) {
                removeCurrentFolder(tempArr[i].children);
            }
        }

        return tempArr;
    }

    function removeCurrentFolder(childrenArr) {
        for (var i = 0; i < childrenArr.length; i++) {
            if (childrenArr[i].folderID == mFolder.folderID) {
                childrenArr.splice(i, 1);
            } else if (childrenArr[i].children && childrenArr[i].children.length) {
                removeCurrentFolder(childrenArr[i].children);
            }
        }
    }

    function changed(data){
        if(mFolder.folderName != data.field.folderName){
            return true;
        }
        if (mFolder.folderParentID != data.field.folderParentID){
            return true;
        }
        return false;
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }
}();