!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, laypage = layui.laypage;
    var excelModels = new ExcelModels();
    var businessModelFolders = new BusinessModelFolders();
    var reports = new Reports();
    var mLimit = 20;
    var mCurrentPage = 1;
    var mTableBodyData = null;
    var mSortBodyData = null;
    var mFolderID = "-1";
    var isFirst = true;
    var tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
    var currentTableBodyData = [];

    $Utils.loading.open();
    initMain();
    
    function initMain(){
        if ($AppVars.serverEdition != 2) {
            $(".group-function-button").remove();
        }
        initTableModelTableHead();
        getAndLoadFoldersMenus();
        treeEvent();
        bindTableEvent();
    }

    function initTableModelTableHead(){
        var excelModelTableHead = [
            [
                {type: "radio"},
                { field: "businessModelName", title: "名称", sort: true },
                { field: "folderURL", title: "所属文件夹" },
                {field: "dataSourceName", title: "数据源名称", sort: true, width: 220},
                // {field: "createUserName",title: "创建者", sort: true},
                // { field: "createDate", title: "创建时间", sort: true, width: 130, templet: function(d){
                //     if(d.createDate){
                //         return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.createDate));
                //     }else{
                //         return "";
                //     }
                // }},
                // {field: "lastModifyUserName",title: "修改者", sort: true},
                { field: "lastModifyDate", title: "修改时间", sort: true, width: 130, templet: function(d){
                    if (d.lastModifyDate){
                        return $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(d.lastModifyDate));
                    }else{
                        return "";
                    }
                }}
            ]
        ];

        if($AppVars.serverEdition == 2){
            var sourceType = {field: "sourceType", title: "来源", sort: true, width: 100, templet: function(d){
                if(d.sourceType == 0){
                    return "本组织创建";
                }else{
                    return "从其它组织订阅";
                }
            }};
            var publishStatus = { field: "publishStatus", title: "发布状态", width: 80, sort: true, templet: function(d){
                if (d.publishStatus == -1){
                    return "-";
                } else if (d.publishStatus == 0){
                    return "未发布";
                } else if (d.publishStatus == 1){
                    return "已发布";
                }else{
                    return "停止发布";
                }
            }};
            excelModelTableHead[0].splice(5, 0, sourceType, publishStatus);
        }
    
        table.render({
            elem: '#excelModel',
            height: tableBodyHeight,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: excelModelTableHead,
            toolbar: false,
            autoSort: false,
            limit: 10
        });
    }

    function getAndLoadFoldersMenus() {
        var succ = function () {
            getModelList();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取Excel模型文件夹列表", errorStatus, msg);
        };
        businessModelFolders.getItemsByType(3, true, succ, fail);
    }

    function getModelList() {
        var succ = function () {
            $Utils.loading.close();
            loadMenus();
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("获取Excel模型列表", errorStatus, msg);
        };
        excelModels.getItems(2, true, succ, fail);   // 2 为moduleID  即模块ID
    }

    function loadMenus() {
        $(".excel-model-folder > ul").html("");
        var folderArr = setFolderTree();
        for (var i = 0; i < folderArr.length; i++) {
            var str = "<li class='folder folder-hide' data-folderid=" + folderArr[i].folderID + "><div title=" + folderArr[i].name + "><i class='iconfont bda-wenjianjia'></i><span>" + folderArr[i].name + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".excel-model-folder > ul").append(str);
            if (folderArr[i].children) {
                createChildrenMenu(folderArr[i].children);
            }
        }
        if (isFirst) {
            $(".excel-model-folder > ul > li:first-child > div").trigger("click");
            isFirst = false;
        } else {
            clickTargetFolderEvent();
        }
    }

    function createChildrenMenu(menuArr) {
        for (var i = 0; i < menuArr.length; i++) {
            var str = "<li class='folder folder-hide' data-folderid=" + menuArr[i].folderID + "><div title=" + menuArr[i].name + "><i class='iconfont bda-wenjianjia'></i><span>" + menuArr[i].name + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>";
            $(".excel-model-folder > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == menuArr[i].folderParentID) {
                    $(this).children("ul").append(str);
                }
            });
            if (menuArr[i].children) {
                createChildrenMenu(menuArr[i].children);
            }
        }
    }

    function setFolderTree() {
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { name: "Excel模型", folderID: "-1", folderParentID: "-1" });
        for (var i = 0; i < businessModelFolders.count; i++) {
            hashTable.add(businessModelFolders.item(i).folderID, { name: businessModelFolders.item(i).folderName, folderID: businessModelFolders.item(i).folderID, folderParentID: businessModelFolders.item(i).folderParentID });
        }
        for (var i = 0; i < businessModelFolders.count; i++) {
            var parentFolder = hashTable.getValue(businessModelFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(businessModelFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function loadExcelModelList(folderID) {
        mFolderID = folderID;
        mTableBodyData = setTableBody(folderID);
        mSortBodyData = mTableBodyData;
        setTablePage(mTableBodyData);
        $Utils.loading.close();
    }

    function setTableBody(folderID){
        var excelModelsTableBody = [];
        if (folderID == "-1") {
            for (var i = 0; i < excelModels.count; i++) {
                var tempObj = {};
                for (var key in excelModels.item(i)) {
                    if (typeof excelModels.item(i)[key] === "function") { continue; }
                    tempObj[key] = excelModels.item(i)[key];
                }
                tempObj.folderURL = setFolderURL(excelModels.item(i).folderID);
                excelModelsTableBody.push(tempObj);
            }
        } else {
            var folderIDs = getFolderIDs(folderID);
            for (var i = 0; i < excelModels.count; i++) {
                if (folderIDs.indexOf(excelModels.item(i).folderID) != -1) {
                    var tempObj = {};
                    for (var key in excelModels.item(i)) {
                        if (typeof excelModels.item(i)[key] === "function") { continue; }
                        tempObj[key] = excelModels.item(i)[key];
                    }
                    tempObj.folderURL = setFolderURL(excelModels.item(i).folderID);
                    excelModelsTableBody.push(tempObj);
                }
            }
        }
        return excelModelsTableBody;
    }

    function setFolderURL(folderID) {
        var folderURL = "";
        if (folderID == "-1") {
            return "/Excel模型/";
        } else {
            folderURL = businessModelFolders.item(folderID).folderName + "/";
            folderURL = setParentFolderURL(businessModelFolders.item(folderID).folderParentID, folderURL);
            return folderURL;
        }
    }

    function setParentFolderURL(folderID, folderURL) {
        if (folderID == "-1") {
            folderURL = "/Excel模型/" + folderURL
            return folderURL;
        } else {
            folderURL = businessModelFolders.item(folderID).folderName + "/" + folderURL;
            folderURL = setParentFolderURL(businessModelFolders.item(folderID).folderParentID, folderURL);
            return folderURL;
        }
    }

    function getFolderIDs(folderID) {
        var tempArr = [];
        tempArr.push(folderID);
        if (folderID == "-1") {
            return tempArr;
        } else {
            for (var i = 0; i < businessModelFolders.count; i++) {
                if (businessModelFolders.item(i).folderParentID == folderID) {
                    tempArr.push(businessModelFolders.item(i).folderID);
                    return getChildrenFolderID(businessModelFolders.item(i).folderID, tempArr);
                }
            }
            return tempArr;
        }
    }

    function getChildrenFolderID(folderID, tempArr) {
        for (var i = 0; i < businessModelFolders.count; i++) {
            if (businessModelFolders.item(i).folderParentID == folderID) {
                tempArr.push(businessModelFolders.item(i).folderID);
                return getChildrenFolderID(businessModelFolders.item(i).folderID, tempArr);
            }
        }
        return tempArr;
    }

    function setTablePage(data){
        laypage.render({
            elem: "pageBox",
            count: data.length,
            limit: mLimit,
            limits: [10, 20, 30, 40, 50],
            curr: mCurrentPage,
            layout: ["prev", "page", "next", "limit"],
            jump: function(obj, first){
                $(".count-page").html("显示 "+(obj.curr*obj.limit - obj.limit + 1)+" 到 "+((obj.curr*obj.limit)>data.length?data.length:(obj.curr*obj.limit))+" ，共 "+data.length+" 条记录");
                mLimit = obj.limit;
                loadExcelModelTableBody(data,obj);
            }
        });
    }

    function loadExcelModelTableBody(tableBodyData,obj){
        currentTableBodyData = tableBodyData.concat().splice(obj.curr*obj.limit - obj.limit, obj.limit);
        table.reload("excelModel",{data:currentTableBodyData,limit:currentTableBodyData.length});

        $(window).resize(function(){
            $AppVars.visibleAreaHeight = $(window).height();
            tableBodyHeight = $AppVars.visibleAreaHeight - $(".BDA-header").height() - 175 - $(".header-box").outerHeight();
            table.reload("excelModel",{height: tableBodyHeight});
        });
        
        $(".right-main").resize(function(){
            table.reload("excelModel",{height: tableBodyHeight});
        });
    }

    function treeEvent() {

        $(".excel-model-folder > ul").on("click", "div", function () {
            if ($(this).siblings("ul").is(":hidden")) {
                $(this).siblings("ul").show(200);
                $(".excel-model-folder li").removeClass("click-folder");
                $(this).parent("li").addClass("click-folder");
                $(this).find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            } else {
                $(this).siblings("ul").hide(200);
                $(this).siblings("ul").find("ul").hide(200);
                $(this).find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
                $(this).siblings("ul").find(".bda-xiangxia").removeClass("bda-xiangxia").addClass("bda-xiangyou");
            }
            if ($(this).parents("ul").is(":hidden")) {
                $(this).parents("ul").show(200);
                $(this).parents("ul").siblings("div").find(".bda-xiangyou").removeClass("bda-xiangyou").addClass("bda-xiangxia");
            }
            $(this).parent("li").siblings("li").removeClass("click-folder");
            $(this).parent("li").siblings("li").find(".click-folder").removeClass("click-folder");
            $(this).parent("li").find(".click-folder").removeClass("click-folder");
            $(this).parent("li").addClass("click-folder");

            loadExcelModelList($(this).parent("li").attr("data-folderid"));
        });
    }

    function bindTableEvent(){
        $(".button-add .iconfont").click(function () {
            if ($(this).hasClass("sanjiao-up")) {
                $(this).removeClass("sanjiao-up");
                $(".button-add .folder-children").show();
            } else {
                $(this).addClass("sanjiao-up");
                $(".button-add .folder-children").hide();
            }
        });

        $(document).click(function (e) {
            var target = $(e.target);
            if (target.closest(".children-sanjiao").length != 0) return;
            $(".button-add .iconfont").addClass("sanjiao-up");
            $(".button-add .folder-children").hide();
        });

        table.on('sort(excelModel)', function (obj) {
            var type = obj.type,
                field = obj.field,
                data = mSortBodyData,//表格的配置Data
                thisData = [];
            if (type === 'asc') { //升序
                thisData = $Utils.sorter(data, field);
            } else if (type === 'desc') { //降序
                thisData = $Utils.sorter(data, field, true);
            } else { //清除排序
                thisData = data;
            }
            setTablePage(thisData);
        });

        $(".search-button").click(function () {
            var searchValue = $(".search input[name=searchContent]").val();
            var searchData = [];
            if (searchValue == "") {
                searchData = mTableBodyData;
            } else {
                searchData = setSearchData(searchValue);
            }
            mSortBodyData = searchData;
            setTablePage(searchData);
        });

        $(".search input[name=searchContent]").keypress(function (e) {
            if (e.which == 13) {
                $(".search-button").click();
            }
        });

        $(".add-folder").click(function () {
            var folder = new BusinessModelFolder();
            folder.folderParentID = mFolderID;
            folder.businessModelType = 3;
            getAndLoadFoldertForm(0, folder);
        });

        $(".add-excel-model").click(function () {
            getAndLoadAddTableModelForm();
        });

        $(".edit-excel-model").click(function () {
            if (table.checkStatus('excelModel').data.length) {
                $Utils.loading.open();
                var excelModel = excelModels.item(table.checkStatus('excelModel').data[0].businessModelID);
                getAndLoadEditTableModelForm(excelModel);
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".attribute-folder").click(function () {
            if (mFolderID != "-1") {
                var folder = businessModelFolders.item(mFolderID);
                getAndLoadFoldertForm(1, folder);
            } else {
                layer.msg("不能修改根文件夹。", { icon: 2 });
            }
        });

        $(".delete-excel-model").click(function () {
            if (table.checkStatus('excelModel').data.length) {
                judgeIncludeModelCount();
            } else {
                layer.msg("请选择一条记录。", { icon: 2 });
            }
        });

        $(".delete-folder").click(function () {
            if (mFolderID != "-1") {
                if (validateFolder(mFolderID)) {
                    loadDeleteFolderWindow(mFolderID);
                }
            } else {
                layer.msg("不能删除根文件夹。", { icon: 2 });
            }
        });

        $(".refresh").click(function () {
            $Utils.loading.open();
            isFirst = true;
            getAndLoadFoldersMenus();
        });

        $(".release").click(function () {
            var selectCecord = table.checkStatus('excelModel').data[0];
            if (selectCecord.sourceType == 1) {
                layer.msg("订阅的模型不能再次发布。", { icon: 2 });
            } else {
                var excelModel = excelModels.item(selectCecord.businessModelID);
                getAndLoadPublisherForm(excelModel);
            }
        });

        $(".subscribe").click(function () {
            getAndLoadSubscriptionForm();
        });
    }

    function setSearchData(searchValue){
        var tempArr = [];
        for(var i = 0; i < mTableBodyData.length; i++){
            if(mTableBodyData[i].businessModelName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1 ||
            (mTableBodyData[i].dataSourceName && (mTableBodyData[i].dataSourceName.toLowerCase().indexOf(searchValue.toLowerCase()) != -1)) ||
            (mTableBodyData[i].description && (mTableBodyData[i].description.toLowerCase().indexOf(searchValue.toLowerCase()) != -1))){
                tempArr.push(mTableBodyData[i]);
            }
        }
        return tempArr;
    }

    function getAndLoadAddTableModelForm(){
        $.ajax({
            url: "html/iBusinessModel/businessModel/excelModel/addExcelModel.html",
            type: 'GET',
            success: function(data){
                loadAddExcelModelForm(data);
            }
        });
    }

    function loadAddExcelModelForm(strHtml){
        layer.open({
            type: 1,
            title: ["数据表模型创建向导","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["800px","600px"],
            content: strHtml,
            success: function(layero,index){
                initAddExcelModelForm(businessModelFolders, mFolderID, index,addSubmit);
            }
        });
    }

    function getAndLoadFoldertForm(operationType, folder) {
        $.ajax({
            url: "html/iBusinessModel/businessModel/folder/folder.html",
            type: 'GET',
            success: function (data) {
                loadFolderForm(operationType, folder, data);
            }
        });
    }

    function loadFolderForm(operationType, folder, strHtml) {
        layer.open({
            type: 1,
            title: [operationType ? folder.folderName + " 属性" : "新增文件夹", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                initFolderFormWindow(operationType, folder, folder.folderParentID, businessModelFolders, index, addFolderSubmit, editFolderSubmit);
            }
        });
    }

    function validateFolder(folderID) {
        for (var i = 0; i < businessModelFolders.count; i++) {
            if (businessModelFolders.item(i).folderParentID == folderID) {
                layer.msg("文件夹 " + businessModelFolders.item(i).folderName + " 包含子文件夹，不能删除。", { icon: 2 });
                return false;
            }
        }

        for (var i = 0; i < excelModels.count; i++) {
            if (excelModels.item(i).folderID == folderID) {
                layer.msg("文件夹 " + businessModelFolders.item(folderID).folderName + " 包含报表，不能删除。", { icon: 2 });
                return false;
            }
        }

        return true;
    }

    function loadDeleteFolderWindow(folderID) {
        layer.open({
            type: 0,
            title: "删除文件夹",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px", "270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont bda-xunwen'></i></div><div class='fr fail-content'>是否删除 " + businessModelFolders.item(folderID).folderName + " ？</div></div>",
            btn: ["是", "否"],
            yes: function (index, layero) {
                layer.close(index);
                $Utils.loading.open();
                deleteFolder(folderID);
            }
        });
    }

    function deleteFolder(folderID) {
        var succ = function () {
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。", { icon: 1 });
            $(".menu-list li").each(function () {
                if ($(this).attr("data-folderid") == folderID) {
                    $(this).parents("li").eq(0).children("div").trigger("click");
                    $(this).remove();
                }
            });
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("删除文件夹", errorStatus, msg);
        };
        businessModelFolders.deleteItem(folderID, true, succ, fail);
    }

    function getAndLoadEditTableModelForm(excelModel){
        $.ajax({
            url: "html/iBusinessModel/businessModel/excelModel/editExcelModel.html",
            type: 'GET',
            success: function(data){
                loadEditExcelModelForm(data,excelModel);
            }
        });
    }

    function loadEditExcelModelForm(strHtml,excelModel){
        layer.open({
            type: 1,
            title: [excelModel.businessModelName + " 属性","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["800px","600px"],
            content: strHtml,
            success: function(layero,index){
                initEditExcelModel(index, excelModel, businessModelFolders,editSubmit);
            }
        });
    }

    function judgeIncludeModelCount(){
        var succ = function(data){
            if(data > 0){
                var str = "当前模型已有报表引用，如果删除将导致引用此模型的报表不可用，您确定要删除该模型吗？";
                deleteWindow(str,"bda-tips");
            }else{
                var str = "是否删除Excel模型 "+table.checkStatus('excelModel').data[0].businessModelName+" ？";
                deleteWindow(str,"bda-xunwen"); 
            }
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("删除Excel模型",errorStatus,msg);
		};
		reports.getUsedCount(table.checkStatus('excelModel').data[0].businessModelID,true,succ,fail);
    }

    function deleteWindow(str,className){
        layer.open({
            type: 0,
            title: "删除Excel模型",
            closeBtn: 1,
            shadeClose: true,
            resize: false,
            area: ["480px","270px"],
            skin: "delete-window",
            content: "<div class='fail-box enquire-box clearfix'><div class='fl fail-icon enquire-icon'><i class='iconfont "+className+"'></i></div><div class='fr fail-content'>"+str+"</div></div>",
            btn: ["是","否"],
            success: function(layero,index){
                $(layero).find('.layui-layer-content').css('height','137px');
            },
            yes: function(index,layero){
                layer.close(index);
                $Utils.loading.open();
                deleteTableModel(table.checkStatus('excelModel').data[0].businessModelID);
            }
        });
    }

    function deleteTableModel(businessModelID){
        var succ = function(){
            $Utils.loading.close();
            layer.msg("删除成功，列表已重新加载。",{icon:1});
            loadExcelModelList(mFolderID);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("删除Excel模型",errorStatus,msg);
        };
        excelModels.deleteItem(businessModelID,2,true,succ,fail);
    }

    function getAndLoadPublisherForm(selectModel) {
        $.ajax({
            url: "html/publisher/publisher.html",
            type: 'GET',
            success: function (data) {
                loadPublisherForm(selectModel, data);
            }
        });
    }

    function loadPublisherForm(selectModel, strHtml) {
        layer.open({
            type: 1,
            title: ["发布", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                $Utils.loading.open();
                initPublisherForm(0, selectModel, index, updateSelectModel);
            }
        });
    }

    function getAndLoadSubscriptionForm() {
        $.ajax({
            url: "html/iBusinessModel/businessModel/subscription/subscription.html",
            type: 'GET',
            success: function (data) {
                loadSubscriptionForm(data);
            }
        });
    }

    function loadSubscriptionForm(strHtml) {
        layer.open({
            type: 1,
            title: ["订阅", "font-size: 14px"],
            btn: false,
            resize: false,
            area: ["760px", "570px"],
            content: strHtml,
            success: function (layero, index) {
                $Utils.loading.open();
                initSubscriptionForm(3, index, updateList);
            }
        });
    }

    var addSubmit = function(excelModel,index){
        var succ = function(){
            $Utils.loading.close();
            layer.close(index);
            getAndLoadFoldersMenus();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("新增Excel模型",errorStatus,msg);
        };
        excelModels.addItem(excelModel,true,succ,fail);
    };

    function clickTargetFolderEvent() {
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == mFolderID) {
                $(this).children("div").trigger("click");
            }
        });
    }

    var editSubmit = function(excelModel,index){
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            editListItem(excelModels.item(excelModel.businessModelID));
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改Excel模型",errorStatus,msg);
        };
        
        excelModels.editItem(excelModel,true,succ,fail);
    };

    function editListItem(excelModel){
        var tempTableBody = $.extend(true,[],currentTableBodyData);
        var folderIDs = getFolderIDs(mFolderID);

        for (var i = currentTableBodyData.length - 1; i >= 0; i--) {
            if (currentTableBodyData[i].businessModelID == excelModel.businessModelID) {
                if (folderIDs.indexOf(excelModel.folderID) != -1 || mFolderID == "-1") {
                    tempTableBody[i].businessModelName = excelModel.businessModelName;
                    currentTableBodyData[i].businessModelName = excelModel.businessModelName;
                    tempTableBody[i].dataSourceName = excelModel.dataSourceName;
                    currentTableBodyData[i].dataSourceName = excelModel.dataSourceName;
                    tempTableBody[i].folderURL = setFolderURL(excelModel.folderID);
                    currentTableBodyData[i].folderURL = setFolderURL(excelModel.folderID);
                    tempTableBody[i].description = excelModel.description;
                    currentTableBodyData[i].description = excelModel.description;
                    tempTableBody[i].LAY_CHECKED = true;
                } else {
                    currentTableBodyData.splice(i, 1);
                    tempTableBody.splice(i, 1);
                }
                break;
            }
        }
        mSortBodyData = currentTableBodyData;
        table.reload("excelModel",{data:tempTableBody,limit:tempTableBody.length});
    }
    
    var addFolderSubmit = function (folder, index) {
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            loadExcelModelList(mFolderID);
            addFolderMenu(folder);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("新增文件夹", errorStatus, msg);
        };
        businessModelFolders.addItem(folder, true, succ, fail);
    };

    function addFolderMenu(folder) {
        str = "<li class='folder folder-hide' data-folderid=" + folder.folderID + "><div title=" + folder.folderName + "><i class='iconfont bda-wenjianjia'></i><span>" + folder.folderName + "</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul></ul></li>"
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == folder.folderParentID) {
                $(this).children("ul").append(str);
            }
        });
    }

    var editFolderSubmit = function (folder, index) {
        var succ = function () {
            $Utils.loading.close();
            layer.close(index);
            businessModelFolders.item(folder.folderID).init(JSON.parse(JSON.stringify(folder)));
            editFolderMenu(folder);
            loadExcelModelList(folder.folderID);
        };
        var fail = function (errorStatus, msg) {
            $Utils.loading.close();
            $Utils.openWindow.failWindow("修改文件夹", errorStatus, msg);
        };
        businessModelFolders.editItem(folder, true, succ, fail);
    };

    function editFolderMenu(folder) {
        var str = "";
        var isEditParent = false;
        $(".menu-list > ul").find("li").each(function () {
            if ($(this).attr("data-folderid") == folder.folderID) {
                if ($(this).parents("li").eq(0).attr("data-folderid") != folder.folderParentID) {
                    isEditParent = true;
                }
                $(this).children("div").attr("title", folder.folderName);
                $(this).children("div").find("span").text(folder.folderName);
                if (isEditParent) {
                    str = $(this);
                    $(this).remove();
                }
                return false;
            }
        });

        if (isEditParent) {
            $(".menu-list > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == folder.folderParentID) {
                    $(this).children("ul").append(str);
                    return false;
                }
            });

            $(".menu-list > ul").find("li").each(function () {
                if ($(this).attr("data-folderid") == folder.folderID) {
                    $(this).parents("li").children("ul").show();
                    return false;
                }
            });
        }
    }

    var updateSelectModel = function (bmPublish) {
        excelModels.item(bmPublish.businessModelID).publishStatus = bmPublish.publishStatus;
        editListItem(excelModels.item(bmPublish.businessModelID));
    };

    var updateList = function () {
        $Utils.loading.open();
        getAndLoadFoldersMenus();
    };

}();