/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-31 15:38:41
 * @LastEditTime: 2021-05-11 09:11:54
 * @LastModifyUser: 
 * @Remark: 
 */
!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, form = layui.form, element = layui.element, tree = layui.tree;
    var formEditSubmit = null;
    var layerIndex = null;
    var mExcelModel = null;
    var mFolders = null;
    var fieldDetailsList = [];
    var excelFile = new ExcelFile();

    var dataType = [
        {"id": 0, "name": "字符串"},
        {"id": 1, "name": "日期"},
        {"id": 2, "name": "数字"},
        {"id": 3, "name": "图像URL"},
        {"id": 4, "name": "图像二进制"},
    ];
    var objectType = [
        {"id": 0, "name": "维度"},
        {"id": 1, "name": "度量"}
    ];
    var aggregation = [
        {"id": 0, "name": "无"},
        {"id": 1, "name": "总和"},
        {"id": 2, "name": "平均"},
        {"id": 3, "name": "计数"},
        {"id": 4, "name": "最大值"},
        {"id": 5, "name": "最小值"}
    ];
    var sort = [
        {"id": 0, "name": "无排序"},
        {"id": 1, "name": "升序"},
        {"id": 2, "name": "降序"},
    ];
    
    window.initEditExcelModel = function (index, excelModel, businessModelFolders,editSubmit){
        layerIndex = index;
        mExcelModel = excelModel;
        formEditSubmit = editSubmit;
        mFolders = businessModelFolders;

        getBusinessObjects(excelModel);
        getExcelFiles(excelModel);
        createTreeSelect();
        initEditSqlModelForm(excelModel);
        $Utils.windowLoading.close();
    }

    function getBusinessObjects(excelModel){
        var succ = function(){};
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+excelModel.businessModelName+" 业务对象",errorStatus,msg);
        };
		mExcelModel.initByModelID(excelModel.businessModelID,false,succ,fail);
    }

    function getExcelFiles(excelModel){
        var succ = function(){
            $Utils.loading.close();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取 "+excelModel.businessModelName+" 数据源",errorStatus,msg);
		};
		excelFile.getItemByDataSourceID(excelModel.dataSourceID,false,succ,fail);
    }

    function createTreeSelect() {
        var treeData = transformFolders();
        tree.render({
            elem: '#classtree',
            data: treeData,
            onlyIconControl: true,
            click: function (node) { //点击节点回调
                var $select = $($(this)[0].elem).parents(".layui-form-select");
                $select.removeClass("layui-form-selected").find(".layui-select-title span").html(node.data.title).end().find("input:hidden[name='folderID']").val(node.data.folderID);
            },
        });
        if (mExcelModel.folderID == -1) {
            $(".model-window .layui-form-select").find(".layui-select-title span").html("Excel模型").end().find("input:hidden[name='folderID']").val(-1);
        } else {
            $(".model-window .layui-form-select").find(".layui-select-title span").html(mFolders.item(mExcelModel.folderID).folderName).end().find("input:hidden[name='folderID']").val(mExcelModel.folderID);
        }
        $(".model-window .downpanel").off("click").on("click", ".layui-select-title", function (e) {
            $(".layui-form-select").not($(this).parents(".layui-form-select")).removeClass("layui-form-selected");
            $(this).parents(".downpanel").toggleClass("layui-form-selected");
            layui.stope(e);
        }).on("click", "dl i", function (e) {
            layui.stope(e);
        });
        $(document).on("click", function (e) {
            $(".model-window .parent-folder .layui-form-select").removeClass("layui-form-selected");
        });
    }

    function transformFolders() {
        var index = 0;
        var tempArr = [];
        var hashTable = new $Utils.HashTable();
        hashTable.add("-1", { title: "Excel模型", id: index, folderID: "-1", folderParentID: "0", spread: true });
        index++;
        for (var i = 0; i < mFolders.count; i++) {
            hashTable.add(mFolders.item(i).folderID, { title: mFolders.item(i).folderName, id: index, folderID: mFolders.item(i).folderID, folderParentID: mFolders.item(i).folderParentID });
            index++;
        }
        for (var i = 0; i < mFolders.count; i++) {
            var parentFolder = hashTable.getValue(mFolders.item(i).folderParentID);
            if (!parentFolder.children) {
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(mFolders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function initEditSqlModelForm(excelModel){
        form.val("editExcelModel",{
            "businessModelName": excelModel.businessModelName,
            "description": excelModel.description,
            "excelFileName": excelFile.excelFileName,
            "sheetName": excelFile.sheetName
        });
        $(".edit-excel-model input[name=businessModelName]").focus();

        var createUserName = excelModel.createUserName || "";
        var createDate = excelModel.createDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(excelModel.createDate)) : "";
        var lastModifyUserName = excelModel.lastModifyUserName || "";
        var lastModifyDate = excelModel.lastModifyDate ? $Utils.formatString.date("YYYY-MM-dd HH:mm:ss", new Date(excelModel.lastModifyDate)) : "";
        $(".bottom-item .createUserName").text(createUserName);
        $(".bottom-item .createDate").text(createDate);
        $(".bottom-item .lastModifyUserName").text(lastModifyUserName);
        $(".bottom-item .lastModifyDate").text(lastModifyDate);

        element.on('tab(modelTab)', function (data) {
            if(excelModel.sourceType == 1){
                if (data.index == 1 || data.index == 2){
                    layer.msg("订阅的模型不能编辑该栏目。", {icon: 2});
                    element.tabChange("modelTab", 0);
                }
                    
            }
        });

        loadFieldDetailsList(excelModel);

        form.render('select');
        initFieldDetailsListTableEvent();

        form.on("submit(editModelSubmit)",function(obj){
            if(change(obj)){
                if(businessObjectTypeAndDataType()){
                    layer.msg("度量的数据类型必须为数字。",{icon: 2});
                    return false;
                }else{
                    var editExcelModel = setEditSaveSqlModel(obj);
                    formEditSubmit(editExcelModel,layerIndex);
                }
            }else{
                layer.close(layerIndex);
            }
            return false;
        });

        $(".layui-btn-cancel").click(function(){
            layer.close(layerIndex);
        });
    }

    function loadFieldDetailsList(excelModel){
        var tableHead = [
            [
                {field: "columnName", title: "列名"},
                {field: "businessObjectName", title: "业务对象名称", edit: "text"},
                {field: "dataType", title: "数据类型", templet: "#selectDataType"},
                {field: "businessObjectType", title: "对象类型", templet: "#selectObjectType"},
                {field: "aggregateFunction", title: "聚合", templet: "#selectAggregation"},
                {field: "valueOrder", title: "排序", templet: "#selectSort"},
                {field: "formatString", title: "数值格式", event: "setDataFormat"}
            ]
        ];
        var tableBody = [];
        for(var i = 0; i < excelModel.businessObjects.count; i++){
            var obj = {};
            obj.columnName = excelModel.businessObjects.item(i).columnName;
            obj.businessObjectName = excelModel.businessObjects.item(i).businessObjectName;
            obj.dataType = excelModel.businessObjects.item(i).dataType;
            obj.businessObjectType = excelModel.businessObjects.item(i).businessObjectType;
            obj.aggregateFunction = setAggregateFunction(excelModel.businessObjects.item(i));
            obj.valueOrder = excelModel.businessObjects.item(i).valueOrder?(excelModel.businessObjects.item(i).valueOrder.indexOf("ASC") != -1 ? 1: 2):0;
            obj.formatString = excelModel.businessObjects.item(i).formatString;
            obj.businessObjectID = excelModel.businessObjects.item(i).businessObjectID;
            obj.businessObjectFolderID = excelModel.businessObjects.item(i).businessObjectFolderID;
            obj.aggregateAware = excelModel.businessObjects.item(i).aggregateAware;
            obj.expressionText = excelModel.businessObjects.item(i).expressionText;
            obj.expressionList = excelModel.businessObjects.item(i).expressionList;
            obj.tableNamesList = excelModel.businessObjects.item(i).tableNamesList;
            obj.sortIndex = excelModel.businessObjects.item(i).sortIndex;
            obj.visibility = excelModel.businessObjects.item(i).visibility;
            tableBody.push(obj);
        }
        fieldDetailsList = tableBody;
        table.render({
            elem: '#fieldDetailsList',
            height: 420,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            cols: tableHead,
            data: tableBody,
            toolbar: false,
            limit: tableBody.length,
            done: function (res, curr, count) {
                initTableSelectEvent();
            }
        });
    }

    function setAggregateFunction(businessObject){
        if(!businessObject.aggregateFunction){
            return 0;
        }else{
            if(businessObject.expressionText.indexOf("sum(") != -1){
                return 1;
            }
            if(businessObject.expressionText.indexOf("avg(") != -1){
                return 2;
            }
            if(businessObject.expressionText.indexOf("count(") != -1){
                return 3;
            }
            if(businessObject.expressionText.indexOf("max(") != -1){
                return 4;
            }
            if(businessObject.expressionText.indexOf("min(") != -1){
                return 5;
            }
        }
    }

    function initTableSelectEvent(){
        $("select[name='dataType']").html(createOptions(dataType));
        layui.each($("select[name='dataType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='businessObjectType']").html(createOptions(objectType));
        layui.each($("select[name='businessObjectType']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='aggregateFunction']").html(createOptions(aggregation));
        layui.each($("select[name='aggregateFunction']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        $("select[name='valueOrder']").html(createOptions(sort));
        layui.each($("select[name='valueOrder']"), function (index, item) {
            var elem = $(item);
            elem.val(elem.data('value'));
        });

        form.render('select');
    }

    function createOptions(dataList){
        var str = "";
        for(var i = 0; i < dataList.length; i++){
            str += "<option value="+dataList[i].id+">"+dataList[i].name+"</option>";
        }
        return str;
    }

    function initFieldDetailsListTableEvent(){
        form.on('select(dataType)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(objectType)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(aggregation)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        form.on('select(sort)', function(obj){
            var elem = $(obj.elem);
            var trElem = elem.parents('tr');
            // 更新到表格的缓存数据中，才能在获得选中行等等其他的方法中得到更新之后的值
            fieldDetailsList[trElem.data('index')][elem.attr('name')] = obj.value;
            form.render('select');
        });
        table.on("tool(fieldDetailsList)",function(obj){
            if(obj.event == "setDataFormat"){
                getAndLoadDataFormatHtml(obj);
            }
        });
    }

    function getAndLoadDataFormatHtml(obj){
        $.ajax({
            url: "html/dataFormat/dataFormat.html",
            type: 'GET',
            success: function(data){
                loadDataFormatHtml(obj,data);
            }
        });
    }

    function loadDataFormatHtml(obj,strHtml){
        layer.open({
            type: 1,
            title: ["数值格式","font-size: 14px"],
            btn: false,
            resize: false,
            area: ["700px","525px"],
            content: strHtml,
            success: function(layero,index){
                initDataFormat(obj,index,setDataFormatToTableCell);
            }
        });
    }

    var setDataFormatToTableCell = function(obj,dataFormatStr,index){
        obj.update({
            "formatString": dataFormatStr || ""
        });
        layer.close(index);
    };

    function change(obj) {
        if (obj.field.businessModelName != mExcelModel.businessModelName) {
            return true;
        }
        if (obj.field.description != mExcelModel.description) {
            return true;
        }
        if (obj.field.folderID != mExcelModel.folderID) {
            return true;
        }
        if(businessObjectChange()){
            return true;
        }
        return false;
    }

    function businessObjectChange(){
        var compareArr = transformationFieldDetailsList();
        for(var i = 0; i < compareArr.length; i++){
            for(var key in mExcelModel.businessObjects.item(compareArr[i].businessObjectID)){
                if(typeof mExcelModel.businessObjects.item(compareArr[i].businessObjectID)[key] === "function"){ continue;}
                if(JSON.stringify(compareArr[i][key]) != JSON.stringify(mExcelModel.businessObjects.item(compareArr[i].businessObjectID)[key])){
                    return true;
                }
            }
        }
        return false;
    }

    function transformationFieldDetailsList(){
        var compareArr = $.extend(true,[],fieldDetailsList);
        for(var i = 0; i < compareArr.length; i++){
            compareArr[i].expressionText = aggregateStr(compareArr[i].columnName,compareArr[i].aggregateFunction);
            compareArr[i].expressionList = [compareArr[i].expressionText];
            
            compareArr[i].aggregateFunction = compareArr[i].aggregateFunction == 0?false:true;
            compareArr[i].valueOrder = compareArr[i].valueOrder==0?"":(compareArr[i].valueOrder==1?"ASC":"DESC");
        }
        return compareArr;
    }

    function aggregateStr(columnName,aggregationID){
        if(aggregationID == 0){
            return "\""+columnName+"\"";
        }
        if(aggregationID == 1){
            return "sum(\""+columnName+"\")";
        }
        if(aggregationID == 2){
            return "avg(\""+columnName+"\")";
        }
        if(aggregationID == 3){
            return "count(\""+columnName+"\")";
        }
        if(aggregationID == 4){
            return "max(\""+columnName+"\")";
        }
        if(aggregationID == 5){
            return "min(\""+columnName+"\")";
        }
    }

    function setEditSaveSqlModel(obj){
        var excelModelObj = {};
        excelModelObj.businessModelID = mExcelModel.businessModelID;
        excelModelObj.businessModelType = mExcelModel.businessModelType;
        excelModelObj.excelFileName = mExcelModel.excelFileName;
        excelModelObj.businessModelName = obj.field.businessModelName;
        excelModelObj.folderID = obj.field.folderID;
        excelModelObj.description = obj.field.description;
        excelModelObj.businessObjects = saveBusinessObject(mExcelModel.tableName);
        return excelModelObj;
    }

    function businessObjectTypeAndDataType(){
        var compareArr = transformationFieldDetailsList();
        for(var i = 0; i < compareArr.length; i++){
            if(compareArr[i].businessObjectType == 1 && compareArr[i].dataType != 2){
                return true;
            }
        }
        return false;
    }

    function saveBusinessObject(tableName){
        var businessObjectsArr = [];
        for(var i = 0; i < fieldDetailsList.length; i++){
            var businessObject = new BusinessObject();
            businessObject.businessObjectID = fieldDetailsList[i].businessObjectID;
            businessObject.businessObjectName = fieldDetailsList[i].businessObjectName;
            businessObject.businessObjectType = fieldDetailsList[i].businessObjectType;
            businessObject.businessObjectFolderID = "-1";
            businessObject.dataType = fieldDetailsList[i].dataType;
            businessObject.aggregateFunction = fieldDetailsList[i].aggregateFunction == 0?false:true;
            businessObject.aggregateAware = false;
            //ASC升序   DESC降序
            businessObject.valueOrder = fieldDetailsList[i].valueOrder==0?"":(fieldDetailsList[i].valueOrder==1?"ASC":"DESC");
            businessObject.formatString = fieldDetailsList[i].formatString;
            businessObject.columnName = fieldDetailsList[i].columnName;
            //表名.列名
            businessObject.expressionText = aggregateStr(fieldDetailsList[i].columnName,fieldDetailsList[i].aggregateFunction);
            businessObject.expressionList = [businessObject.expressionText];
            businessObject.tableNamesList = [];
            businessObject.sortIndex = i;
            businessObjectsArr.push(businessObject);
        }
        return businessObjectsArr;
    }
    
}();