/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-05-19 09:04:46
 * @LastEditTime: 2020-09-03 10:52:03
 * @LastModifyUser: 
 * @Remark: 
 */ 
layui.use(["jquery","form"],function(){
    var $ = layui.jquery, form = layui.form;
    var hardwareMessage = new HardwareMessage();

    $Utils.loading.close();

    form.val("download",{
        "domain": location.protocol+"//" + location.hostname,
        "port": location.port
    });

    form.on("submit(createHardwareInfo)",function(obj){
        $Utils.loading.open();
        var url = obj.field.domain+(obj.field.port?(":"+obj.field.port):"");
        var succ = function(macAddress,cpuSerial){
            $Utils.loading.close();
            $(".cpu,.mac").show();
            $(".cpu .layui-input-block").text(cpuSerial);
            $(".mac .layui-input-block").text(macAddress);
        };
        var fail = function(failTitle,errorStatus,msg){
            $Utils.loading.close();
            $Utils.openWindow.failWindow(failTitle,errorStatus,msg);
        };
        hardwareMessage.getCPUSerial(url,true,succ,fail);
        return false;
    });
});

function HardwareMessage(){
    var me = this;
    this.getCPUSerial = function(strUrl,asyncOrSync,succ,fail){
        var url = strUrl + "/bdasystem/cpuSerial";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.getMACAddress(strUrl,asyncOrSync,succ,fail,data.property);
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("获取cpu信息","网络连接不可用。");
            }else if(textStatus == "timeout"){
                $Utils.openWindow.failWindow("获取cpu信息","请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail("获取cpu信息",XHR.status,XHR.responseText);
                }else{
                    fail("获取cpu信息",XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("获取cpu信息","未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getMACAddress = function(strUrl,asyncOrSync,succ,fail,cpuSerial){
        var url = strUrl + "/bdasystem/macAddress";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.property,cpuSerial);
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("获取mac信息","网络连接不可用。");
            }else if(textStatus == "timeout"){
                $Utils.openWindow.failWindow("获取mac信息","请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail("获取mac信息",XHR.status,XHR.responseText);
                }else{
                    fail("获取mac信息",XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("获取mac信息","未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}