/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-05-19 14:48:17
 * @LastEditTime: 2020-05-19 14:48:18
 * @LastModifyUser: 
 * @Remark: 
 */ 
layui.use(["jquery","layer"],function(){
    var $ = layui.jquery,layer = layui.layer;

    var $AppVars = {
        token: "",
        queryTimeOut: 3,
    };
    
    var $Utils = {
        request: {},
        loading: {},
        openWindow:{}
    };

    $.extend($Utils.request,{
        getRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'get',
                url: url ,
                dataType: dataType,
                timeout: 63000 * $AppVars.queryTimeOut,
                traditional: true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        isJson: function(str){
            if (typeof str == 'string') {
                try {
                    var obj=JSON.parse(str);
                    if(typeof obj == 'object' && obj ){
                        return true;
                    }else{
                        return false;
                    }

                } catch(e) {
                    return false;
                }
            }
        }
    });

    $.extend($Utils.loading,{
        open: function(){
            $(".page-loader").show();
        },
        close: function(){
            $(".page-loader").hide();
        }
    });

    $.extend($Utils.openWindow,{
        failWindow: function(name,errorStatus,msg){
            layer.open({
                type: 0,
                title: name,
                resize: false,
                area: ["480px","270px"],
                skin: "delete-window",
                content: "<div class='fail-box clearfix'><div class='fl fail-icon'></div><div class='fr fail-content'>"+(msg?(errorStatus+'# '+msg):(errorStatus == 0 ?('0# 未知错误。'):errorStatus))+"</div></div>",
                btn: ["确定"],
                success: function(layero,index){
                    $(layero).find('.layui-layer-content').css('height','137px');
                },
                yes: function(index,layero){
                    layer.close(index);
                }
            });
        }
    });

    window.$Utils = $Utils;
    window.$AppVars = $AppVars;
});