!function(){
    var $ = layui.jquery, layer = layui.layer, table = layui.table, tree = layui.tree, form = layui.form, excel = layui.excel;
    $AppVars.token = (location.href.split("token=")[1]).split("&")[0];

    //TODO
    var hasDO = (location.href.split("hasDO=")[1]).split("&")[0];
    // hasDO = 0;
    // var zip = new JSZip();
    // zip.file("aaa.txt","hello world！");
    // zip.folder("sub").file("bbb.js", "var a = 1;");
    // var content = zip.generate({type:"blob"});
    // saveAs(content, "example.zip");
    var pageStack = [];

    var packageName = "";
    var companyName = "";
    var productName = "";
    var description = "";

    var dbSetting = null;
    var rootFolder = new SqlFolder();
    var allTransforms = new BDATransforms();
    var selectedTransforms = new BDATransforms();
    var allJobs = new BDAJobs();
    var selectedJobs = new BDAJobs();
    var jJobTransforms = [];

    var allExcelFiles = new ExcelFiles();
    var selectedExcelFiles = new ExcelFiles();
    var allDatabaseLinks = new DatabaseLinks();
    var selectedDatabaseLinks = new DatabaseLinks();
    var allRelationModels = new RelationModels();
    var selectedRelationModels = new RelationModels();
    var allTableModels = new TableModels();
    var selectedTableModels = new TableModels();
    var allSqlModels = new SqlModels();
    var selectedSqlModels = new SqlModels();
    var allExcelModels = new ExcelModels();
    var selectedExcelModels = new ExcelModels();
    var allReports = new Reports();
    var selectedReports = new Reports();
    var allReportFolders = new ReportFolders();
    var selectedReportFolders = new ReportFolders();
    var reportVisibilitys = {};//Dictionary<string, List<int>>

    initExport();

    function initExport(){
        $(".cancel").click(function(){
            window.parent.close();
        });
        if(hasDO){
            initDOSelectPage();
        }else{
            $Utils.windowLoading.open();
            initBusinessModelPage();
        }
    }
    //#region 选择是否导出数据整理
    function initDOSelectPage(){
        $(".data-organize").show();
        $(".data-organize .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                var data = form.val("package");
                if(data.chkDataOrganize){
                    saveDBSetting();
                    initDDLScriptSelectPage();
                }else{
                    initBusinessModelPage();
                }
            }
            return false;
        });


        $Utils.windowLoading.close();
        pageStack.push(".data-organize");
    }
    function saveDBSetting(){
        dbSetting = null;
        var dbSettings = new BizDbSettings();
        dbSettings.getItems(1, false, function(){
            if(dbSettings.count() > 0){
                dbSetting = dbSettings.item(0);
            }
        }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取数据库设置",errorStatus,msg);
        })
    }
    //#endregion

    //#region 添加DDL
    function initDDLScriptSelectPage(){
        var ddlFolder = getDDLFolder();
        ddlFolder.sqlEntrys = [];
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".script-ddl").show();
        $(".script-ddl .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".script-ddl").hide();
            pageStack.pop();
        });
        $(".script-ddl .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();


                initDMLScriptSelectPage();
            }
            return false;
        });
        $(".script-ddl .add-column").off("click").on("click",function(){
            debugger
            //选择文件
            $("#selectDDLFile").click();
        });
        $("#selectDDLFile").change(function(e) {
            debugger
            $Utils.windowLoading.open();
            if(!Object.values) {
                Object.values = function values(obj) {
                    return Object.keys(obj).map(function(e){
                        return obj[e];
                    })
                };
            }
            var files = Object.values(e.target.files);
            // e.target.value = '';
            putFileToDDL(files, 0);
            $Utils.windowLoading.close();
        });

        $(".script-ddl .remove-column").off("click").on("click",function(){
            //移除文件
            var checkStatus = table.checkStatus('ddlScriptList');
            for(var i = 0; i < checkStatus.data.length; i++){
                var sqlSrcipt = checkStatus.data[i];
                ddlFolder.remove(sqlSrcipt);
            }
            table.reload("ddlScriptList",{
                data: ddlFolder.sqlEntrys
            });
        });
        loadDDLListTable();

        $Utils.windowLoading.close();
        pageStack.push(".script-ddl");
    }
    function putFileToDDL(files,i){
        var ddlFolder = getDDLFolder();
        if(i < files.length){
            var sqlFile = files[i];
            var sqlSrcipt = new SqlScript();
            sqlSrcipt.id = ddlFolder.id + "/" + sqlFile.name;
            sqlSrcipt.name = sqlFile.name;
            sqlSrcipt.parentID = "SqlScripts/DDL";
            var reader = new FileReader();
            reader.onload = function(){
                sqlSrcipt.text = encrypt(this.result, "1qazxsw23edcvfr4");
                sqlSrcipt.showText = this.result;
                ddlFolder.add(sqlSrcipt);
                putFileToDDL(files,i+1);
            };
            reader.readAsText(sqlFile);
        }
        else{
            //重新刷新列表
            table.reload("ddlScriptList",{
                data: ddlFolder.sqlEntrys
            });
        }
    }
    function getDDLFolder(){
        var ddlFolder = rootFolder.item("DDL");
        if(ddlFolder == null){
            ddlFolder = new SqlFolder();
            ddlFolder.name = "DDL";
            ddlFolder.id = "SqlScripts/DDL";
            ddlFolder.parentID = "SqlScripts/";
            rootFolder.sqlEntrys.push(ddlFolder);
        }
        return ddlFolder;
    }
    function loadDDLListTable(){
        var ddlScriptTableHead = [
            [
                {type: "checkbox"},
                {field: "name", title: "名称", sort: true},
                {title: "查看",templet: "#lookup",width: 80, align:"center"}
            ]
        ];
        rootFolder.sqlEntrys
        table.render({
            elem: '#ddlScriptList',
            height: 450,
            width: 630,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: ddlScriptTableHead,
            toolbar: false,
            autoSort: false,
            limit: 100000
        });
    }
    table.on("tool(scriptList)", function(obj){
        var sqlSrcipt = obj.data;
        if(obj.event == "lookupScirpt"){
            layer.open({
                type: 1,
                title: ["SQL脚本窗口","font-size: 14px"],
                btn: false,
                resize: false,
                area: ["760px","570px"],
                content: "<div class='show-sql-text'>" + sqlSrcipt.showText + "</div>"
            });
        }
    });
    //#endregion

    //#region 添加DML
    function initDMLScriptSelectPage(){
        var dmlFolder = getDMLFolder();
        dmlFolder.sqlEntrys = [];
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".script-dml").show();
        $(".script-dml .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".script-dml").hide();
            pageStack.pop();
        });
        $(".script-dml .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();

                initTransformSelectPage();
            }
            return false;
        });
        $(".script-dml .add-column").off("click").on("click",function(){
            //选择文件
            $("#selectDMLFile").click();
        });
        $("#selectDMLFile").change(function(e) {
            $Utils.windowLoading.open();
            debugger
            if(!Object.values) {
                Object.values = function values(obj) {
                    return Object.keys(obj).map(function(e){
                        return obj[e];
                    })
                };
            }
            var files = Object.values(e.target.files);
            // e.target.value = '';
            putFileToDML(files, 0);
            $Utils.windowLoading.close();
        });

        $(".script-dml .remove-column").off("click").on("click",function(){
            //移除文件
            var checkStatus = table.checkStatus('dmlScriptList');
            for(var i = 0; i < checkStatus.data.length; i++){
                var sqlSrcipt = checkStatus.data[i];
                dmlFolder.remove(sqlSrcipt);
            }
            table.reload("dmlScriptList",{
                data: dmlFolder.sqlEntrys
            });
        });
        loadDMLListTable();

        $Utils.windowLoading.close();
        pageStack.push(".script-dml");
    }
    function putFileToDML(files,i){
        var dmlFolder = getDMLFolder();
        if(i < files.length){
            var sqlFile = files[i];
            var sqlSrcipt = new SqlScript();
            sqlSrcipt.id = dmlFolder.id + "/" + sqlFile.name;
            sqlSrcipt.name = sqlFile.name;
            sqlSrcipt.parentID = "SqlScripts/DML";
            var reader = new FileReader();
            reader.onload = function(){
                sqlSrcipt.text = encrypt(this.result, "1qazxsw23edcvfr4");
                sqlSrcipt.showText = this.result;
                dmlFolder.add(sqlSrcipt);
                putFileToDML(files,i+1);
            };
            reader.readAsText(sqlFile);
        }
        else{
            //重新刷新列表
            table.reload("dmlScriptList",{
                data: dmlFolder.sqlEntrys
            });
        }
    }
    function getDMLFolder(){
        var dmlFolder = rootFolder.item("DML");
        if(dmlFolder == null){
            dmlFolder = new SqlFolder();
            dmlFolder.name = "DML";
            dmlFolder.id = "SqlScripts/DML";
            dmlFolder.parentID = "SqlScripts/";
            rootFolder.sqlEntrys.push(dmlFolder);
        }
        return dmlFolder;
    }
    function loadDMLListTable(){
        var dmlScriptTableHead = [
            [
                {type: "checkbox"},
                {field: "name", title: "名称", sort: true},
                {title: "查看",templet: "#lookup",width: 80, align:"center"}
            ]
        ];
        rootFolder.sqlEntrys
        table.render({
            elem: '#dmlScriptList',
            height: 450,
            width: 630,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: [],
            cols: dmlScriptTableHead,
            toolbar: false,
            autoSort: false,
            limit: 100000
        });
    }
    table.on("tool(scriptList)", function(obj){
        var sqlSrcipt = obj.data;
        if(obj.event == "lookupScirpt"){
            layer.open({
                type: 1,
                title: ["SQL脚本窗口","font-size: 14px"],
                btn: false,
                resize: false,
                area: ["760px","570px"],
                content: "<div class='show-sql-text'>" + sqlSrcipt.showText + "</div>"
            });
        }
    });
    //#endregion

    //#region 选择转换
    function initTransformSelectPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".transform").show();
        $(".transform .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".transform").hide();
            pageStack.pop();
        });
        $(".transform .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();

                saveSelectTransforms();

                initJobSelectPage();
            }
            return false;
        });

        loadTransformTable();

        $Utils.windowLoading.close();
        pageStack.push(".transform");
    }
    function loadTransformTable(){
        allTransforms.getItems(1, false, function(){ }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取转换列表",errorStatus,msg);
        }, "?hideLogic=0");
        var transformTableHead = [
            [
                {type: "checkbox"},
                {field: "transformName", title: "名称", sort: true}
            ]
        ]
        var transformTableBody = [];
        for(var i = 0; i < allTransforms.count(); i++){
            transformTableBody.push(allTransforms.item(i));
        }
        table.render({
            elem: '#transformList',
            height: 450,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: transformTableBody,
            cols: transformTableHead,
            toolbar: false,
            autoSort: false,
            limit: 100000
        });
    }
    function saveSelectTransforms(){
        selectedTransforms.clear();
        
        var checkStatus = table.checkStatus('transformList');
        for(var i = 0; i < checkStatus.data.length; i++){
            selectedTransforms.add(checkStatus.data[i]);
        }
    }
    //#endregion
    
    //#region 选择作业
    function initJobSelectPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".job").show();
        $(".job .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".job").hide();
            pageStack.pop();
        });
        $(".job .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                saveSelectJobs();
                if(validateSelectJobs()){

                    initBusinessModelPage();
                }
            }
            return false;
        });

        loadJobTable();

        $Utils.windowLoading.close();
        pageStack.push(".job");
    }
    function loadJobTable(){
        allJobs.getItems(1, false, function(){ }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取作业列表",errorStatus,msg);
        });
        var jobTableHead = [
            [
                {type: "checkbox"},
                {field: "jobName", title: "名称", sort: true}
            ]
        ]
        var jobTableBody = [];
        for(var i = 0; i < allJobs.count(); i++){
            jobTableBody.push(allJobs.item(i));
        }
        table.render({
            elem: '#jobList',
            height: 450,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: jobTableBody,
            cols: jobTableHead,
            toolbar: false,
            autoSort: false,
            limit: 100000
        });
    }
    
    function validateSelectJobs(){
        for(var i = 0; i < selectedJobs.count(); i++){
            var transformIDs = getJobTransformIDs(selectedJobs.item(i).jobID);
            for(var j = 0; j < transformIDs.length; j++){
                if(selectedTransforms.item(transformIDs[j]) == null){
                    $Utils.openWindow.failWindow("导入作业", "无法导入作业 " + selectedJobs.item(i).jobName + " ,因为缺少转换 " + allTransforms.item(transformIDs[j]).transformName + " 。");
                    $Utils.windowLoading.close();
                    return false;
                }
            }
        }
        return true;
    }
    function getJobTransformIDs(jobID){
        var result = [];
        var hasJob = false;
        for(var i = 0; i < jJobTransforms.length; i++){
            if(jJobTransforms[i]["id"] == jobID){
                result = jJobTransforms[i]["transformIDs"];
                hasJob = true;
                break;
            }
        }
        if(!hasJob){
            var job = allJobs.item(jobID);
            var jJobTransform = {};
            jJobTransform.id = jobID;
            jJobTransform.name = job.jobName;
            jJobTransform.transformIDs = [];
            for(var i = 0; i < job.transforms.count(); i++){
                jJobTransform.transformIDs.push(job.transforms.item(i).transformID);
            }
            jJobTransforms.push(jJobTransform);
            result = jJobTransform.transformIDs;
        }
        return result;
    }
    function saveSelectJobs(){
        selectedJobs.clear();
        
        var checkStatus = table.checkStatus('jobList');
        for(var i = 0; i < checkStatus.data.length; i++){
            selectedJobs.add(checkStatus.data[i]);
        }
    }
    //#endregion
    
    //#region 选择业务模型
    function initBusinessModelPage(){
        if(pageStack.length > 0){
            var lastPage = $(pageStack[pageStack.length - 1]);
            lastPage.hide();
        }
        $(".business-model").show();
        $(".business-model .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".business-model").hide();
            pageStack.pop();
        });
        $(".business-model .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                saveSelectModels();
                
                initReportTreePage();
            }
            return false;
        });

        loadBusinessModelTable();
        $Utils.windowLoading.close();
        pageStack.push(".business-model");
    }
    function loadBusinessModelTable(){
        allDatabaseLinks.getItems(1, false, function(){ }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取数据库连接列表",errorStatus,msg);
        });
        allExcelFiles.getItems(1, false, function(){ }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取Excel文件列表",errorStatus,msg);
        });
        allRelationModels.getItems(1, false, function(){ }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取关系模型列表",errorStatus,msg);
        });
        allTableModels.getItems(1, false, function(){ }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取数据表模型列表",errorStatus,msg);
        });
        allSqlModels.getItems(1, false, function(){ }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取SQL模型列表",errorStatus,msg);
        });
        allExcelModels.getItems(1, false, function(){ }, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取Excel模型列表",errorStatus,msg);
        });

        var businessModelTableHead = [
            [
                {type: "checkbox"},
                {field: "businessModelName", title: "名称", sort: true},
                {field: "businessModelType", title: "类型", sort: true, templet: function(d){
                    var typeString = "";
                    if(d.businessModelType == 0){
                        typeString = "关系模型";
                    }else if(d.businessModelType == 1){
                        typeString = "数据表模型";
                    }else if(d.businessModelType == 2){
                        typeString = "SQL模型";
                    }else if(d.businessModelType == 3){
                        typeString = "Excel模型";
                    }

                    return typeString;
                }},
                {field: "description", title: "描述", sort: true}
            ]
        ];

        var businessModelTableBody = [];
        for(var i = 0; i < allRelationModels.count(); i++){
            businessModelTableBody.push(allRelationModels.item(i));
        }
        for(var i = 0; i < allTableModels.count(); i++){
            businessModelTableBody.push(allTableModels.item(i));
        }
        for(var i = 0; i < allSqlModels.count(); i++){
            businessModelTableBody.push(allSqlModels.item(i));
        }
        for(var i = 0; i < allExcelModels.count(); i++){
            businessModelTableBody.push(allExcelModels.item(i));
        }
    
        table.render({
            elem: '#modelList',
            height: 450,
            cellMinWidth: 80, //全局定义常规单元格的最小宽度，layui 2.2.1 新增
            data: businessModelTableBody,
            cols: businessModelTableHead,
            toolbar: false,
            autoSort: false,
            limit: businessModelTableBody.length
        });
    }
    function saveSelectModels(){
        selectedRelationModels.clear();
        selectedTableModels.clear();
        selectedSqlModels.clear();
        selectedExcelModels.clear();
        selectedDatabaseLinks.clear();
        selectedExcelFiles.clear();

        var checkStatus = table.checkStatus('modelList');
        for(var i = 0; i < checkStatus.data.length; i++){
            var selectedModel = checkStatus.data[i];
            if(selectedModel.businessModelType == 0){
                if(allDatabaseLinks.item(selectedModel.dataSourceID) != null){
                    selectedDatabaseLinks.add(allDatabaseLinks.item(selectedModel.dataSourceID));
                }
                selectedRelationModels.add(selectedModel);
            }else if(selectedModel.businessModelType == 1){
                if(allDatabaseLinks.item(selectedModel.dataSourceID) != null){
                    selectedDatabaseLinks.add(allDatabaseLinks.item(selectedModel.dataSourceID));
                }
                selectedTableModels.add(selectedModel);
            }else if(selectedModel.businessModelType == 2){
                if(allDatabaseLinks.item(selectedModel.dataSourceID) != null){
                    selectedDatabaseLinks.add(allDatabaseLinks.item(selectedModel.dataSourceID));
                }
                selectedSqlModels.add(selectedModel);
            }else if(selectedModel.businessModelType == 3){
                if(allExcelFiles.item(selectedModel.dataSourceID) != null){
                    selectedExcelFiles.add(allExcelFiles.item(selectedModel.dataSourceID));
                }
                selectedExcelModels.add(selectedModel);
            }
        }
    }
    //#endregion 

    //#region 选择报表
    function initReportTreePage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".report").show();
        $(".report .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".report").hide();
            pageStack.pop();
        });
        $(".report .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                saveSelectReportAndFolders();
                if(validateSelectReports() == true){
                    $Utils.windowLoading.open();
                    initSelectPackagePages();
                }

            }
            return false;
        });

        initReportTree();

        $Utils.windowLoading.close();
        pageStack.push(".report");
    }
    function initReportTree(){
        var treeData = transformReportFolders();
        tree.render({
            elem: "#reportTree",
            data: treeData,
            showCheckbox: true,  //是否显示复选框
            id: "authority",
            isJump: false,
            onlyIconControl: true,
        });

        $("#reportTree").find(".layui-tree-iconClick").each(function(){
            
            if(!$(this).hasClass("layui-tree-icon")){
                $(this).find(".layui-icon").removeClass().addClass("iconfont bda-shilitubiao");
            }
        });
    }
    function transformReportFolders(){
        allReports.clear();
        allReportFolders.clear();
        allReports.getItems(1, false, function(){}, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取报表列表",errorStatus,msg);
        });
        allReportFolders.getItems(false, function(){}, function(errorStatus,msg){
            $Utils.openWindow.failWindow("获取报表文件夹列表",errorStatus,msg);
        });
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1",{title: "组织分析",id:"-1",folderID:"-1",folderParentID:"0",spread: true});
        for(var i = 0; i < allReportFolders.count(); i++){
            hashTable.add(allReportFolders.item(i).folderID,{title:allReportFolders.item(i).folderName,id:allReportFolders.item(i).folderID,folderID:allReportFolders.item(i).folderID,folderParentID:allReportFolders.item(i).folderParentID});
        }
        for(var i = 0; i < allReportFolders.count(); i++){
            var parentFolder = hashTable.getValue(allReportFolders.item(i).folderParentID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(allReportFolders.item(i).folderID));
        }
        for(var i = 0; i < allReports.count(); i++){
            var parentFolder = hashTable.getValue(allReports.item(i).folderID);
            parentFolder.spread = true;
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push({title:allReports.item(i).reportName,id:allReports.item(i).reportID,folderParentID:allReports.item(i).folderID,reportID:allReports.item(i).reportID});
        }
        if(hashTable.getValue("-1").children){
            tempArr = hashTable.getValue("-1").children;
        }

        return tempArr;
    }
    function saveSelectReportAndFolders(){
        selectedReportFolders.clear();
        selectedReports.clear();
        reportVisibilitys = {};

        var checkData = tree.getChecked('authority');
        var folderIDs = [];
        var reportIDs = [];
        for(var i = 0; i < checkData.length; i++){
            if(checkData[i].folderID){
                folderIDs.push(checkData[i].folderID);
            }
            if(checkData[i].reportID){
                reportIDs.push(checkData[i].reportID);
            }
            if(checkData[i].children && checkData[i].children.length){
                getChildren(checkData[i].children, folderIDs, reportIDs);
            }
        }

        for(var i = 0; i < folderIDs.length; i++){
            selectedReportFolders.add(allReportFolders.item(folderIDs[i]));
        }
        for(var i = 0; i < reportIDs.length; i++){
            var report = allReports.item(reportIDs[i]);
            selectedReports.add(report);
            reportVisibilitys[reportIDs[i]] = [];
            report.getReleaseDevices(false,function(items){
                var visibilityArr = [];
                for(var j = 0; j < items.length; j++){
                    visibilityArr.push(items[j]["deviceTypeID"])
                }
                reportVisibilitys[reportIDs[i]] = visibilityArr.toString();
            }, function(errorStatus,msg){
                $Utils.openWindow.failWindow("获取报表 " + report.reportName + " 的可见性",errorStatus,msg);
            });
            
        }

    }
    function getChildren(checkData, folderIDs, reportIDs){
        for(var i = 0; i < checkData.length; i++){
            if(checkData[i].folderID){
                folderIDs.push(checkData[i].folderID);
            }
            if(checkData[i].reportID){
                reportIDs.push(checkData[i].reportID);
            }
            if(checkData[i].children && checkData[i].children.length){
                getChildren(checkData[i].children, folderIDs, reportIDs);
            }
        }
    }
    function validateSelectReports(){
        for(var i = 0; i < selectedReports.count(); i++){
            var report = selectedReports.item(i);
            if(!report.reportDesign){
                report.reportSettings = new ReportSettings();
                report.reportDesign = new ReportDesign();
                report.getItemByID(report.reportID, false, function(){ }, function(errorStatus,msg){
                    report.reportDesign = null;
                    $Utils.openWindow.failWindow("获取报表",errorStatus,msg);
                });
            }
            if(report.reportDesign){
                for(var j = 0; j < report.reportDesign.queries.count(); j++){
                    var query = report.reportDesign.queries.item(j);
                    if(query.modelType == 0 && selectedRelationModels.item(query.modelID) == null){
                        $Utils.openWindow.failWindow("导出报表", "无法导出报表 " + report.reportName + " ,因为缺少模型 " + query.modelName + " 。");
                        return false;
                    }else if(query.modelType == 1 && selectedTableModels.item(query.modelID) == null){
                        $Utils.openWindow.failWindow("导出报表", "无法导出报表 " + report.reportName + " ,因为缺少模型 " + query.modelName + " 。");
                        return false;
                    }else if(query.modelType == 2 && selectedSqlModels.item(query.modelID) == null){
                        $Utils.openWindow.failWindow("导出报表", "无法导出报表 " + report.reportName + " ,因为缺少模型 " + query.modelName + " 。");
                        return false;
                    }else if(query.modelType == 3 && selectedExcelModels.item(query.modelID) == null){
                        $Utils.openWindow.failWindow("导出报表", "无法导出报表 " + report.reportName + " ,因为缺少模型 " + query.modelName + " 。");
                        return false;
                    }
                }
            }
            
        }
        return true;
    }
    //#endregion
    
    //#region 选择业务包存储路径
    function initSelectPackagePages(){
        
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".package").show();
        $(".package .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".package").hide();
            pageStack.pop();
        });
        $(".package .next-step").click(function(){
            if($(this).prop("disabled") == false){
                $Utils.windowLoading.open();
                savePackageInfo();
                initConfirmMsgPage();
            }
            return false;
        });

        $Utils.windowLoading.close();
        pageStack.push(".package");
    }
    function savePackageInfo(){
        var data = form.val("package");
        if(data.packageName.endsWith(".pkg")){
            packageName = data.packageName;
        }else {
            packageName = data.packageName + ".pkg";
        }
        companyName = data.companyName;
        productName = data.productName;
        description = data.description;
    }
    //#endregion

    //#region 确认页面
    function initConfirmMsgPage(){
        var lastPage = $(pageStack[pageStack.length - 1]);
        lastPage.hide();
        $(".confirm").show();
        $(".confirm .last-step").off("click").on("click",function(){
            lastPage.show();
            $(".confirm").hide();
            pageStack.pop();
        });
        $(".confirm .next-step").off("click").on("click",function(){
            if($(this).prop("disabled") == false){
                // $Utils.windowLoading.open();
                window.parent.openLoading();
                exportSelectedItems();
                
            }
            return false;
        });

        initConfirmMsg();

        $Utils.windowLoading.close();
        pageStack.push(".confirm");
    }
    function initConfirmMsg(){
        var confirmMsg = "业务包包含以下内容：<br><br>";
        if(dbSetting){
            confirmMsg = confirmMsg + "导出数据整理模块<br>"
        }
        confirmMsg = confirmMsg + "业务包名称：" + packageName + "<br>";
        confirmMsg = confirmMsg + "公司：" + companyName + "<br>";
        confirmMsg = confirmMsg + "产品：" + productName + "<br>";
        confirmMsg = confirmMsg + "描述：" + description + "<br>";

        if(selectedRelationModels.count() > 0){
            confirmMsg = confirmMsg + "导出关系模型："
            for(var i = 0; i < selectedRelationModels.count(); i++){
                if(i == selectedRelationModels.count() - 1){
                    confirmMsg = confirmMsg + selectedRelationModels.item(i).businessModelName;
                }else{
                    confirmMsg = confirmMsg + selectedRelationModels.item(i).businessModelName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }
        if(selectedTableModels.count() > 0){
            confirmMsg = confirmMsg + "导出数据表模型："
            for(var i = 0; i < selectedTableModels.count(); i++){
                if(i == selectedTableModels.count() - 1){
                    confirmMsg = confirmMsg + selectedTableModels.item(i).businessModelName;
                }else{
                    confirmMsg = confirmMsg + selectedTableModels.item(i).businessModelName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }
        if(selectedSqlModels.count() > 0){
            confirmMsg = confirmMsg + "导出SQL模型："
            for(var i = 0; i < selectedSqlModels.count(); i++){
                if(i == selectedSqlModels.count() - 1){
                    confirmMsg = confirmMsg + selectedSqlModels.item(i).businessModelName;
                }else{
                    confirmMsg = confirmMsg + selectedSqlModels.item(i).businessModelName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }
        if(selectedExcelModels.count() > 0){
            confirmMsg = confirmMsg + "导出Excel模型："
            for(var i = 0; i < selectedExcelModels.count(); i++){
                if(i == selectedExcelModels.count() - 1){
                    confirmMsg = confirmMsg + selectedExcelModels.item(i).businessModelName;
                }else{
                    confirmMsg = confirmMsg + selectedExcelModels.item(i).businessModelName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }

        if(selectedReportFolders.count() > 0){
            confirmMsg = confirmMsg + "导出报表文件夹："
            for(var i = 0; i < selectedReportFolders.count(); i++){
                if(i == selectedReportFolders.count() - 1){
                    confirmMsg = confirmMsg + selectedReportFolders.item(i).folderName;
                }else{
                    confirmMsg = confirmMsg + selectedReportFolders.item(i).folderName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }

        if(selectedReports.count() > 0){
            confirmMsg = confirmMsg + "导出报表："
            for(var i = 0; i < selectedReports.count(); i++){
                if(i == selectedReports.count() - 1){
                    confirmMsg = confirmMsg + selectedReports.item(i).reportName;
                }else{
                    confirmMsg = confirmMsg + selectedReports.item(i).reportName + ", ";
                }
            }
            confirmMsg = confirmMsg + "<br>";
        }

        $("#confirmMsg").html(confirmMsg);
    }
    var zip;
    function cteateZip(){
        var content = zip.generate({type:"blob"});
        saveAs(content, packageName);
        // alert("导出成功");
        window.parent.close();
        window.parent.closeLoading();
    }
    function exportSelectedItems(){
        zip = new JSZip();
        var jPkgInfo = {};
        jPkgInfo["encoding"] = "UTF8";
        var succ = function(data){
            jPkgInfo["version"] = data.item.version;
        };
        var fail = function(XHR,textStatus){
            window.parent.closeLoading();
            if(XHR.readyState == 0 && !window.navigator.onLine){
                $Utils.openWindow.failWindow("获取服务器版本","网络连接不可用。");
            }else if(textStatus == "timeout"){
                $Utils.openWindow.failWindow("获取服务器版本","请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    $Utils.openWindow.failWindow("获取服务器版本",XHR.status,XHR.responseText);
                }else{
                    $Utils.openWindow.failWindow("获取服务器版本",XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                $Utils.openWindow.failWindow("获取服务器版本","未知错误。");
            }
            return;
        };
        var url = $AppConstants.hostName + $AppConstants.port + "/bdasystem/versions?moduleID=1&deviceTypeID=2&osID=0";
        var obj = "";
        $Utils.request.getRequest(url,obj,false,"json",succ,fail);
        var sPkgInfo = JSON.stringify(jPkgInfo);
        var sBase64 = btoaUTF16(sPkgInfo);
        zip.file("pkg_info.txt", sBase64, {base64 : true});
        
        //生成config文件
        var config = {};
        config["公司"] = companyName;
        config["产品"] = productName;
        config["描述"] = description;

        //导出数据库设置
        if(dbSetting){
            config["dbSetting"] = JSON.stringify(dbSetting);
            
            //导出转换
            config["transforms"] = [];
            for(var i = 0; i < selectedTransforms.count(); i++){
                var jTransform = {};
                jTransform.id = selectedTransforms.item(i).transformID;
                jTransform.name = selectedTransforms.item(i).transformName;
                config["transforms"].push(jTransform);
            }
            zip.file("transforms.json", JSON.stringify(selectedTransforms));

            //导出作业
            config["jobs"] = [];
            for(var i = 0; i < selectedJobs.count(); i++){
                var jJob = {};
                jJob.id = selectedJobs.item(i).jobID;
                jJob.name = selectedJobs.item(i).jobName;
                jJob.transformIDs = getJobTransformIDs(jJob.id);
                selectedJobs.item(i).transforms.clear();
                config["jobs"].push(jJob);
            }
            zip.file("jobs.json", JSON.stringify(selectedJobs));
        }

        //导出sql脚本
        var ddlFolder = getDDLFolder();
        for(var i = 0; i < ddlFolder.sqlEntrys.length; i++){
            var sqlScript = ddlFolder.sqlEntrys[i];
            zip.file(sqlScript.parentID + "/" + sqlScript.name, sqlScript.text);
        }
        
        var dmlFolder = getDMLFolder();
        for(var i = 0; i < dmlFolder.sqlEntrys.length; i++){
            var sqlScript = dmlFolder.sqlEntrys[i];
            zip.file(sqlScript.parentID + "/" + sqlScript.name, sqlScript.text);
        }

        //导出数据库连接
        config["databaseLinks"] = [];
        for(var i = 0; i < selectedDatabaseLinks.count(); i++){
            var databaseLink = selectedDatabaseLinks.item(i);
            databaseLink.initByID(false, function(){
                zip.file(databaseLink.dataSourceName + ".dbl", JSON.stringify(databaseLink));
                config["databaseLinks"].push({"dataSourceID":databaseLink.dataSourceID,
                                                "dataSourceName":databaseLink.dataSourceName });
            }, function(errorStatus,msg){
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("获取数据库连接",errorStatus,msg);
                return;
            });
        }
        //导出excel文件
        config["excelFiles"] = [];
        for(var i = 0; i < selectedExcelFiles.count(); i++){
            var excelFile = selectedExcelFiles.item(i);
            excelFile.initByID(false, function(){
                zip.file(excelFile.dataSourceName + ".exf", JSON.stringify(databaseLink));
                config["excelFiles"].push({"excelFileID":excelFile.dataSourceID,
                                                "excelFileName":excelFile.dataSourceName });
                excelFile.download(false, function(data){
                    zip.file(excelFile.excelFileName, data);
                }, function(errorStatus,msg){
                    window.parent.closeLoading();
                    $Utils.openWindow.failWindow("获取Excel",errorStatus,msg);
                    return;
                });
            },function(errorStatus,msg){
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("获取数据库连接Excel文件",errorStatus,msg);
                return;
            });
        }
        //导出关系模型
        config["relationModels"] = [];
        for(var i = 0; i < selectedRelationModels.count(); i++){
            var fullRelationModel = new RelationModel();
            fullRelationModel.businessModelID = selectedRelationModels.item(i).businessModelID;
            fullRelationModel.initByModelID(false,function(){
                zip.file(fullRelationModel.businessModelName + ".rem", JSON.stringify(fullRelationModel));
                config["relationModels"].push({"relationModelID":selectedRelationModels.item(i).businessModelID,
                                                    "relationModelName":selectedRelationModels.item(i).businessModelName });
            },function(errorStatus,msg){
                window.parent.closeLoading();
                $Utils.openWindow.failWindow("获取关系模型",errorStatus,msg);
                return;
            });
            
        }
        //导出数据表模型
        config["tableModels"] = [];
        for(var i = 0; i < selectedTableModels.count(); i++){
            zip.file(selectedTableModels.item(i).businessModelName + ".tam", JSON.stringify(selectedTableModels.item(i)));
            config["tableModels"].push({"tableModelID":selectedTableModels.item(i).businessModelID,
                                                "tableModelName":selectedTableModels.item(i).businessModelName });
        }
        //导出SQL模型
        config["sqlModels"] = [];
        for(var i = 0; i < selectedSqlModels.count(); i++){
            zip.file(selectedSqlModels.item(i).businessModelName + ".sqm", JSON.stringify(selectedSqlModels.item(i)));
            config["sqlModels"].push({"sqlModelID":selectedSqlModels.item(i).businessModelID,
                                                "sqlModelName":selectedSqlModels.item(i).businessModelName });
        }
        //导出Excel模型
        config["excelModels"] = [];
        for(var i = 0; i < selectedExcelModels.count(); i++){
            zip.file(selectedExcelModels.item(i).businessModelName + ".exf", JSON.stringify(selectedExcelModels.item(i)));
            config["excelModels"].push({"excelModelID":selectedExcelModels.item(i).businessModelID,
                                                "excelModelName":selectedExcelModels.item(i).businessModelName });
        }


        //导出报表文件夹
        config["reportFolders"] = [];
        for(var i = 0; i < selectedReportFolders.count(); i++){
            config["reportFolders"].push({"folderID":selectedReportFolders.item(i).folderID,
                                           "folderName": selectedReportFolders.item(i).folderName,
                                           "folderParentID": selectedReportFolders.item(i).folderParentID});
        }
        //导出报表
        config["reports"] = [];
        var reportFileNameList = [];
        var reportImageUrls = [];
        var reportImageNames = [];
        var reportIDs = [];
        for(var a = 0; a < selectedReports.count(); a++){
            var report  = selectedReports.item(a);
            var reportFileName = getReportFileName(report.reportName, reportFileNameList);
            reportFileNameList.push(reportFileName);
            zip.file(reportFileName, JSON.stringify(report));

            var reportObj = {};
            reportObj.reportID = report.reportID;
            reportObj.reportName = report.reportName;
            reportObj.folderID = report.folderID;
            reportObj.reportFileName = reportFileName;
            reportObj.reportVisibility = reportVisibilitys[report.reportID];

            config["reports"].push(reportObj);

            //#region 打包图片
            var reportdesign = report.reportDesign;
            reportdesign.fillBlocks();
            for(var i = 0; i < reportdesign.pcPages.count(); i++){
                addImageTolist(reportdesign.pcPages.item(i).pageImage,reportImageUrls,reportImageNames,reportIDs,report.reportID);
            }
            for(var i = 0; i < reportdesign.padPages.count(); i++){
                addImageTolist(reportdesign.padPages.item(i).pageImage,reportImageUrls,reportImageNames,reportIDs,report.reportID);
            }
            for(var i = 0; i < reportdesign.mobilePages.count(); i++){
                addImageTolist(reportdesign.mobilePages.item(i).pageImage,reportImageUrls,reportImageNames,reportIDs,report.reportID);
            }
            for(var i = 0; i < reportdesign.blocks.length; i++){
                var block = reportdesign.blocks[i];
                addImageTolist(block.titleIcon,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                addImageTolist(block.backgroundImage,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                if(block instanceof ButtonBlock){
                    addImageTolist(block.icon,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                    addImageTolist(block.image,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                    addImageTolist(block.selectedImage,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                }
                if(block instanceof TabControlBlock){
                    var tabHeads = block.tabHeads;
                    addImageTolist(tabHeads.icon,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                    addImageTolist(tabHeads.backgroundImage,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                    addImageTolist(tabHeads.selectedBackgroundImage,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                }
                if(block instanceof LabelBlock){
                    for(var j = 0; j < block.images.count(); j++){
                        addImageTolist(block.images.item(j),reportImageUrls,reportImageNames,reportIDs,report.reportID);
                    }
                }
                if(block instanceof ChartBlock){
                    addImageTolist(block.picture,reportImageUrls,reportImageNames,reportIDs,report.reportID);
                }
            }

            //#endregion
        }
        zip.file(packageName.replace(".pkg", ".config"), JSON.stringify(config));
        debugger
        createImg(reportImageUrls, reportImageNames, reportIDs, 0);
    }
    function createImg(imageUrlList, imgNameList, reportIDList, i){
        if(i < imageUrlList.length){
            var imgDataUrl = function (dataURL){
                if(dataURL){
                    var realBase64 = dataURL.split("base64,")[1];
                    var folder = zip.folder(reportIDList[i]);
                    folder.file(imgNameList[i], realBase64, {base64:true});
                }
                createImg(imageUrlList, imgNameList, reportIDList, i + 1);
            }
            getImgToBase64(imageUrlList[i],imgDataUrl);
        }else{
            cteateZip();
        }
    }
        
    function getImgToBase64(url, callback) {//将图片转换为Base64
        var canvas = document.createElement('canvas'),
            ctx = canvas.getContext('2d'),
            img = new Image();
            img.crossOrigin = 'Anonymous';
            img.onload = function () {
                canvas.height = img.height;
                canvas.width = img.width;
                ctx.drawImage(img, 0, 0);
                var dataURL = canvas.toDataURL('image/png');
                callback(dataURL);
                canvas = null;
            };
            img.onerror = function(){
                callback(null);
                canvas = null;
            }
        img.src = url;
    }
        
//     function Base64toBlob(dataurl) {//将base64转换为文件
//         var arr = dataurl.split(','), mime = arr[0].match(/:(.*?);/)[1],
//             bstr = atob(arr[1]), n = bstr.length, u8arr = new Uint8Array(n);
//         while (n--) {
//             u8arr[n] = bstr.charCodeAt(n);
//         }
//         return new Blob([u8arr], { type: mime });////blob
//     }
    function addImageTolist(reportImage, urlList, nameList, reportIDList,reportID){
        if(reportImage && reportImage.imageID != "-1"){
            var url = $AppConstants.hostName + $AppConstants.port + "/Report/" + reportImage.imageURL;
            var name = reportImage.imageName;
            if(urlList.indexOf(url) == -1){
                urlList.push(url);
                nameList.push(name);
                reportIDList.push(reportID);
            }
        }
    }
    function getReportFileName(reportName, nameList){
        var newReportName = reportName.replace("/", "_");
        var result = newReportName + ".rep";
        var i = 0;
        while(nameList.indexOf(result) != -1){
            result = reportName + "(" + (++i) + ").rep";
        }
        return result;
    }
    //#endregion





}();