let organizationDateFormats = new OrganizationDateFormats();

const currentDate = {
    "day": "当日",
    "week": "当周",
    "month": "当月",
    "quarter": "当季",
    "year": "当年"
};
const lastDate = {
    "day": "昨日",
    "week": "上周",
    "month": "上月",
    "quarter": "上季",
    "year": "上年"
};
!function () {
    var $ = layui.jquery, layer = layui.layer, form = layui.form;

    window.initDefaultValueForm = function (index, valueStr, setDefaultValue) {
        getDateFormats(valueStr);

        $(".date-default-window .layui-btn-cancel").click(function () {
            layer.close(index);
        });

        form.on("submit(defaultFormSubmit)", function (data) {
            if (data.field.setDefaultValue) {
                if (validate(data)) {
                    let dateDefaultValue = "";
                    if (data.field.dateType == "day") {
                        if (data.field.dateTypeName == "current") {
                            dateDefaultValue = "today";
                        } else {
                            dateDefaultValue = "yesterday";
                        }
                    } else {
                        dateDefaultValue = data.field.dateTypeName + data.field.dateType.toLowerCase().replace(/( |^)[a-z]/g, (L) => L.toUpperCase());
                    }
                    setDefaultValue(dateDefaultValue);
                    layer.close(index);
                } else {
                    layer.msg("请选择默认值。", { icon: 2 });
                }
            } else {
                setDefaultValue("");
                layer.close(index);
            }
            return false;
        });
    }

    function getDateFormats(valueStr) {
        const succ = () => {
            initForm(valueStr);
        };
        const fail = (errorStatus, msg) => {
            $Utils.openWindow.failWindow("获取组织缺省日期设置", errorStatus, msg);
        };
        organizationDateFormats.getItems(true, succ, fail);
    }

    function initForm(valueStr) {
        if (valueStr) {
            let dataFormat = null;
            if (valueStr == "today") {
                $("#day").attr("checked", true);
                $("#current").attr("checked", true);
                $("#current").attr("title", "当日");
                $("#last").attr("title", "昨日");
                dataFormat = organizationDateFormats.item("day").format;
            } else if (valueStr == "yesterday") {
                $("#day").attr("checked", true);
                $("#last").attr("checked", true);
                $("#current").attr("title", "当日");
                $("#last").attr("title", "昨日");
                dataFormat = organizationDateFormats.item("day").format;
            } else {
                let dataType = null;
                if (valueStr.indexOf("current") != -1) {
                    dataType = valueStr.split("current")[1].toLowerCase();
                    $("#" + dataType).attr("checked", true);
                    $("#current").attr("checked", true);
                    $("#current").attr("title", currentDate[dataType]);
                    $("#last").attr("title", lastDate[dataType]);
                } else {
                    dataType = valueStr.split("previous")[1].toLowerCase();
                    $("#" + dataType).attr("checked", true);
                    $("#last").attr("checked", true);
                    $("#current").attr("title", currentDate[dataType]);
                    $("#last").attr("title", lastDate[dataType]);
                }
                dataFormat = organizationDateFormats.item(dataType).format;
            }
            form.val("formWindow", {
                "setDefaultValue": true,
                "dataFormat": dataFormat
            });
            $(".date-default-window input[name=dateType]").removeAttr("disabled");
            $(".date-default-window input[name=dateTypeName]").removeAttr("disabled");
        }
        form.render();
        bindEvent();
    }

    function bindEvent() {
        form.on("checkbox(setDefaultValue)", function (data) {
            if (data.elem.checked) {
                $(".date-default-window input[name=dateType]").removeAttr("disabled");
                $(".date-default-window input[name=dateTypeName]").removeAttr("disabled");
            } else {
                $(".date-default-window input[name=dateType]").attr("disabled", true);
                $(".date-default-window input[name=dateTypeName]").attr("disabled", true);
            }
            form.render();
        });

        form.on("radio(dateType)", function (data) {
            $("#current").attr("title", currentDate[data.value]);
            $("#last").attr("title", lastDate[data.value]);
            $("#current").attr("checked", true);
            form.val("formWindow", {
                "dataFormat": organizationDateFormats.item(data.value).format
            });
        });
    }

    function validate(data) {
        if (data.field.dataFormat) {
            return true;
        }
        return false;
    }
}();
