!function(){
    var $ = layui.jquery, layer = layui.layer, element = layui.element;
    var selectedTableCell = null;
    var layerIndex = null;
    var submitForm = null;
    var tabThisData = null;

    window.initDataFormat = function(obj,index,setDataFormatToTableCell){
        selectedTableCell = obj;
        layerIndex = index;
        submitForm = setDataFormatToTableCell;

        initTab(selectedTableCell);
        
        element.on('tab(formatTab)', function(data){
            tabThisData = null;
            if(data.index == 1){
                initDataValueTab();
            }
            if(data.index == 2){
                initPercentageValueTab();
            }
            if(data.index == 3){
                initScientificCountingTab();
            }
            if(data.index == 4){
                initDateTimeTab();
            }
            tabThisData = data;
        });

        $(".data-format-submit").click(function(){
            var dataFormatStr = "";
            if(tabThisData && tabThisData.index == 1){
                dataFormatStr = setDataValueStr();
            }
            if(tabThisData && tabThisData.index == 2){
                dataFormatStr = setPercentageValueStr();
            }
            if(tabThisData && tabThisData.index == 3){
                dataFormatStr = setScientificCountingStr();
            }
            if(tabThisData && tabThisData.index == 4){
                dataFormatStr = setDateTimeStr();
            }
            submitForm(selectedTableCell,dataFormatStr,layerIndex);
        });

        $(".data-format-cancel").click(function(){
            layer.close(layerIndex);
        });

    };

    function initTab(obj){
        tabThisData = {};
        if(obj.data.formatString.indexOf("Y") != -1 || obj.data.formatString.indexOf("m") != -1){
            element.tabChange("formatTab",4);
            tabThisData.index = 4;
            initDateTime(obj.data.formatString);
        }else if(obj.data.formatString.indexOf("E") != -1){
            element.tabChange("formatTab",3);
            if(obj.data.formatString.indexOf(".") != -1){
                $(".scientific-counting .digit").addClass("select-check");
                var value = (obj.data.formatString.split(".")[1]).split("E")[0].length;
                $(".scientific-counting .digit-value").val(value);
            }else{
                $(".scientific-counting .digit").removeClass("select-check");
            }
            tabThisData.index = 3;
            bindScientificCountingFormEvent(buildSample(3,obj.data.formatString));
        }else if(obj.data.formatString.indexOf("%") != -1){
            element.tabChange("formatTab",2);
            if(obj.data.formatString.indexOf(",") != -1){
                $(".percentage-value .thousand-mark").addClass("select-check");
            }else{
                $(".percentage-value .thousand-mark").removeClass("select-check");
            }
            if(obj.data.formatString.indexOf(".") != -1){
                $(".percentage-value .digit").addClass("select-check");
                var value = (obj.data.formatString.split(".")[1]).split("%")[0].length;
                $(".percentage-value .digit-value").val(value);
            }else{
                $(".percentage-value .digit").removeClass("select-check");
            }
            tabThisData.index = 2;
            bindPercentageValueFormEvent(buildSample(2,obj.data.formatString));
        }else if(obj.data.formatString == ""){
            element.tabChange("formatTab",0);
            tabThisData.index = 0;
        }else {
            element.tabChange("formatTab",1);
            if(obj.data.formatString.indexOf(",") != -1){
                $(".num-value .thousand-mark").addClass("select-check");
            }else{
                $(".num-value .thousand-mark").removeClass("select-check");
            }
            if(obj.data.formatString.indexOf(".") != -1){
                $(".num-value .digit").addClass("select-check");
                var value = obj.data.formatString.split(".")[1].length;
                $(".num-value .digit-value").val(value);
            }else{
                $(".num-value .digit").removeClass("select-check");
            }
            tabThisData.index = 1;
            bindNumValueFormEvent(buildSample(1,obj.data.formatString));
        }
    }

    function buildSample(index,formatString){
        var sample = "";
        switch(index){
            case 0:
                break;
            case 1:
                sample = "1,234";
                if(formatString.indexOf(",") == -1){
                    sample = commafyback(sample);
                }
                if(formatString.indexOf(".") != -1 && (formatString.split(".")[1].length > 0)){
                    sample = addDecimalPoint(sample,formatString.split(".")[1].length);
                }
                break;
            case 2:
                sample = "1,234";
                if(formatString.indexOf(",") == -1){
                    sample = commafyback(sample);
                }
                if(formatString.indexOf(".") != -1 && ((formatString.split(".")[1]).split("%")[0].length > 0)){
                    sample = addDecimalPoint(sample,(formatString.split(".")[1]).split("%")[0].length);
                }
                break;
            case 3:
                sample = "1";
                if(formatString.indexOf(".") != -1 && ((formatString.split(".")[1]).split("E")[0].length > 0)){
                    sample = addDecimalPoint(sample,(formatString.split(".")[1]).split("E")[0].length,2);
                }
                break;
        }
        return sample;
    }

    function initDateTime(formatString){
        var dateStr = "";
        var timeStr = "";
        if(formatString.indexOf("Y") != -1){
            $(".date-time .date-select").addClass("select-check");
            $(".date-time .date").addClass("select-box");
            if(formatString.indexOf("YYYY/M/d") != -1){
                dateStr = "2018/8/8";
                $(".date-time .date-list").find("li").eq(0).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("YYYY/MM/dd") != -1){
                dateStr = "2018/08/08";
                $(".date-time .date-list").find("li").eq(1).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("YYYY-M-d") != -1){
                dateStr = "2018-8-8";
                $(".date-time .date-list").find("li").eq(2).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("YYYY-MM-dd") != -1){
                dateStr = "2018-08-08";
                $(".date-time .date-list").find("li").eq(3).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("YYYY年M月d日") != -1){
                dateStr = "2018年8月8日";
                $(".date-time .date-list").find("li").eq(4).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("YYYY年MM月dd日") != -1){
                dateStr = "2018年08月08日";
                $(".date-time .date-list").find("li").eq(5).addClass("select-list").siblings("li").removeClass("select-list");
            }
        }else{
            $(".date-time .date-select").removeClass("select-check");
            $(".date-time .date").removeClass("select-box");
        }
        if(formatString.indexOf("mm") != -1){
            $(".date-time .time-select").addClass("select-check");
            $(".date-time .time").addClass("select-box");
            if(formatString.indexOf("HH:mm") != -1){
                timeStr = "08:30";
                $(".date-time .time-list").find("li").eq(0).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("hh:mm aa") != -1){
                timeStr = "08:30 AM";
                $(".date-time .time-list").find("li").eq(1).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("hh时mm分 aa") != -1){
                timeStr = "08时30分 AM";
                $(".date-time .time-list").find("li").eq(2).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("HH:mm:ss") != -1){
                timeStr = "08:30:55";
                $(".date-time .time-list").find("li").eq(3).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("hh:mm:ss aa") != -1){
                timeStr = "08:30:55 AM";
                $(".date-time .time-list").find("li").eq(4).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("HH时mm分ss秒") != -1){
                timeStr = "08时30分55秒";
                $(".date-time .time-list").find("li").eq(5).addClass("select-list").siblings("li").removeClass("select-list");
            }
            if(formatString.indexOf("hh时mm分ss秒 aa") != -1){
                timeStr = "08时30分55秒 AM";
                $(".date-time .time-list").find("li").eq(6).addClass("select-list").siblings("li").removeClass("select-list");
            }
        }else{
            $(".date-time .time-select").removeClass("select-check");
            $(".date-time .time").removeClass("select-box");
        }
        var exampleValue = dateStr?(dateStr+" " + timeStr):timeStr;
        bindDateTimeEvent(exampleValue,dateStr,timeStr);
    }

    function setDataValueStr(){
        var str = "###0";
        var digit = "";
        for(var i = 0; i < Number($(".num-value .digit-value").val()); i++){
            digit += "0";
        }
        if($(".num-value .thousand-mark").hasClass("select-check")){
            str = "#,##0";
        }
        if($(".num-value .digit").hasClass("select-check")){
            str = str + "." + digit;
        }
        return str;
    }

    function setPercentageValueStr(){
        var str = "###0";
        var digit = "";
        for(var i = 0; i < Number($(".percentage-value .digit-value").val()); i++){
            digit += "0";
        }
        if($(".percentage-value .thousand-mark").hasClass("select-check")){
            str = "#,##0";
        }
        if($(".percentage-value .digit").hasClass("select-check")){
            str = str + "." + digit;
        }
        return str+"%";
    }

    function setScientificCountingStr(){
        var str = "0";
        var digit = "";
        for(var i = 0; i < Number($(".scientific-counting .digit-value").val()); i++){
            digit += "0";
        }
        if($(".scientific-counting .digit").hasClass("select-check")){
            str = str + "." + digit;
        }
        return str+"E0";
    }

    function setDateTimeStr(){
        var dateStr = "";
        var timeStr = "";
        if($(".date-time .date-select").hasClass("select-check")){
            dateStr = $(".date-time .date-list li.select-list").attr("data-str");
        }
        if($(".date-time .time-select").hasClass("select-check")){
            timeStr = $(".date-time .time-list li.select-list").attr("data-str");
        }
        return (dateStr + (timeStr?(dateStr?(" " + timeStr):timeStr):timeStr));
    }

    function initDataValueTab(){
        var exampleValue = "1,234";
        $(".num-value .digit-value").val(0);
        bindNumValueFormEvent(exampleValue);
    }

    function bindNumValueFormEvent(exampleValue){
        $(".num-value .layui-field-box").text(exampleValue);
        var stempExampleValue = exampleValue;
        $(".num-value .check-box").off('click').on("click",function(){
            if($(this).hasClass("select-check")){
                $(this).removeClass("select-check");
                if($(this).hasClass("thousand-mark")){
                    stempExampleValue = commafyback(stempExampleValue);
                    // stempExampleValue.replace(/,|\s/g,'');
                }
                if($(this).hasClass("digit")){
                    if(stempExampleValue.indexOf(".") != -1){
                        stempExampleValue = stempExampleValue.slice(0,stempExampleValue.indexOf("."));
                    }
                    $(".num-value .digit-value").attr("disabled","disabled");
                }
            }else{
                $(this).addClass("select-check");
                if($(this).hasClass("thousand-mark")){
                    stempExampleValue = commafy(stempExampleValue);
                }
                if($(this).hasClass("digit")){
                    stempExampleValue = addDecimalPoint(stempExampleValue,$(".num-value").find(".digit-value").val());
                    $(".num-value .digit-value").removeAttr("disabled");
                }
            }
            $(".num-value .layui-field-box").text(stempExampleValue);
        });
        $(".num-value .digit-value").on("input propertychange",function(){
            if(Number($(this).val().replace(/[^\d]/g,''))>16){
                $(this).val(16);
            }else{
                $(this).val(Number($(this).val().replace(/[^\d]/g,'')));
            }
            if(stempExampleValue.indexOf(".") != -1){
                stempExampleValue = stempExampleValue.slice(0,stempExampleValue.indexOf(".")) + (resetExample($(this).val())?("."+resetExample($(this).val())):"");
            }else{
                stempExampleValue = stempExampleValue + (resetExample($(this).val())?("."+resetExample($(this).val())):"");
            }
            $(".num-value .layui-field-box").text(stempExampleValue);
        });
    }

    function initPercentageValueTab(){
        var exampleValue = "1,234";
        $(".percentage-value .digit-value").val(0);
        bindPercentageValueFormEvent(exampleValue);
    }

    function bindPercentageValueFormEvent(exampleValue){
        $(".percentage-value .layui-field-box").text(exampleValue+"%");
        var stempExampleValue = exampleValue;
        $(".percentage-value .check-box").off('click').on("click",function(){
            if($(this).hasClass("select-check")){
                $(this).removeClass("select-check");
                if($(this).hasClass("thousand-mark")){
                    stempExampleValue = commafyback(stempExampleValue);
                    // stempExampleValue.replace(/,|\s/g,'');
                }
                if($(this).hasClass("digit")){
                    if(stempExampleValue.indexOf(".") != -1){
                        stempExampleValue = stempExampleValue.slice(0,stempExampleValue.indexOf("."));
                    }
                    $(".percentage-value .digit-value").attr("disabled","disabled");
                }
            }else{
                $(this).addClass("select-check");
                if($(this).hasClass("thousand-mark")){
                    stempExampleValue = commafy(stempExampleValue);
                }
                if($(this).hasClass("digit")){
                    stempExampleValue = addDecimalPoint(stempExampleValue,$(".percentage-value").find(".digit-value").val());
                    $(".percentage-value .digit-value").removeAttr("disabled");
                }
            }
            $(".percentage-value .layui-field-box").text(stempExampleValue+"%");
        });
        $(".percentage-value .digit-value").on("input propertychange",function(){
            if(Number($(this).val().replace(/[^\d]/g,''))>16){
                $(this).val(16);
            }else{
                $(this).val(Number($(this).val().replace(/[^\d]/g,'')));
            }
            if(stempExampleValue.indexOf(".") != -1){
                stempExampleValue = stempExampleValue.slice(0,stempExampleValue.indexOf(".")) + (resetExample($(this).val())?("."+resetExample($(this).val())):"");
            }else{
                stempExampleValue = stempExampleValue + (resetExample($(this).val())?("."+resetExample($(this).val())):"");
            }
            $(".percentage-value .layui-field-box").text(stempExampleValue+"%");
        });
    }

    function initScientificCountingTab(){
        var exampleValue = "1";
        $(".scientific-counting .digit-value").val(0);
        bindScientificCountingFormEvent(exampleValue);
    }

    function bindScientificCountingFormEvent(exampleValue){
        $(".scientific-counting .layui-field-box").text(((exampleValue.indexOf("E") != -1)?exampleValue:(exampleValue+"E+04")));
        var stempExampleValue = exampleValue;
        $(".scientific-counting .check-box").off('click').on("click",function(){
            if($(this).hasClass("select-check")){
                $(this).removeClass("select-check");
                if($(this).hasClass("digit")){
                    if(stempExampleValue.indexOf(".") != -1){
                        stempExampleValue = stempExampleValue.slice(0,stempExampleValue.indexOf("."));
                    }
                    $(".scientific-counting .digit-value").attr("disabled","disabled");
                }
            }else{
                $(this).addClass("select-check");
                if($(this).hasClass("digit")){
                    stempExampleValue = addDecimalPoint(stempExampleValue,$(".scientific-counting").find(".digit-value").val(),2);
                    $(".scientific-counting .digit-value").removeAttr("disabled");
                }
            }
            $(".scientific-counting .layui-field-box").text(stempExampleValue+"E+04");
        });
        $(".scientific-counting .digit-value").on("input propertychange",function(){
            if(Number($(this).val().replace(/[^\d]/g,''))>16){
                $(this).val(16);
            }else{
                $(this).val(Number($(this).val().replace(/[^\d]/g,'')));
            }
            if(stempExampleValue.indexOf(".") != -1){
                stempExampleValue = stempExampleValue.slice(0,stempExampleValue.indexOf(".")) + (resetExample($(this).val(),2)?("."+resetExample($(this).val(),2)):"");
            }else{
                stempExampleValue = stempExampleValue + (resetExample($(this).val(),2)?("."+resetExample($(this).val(),2)):"");
            }
            $(".scientific-counting .layui-field-box").text(stempExampleValue+"E+04");
        });
    }

    function initDateTimeTab(){
        var exampleValueDate = "2018/8/8";
        var exampleValueTime = "";
        var exampleValue = exampleValueDate?(exampleValueDate+" "+exampleValueTime):exampleValueTime;
        bindDateTimeEvent(exampleValue);
    }

    function bindDateTimeEvent(exampleValue){
        $(".date-time .layui-field-box").text(exampleValue);
        var stempExampleValue = "";
        var stempExampleValueDate = "";
        var stempExampleValueTime = "";
        $(".date-time .check-box").off('click').on("click",function(){
            if($(this).hasClass("select-check")){
                $(this).removeClass("select-check");
                if($(this).hasClass("date-select")){
                    $(".date").removeClass("select-box");
                    stempExampleValueDate = "";
                    if($(".time").hasClass("select-box")){
                        stempExampleValueTime = $(".time li.select-list").text();
                    }
                }
                if($(this).hasClass("time-select")){
                    $(".time").removeClass("select-box");
                    stempExampleValueTime = "";
                    if($(".date").hasClass("select-box")){
                        stempExampleValueDate = $(".date li.select-list").text();
                    }
                }
            }else{
                $(this).addClass("select-check");
                if($(this).hasClass("date-select")){
                    $(".date").addClass("select-box");
                    stempExampleValueDate = $(".date-list").find("li.select-list").text();
                    if($(".time").hasClass("select-box")){
                        stempExampleValueTime = $(".time li.select-list").text();
                    }
                }
                if($(this).hasClass("time-select")){
                    $(".time").addClass("select-box");
                    stempExampleValueTime = $(".time-list").find("li.select-list").text();
                    if($(".date").hasClass("select-box")){
                        stempExampleValueDate = $(".date li.select-list").text();
                    }
                }
            }
            stempExampleValue = stempExampleValueDate?(stempExampleValueDate+" "+stempExampleValueTime):stempExampleValueTime;
            $(".date-time .layui-field-box").text(stempExampleValue);
        });
        $(".date-list li").off('click').on("click",function(){
            if($(".date").hasClass("select-box")){
                if(!$(this).hasClass("select-list")){
                    $(this).addClass("select-list").siblings().removeClass("select-list");
                    stempExampleValueDate = $(this).text();
                    if($(".time").hasClass("select-box")){
                        stempExampleValueTime = $(".time li.select-list").text();
                    }
                    stempExampleValue = stempExampleValueDate?(stempExampleValueDate+" "+stempExampleValueTime):stempExampleValueTime;
                    $(".date-time .layui-field-box").text(stempExampleValue);
                }
            }
        });
        $(".time-list li").off('click').on("click",function(){
            if($(".time").hasClass("select-box")){
                if(!$(this).hasClass("select-list")){
                    $(this).addClass("select-list").siblings().removeClass("select-list");
                    stempExampleValueTime = $(this).text();
                    if($(".date").hasClass("select-box")){
                        stempExampleValueDate = $(".date li.select-list").text();
                    }
                    stempExampleValue = stempExampleValueDate?(stempExampleValueDate+" "+stempExampleValueTime):stempExampleValueTime;
                    $(".date-time .layui-field-box").text(stempExampleValue);
                }
            }
        });
    }

    function resetExample(num,startIndex){
        var str = "";
        var startNum = startIndex?startIndex:5;
        for(var i = 0; i < num; i++){
            str += (startNum + "");
            startNum++;
            startNum = startNum % 10;
        }
        return str;
    }

    function commafyback(num){
        var x = num.split(',');
        return x.join("");
    }

    function commafy(num){
        num = Number(num) +"";
        var re=/(-?\d+)(\d{3})/
        while(re.test(num)){
            num=num.replace(re,"$1,$2");
        }
        return num;
    }

    function addDecimalPoint(num,numDecimal,numIndex){
        var decimal = resetExample(numDecimal,numIndex);
        return num + (decimal?("."+decimal):"");
    }

}();