/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-03-09 09:42:01
 * @LastEditTime: 2021-04-09 15:55:45
 * @LastModifyUser: 
 * @Remark: 
 */
function BusinessObject(){
    this.businessObjectID = null;
    this.businessObjectName = null;
    this.businessObjectFolderID = null;
    this.aggregateFunction = null;
    this.aggregateAware = null;
    this.valueOrder = null;
    this.formatString = null;
    this.businessObjectType = null;
    this.dataType = null;
    this.columnName = null;
    this.expressionText = null;
    this.expressionList = null;
    this.tableNamesList = null;
    this.sortIndex = null;
    this.visibility = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };

    this.getBusinessData = function(basePath,businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + basePath + "/" + businessModelID + "/businessObjects/" + this.businessObjectID + "/businessData";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    }
}

function BusinessObjects(){
    var me = this;
    this.count = 0;
    this.aryBusinessObjects = [];
    this.dicBusinessObjects = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryBusinessObjects[indexOrKey];
        }else{
            return this.dicBusinessObjects[indexOrKey];
        }
    };
    this.add = function (businessObject) {
        this.aryBusinessObjects.push(businessObject);
        this.dicBusinessObjects[businessObject.businessObjectID] = businessObject;
        this.count = this.aryBusinessObjects.length;
    };
    this.remove = function (businessObject) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryBusinessObjects[i].businessObjectID==businessObject.businessObjectID){
                k = i;
                break;
            }
        }
        this.aryBusinessObjects.splice(k,1);
        delete this.dicBusinessObjects[businessObject.businessObjectID];
        this.count = this.aryBusinessObjects.length;
    };
    this.setBusinessObjects = function(data){
        this.count = 0;
        this.aryBusinessObjects = [];
        this.dicBusinessObjects = {};
        for(var i = 0; i < data.length; i++){
            var businessObject = new BusinessObject();
            businessObject.init(data[i]);
            this.add(businessObject);
        }
    };
}

function BusinessObjectFolder(){
    this.folderID = null;
    this.folderName = null;
    this.description = null;
    this.folderParentID = null;
    this.sortIndex = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function BusinessObjectFolders(){
    var me = this;
    this.count = 0;
    this.aryBusinessObjectFolders = [];
    this.dicBusinessObjectFolders = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryBusinessObjectFolders[indexOrKey];
        }else{
            return this.dicBusinessObjectFolders[indexOrKey];
        }
    };
    this.add = function (businessObjectFolder) {
        this.aryBusinessObjectFolders.push(businessObjectFolder);
        this.dicBusinessObjectFolders[businessObjectFolder.folderID] = businessObjectFolder;
        this.count = this.aryBusinessObjectFolders.length;
    };
    this.remove = function (businessObjectFolder) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryBusinessObjectFolders[i].folderID==businessObjectFolder.folderID){
                k = i;
                break;
            }
        }
        this.aryBusinessObjectFolders.splice(k,1);
        delete this.dicBusinessObjectFolders[businessObjectFolder.folderID];
        this.count = this.aryBusinessObjectFolders.length;
    };
    this.setBusinessObjectFolders = function(data){
        me.count = 0;
        me.aryBusinessObjectFolders = [];
        me.dicBusinessObjectFolders = {};
        for(var i = 0; i < data.length; i++){
            var businessObjectFolder = new BusinessObjectFolder();
            businessObjectFolder.init(data[i]);
            me.add(businessObjectFolder);
        }
    };
}