function Login(){
	var me = this;
	this.loginID = null;
    this.organizationID = null;
    this.organizationShortName = null;
    this.userID = null;
    this.userName = null;
    this.deviceTypeName = null;
	this.deviceTypeID = null;
    this.osID = null;
    this.osName = null;
	this.token = null;
	this.loginDate = null;
    this.lastOperationDate = null;
    this.logoutDate = null;
    
    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function Logins(){
	var me = this;
    this.aryLogins = [];
    this.dicLogins = {};

    this.add = function (login) {
        this.aryLogins.push(login);
        this.dicLogins[login.loginID] = login;
        this.count = this.aryLogins.length;
    };
    this.remove = function (login) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryLogins[i].loginID==login.loginID){
                k = i;
                break;
            }
        }
        this.aryLogins.splice(k,1);
        delete this.dicLogins[login.loginID];
        this.count = this.aryLogins.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryLogins[indexOrKey];
        }else{
            return this.dicLogins[indexOrKey];
        }
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.loginsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setLogins(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(login,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.loginsPath+"?securityLevel=1";
        var obj = JSON.stringify(login);
        var dataType = 'json';

    	var succCallback = function(data,status,request){
    		if(request.status == 201){
                var loginID = request.getResponseHeader('location').split('/logins/')[1];
                succ(loginID);
    		}
    	}
    	var failCallback = function(XHR,textStatus){
        	if(XHR.readyState == 0 && !window.navigator.onLine){
        		fail("网络连接不可用。");
        	}else   if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
        		if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
        	}else{
        		fail("未知错误。");
        	}
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItemByOTP = function(login,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.loginsPath;
        var obj = JSON.stringify(login);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else   if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemByID = function(loginID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.loginsPath + "/" + loginID;
        var obj = "";
        var dataType = 'json';

        var succCallback = function(data,status,request){
            if(request.status == 200){
                setLogins([data.item]);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deletItem = function(loginID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.loginsPath + "/" + loginID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setLogins(data){
        me.count = 0;
        me.aryLogins = [];
        me.dicLogins = {};
        for(var i = 0; i < data.length; i++){
            var login = new Login();
            login.init(data[i]);
            me.add(login);
        }
    }
}

function User(){
	var me = this;
	this.userID = null;
	this.userName = null;
	this.mobileNumber = null;
	this.emailAddress = null;
	this.fullName = null;
	this.portrait = null;
	this.defaultOrganizationID = null;
    this.organizationShortName = null;
    this.registerMethod = null;     //0：手机、1：邮箱、2：管理员新增
    this.userForbidden = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };

	this.getItemByID = function(userID,asyncOrSync,succ,fail){
    	var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID;
    	var obj = "";
    	
		var dataType = 'json';
    	var succCallback = function(data,status,request){
    		if(request.status == 200){
				me.init(data.item);
    			succ();
    		}
    	}
    	var failCallback = function(XHR,textStatus){
        	if(XHR.readyState == 0 && !window.navigator.onLine){
        		fail("网络连接不可用。");
        	}else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
        		if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
        	}else{
        		fail("未知错误。");
        	}
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
	};

    this.validatePassword = function(password,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + this.userID + "/password" + "?password="+encodeURIComponent(password);
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(XHR.status == 404){
                    fail("原密码不正确。");
                }else{
                    if(!$Utils.request.isJson(XHR.responseText)){
                        fail(XHR.status,XHR.responseText);
                    }else{
                        fail(XHR.status,JSON.parse(XHR.responseText).error);
                    }
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.editPassword = function(password,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + this.userID + "/password" + "?password="+encodeURIComponent(password);
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getModules = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + this.userID + "/userModules/moduleIDs";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.getItemByUserName = function(userName,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "?userName="+userName;
    	var obj = "";
    	
		var dataType = 'json';
    	var succCallback = function(data,status,request){
    		if(request.status == 200){
				me.init(data.items[0]);
    			succ();
    		}
    	}
    	var failCallback = function(XHR,textStatus){
        	if(XHR.readyState == 0 && !window.navigator.onLine){
        		fail("网络连接不可用。");
        	}else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
        		if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
        	}else{
        		fail("未知错误。");
        	}
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.uploadFace = function(faceImage,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + this.userID + "/portrait";
        var obj = faceImage;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function Users(){
	var me = this;
    this.count = 0;
    this.aryUsers = [];
    this.dicUsers = {};

    this.add = function (user) {
        this.aryUsers.push(user);
        this.dicUsers[user.userID] = user;
        this.count = this.aryUsers.length;
    };
    this.remove = function (user) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryUsers[i].userID==user.userID){
                k = i;
                break;
            }
        }
        this.aryUsers.splice(k,1);
        delete this.dicUsers[user.userID];
        this.count = this.aryUsers.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryUsers[indexOrKey];
        }else{
            return this.dicUsers[indexOrKey];
        }
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setUsers(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(user,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath;
        var obj = JSON.stringify(user);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItemByOTP = function(user,code,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "?otp="+code;
        var obj = JSON.stringify(user);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(user,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + user.userID;
        var obj = JSON.stringify(user);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(userID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.changeForbidden = function(userID,forbidden,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/forbidden?forbidden=" + forbidden;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.userForbidden = forbidden?0:1;
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setUsers(data){
        me.count = 0;
        me.aryUsers = [];
        me.dicUsers = {};
        for(var i = 0; i < data.length; i++){
            var user = new User();
            user.init(data[i]);
            me.add(user);
        }
    }
}

function Organization(){
    var me = this;
    this.organizationID = null;
    this.organizationCode = null;
    this.organizationName = null;
    this.organizationShortName = null;
    this.contactPerson = null;
    this.telephone = null;
    this.mobileNumber = null;
    this.emailAddress = null;
    this.countryID = null;
    this.provinceID = null;
    this.cityID = null;
    this.organizationLogo = null;
    this.systemName = null;

    this.createUserID;
    this.createDate;
    this.lastModifyUserID;
    this.lastModifyDate;

    this.updateLogo = function(logoImage,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationsPath + "/" + this.organizationID + "/organizationLogo";
        var obj = logoImage;
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                var imgUrl = request.getResponseHeader('location');
                me.organizationLogo = imgUrl;
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.upLoadRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.initByID = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationsPath + "/" + this.organizationID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function Organizations(){
	var me = this;
    this.count = 0;
    this.aryOrganizations = [];
    this.dicOrganizations = {};

    this.add = function (organization) {
        this.aryOrganizations.push(organization);
        this.dicOrganizations[organization.organizationID] = organization;
        this.count = this.aryOrganizations.length;
    };
    this.remove = function (organization) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryOrganizations[i].organizationID==organization.organizationID){
                k = i;
                break;
            }
        }
        this.aryOrganizations.splice(k,1);
        delete this.dicOrganizations[organization.organizationID];
        this.count = this.aryOrganizations.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryOrganizations[indexOrKey];
        }else{
            return this.dicOrganizations[indexOrKey];
        }
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setOrganizations(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByUserID = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.usersPath + "/" + userID + "/organizations";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setOrganizations(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(organization,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationsPath;
        var obj = JSON.stringify(organization);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var organizationID = request.getResponseHeader('location').split('/organizations/')[1];
                organization.organizationID = organizationID;
                organization.initByID(asyncOrSync,succ,fail);
            }
        };
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(organization,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationsPath + "/" + organization.organizationID;
        var obj = JSON.stringify(organization);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(organization.organizationID).init(organization);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(organizationID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationsPath + "/" + organizationID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(organizationID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setOrganizations(data){
        me.count = 0;
        me.aryOrganizations = [];
        me.dicOrganizations = {};
        for(var i = 0; i < data.length; i++){
            var organization = new Organization();
            organization.init(data[i]);
            me.add(organization);
        }
    }
}

function OrganizationSystemSetting(){
    this.systemSettingKey = null;
    this.systemSettingValue = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function OrganizationSystemSettings(){
	var me = this;
    this.count = 0;
    this.aryOrganizationSystemSettings = [];
    this.dicOrganizationSystemSettings = {};

    this.add = function (organizationSystemSetting) {
        this.aryOrganizationSystemSettings.push(organizationSystemSetting);
        this.dicOrganizationSystemSettings[organizationSystemSetting.systemSettingKey] = organizationSystemSetting;
        this.count = this.aryOrganizationSystemSettings.length;
    };
    this.remove = function (organizationSystemSetting) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryOrganizationSystemSettings[i].systemSettingKey==organizationSystemSetting.systemSettingKey){
                k = i;
                break;
            }
        }
        this.aryOrganizationSystemSettings.splice(k,1);
        delete this.dicOrganizationSystemSettings[organizationSystemSetting.systemSettingKey];
        this.count = this.aryOrganizationSystemSettings.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryOrganizationSystemSettings[indexOrKey];
        }else{
            return this.dicOrganizationSystemSettings[indexOrKey];
        }
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationSystemSettingsPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setOrganizationSystemSettings(data.items);
                succ();
            }
        };
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        };
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.update = function(organizationSystemSettings,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationSystemSettingsPath;
        var obj = JSON.stringify(organizationSystemSettings);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                for(var i = 0; i < organizationSystemSettings.length; i++){
                    me.item(organizationSystemSettings[i].systemSettingKey).systemSettingValue = organizationSystemSettings[i].systemSettingValue;
                }
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setOrganizationSystemSettings(data){
        me.count = 0;
        me.aryOrganizationSystemSettings = [];
        me.dicOrganizationSystemSettings = {};
        for(var i = 0; i < data.length; i++){
            var organizationSystemSetting = new OrganizationSystemSetting();
            organizationSystemSetting.init(data[i]);
            me.add(organizationSystemSetting);
        }
    }
}

function OrganizationUser(){
    var me = this;
    this.organizationUserID = null;
    this.organizationID = null;
    this.userID = null;
    this.organizationUserForbidden = null;
    this.createUserID = null;
    this.createDate = null;
    this.deleteUserID = null;
    this.deleteDate = null;
    this.deleted = null;
    this.userName = null;
    this.mobileNumber = null;
    this.emailAddress = null;
    this.fullName = null;
    this.defaultOrganizationID = null;
    this.organizationUserSettings = new OrganizationUserSettings();

    this.init = function(options){
        for(var key in options){
            if(key == "organizationUserSettings"){
                this[key].setOrganizationUserSettings(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };

}

function OrganizationUsers(){
    var me = this;
    this.count = 0;
    this.aryOrganizationUsers = [];
    this.dicOrganizationUsers = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryOrganizationUsers[indexOrKey];
        }else{
            return this.dicOrganizationUsers[indexOrKey];
        }
    };
    this.add = function (organizationUser) {
        this.aryOrganizationUsers.push(organizationUser);
        this.dicOrganizationUsers[organizationUser.organizationUserID] = organizationUser;
        this.count = this.aryOrganizationUsers.length;
    };
    this.remove = function (organizationUser) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryOrganizationUsers[i].organizationUserID==organizationUser.organizationUserID){
                k = i;
                break;
            }
        }
        this.aryOrganizationUsers.splice(k,1);
        delete this.dicOrganizationUsers[organizationUser.organizationUserID];
        this.count = this.aryOrganizationUsers.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationUsersPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setOrganizationUsers(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItemsByUserID = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationUsersPath+"?userIDs="+userID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setOrganizationUsers(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(organizationUser,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationUsersPath;
        var obj = JSON.stringify(organizationUser);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deletItem = function(organizationUserID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationUsersPath + "/" + organizationUserID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(organizationUserID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.changeForbidden = function(organizationUserID,forbidden,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationUsersPath + "/" + organizationUserID + "/forbidden?forbidden=" + forbidden;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.organizationUserForbidden = forbidden?0:1;
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setOrganizationUsers(data){
        me.count = 0;
        me.aryOrganizationUsers = [];
        me.dicOrganizationUsers = {};
        for(var i = 0; i < data.length; i++){
            var organizationUser = new OrganizationUser();
            organizationUser.init(data[i]);
            me.add(organizationUser);
        }
    }
}

function OrganizationUserSetting(){
    this.settingKey = null;
    this.settingValue = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function OrganizationUserSettings(){
    var me = this;
    this.count = 0;
    this.aryOrganizationUserSettings = [];
    this.dicOrganizationUserSettings = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryOrganizationUserSettings[indexOrKey];
        }else{
            return this.dicOrganizationUserSettings[indexOrKey];
        }
    };
    this.add = function (organizationUserSetting) {
        this.aryOrganizationUserSettings.push(organizationUserSetting);
        this.dicOrganizationUserSettings[organizationUserSetting.settingKey] = organizationUserSetting;
        this.count = this.aryOrganizationUserSettings.length;
    };
    this.remove = function (organizationUserSetting) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryOrganizationUserSettings[i].settingKey==organizationUserSetting.settingKey){
                k = i;
                break;
            }
        }
        this.aryOrganizationUserSettings.splice(k,1);
        delete this.dicOrganizationUserSettings[organizationUserSetting.settingKey];
        this.count = this.aryOrganizationUserSettings.length;
    };
    this.editItem = function(organizationUserID,organizationUserSettings,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.organizationUsersPath + "/" + organizationUserID + "/organizationUserSettings";
        var obj = JSON.stringify(organizationUserSettings);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.setOrganizationUserSettings(organizationUserSettings);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    this.setOrganizationUserSettings = function(data){
        me.count = 0;
        me.aryOrganizationUserSettings = [];
        me.dicOrganizationUserSettings = {};
        for(var i = 0; i < data.length; i++){
            var organizationUserSetting = new OrganizationUserSetting();
            organizationUserSetting.init(data[i]);
            me.add(organizationUserSetting);
        }
    }
}

function Menu(){
    this.menuID = null;
    this.menuCode = null;
    this.menuName = null;
    this.menuImage = null;
    this.menuParentID = null;
    this.moduleID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function Menus(){
    var me = this;
    this.count = 0;
    this.aryMenus = [];
    this.dicMenus = {};

    this.add = function (menu) {
        this.aryMenus.push(menu);
        this.dicMenus[menu.menuID] = menu;
        this.count = this.aryMenus.length;
    };
    this.remove = function (menu) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryMenus[i].menuID==menu.menuID){
                k = i;
                break;
            }
        }
        this.aryMenus.splice(k,1);
        delete this.dicMenus[menu.menuID];
        this.count = this.aryMenus.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryMenus[indexOrKey];
        }else{
            return this.dicMenus[indexOrKey];
        }
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.menusPath + "?moduleID=" + moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setMenus(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    function setMenus(data){
        me.count = 0;
        me.aryMenus = [];
        me.dicMenus = {};
        for(var i = 0; i < data.length; i++){
            var menu = new Menu();
            menu.init(data[i]);
            me.add(menu);
        }
    }
}

function UserTheme(){
    var me = this;
    this.userID = null;
	this.deviceTypeID = null;
    this.themeID = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function UserThemes(){
    var me = this;
    this.count = 0;
    this.aryUserThemes = [];
    this.dicUserThemes = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryUserThemes[indexOrKey];
        }else{
            return this.dicUserThemes[indexOrKey];
        }
    };
    this.add = function (userTheme) {
        this.aryUserThemes.push(userTheme);
        this.dicUserThemes[userTheme.userID] = userTheme;
        this.count = this.aryUserThemes.length;
    };
    this.remove = function (userTheme) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryUserThemes[i].userID==userTheme.userID){
                k = i;
                break;
            }
        }
        this.aryUserThemes.splice(k,1);
        delete this.dicUserThemes[userTheme.userID];
        this.count = this.aryUserThemes.length;
    };
    this.getThemeByUserID = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.userThemesPath + userID + "&" + $AppVars.deviceTypeID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setUserThemes([data.item]);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.update = function(userTheme,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.userThemesPath + userTheme.userID + "&" + userTheme.deviceTypeID;
        var obj = JSON.stringify(userTheme);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setUserThemes(data){
        me.count = 0;
        me.aryUserThemes = [];
        me.dicUserThemes = {};
        for(var i = 0; i < data.length; i++){
            var userTheme = new UserTheme();
            userTheme.init(data[i]);
            me.add(userTheme);
        }
    }
}

function LinkShare(){
    this.shareID = null;
    this.groupID = null;
    this.groupName = null;
    this.groupView = null;
    this.groupSettings = null;
    this.shareType = null;
    this.restrictDate = null;
    this.shareDays = null;
    this.needPassword = null;
    this.sharePassword = null;
    this.themeID = null;
    this.deviceTypeID = null;
    this.shareToken = null;
    this.shareUserID = null;
    this.shareUserName = null;
    this.shareDate = null;
    this.shareEndDate = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function LinkShares(){
    var me = this;
    this.count = 0;
    this.aryLinkShares = [];
    this.dicLinkShares = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryLinkShares[indexOrKey];
        }else{
            return this.dicLinkShares[indexOrKey];
        }
    };
    this.add = function (linkShare) {
        this.aryLinkShares.push(linkShare);
        this.dicLinkShares[linkShare.shareID] = linkShare;
        this.count = this.aryLinkShares.length;
    };
    this.remove = function (linkShare) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryLinkShares[i].shareID==linkShare.shareID){
                k = i;
                break;
            }
        }
        this.aryLinkShares.splice(k,1);
        delete this.dicLinkShares[linkShare.shareID];
        this.count = this.aryLinkShares.length;
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.linkSharePath + "?moduleID=" + moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setLinkShares(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(linkShare,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.linkSharePath;
        var obj = JSON.stringify(linkShare);
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var shareID = request.getResponseHeader('location').split('/linkShares/')[1];
                succ(shareID);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(shareID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.linkSharePath + "/" + shareID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(shareID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setLinkShares(data){
        me.count = 0;
        me.aryLinkShares = [];
        me.dicLinkShares = {};
        for(var i = 0; i < data.length; i++){
            var linkShare = new LinkShare();
            linkShare.init(data[i]);
            me.add(linkShare);
        }
    }
}

function Country(){
    this.countryID = null;
    this.countryCode = null;
    this.countryName = null;
    this.planetID = null;
    this.provinces = new Provinces();
    this.haveMap = 0;
    this.haveChildMap = 0;
    this.longitude = null;
    this.latitude = null;

    this.init = function(options){
        for(var key in options){
            if(key == "provinces" && options[key]){
                this[key].setProvinces(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
}

function Countries(){
    var me = this;
    this.count = 0;
    this.aryCountries = [];
    this.dicCountries = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryCountries[indexOrKey];
        }else{
            return this.dicCountries[indexOrKey];
        }
    };
    this.add = function (country) {
        this.aryCountries.push(country);
        this.dicCountries[country.countryID] = country;
        this.count = this.aryCountries.length;
    };
    this.remove = function (country) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryCountries[i].countryID==country.countryID){
                k = i;
                break;
            }
        }
        this.aryCountries.splice(k,1);
        delete this.dicCountries[country.countryID];
        this.count = this.aryCountries.length;
    };
    this.setCountries = function(data){
        me.count = 0;
        me.aryCountries = [];
        me.dicCountries = {};
        for(var i = 0; i < data.length; i++){
            var country = new Country();
            country.init(data[i]);
            me.add(country);
        }
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.countriesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.setCountries(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

}

function Province(){
    this.provinceID = null;
    this.provinceCode = null;
    this.provinceName = null;
    this.countryID = null;
    this.cities = new Cities();
    this.haveMap = 0;
    this.haveChildMap = 0;
    this.longitude = null;
    this.latitude = null;

    this.init = function(options){
        for(var key in options){
            if(key == "cities" && options[key]){
                this[key].setCities(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
}

function Provinces(){
    var me = this;
    this.count = 0;
    this.aryProvinces = [];
    this.dicProvinces = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryProvinces[indexOrKey];
        }else{
            return this.dicProvinces[indexOrKey];
        }
    };
    this.add = function (province) {
        this.aryProvinces.push(province);
        this.dicProvinces[province.provinceID] = province;
        this.count = this.aryProvinces.length;
    };
    this.remove = function (province) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryProvinces[i].provinceID==province.provinceID){
                k = i;
                break;
            }
        }
        this.aryProvinces.splice(k,1);
        delete this.dicProvinces[province.provinceID];
        this.count = this.aryProvinces.length;
    };
    this.setProvinces = function(data){
        me.count = 0;
        me.aryProvinces = [];
        me.dicProvinces = {};
        for(var i = 0; i < data.length; i++){
            var province = new Province();
            province.init(data[i]);
            me.add(province);
        }
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.provincesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.setProvinces(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function City(){
    this.cityID = null;
    this.cityCode = null;
    this.cityName = null;
    this.provinceID = null;
    this.haveChildMap = 0;
    this.haveMap = 0;
    this.longitude = null;
    this.latitude = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
}

function Cities(){
    var me = this;
    this.count = 0;
    this.aryCities = [];
    this.dicCities = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryCities[indexOrKey];
        }else{
            return this.dicCities[indexOrKey];
        }
    };
    this.add = function (city) {
        this.aryCities.push(city);
        this.dicCities[city.cityID] = city;
        this.count = this.aryCities.length;
    };
    this.remove = function (city) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryCities[i].cityID==city.cityID){
                k = i;
                break;
            }
        }
        this.aryCities.splice(k,1);
        delete this.dicCities[city.cityID];
        this.count = this.aryCities.length;
    };
    this.setCities = function(data){
        me.count = 0;
        me.aryCities = [];
        me.dicCities = {};
        for(var i = 0; i < data.length; i++){
            var city = new City();
            city.init(data[i]);
            me.add(city);
        }
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.citiesPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.setCities(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function MobileNumber(){
    this.validate = function(mobileNumber,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.mobileNumberPath + mobileNumber;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ(request.status);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(XHR.status == 404){
                    succ(XHR.status);
                }else{
                    if(!$Utils.request.isJson(XHR.responseText)){
                        fail(XHR.status,XHR.responseText);
                    }else{
                        fail(XHR.status,JSON.parse(XHR.responseText).error);
                    }
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getOTP = function(mobileNumber,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.mobileNumberPath + mobileNumber +"/OTP";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.property);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function EmailAddress(){
    this.validate = function(emailAddress,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.emailAddressPath + emailAddress;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ(request.status);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(XHR.status == 404){
                    succ(XHR.status);
                }else{
                    if(!$Utils.request.isJson(XHR.responseText)){
                        fail(XHR.status,XHR.responseText);
                    }else{
                        fail(XHR.status,JSON.parse(XHR.responseText).error);
                    }
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getOTP = function(emailAddress,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.emailAddressPath + emailAddress +"/OTP";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.property);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function Favorites(){
    var me = this;
    this.count = 0;
    this.aryFavorites = [];
    this.dicFavorites = {};

    this.add = function (report) {
        this.aryFavorites.push(report);
        this.dicFavorites[report.reportID] = report;
        this.count = this.aryFavorites.length;
    };
    this.remove = function (report) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryFavorites[i].reportID==report.reportID){
                k = i;
                break;
            }
        }
        this.aryFavorites.splice(k,1);
        delete this.dicFavorites[report.reportID];
        this.count = this.aryFavorites.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryFavorites[indexOrKey];
        }else{
            return this.dicFavorites[indexOrKey];
        }
    };
    this.addItem = function(userID,report,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportUsersPath + "/" + userID + "/favorite?reportID=" + report.reportID;
        var obj = "";
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                me.add(report);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(userID,reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportUsersPath + "/" + userID + "/favorite/" + reportID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(reportID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(userID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportUsersPath + "/" + userID + "/favorite";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setFavorites(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setFavorites(data){
        me.count = 0;
        me.aryFavorites = [];
        me.dicFavorites = {};
        for(var i = 0; i < data.length; i++){
            var report = new Report();
            report.init(data[i]);
            me.add(report);
        }
    }
}

function SelfAnalysis(){
    var me = this;
    this.count = 0;
    this.arySelfAnalysis = [];
    this.dicSelfAnalysis = {};

    this.add = function (report) {
        this.arySelfAnalysis.push(report);
        this.dicSelfAnalysis[report.reportID] = report;
        this.count = this.arySelfAnalysis.length;
    };
    this.remove = function (report) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.arySelfAnalysis[i].reportID==report.reportID){
                k = i;
                break;
            }
        }
        this.arySelfAnalysis.splice(k,1);
        delete this.dicSelfAnalysis[report.reportID];
        this.count = this.arySelfAnalysis.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.arySelfAnalysis[indexOrKey];
        }else{
            return this.dicSelfAnalysis[indexOrKey];
        }
    };
    this.deleteItem = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(reportID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "?moduleID="+moduleID+"&createSource=1";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setSelfAnalysis(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    function setSelfAnalysis(data){
        me.count = 0;
        me.arySelfAnalysis = [];
        me.dicSelfAnalysis = {};
        for(var i = 0; i < data.length; i++){
            var report = new Report();
            report.init(data[i]);
            me.add(report);
        }
    }
}

function ChartSample(){
    this.chartID = null;
    this.chartCode = null;
    this.chartName = null;
    this.chartURL = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    }
}

function ChartSamples(){
    var me = this;
    this.count = 0;
    this.aryChartSamples = [];
    this.dicChartSamples = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryChartSamples[indexOrKey];
        }else{
            return this.dicChartSamples[indexOrKey];
        }
    };
    this.add = function (chartSample) {
        this.aryChartSamples.push(chartSample);
        this.dicChartSamples[chartSample.chartID] = chartSample;
        this.count = this.aryChartSamples.length;
    };
    this.remove = function (chartSample) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryChartSamples[i].chartID==chartSample.chartID){
                k = i;
                break;
            }
        }
        this.aryChartSamples.splice(k,1);
        delete this.dicChartSamples[chartSample.chartID];
        this.count = this.aryChartSamples.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.chartSamplePath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setChartSamples(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setChartSamples(data){
        me.count = 0;
        me.aryReports = [];
        me.dicReports = {};
        for(var i = 0; i < data.length; i++){
            var chartSample = new ChartSample();
            chartSample.init(data[i]);
            me.add(chartSample);
        }
    }
}

function ReportFolder(){
    var me = this;
    this.folderID = null;
    this.folderName = null;
    this.folderParentID = null;
    this.organizationID = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = (new Date()).getTime();
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;

    this.init = function(options){
        for(var key in options){
            this[key] = options[key];
        }
    };
    
    this.getItemByID = function(folderID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folderID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
}

function ReportFolders(){
	var me = this;
    this.count = 0;
    this.aryReportFolders = [];
    this.dicReportFolders = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryReportFolders[indexOrKey];
        }else{
            return this.dicReportFolders[indexOrKey];
        }
    };
    this.add = function (reprortFolder) {
        this.aryReportFolders.push(reprortFolder);
        this.dicReportFolders[reprortFolder.folderID] = reprortFolder;
        this.count = this.aryReportFolders.length;
    };
    this.remove = function (reprortFolder) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryReportFolders[i].folderID==reprortFolder.folderID){
                k = i;
                break;
            }
        }
        this.aryReportFolders.splice(k,1);
        delete this.dicReportFolders[reprortFolder.folderID];
        this.count = this.aryReportFolders.length;
    };
    this.getItems = function(asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setReprortFolders(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(folder,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath;
        var obj = JSON.stringify(folder);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var folderID = request.getResponseHeader('location').split('/reportFolders/')[1];
                folder.folderID = folderID;
                me.add(folder);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(folder,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folder.folderID;
        var obj = JSON.stringify(folder);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.deleteItem = function(folderID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.foldersPath + "/" + folderID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(folderID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setReprortFolders(data){
        me.count = 0;
        me.aryReportFolders = [];
        me.dicReportFolders = {};
        for(var i = 0; i < data.length; i++){
            var reportFolder = new ReportFolder();
            reportFolder.init(data[i]);
            me.add(reportFolder);
        }
    }
}

function Report(){
    var me = this;
    this.reportID = null;
    this.reportName = null;
    this.folderID = null;
    this.createUserID = null;
    this.createUserName = null;
    this.createDate = (new Date()).getTime();
    this.createSource = 0;
    this.lastModifyUserID = null;
    this.lastModifyUserName = null;
    this.lastModifyDate = null;
    this.reportSettings = new ReportSettings();
    this.reportDesign = null;

    this.getItemByID = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/simpleProperties";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                me.init(data.item);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getReleaseDevices = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/reportVisibilities";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.updateRelease = function(reportID,parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID + "/reportVisibilities?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.init = function(options){
        for(var key in options){
            if(key == "reportSettings"){
                this[key].setReportSettings(options[key]);
            }else{
                this[key] = options[key];
            }
        }
    };
}

function Reports(){
    var me = this;
    this.count = 0;
    this.aryReports = [];
    this.dicReports = {};

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryReports[indexOrKey];
        }else{
            return this.dicReports[indexOrKey];
        }
    };
    this.add = function (report) {
        this.aryReports.push(report);
        this.dicReports[report.reportID] = report;
        this.count = this.aryReports.length;
    };
    this.remove = function (report) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryReports[i].reportID==report.reportID){
                k = i;
                break;
            }
        }
        this.aryReports.splice(k,1);
        delete this.dicReports[report.reportID];
        this.count = this.aryReports.length;
    };
    this.getItemsByFolderID = function(folderID,moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "?folderID=" + folderID + "&moduleID=" + moduleID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setReports(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.addItem = function(report,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath;
        var obj = JSON.stringify(report);
        var dataType = 'text';
        var succCallback = function(data,status,request){
            if(request.status == 201){
                var reportID = request.getResponseHeader('location').split('/reports/')[1];
                report.reportID = reportID;
                me.add(report);
                succ(reportID);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.postRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editItem = function(report,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + report.reportID;
        var obj = JSON.stringify(report);

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.editSimpleProperty = function(report,parameters,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + report.reportID + "/simpleProperties?" + parameters;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.item(report.reportID).reportName = report.reportName;
                me.item(report.reportID).folderID = report.folderID;
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.putRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    }
    this.deleteItem = function(reportID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "/" + reportID;
        var obj = "";
        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 204){
                me.remove(me.item(reportID));
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.deleteRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getItems = function(moduleID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.reportsPath + "?moduleID="+moduleID+"&includeReportSettings=1";
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                setReports(data.items);
                succ();
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };
    this.getUsedCount = function(businessModelID,asyncOrSync,succ,fail){
        var url = $AppConstants.hostName + $AppConstants.port + $AppURLs.modelReportsPath + "/count?modelID="+businessModelID;
        var obj = "";

        var dataType = 'json';
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.property);
            }
        }
        var failCallback = function(XHR,textStatus){
            if(XHR.readyState == 0 && !window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(textStatus == "timeout"){
                fail("请求超时。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    fail(XHR.status,XHR.responseText);
                }else{
                    fail(XHR.status,JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $Utils.request.getRequest(url,obj,asyncOrSync,dataType,succCallback,failCallback);
    };

    function setReports(data){
        me.count = 0;
        me.aryReports = [];
        me.dicReports = {};
        for(var i = 0; i < data.length; i++){
            var report = new Report();
            report.init(data[i]);
            me.add(report);
        }
    }
}

function ReportSetting(options){
    this.reportSettingKey = options.reportSettingKey;
    this.reportSettingValue = options.reportSettingValue;
}

function ReportSettings(){
    var me = this;
    this.count = 0;
    this.dicreportSettings = {};
    this.aryreportSettings = [];

    this.add = function (reportSetting) {
        this.aryreportSettings.push(reportSetting);
        this.dicreportSettings[reportSetting.reportSettingKey]=reportSetting;

        this.count = this.aryreportSettings.length;
    };
    this.remove = function (reportSetting) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryreportSettings[i].reportSettingKey==reportSetting.reportSettingKey){
                k=i;
                break;
            }
        }
        this.aryreportSettings.splice(k,1);
        delete this.dicreportSettings[reportSetting.reportSettingKey];

        this.count=this.aryreportSettings.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryreportSettings[indexOrKey];
        }else{
            return this.dicreportSettings[indexOrKey];
        }
    };

    this.setReportSettings = function (data) {
        this.count = 0;
        this.dicreportSettings = {};
        this.aryreportSettings = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var reportSetting = new ReportSetting(data[intI]);
            this.add(reportSetting);
        }
    };
}