(function(window){

    var $AppConstants = {
        hostName: location.protocol+"//" + location.hostname,
        // hostName: "http://192.168.1.128",
        port: location.port?(":"+location.port):"",
        // port: ":8080",
        webHostName: location.protocol+"//" + location.hostname,
        // webHostName: "http://127.0.0.1",
        webPort: location.port?(":"+location.port):"",
        // webPort: ":8080",
        projectName: "/app/wap",
        // projectName: ""
    };

    var $AppURLs = {
        jspPath: "/Report/report_front_end/jsp/report.jsp",
        loginsPath: "/bdasystem/logins",
        usersPath: "/bdasystem/users",
        menusPath: "/bdasystem/menus",
        organizationUsersPath: "/bdasystem/organizationUsers",
        organizationSystemSettingsPath: "/bdasystem/organizationSystemSettings",
        foldersPath: "/Report/reportFolders",
        reportsPath: "/Report/reports",
        chartSamplePath: "/Report/charts",
        linkSharePath: "/Report/linkShares",
        reportUsersPath: "/Report/users",
        userThemesPath: "/bdasystem/userThemes/",
    };

    var $AppVars = {
        visibleAreaHeight: 0,
        deviceTypeID: 0,
        osID: 0,
        token: "",
        queryTimeOut: 3
    };
    
    var $Utils = {
        request: {},
        cookie: {},
        loading: {}
    };

    $.extend($Utils.request,{
        getRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'get',
                url: url ,
                dataType: dataType,
                timeout: 63000 * $AppVars.queryTimeOut,
                traditional: true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            });
        },
        postRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Content-Type"] = "application/json; charset=utf-8";
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'post',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            });
        },
        putRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Content-Type"] = "application/json; charset=utf-8";
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'PUT',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            });
        },
        deleteRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Content-Type"] = "application/json; charset=utf-8";
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'DELETE',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            });
        },
        upLoadRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'post',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                contentType:false,
                processData:false,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            });
        },
        downLoadRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var xhr = new XMLHttpRequest();
            xhr.open('GET', url, asyncOrSync);        // 也可以使用POST方式，根据接口
            xhr.responseType = dataType;    // 返回类型blob
            xhr.setRequestHeader("Authorization",$AppVars.gLogin.token);
            // 定义请求完成的处理函数，请求前也可以增加加载框/禁用下载按钮逻辑
            xhr.onreadystatechange = function(){
                if(xhr.readyState == 4 && xhr.status == 200){
                    succCallback([this.response]);
                }else{
                    if(xhr.readyState == 4){
                        var data = this.response;
                        var fileReader = new FileReader();
                        fileReader.onload = function() {
                            try {
                                var jsonData = JSON.parse(this.result);  // 说明是普通对象数据，后台转换失败
                                failCallback(xhr.status,jsonData.error)
                            } catch (err) {   // 解析成对象失败，说明是正常的文件流
                                failCallback();
                            } 
                        };
                        fileReader.readAsText(data);
                    }
                }
            };

            xhr.send()
        },
        isJson: function(str){
            if (typeof str == 'string') {
                try {
                    var obj=JSON.parse(str);
                    if(typeof obj == 'object' && obj ){
                        return true;
                    }else{
                        return false;
                    }

                } catch(e) {
                    return false;
                }
            }
        }
    });

    $.extend($Utils.cookie, {
		addCookie: function(cname,cvalue,exdays){
		    var d = new Date();
		    d.setTime(d.getTime() + (exdays*24*60*60*1000));
		    var expires = "expires=" + d.toGMTString();
		    document.cookie = cname+"="+cvalue+";"+expires+";path=/";
		},
		getCookie: function(cname){
		    var name = cname + "=";
		    var ca = document.cookie.split(";");
		    for(var i=0;i<ca.length;i++){
		        var c = ca[i];
		        while(c.charAt(0)==' '){
		            c = c.substring(1);
		        }
		        if(c.indexOf(cname) == 0){
		            return c.substring(name.length,c.length);
		        }
		    }
		    return "";
		},
		deleteCookie: function(cname){
			var exp = new Date()
			exp.setTime(exp.getTime() - 1)
			var cval = this.getCookie(cname);
			if (cval && cval != null) {
				document.cookie = cname + '=' + cval + ';expires=' + exp.toGMTString()+";path=/";
			}
		}
    });

    $.extend($Utils.loading,{
        open: function(){
            $(".page-loader").show();
        },
        close: function(){
            $(".page-loader").hide();
        }
    });

    window.$Utils = $Utils;
    window.$AppURLs = $AppURLs;
    window.$AppConstants = $AppConstants;
    window.$AppVars = $AppVars;

})(window)