/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-06-08 09:05:46
 * @LastEditTime: 2021-05-10 19:56:20
 * @LastModifyUser: 
 * @Remark: 
 */ 
(function(mui,window,doc){
    var os = function (){
        var ua = navigator.userAgent,
            isWindowsPhone = /(?:Windows Phone)/.test(ua),
            isSymbian = /(?:SymbianOS)/.test(ua) || isWindowsPhone,
            isAndroid = /(?:Android)/.test(ua),
            isFireFox = /(?:Firefox)/.test(ua),
            isChrome = /(?:Chrome|CriOS)/.test(ua),
            isTablet = /(?:iPad|PlayBook)/.test(ua) || (isAndroid && !/(?:Mobile)/.test(ua)) || (isFireFox && /(?:Tablet)/.test(ua)),
            isPhone = /(?:iPhone)/.test(ua) && !isTablet,
            isPc = !isPhone && !isAndroid && !isSymbian;
        return {
            isTablet: isTablet,
            isPhone: isPhone,
            isAndroid: isAndroid,
            isPc: isPc
        };
    }();
    var logins = new Logins();
    var deviceTypeID = 0;

    initPage();

    function initPage(){
        $Utils.loading.close();
        if(os.isPc){
            deviceTypeID = 2;
        }else if(os.isTablet){
            deviceTypeID = 1;
        }else{
            deviceTypeID = 0;
        }
        
        var loginButton = doc.getElementById('login');

        loginButton.addEventListener('tap', function(event) {
            if(validate()){
                $Utils.loading.open();
                loginByUserName();
            }
        });        

        if($Utils.cookie.getCookie(window.location.host+"-mRememberName") && $Utils.cookie.getCookie(window.location.host+"-mRememberWord")){
            $("#userName").val($Utils.cookie.getCookie(window.location.host+"-mRememberName"));
            $("#password").val(decrypt($Utils.cookie.getCookie(window.location.host+"-mRememberWord")));
            $("input[name=rememberPassword]")[0].checked = true;
            if($Utils.cookie.getCookie(window.location.host+"-mAutoLogin")){
                $("input[name=autoLogin]")[0].checked = true;
                if($Utils.cookie.getCookie(window.location.host+"-mLoginStop")){
                    mui.trigger(loginButton,'tap');
                }
            }
        }

        mui('.mui-left').on('change','input[name=autoLogin]',function(){
            var value = this.checked?true:false;
            if(value){
                $('input[name=rememberPassword]')[0].checked = true;
            }
        });

        mui('.mui-left').on('change','input[name=rememberPassword]',function(){
            var value = this.checked?true:false;
            if(!value){
                $('input[name=autoLogin]')[0].checked = false;
            }
        });
    }

    function validate(){
        if(doc.getElementById("userName").value == ""){
            mui.toast("请输入用户名。");
            return false;
        }
        if(doc.getElementById("password").value == ""){
            mui.toast("请输入密码。");
            return false;
        }
        return true;
    }

    function decrypt(word){
        var key = CryptoJS.enc.Utf8.parse("qwertyui87654321");
        var decrypt = CryptoJS.AES.decrypt(word, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
        return CryptoJS.enc.Utf8.stringify(decrypt).toString();
    }

    function encrypt(word){
        var key = CryptoJS.enc.Utf8.parse("qwertyui87654321");
        var srcs = CryptoJS.enc.Utf8.parse(word);
        var encrypted = CryptoJS.AES.encrypt(srcs, key, {mode:CryptoJS.mode.ECB,padding: CryptoJS.pad.Pkcs7});
        return encrypted.toString();
    }

    function loginByUserName(){
        var tempObj = {};
        tempObj.userName = doc.getElementById("userName").value;
        tempObj.password = encrypt(doc.getElementById("password").value);
		tempObj.deviceTypeID = deviceTypeID;
		tempObj.osID = os.isAndroid?2:(os.isPhone?1:0);
        var succ = function(data){
            $Utils.loading.close();
            if($("input[name=autoLogin]")[0].checked){
                $Utils.cookie.addCookie(window.location.host+"-mRememberName",tempObj.userName,30);
                $Utils.cookie.addCookie(window.location.host+"-mRememberWord",tempObj.password,30);
                $Utils.cookie.addCookie(window.location.host+"-mAutoLogin",'true',30);
            }else if(!$("input[name=autoLogin]")[0].checked && $("input[name=rememberPassword]")[0].checked){
                $Utils.cookie.addCookie(window.location.host+"-mRememberName",tempObj.userName,30);
                $Utils.cookie.addCookie(window.location.host+"-mRememberWord",tempObj.password,30);
                $Utils.cookie.deleteCookie(window.location.host+"-mAutoLogin");
            }else{
                $Utils.cookie.deleteCookie(window.location.host+"-mRememberName");
                $Utils.cookie.deleteCookie(window.location.host+"-mRememberWord");
                $Utils.cookie.deleteCookie(window.location.host+"-mAutoLogin");
            }
            $Utils.cookie.addCookie(window.location.host+"-mLoginStop",1,30);
            locationURL(data);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '登录');
        };
        logins.addItem(tempObj,true,succ,fail);
    }

    function locationURL(loginID){
		$Utils.cookie.addCookie(window.location.host+"-mLoginID",loginID);
		if(document.cookie == ""){
			var str = "浏览器阻止了cookie，请设置浏览器允许cookie！"
            mui.alert(str,"设置cookie");
		}else{
			window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/index.html";	
		}
	}

})(mui,window,document)