(function(mui,window,doc){
    var logins = new Logins();
    var organizationUsers = new OrganizationUsers();
    var userThemes = new UserThemes();
    var menus = new Menus();
    var favorites = new Favorites();
    var folders = new ReportFolders();
    var reports = new Reports();
    var selfAnalysis = new SelfAnalysis();
    var chartSamples = new ChartSamples();
    var linkShares = new LinkShares();
    var organizationSystemSettings = new OrganizationSystemSettings();
    var reportIDList = [];
    var backUrl = null;
    var backIsFirst = true;
    
    mui.init();

    if($Utils.cookie.getCookie(window.location.host+"-mLoginID") || location.href.indexOf("?mLoginID=") != -1){
        getLogin($Utils.cookie.getCookie(window.location.host+"-mLoginID") || location.href.split("?mLoginID=")[1]);
    }else{
        window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/login.html";
    }

    function getLogin(loginID){
        var succ = function(){
            if(logins.item(0).logouted == 1){
                window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/login.html";
            }
            $AppVars.token = logins.item(0).token;
            $AppVars.deviceTypeID = logins.item(0).deviceTypeID;
            getOrganizationUsers();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取登录信息');
        };
        logins.getItemByID(loginID,true,succ,fail);
    }

    function getOrganizationUsers(){
        var succ = function(){
            getUserTheme();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取组织用户');
		};
        organizationUsers.getItemsByUserID(logins.item(0).userID,false,succ,fail);
    }

    function getUserTheme(){
		var succ = function(){
            getSystemSettings();
		};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取用户主题');
		};

		userThemes.getThemeByUserID(logins.item(0).userID,false,succ,fail);
    }

    function getSystemSettings(){
        var succ = function(){
            $AppVars.queryTimeOut = organizationSystemSettings.item("queryTimeOut").systemSettingValue;
			initFind();
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
			$Utils.openWindow.failWindow("获取组织设置",errorStatus,msg);
		};
        organizationSystemSettings.getItems(false,succ,fail);
    }

    function initFind(){
        getMenus();
        getFavorites();
        getFolders();
        getReports();
        getSelfAnalysis();
        if(organizationUsers.item(0).organizationUserSettings.item("showChartSample").settingValue == 1){
            getChartSamples();
        }
        creatMainMenu();
        creatTree();
        initPage();
    }

    function getMenus(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取数据探索菜单列表');
		};
		menus.getItems(0,false,succ,fail);
    }

    function getFavorites(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取收藏列表');
		};
		favorites.getItems(logins.item(0).userID,false,succ,fail);
    }

    function getFolders(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取报表文件夹列表');
		};
		folders.getItems(false,succ,fail);
    }

    function getReports(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取报表列表');
		};
		reports.getItems(0,false,succ,fail);
    }

    function getSelfAnalysis(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取自助报表列表');
		};
		selfAnalysis.getItems(0,false,succ,fail);
    }

    function getChartSamples(){
        var succ = function(){};
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取图表样例列表');
		};
		chartSamples.getItems(false,succ,fail);
    }

    function creatMainMenu(){
		var str = "";
        for(var i = 0; i < menus.count; i++){
            if(menus.item(i).menuID != 51 && menus.item(i).menuID != 52 && menus.item(i).menuID != 53){
                if(menus.item(i).menuID == 4){
                    if(organizationUsers.item(0).organizationUserSettings.item("showChartSample").settingValue == 1){
                        str += "<li class='category' data-menu='"+menus.item(i).menuID+"' title="+menus.item(i).menuName+"><div class='clearfix menu'><i class='iconfont bda-menu"+menus.item(i).menuID+"'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div></li>";
                    }
                }else{
                    str += "<li class='category' data-menu='"+menus.item(i).menuID+"' title="+menus.item(i).menuName+"><div class='clearfix menu'><i class='iconfont bda-menu"+menus.item(i).menuID+"'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div></li>";
                }
            }
        }
		$("#offCanvasSideScroll .menu-list ul").html(str);
    }
    
    function creatTree(){
        $("#offCanvasSideScroll .menu-list > ul").children("li").each(function(){
			var elem = this;
			var serialNumber = $(this).attr("data-menu");
			if(serialNumber==1){
				creatMyFavoriteList(elem);
			}else if(serialNumber==2){
				creatFolderOrReport(elem);
			}else if(serialNumber==3){
				creatSelfAnalysis(elem);
			}else if(serialNumber==4 && organizationUsers.item(0).organizationUserSettings.item("showChartSample").settingValue == 1){
				creatChartSample(elem);
			}
		});
    }

    function creatMyFavoriteList(elem){
		var str = "";
		$(elem).append("<ul class='mui-hidden'></ul>");
        for(var i = 0; i < favorites.count; i++){
            str += "<li class='report'  data-index='"+favorites.item(i).reportID+"' title="+favorites.item(i).reportName+"><div><i class='iconfont bda-shilitubiao'></i><span>"+favorites.item(i).reportName+"</span></div></li>";
        }
		$(elem).find("ul").append(str);
    }

    function creatFolderOrReport(elem){
        $(elem).append("<ul class='mui-hidden'></ul>");
		creatFolders(elem);
		creatReport(elem);
    }

    function creatFolders(elem){
        var havefolders = [];
        for(var i = 0; i < reports.count; i++){
            var folderID = reports.item(i).folderID;
            while(folderID != -1 && havefolders.indexOf(folderID) == -1){
                havefolders.push(folderID);
                folderID = folders.item(folderID).folderParentID;
            }
        }

		for(var i = folders.count-1;i>=0;i--){
			if(havefolders.indexOf(folders.item(i).folderID) == -1){
				folders.remove(folders.item(i));
			}
        }
        var folderArr = setFolderTree();
        folderArr = folderArr[0].children?folderArr[0].children:[];
        loadFolders($(elem).children("ul"),folderArr);
    }

    function setFolderTree(){
        var tempArr = [];
        var hashTable = new HashTable();
        hashTable.add("-1",{name: "组织分析",folderID:"-1",folderParentID:"-1"});
        for(var i = 0; i < folders.count; i++){
            hashTable.add(folders.item(i).folderID,{name:folders.item(i).folderName,folderID:folders.item(i).folderID,folderParentID:folders.item(i).folderParentID});
        }
        for(var i = 0; i < folders.count; i++){
            var parentFolder = hashTable.getValue(folders.item(i).folderParentID);
            if(!parentFolder.children){
                parentFolder.children = [];
            }
            parentFolder.children.push(hashTable.getValue(folders.item(i).folderID));
        }
        tempArr.push(hashTable.getValue("-1"));

        return tempArr;
    }

    function loadFolders(elem,folderArr){
        for(var i = 0; i < folderArr.length; i++){
            var str = "<li class='folder folder-hide' data-folderid="+folderArr[i].folderID+"><div title="+folderArr[i].name+"><i class='iconfont bda-wenjianjia'></i><span>"+folderArr[i].name+"</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul class='mui-hidden'></ul></li>";
            $(elem).append(str);
            if(folderArr[i].children){
                createChildrenMenu(elem,folderArr[i].children);
            }
        }
    }

    function createChildrenMenu(elem,menuArr){
        for(var i = 0; i < menuArr.length; i++){
            var str = "<li class='folder folder-hide' data-folderid="+menuArr[i].folderID+"><div title="+menuArr[i].name+"><i class='iconfont bda-wenjianjia'></i><span>"+menuArr[i].name+"</span><i class='fr parent-li iconfont bda-xiangyou'></i></div><ul class='mui-hidden'></ul></li>";
            $(elem).find("li").each(function(){
                if($(this).attr("data-folderid") == menuArr[i].folderParentID){
                    $(this).children("ul").append(str);
                }
            });
            if(menuArr[i].children){
                createChildrenMenu(menuArr[i].children);
            }
        }
    }

    function creatReport(elem){
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).folderID == -1){
                var str = "";
                str = "<li class='report' data-index="+reports.item(i).reportID+"><div title="+reports.item(i).reportName+"><i class='iconfont bda-shilitubiao'></i><span>"+reports.item(i).reportName+"</span></div></li>"
                $(elem).children("ul").append(str);
            }
            if(reports.item(i).folderID != -1){
                var str = "";
                str = "<li class='report' data-index="+reports.item(i).reportID+"><div title="+reports.item(i).reportName+"><i class='iconfont bda-shilitubiao'></i><span>"+reports.item(i).reportName+"</span></div></li>"
                $(elem).find("li").each(function(){
                    if(reports.item(i).folderID == $(this).attr("data-folderID")){
                        $(this).children("ul").append(str);
                    }
                });
            }
        }
    }

    function creatSelfAnalysis(elem){
		var str = "";
        $(elem).append("<ul class='mui-hidden'></ul>");
        for(var i = 0; i < selfAnalysis.count; i++){
            str += "<li class='mui-table-view-cell mui-transitioning report selfAnalysis-li'  data-index='"+selfAnalysis.item(i).reportID+"'><div class='mui-slider-handle' title="+selfAnalysis.item(i).reportName+"><i class='iconfont bda-shilitubiao'></i>"+selfAnalysis.item(i).reportName+"</div><div class='mui-slider-right mui-disabled'><a class='mui-btn mui-btn-red'>删除</a></div></li>";
        }
		$(elem).find("ul").append(str);
	}
	
	function creatChartSample(elem){
		var str = "";
			
        $(elem).append("<ul class='mui-hidden'></ul>");
        for(var i = 0; i < chartSamples.count; i++){
            if(chartSamples.item(i).chartURL){
                str += "<li class='report' data-index='"+chartSamples.item(i).chartURL+"' title="+chartSamples.item(i).chartName+"><div><i class='iconfont bda-"+chartSamples.item(i).chartCode+"'></i>"+chartSamples.item(i).chartName+"</div></li>";
            }
        }
		$(elem).find("ul").append(str);
    }

    function initPage(){
        $Utils.loading.close();
        if(organizationUsers.item(0).organizationUserSettings.item("pageURI")){
            openReport(organizationUsers.item(0).organizationUserSettings.item("pageURI").settingValue || "home.html")
        }else{
            openReport("home.html");
        }
        if(location.href.indexOf("hideLogout=") != -1 && (location.href.split("hideLogout=")[1]).split("&")[0] == 1){
            $("#topPopover .mui-table-view li").each(function(){
                if($(this).attr("data-index") == 3){
                    $(this).remove();
                }
            });
        }
        initEvent();
    }

    function initEvent(){
        //主界面容器
        var offCanvasWrapper = mui('#offCanvasWrapper');
        var offCanvasInner = offCanvasWrapper[0].querySelector('.mui-inner-wrap');
        offCanvasInner.insertBefore(offCanvasSide, offCanvasInner.firstElementChild);
        //主界面和侧滑菜单界面均支持区域滚动；
        mui('#offCanvasSideScroll').scroll();
        mui('body').on('shown', '.mui-popover', function(e) {
            //console.log('shown', e.detail.id);//detail为当前popover元素
        });
        mui('body').on('hidden', '.mui-popover', function(e) {
            //console.log('hidden', e.detail.id);//detail为当前popover元素
        });
        treeEvent();

        $("#topPopover ul").on("tap","li",function(){
            var index = this.getAttribute("data-index");
            if(index == 0){
                openSelf();
            }
            if(index == 1){
                openPersonalization();
            }
            if(index == 2){
                openHelp();
            }
            if(index == 3){
                logout();
            }
            mui('#topPopover').popover("hide");
        });

        bottomButtonEvent();

        window.addEventListener("onorientationchange" in window ? "orientationchange" : "resize", function() {
            
                if(window.orientation === 180 || window.orientation === 0) {
                    //alert('竖屏状态!');
                    $("#offCanvasContentScroll").removeClass("refresh-status");
                    // setTimeout(function(){
                    var pageWidth = $("#offCanvasContentScroll").width();
                    var pageHeight = $("#offCanvasContentScroll").height();
                    var childWindow = $("#offCanvasContentScroll").find("iframe").eq(0)[0].contentWindow;
                    childWindow.showPortrait(pageHeight,pageWidth,1);
                    // },300);
                }
                if(window.orientation === 90 || window.orientation === -90) {
                    if(canBehorizontal()){
                        $("#offCanvasContentScroll").addClass("refresh-status");
                        var pageWidth = $("#offCanvasContentScroll").width();
                        var pageHeight = $("#offCanvasContentScroll").height();
                        var childWindow = $("#offCanvasContentScroll").find("iframe").eq(0)[0].contentWindow;
                        childWindow.showLandscape(pageHeight,pageWidth,1);
                    }else{
                        mui.toast('该报表为自定义布局，请使用竖屏浏览。',{ duration:'short', type:'div' }) 
                    }
                }
        }, false);
    }

    function canBehorizontal(){
        if(reportIDList.length){
            var reportID = reportIDList[reportIDList.length-1];
            if(reports.item(reportID)){
                if(reports.item(reportID).reportSettings.item("customLayoutForMobile") && reports.item(reportID).reportSettings.item("customLayoutForMobile").reportSettingValue == "1"){
                    return false;
                }else{
                    return true;
                }
            }else if(selfAnalysis.item(reportID)){
                if(selfAnalysis.item(reportID).reportSettings.item("customLayoutForMobile") && selfAnalysis.item(reportID).reportSettings.item("customLayoutForMobile").reportSettingValue == "1"){
                    return false;
                }else{
                    return true;
                }
            }
        }else{
            return true;
        }
    }

    function treeEvent(){
        $("#offCanvasSideScroll .menu-list > ul").on("tap","li div:first-child",function(){
            if(!$(this).parent("li").hasClass("report")){
                if($(this).siblings("ul").hasClass("mui-hidden")){
                    $(this).siblings("ul").removeClass("mui-hidden");
                    $(this).find(".bda-xiangyou").eq(0).removeClass("bda-xiangyou").addClass("bda-xiangxia");
                }else{
                    $(this).siblings("ul").addClass("mui-hidden");
                    $(this).find(".bda-xiangxia").eq(0).removeClass("bda-xiangxia").addClass("bda-xiangyou");
                }
            }else if($(this).parent("li").hasClass("report")){
                mui.swipeoutClose($(this).parent("li")[0]);
                mui('#offCanvasWrapper').offCanvas('close');
                openReport($(this).parent("li")[0].getAttribute("data-index"),this.innerText);
            }
        });

        var btnArray = ['确认', '取消'];
        $("#offCanvasSideScroll .menu-list > ul").on("tap",".mui-btn",function(e){
            var elem = this;
            var li = elem.parentNode.parentNode;
            var text = $(li).find(".mui-slider-handle").text();
            mui.confirm('是否删除报表 '+text+'？', '删除自助报表', btnArray, function(e) {
                if (e.index == 0) {
                    deleteSelfAnalysisReport($(li)[0].getAttribute("data-index"),li);
                } else {
                    mui.swipeoutClose(li);
                }
            });
        });
    }

    function deleteSelfAnalysisReport(reportID,li){
        $Utils.loading.open();
        var succ = function(){
            deleteSelfAnalysHtml(reportID);
            $Utils.loading.close();
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '删除自助报表');
            mui.swipeoutClose(li);
        }
        selfAnalysis.deleteItem(reportID,true,succ,fail);
    }

    function deleteSelfAnalysHtml(reportID){
        $("#offCanvasSideScroll .menu-list > ul > li").each(function(){
            $(this).find("li").each(function(){
                if($(this).attr("data-index")==reportID){
                    $(this).remove();
                }
            });
        });
    }

    function openReport(reportID,reportName){
        var reportName = "";
        if(reportID == "home.html"){
            reportName = "主页";
            $(".favorite,.share,.refresh").addClass("opacity");
        }else if(reportID.indexOf(".html") != -1){
            for(var i = 0; i < chartSamples.count; i++){
                if(chartSamples.item(i).chartURL == reportID){
                    reportName = chartSamples.item(i).chartName;
                }
            }
            $(".favorite,.share,.refresh").addClass("opacity");
        }else{
            if(reports.item(reportID)){
                reportName = reports.item(reportID).reportName;
                $(".favorite,.share,.refresh").removeClass("opacity");
            }else if(selfAnalysis.item(reportID)){
                reportName = selfAnalysis.item(reportID).reportName;
                $(".favorite,.share,.refresh").removeClass("opacity");
            }else{
                reportID = "home.html";
                reportName = "主页";
                $(".favorite,.share,.refresh").addClass("opacity");
            }
        }
        var url = "";
        if(reportID == "home.html"){
            url = $AppConstants.projectName + "/home.html";
        }else if(reportID.indexOf(".html") != -1){
            url = $AppConstants.hostName + $AppConstants.port + "/Report/" + reportID;
        }else{
            var parameters = "?token="+$AppVars.token+"&reportID="+reportID+"&deviceTypeID="+logins.item(0).deviceTypeID+"&themeID="+userThemes.item(0).themeID+"&queryTimeOut="+$AppVars.queryTimeOut;
            url = $AppConstants.hostName + $AppConstants.port + $AppURLs.jspPath + parameters;
        }
        reportIDList = [];
        reportIDList.push(reportID);
        $("#offCanvasContentScroll").html("");
        $("#offCanvasWrapper .mui-title").html(reportName);
        createAndLoadReport(url);
        changeFavoritesIcon(reportID);
    }

    function createAndLoadReport(url){
        var str = "<iframe name='right' class='rightMain"+reportIDList.length+"' frameborder='no' scrolling='auto' width='100%' height='100%' allowtransparency='true' src=''></iframe>";
        $("#offCanvasContentScroll").html(str);
        $("#offCanvasContentScroll").find(".rightMain"+reportIDList.length).attr("src",url);
    }

    function openSelf(){
        var url = "";
        if($AppVars.deviceTypeID == 0){
            url = $AppConstants.hostName + $AppConstants.port + "/app/selfAnalysis/selfAnalysis.jsp?token=" + $AppVars.token + "&deviceTypeID=0";
        }else if($AppVars.deviceTypeID == 1){
            url = $AppConstants.hostName + $AppConstants.port + "/app/selfAnalysis/selfAnalysisPC.jsp?token=" + $AppVars.token + "&deviceTypeID=1";
        }
        $(".selfAnalysis").show(200);
        $(".selfAnalysis .selfAnalysis-frame").attr("src",url);
    }

    function openPersonalization(){
        $(".personalization").show(200);
        $(".report-radio .mui-navigate-right").on("tap","",function(){
            $(".report-list").addClass("left-box");
        });
        loadReportList();

        $(".personalization .report-list .menu-list li").each(function(){
            if($(this).children("div").hasClass("mui-slider-handle")){
                $(this).removeClass().addClass("report selfAnalysis-li");
                $(this).children("div.mui-slider-right").remove();
            }
        });
        if(organizationUsers.item(0).organizationUserSettings.item("homePageType")){
            if(organizationUsers.item(0).organizationUserSettings.item("homePageType").settingValue == 0){
                $(".home-radio input").attr("checked","checked");
            }else if(organizationUsers.item(0).organizationUserSettings.item("homePageType").settingValue == 1){
                $(".report-radio input").attr("checked","checked");
                var reportName = setReportName(organizationUsers.item(0).organizationUserSettings.item("pageURI").settingValue);
                loadReportName(organizationUsers.item(0).organizationUserSettings.item("pageURI").settingValue,reportName);
            }
        }else{
            $(".home-radio input").attr("checked","checked");
        }
        if(organizationUsers.item(0).organizationUserSettings.item("showChartSample").settingValue == 1){
            $(".sample .mui-switch").addClass("mui-active");
        }

        $(".close-personalization").on("tap","",function(){
            $(".personalization").hide(200);
        });

        $(".preservation-personalization").on("tap","",function(){
            if(change()){
                savePersonalization();
            }else{
                var selectValue = null;
                for(var i = 0; i < $("input[name=reportName]").length; i++){
                    if($("input[name=reportName]").eq(i)[0].checked == true){
                        selectValue = $("input[name=reportName]").eq(i).val();
                    }
                }
                if(selectValue == 1 && !$(".report-radio .mui-navigate-right").attr("data-reportid")){
                    
                }else{
                    $(".personalization").hide(200);
                }
            }
        });
    }

    function change(){
        var selectValue = null;
        for(var i = 0; i < $("input[name=reportName]").length; i++){
            if($("input[name=reportName]").eq(i)[0].checked == true){
                selectValue = $("input[name=reportName]").eq(i).val();
            }
        }
        if(selectValue == 1 && !$(".report-radio .mui-navigate-right").attr("data-reportid")){
            mui.toast("请选择需要默认打开的报表。");
            return false;
        }
        var sampleNumber = $(".sample .mui-switch").hasClass("mui-active")?1:0;
        if(organizationUsers.item(0).organizationUserSettings.item("showChartSample").settingValue != sampleNumber){
            return true;
        }
        if(organizationUsers.item(0).organizationUserSettings.item("homePageType")){
            if(organizationUsers.item(0).organizationUserSettings.item("homePageType").settingValue != selectValue){
                return true;
            }
            if(organizationUsers.item(0).organizationUserSettings.item("homePageType").settingValue == 1 && organizationUsers.item(0).organizationUserSettings.item("pageURI").settingValue != $(".report-radio .mui-navigate-right").attr("data-reportid")){
                return true;
            }
        }
        return false;
    }

    function savePersonalization(){
        $Utils.loading.open();
        var selectValue = null;
        for(var i = 0; i < $("input[name=reportName]").length; i++){
            if($("input[name=reportName]").eq(i)[0].checked == true){
                selectValue = $("input[name=reportName]").eq(i).val();
            }
        }
        var tempArr = [];
        var tempObj = {};
        tempObj.settingKey = "homePageType";
        tempObj.settingValue = selectValue;
        tempArr.push(tempObj);
        tempObj = {};
        tempObj.settingKey = "pageURI";
        tempObj.settingValue = selectValue != 0?$(".report-radio .mui-navigate-right").attr("data-reportid"):"home.html";
        tempArr.push(tempObj);
        tempObj = {};
        tempObj.settingKey = "linkReportTarget";
        tempObj.settingValue = organizationUsers.item(0).organizationUserSettings.item("linkReportTarget").settingValue;
        tempArr.push(tempObj);
        tempObj = {};
        tempObj.settingKey = "showChartSample";
        tempObj.settingValue = $(".sample .mui-switch").hasClass("mui-active")?1:0;
        tempArr.push(tempObj);
        var succ = function(){
            $Utils.loading.close();
            $(".personalization").hide(200);
        };
		var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '修改个性化');
		};
        organizationUsers.item(0).organizationUserSettings.editItem(organizationUsers.item(0).organizationUserID,tempArr,true,succ,fail);
    }

    function setReportName(reportID){
        var reportName = "未找到可见报表。";
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).reportID == reportID){
                reportName = reports.item(i).reportName;
                break;
            }
        }
        for(var i = 0; i < selfAnalysis.count; i++){
            if(selfAnalysis.item(i).reportID == reportID){
                reportName = selfAnalysis.item(i).reportName;
                break;
            }
        }
        return reportName;
    }

    function loadReportList(){
        var str = "";
        for(var i = 0; i < menus.count; i++){
            if(menus.item(i).menuID == 2 || menus.item(i).menuID == 3){
                str += "<li class='category' data-menu='"+menus.item(i).menuID+"' title="+menus.item(i).menuName+"><div class='clearfix menu'><i class='iconfont bda-wenjianjia'></i><span>"+menus.item(i).menuName+"</span><i class='fr iconfont bda-xiangyou'></i></div></li>";
            }
        }
        $(".report-list-content .menu-list ul").html(str);
        
        $(".report-list-content .menu-list > ul").children("li").each(function(){
			var elem = this;
			var serialNumber = $(this).attr("data-menu");
			if(serialNumber==2){
				creatFolderOrReport(elem);
			}else if(serialNumber==3){
				creatSelfAnalysis(elem);
			}
        });

        bindSelectReportEvent();
    }

    function bindSelectReportEvent(){
        $(".report-list-content .menu-list > ul").on("tap","li",function(){
            if(!$(this).hasClass("report")){
                if($(this).children("ul").hasClass("mui-hidden")){
                    $(this).children("ul").removeClass("mui-hidden");
                    $(this).find(".bda-xiangyou").eq(0).removeClass("bda-xiangyou").addClass("bda-xiangxia");
                }else{
                    $(this).children("ul").addClass("mui-hidden");
                    $(this).find(".bda-xiangxia").eq(0).removeClass("bda-xiangxia").addClass("bda-xiangyou");
                }
            }else if($(this).hasClass("report")){
                if(!$(this).hasClass("selected")){
                    $(".report-list-content .menu-list > ul .selected").removeClass("selected");
                    $(this).addClass("selected");
                    $(".determine").removeClass("opacity");
                }
            }
        });

        $(".go-back").on("tap","",function(){
            $(".report-list").removeClass("left-box");
        });

        $(".determine").on("tap","",function(){
            if(!$(this).hasClass("opacity")){
                $(".personalization .report-list").removeClass("left-box");
                var reportID = $(".personalization .report-list-content .menu-list > ul .selected").attr("data-index");
                var reportName = $(".personalization .report-list-content .menu-list > ul .selected > div").text();
                loadReportName(reportID,reportName);
            }
        });
    }

    function loadReportName(reportID,reportName){
        $(".report-radio .mui-navigate-right").text(reportName);
        $(".report-radio .mui-navigate-right").attr("data-reportid",reportID);
    }

    function openHelp(){
        $(".help-page").show(200);
        var url = "";
        if($AppVars.deviceTypeID == 0){
            url = $AppConstants.hostName + $AppConstants.port + "/bdasystem/ifind_mobile_help/index.html";
        }else if($AppVars.deviceTypeID == 1){
            url = $AppConstants.hostName + $AppConstants.port + "/bdasystem/ifind_pad_help/index.html";
        }
        $(".help-page .help-frame").attr("src",url);

        $(".close-help").on("tap","",function(){
            $(".help-page").hide(200);
        });

        $(".help-back").on("tap","",function(){
            var url = "";
            if($AppVars.deviceTypeID == 0){
                url = $AppConstants.hostName + $AppConstants.port + "/bdasystem/ifind_mobile_help/index.html";
            }else if($AppVars.deviceTypeID == 1){
                url = $AppConstants.hostName + $AppConstants.port + "/bdasystem/ifind_pad_help/index.html";
            }
            backUrl = $(".help-page .help-frame")[0].contentWindow.location.href;
            if(backUrl == url){
                backIsFirst = false;
            }
            if(backIsFirst){
                $(".help-page .help-frame")[0].contentWindow.history.go(-1);
            }else{
                $(".help-page").hide(200);
            }
        });
    }

    function logout(){
        var succ = function(){
            $Utils.cookie.deleteCookie(window.location.host+"-mLoginStop");
            $Utils.cookie.deleteCookie(window.location.host+"-mLoginID");
            window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/login.html";
        };
		var fail = function(errorStatus,msg){
            $Utils.cookie.deleteCookie(window.location.host+"-mAutoLoginStop");
            window.location.href = $AppConstants.webHostName + $AppConstants.webPort + $AppConstants.projectName + "/login.html";
		};
        logins.deletItem(logins.item(0).loginID,true,succ,fail);
    }

    function bottomButtonEvent(){
        $(".favorite").on("tap","",function(){
            if(!$(this).hasClass("opacity")){
                var isFavorite = false;
                for(var i = 0; i < favorites.count; i++){
                    if(favorites.item(i).reportID == reportIDList[reportIDList.length - 1]){
                        isFavorite = true;
                    }
                }
                var report = checkCurrentReportByReportID(reportIDList[reportIDList.length - 1]);
                if(isFavorite){
                    cancelFavorite(reportIDList[reportIDList.length - 1]);
                }else{
                    addFavorite(report);
                }
            }
        });

        $(".refresh").on("tap","",function(){
            if(!$(this).hasClass("opacity")){
                $("#offCanvasContentScroll").addClass("refresh-status");
                var pageWidth = $("#offCanvasContentScroll").width();
                var pageHeight = $("#offCanvasContentScroll").height();
                var childWindow = $("#offCanvasContentScroll").find("iframe").eq(0)[0].contentWindow;
                childWindow.refresh(pageHeight,pageWidth,1);
            }
        });

        $(".back").on("tap","",function(){
            if(!$(this).hasClass("opacity")){
                reportIDList.pop();
                var reportID = reportIDList[reportIDList.length - 1];
                $("#offCanvasContentScroll").find("iframe").eq(0).remove();
                if(reportIDList.length == 1){
                    $(this).addClass("opacity");
                }

                var reportName = "";
                if(reports.item(reportID)){
                    reportName = reports.item(reportID).reportName;
                }
                if(selfAnalysis.item(reportID)){
                    reportName = selfAnalysis.item(reportID).reportName;
                }
                
                $("#offCanvasWrapper .mui-title").html(reportName);
            }
        });

        $(".share").on("tap","",function(){
            if(!$(this).hasClass("opacity")){
                $(".share-mobile").show(200);
                initMobileShare();
            }
        });
    }

    function checkCurrentReportByReportID(reportID){
        var report = {};
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).reportID == reportID){
                report = reports.item(i);
                break;
            }
        }
        for(var i = 0; i < selfAnalysis.count; i++){
            if(selfAnalysis.item(i).reportID == reportID){
                report = selfAnalysis.item(i);
                break;
            }
        }
        return report;
    }

    function cancelFavorite(reportID){
        var succ = function(){
            $Utils.loading.close();
            mui.toast("反收藏成功。");
            deleteMenuHtml(1,reportID);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '取消收藏');
        }
        favorites.deleteItem(logins.item(0).userID,reportID,true,succ,fail);
    }

    function addFavorite(report){
        var succ = function(){
            $Utils.loading.close();
            mui.toast("收藏成功。");
            addReportToFavoriteList(report);
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '收藏');
        }
        favorites.addItem(logins.item(0).userID,report,true,succ,fail);
    }

    function deleteMenuHtml(menuID,reportID){
        $("#offCanvasSideScroll .menu-list > ul > li").each(function(){
            if($(this).attr("data-menu")==menuID){
                $(this).find("li").each(function(){
                    if($(this).attr("data-index")==reportID){
                        $(this).remove();
                    }
                });
            }
        });
        changeFavoritesIcon(reportID);
    }

    function addReportToFavoriteList(report){
		$("#offCanvasSideScroll .menu-list > ul > li").each(function(){
			if($(this).attr("data-menu")==1){
				$(this).find("ul").prepend("<li class=report data-index="+report.reportID+"><div><i class='iconfont bda-shilitubiao'></i>"+report.reportName+"</div></li>");
			}
		});
		changeFavoritesIcon(report.reportID);
    }

    function changeFavoritesIcon(reportID){
        var isFavorite = false;
        for(var i = 0; i < favorites.count; i++){
            if(favorites.item(i).reportID == reportID){
                isFavorite = true;
                break;
            }
        }
        if(isFavorite){
            $(".favorite span").removeClass("bda-shoucang").addClass("bda-antiCollection");
            $(".favorite span").attr("title","取消收藏");
        }else{
            $(".favorite span").removeClass("bda-antiCollection").addClass("bda-shoucang");
            $(".favorite span").attr("title","收藏");
        }
        
    }

    function initMobileShare(){
        $(".mobile-password").val(randomWord(6));

        $(".mobile-share-type span").on("tap","",function(){
            if(!$(this).hasClass("cur-this")){
                $(this).addClass("cur-this").siblings("span").removeClass("cur-this");
            }
        });

        $(".create-share").on("tap","",function(){
            if(validateForm()){
                var shareObj = setMobileShare();
                getShareID(shareObj);
            }
        });

        $(".close").on("tap","",function(){
            $(".share-mobile").hide();
        });
    }

    function randomWord(min){
		var str = "",range = min,
			arr = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
		for(var i=0; i<range; i++){
			var pos = Math.round(Math.random() * (arr.length-1));
			str += arr[pos];
		}
		return str;
    }
    
    function validateForm(){
        if($("input[name=passwordCheck]").is(':checked') && ($(".mobile-password").val() == "")){
            mui.toast("设置密码时，密码不能为空。");
            return false;
        }
        if($("input[name=dateCheck]").is(':checked') && ($(".valid-date").val() == "")){
            mui.toast("设置有效期时，天数不能为空。");
            return false;
        }
        return true;
    }

    function setMobileShare(){
        var shareObj = {};
		var reportID = "";
        reportID = reportIDList[reportIDList.length-1];
        var childWindow = $("#offCanvasContentScroll").find("iframe").eq(0)[0].contentWindow;
        shareObj = childWindow.transmitReportView();
        return setMobileLinkShare(reportID,JSON.parse(shareObj));
    }

    function setMobileLinkShare(reportID,obj){
        var linkShare = {};
        linkShare.reportID = reportID;
        linkShare.shareType = Number($(".mobile-share-type span.cur-this").attr("data-type"));
		if(linkShare.shareType == 0){
			linkShare.reportView = obj.reportView;
		}
        linkShare.restrictDate = $("input[name=dateCheck]").is(':checked')?true:false;
        linkShare.shareDays = $("input[name=dateCheck]").is(':checked')?$(".valid-date").val():"";
        linkShare.needPassword = $("input[name=passwordCheck]").is(':checked')?true:false;
        linkShare.sharePassword = linkShare.needPassword?$(".mobile-password").val():"";
		linkShare.themeID = userThemes.item(0).themeID;
		linkShare.deviceTypeID = logins.item(0).deviceTypeID;
		linkShare.reportSettings = [
            {
                reportSettingKey: "scaleByScreenSize",
                reportSettingValue: obj.scaleByScreenSize
            },
            {
                reportSettingKey: "pageWidth",
                reportSettingValue: obj.pageWidth
            },
			{
				reportSettingKey: "pageHeight",
				reportSettingValue: obj.pageHeight
			},
			{
				reportSettingKey: "followDesignSize",
				reportSettingValue: obj.followDesignSize
			},
			{
				reportSettingKey: "reportName",
				reportSettingValue: obj.reportName
			}
        ];

        return linkShare;
    }

    function getShareID(linkShare){
        var shareUrl = "";
        var succ = function(shareID){
            shareUrl = $AppConstants.hostName + $AppConstants.port+"/Report/linkShares/"+shareID+"/reportJSP";
            $(".share-url").text(shareUrl);
        };
        var fail = function(XHR,textStatus){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取分享列表');
        };
        linkShares.addItem(linkShare,true,succ,fail);
    }

    function HashTable() {
        var size = 0;
        var entry = new Object();
        this.add = function (key, value) {
            if (!this.containsKey(key)) {
                size++;
            }
            entry[key] = value;
        }
        this.getValue = function (key) {
            return this.containsKey(key) ? entry[key] : null;
        }
        this.remove = function (key) {
            if (this.containsKey(key) && (delete entry[key])) {
                size--;
            }
        }
        this.containsKey = function (key) {
            return (key in entry);
        }
        this.containsValue = function (value) {
            for (var prop in entry) {
                if (entry[prop] == value) {
                    return true;
                }
            }
            return false;
        }
        this.getValues = function () {
            var values = new Array();
            for (var prop in entry) {
                values.push(entry[prop]);
            }
            return values;
        }
        this.getKeys = function () {
            var keys = new Array();
            for (var prop in entry) {
                keys.push(prop);
            }
            return keys;
        }
        this.getSize = function () {
            return size;
        }
        this.clear = function () {
            size = 0;
            entry = new Object();
        }
    }

    window.closeFilter = function(){
        $("#offCanvasContentScroll").removeClass("refresh-status");
    };

    window.linkReport = function(url){
        var reportID = (url.split("&reportID=")[1]).split("&")[0];
        reportIDList.push(reportID);
        var str = "<iframe name='right' class='rightMain"+reportIDList.length+"' frameborder='no' scrolling='auto' width='100%' height='100%' allowtransparency='true' src=''></iframe>";
        $("#offCanvasContentScroll").prepend(str);
        $("#offCanvasContentScroll").find(".rightMain"+reportIDList.length).attr("src",url);
        reviseReportName(reportID);
        changeFavoritesIcon(reportID);
        if(reportIDList.length > 1 && $(".back").hasClass("opacity")){
            $(".back").removeClass("opacity");
        }
    };

    function reviseReportName(reportID){
		var isExistence = false;
        for(var i = 0; i < reports.count; i++){
            if(reports.item(i).reportID == reportID){
                $("#offCanvasWrapper .mui-title").text(reports.item(i).reportName);
                $("#offCanvasWrapper .mui-title").attr("title",reports.item(i).reportName);
                isExistence = true;
                break;
            }
        }

		if(isExistence){
			return;
		}
        
        var report = new Report();
		var succ = function(){
			$("#offCanvasWrapper .mui-title").text(report.reportName);
            $("#offCanvasWrapper .mui-title").attr("title",report.reportName);
		};
		var fail = function(errorStatus,msg){
			$Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取报表名称');
		};
		report.getItemByID(reportID,true,succ,fail);
    }
    
    window.onCreatedSelfAnalysis = function(reportID,reportName){
        if(reportID){
            getAddSelfAnalysisReport(reportID,reportName);
        }
        $(".selfAnalysis").hide(200);
    };

    function getAddSelfAnalysisReport(reportID,reportName){
        var report = new Report();
        var succ = function(){
            selfAnalysis.add(report);
            openReport(reportID,reportName);
            $("#offCanvasSideScroll .menu-list li").each(function(){
				if($(this).attr("data-menu") == 3){
                    $(this).find("ul").prepend("<li class='mui-table-view-cell mui-transitioning report selfAnalysis-li'  data-index='"+reportID+"'><div class='mui-slider-handle' title="+reportName+"><i class='iconfont bda-shilitubiao'></i>"+reportName+"</div><div class='mui-slider-right mui-disabled'><a class='mui-btn mui-btn-red'>删除</a></div></li>");
				}
            });
        };
        var fail = function(errorStatus,msg){
            $Utils.loading.close();
            mui.alert(msg?(errorStatus+'# '+msg):errorStatus, '获取新增自助报表');
        };
        report.getItemByID(reportID,true,succ,fail);
    }

})(mui,window,document);