(function(window,$,undefined){
    var $SELF = {
        loading:{},                    /*loading界面*/
        message:{},                    /*信息提示框*/
        request:{},                    /*http请求*/
       	formatString:{},
        basePath: "",
        token: "",
        osID: "",
        deviceTypeID: "",
        titleBarColor: "",
        businessModelPath: "/BusinessModel/businessModels",
        reportsPath: "/Report/reports",
        relationModelsPath: "/BusinessModel/relationModels",
        tableModelsPath: "/BusinessModel/tableModels",
        sqlModelsPath: "/BusinessModel/sqlModels",
        excelModelsPath: "/BusinessModel/excelModels",
        chartsPath: "/Report/charts"
    };
    
    $.extend($SELF.request,{
        publicRequest:function(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback){
            $.ajax({
                type: requestType,
                url: url ,
                dataType: 'json',
                timeout: 63000,
                traditional:true,
                headers: headObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                /*请求成功回调*/
                success: function(data,status,request){
                	if(request.readyState == 4){
                    	succCallback(data,status,request);
                	}
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        isJson: function(str){
            if (typeof str == 'string') {
                try {
                    var obj=JSON.parse(str);
                    if(typeof obj == 'object' && obj ){
                        return true;
                    }else{
                        return false;
                    }

                } catch(e) {
                    return false;
                }
            }
        }
    });

    /*loading界面*/
    $.extend($SELF.loading,{
        open:function(){
            $('.page-loading').show();
        },
        close:function(){
            $('.page-loading').hide();
        }
    });

    /*信息提示框*/
    $.extend($SELF.message,{
        open: function (str) {
            $('.page-msg').css('display','block').find('.page-msg-content div p').html(str||'');
            var msgCurrentHeight =  $('.page-msg .page-msg-content div p').height();
            var msgMaxHeight = Math.floor($(window).height() * 0.8) - 18 - 45;/*18为上内边距 45为下内边距*/
            if(msgCurrentHeight>msgMaxHeight){
                $('.page-msg-content div').css({
                    'height': msgMaxHeight,
                    'overflow-y':'auto'
                });
            }
        },
        close: function () {
            $('.page-msg').css('display','none').find('.page-msg-content div p').html('');
            $('.page-msg-content div').removeAttr('style');
        }
    });
    /*关闭信息提示框事件*/
    $('.page-msg button').click($SELF.message.close);
    $('.page-msg span').click($SELF.message.close);

    $SELF.converRgbToArgb = function (a,r,g,b){
        var color = ((a << 24)|(r << 16)|(g << 8)|b);
        return color;
    }
    
    $SELF.newGuid = function (){
	    var guid = "";
	    for (var i = 1; i <= 32; i++){
	      var n = Math.floor(Math.random()*16.0).toString(16);
	      guid +=   n;
	      if((i==8)||(i==12)||(i==16)||(i==20))
	        guid += "-";
	    }
	    return guid;    
	}
    
    $SELF.getOperationString = function(operation){
		var str = "";
		switch (parseInt(operation)){
			case 0:
				str = "等于";
				break;
			case 1:
				str = "不等于";
				break;
			case 2:
				str = "大于";
				break;
			case 3:
				str = "大于等于";
				break;
			case 4:
				str = "小于";
				break;
			case 5:
				str = "小于等于";
				break;
			case 6:
				str = "属于列表";
				break;
			case 7:
				str = "不属于列表";
				break;
			case 8:
				str = "匹配模式";
				break;
			case 9:
				str = "不同于模式";
				break;
		}
		return str;
	}
    
    $SELF.chartIcon = function (chartID){
    	switch (chartID){
    		case 0 : return 'tile';
            case 1 : return 'verticalTable';
            case 2 : return 'horizontalTable';
            case 3 : return 'pivotTable';
            case 4 : return 'histogram';
            case 5 : return 'accumulateHistogram';
            case 6 : return 'percentHistogram';
            case 7 : return 'barChart';
            case 8 : return 'accumulateBarChart';
            case 9 : return 'percentBarChart';
            case 10 : return 'lineGraph';
            case 11 : return 'areaGraph';
            case 12 : return 'histogramLine';
            case 13 : return 'pieChart';
            case 14 : return 'doughnut';
            case 15 : return 'gauge';
            case 16 : return 'scatterPlot';
            case 17 : return 'bubbleChart';
            case 18 : return 'waterfallPlot';
            case 19 : return 'radarMap';
            case 20 : return '';
            case 21 : return 'funnelPlot';
            case 22 : return '';
            case 23 : return '';
            case 24 : return 'accumulateHistogramLine';
            case 25 : return 'percentHistogramLine';
            case 26 : return '';
            case 27 : return 'scalableLineGraph';
            case 28 : return 'adjustableLineGraph';
            case 29 : return 'variablePie';
            case 30 : return 'percentDoughnut';
            case 31 : return '';
            case 32 : return '';
            case 33 : return '';
            case 34 : return 'pictureBox';
            case 35 : return 'wordCloud';
            case 36 : return 'waterWaveChart';
            case 42 : return 'treeMap';
    	}
    }
    
    $SELF.chartLabel = function (chartID){
    	switch (chartID){
    		case 0 : return [12];
            case 1 : return [11];
            case 2 : return [11];
            case 3 : return [8,9,10];
            case 4 : return [0,1,2];
            case 5 : return [0,1,2];
            case 6 : return [0,1,2];
            case 7 : return [0,1,2];
            case 8 : return [0,1,2];
            case 9 : return [0,1,2];
            case 10 : return [0,1,2];
            case 11 : return [0,1,2];
            case 12 : return [0,3,4];
            case 13 : return [0,2];
            case 14 : return [0,2];
            case 15 : return '';
            case 16 : return [0,1,5,6];
            case 17 : return [0,1,5,6,7];
            case 18 : return [0,2];
            case 19 : return [0,1,2];
            case 20 : return '';
            case 21 : return [2];
            case 22 : return '';
            case 23 : return '';
            case 24 : return [0,1,3,4];
            case 25 : return [0,1,3,4];
            case 26 : return '';
            case 27 : return [0,2];
            case 28 : return [0,2];
            case 29 : return [0,3,4];
            case 30 : return '';
            case 31 : return '';
            case 34 : return '';
            case 35 : return [0,2];
            case 36 : return [2];
            case 42 : return [0,1,2];
    	}
    }
    
    $SELF.inherit = function(p){
    	if(p==null){
    		throw TypeError();
    	}
    	if(Object.create){
    		return Object.create(p);
    	}
    	var t = typeof p;
    	if(t!=="object" && t!=="function"){
    		throw TypeError();
    	}
    	function f(){};
    	f.prototype = p;
    	return new f();
    }
    
    $.extend($SELF.formatString,{
        date : function(type,date){
            if (typeof date == 'string') return date;
            if (!date)return date;
            if (type == ''){
                return this.formatDay('YYYY-MM-dd',date);
            }else {
                if (type.indexOf('YYYY')!=-1&&type.indexOf('mm')!=-1){
                    var hourIndex = type.indexOf('h');
                    return this.formatDay(type.slice(0,hourIndex),date)+this.formatTime(type.slice(hourIndex),date);
                }else{
                    if (type.indexOf('YYYY')!=-1){
                        return this.formatDay(type,date);
                    }else if (type.indexOf('mm')!=-1){
                        return this.formatTime(type,date);
                    }
                }
            }
            return date;
        },
        formatDay:function(type,date){
            var z ={
                Y:date.getFullYear(),
                M:date.getMonth()+1,
                d:date.getDate()
            };
            return type.replace(/(Y+|M+|d+)/g,function(v) {
                return ((v.length>1?"0":"")+z[v.slice(-1)]).slice(-(v.length>2?v.length:2))
            });
        },
        formatTime:function(type,date){
            var z ={
                H:date.getHours(),
                h:date.getHours()%12,
                m:date.getMinutes(),
                s:date.getSeconds(),
                aa:['AM','PM']
            };
            return type.replace(/(H+|h+|m+|s+|aa)/g,function(v) {
                if (v=='aa'){
                    return z.aa[z.H>=12?1:0]
                }else{
                    return ((v.length>1?"0":"")+z[v.slice(-1)]).slice(-(v.length>2?v.length:2));
                }
            });
        }
    });
    
    $SELF.Base64 = function(){

        /* private property*/
        var _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

        /* public method for encoding*/
        this.encode = function (input) {
            var output = "";
            var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
            var i = 0;
            input = _utf8_encode(input);
            while (i < input.length) {
                chr1 = input.charCodeAt(i++);
                chr2 = input.charCodeAt(i++);
                chr3 = input.charCodeAt(i++);
                enc1 = chr1 >> 2;
                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                enc4 = chr3 & 63;
                if (isNaN(chr2)) {
                    enc3 = enc4 = 64;
                } else if (isNaN(chr3)) {
                    enc4 = 64;
                }
                output = output +
                    _keyStr.charAt(enc1) + _keyStr.charAt(enc2) +
                    _keyStr.charAt(enc3) + _keyStr.charAt(enc4);
            }
            return output;
        };

        /* public method for decoding*/
        this.decode = function (input) {
            var output = "";
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = _keyStr.indexOf(input.charAt(i++));
                enc2 = _keyStr.indexOf(input.charAt(i++));
                enc3 = _keyStr.indexOf(input.charAt(i++));
                enc4 = _keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
            output = _utf8_decode(output);
            return output;
        };

        /* private method for UTF-8 encoding*/
        function _utf8_encode(string) {
            string = string.replace(/\r\n/g,"\n");
            var utftext = "";
            for (var n = 0; n < string.length; n++) {
                var c = string.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                } else if((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                } else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }

            }
            return utftext;
        }

        /* private method for UTF-8 decoding*/
        function _utf8_decode(utftext) {
            var string = "";
            var i = 0;
            var c = c1 = c2 = 0;
            while ( i < utftext.length ) {
                c = utftext.charCodeAt(i);
                if (c < 128) {
                    string += String.fromCharCode(c);
                    i++;
                } else if((c > 191) && (c < 224)) {
                    c2 = utftext.charCodeAt(i+1);
                    string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                    i += 2;
                } else {
                    c2 = utftext.charCodeAt(i+1);
                    c3 = utftext.charCodeAt(i+2);
                    string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                    i += 3;
                }
            }
            return string;
        }
    };
    
    window.$SELF = $SELF;

})(window,$);