function Report(options){
	this.reportID = options?options.reportID:"";
	this.reportName = options?options.reportName:"";
	this.folderID = -1;
	this.createUserID = options?options.createUserID:"";
	this.createUserName = options?options.createUserName:"";
	this.createDate = options?options.createDate:"";
	this.createSource = 1;
	this.lastModifyUserID = options?options.lastModifyUserID:"";
	this.lastModifyUserName = options?options.lastModifyUserName:"";
	this.lastModifyDate = options?options.lastModifyDate:"";
	this.reportDesign = new ReportDesign();
	this.reportSettings = new ReportSettings();
}

function Reports(){}

Reports.prototype = $SELF.inherit(Array.prototype);
Reports.prototype.constructor = Reports;
Reports.prototype.addItem = function(report,succ,fail){
    var requestType = "post";
    var url = $SELF.basePath + $SELF.reportsPath;
    var headObj = {};
    headObj["Authorization"] = $SELF.token;
    headObj["Content-Type"] = "application/json; charset=utf-8";
    //headObj["Access-Control-Allow-Origin"] = "*";
    //headObj["Access-Control-Allow-Methods"] = "GET, POST, PATCH, PUT, DELETE, OPTIONS";
    var obj = JSON.stringify(this.createReportJSON(report));
    var asyncOrSync = true;
    var succCallback = function(data,status,request){
        if(request.status == 201){
        	var reportID = request.getResponseHeader('location').split('/reports/')[1]
            succ(reportID);
        }else{
            fail("未知错误。");
        }
    }
    var failCallback = function(XHR,textStatus){
        if(!window.navigator.onLine){
            fail("网络连接不可用。");
        }else if(XHR.responseText){
            if(!$SELF.request.isJson(XHR.responseText)){
                fail(XHR.status+"#: "+XHR.responseText);
            }else{
                fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
            }
        }else{
            fail("未知错误。");
        }
    }
    $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
}
Reports.prototype.createReportJSON = function(report){
	var reportObject = {};
	reportObject.reportID = report.reportID;
	reportObject.reportName = report.reportName;
    reportObject.folderID = report.folderID;
    reportObject.createUserID = report.createUserID; 
    reportObject.createUserName = report.createUserName; 
    reportObject.createDate = report.createDate;
    reportObject.createSource = report.createSource;
    reportObject.lastModifyUserID = report.lastModifyUserID;
    reportObject.lastModifyUserName = report.lastModifyUserName;
    reportObject.lastModifyDate = report.lastModifyDate;
    
    reportObject.reportDesign = createReportDesignJSON(report.reportDesign);
    
    reportObject.reportSettings = [];
    $.each(report.reportSettings, function(i) {
    	reportObject.reportSettings.push(report.reportSettings[i]);
    });
    
    return reportObject;
}

function createReportDesignJSON(reportDesign){
	var reportDesignObject = {};
	
	reportDesignObject.pcPages = [];
	$.each(reportDesign.pcPages, function(i) {
		reportDesignObject.pcPages.push(reportDesign.pcPages[i]);
	});
	
	reportDesignObject.padPages = [];
	$.each(reportDesign.padPages, function(i) {
		reportDesignObject.padPages.push(reportDesign.padPages[i]);
	});
	
	reportDesignObject.mobilePages = [];
	$.each(reportDesign.mobilePages, function(i) {
		reportDesignObject.mobilePages.push(reportDesign.mobilePages[i]);
	});
	
	reportDesignObject.chartBlocks = [];
	$.each(reportDesign.chartBlocks, function(i) {
		reportDesignObject.chartBlocks.push(createChartBlockJSON(reportDesign.chartBlocks[i]));
	});
	
	reportDesignObject.verticalTableBlocks = [];
	$.each(reportDesign.verticalTableBlocks, function(i) {
		reportDesignObject.verticalTableBlocks.push(createTableBlockJSON(reportDesign.verticalTableBlocks[i]));
	});

    reportDesignObject.horizontalTableBlocks = [];
    $.each(reportDesign.horizontalTableBlocks, function(i) {
        reportDesignObject.horizontalTableBlocks.push(createHorizontalTableBlockJSON(reportDesign.horizontalTableBlocks[i]));
    });
	
	reportDesignObject.pivotTableBlocks = [];
	$.each(reportDesign.pivotTableBlocks, function(i) {
		reportDesignObject.pivotTableBlocks.push(createPivotTableBlockJSON(reportDesign.pivotTableBlocks[i]));
	});
	
	reportDesignObject.tileBlocks = [];
	$.each(reportDesign.tileBlocks, function(i) {
		reportDesignObject.tileBlocks.push(createTileBlockJSON(reportDesign.tileBlocks[i]));
	});
	
	reportDesignObject.gaugeBlocks = [];
    reportDesignObject.mapBlocks = [];
    reportDesignObject.labelBlocks = [];
    
    reportDesignObject.queries = [];
    $.each(reportDesign.queries, function(i) {
    	reportDesignObject.queries.push(createQueryJSON(reportDesign.queries[i]));
    });
    
    reportDesignObject.selects = [];
    
    reportDesignObject.dataObjects = [];
    $.each(reportDesign.dataObjects, function(i) {
    	reportDesignObject.dataObjects.push(createDataObjectJson(reportDesign.dataObjects[i]));
    });
    
    return reportDesignObject;
}

function createChartBlockJSON(chartBlock){
	var chartBlockObject = {};
	chartBlockObject.blockID = chartBlock.blockID;
    chartBlockObject.blockName = chartBlock.blockName;
    chartBlockObject.title = chartBlock.title;
    chartBlockObject.titleTextBox = chartBlock.titleTextBox;
    chartBlockObject.subtitle = chartBlock.subtitle;
    chartBlockObject.subtitleTextBox = chartBlock.subtitleTextBox;
    chartBlockObject.remark = chartBlock.remark;
    chartBlockObject.remarkTextBox = chartBlock.remarkTextBox;
    chartBlockObject.queryIDs = chartBlock.queryIDs;
    chartBlockObject.chartID = chartBlock.chartID;
    chartBlockObject.blockFilters = chartBlock.blockFilters;
    chartBlockObject.blockSort = chartBlock.blockSort;
    chartBlockObject.blockRank = chartBlock.blockRank;
    chartBlockObject.blockLayouts = createBlockLayoutsJSON(chartBlock.blockLayouts);
    
    chartBlockObject.primaryDimension = chartBlock.primaryDimension;
    chartBlockObject.groupDimension = chartBlock.groupDimension;
    chartBlockObject.y1Measures = createMeasuresJSON(chartBlock.y1Measures);
    chartBlockObject.y1FormatString = chartBlock.y1FormatString;
    chartBlockObject.y2Measures = createMeasuresJSON(chartBlock.y2Measures);
    chartBlockObject.y2FormatString = chartBlock.y2FormatString;
    chartBlockObject.y3Measures = createMeasuresJSON(chartBlock.y3Measures);
    chartBlockObject.y3FormatString = chartBlock.y3FormatString;
    chartBlockObject.legendShow = chartBlock.legendShow;
    chartBlockObject.legendPosition = chartBlock.legendPosition;
    chartBlockObject.dataShow = chartBlock.dataShow;
    chartBlockObject.dataHoverShow = chartBlock.dataHoverShow;
    chartBlockObject.axisLabelShow = chartBlock.axisLabelShow;
    chartBlockObject.reportLink = chartBlock.reportLink;
    chartBlockObject.dataLabel = chartBlock.dataLabel;
    chartBlockObject.xScaleLineWidth = chartBlock.xScaleLineWidth;
    chartBlockObject.showTickValue = chartBlock.showTickValue;
    chartBlockObject.showToolButtons = true;

    return chartBlockObject;
}

function createBlockLayoutsJSON(blockLayouts){
	var blockLayoutsObject = [];
	$.each(blockLayouts, function(i) {
		blockLayoutsObject.push(blockLayouts[i]);
	});
	
	return blockLayoutsObject;
}

function createMeasuresJSON(measures){
	var measureObject = [];
	$.each(measures, function(i) {
		measureObject.push(measures[i]);
	});
	
	return measureObject;
}

function createTableBlockJSON(tableBlock){
	var tableBlockObject = {};
	tableBlockObject.blockID = tableBlock.blockID;
    tableBlockObject.blockName = tableBlock.blockName;
    tableBlockObject.title = tableBlock.title;
    tableBlockObject.titleTextBox = tableBlock.titleTextBox;
    tableBlockObject.subtitle = tableBlock.subtitle;
    tableBlockObject.subtitleTextBox = tableBlock.subtitleTextBox;
    tableBlockObject.remark = tableBlock.remark;
    tableBlockObject.remarkTextBox = tableBlock.remarkTextBox;
    tableBlockObject.queryIDs = tableBlock.queryIDs;
    tableBlockObject.chartID = tableBlock.chartID;
    tableBlockObject.blockFilters = tableBlock.blockFilters;
    tableBlockObject.blockSort = tableBlock.blockSort;
    tableBlockObject.blockRank = tableBlock.blockRank;
    tableBlockObject.blockLayouts = createBlockLayoutsJSON(tableBlock.blockLayouts);
    tableBlockObject.tableHead = {};
    tableBlockObject.tableHead.rowID = tableBlock.tableHead.rowID;
    tableBlockObject.tableHead.tableRows = createTableRowsJSON(tableBlock.tableHead.tableRows);
    
    tableBlockObject.tableBody = {};
    tableBlockObject.tableBody.rowID = tableBlock.tableBody.rowID;
    tableBlockObject.tableBody.tableRows = createTableRowsJSON(tableBlock.tableBody.tableRows);
    
    tableBlockObject.tableFoot = {};
    tableBlockObject.tableFoot.rowID = tableBlock.tableFoot.rowID;
    tableBlockObject.tableFoot.tableRows = createTableRowsJSON(tableBlock.tableFoot.tableRows);
    
    tableBlockObject.tableWarnings = [];
    tableBlockObject.autoMergeDimensionCells = tableBlock.autoMergeDimensionCells;
    tableBlockObject.notShowBorderOfDetailTableCell = tableBlock.notShowBorderOfDetailTableCell;
    tableBlockObject.tBodyScrolling = tableBlock.tBodyScrolling;
    tableBlockObject.scrollTimePerLine = tableBlock.scrollTimePerLine;
    tableBlockObject.headHeight = tableBlock.headHeight;
    tableBlockObject.bodyHeight = tableBlock.bodyHeight;
    tableBlockObject.footHeight = tableBlock.footHeight;
    tableBlockObject.showToolButtons = true;

    return tableBlockObject;
}

function createTableRowsJSON(tableRows){
	var tableRowsObject = [];
	$.each(tableRows, function(i) {
		var obj = {};
		obj.rowID = tableRows[i].rowID;
		obj.tableCells = createTableCellsJSON(tableRows[i].tableCells);
		
		tableRowsObject.push(obj);
	});
	
	return tableRowsObject;
}

function createTableCellsJSON(tableCells){
	var tableCellsObject = [];
	$.each(tableCells, function(i) {
		tableCellsObject.push(tableCells[i]);
	});
	
	return tableCellsObject;
}

function createHorizontalTableBlockJSON(horizontalTableBlock){
    var tableBlockObject = {};
    tableBlockObject.blockID = horizontalTableBlock.blockID;
    tableBlockObject.blockName = horizontalTableBlock.blockName;
    tableBlockObject.title = horizontalTableBlock.title;
    tableBlockObject.titleTextBox = horizontalTableBlock.titleTextBox;
    tableBlockObject.subtitle = horizontalTableBlock.subtitle;
    tableBlockObject.subtitleTextBox = horizontalTableBlock.subtitleTextBox;
    tableBlockObject.remark = horizontalTableBlock.remark;
    tableBlockObject.remarkTextBox = horizontalTableBlock.remarkTextBox;
    tableBlockObject.queryIDs = horizontalTableBlock.queryIDs;
    tableBlockObject.chartID = horizontalTableBlock.chartID;
    tableBlockObject.blockFilters = horizontalTableBlock.blockFilters;
    tableBlockObject.blockSort = horizontalTableBlock.blockSort;
    tableBlockObject.blockRank = horizontalTableBlock.blockRank;
    tableBlockObject.blockLayouts = createBlockLayoutsJSON(horizontalTableBlock.blockLayouts);
    tableBlockObject.tableHead = {};
    tableBlockObject.tableHead.tableColumns = createTableColumnsJSON(horizontalTableBlock.tableHead.tableColumns);

    tableBlockObject.tableBody = {};
    tableBlockObject.tableBody.tableColumns = createTableColumnsJSON(horizontalTableBlock.tableBody.tableColumns);

    tableBlockObject.tableFoot = {};
    tableBlockObject.tableFoot.tableColumns = createTableColumnsJSON(horizontalTableBlock.tableFoot.tableColumns);

    tableBlockObject.tableWarnings = [];
    tableBlockObject.cellHeight = horizontalTableBlock.cellHeight;
    tableBlockObject.wordWrap = horizontalTableBlock.wordWrap;
    tableBlockObject.notShowBorderOfTableCell = horizontalTableBlock.notShowBorderOfTableCell;
    tableBlockObject.showToolButtons = true;

    return tableBlockObject;
}

function createTableColumnsJSON(tableColumns){
    var tableColumnsObject = [];
    $.each(tableColumns, function(i) {
        var obj = {};
        obj.columnIndex = tableColumns[i].columnIndex;
        obj.tableCells = createTableCellsJSON(tableColumns[i].tableCells);

        tableColumnsObject.push(obj);
    });

    return tableColumnsObject;
}

function createPivotTableBlockJSON(pivotTableBlock){
	var pivotTableBlockObject = {};
	pivotTableBlockObject.blockID = pivotTableBlock.blockID;
    pivotTableBlockObject.blockName = pivotTableBlock.blockName;
    pivotTableBlockObject.title = pivotTableBlock.title;
    pivotTableBlockObject.titleTextBox = pivotTableBlock.titleTextBox;
    pivotTableBlockObject.subtitle = pivotTableBlock.subtitle;
    pivotTableBlockObject.subtitleTextBox = pivotTableBlock.subtitleTextBox;
    pivotTableBlockObject.remark = pivotTableBlock.remark;
    pivotTableBlockObject.remarkTextBox = pivotTableBlock.remarkTextBox;
    pivotTableBlockObject.queryIDs = pivotTableBlock.queryIDs;
    pivotTableBlockObject.chartID = pivotTableBlock.chartID;
    pivotTableBlockObject.blockFilters = pivotTableBlock.blockFilters;
    pivotTableBlockObject.blockSort = pivotTableBlock.blockSort;
    pivotTableBlockObject.blockRank = pivotTableBlock.blockRank;
    pivotTableBlockObject.blockLayouts = createBlockLayoutsJSON(pivotTableBlock.blockLayouts);
    
    pivotTableBlockObject.rowDimensions = creatRowDimensionsJSON(pivotTableBlock.rowDimensions);
    pivotTableBlockObject.columnDimensions = creatColumnDimensionsJSON(pivotTableBlock.columnDimensions);
    pivotTableBlockObject.pivotMeasures = creatPivotMeasuresJSON(pivotTableBlock.pivotMeasures);
    pivotTableBlockObject.rowSubtotal = pivotTableBlock.rowSubtotal;
    pivotTableBlockObject.rowTotal = pivotTableBlock.rowTotal;
    pivotTableBlockObject.columnSubtotal = pivotTableBlock.columnSubtotal;
    pivotTableBlockObject.columnTotal = pivotTableBlock.columnTotal;
    pivotTableBlockObject.showCrossTableHead = pivotTableBlock.showCrossTableHead;
    pivotTableBlockObject.totalBackgroundColor = pivotTableBlock.totalBackgroundColor;
    pivotTableBlockObject.totalColor = pivotTableBlock.totalColor;
    pivotTableBlockObject.totalFont = pivotTableBlock.totalFont;
    pivotTableBlockObject.tableHeadBackgroundColor = pivotTableBlock.tableHeadBackgroundColor;
    pivotTableBlockObject.tableHeadColor = pivotTableBlock.tableHeadColor;
    pivotTableBlockObject.tableHeadFont = pivotTableBlock.tableHeadFont;
    pivotTableBlockObject.showToolButtons = true;
    
    return pivotTableBlockObject;
}

function creatRowDimensionsJSON(rowDimensions){
	var rowDimensionsObject = [];
	$.each(rowDimensions, function(i) {
		rowDimensionsObject.push(rowDimensions[i]);
	});
	
	return rowDimensionsObject;
}

function creatColumnDimensionsJSON(columnDimensions){
	var columnDimensionsObject = [];
	$.each(columnDimensions, function(i) {
		columnDimensionsObject.push(columnDimensions[i]);
	});
	
	return columnDimensionsObject;
}

function creatPivotMeasuresJSON(pivotMeasures){
	var pivotMeasuresObject = [];
	$.each(pivotMeasures, function(i) {
		pivotMeasuresObject.push(pivotMeasures[i]);
	});
	
	return pivotMeasuresObject;
}

function createTileBlockJSON(tileBlock){
	var tileBlockObject = {};
	tileBlockObject.blockID = tileBlock.blockID;
    tileBlockObject.blockName = tileBlock.blockName;
    tileBlockObject.title = tileBlock.title;
    tileBlockObject.titleTextBox = tileBlock.titleTextBox;
    tileBlockObject.subtitle = tileBlock.subtitle;
    tileBlockObject.subtitleTextBox = tileBlock.subtitleTextBox;
    tileBlockObject.remark = tileBlock.remark;
    tileBlockObject.remarkTextBox = tileBlock.remarkTextBox;
    tileBlockObject.queryIDs = tileBlock.queryIDs;
    tileBlockObject.chartID = tileBlock.chartID;
    tileBlockObject.blockFilters = tileBlock.blockFilters;
    tileBlockObject.blockSort = tileBlock.blockSort;
    tileBlockObject.blockRank = tileBlock.blockRank;
    tileBlockObject.blockLayouts = createBlockLayoutsJSON(tileBlock.blockLayouts);
    
    tileBlockObject.mainDataObject = tileBlock.mainDataObject;
    tileBlockObject.mainTextBox = tileBlock.mainTextBox;
    tileBlockObject.mainLabel = tileBlock.mainLabel;
    tileBlockObject.mainLabelTextBox = tileBlock.mainLabelTextBox;
    tileBlockObject.mainFormatString = tileBlock.mainFormatString;

    tileBlockObject.dataObject1 = tileBlock.dataObject1;
    tileBlockObject.textBox1 = tileBlock.textBox1;
    tileBlockObject.label1 = tileBlock.label1;
    tileBlockObject.alertImage1 = tileBlock.alertImage1;
    tileBlockObject.imageColor1 = tileBlock.imageColor1;
    tileBlockObject.arrowDirection1 = tileBlock.arrowDirection1;
    tileBlockObject.formatString1 = tileBlock.formatString1;

    tileBlockObject.dataObject2 = tileBlock.dataObject2;
    tileBlockObject.textBox2 = tileBlock.textBox2;
    tileBlockObject.label2 = tileBlock.label2;
    tileBlockObject.alertImage2 = tileBlock.alertImage2;
    tileBlockObject.imageColor2 = tileBlock.imageColor2;
    tileBlockObject.arrowDirection2 = tileBlock.arrowDirection2;
    tileBlockObject.formatString2 = tileBlock.formatString2;

    tileBlockObject.dataObject3 = tileBlock.dataObject3;
    tileBlockObject.textBox3 = tileBlock.textBox3;
    tileBlockObject.label3 = tileBlock.label3;
    tileBlockObject.alertImage3 = tileBlock.alertImage3;
    tileBlockObject.imageColor3 = tileBlock.imageColor3;
    tileBlockObject.arrowDirection3 = tileBlock.arrowDirection3;
    tileBlockObject.formatString3 = tileBlock.formatString3;

    tileBlockObject.dataObject4 = tileBlock.dataObject4;
    tileBlockObject.textBox4 = tileBlock.textBox4;
    tileBlockObject.label4 = tileBlock.label4;
    tileBlockObject.alertImage4 = tileBlock.alertImage4;
    tileBlockObject.imageColor4 = tileBlock.imageColor4;
    tileBlockObject.arrowDirection4 = tileBlock.arrowDirection4;
    tileBlockObject.formatString4 = tileBlock.formatString4;

    tileBlockObject.dataObject5 = tileBlock.dataObject5;
    tileBlockObject.textBox5 = tileBlock.textBox5;
    tileBlockObject.label5 = tileBlock.label5;
    tileBlockObject.alertImage5 = tileBlock.alertImage5;
    tileBlockObject.imageColor5 = tileBlock.imageColor5;
    tileBlockObject.arrowDirection5 = tileBlock.arrowDirection5;
    tileBlockObject.formatString5 = tileBlock.formatString5;

    tileBlockObject.dataObject6 = tileBlock.dataObject6;
    tileBlockObject.textBox6 = tileBlock.textBox6;
    tileBlockObject.label6 = tileBlock.label6;
    tileBlockObject.alertImage6 = tileBlock.alertImage6;
    tileBlockObject.imageColor6 = tileBlock.imageColor6;
    tileBlockObject.arrowDirection6 = tileBlock.arrowDirection6;
    tileBlockObject.formatString6 = tileBlock.formatString6;
    tileBlockObject.showToolButtons = true;
    
    return tileBlockObject;
}

function createQueryJSON(query){
	var queryObject = {};
	queryObject.queryID = query.queryID;
    queryObject.queryName = query.queryName;
    queryObject.modelType = query.modelType;
    queryObject.modelID = query.modelID;
    queryObject.modelName = query.modelName;
    queryObject.selectObjects = createBusinessObjectsJSON(query.selectObjects);
    queryObject.businessObjectHierarchies = query.businessObjectHierarchies;
    queryObject.filters = createFiltersJSON(query.filters);
    
    return queryObject;
}

function createBusinessObjectsJSON(businessObjects){
	var businessObjectsObject = [];
	
	$.each(businessObjects, function(i) {
		businessObjectsObject.push(businessObjects[i]);
	});
	
	return businessObjectsObject;
}

function createFiltersJSON(filters){
	var filtersObject = [];
	
	$.each(filters, function(i) {
		var obj = {};
		obj.filterID = filters[i].filterID;
	    obj.businessObject = filters[i].businessObject;
	    obj.operation = filters[i].operation;
	    obj.multipleValue = filters[i].multipleValue;
	    obj.filterInputMethod = filters[i].filterInputMethod;
	    obj.prompt = filters[i].prompt;
	    obj.filterValues = createFilterValuesJSON(filters[i].filterValues);
	    obj.valueObject = filters[i].valueObject;
	    obj.defaultValueName = filters[i].defaultValueName;
	    obj.defaultValueDataFormat = filters[i].defaultValueDataFormat;
	    
	    filtersObject.push(obj);
	});
	
	return filtersObject;
}

function createFilterValuesJSON(filterValues){
	var filterValuesObject = [];
	
	$.each(filterValues, function(i) {
		filterValuesObject.push(filterValues[i]);
	});
	
	return filterValuesObject;
}

function createDataObjectJson(dataObject){
    var dataObjectObject = {};
    dataObjectObject.objectID = dataObject.objectID;
    dataObjectObject.objectName = dataObject.objectName;
    dataObjectObject.queryID = dataObject.queryID;
    dataObjectObject.selectIDs = dataObject.selectIDs;
    dataObjectObject.objectType = dataObject.objectType;
    dataObjectObject.dataType = dataObject.dataType;
    dataObjectObject.expression = dataObject.expression;
    dataObjectObject.sourceType = dataObject.sourceType;
    dataObjectObject.sourceName = dataObject.sourceName;
    dataObjectObject.formatString = dataObject.formatString;
    dataObjectObject.finalExpression = createFinalExpressionJson(dataObject.finalExpression);
    dataObjectObject.sourceDimensions = dataObject.sourceDimensions;
    dataObjectObject.dataKey = dataObject.dataKey;
    return dataObjectObject;
}

function createFinalExpressionJson(finalExpression){
    var finalExpressionObject = {};
    finalExpressionObject.feString = finalExpression.feString;
    finalExpressionObject.ceString = finalExpression.ceString;
    finalExpressionObject.sqlSupported = finalExpression.sqlSupported;
    finalExpressionObject.basicDataObjects = finalExpression.basicDataObjects;
    return finalExpressionObject;
}

function ReportSetting(){
	this.reportSettingKey = "";
	this.reportSettingValue = "";
}

function ReportSettings(){}
ReportSettings.prototype = $SELF.inherit(Array.prototype);
ReportSettings.prototype.constructor = ReportSettings;

