/**
 * Created by wangzheng on 2018/12/11.
 */
function BusinessObject(options){
    this.businessObjectID = options?options.businessObjectID:null;
    this.businessObjectName = options?options.businessObjectName:null;
    this.businessObjectFolderID = options?options.businessObjectFolderID:null;
    this.aggregateFunction = options?options.aggregateFunction:null;
    this.valueOrder = options?options.valueOrder:null;
    this.formatString = options?options.formatString:null;
    this.businessObjectType = options?options.businessObjectType:null;
    this.dataType = options?options.dataType:null;
    this.expression = options?options.expression:null;
    this.tableNames = options?options.tableNames:null;
    this.sortIndex = options?options.sortIndex:null;

    this.getValueList = function(token,modelID,businessObjectID,path,succ,fail){
        var requestType = "get";
        var url = $SELF.basePath + path + "/"+modelID+"/businessObjects/"+businessObjectID + "/businessData";
        var headObj = {};
        headObj.Authorization = token;
        var obj = "";
        var asyncOrSync = true;
        var succCallback = function(data,status,request){
            if(request.status == 200){
                succ(data.items);
            }else{
                fail("未知错误。");
            }
        }
        var failCallback = function(XHR,textStatus){
            if(!window.navigator.onLine){
                fail("网络连接不可用。");
            }else if(XHR.responseText){
                if(!$SELF.request.isJson(XHR.responseText)){
                    fail(XHR.status+"#: "+XHR.responseText);
                }else{
                    fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
                }
            }else{
                fail("未知错误。");
            }
        }
        $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
    }
}

function BusinessObjects(){}

BusinessObjects.prototype = $SELF.inherit(Array.prototype);
BusinessObjects.prototype.constructor = BusinessObjects;
BusinessObjects.prototype.getAll = function(token,path,modelID,succ,fail){
    var me = this;
    var requestType = "get";
    var url = $SELF.basePath + path + "/"+modelID+"/businessObjects";
    var headObj = {};
    headObj.Authorization = token;
    var obj = "";
    var asyncOrSync = true;
    var succCallback = function(data,status,request){
        if(request.status == 200){
            $.each(data.items,function(i){
                var businessObject = new BusinessObject(data.items[i]);
                me.push(businessObject);
            });
            succ(me);
        }else{
            fail("未知错误。");
        }
    }
    var failCallback = function(XHR,textStatus){
        if(!window.navigator.onLine){
            fail("网络连接不可用。");
        }else if(XHR.responseText){
            if(!$SELF.request.isJson(XHR.responseText)){
                fail(XHR.status+"#: "+XHR.responseText);
            }else{
                fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
            }
        }else{
            fail("未知错误。");
        }
    }
    $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
}

function BusinessObjectFolder(options){
    this.folderID = options.folderID;
    this.folderName = options.folderName;
    this.description = options.description;
    this.folderParentID = options.folderParentID;
    this.sortIndex = options.sortIndex;
}

function BusinessObjectFolders(){}

BusinessObjectFolders.prototype = $SELF.inherit(Array.prototype);
BusinessObjectFolders.prototype.constructor = BusinessObjectFolders;
BusinessObjectFolders.prototype.getAll = function(token,modelID,succ,fail){
    var me = this;
    var requestType = "get";
    var url = $SELF.basePath + $SELF.relationModelsPath+"/"+modelID+"/businessObjectFolders";
    var headObj = {};
    headObj.Authorization = token;
    var obj = "";
    var asyncOrSync = true;
    var succCallback = function(data,status,request){
        if(request.status == 200){
            $.each(data.items,function(i){
                var businessObjectFolder = new BusinessObjectFolder(data.items[i]);
                me.push(businessObjectFolder);
            });
            succ(me);
        }else{
            fail("未知错误。");
        }
    }
    var failCallback = function(XHR,textStatus){
        if(!window.navigator.onLine){
            fail("网络连接不可用。");
        }else if(XHR.responseText){
            if(!$SELF.request.isJson(XHR.responseText)){
                fail(XHR.status+"#: "+XHR.responseText);
            }else{
                fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
            }
        }else{
            fail("未知错误。");
        }
    }
    $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
}