/**
 * Created by wangzheng on 2018/12/11.
 */
function BusinessModel(options){
    this.businessModelID = options.businessModelID;
    this.businessModelName = options.businessModelName;
    this.businessModelType = options.businessModelType;
    this.description = options.description;
    this.dataSourceID = options.dataSourceID;
    this.dataSourceName = options.dataSourceName;
    this.createUserID = options.createUserID;
    this.createUserName = options.createUserName;
    this.createDate = options.createDate;
    this.lastModifyUserID = options.lastModifyUserID;
    this.lastModifyUserName = options.lastModifyUserName;
    this.lastModifyDate = options.lastModifyDate;
}

function BusinessModels(){}

BusinessModels.prototype = $SELF.inherit(Array.prototype);
BusinessModels.prototype.constructor = BusinessModels;
BusinessModels.prototype.getAll = function(token, succ, fail){
    var me = this;
    var requestType = "get";
    var url = $SELF.basePath + $SELF.businessModelPath + "?moduleID=0";
    var headObj = {};
    headObj.Authorization = token;
    var obj = "";
    var asyncOrSync = false;
    var succCallback = function(data,status,request){
        if(request.status == 200){
            $.each(data.items,function(i){
                var businessModel = new RelationModel(data.items[i]);
                me.push(businessModel);
            });
            succ();
        }else{
            fail("未知错误。");
        }
    }
    var failCallback = function(XHR,textStatus){
        if(!window.navigator.onLine){
            fail("网络连接不可用。");
        }else if(XHR.responseText){
            if(!$SELF.request.isJson(XHR.responseText)){
                fail(XHR.status+"#: "+XHR.responseText);
            }else{
                fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
            }
        }else{
            fail("未知错误。");
        }
    }
    $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
}

function RelationModel(options){
    BusinessModel.call(this,options);
    this.businessObjects = options.businessObjects;
}

function RelationModels(){}

RelationModels.prototype = $SELF.inherit(Array.prototype);
RelationModels.prototype.constructor = RelationModels;
RelationModels.prototype.getAll = function(token, succ, fail){
    var me = this;
    var requestType = "get";
    var url = $SELF.basePath + $SELF.businessModelPath + "?moduleID=0&businessModelType=3";
    var headObj = {};
    headObj.Authorization = token;
    var obj = "";
    var asyncOrSync = true;
    var succCallback = function(data,status,request){
        if(request.status == 200){
            $.each(data.items,function(i){
                var businessModel = new RelationModel(data.items[i]);
                me.push(businessModel);
            });
            succ(me);
        }else{
            fail("未知错误。");
        }
    }
    var failCallback = function(XHR,textStatus){
        if(!window.navigator.onLine){
            fail("网络连接不可用。");
        }else if(XHR.responseText){
            if(!$SELF.request.isJson(XHR.responseText)){
                fail(XHR.status+"#: "+XHR.responseText);
            }else{
                fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
            }
        }else{
            fail("未知错误。");
        }
    }
    $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
}

function TableModel(options){
    BusinessModel.call(this,options)
    this.ption = options.ption;
    this.tableName = options.tableName;
    this.businessObjects = options.businessObjects;
}

function TableModels(){}

TableModels.prototype = $SELF.inherit(Array.prototype);
TableModels.prototype.constructor = TableModels;
TableModels.prototype.getAll = function(token,succ,fail){
    var me = this;
    var requestType = "get";
    var url = $SELF.basePath + $SELF.businessModelPath + "?moduleID=0&businessModelType=1";
    var headObj = {};
    headObj.Authorization = token;
    var obj = "";
    var asyncOrSync = true;
    var succCallback = function(data,status,request){
        if(request.status == 200){
            $.each(data.items,function(i){
                var tableModel = new TableModel(data.items[i]);
                me.push(tableModel);
            });
            succ(me);
        }else{
            fail("未知错误。");
        }
    }
    var failCallback = function(XHR,textStatus){
        if(!window.navigator.onLine){
            fail("网络连接不可用。");
        }else if(XHR.responseText){
            if(!$SELF.request.isJson(XHR.responseText)){
                fail(XHR.status+"#: "+XHR.responseText);
            }else{
                fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
            }
        }else{
            fail("未知错误。");
        }
    }
    $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
}

function SqlModel(options){
    BusinessModel.call(this,options);
    this.sqlText = options.sqlText;
    this.businessObjects = options.businessObjects;

}

function SqlModels(){}

SqlModels.prototype = $SELF.inherit(Array.prototype);
SqlModels.prototype.constructor = SqlModels;
SqlModels.prototype.getAll = function(token,succ,fail){
    var me = this;
    var requestType = "get";
    var url = $SELF.basePath + $SELF.businessModelPath + "?moduleID=0&businessModelType=2";
    var headObj = {};
    headObj.Authorization = token;
    var obj = "";
    var asyncOrSync = true;
    var succCallback = function(data,status,request){
        if(request.status == 200){
            $.each(data.items,function(i){
                var sqlModel = new SqlModel(data.items[i]);
                me.push(sqlModel);
            });
            succ(me);
        }else{
            fail("未知错误。");
        }
    }
    var failCallback = function(XHR,textStatus){
        if(!window.navigator.onLine){
            fail("网络连接不可用。");
        }else if(XHR.responseText){
            if(!$SELF.request.isJson(XHR.responseText)){
                fail(XHR.status+"#: "+XHR.responseText);
            }else{
                fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
            }
        }else{
            fail("未知错误。");
        }
    }
    $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
}

function ExcelModel(options){
    BusinessModel.call(this,options);
    this.excelFileId = options.excelFileId;
    this.excelFileName = options.excelFileName;
    this.sheetName = options.sheetName;
    this.businessObjects = options.businessObjects;
}

function ExcelModels(){}

ExcelModels.prototype = $SELF.inherit(Array.prototype);
ExcelModels.prototype.constructor = ExcelModels;
ExcelModels.prototype.getAll = function(token,succ,fail){
    var me = this;
    var requestType = "get";
    var url = $SELF.basePath + $SELF.businessModelPath + "?moduleID=0&businessModelType=3";
    var headObj = {};
    headObj.Authorization = token;
    var obj = "";
    var asyncOrSync = true;
    var succCallback = function(data,status,request){
        if(request.status == 200){
            $.each(data.items,function(i){
                var excelModel = new ExcelModel(data.items[i]);
                me.push(excelModel);
            });
            succ(me);
        }else{
            fail("未知错误。");
        }
    }
    var failCallback = function(XHR,textStatus){
        if(!window.navigator.onLine){
            fail("网络连接不可用。");
        }else if(XHR.responseText){
            if(!$SELF.request.isJson(XHR.responseText)){
                fail(XHR.status+"#: "+XHR.responseText);
            }else{
                fail(XHR.status+"#: "+JSON.parse(XHR.responseText).error);
            }
        }else{
            fail("未知错误。");
        }
    }
    $SELF.request.publicRequest(requestType,url,headObj,obj,asyncOrSync,succCallback,failCallback);
}