/**
 * Created by wangzheng on 2018/12/12.
 */
function Block(options){
	var blockLayouts = new BlockLayouts();
	var pcBlockLayout = new BlockLayout();
	var padBlockLayout = new BlockLayout();
	var mobileBlockLayout = new BlockLayout();
	blockLayouts.push(pcBlockLayout);
	blockLayouts.push(padBlockLayout);
	blockLayouts.push(mobileBlockLayout);
	
    this.blockID = $SELF.newGuid();
    this.blockName = options?options.blockName:"";
    this.title = "";
    this.titleTextBox = new BDATextBox(options);
    this.subtitle = "";
    this.subtitleTextBox = new BDATextBox(options);
    this.remark = "";
    this.remarkTextBox = new BDATextBox(options);
    this.queryIDs = options?options.queryIDs:[];
    this.chartID = options?options.chartID:"";
    this.blockLayouts = blockLayouts;
    this.blockFilters = [];
    this.blockSort = new BlockSort();
    this.blockRank = new BlockRank();
    this.showToolButtons = true;

}

function ChartBlock(options){
    var pieDataLabel = new DataLabel();
    Block.call(this,options);

    this.primaryDimension = options?options.primaryDimension:null;
    this.groupDimension = options?options.groupDimension:null;
    this.y1Measures = options?options.y1Measures:[];
    this.y1FormatString = "";
    this.y2Measures = options?options.y2Measures:[];
    this.y2FormatString = "";
    this.y3Measures = options?options.y3Measures:[];
    this.y3FormatString = "";
    this.legendShow = false;
    this.legendPosition = 0;
    this.dataShow = true;
    this.dataHoverShow = true;
    this.axisLabelShow = true;
    this.reportLink = null;
    this.dataLabel = pieDataLabel;
    this.xScaleLineWidth = 1;
    this.showTickValue = true;

}

function ChartBlocks(){}

ChartBlocks.prototype = $SELF.inherit(Array.prototype);
ChartBlocks.prototype.constructor = ChartBlocks;

function VerticalTableBlock(options){
    Block.call(this,options);

    this.tableHead = new TableHead(options);
    this.tableBody = new TableBody(options);
    this.tableFoot = new TableFoot(options);
    
    var headOptions = {};
    headOptions.rowID = 0;
    var tableHeadRow = new TableRow(headOptions);
    this.tableHead.tableRows.push(tableHeadRow);
    
    var bodyOptions = {};
    bodyOptions.rowID = 1;
    var tableBodyRow = new TableRow(bodyOptions);
    this.tableBody.tableRows.push(tableBodyRow);
    
    var footOptions = {};
    footOptions.rowID = 0;
    var tableFootRow = new TableRow(footOptions);
    this.tableFoot.tableRows.push(tableFootRow);
    
    this.tableWarnings = options?options.tableWarnings:[];
    this.autoMergeDimensionCells = false;
    this.notShowBorderOfDetailTableCell = false;
    this.tBodyScrolling = false;
    this.scrollTimePerLine = 2000;
    this.headHeight = 30;
    this.bodyHeight = 30;
    this.footHeight = 30;
}

function VerticalTableBlocks(){}

VerticalTableBlocks.prototype = $SELF.inherit(Array.prototype);
VerticalTableBlocks.prototype.constructor = VerticalTableBlocks;

function HorizontalTableBlock(options){
    Block.call(this,options);

    this.tableHead = new HorizontalTableHead(options);
    this.tableBody = new HorizontalTableBody(options);
    this.tableFoot = new HorizontalTableFoot(options);

    var headOptions = {};
    headOptions.rowID = 0;
    var tableHeadRow = new TableColumn(headOptions);
    this.tableHead.tableColumns.push(tableHeadRow);

    var bodyOptions = {};
    bodyOptions.rowID = 1;
    var tableBodyRow = new TableColumn(bodyOptions);
    this.tableBody.tableColumns.push(tableBodyRow);

    var footOptions = {};
    footOptions.rowID = 0;
    var tableFootRow = new TableColumn(footOptions);
    this.tableFoot.tableColumns.push(tableFootRow);

    this.tableWarnings = options?options.tableWarnings:[];
    this.cellHeight = 35;
    this.wordWrap = false;
    this.notShowBorderOfTableCell = false;
}
function HorizontalTableBlocks(){}

HorizontalTableBlocks.prototype = $SELF.inherit(Array.prototype);
HorizontalTableBlocks.prototype.constructor = HorizontalTableBlocks;

function PivotTableBlock(options){
	var pivotMeasures = new PivotMeasures();
	
    Block.call(this,options);

    this.rowDimensions = options?options.rowDimensions:[];
    this.columnDimensions = options?options.columnDimensions:[];
    this.pivotMeasures = pivotMeasures;
    /// <summary>
    /// 行小计 true：显示  false：不显示
    /// </summary>
    this.rowSubtotal = false;
    /// <summary>
    /// 行总计 true：显示  false：不显示
    /// </summary>
    this.rowTotal = false;
    this.columnSubtotal = false;
    this.columnTotal = false;
    this.showCrossTableHead = false;
    this.totalBackgroundColor = $SELF.converRgbToArgb(255,118, 147, 60);
    this.totalColor = $SELF.converRgbToArgb(255,255,255,255);
    this.totalFont = new BDAFont();
    this.tableHeadBackgroundColor = $SELF.converRgbToArgb(255,81, 117, 185);
    this.tableHeadColor = $SELF.converRgbToArgb(255,255,255,255);
    this.tableHeadFont = new BDAFont();
}

function PivotTableBlocks(){}

PivotTableBlocks.prototype = $SELF.inherit(Array.prototype);
PivotTableBlocks.prototype.constructor = PivotTableBlocks;

function TileBlock(options){
    Block.call(this,options);

    this.mainDataObject = options?options.mainDataObject:null;
    this.mainTextBox = new BDATextBox(options);
    this.mainLabel = options?options.mainLabel:"";
    this.mainLabelTextBox = new BDATextBox(options);
    this.mainFormatString = "";

    this.dataObject1 = null;
    this.textBox1 = new BDATextBox(options);
    this.label1 = "";
    this.alertImage1 = 0;
    this.imageColor1 = 0;
    this.arrowDirection1 = 0;
    this.formatString1 = "";

    this.dataObject2 = null;
    this.textBox2 = new BDATextBox(options);
    this.label2 = "";
    this.alertImage2 = 0;
    this.imageColor2 = 0;
    this.arrowDirection2 = 0;
    this.formatString2 = "";

    this.dataObject3 = null;
    this.textBox3 = new BDATextBox(options);
    this.label3 = "";
    this.alertImage3 = 0;
    this.imageColor3 = 0;
    this.arrowDirection3 = 0;
    this.formatString3 = "";

    this.dataObject4 = null;
    this.textBox4 = new BDATextBox(options);
    this.label4 = "";
    this.alertImage4 = 0;
    this.imageColor4 = 0;
    this.arrowDirection4 = 0;
    this.formatString4 = "";

    this.dataObject5 = null;
    this.textBox5 = new BDATextBox(options);
    this.label5 = "";
    this.alertImage5 = 0;
    this.imageColor5 = 0;
    this.arrowDirection5 = 0;
    this.formatString5 = "";

    this.dataObject6 = null;
    this.textBox6 = new BDATextBox(options);
    this.label6 = "";
    this.alertImage6 = 0;
    this.imageColor6 = 0;
    this.arrowDirection6 = 0;
    this.formatString6 = "";
}

function TileBlocks(){}

TileBlocks.prototype = $SELF.inherit(Array.prototype);
TileBlocks.prototype.constructor = TileBlocks;

function BDATextBox(options){
    var bdaFont = new BDAFont();

    this.borderRadius = "0,0,0,0";
    this.height = 30;
    this.textAlign = options?options.textAlign:1;
    this.font = bdaFont;
    this.verticalAlign = 1;
    this.backgroundColor = $SELF.converRgbToArgb(0,255,255,255);
    this.color = $SELF.converRgbToArgb(255,36,36,36);
    this.adjustWidthAccordingToText = false;
}

function BDAFont(){
    this.italic = false;
    this.bold = false;
    this.fontFamily = "Arial";
    this.size = 14;
    this.strikeout = false;
    this.underline = false;
}

function DataLabel(){
    this.showValue = true;
    this.showPercentage = false;
    this.showDimension = false;
    this.position = 30;
}

function TableHead(){
	this.rowID = 0;
    this.tableRows = new TableRows();
}

function TableBody(){
	this.rowID = 1;
    this.tableRows = new TableRows();
}

function TableFoot(){
	this.rowID = 2;
	var options =  {};
	options.rowID = this.rowID;
    this.tableRows = new TableRows(options);
}

function TableRow(options){
    this.rowID = options.rowID;
    this.tableCells = new TableCells();
}

function TableRows(){}

TableRows.prototype = $SELF.inherit(Array.prototype);
TableRows.prototype.constructor = TableRows;

function HorizontalTableHead(){
    var options = {};
    options.columnIndex = 0;
    this.tableColumns = new TableColumns(options);
}

function HorizontalTableBody(){
    var options = {};
    options.columnIndex = 1;
    this.tableColumns = new TableColumns(options);
}

function HorizontalTableFoot(){
    var options = {};
    options.columnIndex = 2;
    this.tableColumns = new TableColumns(options);
}

function TableColumn(options){
    this.columnIndex = options.columnIndex;
    this.tableCells = new TableCells();
}

function TableColumns(){}

TableColumns.prototype = $SELF.inherit(Array.prototype);
TableColumns.prototype.constructor = TableColumns

function TableCell(){
    this.rowID = "";
    this.columnIndex = null;
    this.text = "";
    this.dataObject = null;
    this.formatString = "";

    this.cellTextBox = new BDATextBox();

    this.reportLink = null;
    this.colspan = 1;
    this.rowspan = 1;

    this.showColumnBarForMeasure = false;
    this.columnBarMaxLength = 0.8;
    this.positiveColumnBarColor = 1;
    this.negativeColumnBarColor = 1;
    this.autoColumnWidth = true;
}

function TableCells(){}

TableCells.prototype = $SELF.inherit(Array.prototype);
TableCells.prototype.constructor = TableCells;

function PivotMeasure(){
    this.measureID = "";
    this.measureName = "";
    this.measureObject = null;
    this.aggregateFunctionName = "";
    this.formatString = "";
}

function PivotMeasures(){}

PivotMeasures.prototype = $SELF.inherit(Array.prototype);
PivotMeasures.prototype.constructor = PivotMeasures;

function BlockLayout(){
    this.pageID = $SELF.newGuid();
    this.left = 0;
    this.top = 0;
    this.width = 1;
    this.height = 1;
}

function BlockLayouts(){}

BlockLayouts.prototype = $SELF.inherit(Array.prototype);
BlockLayouts.prototype.constructor = BlockLayouts;

function BlockSort(){
	this.sortEnabled = false;
	this.sortDataObject = null;
	this.sortType = 0;
}

function BlockRank(){
	this.rankEnabled = false;
    this.rankDataObject = null;
    this.rankNumber = 3;
    this.rankDirection = 0;
}
