layui.use(["jquery"],function(){
    var $ = layui.jquery;

    var $AppConstants = {
        hostName: location.protocol+"//" + location.hostname,
        // hostName: "http://192.168.1.128",
        port: location.port?(":"+location.port):"",
        // port: "",
        webHostName: location.protocol+"//" + location.hostname,
        // webHostName: "http://127.0.0.1",
        webPort: location.port?(":"+location.port):"",
        // webPort: ":8080",
        certificateHostName: "",
        certificatePort: "",
        // projectName: "/web",
        projectName: ""
    };
    
    var $Utils = {
        request: {},
        loading: {},
        message: {}
    };

    var $AppVars = {
        token: "",
        queryTimeOut: 3
    };

    $.extend($Utils.request,{
        getRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'get',
                url: url ,
                dataType: dataType,
                timeout: 63000 * $AppVars.queryTimeOut,
                traditional: true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        postRequest:function(url,obj,asyncOrSync,dataType,succCallback,failCallback){
            var headersObj = {};
            headersObj["Content-Type"] = "application/json; charset=utf-8";
            headersObj["Authorization"] = $AppVars.token;
            $.ajax({
                type: 'post',
                url: url ,
                dataType: dataType,
                timeout: 63000,
                traditional:true,
                headers: headersObj,
                data: obj,
                async: asyncOrSync,
                context: this,
                cache: false,
                /*请求成功回调*/
                success: function(data,status,request){
                    succCallback(data,status,request);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    failCallback(XHR,textStatus);
                }
            }).then();
        },
        isJson: function(str){
            if (typeof str == 'string') {
                try {
                    var obj=JSON.parse(str);
                    if(typeof obj == 'object' && obj ){
                        return true;
                    }else{
                        return false;
                    }

                } catch(e) {
                    return false;
                }
            }
        }
    });

    $.extend($Utils.loading,{
        open: function(){
            $(".page-loading").show();
        },
        close: function(){
            $(".page-loading").hide();
        }
    });

    $.extend($Utils.message,{
        open: function (strTitle,str) {
            $('.page-msg').css('display','block').find('.page-msg-content div p').html(str||'');
            $('.page-msg').find("h3 .msg-title").html(strTitle || "");
            var msgCurrentHeight =  $('.page-msg .page-msg-content div p').height();
            var msgMaxHeight = Math.floor($(window).height() * 0.8) - 18 - 45;/*18为上内边距 45为下内边距*/
            if(msgCurrentHeight>msgMaxHeight){
                $('.page-msg-content div p').css({
                    'height': msgMaxHeight,
                    'overflow-y':'auto'
                });
            }
        },
        close: function () {
            $('.page-msg').css('display','none').find('.page-msg-content div p').html('');
            $('.page-msg-content div').removeAttr('style');
        }
    });
    /*关闭信息提示框事件*/
    $('.page-msg button').click($Utils.message.close);
    $('.page-msg span').click($Utils.message.close);

    window.$Utils = $Utils;
    window.$AppVars = $AppVars;
    window.$AppConstants = $AppConstants;
});