/*
 * @version: 
 * @Descripttion: 
 * @Author: 王政
 * @Date: 2020-05-19 09:40:26
 * @LastEditTime: 2021-03-31 11:38:33
 * @LastModifyUser: 
 * @Remark: 
 */ 
layui.use(["jquery","form"],function(){
    var $ = layui.jquery, form = layui.form;
    var os = function (){
        var ua = navigator.userAgent,
            isWindowsPhone = /(?:Windows Phone)/.test(ua),
            isSymbian = /(?:SymbianOS)/.test(ua) || isWindowsPhone,
            isAndroid = /(?:Android)/.test(ua),
            isFireFox = /(?:Firefox)/.test(ua),
            isChrome = /(?:Chrome|CriOS)/.test(ua),
            isTablet = /(?:iPad|PlayBook)/.test(ua) || (isAndroid && !/(?:Mobile)/.test(ua)) || (isFireFox && /(?:Tablet)/.test(ua)),
            isPhone = /(?:iPhone)/.test(ua) && !isTablet,
            isPc = !isPhone && !isAndroid && !isSymbian;
        return {
            isTablet: isTablet,
            isPhone: isPhone,
            isAndroid: isAndroid,
            isPc: isPc
        };
    }();
    var reportName = "导出Excel";
    var reportUrlArr = [];
    var deviceTypeID = 2;
    var reportName = "";
    function onBridgeReady() {
        WeixinJSBridge.call('hideOptionMenu');
    }

    if (typeof WeixinJSBridge == "undefined") {
        if (document.addEventListener) {
            document.addEventListener('WeixinJSBridgeReady', onBridgeReady, false);
        } else if (document.attachEvent) {
            document.attachEvent('WeixinJSBridgeReady', onBridgeReady);
            document.attachEvent('onWeixinJSBridgeReady', onBridgeReady);
        }
    } else {
        onBridgeReady();
    }
    initPage();

    function initPage(){
        if(os.isPc){
            deviceTypeID = 2;
            $(".bottom-bar").hide();
            $(".top-bar").show();
            $(".top-box").addClass("pc-box");
        }else if(os.isTablet){
            deviceTypeID = 1;
            $(".bottom-bar").hide();
            $(".top-bar").show();
            $(".top-box").addClass("pc-box");
        }else{
            deviceTypeID = 0;
            $(".bottom-bar").show();
            $(".top-bar").hide();
            $(".top-box").removeClass("pc-box");
        }
    
        initIframe();

        $(".fixed-box .left-button").off('click').on("click",function(){
            if($(this).parent(".fixed-box").hasClass("select-button-box")){
                $(this).parent(".fixed-box").removeClass("select-button-box");
            }else{
                $(this).parent(".fixed-box").addClass("select-button-box");
            }
        });
    
        $("#backPC,#buttonBack,#backMobile").click(function(){
            if(!$(this).hasClass("opacity")){
                $(".top-box").find(".reportMain"+(reportUrlArr.length)).remove();
                reportUrlArr.pop();
                if(reportUrlArr.length < 2){
                    $("#backPC,#backMobile").addClass("opacity");
                }
                var reportID = (reportUrlArr[reportUrlArr.length-1].split("&reportID=")[1]).split("&")[0];
                reviseReportName(reportID);
            }
        });
    
        $("#refreshPC,#refreshMobile,#buttonRefresh").on("click",function(){
            var childWindow = $(".top-box").find("iframe") .eq(0)[0].contentWindow;
            var frameWidth = $(".top-box").width();
            var frameHeight = $(".top-box").height();
            childWindow.refresh(frameHeight,frameWidth,1);
        });
    
        $("#magnify").click(function(){
            magnify();
        });
    
        $("#closeMagnify").click(function(){
            quitFullScreen();
        });
    
        $("#export").click(function(){
            var childWindow = $(".top-box").find("iframe") .eq(0)[0].contentWindow;
            childWindow.exportToExcel(reportName);
        });
    
        $("#print").click(function(){
            var childWindow = $(".top-box").find("iframe") .eq(0)[0].contentWindow;
            childWindow.printing();
        });
    
        $("#sharePC").click(function(){
            $(".share-mark").show();
            $(".share-box").removeAttr("style");
            initShare();
        });
    
        $("#shareMobile").click(function(){
            $(".share-mobile").show();
            initMobileShare();
        });
    }

    function initIframe(){
        var allParameters = window.location.search;
        var token = "null";
        if(allParameters.indexOf("token=") != -1){
            token = (allParameters.split("token=")[1]).split("&")[0];
        }
        var reportID = "null";
        if(allParameters.indexOf("reportID=") != -1){
            reportID = (allParameters.split("reportID=")[1]).split("&")[0];
        }
        var themeID = "null";
        if(allParameters.indexOf("themeID=") != -1){
            themeID = (allParameters.split("themeID=")[1]).split("&")[0];
        }
        var parameters = "null";
        if (allParameters.indexOf("parameters=") != -1){
            parameters = (allParameters.split("parameters=")[1]).split("&")[0];
        }
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/report_front_end/jsp/report.jsp?token=" + token + "&reportID=" + reportID + "&deviceTypeID=" + deviceTypeID + "&themeID=" + themeID + "&queryTimeOut=3&parameters=" + parameters;
        $(".top-box .reportMain1").attr("src",url);
        reportUrlArr.push(url);
        $AppVars.token = token;
        reviseReportName(reportID);
    }

    $Utils.loading.close();
    window.addEventListener("message",function(e){
        if(e.data.key == "linkReport"){
            linkReport(e.data.value);
        }
    });
    
    window.closeFilter = function(){
        return;
    };

    window.linkReport = function(url){
        reportUrlArr.push(url);
        var reportID = (url.split("&reportID=")[1]).split("&")[0];
        var index = reportUrlArr.length;
        var iframe = "<iframe name='reportMain"+index+"' class='reportMain"+index+"' src='' frameborder='no' scrolling='auto' width='100%' height='100%' allowtransparency='true'></iframe>";
        $(".top-box").prepend(iframe);
        $(".top-box .reportMain"+index).attr("src",url);

        reviseReportName(reportID);
        if(reportUrlArr.length > 1){
            $("#backPC,#backMobile").removeClass("opacity");
        }
    }

    function initShare(){
		$(".copy").hide();
		$(".share-type span").removeClass("current-type");
		$(".share-type span:first-child").addClass("current-type");
		$(".share-content").addClass("current-share-content");
		$(".share-content label").addClass("selected-check").siblings("input").removeAttr("style");
		$("#report-url").val("");
		$(".password").val(randomWord(6));
		$(".valid-date").val(7);
        $(".share-content p").html("");
        bindShareBoxEvent();
    }

    function randomWord(min){
		var str = "",range = min,
			arr = ['0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'];
		for(var i=0; i<range; i++){
			var pos = Math.round(Math.random() * (arr.length-1));
			str += arr[pos];
		}
		return str;
	}
    
    function bindShareBoxEvent(){
        $(".create-url").off('click').on("click",function(){
            if(validateShare()){
                var shareObj = setShare();
                getShareID(shareObj);
            }
        });

        $(".share-type span").off('click').on("click",function(){
            if(!$(this).hasClass("current-type")){
                $(this).addClass("current-type").siblings("span").removeClass("current-type");
            }
        });

        $(".share-content label").off('click').on("click",function(){
            if($(this).hasClass("selected-check")){
                $(this).removeClass("selected-check");
                $(this).siblings("input").attr("disabled",true);
                $(this).siblings("input").css("color","#999");
            }else{
                $(this).addClass("selected-check");
                $(this).siblings("input").attr("disabled",false);
                $(this).siblings("input").css("color","#333");
            }
        });

        $(".close-share-box,#cancelShare").off('click').on("click",function(){
            $(".share-mark").hide();
        });
    }

    function validateShare(){
		if($(".pass-check").hasClass("selected-check") && $.trim($(".password").val()) == ""){
			$(".password").siblings("p").html("请输入验证密码!");
			return false;
		}
		if($(".date-check").hasClass("selected-check") && $.trim($(".valid-date").val()) == ""){
			$(".valid-date").siblings("p").html("请输入天数!");
			return false;
		}
		return true;
    }

    function setShare(){
        var shareObj = {};
		var url = "";
        url = reportUrlArr[reportUrlArr.length-1];
        var childWindow = $(".top-box").find("iframe") .eq(0)[0].contentWindow;
        shareObj = childWindow.transmitReportView();

        return setLinkShare(url,shareObj);
    }

    function setLinkShare(url,shareObj){
		var reportID = url.split("reportID=")[1];
		reportID = reportID.split("&")[0];
        var linkShare = {};
        linkShare.reportID = reportID;
        linkShare.shareType = $(".have-limit").hasClass("current-type")?0:1;
		if(linkShare.shareType == 0){
			linkShare.reportView = shareObj.reportView;
		}
        linkShare.restrictDate = $(".date-check").hasClass("selected-check");
        linkShare.shareDays = $(".date-check").hasClass("selected-check")?$(".valid-date").val():"";
        linkShare.needPassword = $(".pass-check").hasClass("selected-check");
        linkShare.sharePassword = linkShare.needPassword?$(".password").val():"";
		linkShare.themeID = url.split("themeID=")[1].split("&")[0];
		linkShare.deviceTypeID = url.split("deviceTypeID=")[1].split("&")[0];
		linkShare.reportSettings = [
            {
                reportSettingKey: "scaleByScreenSize",
                reportSettingValue: shareObj.scaleByScreenSize
            },
            {
                reportSettingKey: "pageWidth",
                reportSettingValue: shareObj.pageWidth
            },
			{
				reportSettingKey: "pageHeight",
				reportSettingValue: shareObj.pageHeight
			},
			{
				reportSettingKey: "followDesignSize",
				reportSettingValue: shareObj.followDesignSize
			},
			{
				reportSettingKey: "reportName",
				reportSettingValue: shareObj.reportName
			}
        ];

        return linkShare;
    }
    
    function getShareID(linkShare){
        var shareUrl = "";
        var succ = function(data,status,request){
            if(request.status == 201){
                var shareID = request.getResponseHeader('location').split('/linkShares/')[1];
                shareUrl = $AppConstants.hostName + $AppConstants.port+"/Report/linkShares/"+shareID+"/reportJSP";
                if(deviceTypeID != 0){
                    $("#report-url").val(shareUrl);
                    var Url = document.getElementById("report-url");
                    Url.select();
                    document.execCommand("Copy");
                }else{
                    $(".share-url").text(shareUrl);
                }
            }
        };
        var fail = function(XHR,textStatus){
            if(!window.navigator.onLine){
                $Utils.message.open("新增分享","网络连接不可用。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    $Utils.message.open("新增分享",XHR.status+"#: "+XHR.responseText);
                }else{
                    $Utils.message.open("新增分享",XHR.status+"#: "+JSON.parse(XHR.responseText).error);
                }
            }else{
                $Utils.message.open("新增分享","未知错误。");
            }
        };
        var url = $AppConstants.hostName + $AppConstants.port + "/Report/linkShares";
        $Utils.request.postRequest(url,JSON.stringify(linkShare),true,'text',succ,fail);
    }

    function initMobileShare(){

        form.val("mobileShare",{
            mobilePassword: randomWord(6),
            date: 7
        });

        $(".mobile-share-type span").off("click").on("click",function(){
            if(!$(this).hasClass("cur-this")){
                $(this).addClass("cur-this").siblings("span").removeClass("cur-this");
            }
        });

        $(".create-share").off("click").on("click",function(){
            var formVal = form.val('mobileShare');
            if(validateForm(formVal)){
                var shareObj = setMobileShare();
                getShareID(shareObj);
            }
        });

        $(".close").off("click").on("click",function(){
            $(".share-mobile").hide();
        });
    }

    function validateForm(obj){
        if(obj.isPassword && (obj.mobilePassword == "")){
            layer.msg("设置密码时，密码不能为空。",{icon:2});
            return false;
        }
        if(obj.isDate && (obj.date == "")){
            layer.msg("设置有效期时，天数不能为空。",{icon:2});
            return false;
        }
        return true;
    }

    function setMobileShare(){
        var shareObj = {};
		var url = "";
        url = reportUrlArr[reportUrlArr.length-1];
        var childWindow = $(".top-box").find("iframe") .eq(0)[0].contentWindow;
        shareObj = childWindow.transmitReportView();
        return setMobileLinkShare(url,JSON.parse(shareObj));
    }

    function setMobileLinkShare(url,obj){
        var formVal = form.val('mobileShare');

        var reportID = url.split("reportID=")[1];
		reportID = reportID.split("&")[0];
        var linkShare = {};
        linkShare.reportID = reportID;
        linkShare.shareType = Number($(".mobile-share-type span.cur-this").attr("data-type"));
		if(linkShare.shareType == 0){
			linkShare.reportView = obj.reportView;
		}
        linkShare.restrictDate = formVal.isDate?true:false;
        linkShare.shareDays = formVal.isDate?formVal.date:"";
        linkShare.needPassword = formVal.isPassword?true:false;
        linkShare.sharePassword = linkShare.needPassword?formVal.mobilePassword:"";
		linkShare.themeID = url.split("themeID=")[1].split("&")[0];
		linkShare.deviceTypeID = url.split("deviceTypeID=")[1].split("&")[0];
		linkShare.reportSettings = [
            {
                reportSettingKey: "scaleByScreenSize",
                reportSettingValue: obj.scaleByScreenSize
            },
            {
                reportSettingKey: "pageWidth",
                reportSettingValue: obj.pageWidth
            },
			{
				reportSettingKey: "pageHeight",
				reportSettingValue: obj.pageHeight
			},
			{
				reportSettingKey: "followDesignSize",
				reportSettingValue: obj.followDesignSize
			},
			{
				reportSettingKey: "reportName",
				reportSettingValue: obj.reportName
			}
        ];

        return linkShare;
    }

    var isESCPress = false;
	
    document.body.onkeydown = function(e){
        var ev = e || window.event;
        var code = ev.keyCode;
        
        code ==27 && (isESCPress = true);
        if(isESCPress){
            quitFullScreen();
        }
        if(code == 122 && ev.ctrlKey){
            magnify();
        }
    }
    
    document.body.onkeyup = function(e){
        var ev = e || window.event;
        var code = ev.keyCode;
        
        code ==27 && (isESCPress = false);
    }
    
    window.magnify = function(){
        var childWindow = $(".top-box").find("iframe") .eq(0)[0].contentWindow;
        var reportSettings = "";
        var reportSettings = childWindow.transmitReportSettings();

        $(".pc-box").css({
            "top": 0
        });
        if(deviceTypeID==2){
            $(".tishi").show(500);
            setTimeout(function() {
                $(".tishi").hide(500);
            }, 5000);
        }
        
        if(reportSettings.backButtonInitPosition && reportSettings.backButtonInitPosition == "0"){
            $(".fixed-box").removeClass().addClass("fixed-box left-top");
        }
        if(reportSettings.backButtonInitPosition && reportSettings.backButtonInitPosition == "1"){
            $(".fixed-box").removeClass().addClass("fixed-box right-top");
        }
        if(reportSettings.backButtonInitPosition && reportSettings.backButtonInitPosition == "2"){
            $(".fixed-box").removeClass().addClass("fixed-box right-bottom");
        }
        if(reportSettings.backButtonInitPosition && reportSettings.backButtonInitPosition == "3"){
            $(".fixed-box").removeClass().addClass("fixed-box left-bottom");
        }
        if(reportSettings.showBackButtonWhenPCFullscreen && reportSettings.showBackButtonWhenPCFullscreen == "1"){
            $(".fixed-box").show();
        }
    };

    window.quitFullScreen = function(){
        $(".pc-box").removeAttr("style");
        $(".fixed-box").removeClass("select-button-box").hide();
	};

    function reviseReportName(reportID){
        var succ = function(data,status,request){
            if(request.status == 200){
                $(".report-name").text(data.item.reportName);
                document.title = data.item.reportName;
                reportName = data.item.reportName;
            }
        };
        var fail = function(XHR,textStatus){
            if(!window.navigator.onLine){
                $Utils.message.open("获取报表名称","网络连接不可用。");
            }else if(XHR.status || XHR.status == 0){
                if(!$Utils.request.isJson(XHR.responseText)){
                    $Utils.message.open("获取报表名称",XHR.status+"#: "+XHR.responseText);
                }else{
                    $Utils.message.open("获取报表名称",XHR.status+"#: "+JSON.parse(XHR.responseText).error);
                }
            }else{
                $Utils.message.open("获取报表名称","未知错误。");
            }
        };
        $Utils.request.getRequest($AppConstants.hostName + $AppConstants.port +"/Report/reports/"+reportID+"/simpleProperties","",true,"json",succ,fail);
    }
});