/**
 * Created by wangzheng on 2019/12/28.
 */
(function(){
    var authorization = '', reportID = 0, requestParameters={}, deviceTypeID = 2, basePath = '', baseUrl = '', filter_base64 = '', queryTimeOut= 0,share = '', allParameters='',shareID='',isNeedPassword = true;
    var os = function (){
        var ua = navigator.userAgent,
            isWindowsPhone = /(?:Windows Phone)/.test(ua),
            isSymbian = /(?:SymbianOS)/.test(ua) || isWindowsPhone,
            isAndroid = /(?:Android)/.test(ua),
            isFireFox = /(?:Firefox)/.test(ua),
            isChrome = /(?:Chrome|CriOS)/.test(ua),
            isTablet = /(?:iPad|PlayBook)/.test(ua) || (isAndroid && !/(?:Mobile)/.test(ua)) || (isFireFox && /(?:Tablet)/.test(ua)),
            isPhone = /(?:iPhone)/.test(ua) && !isTablet,
            isPc = !isPhone && !isAndroid && !isSymbian;
        return {
            isTablet: isTablet,
            isPhone: isPhone,
            isAndroid: isAndroid,
            isPc: isPc
        };
    }();
    var reportSettings = new ReportSettings();
    var isESCPress = false;
    ajaxTools.authorization = authorization = $('script[token]').attr('token');
    reportID =  $('script[token]').attr('reportid');
    deviceTypeID = $('script[token]').attr('devicetypeid');

    basePath = $('script[token]').attr('basePath');
    baseUrl = $('script[token]').attr('url');
    ajaxTools.queryTimeOut = parseInt($('script[token]').attr('queryTimeOut')) || 3;
    shareID = $('script[token]').attr('shareID');
    allParameters = $('script[token]').attr('allParameters');
    if(shareID != "null"){
        if (os.isAndroid || os.isPhone) {
            // 手机
            deviceTypeID = 0;
        } else if (os.isTablet) {
            // 平板
            deviceTypeID = 1;
        } else if (os.isPc) {
            // pc
            deviceTypeID = 2;
        }
        //allParameters = allParameters.split("deviceTypeID=")[0]+"deviceTypeID="+deviceTypeID+allParameters.split("deviceTypeID=")[1].substring(1);
        allParameters = allParameters + "&deviceTypeID=" + deviceTypeID;
    }
    $BDA.deviceTypeID.check(deviceTypeID);


    $('.browserupgrade span').click(function(){
        $('.browserupgrade').hide();
    });

    var str = "<iframe name='report"+reportID+"' id='report"+reportID+"' class='report"+reportID+"' frameborder='no' width='100%' height='100%' scrolling='auto' allowtransparency='true' src='' allowTransparency='true'></iframe>";
    $("body").append(str);

    var fail = function(strTitle,XHR,textStatus){
        if(textStatus == 'timeout'){
            $BDA.message.open(strTitle,'连接超时');
            return;
        }
        if(textStatus == 'error'){
            if(!window.navigator.onLine){
                $BDA.message.open(strTitle,'网络链接不可用');
            }else if(XHR.responseText){
                if(!isJson(XHR.responseText)){
                    $BDA.message.open(strTitle,XHR.status +'#: '+ XHR.responseText);
                }else{
                    $BDA.message.open(strTitle,XHR.status +'#: '+ JSON.parse(XHR.responseText).error);
                }
            }else{
                $BDA.message.open(strTitle,'error');
            }
        };
    };
    if(shareID != "null"){
        if(deviceTypeID == 2){
            var succ = function(){
                document.title = reportSettings.item("reportName")?reportSettings.item("reportName").reportSettingValue:"";
                if(reportSettings.item("followDesignSize") && parseInt(reportSettings.item("followDesignSize").reportSettingValue)) {
                    setIframeSize();
                }else{
                    $("#report"+reportID).width($(window).width());
                    $("#report"+reportID).height($(window).height());
                }
                openURL();
            };
            reportSettings.getShareItems(basePath,shareID,succ,fail);
        }else{
            window.location.href = (baseUrl.split("report.jsp")[0])+"index.jsp"+"?"+allParameters;
        }
    }else{
        getReportName(reportID);
        var succ = function(){
            if(deviceTypeID == 2){
                if(reportSettings.item("followDesignSize") && parseInt(reportSettings.item("followDesignSize").reportSettingValue)) {
                    setIframeSize();

                }else{
                    $("#report"+reportID).width($(window).width());
                    $("#report"+reportID).height($(window).height());
                }
                openURL();
            } else {
                var notGetReportView = reportSettings.item("notGetReportView") && (reportSettings.item("notGetReportView").reportSettingValue == "1") ? ("&notGetReportView=1") : ("&notGetReportView=0");
                window.location.href = (baseUrl.split("report.jsp")[0]) + "index.jsp" + "?" + allParameters + notGetReportView + "&useComputerStyleForMobile="+(reportSettings.item("useComputerStyleForMobile")?parseInt(reportSettings.item("useComputerStyleForMobile").reportSettingValue):0);
            }
        };
        reportSettings.getItems(basePath,reportID,succ,fail);
    }

    function getReportName(reportID){
        ajaxTools.request(basePath+"/Report/reports/"+reportID+"/simpleProperties", "","get", function(data,status,jqXHR){
            if(status == 'success'){
                var reportName = data.item.reportName;
                document.title = reportName;
            }
        },function(XHR,textStatus){
            fail("获取报表名称",XHR,textStatus);
        });
    }

    function openURL(){
        //if(deviceTypeID==2){
        var notGetReportView = reportSettings.item("notGetReportView") && (reportSettings.item("notGetReportView").reportSettingValue == "1") ? ("&notGetReportView=1") : ("&notGetReportView=0");
        var showPFinReport = reportSettings.item("showPFinReport") && (reportSettings.item("showPFinReport").reportSettingValue == "1") ? ("&showPFinReport=1") : ("&showPFinReport=0");
        var url = baseUrl.split("report.jsp")[0] + "index.jsp" + "?" + allParameters + notGetReportView + showPFinReport;
        $(".report"+reportID).attr("src",url);
            // window.open(,'report'+reportID);
        //}else{
        //    window.location.href = baseUrl.split("report.jsp")[0]+"index.jsp"+"?"+allParameters;
        //}
    }

    $(window).resize(function(){
        if(reportSettings.item("followDesignSize") && parseInt(reportSettings.item("followDesignSize").reportSettingValue)) {
            setIframeSize();
        }else{
            $("#report"+reportID).width($(window).width());
            $("#report"+reportID).height($(window).height());
        }
    });

    function setIframeSize(){
        var screenWidth = $(window).width();
        var screenHeight = $(window).height();
        var defaultWidth = parseInt(reportSettings.item("pageWidth").reportSettingValue);
        var defaultHeight = parseInt(reportSettings.item("pageHeight").reportSettingValue);

        if((screenWidth*defaultHeight)/defaultWidth > screenHeight){
            $("#report"+reportID).width((defaultWidth*screenHeight)/defaultHeight);
            $("#report"+reportID).height(screenHeight);
        }else{
            $("#report"+reportID).width(screenWidth);
            $("#report"+reportID).height((screenWidth*defaultHeight)/defaultWidth);
        }
        $("#report"+reportID).css({
            "position": "absolute",
            "top": "50%",
            "left": "50%",
            "margin-top": -$("#report"+reportID).height()/2,
            "margin-left": -$("#report"+reportID).width()/2
        });
        $("body").css("background-color","rgba(0,0,0,1)");
    }

    function isJson(str){
        if (typeof str == 'string') {
            try {
                var obj = JSON.parse(str);
                if(typeof obj == 'object' && obj ){
                    return true;
                }else{
                    return false;
                }
            } catch(e) {
                return false;
            }
        }
    }

    window.addEventListener('message',function (e) { 
        if(e.data.key == "refresh"){
            refresh();
        }
        if(e.data.key == "exportToExcel"){
            exportToExcel(e.data.value);
        }
        if(e.data.key == "printing"){
            printing();
        }
        if(e.data.key == "transmitReportSettings"){
            transmitReportSettings();
        }
        if(e.data.key == "transmitReportView"){
            transmitReportView();
        }
    });

    window.loaded = function(){
        try{
            window.external.loaded();
        }catch(e) {
            return false;
        }
    };

    window.linkReport = function(url,isCurrentWindow){
        if(isCurrentWindow){
            window.location.href = url;
        }else{
            if(sendLinkReport(url)){
                
            }else if($BDA.deviceTypeID.mac&&window.webkit){
                var message = {
                    url: url
                }
                window.webkit.messageHandlers.linkReport.postMessage(message);
            }else if($BDA.deviceTypeID.IOS&&window.webkit){
               var message = {
                   url: url
               }
               window.webkit.messageHandlers.linkReport.postMessage(message);
            }else if(window.Android && window.Android.linkReport){
                Android.linkReport(url);
            }else if(top.location != self.location){
                try{
                    window.top.linkReport(url);
                }catch(e) {
                    var msg = {key:"linkReport",value:url};
                    window.parent.postMessage(msg,"*")
                }
            }else {
                window.location.href = url;
            }
        }
    };

    function sendLinkReport(url){
        var result = true;
        try{
            window.external.linkReport(url);
        }catch(e) {
            result = false;
        }
        return result;
    }

    window.transmitReportView = function(){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        var reportView = childWindow.transmitReportView();

        if(top.location != self.location){
            try{
                window.parent.quitFullScreen();
                return reportView;
            }catch(e) {
                reportView = JSON.stringify(reportView);
                var msg = {key:"transmitReportView",value:reportView};
                window.parent.postMessage(msg,"*");
            }
        }
    };

    window.transmitReportSettings = function(){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        if(top.location != self.location){
            try{
                window.parent.quitFullScreen();
                return childWindow.transmitReportSettings();
            }catch(e) {
                var reportSettings = JSON.stringify(childWindow.transmitReportSettings());
                var msg = {key:"transmitReportSettings",value:reportSettings};
                window.parent.postMessage(msg,"*");
            }
        }

    };

    window.getBlockContent = function(blockID,objectName){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        return childWindow.getBlockContent(blockID,objectName);
    };

    window.exportToExcel = function(reportName){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        childWindow.exportToExcel(reportName);
    };

    window.printing = function(){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        childWindow.printing();
    };

    window.getPromptFilterString = function(){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        return childWindow.getPromptFilterString();
    };

    window.closeFilter = function(){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        childWindow.closeFilter();
    };

    window.refresh = function(){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        childWindow.refresh();
    };

    window.openFilter = function(){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        childWindow.openFilter();
    };

    // window.closeFilter = function(deviceTypeID){
    //     if(deviceTypeID == 0){
    //         $BDA.JS2Other.show();
    //     }else{
    //         window.webkit.messageHandlers.changeConnectState.postMessage(null);
    //     }
    // };

    window.redrawForPad = function(){
        var childWindow = $("#report"+reportID)[0].contentWindow;
        childWindow.redrawForPad();
    };

    window.quitFullScreen = function(){
        try{
            window.top.quitFullScreen();
        }catch(e) {
            var msg = {key:"quitFullScreen",value:""};
            window.top.postMessage(msg,"*");
            // result = false;
        }
        // if(window.parent && window.parent.quitFullScreen){
        //     window.parent.quitFullScreen();
        // }
    }

    window.magnify = function(){
        if(window.parent && window.parent.magnify){
            window.parent.magnify();
        }
    }

    document.body.onkeydown = function(e){
        var ev = e||window.event;
        var code = ev.keyCode;
        if(code == 27){
            isESCPress = true;
        }
        if(isESCPress && window.parent.quitFullScreen){
            quitFullScreen();
        }
        if(code == 122 && ev.ctrlKey){
            magnify();
        }
    };

    document.body.onkeyup = function(e){
        var ev = e||window.event;
        if(ev.keyCode == 27){
            isESCPress = false
        }
    };

})($);

function ReportSetting(options){
    this.reportSettingKey = options.reportSettingKey;
    this.reportSettingValue = options.reportSettingValue;
}

function ReportSettings(){
    var me = this;
    this.count = 0;
    this.dicreportSettings = {};
    this.aryreportSettings = [];

    this.add = function (reportSetting) {
        this.aryreportSettings.push(reportSetting);
        this.dicreportSettings[reportSetting.reportSettingKey]=reportSetting;

        this.count = this.aryreportSettings.length;
    };
    this.remove = function (reportSetting) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryreportSettings[i].reportSettingKey==reportSetting.reportSettingKey){
                k=i;
                break;
            }
        }
        this.aryreportSettings.splice(k,1);
        delete this.dicreportSettings[reportSetting.reportSettingKey];

        this.count=this.aryreportSettings.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryreportSettings[indexOrKey];
        }else{
            return this.dicreportSettings[indexOrKey];
        }
    };

    this.setReportSettings = function (data) {
        this.count = 0;
        this.dicreportSettings = {};
        this.aryreportSettings = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var reportSetting = new ReportSetting(data[intI]);
            this.add(reportSetting);
        }
    };
    
    this.getItems = function(basePath,reportID,succ,fail){
        ajaxTools.request(basePath+"/Report/reports/"+reportID+"/reportSettings", "","get", function(data, status, jqXHR){
            if(status == 'success'){
                me.setReportSettings(data.property);
                succ();
            }
        }, function(XHR, statusText){
            fail("获取报表设置",XHR, statusText);
        });
    };

    this.getShareItems = function(basePath,shareID,succ,fail){
        ajaxTools.request(basePath+"/Report/linkShares/"+shareID+"/reportSettings", "","get", function(data, status, jqXHR){
            if(status == 'success'){
                me.setReportSettings(data.property);
                succ();
            }
        }, function(XHR, statusText){
            fail("获取报表设置",XHR, statusText);
        });
    }
}