function Report(reportID,basePath){
    this.reportID = reportID;
    this.basePath = basePath;
    this.domain = this.basePath + '/Report/reports/';
    this.uri = '/reportView';
    this.viewBusinessObjectHierarchies = {};
    this.reportView = {};
    this.charts = new Charts();
    /*暂定默认值*/
    this.pcPages = new PcPages();
    this.padPages = new PadPages();
    this.mobilePages = new MobilePages();
    this.viewBlocks = new ViewBlocks();
    this.viewVerticalTableBlocks = new ViewVerticalTableBlocks();
    this.viewHorizontalTableBlocks = new ViewHorizontalTableBlocks();
    this.viewPivotTableBlocks = new ViewPivotTableBlocks();
    this.viewChartBlocks = new ViewChartBlocks();
    this.viewTileBlocks = new ViewTileBlocks();
    this.viewGaugeBlocks = new ViewGaugeBlocks();
    this.viewMapBlocks = new ViewMapBlocks();
    this.reportSettings = new reportSettings();
    this.viewLabelBlocks = new ViewLabelBlocks();
    this.viewFoldingTableBlocks = new ViewFoldingTableBlocks();
    this.viewReportContainerBlocks = new ViewReportContainerBlocks();
    this.viewButtonBlocks = new ViewButtonBlocks();
    this.viewEquipmentBlocks = new ViewEquipmentBlocks();
    this.viewGanttBlocks = new ViewGanttBlocks();
    this.viewTabControlBlocks = new ViewTabControlBlocks();
    this.viewFreeTableBlocks = new ViewFreeTableBlocks();

    this.init = function( requestParameters, deviceTypeID, success, error){
        var me=this;
        //var parameters = {
        //    parameters: requestParameters
        //}
        //parameters = JSON.stringify(parameters);
        ////requestParameters = requestParameters?("parameters="+requestParameters):"";
        ajaxTools.request(this.domain+this.reportID+this.uri, requestParameters,"post", function(data,status,jqXHR){
            if(status == 'success'){
                setReportView(me,data,success,deviceTypeID);
            }
        },function(XHR,textStatus){
            error("获取报表",XHR,textStatus);
        });
    };

    this.shareInit = function(shareID,passwordObj,deviceTypeID,success,error){
        var me=this;
        if(passwordObj != ""){
            passwordObj = "?sharePassword="+encodeURIComponent(passwordObj.sharePassword);
        }
        ajaxTools.request(this.basePath+"/Report/linkShares/"+shareID+this.uri+passwordObj,"","get", function(data,status,jqXHR){
            if (status == 'success') {
                var token = jqXHR.getResponseHeader('token');
                var reportID = jqXHR.getResponseHeader('reportID');
                setReportView(me, data, success, deviceTypeID, token, reportID);
            }
        },function(XHR,textStatus){
            error("获取报表",XHR,textStatus);
        });
    }

    function setReportView(me, data, success, deviceTypeID, token, reportID){
        me.reportView = data.property;
        me.viewBusinessObjectHierarchies = data.property.viewBusinessObjectHierarchies;
        me.pcPages.getPages(data.property.pcPages);
        me.padPages.getPages(data.property.padPages);
        me.mobilePages.getPages(data.property.mobilePages);
        me.viewBlocks = new ViewBlocks();

        me.viewChartBlocks.setViewChartBlocks(data.property.viewChartBlocks);
        me.viewVerticalTableBlocks.setViewVerticalTableBlocks(data.property.viewVerticalTableBlocks);
        me.viewHorizontalTableBlocks.setViewHorizontalTableBlocks(data.property.viewHorizontalTableBlocks);
        me.viewPivotTableBlocks.setViewPivotTableBlocks(data.property.viewPivotTableBlocks);
        me.viewTileBlocks.setViewTileBlocks(data.property.viewTileBlocks);
        me.viewGaugeBlocks.setViewGaugeBlocks(data.property.viewGaugeBlocks);
        me.viewMapBlocks.setViewMapBlocks(data.property.viewMapBlocks);
        me.viewLabelBlocks.setViewLabelBlocks(data.property.viewLabelBlocks);
        me.viewFoldingTableBlocks.setViewFoldingTableBlocks(data.property.viewFoldingTableBlocks);
        me.viewReportContainerBlocks.setViewReportContainerBlocks(data.property.viewReportContainerBlocks);
        me.viewButtonBlocks.setViewButtonBlocks(data.property.viewButtonBlocks);
        me.viewEquipmentBlocks.setViewEquipmentBlocks(data.property.viewEquipmentBlocks);
        me.viewGanttBlocks.setViewGanttBlocks(data.property.viewGanttBlocks);
        me.viewTabControlBlocks.setViewTabControlBlocks(data.property.viewTabControlBlocks);
        me.viewFreeTableBlocks.setViewFreeTableBlocks(data.property.viewFreeTableBlocks);

        me.viewBlocks.addAll(me.viewChartBlocks);
        me.viewBlocks.addAll(me.viewVerticalTableBlocks);
        me.viewBlocks.addAll(me.viewHorizontalTableBlocks);
        me.viewBlocks.addAll(me.viewPivotTableBlocks);
        me.viewBlocks.addAll(me.viewTileBlocks);
        me.viewBlocks.addAll(me.viewGaugeBlocks);
        me.viewBlocks.addAll(me.viewMapBlocks);
        me.viewBlocks.addAll(me.viewLabelBlocks);
        me.viewBlocks.addAll(me.viewFoldingTableBlocks);
        me.viewBlocks.addAll(me.viewReportContainerBlocks);
        me.viewBlocks.addAll(me.viewButtonBlocks);
        me.viewBlocks.addAll(me.viewEquipmentBlocks);
        me.viewBlocks.addAll(me.viewGanttBlocks);
        me.viewBlocks.addAll(me.viewTabControlBlocks);
        me.viewBlocks.addAll(me.viewFreeTableBlocks);

        me.reportSettings.getReportSettings(data.property.reportSettings);

        if(deviceTypeID == 2 && parseInt(me.reportSettings.scaleByScreenSize)){
            $BDA.setHtmlFontSize(false,me);
        }

        if(deviceTypeID != 2){
            eliminatePageIDNonExistentBlock(me.viewBlocks,deviceTypeID);
        }


        if(me.reportSettings.nullDisplayWithZero && me.reportSettings.nullDisplayWithZero == 1){
            setBlockDataMeasuresValue(me.viewBlocks);
        }

        copyBlockDataToBlockDataToDraw(me.viewBlocks);

        //为所有的block加载联动的过滤维度及数据，如果该block受其它图表联动
        loadAllBlocksLinkageParameters(me.viewBlocks);

        removeAllBlockDataToDrawUnusefulValue(me.viewBlocks);

        sortViewBlocksByPages(me, deviceTypeID);

        me.charts.getCharts(me.viewBlocks);

        success(token, reportID);
    }

    function eliminatePageIDNonExistentBlock(vieBlocks,deviceTypeID){
        for(var i = vieBlocks.count - 1; i >= 0; i--){
            if(!vieBlocks.item(i).blockLayouts[deviceTypeID].pageID){
                vieBlocks.remove(vieBlocks.item(i));
            }
        }
    }

    function copyBlockDataToBlockDataToDraw(viewBlocks){
        for(var i = 0; i < viewBlocks.count; i++){
            $.extend(true,viewBlocks.item(i).blockDataToDraw,viewBlocks.item(i).blockData);
        }
    }

    function sortViewBlocksByPages(me, deviceTypeID){
        var pages = {};
        var tempViewBlocks = new ViewBlocks();

        if (deviceTypeID == 0){
            pages = me.mobilePages;
        }else if (deviceTypeID == 1){
            pages = me.padPages;
        }else{
            pages = me.pcPages;
        }
        for (var i = 0; i < pages.count;i++){
            var blocksOfcurrentPage = [];
            var tabBlocks = [];
            for (var j = 0;j < me.viewBlocks.count;j++){
                if (pages.item(i).pageID === me.viewBlocks.item(j).blockLayouts[deviceTypeID].pageID && !me.viewBlocks.item(j).blockLayouts[deviceTypeID].containerID){
                    blocksOfcurrentPage.push(me.viewBlocks.item(j));
                }
                if (pages.item(i).pageID === me.viewBlocks.item(j).blockLayouts[deviceTypeID].pageID && me.viewBlocks.item(j).blockLayouts[deviceTypeID].containerID){
                    tabBlocks.push(me.viewBlocks.item(j));
                }
            }

            for (var k = 0; k < blocksOfcurrentPage.length-1; k++){
                for (var n = k+1; n < blocksOfcurrentPage.length; n++){
                    var layout_k = blocksOfcurrentPage[k].blockLayouts[deviceTypeID];
                    var layout_n = blocksOfcurrentPage[n].blockLayouts[deviceTypeID];

                    if (layout_k.top * pages.item(i).columns + layout_k.left > layout_n.top * pages.item(i).columns + layout_n.left){
                        blocksOfcurrentPage[k] = [blocksOfcurrentPage[n], blocksOfcurrentPage[n]=blocksOfcurrentPage[k]][0];
                    }
                }
            }
            $.each(blocksOfcurrentPage,function(m){
                tempViewBlocks.add(blocksOfcurrentPage[m]);
            });
            $.each(tabBlocks,function(m){
                tempViewBlocks.add(tabBlocks[m]);
            });
        }

        me.viewBlocks = tempViewBlocks;
    }

    function loadAllBlocksLinkageParameters(viewBlocks){
        //var viewBlock = null;

        for (var i = 0; i < viewBlocks.count; i++) {
            //viewBlock = viewBlocks.item(i);
            loadLinkageParameters(viewBlocks.item(i), viewBlocks);
        }
    }

    function loadLinkageParameters(viewBlock, viewBlocks){
        var viewLinkageBlock = null;

        for(var j = 0; j < viewBlocks.count; j++){
            viewLinkageBlock = viewBlocks.item(j);
            if (viewBlock.blockID != viewLinkageBlock.blockID){
                if(viewLinkageBlock.linkage && viewLinkageBlock.linkage.blockIDs.indexOf(viewBlock.blockID)>-1){
                    if(viewLinkageBlock.chartID == 44 && viewLinkageBlock.defaultSelected){
                        for (var i = 0; i < viewLinkageBlock.getLinkageParameters().length; i++){
                            viewBlock.linkageParameters.push(viewLinkageBlock.getLinkageParameters()[i]);
                        }
                        loadCurrentBlockDataToDraw(viewBlock);
                        if(viewBlock.linkage){
                            loadChildrensLinkageParameters(viewBlock, viewBlocks);
                        }
                    }else if(viewLinkageBlock.chartID != 44){
                        for (var i = 0; i < viewLinkageBlock.getLinkageParameters().length; i++){
                            viewBlock.linkageParameters.push(viewLinkageBlock.getLinkageParameters()[i]);
                        }
                        loadCurrentBlockDataToDraw(viewBlock);
                        if(viewBlock.linkage){
                            loadChildrensLinkageParameters(viewBlock, viewBlocks);
                        }
                    }
                }
            }
        }
    }

    function loadChildrensLinkageParameters(viewBlock, viewBlocks){
        var viewLinkageBlock = null;

        for(var i = 0; i < viewBlocks.count; i++){
            viewLinkageBlock = viewBlocks.item(i);
            if(viewBlock.linkage.blockIDs.indexOf(viewLinkageBlock.blockID) > -1){
                viewLinkageBlock.linkageParameters.push.apply(viewLinkageBlock.linkageParameters,viewBlock.linkageParameters);
                loadCurrentBlockDataToDraw(viewLinkageBlock);
                if(viewLinkageBlock.linkage){
                    loadChildrensLinkageParameters(viewLinkageBlock, viewBlocks);
                }
            }
        }
    }

    function loadCurrentBlockDataToDraw(viewBlock){
        if(viewBlock.linkageParameters.length){
            var linkageParameter;
            for (var j = 0; j < viewBlock.linkageParameters.length; j++){
                linkageParameter = viewBlock.linkageParameters[j];
                for (var k = viewBlock.blockDataToDraw.length-1; k >= 0; k--){
                    if (viewBlock.blockDataToDraw[k][linkageParameter.queryName+"___"+linkageParameter.dimensionName] != linkageParameter.dimensionValue){
                        viewBlock.blockDataToDraw.splice(k,1);
                    }
                }
            }
            if(viewBlock.chartID == 0 && viewBlock.blockDataToDraw.length > 1){
                for(var key in viewBlock.blockDataToDraw[0]){
                    viewBlock.blockDataToDraw[0][key] = "#MultiValue";
                }
            }
            //viewBlock.removeBlockDataToDrawUnusefulValue();
        }else{
            if(viewBlock.chartID == 0 && viewBlock.blockDataToDraw.length > 1){
                for(var key in viewBlock.blockDataToDraw[0]){
                    viewBlock.blockDataToDraw[0][key] = "#MultiValue";
                }
            }
        }
    }

    function removeAllBlockDataToDrawUnusefulValue(viewBlocks){
        for(var i = 0; i < viewBlocks.count; i++){
            if(viewBlocks.item(i).linkageParameters.length){
                viewBlocks.item(i).removeBlockDataToDrawUnusefulValue();
            }
        }
    }

    function setBlockDataMeasuresValue(viewBlocks){
        for(var i = 0; i < viewBlocks.count; i++){
            viewBlocks.item(i).setBlockData();
        }
    }

    this.loadBlockDataToDraw = function (viewBlock){
        $.extend(true,viewBlock.blockDataToDraw,viewBlock.blockData);
        if(viewBlock.linkageParameters.length){
            var linkageParameter;
            for (var j = 0; j < viewBlock.linkageParameters.length; j++){
                linkageParameter = viewBlock.linkageParameters[j];
                for (var k = viewBlock.blockDataToDraw.length-1; k >= 0; k--){
                    if (viewBlock.blockDataToDraw[k][linkageParameter.queryName+"___"+linkageParameter.dimensionName] != linkageParameter.dimensionValue){
                        viewBlock.blockDataToDraw.splice(k,1);
                    }
                }
            }
            if(viewBlock.chartID == 0 && viewBlock.blockDataToDraw.length > 1){
                for(var key in viewBlock.blockDataToDraw[0]){
                    viewBlock.blockDataToDraw[0][key] = "#MultiValue";
                }
            }
            viewBlock.removeBlockDataToDrawUnusefulValue();
        }else{
            if(viewBlock.chartID == 0 && viewBlock.blockDataToDraw.length > 1){
                for(var key in viewBlock.blockDataToDraw[0]){
                    viewBlock.blockDataToDraw[0][key] = "#MultiValue";
                }
            }
        }
    }
}

/*类---chart*/
function Chart(strType, strBDAChartID, strTitle, viewBlock, colors){
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = {sum: 0, itemCount: 0, items: []};
    this.colors = colors || {};
}

Chart.prototype = {
    draw : function(){},
    move : function(fltX, fltY){},
    touchStart : function(fltX, fltY){},
    touchMove : function(fltX, fltY){},
    touchEnd : function(){},
    changeDimension : function(){},
    changeMeasure : function(){},
    changeGrouping : function(){},
    selectChart : function(){
        $(this.chartID).addClass("bda-chart-selected"); /*选中*/
    },
    unSelectChart : function(){
        $(this.chartID).removeClass("bda-chart-selected");  /*除去选中*/
    },
    setChartTitleContent : function(viewBlock){
        if(!viewBlock.title){return;}
        $(this.chartID).find('h3').html('').prepend('<span></span>');
        viewBlock.titleExpression = $.trim(viewBlock.titleExpression);
        if(viewBlock.titleExpression.indexOf("=") != -1 && viewBlock.titleExpression.indexOf("=") == 0){
            var titleArr = viewBlock.titleExpression.split("+");
            titleArr[0] = titleArr[0].substr(1,titleArr[0].length-1);
            $.each(titleArr,function(i){
                titleArr[i] = $.trim(titleArr[i]);
                if(titleArr[i].indexOf("[") != -1){
                    titleArr[i] = titleArr[i].replace(/\s*/g,"")+"";
                    var queryName = (titleArr[i].match(/\[(.+?)\]/g))[0];
                    queryName = queryName.substr(1,queryName.length-2);
                    var objcecName = (titleArr[i].match(/\[(.+?)\]/g))[1];
                    objcecName = objcecName.substr(1,objcecName.length-2);
                    if(titleArr[i].indexOf("Linkage(") != -1){
                        for(var j = 0; j < viewBlock.linkageParameters.length; j++){
                            if(queryName == viewBlock.linkageParameters[j].queryName && objcecName == viewBlock.linkageParameters[j].dimensionName){
                                if(viewBlock.linkageParameters[j].dataType == 1){
                                    titleArr[i] = $BDA.formatString.date("",new Date(viewBlock.linkageParameters[j].dimensionValue))+"";
                                }else{
                                    titleArr[i] = viewBlock.linkageParameters[j].dimensionValue+"";
                                }
                                break;
                            }
                        }
                    }
                    if(titleArr[i].indexOf("Sum(") != -1){
                        var sum = 0;
                        for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
                            sum += (viewBlock.blockDataToDraw[j][queryName+"___"+objcecName]?viewBlock.blockDataToDraw[j][queryName+"___"+objcecName]:0);
                        }
                        titleArr[i] = $BDA.formatString.number($BDA.getFormatType(viewBlock,queryName+"___"+objcecName),sum) + "";
                    }
                    if(titleArr[i] != "Invalid Date"){
                        if(titleArr[i].indexOf("[") != -1){ titleArr[i] = "";}//linkageParameters没有包含当前参数;
                    }
                }else{
                    titleArr[i] = titleArr[i].substr(1,titleArr[i].length-2);
                }
            });
            $(this.chartID).find('h3 span').html(titleArr.join(""));
        }else{
            $(this.chartID).find('h3 span').html(viewBlock.title||'');
        }
        if(viewBlock.titleIcon){
            var str = "<img src='/Report/"+viewBlock.titleIcon.imageURL+"' style='width: "+viewBlock.titleTextBox.font.size/100+"rem; height: "+viewBlock.titleTextBox.font.size/100+"rem;'>";
            $(this.chartID).find('h3').prepend(str);
        }
    },
    setChartTitleStyle : function(viewBlock,useComputerStyleForMobile){
        var titleTextBox = viewBlock.titleTextBox;
        var customColorApplyOtherThemes = viewBlock.customColorApplyOtherThemes || false;
        $(this.chartID).find('h3').css({
            'height': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height:(titleTextBox.height/100+"rem"),
            'line-height': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?(titleTextBox.height+"px"):(titleTextBox.height/100+'rem'),
            'overflow': "hidden",
            'color': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?($BDA.theme.currentBackgroundColor?"#d2d2d2":"#333"):($BDA.theme.currentBackgroundColor?(customColorApplyOtherThemes?$BDA.csharp2rgba(titleTextBox.color):'#d2d2d2'):$BDA.csharp2rgba(titleTextBox.color)),
            'font-family': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'Arial':(titleTextBox.font.fontFamily || 'Arial'),
            'font-size': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'13px':((titleTextBox.font.size >40)?'0.40rem': titleTextBox.font.size/100+"rem"),
            'font-weight': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'normal':(titleTextBox.font.bold?'bold':'normal'),
            'font-style': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'normal':(titleTextBox.font.italic?'italic':'normal'),
            'text-decoration': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'none':(titleTextBox.font.underline?'underline':(titleTextBox.font.strikeout?'line-through':'none')),
            'text-align': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'left':(titleTextBox.textAlign == "0"?'left':(titleTextBox.textAlign == "1"?'center':'right')),
            'border-bottom-width': (viewBlock.titleBottomBorderWidth?viewBlock.titleBottomBorderWidth/100:0)+"rem",
            'border-bottom-color': viewBlock.titleBottomBorderColor?$BDA.csharp2rgba(viewBlock.titleBottomBorderColor):"#e8e8e8",
            'border-bottom-style': 'solid'
        });
        if(!viewBlock.backgroundColorTransparent){
            $(this.chartID).find('h3').css({
                'background-color': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0) ? ($BDA.theme.currentBackgroundColor ? $BDA.theme.currentBackgroundColor : '#ffffff') : ($BDA.theme.currentBackgroundColor ? (customColorApplyOtherThemes ? $BDA.csharp2rgba(titleTextBox.backgroundColor) : $BDA.theme.currentBackgroundColor) : $BDA.csharp2rgba(titleTextBox.backgroundColor)),
            });
        }
        if(!viewBlock.showToolButtons){
            $(this.chartID).find('.chart-drill-toolbar,.chart-link-toolbar').hide();
        }
        $(this.chartID).find('.chart-drill-toolbar').css({
            'width':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.8:titleTextBox.height*0.8/100+"rem",
            'height':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.8:titleTextBox.height*0.8/100+"rem"
        }).find('span').css({
            'width':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.8:titleTextBox.height*0.8/100+"rem",
            'height':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.8:titleTextBox.height*0.8/100+"rem",
            'background-size':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.6:titleTextBox.height*0.6/100+"rem"
        });
        $(this.chartID).find('.chart-link-toolbar').css({
            'width':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.8:titleTextBox.height*0.8/100+"rem",
            'height':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.8:titleTextBox.height*0.8/100+"rem"
        }).find('span').css({
            'width':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.8:titleTextBox.height*0.8/100+"rem",
            'height':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.8:titleTextBox.height*0.8/100+"rem",
            'background-size':(ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleTextBox.height*0.6:titleTextBox.height*0.6/100+"rem"
        });
        if (titleTextBox.adjustWidthAccordingToText){
            $(this.chartID).find('h3').css({
                'background-color': 'transparent',
                'border-radius': 0
            }).find('span').css({
                'background-color': $BDA.theme.currentBackgroundColor?(customColorApplyOtherThemes?$BDA.csharp2rgba(titleTextBox.backgroundColor):$BDA.theme.currentBackgroundColor):$BDA.csharp2rgba(titleTextBox.backgroundColor),
                'border-radius': titleTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
            });
        }
    },
    setChartSubtitleContent:function(viewBlock){
        if(!viewBlock.subtitle || (viewBlock.ChartStyle && viewBlock.ChartStyle.subtitleInCircle)){return;}
        viewBlock.subtitleExpression = $.trim(viewBlock.subtitleExpression);
        if(viewBlock.subtitleExpression.indexOf("=") != -1 && viewBlock.subtitleExpression.indexOf("=") == 0){
            var titleArr = viewBlock.subtitleExpression.split("+");
            titleArr[0] = titleArr[0].substr(1,titleArr[0].length-1);
            $.each(titleArr,function(i){
                titleArr[i] = $.trim(titleArr[i]);
                if(titleArr[i].indexOf("[") != -1){
                    titleArr[i] = titleArr[i].replace(/\s*/g,"")+"";
                    var queryName = (titleArr[i].match(/\[(.+?)\]/g))[0];
                    queryName = queryName.substr(1,queryName.length-2);
                    var objcecName = (titleArr[i].match(/\[(.+?)\]/g))[1];
                    objcecName = objcecName.substr(1,objcecName.length-2);
                    if(titleArr[i].indexOf("Linkage(") != -1){
                        for(var j = 0; j < viewBlock.linkageParameters.length; j++){
                            if(queryName == viewBlock.linkageParameters[j].queryName && objcecName == viewBlock.linkageParameters[j].dimensionName){
                                if(viewBlock.linkageParameters[j].dataType == 1){
                                    titleArr[i] = $BDA.formatString.date("",new Date(viewBlock.linkageParameters[j].dimensionValue))+"";
                                }else{
                                    titleArr[i] = viewBlock.linkageParameters[j].dimensionValue+"";
                                }
                                break;
                            }
                        }
                    }
                    if(titleArr[i].indexOf("Sum(") != -1){
                        var sum = 0;
                        for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
                            sum += (viewBlock.blockDataToDraw[j][queryName+"___"+objcecName]?viewBlock.blockDataToDraw[j][queryName+"___"+objcecName]:0);
                        }
                        titleArr[i] = $BDA.formatString.number($BDA.getFormatType(viewBlock,queryName+"___"+objcecName),sum) + "";
                    }
                    if(titleArr[i] != "Invalid Date"){
                        if(titleArr[i].indexOf("[") != -1){ titleArr[i] = "";}//linkageParameters没有包含当前参数;
                    }
                }else{
                    titleArr[i] = titleArr[i].substr(1,titleArr[i].length-2);
                }
            });
            $(this.chartID).find('h5').css('display','block').find('span').html(titleArr.join(""));
        }else{
            $(this.chartID).find('h5').css('display','block').find('span').html(viewBlock.subtitle||'');
        }
    },
    setChartSubtitleStyle:function(viewBlock,useComputerStyleForMobile){
        if (!viewBlock.subtitle)return;
        var subtitleTextBox = viewBlock.subtitleTextBox;
        var customColorApplyOtherThemes = viewBlock.customColorApplyOtherThemes || false;
        $(this.chartID).find('h5').css({
            'color': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?($BDA.theme.currentBackgroundColor?"#d2d2d2":"#333"):($BDA.theme.currentBackgroundColor?(customColorApplyOtherThemes?$BDA.csharp2rgba(subtitleTextBox.color):'#d2d2d2'):$BDA.csharp2rgba(subtitleTextBox.color)),
            'font-family': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'Arial':(subtitleTextBox.font.fontFamily || 'Arial'),
            'font-size': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'12px':(subtitleTextBox.font.size/100+"rem" || '0.12rem'),
            'font-weight': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'normal':(subtitleTextBox.font.bold?'bold':'normal'),
            'font-style': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'normal':(subtitleTextBox.font.italic?'italic':'normal'),
            'text-decoration': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'none':(subtitleTextBox.font.underline?'underline':(subtitleTextBox.font.strikeout?'line-through':'none')),
            'text-align': viewBlock.singleLineTitleBar?'right':((ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'left':(subtitleTextBox.textAlign == "0"?'left':(subtitleTextBox.textAlign == "1"?'center':'right')))
        });
        if(viewBlock.singleLineTitleBar){
            var titleHeight = $(this.chartID).find('h3').height();
            $(this.chartID).find('h5').css({
                'position': 'absolute',
                'display': 'inline-block',
                'top': 0,
                'right': 0,
                //'left': 0,
                'box-sizing': 'border-box',
                'height': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?titleHeight:(titleHeight/100+"rem"),
                'line-height': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?(titleHeight+"px"):(titleHeight/100+'rem'),
            });
            if(viewBlock.showToolButtons){
                $(this.chartID).find('h5').css({
                    'right': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?"5px":'0.50rem'
                });
            }
        }
        if(!viewBlock.singleLineTitleBar){
            $(this.chartID).find('h5').css({
                'height': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?subtitleTextBox.height:(subtitleTextBox.height/100+"rem"),
                'line-height': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?(subtitleTextBox.height+"px"):(subtitleTextBox.height/100 + 'rem'),
                'background-color': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?($BDA.theme.currentBackgroundColor?$BDA.theme.currentBackgroundColor:'#ffffff'):($BDA.theme.currentBackgroundColor?(customColorApplyOtherThemes?$BDA.csharp2rgba(subtitleTextBox.backgroundColor):$BDA.theme.currentBackgroundColor):$BDA.csharp2rgba(subtitleTextBox.backgroundColor)),
                'border-radius': subtitleTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
            });
        }
        if (subtitleTextBox.adjustWidthAccordingToText){
            if(!viewBlock.singleLineTitleBar ){
                $(this.chartID).find('h5').css({
                    'background-color': 'transparent',
                    'border-radius': 0
                }).find('span').css({
                    'background-color': $BDA.theme.currentBackgroundColor?(customColorApplyOtherThemes?$BDA.csharp2rgba(subtitleTextBox.backgroundColor):$BDA.theme.currentBackgroundColor):$BDA.csharp2rgba(subtitleTextBox.backgroundColor),
                    'border-radius': subtitleTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
                });
            }
        }
    },
    setChartMarkContent : function(viewBlock){
        if (!viewBlock.remark)return;
        $(this.chartID).find('.bda-remark').html(viewBlock.remark.replace(/\r\n/g,'<br/>')).css('display','block');
    },
    setChartMarkStyle : function(viewBlock,useComputerStyleForMobile){
        var customColorApplyOtherThemes = viewBlock.customColorApplyOtherThemes || false;
        if (viewBlock.remark){
            var remarkTextBox = viewBlock.remarkTextBox;
            $(this.chartID).find('.bda-remark').css({
                'background-color': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?($BDA.theme.currentBackgroundColor?$BDA.theme.currentBackgroundColor:'#ffffff'):($BDA.theme.currentBackgroundColor?(customColorApplyOtherThemes?$BDA.csharp2rgba(remarkTextBox.backgroundColor):$BDA.theme.currentBackgroundColor):$BDA.csharp2rgba(remarkTextBox.backgroundColor)),
                'font-family': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'Arial':(remarkTextBox.font.fontFamily || 'Arial'),
                'font-size': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'12px':(remarkTextBox.font.size/100+"rem" || '0.12rem'),
                'font-weight': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'normal':(remarkTextBox.font.bold?'bold':'normal'),
                'font-style': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'normal':(remarkTextBox.font.italic?'italic':'normal'),
                'text-decoration': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?'none':(remarkTextBox.font.underline?'underline':(remarkTextBox.font.strikeout?'line-through':'none')),
                'color': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?($BDA.theme.currentBackgroundColor?"#d2d2d2":"#333"):($BDA.theme.currentBackgroundColor?(customColorApplyOtherThemes?$BDA.csharp2rgba(remarkTextBox.color):'#d2d2d2'):$BDA.csharp2rgba(remarkTextBox.color)),
                'border-top': $BDA.theme.currentBackgroundColor?('0.01rem solid #fff'):('0.01rem solid #ddd'),
                //'margin': '0 10px',
                'padding': (ajaxTools.deviceTypeID<2 && useComputerStyleForMobile && useComputerStyleForMobile == 0)?"5px 10px":'0.05rem 0.10rem',
                'border-radius': remarkTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
            })
        }
        //if($BDA.theme.currentBackgroundColor&&!customColorApplyOtherThemes){
        //    $(this.chartID).find('.bda-remark').css({
        //        'background-color': $BDA.theme.currentBackgroundColor,
        //        'color': "#fff",
        //        'border-top':'1px solid #fff'
        //    });
        //}
    },
    setChartContentHeight : function(fltHeight){
        var fltChartContentWidth = parseFloat($(this.chartID).find(".bda-chart-box").width());
        var fltChartHeight = fltHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        fltChartHeight = fltChartHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        var fltTitleHeight = $(this.chartID).find("h3").height();
        var jqueryH5 = $(this.chartID).find("h5");
        var fltSubtitleHeight = jqueryH5.height()*(jqueryH5.css("display") == "none"?0:(jqueryH5.css("position")=="absolute"?0:1));
        var fltMarkHeight = $(this.chartID).find(".bda-remark").height()>1?($(this.chartID).find(".bda-remark").height()+11):0;
        if ($(this.chartID).find(".bda-data").css("display") == "none"){
            var fltDataHeight = 0;
        }else {
            var fltDataHeight = parseFloat($(this.chartID).find(".bda-data").css("height"));
        }
        var fltChartBoxPaddingTop = parseFloat($(this.chartID).find(".bda-chart-box").css("padding-top"));
        var fltChartContentHeight = fltChartHeight - fltTitleHeight - fltSubtitleHeight - fltDataHeight - fltChartBoxPaddingTop-fltMarkHeight;
        if (this.type == 13){
            fltChartContentHeight = Math.min(fltChartContentHeight, fltChartContentWidth)
        }

        $(this.chartID).css("height", ajaxTools.deviceTypeID<2?fltChartHeight:(fltChartHeight/(100*$BDA.defaultRatio)+"rem"));
        $(this.chartID).find(".bda-chart-content").css("height", ajaxTools.deviceTypeID<2?fltChartContentHeight:(fltChartContentHeight/(100*$BDA.defaultRatio)+"rem"));
    },
    setChartBackgroundColor: function(viewBlock){
        var customColorApplyOtherThemes = viewBlock.customColorApplyOtherThemes || false;
        if(!viewBlock.backgroundColorTransparent){
            $(this.chartID).find('.bda-bgcolor').css('background-color',$BDA.theme.currentBackgroundColor?(customColorApplyOtherThemes?$BDA.csharp2rgba(viewBlock.backgroundColor):$BDA.theme.currentBackgroundColor):(viewBlock.backgroundColor?$BDA.csharp2rgba(viewBlock.backgroundColor):'#ffffff'));
        }
        var  borderWidth = "0,0,0,0";
        borderWidth = viewBlock.borderWidth?viewBlock.borderWidth.split(","):borderWidth.split(",");
        var borderColor = "-14408668, -14408668, -14408668, -14408668";
        borderColor = viewBlock.borderColor?viewBlock.borderColor.split(","):borderColor.split(",");
        var borderRadius = "0,0,0,0";
        borderRadius = viewBlock.borderRadius?viewBlock.borderRadius:borderRadius;
        if(viewBlock.chartID != 44){
            $(this.chartID).find('.bda-bgcolor').css({
                "border-top-width": Number(borderWidth[0])+"px",
                "border-right-width": Number(borderWidth[1])+"px",
                "border-bottom-width": Number(borderWidth[2])+"px",
                "border-left-width": Number(borderWidth[3])+"px",
                "border-top-color": $BDA.csharp2rgba(borderColor[0]),
                "border-right-color": $BDA.csharp2rgba(borderColor[1]),
                "border-bottom-color": $BDA.csharp2rgba(borderColor[2]),
                "border-left-color": $BDA.csharp2rgba(borderColor[3]),
                "border-style": "solid"
            });
        }
        $(this.chartID).find('.bda-bgcolor').css({
            "border-radius": borderRadius.replace(/\,/g, 'px ') + 'px'
        });
    }
};

function Charts(){
    this.count = 0;
    this.dicCharts = {};
    this.aryCharts = [];

    this.add = function (chart) {
        this.aryCharts.push(chart);
        this.dicCharts['_' + chart.chartID]=chart;

        this.count = this.aryCharts.length;
    };
    this.remove = function (chart) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryCharts[i].chartID==chart.chartID){
                k=i;
                break;
            }
        }
        this.aryCharts.splice(k,1);
        delete this.dicCharts['_' + chart.chartID];

        this.count=this.aryCharts.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryCharts[indexOrKey];
        }else{
            return this.dicCharts[indexOrKey];
        }
    };
    this.getCharts = function (viewBlocks) {
        this.count = 0;
        this.dicCharts = {};
        this.aryCharts = [];
        for(var intI = 0; intI < viewBlocks.count; intI++ ){
            var chart = $BDA.newChart( viewBlocks.item(intI).chartID,'#bda-chart'+intI, viewBlocks.item(intI).title, viewBlocks.item(intI));
            this.add(chart);
        }
    };
}

/*类---块*/
function ViewBlock(options){
    this.queryIDs = options.queryIDs;
    this.blockID = options.blockID;
    this.blockName = options.blockName;
    this.chartID = options.chartID;
    this.blockLayouts = options.blockLayouts;
    this.reportLink = options.reportLink ? options.reportLink : null;
    this.blockData = options.blockData;
    this.linkageParameters = [];
    this.blockDataToDraw = [];
    this.linkage = options.linkage?new Linkage(options.linkage):null;
    this.backgroundImage = options.backgroundImage;
    this.showToolButtons = options.showToolButtons;
    this.singleLineTitleBar = options.singleLineTitleBar;
    this.backgroundColorTransparent  = options.backgroundColorTransparent ;
    this.margin = options.margin;
    this.backgroundColor = options.backgroundColor;
    this.autoRefreshFollowReport = options.autoRefreshFollowReport;
    this.scaleUpByMagnifyButton = options.scaleUpByMagnifyButton;
    this.borderWidth = options.borderWidth;
    this.borderColor = options.borderColor;
    this.borderRadius = options.borderRadius;
    if (options.reportLinks) {
        var reportLinks = new ReportLinks();
        reportLinks.setReportLinks(options.reportLinks);
        this.reportLinks = reportLinks;
    }
}

function ReportLinks(){
    this.count = 0;
    this.dicReportLinks = {};
    this.aryReportLinks = [];

    this.add = function (reportLink) {
        this.aryReportLinks.push(reportLink);
        this.dicReportLinks[reportLink.reportLinkID] = reportLink;

        this.count = this.aryReportLinks.length;
    };
    this.remove = function (reportLink) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryReportLinks[i].reportLinkID == reportLink.reportLinkID) {
                k = i;
                break;
            }
        }
        this.aryReportLinks.splice(k, 1);
        delete this.dicReportLinks[reportLink.reportLinkID];

        this.count = this.aryReportLinks.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryReportLinks[indexOrKey];
        } else {
            return this.dicReportLinks[indexOrKey];
        }
    };
    this.setReportLinks = function (data) {
        this.count = 0;
        this.dicReportLinks = {};
        this.aryReportLinks = [];
        for (var intI = 0; intI < data.length; intI++) {
            var reportLink = new ReportLink(data[intI]);
            reportLink.reportLinkID = "rl"+intI;
            this.add(reportLink);
        }
    };
}

function ReportLink(options){
    this.reportLinkID = options.reportLinkID;
    this.containerBlockID = options.containerBlockID;
    this.reportID = options.reportID;
    this.showWithPopupWindow = options.showWithPopupWindow;
    this.reportLinkFilters = options.reportLinkFilters;
    this.conditionalDataKey = options.conditionalDataKey;
    this.operation = options.operation;
    this.compareConstants = options.compareConstants;
}

function ViewBlocks(){
    this.count = 0;
    this.dicViewBlocks = {};
    this.aryViewBlocks = [];

    this.add = function (viewBlock) {
        this.aryViewBlocks.push(viewBlock);
        this.dicViewBlocks['_' + viewBlock.blockID]=viewBlock;

        this.count = this.aryViewBlocks.length;
    };

    this.addAll = function(viewBlocks){
        for (var i = 0; i < viewBlocks.count; i++){
            this.add(viewBlocks.item(i));
        }
    }
    this.remove = function (viewBlock) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewBlocks[i].blockID==viewBlock.blockID){
                k=i;
                break;
            }
        }
        this.aryViewBlocks.splice(k,1);
        delete this.dicViewBlocks['_' + viewBlock.blockID];

        this.count = this.aryViewBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewBlocks[indexOrKey];
        }else{
            return this.dicViewBlocks[indexOrKey];
        }
    };

}

/*类---标题*/
function BlockTitle(options){
    this.title = options.title;
    this.titleTextBox = options.titleTextBox;
    this.titleBottomBorderWidth = options.titleBottomBorderWidth;
    this.titleBottomBorderColor = options.titleBottomBorderColor;
    this.titleExpression = options.titleExpression;
    this.titleIcon = options.titleIcon;
}

/*类---副标题*/
function Subtitle(options){
    this.subtitle = options.subtitle;
    this.subtitleTextBox = options.subtitleTextBox;
    this.subtitleExpression = options.subtitleExpression;
}

/*类---标记区*/
function Mark(options){
    this.remark = options.remark;
    this.remarkTextBox = options.remarkTextBox;
}

/*类---图形块*/
function ViewChartBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.primaryDimension = options.primaryDimension;
    this.groupDimension = options.groupDimension;
    this.y1Measures = options.y1Measures;
    this.y2Measures = options.y2Measures;
    this.y3Measures = options.y3Measures;
    this.y1DataFormat = options.y1DataFormat;
    this.y2DataFormat = options.y2DataFormat;
    this.y3DataFormat = options.y3DataFormat;
    this.viewBulletWarnings = options.viewBulletWarnings;

    this.canDrillDown = function(viewBusinessObjectHierarchies){
        var hierachy = null;
        var dimensionName = '';
        var queryName = '';

        if(this.chartID == 27 || this.chartID == 28 || this.chartID == 30 || this.chartID == 31 || this.chartID == 36){return false;}
        for (var i= 0; i < viewBusinessObjectHierarchies.length; i++){
            hierachy = viewBusinessObjectHierarchies[i];
            if (hierachy.queryID == this.queryIDs[0]) {
                for (var j = 0; j < hierachy.hierarchyDimensions.length; j++) {
                    dimensionName = hierachy.hierarchyDimensions[j][1];
                    queryName = hierachy.hierarchyDimensions[j][0];

                    if ((this.primaryDimension && dimensionName == this.primaryDimension[1] && queryName == this.primaryDimension[0]) ||
                        (this.groupDimension && dimensionName == this.groupDimension[1] && queryName == this.groupDimension[0])) {
                        if (j <  hierachy.hierarchyDimensions.length - 1) {
                            return true;
                        }
                    }
                }
            }
        }

        return false;
    }

    this.getLinkageParameters = function(){
        var linkageParameters = [];

        if(this.primaryDimension){
            loadLinkageParmeterOfPrimaryDimension(this, linkageParameters);
        }

        if(this.groupDimension) {
            loadLinkageParmeterOfGroupDimension(this, linkageParameters);
        }

        return linkageParameters;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        var arrDimension = [];
        if(this.primaryDimension){
            arrDimension.push(this.primaryDimension[0]+'___'+this.primaryDimension[1]);
        }
        if(this.groupDimension){
            arrDimension.push(this.groupDimension[0]+'___'+this.groupDimension[1]);
        }

        var arrLinkageDimension = [];
        for(var i = 0; i < this.linkageParameters.length; i++){
            if(arrDimension.indexOf((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName)) == -1){
                arrLinkageDimension.push((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName));
            }
        }

        for(var i = 0; i < this.blockDataToDraw.length; i++){
            for(var key in this.blockDataToDraw[i]){
                if(arrLinkageDimension.indexOf(key) != -1){
                    delete this.blockDataToDraw[i][key];
                }
            }
        }
    }

    function loadLinkageParmeterOfPrimaryDimension(me, linkageParameters){
        var objLinkageParameter = {};

        objLinkageParameter.blockID = me.blockID;
        objLinkageParameter.dimensionValue = "";
        objLinkageParameter.queryName = me.primaryDimension[0];
        objLinkageParameter.dimensionName = me.primaryDimension[1];
        objLinkageParameter.dataType = me.primaryDimension[3];
        if (me.blockDataToDraw.length){
            objLinkageParameter.dimensionValue = me.blockDataToDraw[0][me.primaryDimension[0] +
            "___" +
            me.primaryDimension[1]];
        }

        linkageParameters.push(objLinkageParameter);
    }

    function loadLinkageParmeterOfGroupDimension(me, linkageParameters){
        var objLinkageParameter = {};

        objLinkageParameter.blockID = me.blockID;
        objLinkageParameter.dimensionValue = "";
        objLinkageParameter.queryName = me.groupDimension[0];
        objLinkageParameter.dimensionName = me.groupDimension[1];
        objLinkageParameter.dataType = me.groupDimension[3];
        if (me.blockDataToDraw.length) {
            objLinkageParameter.dimensionValue = me.blockDataToDraw[0][me.groupDimension[0] +
            "___" +
            me.groupDimension[1]];
        }

        var dimensionNameIsRepeat = false;
        $.each(linkageParameters,function(i){
            if(linkageParameters[i].dimensionName == objLinkageParameter.dimensionName){
                dimensionNameIsRepeat = true;
                return false;
            }
        });
        if(!dimensionNameIsRepeat){
            linkageParameters.push(objLinkageParameter);
        }
    }

    this.getOfficeData = function(){
        var officeData = {};
        var labels = [];
        var objectData = [];
        if(this.primaryDimension){
            labels.push(this.primaryDimension[1]);
            objectData.push(this.primaryDimension);
        }else{
            labels.push(null);
        }
        if(this.groupDimension){
            labels.push(this.groupDimension[1]);
            objectData.push(this.groupDimension);
        }else{
            labels.push(null);
        }

        var y1MeasuresName = [];
        var y2MeasuresName = [];
        var y3MeasuresName = [];
        for(var i = 0; i < this.y1Measures.length; i++){
            labels.push(this.y1Measures[i][1]);
            objectData.push(this.y1Measures[i]);
            y1MeasuresName.push(this.y1Measures[i][0]+'___'+this.y1Measures[i][1]);
        }
        for(var i = 0; i < this.y2Measures.length; i++){
            labels.push(this.y2Measures[i][1]);
            objectData.push(this.y2Measures[i]);
            y2MeasuresName.push(this.y2Measures[i][0]+'___'+this.y2Measures[i][1]);
        }
        for(var i = 0; i < this.y3Measures.length; i++){
            labels.push(this.y3Measures[i][1]);
            objectData.push(this.y3Measures[i]);
            y3MeasuresName.push(this.y3Measures[i][0]+'___'+this.y3Measures[i][1]);
        }
        officeData.labels = labels;

        var valueData = [];
        for(var i = 0; i < this.blockDataToDraw.length; i++){
            var arr = [];
            for(var j = 0; j < objectData.length; j++){
                if(objectData[j][3] == 1){
                    var measuresName = objectData[j][0]+"___"+objectData[j][1];
                    if(y1MeasuresName.indexOf(measuresName) != 0){
                        arr.push($BDA.formatString.number(this.y1DataFormat,this.blockDataToDraw[i][measuresName]));
                    }else if(y2MeasuresName.indexOf(measuresName) != 0){
                        arr.push($BDA.formatString.number(this.y2DataFormat,this.blockDataToDraw[i][measuresName]));
                    }else if(y3MeasuresName.indexOf(measuresName) != 0){
                        arr.push($BDA.formatString.number(this.y3DataFormat,this.blockDataToDraw[i][measuresName]));
                    }
                }else{
                    arr.push(this.blockDataToDraw[i][objectData[j][0]+"___"+objectData[j][1]]);
                }
            }
            valueData.push(arr);
        }
        officeData.valueData = valueData;

        return officeData;
    }

    this.getDataType = function(){
        var tempObj = {};
        var defaultIndex = 0;
        var measuresIndex = [];
        var dateIndex = [];
        var dateKey = [];

        if(this.primaryDimension && !this.groupDimension){
            if(this.primaryDimension[3]==1){
                dateIndex.push(0);
                dateKey.push(this.primaryDimension[0]+"___"+this.primaryDimension[1]);
            }
            if(this.primaryDimension[3]==2){
                measuresIndex.push(0);
            }
            defaultIndex = 1;
        }
        if(!this.primaryDimension && this.groupDimension){
            if(this.groupDimension[3]==1){
                dateIndex.push(0);
                dateKey.push(this.groupDimension[0]+"___"+this.groupDimension[1]);
            }
            if(this.groupDimension[3]==2){
                measuresIndex.push(0);
            }
            defaultIndex = 1;
        }
        if(this.primaryDimension && this.groupDimension){
            if(this.primaryDimension[3]==1){
                dateIndex.push(0);
                dateKey.push(this.primaryDimension[0]+"___"+this.primaryDimension[1]);
            }
            if(this.primaryDimension[3]==2){
                measuresIndex.push(0);
            }
            if(this.groupDimension[3]==1){
                dateIndex.push(1);
                dateKey.push(this.groupDimension[0]+"___"+this.groupDimension[1]);
            }
            if(this.groupDimension[3]==2){
                measuresIndex.push(1);
            }
            defaultIndex = 2;
        }

        var measures = this.y1Measures.concat(this.y2Measures.concat(this.y3Measures));

        for(var i = 0; i < measures.length; i++){
            measuresIndex.push(i+defaultIndex);
        }

        tempObj.measuresIndex = measuresIndex;
        tempObj.dateIndex = dateIndex;
        tempObj.dateKey = dateKey;

        return tempObj;
    };

    this.setBlockData = function(){
        var measuresArr = [];
        for(var i = 0; i < this.y1Measures.length; i++){
            measuresArr.push(this.y1Measures[i][0]+"___"+this.y1Measures[i][1]);
        }
        for(var i = 0; i < this.y2Measures.length; i++){
            measuresArr.push(this.y2Measures[i][0]+"___"+this.y2Measures[i][1]);
        }
        for(var i = 0; i < this.y3Measures.length; i++){
            measuresArr.push(this.y3Measures[i][0]+"___"+this.y3Measures[i][1]);
        }

        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(measuresArr.indexOf(key) != -1 && this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }

    };

}

function ViewChartBlocks(){
    this.count = 0;
    this.dicViewChartBlocks = {};
    this.aryViewChartBlocks = [];

    this.add = function (block) {
        this.aryViewChartBlocks.push(block);
        this.dicViewChartBlocks[block.blockID]=block;

        this.count = this.aryViewChartBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewChartBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewChartBlocks.splice(k,1);
        delete this.dicViewChartBlocks[block.blockID];

        this.count=this.aryViewChartBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewChartBlocks[indexOrKey];
        }else{
            return this.dicViewChartBlocks[indexOrKey];
        }
    };
    this.setViewChartBlocks = function (data) {
        this.count = 0;
        this.dicViewChartBlocks = {};
        this.aryViewChartBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewChartBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

function ChartStyle(options){
    this.legendShow = options.legendShow;
    this.legendPosition = options.legendPosition;
    this.dataShow = options.dataShow;
    this.dataHoverShow = options.dataHoverShow;
    this.axisLabelShow = options.axisLabelShow;
    this.dataLabel = options.dataLabel;
    this.smooth = options.smooth;
    this.showScale = options.showScale;
    this.scaleFont = options.scaleFont;
    this.scaleColor = options.scaleColor;
    this.xScaleLineWidth = options.xScaleLineWidth;
    this.xScaleLineColor = options.xScaleLineColor;
    this.y1ScaleLineWidth = options.y1ScaleLineWidth;
    this.y1ScaleLineColor = options.y1ScaleLineColor;
    this.y2ScaleLineWidth = options.y2ScaleLineWidth;
    this.y2ScaleLineColor = options.y2ScaleLineColor;
    this.axisLabelFont = options.axisLabelFont;
    this.axisLabelColor = options.axisLabelColor;
    this.lineWidth = options.lineWidth;
    this.dataFont = options.dataFont;
    this.dataHoverFont = options.dataHoverFont;
    this.legendFont = options.legendFont;
    this.legendColor = options.legendColor;
    this.connectorWidth = options.connectorWidth;
    this.colorSequence = options.colorSequence;
    this.viewScaleMaxValues = options.viewScaleMaxValues;
    this.showGridLine  = options.showGridLine;
    this.showTick = options.showTick;
    this.showTickValue = options.showTickValue;
    this.unit = options.unit;
    this.colorByPoint = options.colorByPoint;
    this.negativeColor = options.negativeColor;
    this.subtitleInCircle = options.subtitleInCircle;
    this.showDataInLegend = options.showDataInLegend;
    this.dataColor = options.dataColor;
    this.barWidth = options.barWidth;
    this.carouselTooltip = options.carouselTooltip;
    this.carouselInterval = options.carouselInterval;
    this.innerSize = options.innerSize;
    this.tooltipBackgroundColor = options.tooltipBackgroundColor;
    this.tooltipBorderColor = options.tooltipBorderColor;
    this.tooltipBorderWidth = options.tooltipBorderWidth;
    this.tooltipPadding = options.tooltipPadding;
    this.dataHoverColor = options.dataHoverColor;
    this.picture = options.picture;
    this.scalePosition = options.scalePosition;
    this.colorGradual = options.colorGradual;
}

/*类---表格块*/
function ViewVerticalTableBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.viewTableHead = new TableHead(options.viewTableHead);
    this.viewTableBody = new TableBody(options.viewTableBody);
    this.viewTableFoot = new TableFoot(options.viewTableFoot);
    this.viewTableWarnings = options.viewTableWarnings;
    this.autoMergeDimensionCells = options.autoMergeDimensionCells;
    this.showColumnBarForMeasure = options.showColumnBarForMeasure;
    this.positiveColumnBarColor = options.positiveColumnBarColor;
    this.negativeColumnBarColor = options.negativeColumnBarColor;
    this.notShowBorderOfDetailTableCell = options.notShowBorderOfDetailTableCell;
    this.columnBarMaxLength = options.columnBarMaxLength;
    this.tBodyScrolling = options.tBodyScrolling;
    this.scrollTimePerLine = options.scrollTimePerLine;
    this.headHeight = options.headHeight;
    this.bodyHeight = options.bodyHeight;
    this.footHeight = options.footHeight;
    this.tableStyle = options.tableStyle;
    this.tableStyleColor = options.tableStyleColor;
    this.wordWrap = options.wordWrap;
    this.striped = options.striped;
    this.rowMarginBottom = options.rowMarginBottom;
    this.pagingDisplay = options.pagingDisplay;
    this.pageRecordCount = options.pageRecordCount;
    this.frozenColumnCount = options.frozenColumnCount;
    this.padding = options.padding;

    this.canDrillDown = function (viewBusinessObjectHierarchies){

        if(this.chartID == 38){ return false;}

        var tableCell = null;
        var hierachy = null;
        var dimensionName = '';
        var queryName = '';

        for (var i = 0; i < this.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++){
            tableCell = this.viewTableBody.viewTableRows.item(0).viewTableCells.item(i);
            if (parseFloat(tableCell.cellObject[2]) == 0){
                for (var j = 0; j < viewBusinessObjectHierarchies.length; j++){
                    hierachy = viewBusinessObjectHierarchies[j];
                    if (hierachy.queryID == this.queryIDs[0]) {
                        for (var k = 0; k < hierachy.hierarchyDimensions.length; k++) {
                            dimensionName = hierachy.hierarchyDimensions[k][1];
                            queryName = hierachy.hierarchyDimensions[k][0];
                            if (dimensionName == tableCell.cellObject[1] && queryName == tableCell.cellObject[0]) {
                                if (k < hierachy.hierarchyDimensions.length - 1) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    };

    this.getLinkageParameters = function(){
        var linkageParameters = [];
        var objLinkageParameter = {};
        var dimensionNameIsRepeat = false;
        var viewTableCell;

        for(var k = 0; k < this.viewTableBody.viewTableRows.item(0).viewTableCells.count; k++){
            viewTableCell = this.viewTableBody.viewTableRows.item(0).viewTableCells.item(k);
            if(viewTableCell.cellObject[2] == 0){
                objLinkageParameter = {};
                objLinkageParameter.blockID = this.blockID;
                objLinkageParameter.queryName = viewTableCell.cellObject[0];
                objLinkageParameter.dimensionName = viewTableCell.cellObject[1];
                objLinkageParameter.dataType = viewTableCell.cellObject[3];
                objLinkageParameter.dimensionValue = "";
                if (this.blockDataToDraw.length){
                    objLinkageParameter.dimensionValue = this.blockDataToDraw[0][viewTableCell.cellObject[0] +
                    "___" +
                    viewTableCell.cellObject[1]];
                }

                dimensionNameIsRepeat = false;
                $.each(linkageParameters,function(i){
                    if(linkageParameters[i].dimensionName == objLinkageParameter.dimensionName){
                        dimensionNameIsRepeat = true;
                        return false;
                    }
                });
                if(!dimensionNameIsRepeat){
                    linkageParameters.push(objLinkageParameter);
                }
            }
        }

        return linkageParameters;
    };

    this.removeBlockDataToDrawUnusefulValue = function(){
        var arrDimension = [];
        var viewTableCell = null;
        for(var i = 0; i < this.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++){
            viewTableCell = this.viewTableBody.viewTableRows.item(0).viewTableCells.item(i);
            if(viewTableCell.cellObject[2] == 0) {
                arrDimension.push(viewTableCell.cellObject[0]+'___'+viewTableCell.cellObject[1]);
            }
        }

        var arrLinkageDimension = [];
        for(var i = 0; i < this.linkageParameters.length; i++){
            if(arrDimension.indexOf((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName)) == -1){
                arrLinkageDimension.push((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName));
            }
        }

        for(var i = 0; i < this.blockDataToDraw.length; i++){
            for(var key in this.blockDataToDraw[i]){
                if(arrLinkageDimension.indexOf(key) != -1){
                    delete this.blockDataToDraw[i][key];
                }
            }
        }
    };

    this.getOfficeData = function(){
        var officeData = {};
        officeData.tableHead = [];
        officeData.tableBody = [];

        for(var i = 0; i < this.viewTableHead.viewTableRows.count; i++){
            var arr = [];
            for(var j = 0; j < this.viewTableHead.viewTableRows.item(i).viewTableCells.count; j++){
                var tableCell = this.viewTableHead.viewTableRows.item(i).viewTableCells.item(j);
                if(tableCell.cellObject[3] == 1){
                    arr.push(((!isNaN(tableCell.text))?$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text))):tableCell.text));
                }else if(tableCell.cellObject[3] == 2){
                    arr.push(($BDA.formatString.number(tableCell.formatString,(!isNaN(tableCell.text))?(Number(tableCell.text) || ''):(tableCell.text || ''))));
                }else{
                    arr.push(tableCell.text);
                }
            }
            officeData.tableHead.push(arr);
        }

        for(var i = 0; i < this.blockDataToDraw.length; i++){
            var arr = [];
            for(var j = 0; j < this.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                var tableCell = this.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                if(tableCell.cellObject[3] == 1){
                    arr.push($BDA.formatString.date(tableCell.formatString,new Date(this.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]])));
                }else if(tableCell.cellObject[3] == 2){
                    arr.push($BDA.formatString.number(tableCell.formatString,this.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]]));
                }else{
                    arr.push(this.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]]);
                }
                //arr.push(this.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]]);
            }
            officeData.tableBody.push(arr);
        }

        for(var i = 0; i < this.viewTableFoot.viewTableRows.count; i++){
            var arr = [];
            for(var j = 0; j < this.viewTableFoot.viewTableRows.item(i).viewTableCells.count; j++){
                var tableCell = this.viewTableFoot.viewTableRows.item(i).viewTableCells.item(j);
                if(tableCell.cellObject[3] == 1){
                    arr.push(((!isNaN(tableCell.text))?$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text))):tableCell.text));
                }else if(tableCell.cellObject[3] == 2){
                    arr.push(($BDA.formatString.number(tableCell.formatString,(!isNaN(tableCell.text))?(Number(tableCell.text) || ''):(tableCell.text || ''))));
                }else{
                    arr.push(tableCell.text);
                }
            }
            officeData.tableBody.push(arr);
        }

        return officeData;
    };

    this.getOfficeObjectData = function(dataKey){
        var officeData = {};
        officeData.labels = [];
        officeData.valueData = [];
        officeData.labels.push(dataKey.split("___")[1]);
        var queryName = dataKey.split("___")[0];
        var objectName = dataKey.split("___")[1];
        for(var i = 0; i < this.blockDataToDraw.length; i++){
            for(var j = 0; j < this.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                var tableCell = this.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                if(queryName == tableCell.cellObject[0] && objectName == tableCell.cellObject[1]){
                    if(tableCell.cellObject[3] == 1){
                        officeData.valueData.push($BDA.formatString.date(tableCell.formatString,new Date(this.blockDataToDraw[i][dataKey])));
                    }else if(tableCell.cellObject[3] == 2){
                        officeData.valueData.push($BDA.formatString.number(tableCell.formatString,this.blockDataToDraw[i][dataKey]));
                    }else{
                        officeData.valueData.push(this.blockDataToDraw[i][dataKey]);
                    }
                }
            }
        }
        if(!officeData.valueData.length){
            for(var i = 0; i < this.viewTableHead.viewTableRows.count; i++){
                for(var j = 0; j < this.viewTableHead.viewTableRows.item(i).viewTableCells.count; j++){
                    var tableCell = this.viewTableHead.viewTableRows.item(i).viewTableCells.item(j);
                    if(queryName == tableCell.cellObject[0] && objectName == tableCell.cellObject[1]){
                        if(tableCell.cellObject[3] == 1){
                            officeData.valueData.push($BDA.formatString.date(tableCell.formatString,new Date(tableCell.text)));
                        }else if(tableCell.cellObject[3] == 2){
                            officeData.valueData.push($BDA.formatString.number(tableCell.formatString,tableCell.text));
                        }else{
                            officeData.valueData.push(tableCell.text);
                        }
                    }
                }
            }
        }
        if(!officeData.valueData.length){
            for(var i = 0; i < this.viewTableFoot.viewTableRows.count; i++){
                for(var j = 0; j < this.viewTableFoot.viewTableRows.item(i).viewTableCells.count; j++){
                    var tableCell = this.viewTableFoot.viewTableRows.item(i).viewTableCells.item(j);
                    if(queryName == tableCell.cellObject[0] && objectName == tableCell.cellObject[1]){
                        if(tableCell.cellObject[3] == 1){
                            officeData.valueData.push($BDA.formatString.date(tableCell.formatString,new Date(tableCell.text)));
                        }else if(tableCell.cellObject[3] == 2){
                            officeData.valueData.push($BDA.formatString.number(tableCell.formatString,tableCell.text));
                        }else{
                            officeData.valueData.push(tableCell.text);
                        }
                    }
                }
            }
        }
        return officeData;
    };

    this.setBlockData = function(){
        var measuresArr = [];
        for(var i = 0; i < this.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++){
            var tableCell = this.viewTableBody.viewTableRows.item(0).viewTableCells.item(i);
            if(tableCell.cellObject[2] == 1){
                measuresArr.push(tableCell.cellObject[0]+"___"+tableCell.cellObject[1]);
            }
        }

        for(var i = 0; i < this.viewTableHead.viewTableRows.count; i++){
            for(var j = 0; j < this.viewTableHead.viewTableRows.item(i).viewTableCells.count; j++){
                var tableCell = this.viewTableHead.viewTableRows.item(i).viewTableCells.item(j);
                if(tableCell.text == "null"){
                    tableCell.text = 0;
                }
            }
        }

        for(var i = 0; i < this.viewTableFoot.viewTableRows.count; i++){
            for(var j = 0; j < this.viewTableFoot.viewTableRows.item(i).viewTableCells.count; j++){
                var tableCell = this.viewTableFoot.viewTableRows.item(i).viewTableCells.item(j);
                if(tableCell.text == "null"){
                    tableCell.text = 0;
                }
            }
        }

        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(measuresArr.indexOf(key) != -1 && this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }

    };
}

function ViewVerticalTableBlocks(){
    this.count = 0;
    this.dicViewVerticalTableBlocks = {};
    this.aryViewVerticalTableBlocks = [];

    this.add = function (block) {
        this.aryViewVerticalTableBlocks.push(block);
        this.dicViewVerticalTableBlocks[block.blockID]=block;

        this.count = this.aryViewVerticalTableBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewVerticalTableBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewVerticalTableBlocks.splice(k,1);
        delete this.dicViewVerticalTableBlocks[block.blockID];

        this.count=this.aryViewVerticalTableBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewVerticalTableBlocks[indexOrKey];
        }else{
            return this.dicViewVerticalTableBlocks[indexOrKey];
        }
    };
    this.setViewVerticalTableBlocks = function (data) {
        this.count = 0;
        this.dicViewVerticalTableBlocks = {};
        this.aryViewVerticalTableBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewVerticalTableBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

function TableHead(options){
    var tableRows = new TableRows();
    tableRows.setTableRows(options.viewTableRows)
    this.viewTableRows = tableRows;
}

function TableBody(options){
    var tableRows = new TableRows();
    tableRows.setTableRows(options.viewTableRows)
    this.viewTableRows = tableRows;
}

function TableFoot(options){
    var tableRows = new TableRows();
    tableRows.setTableRows(options.viewTableRows)
    this.viewTableRows = tableRows;
}

function TableRow(options){
    var tableCells = new TableCells();
    tableCells.setTableCells(options.viewTableCells)
    this.rowID = options.rowID;
    this.viewTableCells = tableCells;
}

function TableRows(){
    this.count = 0;
    this.dicTableRows = {};
    this.aryTableRows = [];

    this.add = function (tableRow){
        this.aryTableRows.push(tableRow);
        this.dicTableRows[tableRow.rowID]=tableRow;

        this.count = this.aryTableRows.length;
    };
    this.remove = function (tableRow) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTableRows[i].rowID==tableRow.rowID){
                k=i;
                break;
            }
        }
        this.aryTableRows.splice(k,1);
        delete this.dicTableRows[tableRow.rowID];

        this.count=this.aryTableRows.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTableRows[indexOrKey];
        }else{
            return this.dicTableRows[indexOrKey];
        }
    };
    this.setTableRows = function (data){
        this.count = 0;
        this.dicTableRows = {};
        this.aryTableRows = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var tableRow = new TableRow(data[intI]);
            this.add(tableRow);
        }
    };
}

function TableCell(options){
    this.cellObject = options.cellObject;
    this.cellTextBox = options.cellTextBox;
    this.colspan = options.colspan;
    this.columnBarMaxLength = options.columnBarMaxLength;
    this.columnIndex = options.columnIndex;
    this.formatString = options.formatString;
    this.negativeColumnBarColor = options.negativeColumnBarColor;
    this.positiveColumnBarColor = options.positiveColumnBarColor;
    this.reportLink = options.reportLink ? options.reportLink : null;
    this.rowID = options.rowID;
    this.rowspan = options.rowspan;
    this.showColumnBarForMeasure = options.showColumnBarForMeasure;
    this.text = options.text;
    this.columnWidth = options.columnWidth;
    this.autoColumnWidth = options.autoColumnWidth;
    this.viewSparkline = options.viewSparkline;
    this.borderWidth = options.borderWidth;
    this.borderColor = options.borderColor;
    this.borderRadius = options.borderRadius;
    this.dimensionDataKeyToMergeCells = options.dimensionDataKeyToMergeCells ? options.dimensionDataKeyToMergeCells : null;

    if (options.reportLinks) {
        var reportLinks = new ReportLinks();
        reportLinks.setReportLinks(options.reportLinks);
        this.reportLinks = reportLinks;
    }
}

function TableCells(){
    this.count = 0;
    this.dicTableCells = {};
    this.aryTableCells = [];

    this.add = function (tableCell){
        this.aryTableCells.push(tableCell);
        this.dicTableCells[tableCell.columnIndex]=tableCell;

        this.count = this.aryTableCells.length;
    };
    this.remove = function (tableCell) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTableCells[i].columnIndex==tableCell.columnIndex){
                k=i;
                break;
            }
        }
        this.aryTableCells.splice(k,1);
        delete this.dicTableCells[tableCell.blockID];

        this.count=this.aryTableCells.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTableCells[indexOrKey];
        }else{
            return this.dicTableCells[indexOrKey];
        }
    };
    this.setTableCells = function (data){
        this.count = 0;
        this.dicTableCells = {};
        this.aryTableCells = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var tableCell = new TableCell(data[intI]);
            this.add(tableCell);
        }
    };
}

/*类---水平表*/
function ViewHorizontalTableBlock(options){
    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.viewTableHead = new HorizontalTableHead(options.viewTableHead);
    this.viewTableBody = new HorizontalTableBody(options.viewTableBody);
    this.viewTableFoot = new HorizontalTableFoot(options.viewTableFoot);
    this.viewTableWarnings = options.viewTableWarnings;
    this.cellHeight = options.cellHeight;
    this.wordWrap = options.wordWrap;
    this.notShowBorderOfTableCell = options.notShowBorderOfTableCell;
    this.autoMergeDimensionCells = options.autoMergeDimensionCells;
    this.padding = options.padding;

    this.canDrillDown = function (viewBusinessObjectHierarchies){

        var tableCell = null;
        var hierachy = null;
        var dimensionName = '';
        var queryName = '';

        for (var i = 0; i < this.viewTableBody.viewTableColumns.item(0).viewTableCells.count; i++){
            tableCell = this.viewTableBody.viewTableColumns.item(0).viewTableCells.item(i);
            if (parseFloat(tableCell.cellObject[2]) == 0){
                for (var j = 0; j < viewBusinessObjectHierarchies.length; j++){
                    hierachy = viewBusinessObjectHierarchies[j];
                    if (hierachy.queryID == this.queryIDs[0]) {
                        for (var k = 0; k < hierachy.hierarchyDimensions.length; k++) {
                            dimensionName = hierachy.hierarchyDimensions[k][1];
                            queryName = hierachy.hierarchyDimensions[k][0];
                            if (dimensionName == tableCell.cellObject[1] && queryName == tableCell.cellObject[0]) {
                                if (k < hierachy.hierarchyDimensions.length - 1) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    };

    this.getLinkageParameters = function(){
        return;
    };

    this.removeBlockDataToDrawUnusefulValue = function(){
        var arrDimension = [];
        var viewTableCell = null;
        for(var i = 0; i < this.viewTableBody.viewTableColumns.item(0).viewTableCells.count; i++){
            viewTableCell = this.viewTableBody.viewTableColumns.item(0).viewTableCells.item(i);
            if(viewTableCell.cellObject[2] == 0) {
                arrDimension.push(viewTableCell.cellObject[0]+'___'+viewTableCell.cellObject[1]);
            }
        }

        var arrLinkageDimension = [];
        for(var i = 0; i < this.linkageParameters.length; i++){
            if(arrDimension.indexOf((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName)) == -1){
                arrLinkageDimension.push((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName));
            }
        }

        for(var i = 0; i < this.blockDataToDraw.length; i++){
            for(var key in this.blockDataToDraw[i]){
                if(arrLinkageDimension.indexOf(key) != -1){
                    delete this.blockDataToDraw[i][key];
                }
            }
        }
    };

    this.getOfficeData = function(){
        return;
    };

    this.getOfficeObjectData = function(dataKey){
        return;
    };

    this.setBlockData = function(){
        var measuresArr = [];
        for(var i = 0; i < this.viewTableBody.viewTableColumns.item(0).viewTableCells.count; i++){
            var tableCell = this.viewTableBody.viewTableColumns.item(0).viewTableCells.item(i);
            if(tableCell.cellObject[2] == 1){
                measuresArr.push(tableCell.cellObject[0]+"___"+tableCell.cellObject[1]);
            }
        }

        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(measuresArr.indexOf(key) != -1 && this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }

    };
}

function ViewHorizontalTableBlocks(){
    this.count = 0;
    this.dicViewHorizontalTableBlocks = {};
    this.aryViewHorizontalTableBlocks = [];

    this.add = function (block) {
        this.aryViewHorizontalTableBlocks.push(block);
        this.dicViewHorizontalTableBlocks[block.blockID]=block;

        this.count = this.aryViewHorizontalTableBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewHorizontalTableBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewHorizontalTableBlocks.splice(k,1);
        delete this.dicViewHorizontalTableBlocks[block.blockID];

        this.count=this.aryViewHorizontalTableBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewHorizontalTableBlocks[indexOrKey];
        }else{
            return this.dicViewHorizontalTableBlocks[indexOrKey];
        }
    };
    this.setViewHorizontalTableBlocks = function (data) {
        this.count = 0;
        this.dicViewHorizontalTableBlocks = {};
        this.aryViewHorizontalTableBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewHorizontalTableBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

function HorizontalTableHead(options){
    var tableColumns = new TableColumns();
    tableColumns.setTableColumns(options.viewTableColumns)
    this.viewTableColumns = tableColumns;
}

function HorizontalTableBody(options){
    var tableColumns = new TableColumns();
    tableColumns.setTableColumns(options.viewTableColumns)
    this.viewTableColumns = tableColumns;
}

function HorizontalTableFoot(options){
    var tableColumns = new TableColumns();
    tableColumns.setTableColumns(options.viewTableColumns)
    this.viewTableColumns = tableColumns;
}

function TableColumn(options){
    var tableCells = new TableCells();
    tableCells.setTableCells(options.viewTableCells)
    this.columnIndex = options.columnIndex;
    this.viewTableCells = tableCells;
}

function TableColumns(){
    this.count = 0;
    this.dicTableColumns = {};
    this.aryTableColumns = [];

    this.add = function (tableColumn){
        this.aryTableColumns.push(tableColumn);
        this.dicTableColumns[tableColumn.columnID]=tableColumn;

        this.count = this.aryTableColumns.length;
    };
    this.remove = function (tableColumn) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryTableColumns[i].columnID==tableColumn.columnID){
                k=i;
                break;
            }
        }
        this.aryTableColumns.splice(k,1);
        delete this.dicTableColumns[tableColumn.columnID];

        this.count=this.aryTableColumns.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryTableColumns[indexOrKey];
        }else{
            return this.dicTableColumns[indexOrKey];
        }
    };
    this.setTableColumns = function (data){
        this.count = 0;
        this.dicTableColumns = {};
        this.aryTableColumns = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var tableColumn = new TableColumn(data[intI]);
            this.add(tableColumn);
        }
    };
}

/*类---透视表*/
function ViewPivotTableBlock(options){
    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.rowDimensions = options.rowDimensions;
    this.columnDimensions = options.columnDimensions;
    this.viewPivotMeasures = options.viewPivotMeasures;
    this.viewVerticalTableBlock = options.viewVerticalTableBlock;
    this.showCrossTableHead = options.showCrossTableHead;
    this.totalBackgroundColor = options.totalBackgroundColor;
    this.totalColor = options.totalColor;
    this.totalFont = options.totalFont;
    this.tableHeadBackgroundColor = options.tableHeadBackgroundColor;
    this.tableHeadColor = options.tableHeadColor;
    this.tableHeadFont = options.tableHeadFont;
    this.padding = options.padding;
    this.pagingDisplay = options.pagingDisplay;
    this.pageRecordCount = options.pageRecordCount;

    this.canDrillDown = function (viewBusinessObjectHierarchies){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        return;
    }

    this.getLinkageParameters = function(){
        return;
    }

    this.getOfficeData = function(){
        var officeData = {};
        officeData.tableHead = [];
        officeData.tableBody = [];

        for(var i = 0; i < this.viewTableHead.viewTableRows.count; i++){
            var arr = [];
            for(var j = 0; j < this.viewTableHead.viewTableRows.item(i).viewTableCells.count; j++){
                var tableCell = this.viewTableHead.viewTableRows.item(i).viewTableCells.item(j);
                if(tableCell.cellObject[3] == 1){
                    arr.push(((!isNaN(tableCell.text))?$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text))):tableCell.text));
                }else if(tableCell.cellObject[3] == 2){
                    arr.push(($BDA.formatString.number(tableCell.formatString,(!isNaN(tableCell.text))?(Number(tableCell.text) || ''):(tableCell.text || ''))));
                }else{
                    arr.push(tableCell.text);
                }
            }
            officeData.tableHead.push(arr);
        }

        for(var i = 0; i < this.blockDataToDraw; i++){
            var arr = [];
            for(var j = 0; j < this.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                var tableCell = this.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                arr.push(this.blockDataToDraw[i][j+'']);
            }
            officeData.tableBody.push(arr);
        }
        return officeData;
    };

    this.setBlockData = function(){
        var measuresArr = [];
        var measuresNameArr = [];
        for(var i = 0; i < this.viewPivotMeasures.length; i++){
            measuresNameArr.push(this.viewPivotMeasures[i].measureName);
        }
        for(var i = 0; i < this.viewVerticalTableBlock.viewTableBody.viewTableRows[0].viewTableCells.length; i++){
            var tableCell = this.viewVerticalTableBlock.viewTableBody.viewTableRows[0].viewTableCells[i];
            for(var j = 0; j < measuresNameArr.length; j++){
                if(tableCell.cellObject[1].indexOf(measuresNameArr[j]) != -1){
                    measuresArr.push(tableCell.columnIndex+"");
                    break;
                }
            }
        }

        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(measuresArr.indexOf(key+"") != -1 && this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }

    };
}

function ViewPivotTableBlocks(){
    this.count = 0;
    this.dicViewPivotTableBlocks = {};
    this.aryViewPivotTableBlocks = [];

    this.add = function (block) {
        this.aryViewPivotTableBlocks.push(block);
        this.dicViewPivotTableBlocks[block.blockID]=block;

        this.count = this.aryViewPivotTableBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewPivotTableBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewPivotTableBlocks.splice(k,1);
        delete this.dicViewPivotTableBlocks[block.blockID];

        this.count=this.aryViewPivotTableBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewPivotTableBlocks[indexOrKey];
        }else{
            return this.dicViewPivotTableBlocks[indexOrKey];
        }
    };
    this.setViewPivotTableBlocks = function (data) {
        this.count = 0;
        this.dicViewPivotTableBlocks = {};
        this.aryViewPivotTableBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewPivotTableBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

/*类----自由表格*/
function ViewFreeTableBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    var tableRows = new TableRows();
    tableRows.setTableRows(options.viewTableRows)

    this.row = options.row;
    this.column = options.column;
    this.viewTableRows = tableRows;
    this.cellHeight = options.cellHeight;
    this.padding = options.padding;
    this.highlightWhenSelected = options.highlightWhenSelected;
    this.highlightColor = options.highlightColor;
    this.wordWrap = options.wordWrap;
    
    this.canDrillDown = function (viewBusinessObjectHierarchies){
        return false;
    };

    this.getLinkageParameters = function(){

        return;
    };

    this.removeBlockDataToDrawUnusefulValue = function(){
        return;
    };

    this.getOfficeData = function(){
       
        return;
    };

    this.getOfficeObjectData = function(dataKey){
        
        return;
    };

    this.setBlockData = function(){
        for(var i = 0; i < this.viewTableRows.count; i++){
            for(var j = 0; j < this.viewTableRows.item(i).viewTableCells.count; j++){
                var tableCell = this.viewTableRows.item(i).viewTableCells.item(j);
                if(tableCell.text == "null" || tableCell.text == null){
                    tableCell.text = 0;
                }
            }
        }

    };
}

function ViewFreeTableBlocks(){
    this.count = 0;
    this.dicViewFreeTableBlocks = {};
    this.aryViewFreeTableBlocks = [];

    this.add = function (block) {
        this.aryViewFreeTableBlocks.push(block);
        this.dicViewFreeTableBlocks[block.blockID]=block;

        this.count = this.aryViewFreeTableBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewFreeTableBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewFreeTableBlocks.splice(k,1);
        delete this.dicViewFreeTableBlocks[block.blockID];

        this.count=this.aryViewFreeTableBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewFreeTableBlocks[indexOrKey];
        }else{
            return this.dicViewFreeTableBlocks[indexOrKey];
        }
    };
    this.setViewFreeTableBlocks = function (data) {
        this.count = 0;
        this.dicViewFreeTableBlocks = {};
        this.aryViewFreeTableBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewFreeTableBlock(data[intI]);
            this.add(block);
        }
    };
}

/*类---磁贴块*/
function ViewTileBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.mainFormatString = options.mainFormatString;
    this.formatString1 = options.formatString1;
    this.formatString2 = options.formatString2;
    this.formatString3 = options.formatString3;
    this.formatString4 = options.formatString4;
    this.formatString5 = options.formatString5;
    this.formatString6 = options.formatString6;
    this.mainDataObject = options.mainDataObject;
    this.dataObject1 = options.dataObject1;
    this.dataObject2 = options.dataObject2;
    this.dataObject3 = options.dataObject3;
    this.dataObject4 = options.dataObject4;
    this.dataObject5 = options.dataObject5;
    this.dataObject6 = options.dataObject6;
    this.alertImage1 = options.alertImage1;
    this.alertImage2 = options.alertImage2;
    this.alertImage3 = options.alertImage3;
    this.alertImage4 = options.alertImage4;
    this.alertImage5 = options.alertImage5;
    this.alertImage6 = options.alertImage6;
    this.imageColor1 = options.imageColor1;
    this.imageColor2 = options.imageColor2;
    this.imageColor3 = options.imageColor3;
    this.imageColor4 = options.imageColor4;
    this.imageColor5 = options.imageColor5;
    this.imageColor6 = options.imageColor6;
    this.mainLabel = options.mainLabel;
    this.mainUnit = options.mainUnit;
    this.mainUnitTextBox = options.mainUnitTextBox;
    this.label1 = options.label1;
    this.label2 = options.label2;
    this.label3 = options.label3;
    this.label4 = options.label4;
    this.label5 = options.label5;
    this.label6 = options.label6;
    this.mainTextBox = options.mainTextBox;
    this.textBox1 = options.textBox1;
    this.textBox2 = options.textBox2;
    this.textBox3 = options.textBox3;
    this.textBox4 = options.textBox4;
    this.textBox5 = options.textBox5;
    this.textBox6 = options.textBox6;
    this.arrowDirection1 = options.arrowDirection1;
    this.arrowDirection2 = options.arrowDirection2;
    this.arrowDirection3 = options.arrowDirection3;
    this.arrowDirection4 = options.arrowDirection4;
    this.arrowDirection5 = options.arrowDirection5;
    this.arrowDirection6 = options.arrowDirection6;
    this.mainLabelTextBox = options.mainLabelTextBox;
    this.customColorApplyOtherThemes = options.customColorApplyOtherThemes;
    this.backgroundColor = options.backgroundColor;
    this.autoFontSize = options.autoFontSize;
    this.viewMainTileWarning = options.viewMainTileWarning;

    this.canDrillDown = function (viewBusinessObjectHierarchies){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        var arrDimension = [];
        if(this.mainDataObject){
            arrDimension.push(this.mainDataObject[0]+'___'+this.mainDataObject[1]);
        }
        if(this.dataObject1){
            arrDimension.push(this.dataObject1[0]+'___'+this.dataObject1[1]);
        }
        if(this.dataObject2){
            arrDimension.push(this.dataObject2[0]+'___'+this.dataObject2[1]);
        }
        if(this.dataObject3){
            arrDimension.push(this.dataObject3[0]+'___'+this.dataObject3[1]);
        }
        if(this.dataObject4){
            arrDimension.push(this.dataObject4[0]+'___'+this.dataObject4[1]);
        }
        if(this.dataObject5){
            arrDimension.push(this.dataObject5[0]+'___'+this.dataObject5[1]);
        }
        if(this.dataObject6){
            arrDimension.push(this.dataObject6[0]+'___'+this.dataObject6[1]);
        }

        var arrLinkageDimension = [];
        for(var i = 0; i < this.linkageParameters.length; i++){
            if(arrDimension.indexOf((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName)) == -1){
                arrLinkageDimension.push((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName));
            }
        }

        for(var i = 0; i < this.blockDataToDraw.length; i++){
            for(var key in this.blockDataToDraw[i]){
                if(arrLinkageDimension.indexOf(key) != -1){
                    delete this.blockDataToDraw[i][key];
                }
            }
        }
    }

    this.getLinkageParameters = function(){
        return;
    }

    this.getOfficeObjectData = function(dataKey){
        var officeData = {};
        officeData.labels = [];
        officeData.valueData = [];
        officeData.labels.push(dataKey.split("___")[1]);

        var dataObjectKey = [];
        var dataObject = [];
        var dataFormatString = [];
        if(this.mainDataObject){
            dataObjectKey.push(this.mainDataObject[0]+'___'+this.mainDataObject[1]);
            dataObject.push(this.mainDataObject);
            dataFormatString.push(this.mainFormatString);
        }
        if(this.dataObject1){
            dataObjectKey.push(this.dataObject1[0]+'___'+this.dataObject1[1]);
            dataObject.push(this.dataObject1);
            dataFormatString.push(this.dataObject1);
        }
        if(this.dataObject2){
            dataObjectKey.push(this.dataObject2[0]+'___'+this.dataObject2[1]);
            dataObject.push(this.dataObject2);
            dataFormatString.push(this.dataObject1);
        }
        if(this.dataObject3){
            dataObjectKey.push(this.dataObject3[0]+'___'+this.dataObject3[1]);
            dataObject.push(this.dataObject3);
            dataFormatString.push(this.dataObject1);
        }
        if(this.dataObject4){
            dataObjectKey.push(this.dataObject4[0]+'___'+this.dataObject4[1]);
            dataObject.push(this.dataObject4);
            dataFormatString.push(this.dataObject1);
        }
        if(this.dataObject5){
            dataObjectKey.push(this.dataObject5[0]+'___'+this.dataObject5[1]);
            dataObject.push(this.dataObject5);
            dataFormatString.push(this.dataObject1);
        }
        if(this.dataObject6){
            dataObjectKey.push(this.dataObject6[0]+'___'+this.dataObject6[1]);
            dataObject.push(this.dataObject6);
            dataFormatString.push(this.dataObject1);
        }

        for(var i = 0; i < this.blockDataToDraw.length; i++){
            var index = dataObjectKey.indexOf(dataKey);
            if(dataObject[index][3] == 1){
                officeData.valueData.push($BDA.formatString.date(dataFormatString[index],this.blockDataToDraw[i][dataKey]));
            }else if(dataObject[index][3] == 2){
                officeData.valueData.push($BDA.formatString.number(dataFormatString[index],this.blockDataToDraw[i][dataKey]));
            }else{
                officeData.valueData.push(this.blockDataToDraw[i][dataKey]);
            }
        }
        return officeData;
    }

    this.getDataType = function(){
        var tempObj = {};
        var measuresIndex = [];
        var dateIndex = [];

        if(this.mainDataObject && this.mainDataObject[3]==1){
            dateIndex.push(0);
        }
        if(this.mainDataObject && this.mainDataObject[3]==2){
            measuresIndex.push(0);
        }

        tempObj.measuresIndex = measuresIndex;
        tempObj.dateIndex = dateIndex;

        return tempObj;
    };

    this.setBlockData = function(){
        var measuresArr = [];
        if(this.mainDataObject && this.mainDataObject[2] == 1){
            measuresArr.push(this.mainDataObject[0]+'___'+this.mainDataObject[1]);
        }
        if(this.dataObject1 && this.dataObject1[2] == 1){
            measuresArr.push(this.dataObject1[0]+'___'+this.dataObject1[1]);
        }
        if(this.dataObject2 && this.dataObject2[2] == 1){
            measuresArr.push(this.dataObject2[0]+'___'+this.dataObject2[1]);
        }
        if(this.dataObject3 && this.dataObject3[2] == 1){
            measuresArr.push(this.dataObject3[0]+'___'+this.dataObject3[1]);
        }
        if(this.dataObject4 && this.dataObject4[2] == 1){
            measuresArr.push(this.dataObject4[0]+'___'+this.dataObject4[1]);
        }
        if(this.dataObject5 && this.dataObject5[2] == 1){
            measuresArr.push(this.dataObject5[0]+'___'+this.dataObject5[1]);
        }
        if(this.dataObject6 && this.dataObject6[2] == 1){
            measuresArr.push(this.dataObject6[0]+'___'+this.dataObject6[1]);
        }

        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(measuresArr.indexOf(key) != -1 && this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }
    };
}

function ViewTileBlocks(){
    this.count = 0;
    this.dicViewTileBlocks = {};
    this.aryViewTileBlocks = [];

    this.add = function (block) {
        this.aryViewTileBlocks.push(block);
        this.dicViewTileBlocks[block.blockID]=block;

        this.count = this.aryViewTileBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewTileBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewTileBlocks.splice(k,1);
        delete this.dicViewTileBlocks[block.blockID];

        this.count=this.aryViewTileBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewTileBlocks[indexOrKey];
        }else{
            return this.dicViewTileBlocks[indexOrKey];
        }
    };
    this.setViewTileBlocks = function (data) {
        this.count = 0;
        this.dicViewTileBlocks = {};
        this.aryViewTileBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewTileBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

/*类---仪表盘块*/
function ViewGaugeBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.formatString = options.formatString;
    this.measure = options.measure;
    this.viewGaugeWarning = options.viewGaugeWarning;

    this.canDrillDown = function (viewBusinessObjectHierarchies){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        return
    }

    this.getLinkageParameters = function(){
        return;
    }

    this.getDataType = function(){
        var tempObj = {};
        var measuresIndex = [];
        var dateIndex = [];

        if(this.measure && this.measure[3]==1){
            dateIndex.push(0);
        }
        if(this.measure && this.measure[3]==2){
            measuresIndex.push(0);
        }

        tempObj.measuresIndex = measuresIndex;
        tempObj.dateIndex = dateIndex;

        return tempObj;
    };

    this.setBlockData = function(){
        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }
    };
}

function ViewGaugeBlocks(){
    this.count = 0;
    this.dicViewGaugeBlocks = {};
    this.aryViewGaugeBlocks = [];

    this.add = function (block) {
        this.aryViewGaugeBlocks.push(block);
        this.dicViewGaugeBlocks[block.blockID]=block;

        this.count = this.aryViewGaugeBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewGaugeBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewGaugeBlocks.splice(k,1);
        delete this.dicViewGaugeBlocks[block.blockID];

        this.count=this.aryViewGaugeBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewGaugeBlocks[indexOrKey];
        }else{
            return this.dicViewGaugeBlocks[indexOrKey];
        }
    };
    this.setViewGaugeBlocks = function (data) {
        this.count = 0;
        this.dicViewGaugeBlocks = {};
        this.aryViewGaugeBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewGaugeBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

/*类---地图块*/
function ViewMapBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.formatString = options.formatString;
    this.mapCode = options.mapCode;
    this.mapData = null;
    this.parentID = options.parentID;
    this.mainMeasure = options.mainMeasure;
    this.otherMeasures = options.otherMeasures;
    this.locationDimension = options.locationDimension;
    this.viewGeographyDataCompares = options.viewGeographyDataCompares;
    this.geoLevel = options.geoLevel;
    this.haveChildMap = options.haveChildMap;
    this.linkage = options.linkage;
    this.mapLegend = options.mapLegend;
    this.colorSequence = options.colorSequence;
    this.symbolType = options.symbolType;
    this.symbolSize = options.symbolSize;
    this.symbolSizeFixed = options.symbolSizeFixed;
    this.mapDefaultColor = options.mapDefaultColor;
    this.mapHoverColor = options.mapHoverColor;
    this.mapBorderColor = options.mapBorderColor;
    this.mapBorderWidth = options.mapBorderWidth;

    this.canDrillDown = function (viewBusinessObjectHierarchies){
        var hierachy = null;
        var dimensionName = '';
        var queryName = '';

        for (var i= 0; i < viewBusinessObjectHierarchies.length; i++){
            hierachy = viewBusinessObjectHierarchies[i];
            if (hierachy.queryID == this.queryIDs[0]) {
                for (var j = 0; j < hierachy.hierarchyDimensions.length; j++) {
                    dimensionName = hierachy.hierarchyDimensions[j][1];
                    queryName = hierachy.hierarchyDimensions[j][0];
                    if (this.locationDimension && dimensionName == this.locationDimension[1] && queryName == this.locationDimension[0]) {
                        if (j < hierachy.hierarchyDimensions.length - 1) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    this.getLinkageParameters = function(){
        var linkageParameters = [];
        var objLinkageParameter = {};

        if (this.locationDimension){
            objLinkageParameter.blockID = this.blockID;
            objLinkageParameter.dimensionValue = "";
            objLinkageParameter.queryName = this.locationDimension[0];
            objLinkageParameter.dimensionName = this.locationDimension[1];
            objLinkageParameter.dataType = this.locationDimension[3];
            if (this.blockDataToDraw.length){
                objLinkageParameter.dimensionValue = this.blockDataToDraw[0][this.locationDimension[0] +
                "___" +
                this.locationDimension[1]];
            }

            linkageParameters.push(objLinkageParameter);
        }

        return linkageParameters;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        var arrDimension = [];
        if(this.locationDimension){
            arrDimension.push(this.locationDimension[0]+'___'+this.locationDimension[1]);
        }

        var arrLinkageDimension = [];
        for(var i = 0; i < this.linkageParameters.length; i++){
            if(arrDimension.indexOf((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName)) == -1){
                arrLinkageDimension.push((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName));
            }
        }

        for(var i = 0; i < this.blockDataToDraw.length; i++){
            for(var key in this.blockDataToDraw[i]){
                if(arrLinkageDimension.indexOf(key) != -1){
                    delete this.blockDataToDraw[i][key];
                }
            }
        }
    }

    this.getDataType = function(){
        var tempObj = {};
        var measuresIndex = [];
        var dateIndex = [];
        var defaultIndex = 0;

        if(this.locationDimension){
            if(this.locationDimension[3] == 1){
                dateIndex.push(0);
            }
            if(this.locationDimension[3] == 2){
                measuresIndex.push(0);
            }
            defaultIndex = 1;
        }

        var measures = this.mainMeasure.concat(this.otherMeasures);
        for(var i = 0; i < measures.length; i++){
            measuresIndex.push(i+defaultIndex);
        }

        tempObj.measuresIndex = measuresIndex;
        tempObj.dateIndex = dateIndex;

        return tempObj;
    };

    this.setBlockData = function(){
        var measuresArr = [];
        if(this.mainMeasure){
            measuresArr.push(this.mainMeasure[0]+"___"+this.mainMeasure[1]);
        }
        for(var i = 0; i < this.otherMeasures.length; i++){
            measuresArr.push(this.otherMeasures[i][0]+"___"+this.otherMeasures[i][1]);
        }

        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(measuresArr.indexOf(key) != -1 && this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }

    };
}

function ViewMapBlocks(){
    this.count = 0;
    this.dicViewMapBlocks = {};
    this.aryViewMapBlocks = [];

    this.add = function (block) {
        this.aryViewMapBlocks.push(block);
        this.dicViewMapBlocks[block.blockID]=block;

        this.count = this.aryViewMapBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewMapBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewMapBlocks.splice(k,1);
        delete this.dicViewMapBlocks[block.blockID];

        this.count=this.aryViewMapBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewMapBlocks[indexOrKey];
        }else{
            return this.dicViewMapBlocks[indexOrKey];
        }
    };

    this.setViewMapBlocks = function (data) {
        this.count = 0;
        this.dicViewMapBlocks = {};
        this.aryViewMapBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewMapBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };


}

/*类---标签块*/
function ViewLabelBlock(options){
    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.labelContent = options.labelContent;
    this.labelTextBox = options.labelTextBox;
    this.images = options.images;
    this.carouselInterval = options.carouselInterval;
    this.tileMode = options.tileMode;
    this.freeCellType = options.freeCellType;
    this.dateTimeFormatString = options.dateTimeFormatString;
    this.textScroll = options.textScroll;
    this.dataObject = options.dataObject;
    this.scrollDirection = options.scrollDirection;
    this.scrollTimePerPx = options.scrollTimePerPx;
    this.imageRadius = options.imageRadius;
    this.showCircleImage = options.showCircleImage;
    this.formatString = options.formatString;

    this.canDrillDown = function (viewBusinessObjectHierarchies){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        return
    }

    this.getLinkageParameters = function(){
        return;
    };

    this.setBlockData = function(){
        var measuresArr = [];
        if(this.dataObject && this.dataObject[2] == 1){
            measuresArr.push(this.dataObject[0]+"___"+this.dataObject[1]);
        }
        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(measuresArr.indexOf(key) != -1 && this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }
    };
}

function ViewLabelBlocks(){
    this.count = 0;
    this.dicViewLabelBlocks = {};
    this.aryViewLabelBlocks = [];

    this.add = function (block) {
        this.aryViewLabelBlocks.push(block);
        this.dicViewLabelBlocks[block.blockID]=block;

        this.count = this.aryViewLabelBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewLabelBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewLabelBlocks.splice(k,1);
        delete this.dicViewLabelBlocks[block.blockID];

        this.count=this.aryViewLabelBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewLabelBlocks[indexOrKey];
        }else{
            return this.dicViewLabelBlocks[indexOrKey];
        }
    };
    this.setViewLabelBlocks = function (data) {
        this.count = 0;
        this.dicViewLabelBlocks = {};
        this.aryViewLabelBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewLabelBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

function Linkage(options){
    this.blockIDs = options.blockIDs;
}

/*类---折叠表*/
function ViewFoldingTableBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    var dimensions = new Dimensions();
    dimensions.setDimensions(options.dimensions);

    var foldingMeasures = new FoldingMeasures();
    foldingMeasures.setFoldingMeasures(options.foldingMeasures);

    var aggregateLines = new AggregateLines();
    aggregateLines.setAggregateLines(options.aggregateLines);
    
    this.foldingDimensionFormatStrings = options.foldingDimensionFormatStrings;
    this.measureFormatStrings = options.measureFormatStrings;
    this.tableStyle = options.tableStyle;
    this.tableStyleColor = options.tableStyleColor;
    this.viewTableHead = options.viewTableHead;
    this.headHeight = options.headHeight;
    this.viewTableBody = options.viewTableBody;
    this.bodyHeight = options.bodyHeight;
    this.rowTotal = options.rowTotal;
    this.padding = options.padding;
    this.pagingDisplay = options.pagingDisplay;
    this.pageRecordCount = options.pageRecordCount;

    this.dimensions = dimensions;
    this.foldingMeasures = foldingMeasures;
    this.aggregateLines = aggregateLines;

    this.canDrillDown = function (viewBusinessObjectHierarchies){
        return false;
    }

    this.getLinkageParameters = function(){
        return;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        var arrDimension = [];
        for(var i = 0; i < this.dimensions.count; i++){
            arrDimension.push(this.dimensions.item(i).dimensionObject[0] + '___' + this.dimensions.item(i).dimensionObject[1]);
        }

        var arrLinkageDimension = [];
        for(var i = 0; i < this.linkageParameters.length; i++){
            if(arrDimension.indexOf((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName)) == -1){
                arrLinkageDimension.push((this.linkageParameters[i].queryName+"___"+this.linkageParameters[i].dimensionName));
            }
        }

        for(var i = 0; i < this.blockDataToDraw.length; i++){
            for(var key in this.blockDataToDraw[i]){
                if(arrLinkageDimension.indexOf(key) != -1){
                    delete this.blockDataToDraw[i][key];
                }
            }
        }
    }

    this.getDataType = function(){
        var tempObj = {};
        var measuresIndex = [];
        var dateIndex = [];

        var tempDimensions = [];
        for(var i = 0; i < this.dimensions.count; i++){
            tempDimensions.push(this.dimensions.item(i).dimensionObject);
        }

        var tempMeasures = [];
        for(var i = 0; i < this.foldingMeasures.count; i++){
            tempMeasures.push(this.foldingMeasures.item(i).measureObject)
        }

        var dimensionAndMeasures = tempDimensions.concat(tempMeasures);

        for(var i = 0; i < dimensionAndMeasures.length; i++){
            if(dimensionAndMeasures[i][3]==1){
                dateIndex.push(i);
            }
            if(dimensionAndMeasures[i][3]==2){
                measuresIndex.push(i);
            }
        }

        tempObj.measuresIndex = measuresIndex;
        tempObj.dateIndex = dateIndex;

        return tempObj;
    };

    this.setBlockData = function(){
        var measuresArr = [];
        for (var i = 0; i < this.foldingMeasures.count; i++){
            measuresArr.push(this.measures.item(i).measureObject[0] + "___" + this.measures.item(i).measureObject[1]);
        }

        if(this.blockData){
            for(var i = 0; i < this.blockData.length; i++){
                for(var key in this.blockData[i]){
                    if(measuresArr.indexOf(key) != -1 && this.blockData[i][key] == null){
                        this.blockData[i][key] = 0;
                    }
                }
            }
        }

    };
}

function ViewFoldingTableBlocks(){
    this.count = 0;
    this.dicViewFoldingTableBlocks = {};
    this.aryViewFoldingTableBlocks = [];

    this.add = function (block) {
        this.aryViewFoldingTableBlocks.push(block);
        this.dicViewFoldingTableBlocks[block.blockID]=block;

        this.count = this.aryViewFoldingTableBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewFoldingTableBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewFoldingTableBlocks.splice(k,1);
        delete this.dicViewFoldingTableBlocks[block.blockID];

        this.count=this.aryViewFoldingTableBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewFoldingTableBlocks[indexOrKey];
        }else{
            return this.dicViewFoldingTableBlocks[indexOrKey];
        }
    };

    this.setViewFoldingTableBlocks = function (data) {
        this.count = 0;
        this.dicViewFoldingTableBlocks = {};
        this.aryViewFoldingTableBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewFoldingTableBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };

}

function Dimension(options){
    this.dimensionID = options.dimensionID;
    this.dimensionObject = options.dimensionObject;
    this.aggregate = options.aggregate;
    this.aggregatePosition = options.aggregatePosition;
}

function Dimensions() {
    this.count = 0;
    this.dicFoldingDimensions = {};
    this.aryFoldingDimensions = [];

    this.add = function (dimension) {
        this.aryDimensions.push(dimension);
        this.dicDimensions[dimension.dimensionID] = dimension;

        this.count = this.aryDimensions.length;
    };
    this.remove = function (dimension) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryDimensions[i].dimensionID == dimension.dimensionID) {
                k = i;
                break;
            }
        }
        this.aryDimensions.splice(k, 1);
        delete this.dicDimensions[dimension.dimensionID];

        this.count = this.aryDimensions.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryDimensions[indexOrKey];
        } else {
            return this.dicDimensions[indexOrKey];
        }
    };

    this.setDimensions = function (data) {
        this.count = 0;
        this.dicDimensions = {};
        this.aryDimensions = [];
        for (var intI = 0; intI < data.length; intI++) {
            data[intI].dimensionID = "d" + intI;
            var dimension = new Dimension(data[intI]);
            this.add(dimension);
        }
    };

}

function FoldingMeasure(options){
    this.foldingMeasureID = options.foldingMeasureID;
    this.measureObject = options.measureObject;
    this.aggregateFunctions = options.aggregateFunctions;
}

function FoldingMeasures(){
    this.count = 0;
    this.dicFoldingMeasures = {};
    this.aryFoldingMeasures = [];

    this.add = function (foldingMeasure) {
        this.aryFoldingMeasures.push(foldingMeasure);
        this.dicFoldingMeasures[foldingMeasure.foldingMeasureID] = foldingMeasure;

        this.count = this.aryFoldingMeasures.length;
    };
    this.remove = function (foldingMeasure) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryFoldingMeasures[i].foldingMeasureID == foldingMeasure.foldingMeasureID) {
                k = i;
                break;
            }
        }
        this.aryFoldingMeasures.splice(k, 1);
        delete this.dicFoldingMeasures[foldingMeasure.foldingMeasureID];

        this.count = this.aryFoldingMeasures.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryFoldingMeasures[indexOrKey];
        } else {
            return this.dicFoldingMeasures[indexOrKey];
        }
    };

    this.setFoldingMeasures = function (data) {
        this.count = 0;
        this.dicFoldingMeasures = {};
        this.aryFoldingMeasures = [];
        for (var intI = 0; intI < data.length; intI++) {
            data[intI].foldingMeasureID = "m" + intI;
            var foldingMeasure = new FoldingMeasure(data[intI]);
            this.add(foldingMeasure);
        }
    };
}

function AggregateLine(options){
    this.aggregateLineID = options.aggregateLineID;
    this.defaultAggregateFunction = options.defaultAggregateFunction;
    this.subtotalLabel = options.subtotalLabel;
    this.totalLabel = options.totalLabel;
}

function AggregateLines(){
    this.count = 0;
    this.dicAggregateLines = {};
    this.aryAggregateLines = [];

    this.add = function (aggregateLine) {
        this.aryAggregateLines.push(aggregateLine);
        this.dicAggregateLines[aggregateLine.aggregateLineID] = aggregateLine;

        this.count = this.aryAggregateLines.length;
    };
    this.remove = function (aggregateLine) {
        for (var i = 0, len = this.count, k; i < len; i++) {
            if (this.aryAggregateLines[i].aggregateLineID == aggregateLine.aggregateLineID) {
                k = i;
                break;
            }
        }
        this.aryAggregateLines.splice(k, 1);
        delete this.dicAggregateLines[aggregateLine.aggregateLineID];

        this.count = this.aryAggregateLines.length;
    };
    this.item = function (indexOrKey) {
        if (typeof indexOrKey == 'number') {
            return this.aryAggregateLines[indexOrKey];
        } else {
            return this.dicAggregateLines[indexOrKey];
        }
    };

    this.setAggregateLines = function (data) {
        this.count = 0;
        this.dicAggregateLines = {};
        this.aryAggregateLines = [];
        for (var intI = 0; intI < data.length; intI++) {
            data[intI].aggregateLineID = "aggre" + intI;
            var aggregateLine = new AggregateLine(data[intI]);
            this.add(aggregateLine);
        }
    };
}

/*类---报表容器*/
function ViewReportContainerBlock(options){
    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.reportID = options.reportID;
    this.reportLinkFilters = options.reportLinkFilters;

    this.canDrillDown = function (viewBusinessObjectHierarchies){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        return
    }

    this.getLinkageParameters = function(){
        return;
    };
    
    this.setBlockData = function(){
        return;

    };
}

function ViewReportContainerBlocks(){
    this.count = 0;
    this.dicViewReportContainerBlocks = {};
    this.aryViewReportContainerBlocks = [];

    this.add = function (block) {
        this.aryViewReportContainerBlocks.push(block);
        this.dicViewReportContainerBlocks[block.blockID]=block;

        this.count = this.aryViewReportContainerBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewReportContainerBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewReportContainerBlocks.splice(k,1);
        delete this.dicViewReportContainerBlocks[block.blockID];

        this.count=this.aryViewReportContainerBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewReportContainerBlocks[indexOrKey];
        }else{
            return this.dicViewReportContainerBlocks[indexOrKey];
        }
    };

    this.setViewReportContainerBlocks = function (data) {
        this.count = 0;
        this.dicViewReportContainerBlocks = {};
        this.aryViewReportContainerBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewReportContainerBlock(data[intI]);
            this.add(block);
        }
    };
}

/*类---按钮*/
function ViewButtonBlock(options){
    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.text = options.text;
    this.dataObject = options.dataObject;
    this.subReports = options.subReports;
    this.textBox = options.textBox;
    this.groupName = options.groupName;
    this.selectedTextBox = options.selectedTextBox;
    this.defaultSelected = options.defaultSelected;
    this.contentType = options.contentType;
    this.image = options.image;
    // this.radius = options.radius;
    // this.borderWidth = options.borderWidth;
    // this.borderColor = options.borderColor;
    this.selectedBorderWidth = options.selectedBorderWidth;
    this.selectedBorderColor = options.selectedBorderColor;
    this.carousel = options.carousel;
    this.carouselInterval = options.carouselInterval;
    this.index = options.index;
    this.selectedIndex = options.defaultSelected;
    this.linkageValue = options.linkageValue;
    this.imageDataObject = options.imageDataObject;
    this.selectedImage = options.selectedImage;
    this.tileMode = options.tileMode;
    this.icon = options.icon;
    this.iconLocation = options.iconLocation;

    this.canDrillDown = function (){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        return
    }

    this.getLinkageParameters = function(){
        var linkageParameters = [];
        if(this.dataObject){
            var objLinkageParameter = {};
            objLinkageParameter.blockID = this.blockID;
            objLinkageParameter.dimensionValue = this.text || "";
            objLinkageParameter.queryName = this.dataObject[0];
            objLinkageParameter.dimensionName = this.dataObject[1];
            objLinkageParameter.dataType = this.dataObject[3];

            linkageParameters.push(objLinkageParameter);
        }

        return linkageParameters;
    };

    this.setBlockData = function(){
        return;
    };
}

function ViewButtonBlocks(){
    this.count = 0;
    this.dicViewButtonBlocks = {};
    this.aryViewButtonBlocks = [];

    this.add = function (block) {
        this.aryViewButtonBlocks.push(block);
        this.dicViewButtonBlocks[block.blockID]=block;

        this.count = this.aryViewButtonBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewButtonBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewButtonBlocks.splice(k,1);
        delete this.dicViewButtonBlocks[block.blockID];

        this.count=this.aryViewButtonBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewButtonBlocks[indexOrKey];
        }else{
            return this.dicViewButtonBlocks[indexOrKey];
        }
    };

    this.setViewButtonBlocks = function (data) {
        this.count = 0;
        this.dicViewButtonBlocks = {};
        this.aryViewButtonBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewButtonBlock(data[intI]);
            this.add(block);
        }
    };
}

/*类---设备状态*/
function ViewEquipmentBlock(options){
    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.measures = options.measures;
    this.labelTextBox = options.labelTextBox;
    this.valueTextBox = options.valueTextBox;
    // this.borderColor = options.borderColor;
    // this.borderWidth = options.borderWidth;
    // this.borderRadius = options.borderRadius;
    this.equipmentDimension = options.equipmentDimension;
    this.statusDimension = options.statusDimension;
    this.runningStyle = new EquipmentStatusStyle(options.runningStyle);
    this.idleStyle = new EquipmentStatusStyle(options.idleStyle);
    this.warningStyle = new EquipmentStatusStyle(options.warningStyle);
    this.breakdownStyle = new EquipmentStatusStyle(options.breakdownStyle);
    this.fromDateDimension = options.fromDateDimension;
    this.toDateDimension = options.toDateDimension;
    // this.legendShow = options.legendShow;
    // this.legendPosition = options.legendPosition;
    // this.legendFont = options.legendFont;
    // this.legendColor = options.legendColor;
    // this.timeRange = new TimeRange(options.timeRange);
    this.showScale = options.showScale;
    this.scaleFont = options.scaleFont;
    this.scaleColor = options.scaleColor;
    this.xScaleLineColor = options.xScaleLineColor;
    this.xScaleLineWidth = options.xScaleLineWidth;
    this.y1ScaleLineColor = options.y1ScaleLineColor;
    this.y1ScaleLineWidth = options.y1ScaleLineWidth;
    this.showGridLine = options.showGridLine;
    this.showTick = options.showTick;
    this.timeUnit = options.timeUnit;

    this.canDrillDown = function (){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        return
    };

    this.setBlockData = function(){
        return;
    };
}

function ViewEquipmentBlocks(){
    this.count = 0;
    this.dicViewEquipmentBlocks = {};
    this.aryViewEquipmentBlocks = [];

    this.add = function (block) {
        this.aryViewEquipmentBlocks.push(block);
        this.dicViewEquipmentBlocks[block.blockID]=block;

        this.count = this.aryViewEquipmentBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewEquipmentBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewEquipmentBlocks.splice(k,1);
        delete this.dicViewEquipmentBlocks[block.blockID];

        this.count=this.aryViewEquipmentBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewEquipmentBlocks[indexOrKey];
        }else{
            return this.dicViewEquipmentBlocks[indexOrKey];
        }
    };

    this.setViewEquipmentBlocks = function (data) {
        this.count = 0;
        this.dicViewEquipmentBlocks = {};
        this.aryViewEquipmentBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewEquipmentBlock(data[intI]);
            this.add(block);
        }
    };
}

function EquipmentStatusStyle(options){
    this.statusDimensionValue = options.statusDimensionValue;
    this.borderColor = options.borderColor;
    this.equipmentNameColor = options.equipmentNameColor;
    this.flashing = options.flashing;
}

/*类---简单甘特*/
function ViewGanttBlock(options){

    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.jobDimension = options.jobDimension;
    this.statusDimension = options.statusDimension;
    this.startDate = options.startDate;
    this.endDate = options.endDate;
    this.completeness = options.completeness;

    this.showScale = options.showScale;
    this.scaleFont = options.scaleFont;
    this.scaleColor = options.scaleColor;
    this.scaleFormat = options.scaleFormat;
    this.xScaleLineColor = options.xScaleLineColor;
    this.xScaleLineWidth = options.xScaleLineWidth;
    this.y1ScaleLineColor = options.y1ScaleLineColor;
    this.y1ScaleLineWidth = options.y1ScaleLineWidth;
    this.y2ScaleLineColor = options.y2ScaleLineColor;
    this.y2ScaleLineWidth = options.y2ScaleLineWidth;
    this.legendShow = options.legendShow;
    this.legendPosition = options.legendPosition;
    this.legendFont = options.legendFont;
    this.legendColor = options.legendColor;
    this.showDataInLegend = options.showDataInLegend;
    this.dataShow = options.dataShow;
    this.dataFont = options.dataFont;
    this.dataHoverShow = options.dataHoverShow;
    this.dataHoverFont = options.dataHoverFont;
    this.dataHoverColor = options.dataHoverColor;
    this.dataColor = options.dataColor;
    this.showGridLine = options.showGridLine;
    this.showTick = options.showTick;
    this.showTickValue = options.showTickValue;
    this.ontimeDimensionValue = options.ontimeDimensionValue;
    this.ontimeColor = options.ontimeColor;
    this.delayedDimensionValue = options.delayedDimensionValue;
    this.delayedColor = options.delayedColor;
    this.barWidth = options.barWidth;

    this.canDrillDown = function (){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        return
    };

    this.setBlockData = function(){
        return;
    };
}

function ViewGanttBlocks(){
    this.count = 0;
    this.dicViewGanttBlocks = {};
    this.aryViewGanttBlocks = [];

    this.add = function (block) {
        this.aryViewGanttBlocks.push(block);
        this.dicViewGanttBlocks[block.blockID]=block;

        this.count = this.aryViewGanttBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewGanttBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewGanttBlocks.splice(k,1);
        delete this.dicViewGanttBlocks[block.blockID];

        this.count=this.aryViewGanttBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewGanttBlocks[indexOrKey];
        }else{
            return this.dicViewGanttBlocks[indexOrKey];
        }
    };

    this.setViewGanttBlocks = function (data) {
        this.count = 0;
        this.dicViewGanttBlocks = {};
        this.aryViewGanttBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewGanttBlock(data[intI]);
            this.add(block);
        }
    };
}

/*类---页签控件*/
function ViewTabControlBlock(options){
    ViewBlock.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.tabHeadLayoutStyle = options.tabHeadLayoutStyle;
    this.tabHeadPadding = options.tabHeadPadding;
    this.tabHeads = options.tabHeads;
    this.tabBodys = options.tabBodys;
    this.tabHeadLocation = options.tabHeadLocation;
    this.carousel = options.carousel;
    this.carouselInterval = options.carouselInterval;

    this.canDrillDown = function (){
        return false;
    }

    this.removeBlockDataToDrawUnusefulValue = function(){
        return
    };

    this.setBlockData = function(){
        return;

    };
}

function ViewTabControlBlocks(){
    this.count = 0;
    this.dicViewTabControlBlocks = {};
    this.aryViewTabControlBlocks = [];

    this.add = function (block) {
        this.aryViewTabControlBlocks.push(block);
        this.dicViewTabControlBlocks[block.blockID]=block;

        this.count = this.aryViewTabControlBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewTabControlBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewTabControlBlocks.splice(k,1);
        delete this.dicViewTabControlBlocks[block.blockID];

        this.count=this.aryViewTabControlBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewTabControlBlocks[indexOrKey];
        }else{
            return this.dicViewTabControlBlocks[indexOrKey];
        }
    };

    this.setViewTabControlBlocks = function (data) {
        this.count = 0;
        this.dicViewTabControlBlocks = {};
        this.aryViewTabControlBlocks = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewTabControlBlock(data[intI]);
            this.add(block);
        }
    };
}

/*类---Page*/
function Page(options){
    this.pageID = options.pageID;
    this.rows = options.rows;
    this.columns = options.columns;
    this.pageImage = options.pageImage;
    this.backgroundColor = options.backgroundColor;
}

function PcPages(){
    this.count = 0;
    this.dicPages = {};
    this.aryPages = [];

    this.add = function (page) {
        this.aryPages.push(page);
        this.dicPages[page.pageID]=page;

        this.count = this.aryPages.length;
    };
    this.remove = function (page) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPages[i].pageID==page.pageID){
                k=i;
                break;
            }
        }
        this.aryPages.splice(k,1);
        delete this.dicPages[page.pageID];

        this.count=this.aryPages.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPages[indexOrKey];
        }else{
            return this.dicPages[indexOrKey];
        }
    };
    this.getPages = function (data) {
        this.count = 0;
        this.dicPages = {};
        this.aryPages = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var page = new Page(data[intI]);
            this.add(page);
        }
    };
}

function PadPages(){
    this.count = 0;
    this.dicPages = {};
    this.aryPages = [];

    this.add = function (page) {
        this.aryPages.push(page);
        this.dicPages[page.pageID]=page;

        this.count = this.aryPages.length;
    };
    this.remove = function (page) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPages[i].pageID==page.pageID){
                k=i;
                break;
            }
        }
        this.aryPages.splice(k,1);
        delete this.dicPages[page.pageID];

        this.count=this.aryPages.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPages[indexOrKey];
        }else{
            return this.dicPages[indexOrKey];
        }
    };
    this.getPages = function (data) {
        this.count = 0;
        this.dicPages = {};
        this.aryPages = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var page = new Page(data[intI]);
            this.add(page);
        }
    };
}

function MobilePages(){
    this.count = 0;
    this.dicPages = {};
    this.aryPages = [];

    this.add = function (page) {
        this.aryPages.push(page);
        this.dicPages[page.pageID]=page;

        this.count = this.aryPages.length;
    };
    this.remove = function (page) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPages[i].pageID==page.pageID){
                k=i;
                break;
            }
        }
        this.aryPages.splice(k,1);
        delete this.dicPages[page.pageID];

        this.count=this.aryPages.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPages[indexOrKey];
        }else{
            return this.dicPages[indexOrKey];
        }
    };
    this.getPages = function (data) {
        this.count = 0;
        this.dicPages = {};
        this.aryPages = [];
        for(var intI = 0; intI < data.length; intI++ ){
            var page = new Page(data[intI]);
            this.add(page);
        }
    };
}

/*类---PromptFilter*/
function PromptFilter(options){
    this.filterID = options.filterID;
    this.valueObjectType = options.valueObjectType;
    this.multipleValue = options.multipleValue;
    this.valueObjectName = options.valueObjectName;
    this.dataType = options.dataType;
    this.prompt = options.prompt;
    this.operation = options.operation;
    this.valueObjectData = options.valueObjectData;
    this.filterValues = options.filterValues;
    this.formatString = options.formatString;
    this.cascadePrompt = options.cascadePrompt;
    this.marginRight = options.marginRight;
    this.inputWidth = options.inputWidth;
    this.selectedValues = [];
    this.directInput = options.directInput;
    this.mustInput = options.mustInput;

    this.convertObjectData = function(){
        if (this.dataType == 1 && this.valueObjectData.length){
            var self = this;
            $.each(this.valueObjectData,function(){
                this[self.valueObjectName] = $BDA.formatString.date('',new Date(this[self.valueObjectName]));
            });
        }
    };

    this.setSelectedValues = function(){
        for (var i = 0,len=this.filterValues.length;i<len;i++){
            var value = this.filterValues[i].value;
            //if (this.dataType == 1){
            //    value = $BDA.formatString.date('',new Date(parseInt(this.filterValues[i].value)));
            //}
            this.selectedValues.push(value);
        }
    }
}

function PromptFilters(basePath){
    this.basePath = basePath;
    this.domain = this.basePath + '/Report/reports/';
    this.uri = '/promptFilters';
    this.count = 0;
    this.dicPromptFilters = {};
    this.aryPromptFilters = [];

    this.add = function (filter) {
        this.aryPromptFilters.push(filter);
        this.dicPromptFilters[filter.filterID]=filter;

        this.count = this.aryPromptFilters.length;
    };

    this.remove = function (filter) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPromptFilters[i].filterID==filter.filterID){
                k=i;
                break;
            }
        }
        this.aryPromptFilters.splice(k,1);
        delete this.dicPromptFilters[filter.filterID];

        this.count=this.aryPromptFilters.length;
    };

    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPromptFilters[indexOrKey];
        }else{
            return this.dicPromptFilters[indexOrKey];
        }
    };

    this.getPromptFilters = function (requestParameters,includeValueObjectData,reportID,succ,error) {
        var me=this;
        ajaxTools.request(this.domain+reportID+this.uri+"?includeValueObjectData="+includeValueObjectData,"","get",function(data,status,jqXHR){
            if(status == 'success'){
                me.count = 0;
                me.dicPromptFilters = {};
                me.aryPromptFilters = [];
                var filters = data.items;
                for(var intI = 0; intI < filters.length; intI++ ){
                    var filter = new PromptFilter(filters[intI]);
                    filter.convertObjectData();
                    filter.setSelectedValues();
                    me.add(filter);
                }
                succ();
            }
        },function(XHR,textStatus){
            error("获取过滤条件",XHR,textStatus);
        });
    };
}

/*类---钻取数据*/
function DrillingBlockData(basePath){
    this.basePath = basePath;
    this.domain = this.basePath + '/Report/reports/';
    this.uri1 = '/blocks/';
    this.uri2 = '/drillingBlockData';

    this.getDrillingBlockData = function(reportID,blockID, requestParameters, success, error){
        var obj = {
            promptFilters: requestParameters.promptFilters,
            drilledFilters: requestParameters.drilledFilters,
            selectObjectNames: requestParameters.selectObjectNames
        };
        if(requestParameters.geoLevel){
            obj.geoLevel = requestParameters.geoLevel;
            obj.mapGeoName = requestParameters.mapGeoName
        }
        obj = JSON.stringify(obj);
        ajaxTools.request(this.domain+reportID+this.uri1+blockID+this.uri2, obj,"post", function(data, status, jqXHR){
            if(status == 'success'){
                success(data);
            }
        }, function(XHR, statusText){
            error("获取钻取数据",XHR, statusText);
        });
    };
}

/*类---地图钻取数据*/
function DrillingViewMapBlock(basePath){
    this.basePath = basePath;
    this.domain = this.basePath + '/Report/reports/';
    this.uri1 = '/reportView/viewMapBlocks/';
    this.uri2 = '/drillingViewMapBlock';

    this.getDrillingViewMapBlock = function(reportID,blockID, requestParameters, success, error){
        var obj = {
            promptFilters: requestParameters.promptFilters,
            drilledFilters: requestParameters.drilledFilters,
            selectObjectNames: requestParameters.selectObjectNames,
            geoLevel: requestParameters.geoLevel,
            mapGeoName: requestParameters.mapGeoName
        };
        obj = JSON.stringify(obj);
        ajaxTools.request(this.domain+reportID+this.uri1+blockID+this.uri2, obj,"post", function(data, status, jqXHR){
            if(status == 'success'){
                success(data);
            }
        }, function(XHR, statusText){
            error(XHR, statusText);
        });
    };
}

/*类------systemSetting*/
function reportSettings(){
    this.clickBlockToMaxForMobile = null;
    this.autoRefresh = null;
    this.refreshInterval = null;
    this.customLayoutForMobile = 0;
    this.directShowDataInChartForMobile = 0;
    this.displayHoverShadow = null;
    this.autoCloseComponent = null;
    this.closeComponentInterval = null;
    this.autoReturnDefaultFilters = null;
    this.returnDefaultFiltersInterval = null;
    this.showBackButtonWhenPCFullscreen = null;
    this.backButtonInitPosition = null;
    this.pageWidth = null;
    this.pageHeight = null;
    this.showMagnifierGeneral = null;
    this.scaleByScreenSize = null;
    this.filterDialogInitPosition = null;
    this.toolButonsColor = null;
    this.colorOfTransformedTableBody = null;
    this.followDesignSize = null;
    this.useComputerStyleForMobile = null;
    this.linkCoverMyself = null;
    this.calendarWithLunar = null;
    this.showPFinReport = null;

    this.getReportSettings = function(items){
        for (var i=0;i<items.length;i++){
            if (items[i].reportSettingKey == "clickBlockToMaxForMobile"){
                this.clickBlockToMaxForMobile = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'autoRefresh'){
                this.autoRefresh = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'refreshInterval'){
                this.refreshInterval = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey =='customLayoutForMobile'){
                this.customLayoutForMobile = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey =='directShowDataInChartForMobile'){
                this.directShowDataInChartForMobile = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'displayHoverShadow'){
                this.displayHoverShadow = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'autoCloseComponent'){
                this.autoCloseComponent = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'closeComponentInterval'){
                this.closeComponentInterval = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'autoReturnDefaultFilters'){
                this.autoReturnDefaultFilters = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'returnDefaultFiltersInterval'){
                this.returnDefaultFiltersInterval = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'showBackButtonWhenPCFullscreen'){
                this.showBackButtonWhenPCFullscreen = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'backButtonInitPosition'){
                this.backButtonInitPosition = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'pageWidth'){
                this.pageWidth = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'pageHeight'){
                this.pageHeight = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'showMagnifierGeneral'){
                this.showMagnifierGeneral = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'scaleByScreenSize'){
                this.scaleByScreenSize = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'filterDialogInitPosition'){
                this.filterDialogInitPosition = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'toolButonsColor'){
                this.toolButonsColor = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'colorOfTransformedTableBody'){
                this.colorOfTransformedTableBody = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'followDesignSize'){
                this.followDesignSize = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'useNumericSymbols'){
                this.useNumericSymbols = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'nullDisplayWithZero'){
                this.nullDisplayWithZero = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'useComputerStyleForMobile'){
                this.useComputerStyleForMobile = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'linkCoverMyself'){
                this.linkCoverMyself = items[i].reportSettingValue;
            }
            if(items[i].reportSettingKey == 'calendarWithLunar'){
                this.calendarWithLunar = items[i].reportSettingValue;
            }
            if (items[i].reportSettingKey == 'showPFinReport'){
                this.showPFinReport = items[i].reportSettingValue;
            }
        }
    };
}