'use strict';
/*类----磁贴图*/
function TileChart(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    var mainDataScale = 0.7;
    var mainlabelScale = 0.8;
    var otherDataScale = 0.8;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignTileChartData();
    this.heightObject = {};

    function assignTileChartData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var tileData = {},blockData = viewBlock.blockDataToDraw[0];
        tileData.mainDataObject = viewBlock.mainDataObject?blockData[viewBlock.mainDataObject[0]+'___'+viewBlock.mainDataObject[1]]:null;
        tileData.dataObject1 = viewBlock.dataObject1?blockData[viewBlock.dataObject1[0]+'___'+viewBlock.dataObject1[1]]:null;
        tileData.dataObject2 = viewBlock.dataObject2?blockData[viewBlock.dataObject2[0]+'___'+viewBlock.dataObject2[1]]:null;
        tileData.dataObject3 = viewBlock.dataObject3?blockData[viewBlock.dataObject3[0]+'___'+viewBlock.dataObject3[1]]:null;
        tileData.dataObject4 = viewBlock.dataObject4?blockData[viewBlock.dataObject4[0]+'___'+viewBlock.dataObject4[1]]:null;
        tileData.dataObject5 = viewBlock.dataObject5?blockData[viewBlock.dataObject5[0]+'___'+viewBlock.dataObject5[1]]:null;
        tileData.dataObject6 = viewBlock.dataObject6?blockData[viewBlock.dataObject6[0]+'___'+viewBlock.dataObject6[1]]:null;
        tileData.mainFormatString = viewBlock.mainFormatString;
        tileData.formatString1 = viewBlock.formatString1;
        tileData.formatString2 = viewBlock.formatString2;
        tileData.formatString3 = viewBlock.formatString3;
        tileData.formatString4 = viewBlock.formatString4;
        tileData.formatString5 = viewBlock.formatString5;
        tileData.formatString6 = viewBlock.formatString6;
        tileData.reportLink = viewBlock.reportLink;

        return tileData;
    }

    function setTextBoxStyle(targetBox,textBox){
        targetBox.css({
            'background-color': $BDA.theme.currentBackgroundColor?(viewBlock.customColorApplyOtherThemes?$BDA.csharp2rgba(textBox.backgroundColor):$BDA.theme.currentBackgroundColor):$BDA.csharp2rgba(textBox.backgroundColor),
            'color': $BDA.theme.currentBackgroundColor?(viewBlock.customColorApplyOtherThemes?$BDA.csharp2rgba(textBox.color):'#ffffff'):$BDA.csharp2rgba(textBox.color),
            'font-family': textBox.font.fontFamily || 'Arial',
            //'font-size': textBox.font.size,
            'font-weight': textBox.font.bold?'bold':'normal',
            'font-style': textBox.font.italic?'italic':'normal',
            'text-decoration': textBox.font.underline?'underline':(textBox.font.strikeout?'line-through':'none'),
            'text-align':textBox.textAlign == "0"?'left':textBox.textAlign == "1"?'center':textBox.textAlign == "2"?'right':'left',
            'border-radius':textBox.borderRadius.replace(/\,/g,'px ') + 'px',
            "overflow": 'hidden',
            "white-space": 'nowrap',
            "text-overflow": 'ellipsis'
        }).find('span').css({
            'text-decoration': textBox.font.underline?'underline':(textBox.font.strikeout?'line-through':'none')
        });
        if(!viewBlock.autoFontSize){
            targetBox.css({
                'font-size': textBox.font.size/100+"rem"
            });
        }
    }

    this.draw = function(fltHeight,openDrilldown) {

        this.setChartContentHeight(fltHeight);

        var screenHeight = fltHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        screenHeight = screenHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        $(this.chartID).find(".bda-chart-content").css("height",screenHeight/(100*$BDA.defaultRatio)+"rem");
        $(this.chartID).find(".bda-chart-content").css({
            "padding-top": $(this.chartID).find(".bda-chart-content").height()*0.08,
            "padding-right": $(this.chartID).find(".bda-chart-content").width()*0.08,
            "padding-bottom": $(this.chartID).find(".bda-chart-content").height()*0.08,
            "padding-left": $(this.chartID).find(".bda-chart-content").width()*0.08
        }).html('');
        $(this.chartID).find(".bda-chart-content").html(
            '<div class="bda-chart-tile-measure1-name"><span></span></div><div class="bda-chart-tile-measure1">\
                <span class="mainDataObject"></span>\
             </div>\
             <div class="bda-chart-tile-other1">\
                <div class="bda-chart-tile-other-left">\
                    <div class="bda-chart-tile-measure2">\
                        <span class="text"></span>\
                    </div>\
                </div>\
                <div class="bda-chart-tile-other-right">\
                    <div class="bda-chart-tile-measure3">\
                        <span class="text"></span>\
                    </div>\
                </div>\
             </div>\
             <div class="bda-chart-tile-other2">\
                <div class="bda-chart-tile-other-left">\
                    <div class="bda-chart-tile-measure4">\
                        <span class="text"></span>\
                    </div>\
                </div>\
                <div class="bda-chart-tile-other-right">\
                    <div class="bda-chart-tile-measure5">\
                        <span class="text"></span>\
                    </div>\
                </div>\
             </div>\
             <div class="bda-chart-tile-other3">\
                <div class="bda-chart-tile-other-left">\
                    <div class="bda-chart-tile-measure6">\
                        <span class="text"></span>\
                    </div>\
                </div>\
                <div class="bda-chart-tile-other-right">\
                    <div class="bda-chart-tile-measure7">\
                        <span class="text"></span>\
                    </div>\
                </div>\
             </div>'
        );

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        if(viewBlock.reportLink || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0)){
            $(this.chartID).find('.bda-chart-content').hover(function(){
                $(this).css('cursor','pointer');
            });
        }

        function imageName(imageColor,alertImage,arrowDirection,data){
            var imgName,firstName,lastName;

            if(alertImage==1){
                firstName = arrowDirection?(data>=0?'upArrow':'downArrow'):(data>=me.data.mainDataObject?'downArrow':'upArrow');
            }else if(alertImage==2){
                firstName = 'light';
            }
            switch(imageColor){
                case 0:
                    lastName = data>=me.data.mainDataObject?'red':'green';
                    break;
                case 1:
                    lastName = data>=me.data.mainDataObject?'green':'red';
                    break;
                case 2:
                    lastName = data>=0?'red':'green';
                    break;
                case 3:
                    lastName = data>=0?'green':'red';
                    break;
            }
            return imgName = (firstName + '-' + lastName);
        }
        setBoxHeight();

        function judgeLineNuber(){
            var data1 = viewBlock.dataObject1, data2 = viewBlock.dataObject2, data3 = viewBlock.dataObject3;
            var data4 = viewBlock.dataObject4, data5 = viewBlock.dataObject5, data6 = viewBlock.dataObject6;
            var label1 = viewBlock.label1, label2 = viewBlock.label2, label3 = viewBlock.label3;
            var label4 = viewBlock.label4, label5 = viewBlock.label5, label6 = viewBlock.label6;
            var lineNuber = 0;
            var isOtherMeasure1 = false;
            var isOtherMeasure2 = false;
            var isOtherMeasure3 = false;

            if(me.data.dataObject1||me.data.dataObject2||viewBlock.label1||viewBlock.label2){
                isOtherMeasure1 = true;
            }
            if(me.data.dataObject3||me.data.dataObject4||viewBlock.label3||viewBlock.label4){
                isOtherMeasure2 = true;
            }
            if(me.data.dataObject5||me.data.dataObject6||viewBlock.label5||viewBlock.label6){
                isOtherMeasure3 = true;
            }

            if(!data1&&!data2&&!label1&&!label2&&!data3&&!data4&&!label3&&!label4&&!data5&&!data6&&!label5&&!label6){
                lineNuber = 0;
            }
            if((data1||data2||label1||label2)&&!data3&&!data4&&!data5&&!data6&&!label3&&!label4&&!label5&&!label6){
                lineNuber = 1;
            }
            if((data3||data4||label3||label4)&&!data1&&!data2&&!data5&&!data6&&!label1&&!label2&&!label5&&!label6){
                lineNuber = 1;
            }
            if((data5||data6||label5||label6)&&!data1&&!data2&&!data3&&!data4&&!label1&&!label2&&!label3&&!label4){
                lineNuber = 1;
            }
            if((data1||data2||label1||label2)&&(data3||data4||label3||label4)&&!data5&&!data6&&!label5&&!label6){
                lineNuber = 2;
            }
            if((data1||data2||label1||label2)&&(data5||data6||label5||label6)&&!data3&&!data4&&!label3&&!label4){
                lineNuber = 2;
            }
            if((data3||data4||label3||label4)&&(data5||data6||label5||label6)&&!data1&&!data2&&!label1&&!label2){
                lineNuber = 2;
            }
            if((data1||data2||label1||label2)&&(data3||data4||label3||label4)&&(data5||data6||label5||label6)){
                lineNuber = 3;
            }

            me.heightObject.isOtherMeasure1 = isOtherMeasure1;
            me.heightObject.isOtherMeasure2 = isOtherMeasure2;
            me.heightObject.isOtherMeasure3 = isOtherMeasure3;
            return lineNuber;
        }

        function setBoxHeight(){
            var mainLabelHeight = null;
            var mainDataObjectHeight = null;
            var otherMeasureHeight = null;
            var isMainLabel = 0;
            var obj = {};
            var lineNuber = judgeLineNuber();
            var oneLineScale = 0.2;
            var twoLineScale = 0.18;
            var threeLineScale = 0.16;

            if(viewBlock.mainLabel){
                isMainLabel = 1;
            }

            mainLabelHeight = Math.ceil($(me.chartID).find(".bda-chart-content").height()*0.22*isMainLabel);
            otherMeasureHeight = Math.ceil($(me.chartID).find(".bda-chart-content").height()*(lineNuber==0?0:(lineNuber==1?oneLineScale:(lineNuber==2?twoLineScale:threeLineScale))));
            mainDataObjectHeight = $(me.chartID).find(".bda-chart-content").height()-mainLabelHeight-otherMeasureHeight*lineNuber-$(me.chartID).find(".bda-chart-content").height()*0.02;

            me.heightObject.mainLabelHeight = mainLabelHeight;
            me.heightObject.otherMeasureHeight = otherMeasureHeight;
            me.heightObject.mainDataObjectHeight = mainDataObjectHeight;
        }

        var isLeft1 = false, isRight1 = false, isLeft2 = false, isRight2 = false, isLeft3 = false, isRight3 = false;
        //底部第一行
        if (viewBlock.label1 || viewBlock.dataObject1){
            $(this.chartID).find(".bda-chart-tile-measure2 span.text").html((viewBlock.label1||'') + (this.data.dataObject1!=null?$BDA.formatString.number(me.data.formatString1,this.data.dataObject1):''));
            setTextBoxStyle($(this.chartID).find(".bda-chart-tile-measure2"),viewBlock.textBox1);
            if(!viewBlock.dataObject2 && !viewBlock.label2){
                $(this.chartID).find('.bda-chart-tile-other1 .bda-chart-tile-other-left').css('width','100%');
                $(this.chartID).find('.bda-chart-tile-other1 .bda-chart-tile-other-right').css('width',0);
                isLeft1 = true;
            }
            var alertImage1 = viewBlock.alertImage1;
            var imageColor1 = viewBlock.imageColor1;
            var arrowDirection1 = viewBlock.arrowDirection1;
            if (alertImage1){
                var imgName = imageName(imageColor1,alertImage1,arrowDirection1,this.data.dataObject1);
                var insertHtml = "<span class='text-img'></span>";
                $(this.chartID).find(".bda-chart-tile-measure2 span.text").after(insertHtml);
                $(this.chartID).find(".bda-chart-tile-measure2 span.text-img").css({
                    "display": "inline-block",
                    "background-image": "url(../img/"+imgName+".svg)",
                    "background-position": "center center",
                    "background-repeat": "no-repeat",
                    "background-size": "contain"
                });
                //if(imgName.indexOf("light") != -1){
                    $(this.chartID).find(".bda-chart-tile-measure2 span.text").css("margin-right",'4px');
                //}
            }
        }
        if (viewBlock.label2 || viewBlock.dataObject2){
            $(this.chartID).find(".bda-chart-tile-measure3 span.text").html((viewBlock.label2||'') + (this.data.dataObject2!=null?$BDA.formatString.number(me.data.formatString2,this.data.dataObject2):''));
            setTextBoxStyle($(this.chartID).find(".bda-chart-tile-measure3"), viewBlock.textBox2);
            if(!viewBlock.dataObject1 &&! viewBlock.label1){
                $(this.chartID).find('.bda-chart-tile-other1 .bda-chart-tile-other-left').css('width',0);
                $(this.chartID).find('.bda-chart-tile-other1 .bda-chart-tile-other-right').css('width','100%');
                isRight1 = true;
            }
            var alertImage2 = viewBlock.alertImage2;
            var imageColor2 = viewBlock.imageColor2;
            var arrowDirection2 = viewBlock.arrowDirection2;
            if (alertImage2){
                var imgName = imageName(imageColor2,alertImage2,arrowDirection2,this.data.dataObject2);
                var insertHtml = "<span class='text-img'></span>";
                $(this.chartID).find(".bda-chart-tile-measure3 span.text").after(insertHtml);
                $(this.chartID).find(".bda-chart-tile-measure3 span.text-img").css({
                    "display": "inline-block",
                    "background-image": "url(../img/"+imgName+".svg)",
                    "background-position": "center center",
                    "background-repeat": "no-repeat",
                    "background-size": "contain"
                });
                //if(imgName.indexOf("light") != -1){
                    $(this.chartID).find(".bda-chart-tile-measure3 span.text").css("margin-right",'4px');
                //}
            }
        }

        if (viewBlock.label1 || viewBlock.dataObject1 || viewBlock.label2 || viewBlock.dataObject2){
            $(this.chartID).find(".bda-chart-tile-other1").css({
                "display": "block",
                "height": me.heightObject.otherMeasureHeight,
                "line-height": me.heightObject.otherMeasureHeight+"px"
            });
        }

        //底部第二行
        if (viewBlock.label3 || viewBlock.dataObject3){
            $(this.chartID).find(".bda-chart-tile-measure4 span.text").html((viewBlock.label3||'') + (this.data.dataObject3!=null?$BDA.formatString.number(me.data.formatString3,this.data.dataObject3):''));
            setTextBoxStyle($(this.chartID).find(".bda-chart-tile-measure4"),viewBlock.textBox3);
            if(!viewBlock.dataObject4 && !viewBlock.label4){
                $(this.chartID).find('.bda-chart-tile-other2 .bda-chart-tile-other-left').css('width','100%');
                $(this.chartID).find('.bda-chart-tile-other2 .bda-chart-tile-other-right').css('width',0);
                isLeft2 = true;
            }
            var alertImage3 = viewBlock.alertImage3;
            var imageColor3 = viewBlock.imageColor3;
            var arrowDirection3 = viewBlock.arrowDirection3;
            if (alertImage3){
                var imgName = imageName(imageColor3,alertImage3,arrowDirection3,this.data.dataObject3);
                var insertHtml = "<span class='text-img'></span>";
                $(this.chartID).find(".bda-chart-tile-measure4 span.text").after(insertHtml);
                $(this.chartID).find(".bda-chart-tile-measure4 span.text-img").css({
                    "display": "inline-block",
                    "background-image": "url(../img/"+imgName+".svg)",
                    "background-position": "center center",
                    "background-repeat": "no-repeat",
                    "background-size": "contain"
                });
                //if(imgName.indexOf("light") != -1){
                    $(this.chartID).find(".bda-chart-tile-measure4 span.text").css("margin-right",'4px');
                //}
            }
        }
        if (viewBlock.label4 || viewBlock.dataObject4){
            $(this.chartID).find(".bda-chart-tile-measure5 span.text").html(( viewBlock.label4||'') + (this.data.dataObject4!=null?$BDA.formatString.number(me.data.formatString4,this.data.dataObject4):''));
            setTextBoxStyle($(this.chartID).find(".bda-chart-tile-measure5"), viewBlock.textBox4);
            if(!viewBlock.dataObject3 && !viewBlock.label3){
                $(this.chartID).find('.bda-chart-tile-other2 .bda-chart-tile-other-left').css('width',0);
                $(this.chartID).find('.bda-chart-tile-other2 .bda-chart-tile-other-right').css('width','100%');
                isRight2 = true;
            }
            var alertImage4 = viewBlock.alertImage4;
            var imageColor4 = viewBlock.imageColor4;
            var arrowDirection4 = viewBlock.arrowDirection4;
            if (alertImage4){
                var imgName = imageName(imageColor4,alertImage4,arrowDirection4,this.data.dataObject4);
                var insertHtml = "<span class='text-img'></span>";
                $(this.chartID).find(".bda-chart-tile-measure5 span.text").after(insertHtml);
                $(this.chartID).find(".bda-chart-tile-measure5 span.text-img").css({
                    "display": "inline-block",
                    "background-image": "url(../img/"+imgName+".svg)",
                    "background-position": "center center",
                    "background-repeat": "no-repeat",
                    "background-size": "contain"
                });
                //if(imgName.indexOf("light") != -1){
                    $(this.chartID).find(".bda-chart-tile-measure5 span.text").css("margin-right",'4px');
                //}
            }
        }

        if (viewBlock.label3 || viewBlock.dataObject3 || viewBlock.label4 || viewBlock.dataObject4){
            $(this.chartID).find(".bda-chart-tile-other2").css({
                "display": "block",
                "height": me.heightObject.otherMeasureHeight,
                "line-height": me.heightObject.otherMeasureHeight+"px"
            });
        }

        //底部第三行
        if (viewBlock.label5 || viewBlock.dataObject5){
            $(this.chartID).find(".bda-chart-tile-measure6 span.text").html((viewBlock.label5||'') + (this.data.dataObject5!=null?$BDA.formatString.number(me.data.formatString5,this.data.dataObject5):''));
            setTextBoxStyle($(this.chartID).find(".bda-chart-tile-measure6"),viewBlock.textBox5);
            if(!viewBlock.dataObject6 && !viewBlock.label6){
                $(this.chartID).find('.bda-chart-tile-other3 .bda-chart-tile-other-left').css('width','100%');
                $(this.chartID).find('.bda-chart-tile-other3 .bda-chart-tile-other-right').css('width',0);
                isLeft3 = true;
            }
            var alertImage5 = viewBlock.alertImage5;
            var imageColor5 = viewBlock.imageColor5;
            var arrowDirection5 = viewBlock.arrowDirection5;
            if (alertImage5){
                var imgName = imageName(imageColor5,alertImage5,arrowDirection5,this.data.dataObject5);
                var insertHtml = "<span class='text-img'></span>";
                $(this.chartID).find(".bda-chart-tile-measure6 span.text").after(insertHtml);
                $(this.chartID).find(".bda-chart-tile-measure6 span.text-img").css({
                    "display": "inline-block",
                    "background-image": "url(../img/"+imgName+".svg)",
                    "background-position": "center center",
                    "background-repeat": "no-repeat",
                    "background-size": "contain"
                });
                //if(imgName.indexOf("light") != -1){
                    $(this.chartID).find(".bda-chart-tile-measure6 span.text").css("margin-right",'4px');
                //}
            }
        }
        if (viewBlock.label6||viewBlock.dataObject6){
            $(this.chartID).find(".bda-chart-tile-measure7 span.text").html((viewBlock.label6||'') + (this.data.dataObject6!=null?$BDA.formatString.number(me.data.formatString6,this.data.dataObject6):''));
            setTextBoxStyle($(this.chartID).find(".bda-chart-tile-measure7"),viewBlock.textBox6);
            if(!viewBlock.dataObject5 && !viewBlock.label5){
                $(this.chartID).find('.bda-chart-tile-other3 .bda-chart-tile-other-left').css('width',0);
                $(this.chartID).find('.bda-chart-tile-other3 .bda-chart-tile-other-right').css('width','100%');
                isRight3 = true;
            }
            var alertImage6 = viewBlock.alertImage6;
            var imageColor6 = viewBlock.imageColor6;
            var arrowDirection6 = viewBlock.arrowDirection6;
            if (alertImage6){
                var imgName = imageName(imageColor6,alertImage6,arrowDirection6,this.data.dataObject6);
                var insertHtml = "<span class='text-img'></span>";
                $(this.chartID).find(".bda-chart-tile-measure7 span.text").after(insertHtml);
                $(this.chartID).find(".bda-chart-tile-measure7 span.text-img").css({
                    "display": "inline-block",
                    "background-image": "url(../img/"+imgName+".svg)",
                    "background-position": "center center",
                    "background-repeat": "no-repeat",
                    "background-size": "contain"
                });
                //if(imgName.indexOf("light") != -1){
                    $(this.chartID).find(".bda-chart-tile-measure7 span.text").css("margin-right",'4px');
                //}
            }
        }

        if (viewBlock.label5 || viewBlock.dataObject5 || viewBlock.label6 || viewBlock.dataObject6){
            $(this.chartID).find(".bda-chart-tile-other3").css({
                "display": "block",
                "height": me.heightObject.otherMeasureHeight,
                "line-height": me.heightObject.otherMeasureHeight+"px"
            });
        }

        if(viewBlock.mainLabel){
            viewBlock.mainLabel = $.trim(viewBlock.mainLabel);
            if(viewBlock.mainLabel.indexOf("=") != -1 && viewBlock.mainLabel.indexOf("=") == 0){
                var titleArr = viewBlock.mainLabel.split("+");
                $.each(titleArr,function(i){
                    titleArr[i] = $.trim(titleArr[i]);
                    if(titleArr[i].indexOf("[") != -1){
                        titleArr[i] = titleArr[i].replace(/\s*/g,"");
                        var queryName = (titleArr[i].match(/\[(.+?)\]/g))[0];
                        queryName = queryName.substr(1,queryName.length-2);
                        var dimensionName = (titleArr[i].match(/\[(.+?)\]/g))[1];
                        dimensionName = dimensionName.substr(1,dimensionName.length-2);
                        for(var j = 0; j < viewBlock.linkageParameters.length; j++){
                            if(queryName == viewBlock.linkageParameters[j].queryName && dimensionName == viewBlock.linkageParameters[j].dimensionName){
                                titleArr[i] = viewBlock.linkageParameters[j].dimensionValue;
                                break;
                            }
                        }
                        if(titleArr[i].indexOf("[") != -1){ titleArr[i] = "";}    //linkageParameters没有包含当前参数;
                    }else{
                        titleArr[i] = titleArr[i].substr(1,titleArr[i].length-2);
                    }
                });
            }

            $(this.chartID).find(".bda-chart-tile-measure1-name").css({
                'height': me.heightObject.mainLabelHeight,
                "line-height": me.heightObject.mainLabelHeight+"px",
                'background-color': $BDA.theme.currentBackgroundColor?(viewBlock.customColorApplyOtherThemes?$BDA.csharp2rgba(viewBlock.mainTextBox.backgroundColor):$BDA.theme.currentBackgroundColor):$BDA.csharp2rgba(viewBlock.mainTextBox.backgroundColor),
                'color': $BDA.theme.currentBackgroundColor?(viewBlock.customColorApplyOtherThemes?$BDA.csharp2rgba(viewBlock.mainLabelTextBox.color):'#ffffff'):$BDA.csharp2rgba(viewBlock.mainLabelTextBox.color),
                'font-family': viewBlock.mainLabelTextBox.font.fontFamily || 'Arial',
                //'font-size': viewBlock.mainLabelTextBox.font.size,
                'font-weight': viewBlock.mainLabelTextBox.font.bold?'bold':'normal',
                'font-style': viewBlock.mainLabelTextBox.font.italic?'italic':'normal',
                'text-decoration': viewBlock.mainLabelTextBox.font.underline?'underline':(viewBlock.mainLabelTextBox.font.strikeout?'line-through':'none'),
                'text-align':viewBlock.mainLabelTextBox.textAlign == "0"?'left':viewBlock.mainLabelTextBox.textAlign == "1"?'center':viewBlock.mainLabelTextBox.textAlign == "2"?'right':'left',
                'overflow': 'hidden',
                'white-space': 'nowrap',
                'text-overflow': 'ellipsis'
            }).find("span").html((titleArr?titleArr.join(""):viewBlock.mainLabel));
            if(!viewBlock.autoFontSize){
                $(this.chartID).find(".bda-chart-tile-measure1-name").css({
                    'font-size': viewBlock.mainLabelTextBox.font.size/100+"rem"
                });
            }
        }

        //度量一
        if (viewBlock.mainDataObject){
            setTextBoxStyle($(this.chartID).find(".bda-chart-tile-measure1"),viewBlock.mainTextBox);
            $(this.chartID).find(".bda-chart-tile-measure1").css({
                "height": me.heightObject.mainDataObjectHeight,
                "margin-bottom": "2%",
                "color": $BDA.theme.currentBackgroundColor?(viewBlock.customColorApplyOtherThemes?$BDA.csharp2rgba(viewBlock.mainTextBox.color):'#ffffff'):$BDA.csharp2rgba(viewBlock.mainTextBox.color)
            }).find("span.mainDataObject").html($BDA.formatString.number(me.data.mainFormatString,this.data.mainDataObject)+" <span class='main-unit'>"+viewBlock.mainUnit+"</span>");
            $(this.chartID).find("span.main-unit").css({
                'color': $BDA.theme.currentBackgroundColor?(viewBlock.customColorApplyOtherThemes?$BDA.csharp2rgba(viewBlock.mainUnitTextBox.color):'#ffffff'):$BDA.csharp2rgba(viewBlock.mainUnitTextBox.color),
                'font-family': viewBlock.mainUnitTextBox.font.fontFamily || 'Arial',
                'font-size': viewBlock.mainUnitTextBox.font.size/100+"rem",
                'font-weight': viewBlock.mainUnitTextBox.font.bold?'bold':'normal',
                'font-style': viewBlock.mainUnitTextBox.font.italic?'italic':'normal',
                'text-decoration': viewBlock.mainUnitTextBox.font.underline?'underline':(viewBlock.mainUnitTextBox.font.strikeout?'line-through':'none')
            });
            var align = viewBlock.mainTextBox.textAlign;
            if (align== "0"){
                $(this.chartID).find(".bda-chart-tile-measure1 span.mainDataObject").css("left",0);
            }else if (align == "1"){
                $(this.chartID).find(".bda-chart-tile-measure1 span.mainDataObject").css({
                    "left":"50%",
                    "transform": "translate(-50%,-50%)"
                });
            }else if (align == "2"){
                $(this.chartID).find(".bda-chart-tile-measure1 span.mainDataObject").css("right",0);
            }
            if(viewBlock.viewMainTileWarning){
                if(viewBlock.viewMainTileWarning.compareValueType == 0){
                    if(compare(this.data.mainDataObject,viewBlock.viewMainTileWarning.compareConstants[0],viewBlock.viewMainTileWarning.operation)){
                        $(this.chartID).find(".bda-chart-tile-measure1").css({
                            "background-color": $BDA.csharp2rgba(viewBlock.viewMainTileWarning.backgroundColor),
                            "color": $BDA.csharp2rgba(viewBlock.viewMainTileWarning.color)
                        });
                    }
                }
                if(viewBlock.viewMainTileWarning.compareValueType == 1){
                    if(compare(this.data.mainDataObject,viewBlock.blockDataToDraw[0][viewBlock.viewMainTileWarning.compareObject[0]+'___'+viewBlock.viewMainTileWarning.compareObject[1]],viewBlock.viewMainTileWarning.operation)){
                        $(this.chartID).find(".bda-chart-tile-measure1").css({
                            "background-color": $BDA.csharp2rgba(viewBlock.viewMainTileWarning.backgroundColor),
                            "color": $BDA.csharp2rgba(viewBlock.viewMainTileWarning.color)
                        });
                    }
                }
            }
        }

        function compare(mainMeasure,compareValue,operation){
            switch (operation){
                case 0:
                    if(mainMeasure == compareValue){ return true;}
                    break;
                case 1:
                    if(mainMeasure != compareValue){return true;}
                    break;
                case 2:
                    if(mainMeasure > compareValue){return true;}
                    break;
                case 3:
                    if(mainMeasure >= compareValue){return true;}
                    break;
                case 4:
                    if(mainMeasure < compareValue){return true;}
                    break;
                case 5:
                    if(mainMeasure <= compareValue){return true;}
                    break;
            }
        }

        setFontSize();

        if(viewBlock.autoFontSize){
            $(this.chartID).find(".bda-chart-tile-measure1-name").css("font-size",me.heightObject.mainLabelSize/100+"rem");
            $(this.chartID).find(".bda-chart-tile-measure1").css("font-size",me.heightObject.mainDataObjectSize/100+"rem");
            $(this.chartID).find(".bda-chart-tile-other1").css("font-size",me.heightObject.finalSize/100+"rem");
            $(this.chartID).find(".bda-chart-tile-other2").css("font-size",me.heightObject.finalSize/100+"rem");
            $(this.chartID).find(".bda-chart-tile-other3").css("font-size",me.heightObject.finalSize/100+"rem");
        }
        if($(this.chartID).find(".bda-chart-tile-other1").find("span.text-img").length){
            $(this.chartID).find(".bda-chart-tile-other1").find("span.text-img").css({
                "width": $(this.chartID).find(".bda-chart-tile-other1").find("span.text").height()*0.7,
                "height": $(this.chartID).find(".bda-chart-tile-other1").find("span.text").height()*0.7
            });
            //$(this.chartID).find(".bda-chart-tile-other1").find("span.text").css("display","inline-block");
        }
        if($(this.chartID).find(".bda-chart-tile-other2").find("span.text-img").length){
            $(this.chartID).find(".bda-chart-tile-other2").find("span.text-img").css({
                "width": $(this.chartID).find(".bda-chart-tile-other2").find("span.text").height()*0.7,
                "height": $(this.chartID).find(".bda-chart-tile-other2").find("span.text").height()*0.7
            });
            //$(this.chartID).find(".bda-chart-tile-other2").find("span.text").css("display","inline-block");
        }
        if($(this.chartID).find(".bda-chart-tile-other3").find("span.text-img").length){
            $(this.chartID).find(".bda-chart-tile-other3").find("span.text-img").css({
                "width": $(this.chartID).find(".bda-chart-tile-other3").find("span.text").height()*0.7,
                "height": $(this.chartID).find(".bda-chart-tile-other3").find("span.text").height()*0.7
            });
            //$(this.chartID).find(".bda-chart-tile-other3").find("span.text").css("display","inline-block");
        }

        function setFontSize(){
            var mainLabelSize = 0;
            var mainDataObjectSize = 0;
            var otherHeight1Size = 0;
            var otherHeight2Size = 0;
            var otherHeight3Size = 0;
            var contentWidth = $(me.chartID).find(".bda-chart-content").width();
            var leftSize = 0;
            var rightSize = 0;
            var finalSize = 0;

            if(me.heightObject.mainDataObjectHeight){
                mainDataObjectSize = getFontSize(contentWidth,me.heightObject.mainDataObjectHeight,($(me.chartID).find(".bda-chart-tile-measure1 span").text()+viewBlock.mainUnit),mainDataScale);
            }
            if(me.heightObject.mainLabelHeight){
                mainLabelSize = getFontSize(contentWidth,me.heightObject.mainLabelHeight,$(me.chartID).find(".bda-chart-tile-measure1-name span").text(),mainlabelScale);
                mainLabelSize = Math.min(mainLabelSize,mainDataObjectSize*0.7);
            }
            if(me.heightObject.isOtherMeasure1){
                if(isLeft1){
                    otherHeight1Size = getFontSize(contentWidth,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure2 span").text()+(viewBlock.alertImage1?"xxx":""),otherDataScale);
                }else if(isRight1){
                    otherHeight1Size = getFontSize(contentWidth,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure3 span").text()+(viewBlock.alertImage2?"xxx":""),otherDataScale);
                }else if(!isLeft1&&!isRight1){
                    leftSize = getFontSize(contentWidth*0.49,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure2 span").text()+(viewBlock.alertImage1?"xxx":""),otherDataScale);
                    rightSize = getFontSize(contentWidth*0.49,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure3 span").text()+(viewBlock.alertImage2?"xxx":""),otherDataScale);
                    otherHeight1Size = Math.min(leftSize,rightSize);
                }
            }
            if(me.heightObject.isOtherMeasure2){
                if(isLeft2){
                    otherHeight2Size = getFontSize(contentWidth,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure4 span").text()+(viewBlock.alertImage3?"xxx":""),otherDataScale);
                }else if(isRight2){
                    otherHeight2Size = getFontSize(contentWidth,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure5 span").text()+(viewBlock.alertImage4?"xxx":""),otherDataScale);
                }else if(!isLeft2&&!isRight2){
                    leftSize = getFontSize(contentWidth*0.49,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure4 span").text()+(viewBlock.alertImage3?"xxx":""),otherDataScale);
                    rightSize = getFontSize(contentWidth*0.49,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure5 span").text()+(viewBlock.alertImage4?"xxx":""),otherDataScale);
                    otherHeight2Size = Math.min(leftSize,rightSize);
                }
            }
            if(me.heightObject.isOtherMeasure3){
                if(isLeft3){
                    otherHeight3Size = getFontSize(contentWidth,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure6 span").text()+(viewBlock.alertImage5?"xxx":""),otherDataScale);
                }else if(isRight3){
                    otherHeight3Size = getFontSize(contentWidth,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure7 span").text()+(viewBlock.alertImage6?"xxx":""),otherDataScale);
                }else if(!isLeft3&&!isRight3){
                    leftSize = getFontSize(contentWidth*0.49,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure6 span").text()+(viewBlock.alertImage5?"xxx":""),otherDataScale);
                    rightSize = getFontSize(contentWidth*0.49,me.heightObject.otherMeasureHeight,$(me.chartID).find(".bda-chart-tile-measure7 span").text()+(viewBlock.alertImage6?"xxx":""),otherDataScale);
                    otherHeight3Size = Math.min(leftSize,rightSize);
                }
            }
            if(otherHeight1Size&&otherHeight2Size&&otherHeight3Size){
                finalSize = Math.min(otherHeight1Size,otherHeight2Size,otherHeight3Size,mainDataObjectSize*0.5);
            }
            if(otherHeight1Size&&!otherHeight2Size&&!otherHeight3Size){
                finalSize = Math.min(otherHeight1Size,mainDataObjectSize*0.5);
            }
            if(!otherHeight1Size&&otherHeight2Size&&!otherHeight3Size){
                finalSize = Math.min(otherHeight2Size,mainDataObjectSize*0.5);
            }
            if(!otherHeight1Size&&!otherHeight2Size&&otherHeight3Size){
                finalSize = Math.min(otherHeight3Size,mainDataObjectSize*0.5);
            }
            if(otherHeight1Size&&otherHeight2Size&&!otherHeight3Size){
                finalSize = Math.min(otherHeight1Size,otherHeight2Size,mainDataObjectSize*0.5);
            }
            if(otherHeight1Size&&!otherHeight2Size&&otherHeight3Size){
                finalSize = Math.min(otherHeight1Size,otherHeight3Size,mainDataObjectSize*0.5);
            }
            if(!otherHeight1Size&&otherHeight2Size&&otherHeight3Size){
                finalSize = Math.min(otherHeight2Size,otherHeight3Size,mainDataObjectSize*0.5);
            }


            me.heightObject.mainLabelSize = mainLabelSize;
            me.heightObject.mainDataObjectSize = mainDataObjectSize;
            me.heightObject.finalSize = finalSize;
        }

        function getFontSize(maxWidth,maxHeight,str,scale){
            var spanWidth = 0;
            var spanHeight = 0;
            var fontSize = 12;
            $(".test-length span").html(($.trim(str)?str:"null")).css('font-size', '12px');

            do{
                fontSize++;
                $(".test-length span").css('font-size', fontSize + 'px');
                spanWidth = $(".test-length span").width();
                spanHeight = $(".test-length span").height();
            }while ((spanWidth<maxWidth && spanHeight<maxHeight*scale));

            return (fontSize-1);
        }
    };

    this.refreshByLinkage=function(fltHeight){
        this.data = assignTileChartData();
        me.draw(fltHeight);
    };

    this.autoRefresh=function(fltHeight, openDrilldown){
        this.data = assignTileChartData();
        this.draw(fltHeight, openDrilldown);
    }
}

/*类----垂直表*/
function VerticalTable(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = vertivalTableData();
    this.pageSizeNum = 0;
    this.currentPage = 1;
    this.firstLoading = true;
    var timer = null;

    function vertivalTableData(){
        var vertivalTable = {};
        var tableHead = viewBlock.viewTableHead;
        var tableBody = viewBlock.viewTableBody;
        var tableFoot = viewBlock.viewTableFoot;
        var intLength = tableHead.viewTableRows.count;

        vertivalTable.sum = viewBlock.blockDataToDraw?viewBlock.blockDataToDraw.length:0;

        viewBlock.blockDataToDraw = viewBlock.blockDataToDraw || [];

        var tableBodyArry = [],formatArry = [];
        for(var i= 0,len=viewBlock.blockDataToDraw.length;i<len;i++){
            var obj = {},finalObj = {};
            var tempObj = $.extend(true,{},viewBlock.blockDataToDraw[i]);
            for(var j= 0,jen=tableBody.viewTableRows.item(0).viewTableCells.count;j<jen;j++){
                var tableCell = tableBody.viewTableRows.item(0).viewTableCells.item(j);
                finalObj[tableCell.columnIndex] = viewBlock.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]]===null ? '' : viewBlock.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]];

                var value = viewBlock.blockDataToDraw[i][tableCell.cellObject[0]+'___'+tableCell.cellObject[1]];
                if(tableCell.cellObject[3] == 3){
                    if(value.indexOf("http://") != -1 || value.indexOf("https://") != -1){
                        obj[tableCell.columnIndex] = "<img height='"+(parseInt(tableCell.cellTextBox.font.size)*$BDA.defaultRatio)+"' src='"+ value +"'/>";
                    }else {
                        obj[tableCell.columnIndex] = "<img height='" + (parseInt(tableCell.cellTextBox.font.size) * $BDA.defaultRatio) + "' src='/Report/resource/report/custom/img/" + value + "'/>";
                    }
                }else if(tableCell.cellObject[3] == 4){
                    obj[tableCell.columnIndex] = "<img height='"+(parseInt(tableCell.cellTextBox.font.size)*$BDA.defaultRatio)+"' src='data:image/png;base64,"+ value +"'/>";
                }else{
                    if(!tableCell.formatString){
                        if(tableCell.cellObject[3] == 1){
                            obj[tableCell.columnIndex] = (value===null || value==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(value));
                        }else{
                            obj[tableCell.columnIndex] = value===null?"":value;
                        }
                    }else {
                        if(tableCell.cellObject[3] == 1){
                            obj[tableCell.columnIndex] = (value===null || value==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(value)));
                        }else if(tableCell.cellObject[3] == 2){
                            obj[tableCell.columnIndex] = (value===null || value==="")?"":$BDA.formatString.number(tableCell.formatString,value);
                        }else{
                            obj[tableCell.columnIndex] = value===null?"":value;
                        }
                    }
                }
                delete tempObj[tableCell.cellObject[0]+'___'+tableCell.cellObject[1]];
            }
            for(var key in tempObj){
                obj[key] =tempObj[key];
            }
            obj.rowIndex = i;
            finalObj.rowIndex = i;
            tableBodyArry.push(finalObj);
            formatArry.push(obj);
        }

        vertivalTable.original = viewBlock.blockDataToDraw;
        vertivalTable.startBody = tableBodyArry;
        vertivalTable.tableBodyData = formatArry;

        var sortArry = [];
        $.extend(true,sortArry,vertivalTable.tableBodyData);
        vertivalTable.sortArry = sortArry;

        var theadIdentical = [];

        for(var i=0;i<intLength;i++){
            for(var j=0;j<tableHead.viewTableRows.item(i).viewTableCells.count;j++){
                if(!tableHead.viewTableRows.item(i).viewTableCells.item(j).text){
                    theadIdentical.push(tableHead.viewTableRows.item(i).viewTableCells.item(j).columnIndex);
                }
            }
        }

        vertivalTable.tableHead = [];
        vertivalTable.tableHeadStyle = [];
        vertivalTable.tableHeadDivStyle = [];

        for(var i=0;i<intLength;i++){
            var tableHeadData = [];
            var tdStyleArr = [];
            var divStyleArr = [];
            for(var j= 0,jen=tableHead.viewTableRows.item(i).viewTableCells.count;j<jen;j++){
                var tableCell = tableHead.viewTableRows.item(i).viewTableCells.item(j);
                if(tableCell.colspan && tableCell.rowspan){
                    var obj = {};

                    if(tableCell.colspan==1){
                        obj.field = tableCell.columnIndex+'';
                    }

                    if(!tableCell.formatString){
                        if(tableCell.cellObject[3] != 1){
                            obj.title = tableCell.text===null?"":tableCell.text;
                        }else{
                            obj.title = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                        }
                    }else {
                        if(tableCell.cellObject[3] <= 0){
                            obj.title = tableCell.text===null?"":tableCell.text;
                        }else if(tableCell.cellObject[3] == 1){
                            obj.title = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                        }else{
                            obj.title = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.number(tableCell.formatString,tableCell.text);
                        }
                    }

                    obj.colspan = tableCell.colspan;
                    obj.rowspan = tableCell.rowspan;
                    //obj.resizable = false;
                    obj.align = tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right');

                    if((tableCell.autoColumnWidth || (!tableCell.autoColumnWidth && tableCell.columnWidth !=0))&&tableCell.colspan){
                        tdStyleArr.push({
                            "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                            "backgroundColor": $BDA.csharp2rgba(tableCell.cellTextBox.backgroundColor),
                            "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                            "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                            "font-family": tableCell.cellTextBox.font.fontFamily,
                            'font-size': tableCell.cellTextBox.font.size/100+"rem",
                            'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                            'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                            'text-decoration': tableCell.cellTextBox.font.underline?'underline':(tableCell.cellTextBox.font.strikeout?'line-through':'none')
                        });
                        divStyleArr.push({
                            "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                            "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                            "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                            "font-family": tableCell.cellTextBox.font.fontFamily,
                            'font-size': tableCell.cellTextBox.font.size/100+"rem",
                            'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                            'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                            'text-decoration': tableCell.cellTextBox.font.underline?'underline':(tableCell.cellTextBox.font.strikeout?'line-through':'none')
                        })
                    }
                    tableHeadData.push(obj);
                }
            }
            vertivalTable.tableHeadStyle.push(tdStyleArr);
            vertivalTable.tableHeadDivStyle.push(divStyleArr);
            vertivalTable.tableHead.push(tableHeadData);
        }

        /*获取所有含有field的对象*/
        var fieldObjArry = [], fieldList = [];
        for(var i= 0,len=vertivalTable.tableHead.length;i<len;i++){
            for(var j= 0,jen=vertivalTable.tableHead[i].length;j<jen;j++){
                var columnIndex = vertivalTable.tableHead[i][j].field;
                if(columnIndex&&(fieldList.indexOf(columnIndex)==-1)){
                    fieldObjArry.push(vertivalTable.tableHead[i][j]);
                    fieldList.push(columnIndex);
                }
            }
        }

        /*以field的大小来正序*/
        fieldObjArry.sort(function(a,b){
            return parseFloat(a.field)-parseFloat(b.field);
        });

        vertivalTable.fieldObjArry = fieldObjArry;

        var tableBlockFoot = [];

        for(var m=0;m<tableFoot.viewTableRows.count;m++){
            var obj = {};

            for(var n=0;n<tableFoot.viewTableRows.item(m).viewTableCells.count;n++){
                var tableCell = tableFoot.viewTableRows.item(m).viewTableCells.item(n);
                if(!tableCell.formatString){
                    if(tableCell.cellObject[3] != 1){
                        obj[tableCell.columnIndex] = tableCell.text===null?"":tableCell.text;
                    }else{
                        obj[tableCell.columnIndex] = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                    }
                }else {
                    if(tableCell.cellObject[3] <= 0){
                        obj[tableCell.columnIndex] = tableCell.text===null?"":tableCell.text;
                    }else if(tableCell.cellObject[3] == 1){
                        obj[tableCell.columnIndex] = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                    }else{
                        obj[tableCell.columnIndex] = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.number(tableCell.formatString,tableCell.text);
                    }
                }
                obj.rowIndex = vertivalTable.sum + i;
            }
            tableBlockFoot.push(obj);
        }

        for(var i=0;i<tableBlockFoot.length;i++){
            vertivalTable.tableBodyData.push(tableBlockFoot[i]);
        }

        vertivalTable.footerData = tableBlockFoot;

        function getMeasureColumnMaxValue(){
            var bodyTableRows = viewBlock.viewTableBody.viewTableRows.item(0);
            var maxValueArry = [];
            for(var i= 0,len=bodyTableRows.viewTableCells.count;i<len;i++){
                if(bodyTableRows.viewTableCells.item(i).cellObject[2] == 1){
                    var maxValue = 0;
                    for(var j= 0,jen=viewBlock.blockDataToDraw.length;j<jen;j++){
                        if(maxValue < Math.abs(viewBlock.blockDataToDraw[j][bodyTableRows.viewTableCells.item(i).cellObject[0]+'___'+bodyTableRows.viewTableCells.item(i).cellObject[1]])){
                            maxValue = Math.abs(viewBlock.blockDataToDraw[j][bodyTableRows.viewTableCells.item(i).cellObject[0]+'___'+bodyTableRows.viewTableCells.item(i).cellObject[1]]);
                        }
                    }
                    maxValueArry.push(maxValue);
                }
            }

            return maxValueArry;
        }

        vertivalTable.maxValueArray = getMeasureColumnMaxValue();
        vertivalTable.isNotHiddenScroll = false;

        var tableWarnings = [];
        var tempObj = {};
        var isRepeat = false;
        var currentRepeatIndex = null;
        if(viewBlock.viewTableWarnings){
            for(var i = 0; i < viewBlock.viewTableWarnings.length; i++){
                tempObj = {};
                if(tableWarnings.length){
                    isRepeat = false;
                    for(var j = 0; j < tableWarnings.length; j++){
                        if(viewBlock.viewTableWarnings[i].objectName == tableWarnings[j].objectName){
                            isRepeat = true;
                            break;
                        }
                    }
                    if(isRepeat){
                        tableWarnings[j].warnings.push(viewBlock.viewTableWarnings[i]);
                    }else{
                        tempObj.objectName = viewBlock.viewTableWarnings[i].objectName;
                        tempObj.warnings = [];
                        tempObj.warnings.push(viewBlock.viewTableWarnings[i]);
                        tableWarnings.push(tempObj);
                    }
                }else{
                    tempObj.objectName = viewBlock.viewTableWarnings[i].objectName;
                    tempObj.warnings = [];
                    tempObj.warnings.push(viewBlock.viewTableWarnings[i]);
                    tableWarnings.push(tempObj);
                }
            }
            for(var i = 0; i < tableWarnings.length; i++){
                for(var j = 0; j < tableWarnings[i].warnings.length; j++){
                    if(tableWarnings[i].warnings[j].compareValueType){
                        isRepeat = false;
                        currentRepeatIndex = null;
                        for(var k = 0; k < tableBody.viewTableRows.item(0).viewTableCells.count; k++){
                            var tableBodyCell = tableBody.viewTableRows.item(0).viewTableCells.item(k);
                            if((tableWarnings[i].warnings[j].compareObject[0]+"___"+tableWarnings[i].warnings[j].compareObject[1]) == (tableBodyCell.cellObject[0]+"___"+tableBodyCell.cellObject[1])){
                                isRepeat = true;
                                currentRepeatIndex = tableBodyCell.columnIndex;
                                break;
                            }
                        }
                        if(isRepeat){
                            tableWarnings[i].warnings[j].compareObjectField = currentRepeatIndex;
                        }else{
                            tableWarnings[i].warnings[j].compareObjectField = tableWarnings[i].warnings[j].compareObject[0]+"___"+tableWarnings[i].warnings[j].compareObject[1];
                        }
                    }
                }
            }
            vertivalTable.tableWarnings = tableWarnings;
        }

        return vertivalTable;
    }

    this.draw = function(fltHeight,openDrilldown,hierachies){

        var userAgent = window.navigator.userAgent;
        var isWebkit = false;
        if(userAgent.indexOf('Chrome') != -1){
            isWebkit = true;
        }
        
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        var tempStr = "10,10,10,10";
        var paddingArr = viewBlock.padding?viewBlock.padding.split(","):tempStr.split(",");
        $(this.chartID).find('.bda-chart-content').css({
            "padding-top": Number($.trim(paddingArr[0]))/100 + "rem",
            "padding-right": Number($.trim(paddingArr[1]))/100 + "rem",
            "padding-bottom": Number($.trim(paddingArr[2]))/100 + "rem",
            "padding-left": Number($.trim(paddingArr[3]))/100 + "rem"
        });
        this.setChartContentHeight(fltHeight);
        
        var tableHeight = $(this.chartID).find('.bda-chart-content').height();
        var tableWidth = $(this.chartID).find('.bda-chart-content').width();
        var table = document.createElement('table');
        
        var pageSizeNum = setPageSIze();
        var filterPageSortData = {};
        var queue = 0;     /*1正序  -1倒序*/
        var pageLoaded = true;
        
        maxWidth();
        setTableWidth(tableWidth);
        this.pageSizeNum = pageSizeNum;

        $(this.chartID).find('.bda-chart-content').html('');

        $(table).css({
            width: tableWidth,
            height: tableHeight
        });

        $(this.chartID).find(".bda-chart-content").append(table);
        deleteTableCellWidth0();
        if(this.firstLoading){
            setFrozenColumn();
            this.firstLoading = false;

        }
        if(viewBlock.pagingDisplay){
            $(table).datagrid({loadFilter: pagerFilter}).datagrid({
                pagination: viewBlock.pagingDisplay,	//表示在datagrid设置分页
                pageSize: pageSizeNum,
                pageNumber:1,	//第几页显示（默认第一页，可以省略）
                pageList: [pageSizeNum, 20, 30,40,50],
                url: null,
                remoteSort: false,
                frozenColumns: viewBlock.frozenColumnCount?(this.data.frozenColumns?this.data.frozenColumns:[]):[],
                columns: this.data.tableHead,
                scrollbarSize: 20,
                striped: viewBlock.striped,
                singleSelect: true,
                data: this.data.tableBodyData,
                nowrap: !viewBlock.wordWrap,
                onLoadSuccess: function () {
                    var self = this;
                    tableSuccess(self);
                }
            });
            $($(table).datagrid("getPager")).pagination({
                showRefresh: false,
            })
        }else{
            var datagridObj = {
                pageSize: pageSizeNum,
                url: null,
                remoteSort: false,
                frozenColumns: viewBlock.frozenColumnCount?(this.data.frozenColumns?this.data.frozenColumns:[]):[],
                columns: this.data.tableHead,
                scrollbarSize: 20,
                striped: viewBlock.striped,
                singleSelect: true,
                nowrap: !viewBlock.wordWrap,
                //data: this.data.tableBodyData,
                onLoadSuccess: function () {
                    var self = this;
                    tableSuccess(self);
                }
            };

            if(!viewBlock.tBodyScrolling && this.data.tableBodyData.length>100){
                datagridObj.view = scrollview
            }
            $(table).datagrid(datagridObj).datagrid('loadData', this.data.tableBodyData);
        }

        function tableSuccess(self){
            var indexType = viewBlock.tableStyle?viewBlock.tableStyle:0;
            setBorderType(indexType);
            setStyle();

            clickTrBackground();

            /*高度不满一屏 取消滚动条*/
            var tBodyHeight = parseFloat($(me.chartID).find('.datagrid-view .datagrid-btable').height());
            var datagridBodyHeight = parseFloat($(me.chartID).find('.datagrid-view div.datagrid-body').height());

            if(((tBodyHeight<=datagridBodyHeight) && me.data.isNotHiddenScroll)||viewBlock.tBodyScrolling){
                $(me.chartID).find('.datagrid-view div.datagrid-body').css('overflow-y','hidden');
            }

            ///*宽度设置   start*/
            var contentWidth = parseFloat($(me.chartID).find('.bda-chart-content').width());
            var currentTheadWidth = parseFloat($(me.chartID).find('.datagrid-view .datagrid-htable').width());

            if((contentWidth - currentTheadWidth) < 17){
                $(me.chartID).find('.datagrid-view .datagrid-body').css('overflow-x','auto');
            }

            //是否设置合并
            if(viewBlock.autoMergeDimensionCells){
                var tableBodyMergeRows = computeTableMergeRows(viewBlock.viewTableBody);
                mergeTDForBody(self,tableBodyMergeRows);
            }

            mergeTDForFoot(self);


            if(openDrilldown){
                createUnderline();
            }else{
                reportLink();
            }

            var measureIndexArray = addSpanBox();
            setSpanStyle(me.data.maxValueArray, measureIndexArray);

            if(viewBlock.notShowBorderOfDetailTableCell){
                hideCellBorder();
            }

            if(viewBlock.viewTableWarnings){
                setTableWarnings();
            }

            if(viewBlock.tBodyScrolling && (tBodyHeight>datagridBodyHeight)){
                var speed = viewBlock.scrollTimePerLine;
                clearTimeout(timer);
                timer = null;
                timer = setTimeout(function(){
                    tBodyScroll(speed);
                },1000);
            }
            
            pageLoaded = true;
            if (viewBlock.wordWrap && viewBlock.frozenColumnCount){
                resetRowHeight();
            }
        }

        function resetRowHeight(){
            $(me.chartID).find(".datagrid-view1 .datagrid-body .datagrid-btable tr").each(function(i){
                var leftHeight = Number($(this).height());
                var rightHeight = Number($(me.chartID).find(".datagrid-view2 .datagrid-body .datagrid-btable tr").eq(i).height());
                var finalHeight = Math.max(leftHeight,rightHeight)/100 * $BDA.defaultRatio;
                $(this).css("height",finalHeight+"rem");
                $(me.chartID).find(".datagrid-view2 .datagrid-body .datagrid-btable tr").eq(i).css("height", finalHeight + "rem");
            });
        }

        function setPageSIze(){
            var pageSize = 50;
            if(viewBlock.pageRecordCount != -1){
                pageSize = viewBlock.pageRecordCount;
            }else{
                var bodyHeight = tableHeight - me.data.tableHead.length * viewBlock.headHeight;
                bodyHeight = viewBlock.pagingDisplay?(bodyHeight-35):bodyHeight;
                pageSize = viewBlock.bodyHeight?parseInt(bodyHeight/viewBlock.bodyHeight):50;
            }
            return pageSize;
        }

        function pagerFilter(data){
            if (typeof data.length == 'number' && typeof data.splice == 'function') {	// is array
                data = {
                    total: data.length,
                    rows: data
                }
            }
            var dg = $(this);
            var opts = dg.datagrid('options');
            var pager = dg.datagrid('getPager');
            me.currentPage = opts.pageNumber;
            me.pageSizeNum = opts.pageSize;
            pager.pagination({
                onSelectPage: function (pageNum, pageSize) {
                    if(!pageLoaded){ return;}
                    pageLoaded = false;
                    opts.pageNumber = pageNum;
                    opts.pageSize = pageSize;
                    pager.pagination('refresh', {
                        pageNumber: pageNum,
                        pageSize: pageSize
                    });
                    dg.datagrid('loadData', data);
                }
            });
            if (!data.originalRows) {
                data.originalRows = (data.rows);
            }
            var start = (opts.pageNumber - 1) * parseInt(opts.pageSize);
            var end = start + parseInt(opts.pageSize);
            data.rows = (data.originalRows.slice(start, end));
            //$.extend(true,filterPageSortData,data);
            //$(me.chartID).find('.datagrid-view2 .datagrid-header .datagrid-htable tr:last-child td').each(function(){
            //    if($(this).hasClass('datagrid-sort-desc') || $(this).hasClass('datagrid-sort-asc')){
            //        if($(this).hasClass('datagrid-sort-desc')){
            //            queue = -1;
            //        }else if($(this).hasClass('datagrid-sort-asc')){
            //            queue = 1;
            //        }
            //        var isLast = false;
            //        for(var i = data.rows.length-1; i >= 0; i--){
            //            if(data.rows[i].rowIndex >= me.data.sum){
            //                data.rows.splice(i,1);
            //                isLast = true;
            //            }
            //        }
            //
            //        var sortId = $(this).attr('field');
            //
            //        sorter(data.rows,sortId);
            //        if(isLast){
            //            for(var i = 0,len = me.data.footerData.length;i<len;i++){
            //                data.rows.push(me.data.footerData[i]);
            //            }
            //        }
            //        return false;
            //    }
            //});
            return data;
        }

        function  computeTableMergeRows(tableBody){
            var arrMergeRows = [], arrMergeRow=[], mergeRow = {}, lastMergeRow = {}, previousIsMerge = true;
            var currentPageTableRowLength = $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').length;
            var lastTableRowIndex = $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr:last-child').attr("datagrid-row-index");
            if(viewBlock.pagingDisplay){
                if((Number(lastTableRowIndex) + (me.currentPage - 1) * me.pageSizeNum) >= me.data.sum){
                    currentPageTableRowLength = me.data.sum - (me.currentPage - 1) * me.pageSizeNum;
                }
            }else{
                if(Number(lastTableRowIndex) >= me.data.sum){
                    currentPageTableRowLength = currentPageTableRowLength - (Number(lastTableRowIndex) - me.data.sum) - 1;
                }
            }

            for(var i = 0; i<tableBody.viewTableRows.item(0).viewTableCells.count; i++){
                arrMergeRow=[];
                if(tableBody.viewTableRows.item(0).viewTableCells.item(i).cellObject[2] == 0){      //2 is object type, and 0 is diemenssion
                    for(var j = 0; j < currentPageTableRowLength;){
                        mergeRow = {};
                        mergeRow.row = Number($(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(j).attr('datagrid-row-index'));
                        mergeRow.rowspan = 1;
                        mergeRow.col =i;mergeRow.rowDomIndex=j;
                        var cellText = $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(j).find('td').eq(i).find('div').html();
                        if(arrMergeRows.length == 0){
                            for(var k = j + 1; k < currentPageTableRowLength; k++){
                                j = k;
                                if (cellText == $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(k).find('td').eq(i).find('div').html()){
                                     mergeRow.rowspan++;
                                }else { break;}
                            }
                        }else {
                            previousIsMerge = false;
                            for(var m = 0; m < arrMergeRows[arrMergeRows.length - 1].length; m++){
                                lastMergeRow = arrMergeRows[arrMergeRows.length - 1][m];
                                if(j >= lastMergeRow.rowDomIndex && j <= lastMergeRow.rowDomIndex + lastMergeRow.rowspan - 2) {
                                    previousIsMerge = true;
                                    break;
                                }
                            }
                            if(previousIsMerge){
                                for(var k = j + 1; k < currentPageTableRowLength; k++){
                                    j = k;
                                    if ((cellText == $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(k).find('td').eq(i).find('div').html()) &&
                                        (k >= lastMergeRow.rowDomIndex + 1 && k <= lastMergeRow.rowDomIndex + lastMergeRow.rowspan - 1)){
                                            mergeRow.rowspan++;
                                    }else { break;}
                                }
                            }else { j++; }
                        }
                        arrMergeRow.push(mergeRow);
                        if(j == currentPageTableRowLength - 1){ j++; }
                    }
                    arrMergeRows.push(arrMergeRow);
                }
            }

            return arrMergeRows;
        }

        function getLength(str,isHead,i,j){
            if(isHead){
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableHead.viewTableRows.item(j).viewTableCells.item(i).cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableHead.viewTableRows.item(j).viewTableCells.item(i).cellTextBox.font.size/100+"rem"
                });
                return parseInt($('.test-length span').html(str).width() + (10 + 13));   //8,表头单元格内边距，13，表头排序三角符宽度
            }else{
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).cellTextBox.font.size/100+"rem"
                });
                return parseInt($('.test-length span').html(str).width() + 14);
            }
        }

        function maxWidth(){
            var tableHeadStrLength = computeTableHeadTableCellWidth();
            var tableBodyStrLength = computeTableBodyTableCellWidth();
            var tableCellMaxWidthArray = [];
            var maxValue = 0;

            for(var i= 0;i<tableBodyStrLength.length;i++){
                maxValue = Math.max(tableHeadStrLength[i],tableBodyStrLength[i]);
                tableCellMaxWidthArray.push(maxValue);
            }

            me.data.maxTopWidth = tableCellMaxWidthArray;
        }

        function computeTableHeadTableCellWidth(){
            var tableHead = viewBlock.viewTableHead;
            var tableHeadStrLength = [];
            var array = [];
            var tableCell = null;
            for(var i = 0; i < tableHead.viewTableRows.item(0).viewTableCells.count; i++){
                array = [];
                tableCell = tableHead.viewTableRows.item(0).viewTableCells.item(i);
                // if(tableCell.colspan > 1){
                //     array.push(0);
                // }else{
                    if(tableCell.autoColumnWidth){
                        for(var j= 0,jen=tableHead.viewTableRows.count;j<jen;j++){
                            if(tableHead.viewTableRows.item(j).viewTableCells.item(i).colspan > 1){
                                array.push(0);
                            }else{
                                var strLength = tableHead.viewTableRows.item(j).viewTableCells.item(i).text;
                                array.push(getLength(strLength,true,i,j)+1);
                            }
                        }
                    }else{
                        array.push(tableCell.columnWidth * $BDA.tableColumnsWidthRatio);
                    }
                // }

                tableHeadStrLength.push(Math.max.apply(Math,array));
            }
            return tableHeadStrLength;
        }

        function computeTableBodyTableCellWidth(){
            var tableBodyStrLength = [];
            var tableBody = viewBlock.viewTableBody;
            var array = [];
            var tableCell = null;
            var jen = me.data.tableBodyData.length>pageSizeNum?pageSizeNum:me.data.tableBodyData.length;
            for(var i = 0; i < tableBody.viewTableRows.item(0).viewTableCells.count; i++){
                array = [];
                tableCell = tableBody.viewTableRows.item(0).viewTableCells.item(i);
                if(tableCell.autoColumnWidth){
                    for(var j= 0;j<jen;j++){
                        var strLength = me.data.tableBodyData[j][i];
                        array.push(getLength(strLength,false,i)+1);
                    }
                }else{
                    array.push(tableCell.columnWidth * $BDA.tableColumnsWidthRatio);
                }
                tableBodyStrLength.push(Math.max.apply(Math,array));
            }

            return tableBodyStrLength;
        }

        function setTableWidth(tableWidth){
            var headHeight = (viewBlock.headHeight?viewBlock.headHeight:30)*$BDA.defaultRatio;
            var bodyHeight = (viewBlock.bodyHeight?viewBlock.bodyHeight:30)*$BDA.defaultRatio;
            var footHeight = (viewBlock.footHeight?viewBlock.footHeight:30)*$BDA.defaultRatio;
            var currentTableHeight = me.data.tableHead.length * headHeight + me.data.startBody.length * bodyHeight + me.data.footerData.length * footHeight + viewBlock.rowMarginBottom * (me.data.tableHead.length + me.data.startBody.length + me.data.footerData.length);
            var maxSumValue = sumWidth(me.data.maxTopWidth);
            var indexType = viewBlock.tableStyle?viewBlock.tableStyle:0;
            var borderAddedValue = 0;
            var scrollWidth = parseInt(isWebkit?10:17);

            switch (indexType){
                case 0:
                    tableWidth = tableWidth - (me.data.maxTopWidth.length+1)*$BDA.defaultRatio
                    break;
                case 1:
                    if(!viewBlock.tBodyScrolling){
                        borderAddedValue = (me.data.maxTopWidth.length - 2)*$BDA.defaultRatio;
                    }
                    break;
                case 2:
                case 3:
                    if(!viewBlock.tBodyScrolling){
                        borderAddedValue = me.data.maxTopWidth.length;
                    }
                    break;
            }

            if(viewBlock.tBodyScrolling){
                if (tableWidth >= maxSumValue) {
                    setNotExceedingWidth(tableWidth,maxSumValue,0,borderAddedValue);
                } else {
                    setExceedWidth();
                }
            }else{
                if(currentTableHeight<=tableHeight){
                    if (tableWidth >= maxSumValue) {
                        setNotExceedingWidth(tableWidth,maxSumValue,0,borderAddedValue);
                    } else {
                        setExceedWidth();
                    }
                    me.data.isNotHiddenScroll = true;
                }else {
                    if ((tableWidth - maxSumValue) >= scrollWidth) {
                        setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue);
                    } else {
                        setExceedWidth();
                    }
                }
            }
        }

        function sumWidth(arry){
            var sumArry = 0;
            for(var i= 0;i<arry.length;i++){
                sumArry += arry[i];
            }
            return sumArry;
        }

        function setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue){
            var averageWidth = parseInt((tableWidth - maxSumValue - scrollWidth) / me.data.maxTopWidth.length);

            for (var i = 0; i < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++) {
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).autoColumnWidth){
                    me.data.maxTopWidth[i] += averageWidth;
                }
            }

            //var lastTd = tableWidth - sumWidth(me.data.maxTopWidth) - (borderAddedValue?0:1)*$BDA.defaultRatio - scrollWidth + borderAddedValue;
            var lastTd = tableWidth - sumWidth(me.data.maxTopWidth) - scrollWidth + borderAddedValue;

            for(var i = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count - 1; i >= 0; i--){
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).autoColumnWidth){
                    me.data.maxTopWidth[i] += lastTd;
                    break;
                }
            }

            for (var i = 0, len = me.data.fieldObjArry.length; i < len; i++) {
                me.data.fieldObjArry[i].width = me.data.maxTopWidth[i];
            }

            for (var i = 0, len = me.data.tableHead.length; i < len; i++) {
                for (var j = 0, jen = me.data.tableHead[i].length; j < jen; j++) {
                    if (me.data.tableHead[i][j].field) {
                        var field = me.data.tableHead[i][j].field;
                        for (var k = 0, ken = me.data.fieldObjArry.length; k < ken; k++) {
                            if (field == me.data.fieldObjArry[k].field) {
                                me.data.tableHead[i][j].width = me.data.fieldObjArry[k].width;
                            }
                        }
                    }
                }
            }
        }

        function setExceedWidth(){
            for (var i = 0, len = me.data.fieldObjArry.length; i < len; i++) {
                me.data.fieldObjArry[i].width = me.data.maxTopWidth[i];
            }

            for (var i = 0, len = me.data.tableHead.length; i < len; i++) {
                for (var j = 0, jen = me.data.tableHead[i].length; j < jen; j++) {
                    if (me.data.tableHead[i][j].field) {
                        var field = me.data.tableHead[i][j].field;
                        for (var k = 0, ken = me.data.fieldObjArry.length; k < ken; k++) {
                            if (field == me.data.fieldObjArry[k].field) {
                                me.data.tableHead[i][j].width = me.data.fieldObjArry[k].width;
                            }
                        }
                    }
                }
            }
        }

        function deleteTableCellWidth0(){
            for(var i = 0; i < me.data.tableHead.length; i++){
                for(var j = me.data.tableHead[i].length - 1; j >= 0; j--){
                    if(me.data.tableHead[i][j].width == 0){
                        me.data.tableHead[i].splice(j,1);
                    }
                }
            }
        }

        function setFrozenColumn(){
            var indexArr = [];
            var sumIndexArr = [];
            for(var i = 0; i < me.data.tableHead.length; i++){
                sumIndexArr.push(0);
            }
            var frozenColumns = [];
            for(var i = 0; i < me.data.tableHead.length; i++){
                var tempArr = [];
                var tempIndexArr = [];
                for(var j = 0; j < me.data.tableHead[i].length; j++){
                    if(sumIndexArr[i] < viewBlock.frozenColumnCount){
                        if(me.data.tableHead[i][j].colspan > 1){
                            sumIndexArr[i] += me.data.tableHead[i][j].colspan;
                            tempIndexArr.push(j);
                            tempArr.push(me.data.tableHead[i][j]);
                        }else if(me.data.tableHead[i][j].rowspan > 1){
                            for(var k = 0; k < me.data.tableHead[i][j].rowspan; k++){
                                sumIndexArr[k] += 1;
                            }
                            tempIndexArr.push(j);
                            tempArr.push(me.data.tableHead[i][j]);
                        }else{
                            sumIndexArr[i] += 1;
                            tempIndexArr.push(j);
                            tempArr.push(me.data.tableHead[i][j]); 
                        }
                    }
                }
                indexArr.push(tempIndexArr);
                frozenColumns.push(tempArr);
            }
            for(var i = 0; i < indexArr.length; i++){
                for(var j = indexArr[i].length-1; j >= 0; j--){
                    me.data.tableHead[i].splice(indexArr[i][j],1);
                }
            }
            me.data.frozenColumns = frozenColumns;
        }

        if(viewBlock.blockDataToDraw){
            $(me.chartID).find('.datagrid-view2 .datagrid-header .datagrid-htable tr:last-child td div').click(function(){
                if($(this).parents("td").attr('field')){
                    if(!$(this).parents("td").hasClass('datagrid-sort-desc')&&!$(this).parents("td").hasClass('datagrid-sort-asc')){
                        queue = -1;
                        $(me.chartID).find(".datagrid-view .datagrid-sort-desc").removeClass('datagrid-sort-desc');
                        $(me.chartID).find(".datagrid-view .datagrid-sort-asc").removeClass('datagrid-sort-asc');
                        $(this).parents("td").addClass('datagrid-sort-desc');
                    }else if($(this).parents("td").hasClass('datagrid-sort-desc')){
                        queue = 1;
                        $(this).parents("td").removeClass('datagrid-sort-desc').addClass('datagrid-sort-asc').siblings('td').removeClass('datagrid-sort-desc').removeClass('datagrid-sort-asc');
                    }else if($(this).parents("td").hasClass('datagrid-sort-asc')){
                        queue = -1;
                        $(this).parents("td").removeClass('datagrid-sort-asc').addClass('datagrid-sort-desc').siblings('td').removeClass('datagrid-sort-desc').removeClass('datagrid-sort-asc');
                    }
                    var sortBody = [];
                    $.extend(true,sortBody,me.data.sortArry);

                    var sortId = $(this).parents("td").attr('field');

                    sorter(sortBody,sortId);
                    $.extend(true,me.data.sortArry,sortBody);

                    for(var i = 0,len = me.data.footerData.length;i<len;i++){
                        sortBody.push(me.data.footerData[i]);
                    }
                    $.extend(true,me.data.tableBodyData,sortBody);

                    $(table).datagrid('load');
                    $(table).datagrid('loadData',sortBody);
                }
            });
        }

        function sorter(sortBody,sortId){
            if(queue > 0){
                sortBody.sort(arrSortMinToMax);
            }else{
                sortBody.sort(arrSortMaxToMin);
            }
            queue = -queue

            function arrSortMinToMax(a, b) {
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(sortId).cellObject[3] == 2){
                    var currentA = 0 , currentB = 0;
                    currentA = a[sortId] === ''? Number.NEGATIVE_INFINITY : a[sortId];
                    currentB = b[sortId] === ''? Number.NEGATIVE_INFINITY : b[sortId];
                    return $BDA.reverseFormatting(currentA) - $BDA.reverseFormatting(currentB);
                }else if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(sortId).cellObject[3] == 1){
                    a[sortId] = a[sortId] || '';
                    b[sortId] = b[sortId] || '';
                    return new Date(a[sortId] || 0).getTime() - new Date(b[sortId] || 0).getTime();
                }else{
                    // 判断是否为数字开始; 为啥要判断?看上图源数据
                    if (Number($BDA.reverseFormatting(a[sortId])) && Number($BDA.reverseFormatting(b[sortId]))) {
                        // 提取起始数字, 然后比较返回
                        return $BDA.reverseFormatting(a[sortId]) - $BDA.reverseFormatting(b[sortId]);
                        // 如包含中文, 按照中文拼音排序
                    } else if (isChinese(a[sortId]) && isChinese(b[sortId])) {
                        // 按照中文拼音, 比较字符串
                        return a[sortId].localeCompare(b[sortId], 'zh-CN')
                    } else {
                        // 排序数字和字母
                        return a[sortId].localeCompare(b[sortId], 'en');
                    }
                }
            }

            function arrSortMaxToMin(a,b){
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(sortId).cellObject[3] == 2){
                    var currentA = 0 , currentB = 0;
                    currentA = a[sortId] === ''? Number.NEGATIVE_INFINITY : a[sortId];
                    currentB = b[sortId] === ''? Number.NEGATIVE_INFINITY : b[sortId];
                    return $BDA.reverseFormatting(currentB) - $BDA.reverseFormatting(currentA);
                }else if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(sortId).cellObject[3] == 1){
                    a[sortId] = a[sortId] || '';
                    b[sortId] = b[sortId] || '';
                    return new Date(b[sortId] || 0).getTime() - new Date(a[sortId] || 0).getTime();
                }else{
                    // 判断是否为数字开始; 为啥要判断?看上图源数据
                    if (Number($BDA.reverseFormatting(a[sortId])) && Number($BDA.reverseFormatting(b[sortId]))) {
                        // 提取起始数字, 然后比较返回
                        return $BDA.reverseFormatting(b[sortId]) - $BDA.reverseFormatting(a[sortId]);
                        // 如包含中文, 按照中文拼音排序
                    } else if (isChinese(a[sortId]) && isChinese(b[sortId])) {
                        // 按照中文拼音, 比较字符串
                        //return a[sortId].localeCompare(b[sortId], 'zh-CN');
                        return b[sortId].localeCompare(a[sortId], 'zh-CN');
                    } else {
                        // 排序数字和字母
                        return b[sortId].localeCompare(a[sortId], 'en');
                    }
                }

            }
        }
        // 检测是否为中文，true表示是中文，false表示非中文
        function isChinese(str) {
            // 中文万国码正则
            if (/[\u4E00-\u9FCC\u3400-\u4DB5\uFA0E\uFA0F\uFA11\uFA13\uFA14\uFA1F\uFA21\uFA23\uFA24\uFA27-\uFA29]|[\ud840-\ud868][\udc00-\udfff]|\ud869[\udc00-\uded6\udf00-\udfff]|[\ud86a-\ud86c][\udc00-\udfff]|\ud86d[\udc00-\udf34\udf40-\udfff]|\ud86e[\udc00-\udc1d]/.test(str)) {
                return true;
            } else {
                return false;
            }
        }

        if ($BDA.theme.themeID){
            $(this.chartID).find('.datagrid-header-row td').each(function(){
                $(this).css({
                    "background-color":$BDA.theme.currentBackgroundColor,
                    "color":"#fff"
                });
            }).children().each(function(){
                $(this).css({
                    "background-color":$BDA.theme.currentBackgroundColor,
                    "color":"#fff"
                });
            });
        }

        function clickTrBackground(){
            if(!$BDA.theme.themeID && !$(me.chartID).parents().hasClass("drill-page")){
                $(me.chartID).find('.datagrid-view .datagrid-body tr').click(function(){
                    if(!$(this).hasClass("add-background-color")){
                        var rowIndex = $(this).attr("datagrid-row-index");
                        $(me.chartID).find('.datagrid-view .datagrid-body').each(function(){
                            $(this).find("tr").each(function(){
                                if(rowIndex == $(this).attr("datagrid-row-index")){
                                    $(this).addClass("add-background-color").css({
                                        "background-color": "rgba("+int2hex(viewBlock.tableStyleColor,1)+",.2)"
                                    });
                                    $(this).siblings("tr").removeClass("add-background-color").css("background-color","transparent");
                                    $(this).siblings("tr.datagrid-row-alt").css("background-color","rgba("+int2hex(viewBlock.tableStyleColor,2)+",.1)");
                                }
                            });
                        });

                        
                    }
                });
            }
        }

        function mergeTDForBody(self,mergeRows){
            /*表体合并行*/
            for(var i=0,len=mergeRows.length;i<len;i++){
                for(var j= 0,jen=mergeRows[i].length;j<jen;j++){
                    if(mergeRows[i][j].rowspan > 1){
                        $(self).datagrid('mergeCells',{
                            index: mergeRows[i][j].row,
                            field: mergeRows[i][j].col,
                            rowspan: mergeRows[i][j].rowspan,
                            colspan: null
                        });
                    }

                }
            }

            var mergeCells = [];
            var tableCellsField = [];
            for (var i = 0; i < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++){
                var tableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i);
                if (tableCell.dimensionDataKeyToMergeCells && tableCell.cellObject[2] == 1){
                    mergeCells.push(tableCell.dimensionDataKeyToMergeCells);
                    tableCellsField.push(tableCell.columnIndex + "");
                }
            }
            var measureMerge = [];
            for (var i = 0; i < mergeCells.length; i++){
                for (var j = 0; j < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                    var tableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                    if (mergeCells[i] == (tableCell.cellObject[0] + "___" + tableCell.cellObject[1]) && mergeRows.length > tableCell.columnIndex){
                        measureMerge.push(mergeRows[tableCell.columnIndex]);
                    }
                }
            }

            for (var i = 0, len = measureMerge.length; i < len; i++) {
                for (var j = 0, jen = measureMerge[i].length; j < jen; j++) {
                    if (measureMerge[i][j].rowspan > 1) {
                        $(self).datagrid('mergeCells', {
                            index: measureMerge[i][j].row,
                            field: tableCellsField[i],
                            rowspan: measureMerge[i][j].rowspan,
                            colspan: null
                        });
                    }

                }
            }
        }

        function mergeTDForFoot(self){
            /*表尾合并*/
            if(viewBlock.pagingDisplay && (me.currentPage * me.pageSizeNum) >= me.data.sum){
                var currentIndex = null;
                $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                    if((Number($(this).attr("datagrid-row-index")) + (me.currentPage - 1)*me.pageSizeNum) >= me.data.sum){
                        currentIndex = Number($(this).attr("datagrid-row-index"));
                        return false;
                    }
                });
                if(currentIndex != null){
                    for(var i=0;i<viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count;i++){
                        for(var j=0;j<me.data.footerData.length;j++){
                            $(self).datagrid('mergeCells',{
                                index: currentIndex+j,
                                field: viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).columnIndex,
                                colspan: viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(i).colspan,
                                rowspan: viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(i).rowspan
                            });
                        }
                    }
                }
            }else{
                for(var i=0;i<viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count;i++){
                    for(var j=0;j<me.data.footerData.length;j++){
                        $(self).datagrid('mergeCells',{
                            index: me.data.sum+j,
                            field: viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).columnIndex,
                            colspan: viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(i).colspan,
                            rowspan: viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(i).rowspan
                        });
                    }
                }
            }
        }

        function setStyle(){
            if(viewBlock.tableStyleColor && !$BDA.theme.themeID){
                $(me.chartID).find(".datagrid-view td").css({
                    "border-color": "rgba("+int2hex(viewBlock.tableStyleColor,2)+",.3)"
                });
            }

            $(me.chartID).find(".datagrid-wrap").css({
                "height": $(me.chartID).find(".bda-chart-content").height()/($BDA.defaultRatio*100) +"rem"
            }).find(".datagrid-view").css({
                "height": ($(me.chartID).find(".bda-chart-content").height()-(viewBlock.pagingDisplay?35:0))/($BDA.defaultRatio*100) +"rem"
            });

            $(me.chartID).find(".datagrid-view .datagrid-header table.datagrid-htable tr").css({
                "height": viewBlock.headHeight/100+"rem"
            });
            $(me.chartID).find(".datagrid-view .datagrid-body table.datagrid-btable tr").css({
                "height": viewBlock.bodyHeight/100+"rem"
            });
            $(me.chartID).find(".datagrid-view .datagrid-header table.datagrid-htable tr td").css({
                "height": viewBlock.headHeight/100+"rem"
            });
            $(me.chartID).find(".datagrid-view .datagrid-header table.datagrid-htable tr td div").css({
                "height": viewBlock.headHeight>0?'auto':(viewBlock.headHeight/100+"rem")
            });
            $(me.chartID).find(".datagrid-view .datagrid-body table.datagrid-btable tr td").css({
                "height": viewBlock.bodyHeight/100+"rem"
            });
            $(me.chartID).find(".datagrid-view .datagrid-body table.datagrid-btable tr td div").css({
                "height": viewBlock.bodyHeight>0?'auto':(viewBlock.bodyHeight/100+"rem")
            });
            if(viewBlock.rowMarginBottom){
                $(me.chartID).find("tr").css({
                    "height": "auto",
                    "display": "block",
                    "margin-bottom": viewBlock.rowMarginBottom
                });
                $(me.chartID).find(".datagrid-header").css("margin-bottom",viewBlock.rowMarginBottom);
                $(me.chartID).find("tr td:first-child").css("border-radius","0.03rem 0 0 0.03rem");
                $(me.chartID).find("tr td:last-child").css("border-radius","0 0.03rem 0.03rem 0");
            }
            /*表头行高*/
            if(viewBlock.wordWrap){
                $(me.chartID).find(".datagrid-header table.datagrid-htable td").css({
                    'padding': '0.05rem 0'
                }).find("span").css({
                    'white-space': 'normal',
                    'word-break': 'break-all'
                });
            }
            $(me.chartID).find("table.datagrid-htable").css({
                "height": viewBlock.headHeight/100*viewBlock.viewTableHead.viewTableRows.count+"rem"
            });

            $(me.chartID).find(".datagrid-header").css({
                "height":  viewBlock.headHeight/100*viewBlock.viewTableHead.viewTableRows.count+"rem"
            });
            
            if(viewBlock.bodyHeight == 0 && viewBlock.footHeight == 0 || viewBlock.bodyHeight == 0 && viewBlock.viewTableFoot.viewTableRows.count == 0){
                $(me.chartID).find(".datagrid-body").css({
                    "height": 0
                });
            }else{
                $(me.chartID).find(".datagrid-body").css({
                    "height": ($(me.chartID).find(".bda-chart-content").height()-(viewBlock.pagingDisplay?35:0))/($BDA.defaultRatio*100) - viewBlock.headHeight/100*viewBlock.viewTableHead.viewTableRows.count +"rem"
                });
            }

            if(viewBlock.headHeight == 0 && viewBlock.bodyHeight == 0 && viewBlock.footHeight == 0){
                $(me.chartID).find(".datagrid-pager").css("display","none");
            }

            if(viewBlock.frozenColumnCount){
                $(me.chartID).find('.datagrid-view1 .datagrid-header-row').each(function(i){
                    $(this).find('td').each(function(j){
                        $(this).css(me.data.tableHeadStyle[i][j]).find("div").css(me.data.tableHeadDivStyle[i][j]);
                        
                        if($(this).find("a").length){
                            $(this).find("div").css({
                                'text-decoration': 'underline'
                            }).find("a").css({
                                'color': $BDA.csharp2rgba(me.data.tableHeadStyle[i][j].color)
                            })
                        }
                    });
                });
                $(me.chartID).find('.datagrid-view2 .datagrid-header-row').each(function(i){
                    $(this).find('td').each(function(j){
                        $(this).css(me.data.tableHeadStyle[i][j+viewBlock.frozenColumnCount]).find("div").css(me.data.tableHeadDivStyle[i][j+viewBlock.frozenColumnCount]);
                        
                        if($(this).find("a").length){
                            $(this).find("div").css({
                                'text-decoration': 'underline'
                            }).find("a").css({
                                'color': $BDA.csharp2rgba(me.data.tableHeadStyle[i][j+viewBlock.frozenColumnCount].color)
                            })
                        }
                    });
                });
            }else{
                $(me.chartID).find('.datagrid-header-row').each(function(i){
                    $(this).find('td').each(function(j){
                        $(this).css(me.data.tableHeadStyle[i][j]).find("div").css(me.data.tableHeadDivStyle[i][j]);
                        
                        if($(this).find("a").length){
                            $(this).find("div").css({
                                'text-decoration': 'underline'
                            }).find("a").css({
                                'color': $BDA.csharp2rgba(me.data.tableHeadStyle[i][j].color)
                            })
                        }
                    });
                });
                // $(me.chartID).find('.datagrid-header-row td').each(function(i){
                //     $(this).css(me.data.tableHeadStyle[i]).find("div").css(me.data.tableHeadDivStyle[i]);
                // });
            }

            /*表体样式设置*/
            $(me.chartID).find('tr.datagrid-row td').each(function(){
                var tdField = parseFloat($(this).attr('field'));
                var rowspan = parseFloat($(this).attr('rowspan'));
                var tBodyCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(tdField);

                if(rowspan>1 && tBodyCell.cellTextBox.backgroundColor == ''){
                    $(this).css('background-color',$BDA.theme.currentBackgroundColor||'#ffffff');
                }else{
                    $(this).css('background-color',$BDA.csharp2rgba(tBodyCell.cellTextBox.backgroundColor));
                }

                $(this).css({
                    'color': $BDA.csharp2rgba(tBodyCell.cellTextBox.color),
                    'font-family': tBodyCell.cellTextBox.font.fontFamily,
                    'font-style': tBodyCell.cellTextBox.font.italic?'italic':'normal',
                    'font-weight': tBodyCell.cellTextBox.font.bold?'bold':'normal'
                }).find('div').css({
                    'font-size': tBodyCell.cellTextBox.font.size/100+"rem",
                    verticalAlign: tBodyCell.cellTextBox.verticalAlign=='0'?'top':(tBodyCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                    textAlign: tBodyCell.cellTextBox.textAlign=='0'?'left':(tBodyCell.cellTextBox.textAlign=='1'?'center':'right'),
                    'text-decoration': tBodyCell.cellTextBox.font.underline?'underline':
                        (tBodyCell.cellTextBox.font.strikeout?'line-through':'none')
                });

                if($(this).find("a").length){
                    $(this).find("div").css({
                        'text-decoration': 'underline'
                    }).find("a").css({
                        'color': $BDA.csharp2rgba(tBodyCell.cellTextBox.color)
                    })
                }

                if(viewBlock.wordWrap){
                    $(this).css({
                        'padding': '0.05rem 0'
                    }).find("div").css({
                        'white-space': 'normal',
                        'word-break': 'break-all'
                    });
                }

                if ($BDA.theme.themeID){
                    $(this).css({
                        "color":"#b4b4b4"
                        //'background-color':$BDA.theme.currentBackgroundColor
                    });
                }
            });

            /*表尾样式设置*/
            if(viewBlock.pagingDisplay && (me.currentPage * me.pageSizeNum) >= me.data.sum){
                $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                    if((Number($(this).attr("datagrid-row-index")) + (me.currentPage - 1)*me.pageSizeNum) >= me.data.sum){
                        var j = (Number($(this).attr("datagrid-row-index")) + (me.currentPage - 1)*me.pageSizeNum) - me.data.sum;
                        $(this).css("height",viewBlock.footHeight/100+"rem");
                        $(this).find("td").each(function(){
                            var k = Number($(this).attr("field"));
                            var tFootCell = viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(k);
                            $(this).css({
                                'height': viewBlock.footHeight/100+"rem",
                                'background-color': $BDA.theme.themeID?"rgba(254,254,254,.1)": ($BDA.csharp2rgba(tFootCell.cellTextBox.backgroundColor)),
                                'font-family': tFootCell.cellTextBox.font.fontFamily,
                                'font-size': tFootCell.cellTextBox.font.size/100+"rem",
                                'font-style': tFootCell.cellTextBox.font.italic?'italic':'normal',
                                'font-weight': tFootCell.cellTextBox.font.bold?'bold':'normal',
                                color: $BDA.theme.themeID?"#b4b4b4": ($BDA.csharp2rgba(tFootCell.cellTextBox.color))
                            }).find('div').css({
                                'height': viewBlock.footHeight>0?'auto':(viewBlock.footHeight/100+"rem"),
                                'textAlign': tFootCell.cellTextBox.textAlign=='0'?'left':(tFootCell.cellTextBox.textAlign=='1'?'center':'right'),
                                'verticalAlign': tFootCell.cellTextBox.verticalAlign=='0'?'top':(tFootCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                                'text-decoration': tFootCell.cellTextBox.font.underline?'underline':
                                    (tFootCell.cellTextBox.font.strikeout?'line-through':'none')
                            });
                            
                            if($(this).find("a").length){
                                $(this).find("div").css({
                                    'text-decoration': 'underline'
                                })
                            }
                            if ($BDA.theme.themeID){
                                $(this).css({
                                    "color":"#b4b4b4"
                                    //'background-color':$BDA.theme.currentBackgroundColor
                                });
                            }
                        });
                    }
                });
            }else{
                var j=0;
                for(var i=me.data.sum;i<me.data.tableBodyData.length;i++){
                    $(me.chartID).find('tr[datagrid-row-index='+i+']').css("height",viewBlock.footHeight/100+"rem");
                    $(me.chartID).find('tr[datagrid-row-index='+i+']').find('td').each(function(k){
                        var tFootCell = viewBlock.viewTableFoot.viewTableRows.item(j).viewTableCells.item(k);
                        $(this).css({
                            'height': viewBlock.footHeight/100+"rem",
                            'background-color': $BDA.theme.themeID?"rgba(254,254,254,.1)": ($BDA.csharp2rgba(tFootCell.cellTextBox.backgroundColor)),
                            'font-family': tFootCell.cellTextBox.font.fontFamily,
                            'font-size': tFootCell.cellTextBox.font.size/100+"rem",
                            'font-style': tFootCell.cellTextBox.font.italic?'italic':'normal',
                            'font-weight': tFootCell.cellTextBox.font.bold?'bold':'normal',
                            color: $BDA.theme.themeID?"#b4b4b4": ($BDA.csharp2rgba(tFootCell.cellTextBox.color))
                        }).find('div').css({
                            'height': viewBlock.footHeight>0?'auto':(viewBlock.footHeight/100+"rem"),
                            'textAlign': tFootCell.cellTextBox.textAlign=='0'?'left':(tFootCell.cellTextBox.textAlign=='1'?'center':'right'),
                            'verticalAlign': tFootCell.cellTextBox.verticalAlign=='0'?'top':(tFootCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                            'text-decoration': tFootCell.cellTextBox.font.underline?'underline':
                                (tFootCell.cellTextBox.font.strikeout?'line-through':'none')
                        });
                        
                        if($(this).find("a").length){
                            $(this).find("div").css({
                                'text-decoration': 'underline'
                            })
                        }
                        if ($BDA.theme.themeID){
                            $(this).css({
                                "color":"#b4b4b4"
                                //'background-color':$BDA.theme.currentBackgroundColor
                            });
                        }
                    });
                    j++;
                }
            }
        
        }

        function setBorderType(type){
            switch (type){
                case 0:
                    if(viewBlock.tableStyleColor && !$BDA.theme.themeID){
                        $(me.chartID).find("tr.datagrid-row-alt").css({
                            "background-color": "rgba("+int2hex(viewBlock.tableStyleColor,2)+",.1)"
                        });
                    }
                    break;
                case 1:
                    $(me.chartID).find("tr.datagrid-header-row").each(function(){
                        var me = this;
                        $(this).find("td").each(function(i){
                            if(i!=($(me).find("td").length-1)){
                                $(this).css({
                                    "border-right": 0
                                });
                            }
                        })
                    });
                    $(me.chartID).find("tr.datagrid-row").each(function(){
                        var me = this;
                        $(this).find("td").each(function(i){
                            if(i!=($(me).find("td").length-1)){
                                $(this).css({
                                    "border-right": 0
                                });
                            }
                        })
                    });
                    if(viewBlock.tableStyleColor && !$BDA.theme.themeID){
                        $(me.chartID).find("tr.datagrid-row-alt").css({
                            "background-color": "rgba("+int2hex(viewBlock.tableStyleColor,2)+",.1)"
                        });
                    }
                    break;
                case 2:
                    $(me.chartID).find(".datagrid-view .datagrid-header-inner").each(function(){
                        var self = this;
                        $(this).find("tr.datagrid-header-row").each(function(i){
                            if(i!=($(self).find("tr.datagrid-header-row").length-1)){
                                $(this).find("td").css({
                                    "border-bottom": 0
                                });
                            }
                            $(this).find("td").css({
                                "border-left": 0,
                                "border-right": 0
                            });
                        });
                    });
                    $(me.chartID).find(".datagrid-view .datagrid-body").each(function(){
                        var self = this;
                        $(this).find("tr.datagrid-row").each(function(i){
                            if(i!=($(self).find("tr.datagrid-row").length-1)){
                                $(this).find("td").css({
                                    "border-bottom": 0
                                });
                            }
                            $(this).find("td").css({
                                "border-left": 0,
                                "border-right": 0
                            });
                        });
                    });
                    break;
                case 3:
                    $(me.chartID).find(".datagrid-view .datagrid-header-inner").each(function(){
                        var self = this;
                        $(this).find("tr.datagrid-header-row").each(function(i){
                            $(this).find("td").css({
                                "border-left": 0,
                                "border-right": 0,
                                "border-top": 0
                            });
                            if(i!=($(self).find("tr.datagrid-header-row").length-1)){
                                $(this).find("td").css({
                                    "border-bottom": 0
                                });
                            }
                        });
                    });

                    $(me.chartID).find("tr.datagrid-row").each(function(i){
                        $(this).find("td").css({
                            "border-left": 0,
                            "border-right": 0,
                            "border-bottom": 0
                        });
                    });
                    break;
            }
        }

        function createUnderline(){
            var tBodyRow = viewBlock.viewTableBody.viewTableRows.item(0);
            for(var i= 0,len=tBodyRow.viewTableCells.count;i<len;i++){
                if(!parseFloat(tBodyRow.viewTableCells.item(i).cellObject[2])){
                    for(var j= 0,jen=hierachies.length;j<jen;j++){
                        for(var k= 0,ken=hierachies[j].hierarchyDimensions.length;k<ken;k++){
                            if((hierachies[j].hierarchyDimensions[k][0]+"___"+hierachies[j].hierarchyDimensions[k][1])==(tBodyRow.viewTableCells.item(i).cellObject[0]+"___"+tBodyRow.viewTableCells.item(i).cellObject[1]) && tBodyRow.viewTableCells.item(i).cellObject[0] !='merge'){
                                $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                                    if(viewBlock.pagingDisplay){
                                        if((Number($(this).attr("datagrid-row-index")) + (me.currentPage - 1)*me.pageSizeNum) < me.data.sum){
                                            $(this).find('td').each(function(){
                                                if(parseFloat($(this).attr('field'))==tBodyRow.viewTableCells.item(i).columnIndex && k < ken-1){
                                                    $(this).addClass('table-open-drilldown').find('div').css('text-decoration','underline');
                                                    $(this).find('div').hover(function(){
                                                        $(this).css('cursor','pointer');
                                                    },function(){
                                                        $(this).css('cursor','default');
                                                    });
                                                }
                                            });
                                        }
                                    }else{
                                        if($(this).attr("datagrid-row-index") < me.data.sum){
                                            $(this).find('td').each(function(){
                                                if(parseFloat($(this).attr('field'))==tBodyRow.viewTableCells.item(i).columnIndex && k < ken-1){
                                                    $(this).addClass('table-open-drilldown').find('div').css('text-decoration','underline');
                                                    $(this).find('div').hover(function(){
                                                        $(this).css('cursor','pointer');
                                                    },function(){
                                                        $(this).css('cursor','default');
                                                    });
                                                }
                                            });
                                        }
                                    }
                                });
                            }
                        }
                    }
                }else{
                    $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                        if(viewBlock.pagingDisplay){
                            if((Number($(this).attr("datagrid-row-index")) + (me.currentPage - 1)*me.pageSizeNum) < me.data.sum){
                                $(this).find('td').each(function(){
                                    if(parseFloat($(this).attr('field'))==tBodyRow.viewTableCells.item(i).columnIndex){
                                        $(this).addClass('table-open-drilldown').find('div').css('text-decoration','underline');
                                        $(this).find('div').hover(function(){
                                            $(this).css('cursor','pointer');
                                        },function(){
                                            $(this).css('cursor','default');
                                        });
                                    }
                                });
                            }
                        }else{
                            if($(this).attr("datagrid-row-index") < me.data.sum){
                                $(this).find('td').each(function(){
                                    if(parseFloat($(this).attr('field'))==tBodyRow.viewTableCells.item(i).columnIndex){
                                        $(this).addClass('table-open-drilldown').find('div').css('text-decoration','underline');
                                        $(this).find('div').hover(function(){
                                            $(this).css('cursor','pointer');
                                        },function(){
                                            $(this).css('cursor','default');
                                        });
                                    }
                                });
                            }
                        }
                    });
                }
            }
        }

        function reportLink(){
            var tableHead = viewBlock.viewTableHead;
            for(var i = 0; i < tableHead.viewTableRows.count; i++){
                for(var j = 0; j < tableHead.viewTableRows.item(i).viewTableCells.count; j++){
                    var tableCell = tableHead.viewTableRows.item(i).viewTableCells.item(j);
                    if (tableCell.reportLink || (tableCell.reportLinks && tableCell.reportLinks.count > 0)){
                        $(me.chartID).find('.datagrid-view .datagrid-header .datagrid-header-inner tr').eq(i).find("td").each(function(){
                            if($(this).attr("field") == tableCell.columnIndex){
                                $(this).addClass('tableCell-reportLink').css('text-decoration','underline').find('div > span').hover(function(){
                                    $(this).css('cursor','pointer');
                                },function(){
                                    $(this).css('cursor','default');
                                });
                            }
                        })
                    }
                }
            }
            var tableBody = viewBlock.viewTableBody;
            for(var i= 0,len=tableBody.viewTableRows.item(0).viewTableCells.count;i<len;i++){
                var tableBodyCell=tableBody.viewTableRows.item(0).viewTableCells.item(i);
                if (typeof openDrilldown == "undefined" && ((tableBodyCell.reportLink && tableBodyCell.reportLink.reportID) || (tableBodyCell.reportLinks && tableBodyCell.reportLinks.count > 0))){
                    $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                        if(viewBlock.pagingDisplay){
                            if((Number($(this).attr("datagrid-row-index")) + (me.currentPage - 1)*me.pageSizeNum) < me.data.sum){
                                $(this).find('td[field='+i+']').addClass('tableCell-reportLink').css('text-decoration','underline')
                                    .find('div').hover(function(){$(this).css('cursor','pointer');},
                                    function(){$(this).css('cursor','default');});
                            }
                        }else{
                            if($(this).attr("datagrid-row-index") < me.data.sum){
                                $(this).find('td[field='+i+']').addClass('tableCell-reportLink').css('text-decoration','underline')
                                    .find('div').hover(function(){$(this).css('cursor','pointer');},
                                    function(){$(this).css('cursor','default');});
                            }
                        }
                    });
                }
            }
            var tableFoot = viewBlock.viewTableFoot;
            for(var i = 0; i < tableFoot.viewTableRows.count; i++){
                for(var j = 0; j < tableFoot.viewTableRows.item(i).viewTableCells.count; j++){
                    var tableCell = tableFoot.viewTableRows.item(i).viewTableCells.item(j);
                    if(tableCell.reportLink || (tableCell.reportLinks && tableCell.reportLinks.count > 0)){
                        $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                            if(viewBlock.pagingDisplay){
                                if(((Number($(this).attr("datagrid-row-index")) + (me.currentPage - 1)*me.pageSizeNum) - me.data.sum) == i){
                                    $(this).find("td").each(function(){
                                        if($(this).attr("field") == tableCell.columnIndex){
                                            $(this).addClass('tableCell-reportLink').css('text-decoration','underline').find('div').hover(function(){
                                                $(this).css('cursor','pointer');
                                            },function(){
                                                $(this).css('cursor','default');
                                            });
                                        }
                                    });
                                }
                            }else{
                                if((Number($(this).attr("datagrid-row-index")) - me.data.sum) == i){
                                    $(this).find("td").each(function(){
                                        if($(this).attr("field") == tableCell.columnIndex){
                                            $(this).addClass('tableCell-reportLink').css('text-decoration','underline').find('div').hover(function(){
                                                $(this).css('cursor','pointer');
                                            },function(){
                                                $(this).css('cursor','default');
                                            });
                                        }
                                    });
                                }
                            }
                        });
                    }
                }
            }

        }

        function addSpanBox(){
            var bodyTable = viewBlock.viewTableBody;
            var measureIndexArray = [];
            var a = bodyTable.viewTableRows.item(0).viewTableCells.count;
            for(var i= 0,len=bodyTable.viewTableRows.item(0).viewTableCells.count;i<len;i++){
                if(bodyTable.viewTableRows.item(0).viewTableCells.item(i).cellObject[2] == 1){
                    measureIndexArray.push(bodyTable.viewTableRows.item(0).viewTableCells.item(i).columnIndex);
                }
            }

            for(var i= 0,len=measureIndexArray.length;i<len;i++){
                $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable td[field='+measureIndexArray[i]+']').append('<span></span>');
            }

            
            $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                var rowIndex = Number($(this).attr("datagrid-row-index"));
                if(viewBlock.pagingDisplay){
                    if((Number(rowIndex) + (me.currentPage - 1) * me.pageSizeNum) >= me.data.sum){
                        $(this).find("span").remove();
                    }
                }else{
                    if(Number(rowIndex) >= me.data.sum){
                        $(this).find("span").remove();
                    }
                }
            });
            /*取消表尾添加的span*/
            // for(var i=me.data.sum;i<me.data.tableBodyData.length;i++){
            //     if(viewBlock.pagingDisplay){
            //         var k = i % pageSizeNum;
            //     }else{

            //         $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr[datagrid-row-index='+i+']').find('span').remove();
            //     }
            // }

            return measureIndexArray;
        }

        function setSpanStyle(maxValueArray, measureIndexArray){
            for(var i= 0,len=measureIndexArray.length;i<len;i++){
                $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').each(function(){
                    var cells = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells;
                    if (cells.item(measureIndexArray[i]).showColumnBarForMeasure){
                        var currentValue = $BDA.reverseFormatting($(this).find('td[field='+measureIndexArray[i]+']').text() || 0);
                        var currentDivHeight = $(this).find('td[field='+measureIndexArray[i]+'] div').height();
                        $(this).find('td[field='+measureIndexArray[i]+'] span').css({
                            'width': (Math.abs(currentValue)/maxValueArray[i]) * cells.item(measureIndexArray[i]).columnBarMaxLength * 100 + '%',
                            'background-color': currentValue>=0 ? $BDA.csharp2rgba(cells.item(measureIndexArray[i]).positiveColumnBarColor) :$BDA.csharp2rgba(cells.item(measureIndexArray[i]).negativeColumnBarColor),
                            'height': currentDivHeight * 0.8/100 + "rem"
                        });
                    }
                });
            }
        }

        function hideCellBorder(){
            var tableBodyCellLength = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count;
            var tableBodyTrLength = $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').length;
            var mergeColumn = [],mergeColumnLast = [];

            for(var i=tableBodyCellLength-1;i>=0;i--){
                for(var j=0;j<tableBodyTrLength;j++){
                    var rowspan = $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').eq(j).find('td').eq(i).attr('rowspan');
                    if(rowspan){
                        var obj = {};

                        obj.field = i;
                        obj.index = j;
                        obj.rowspan = parseFloat(rowspan);
                        mergeColumn.push(obj);
                    }
                }
                if(mergeColumn.length){ break;}
                mergeColumnLast.push(i);
            }

            for(var i= 0,len=mergeColumnLast.length;i<len;i++){
                for(var m= 0,men=mergeColumn.length;m<men;m++){
                    for(var n= mergeColumn[m].index;n<(mergeColumn[m].rowspan+mergeColumn[m].index-1);n++){
                        $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable tr').eq(n).find('td').eq(mergeColumnLast[i]).css('border-bottom',0);
                    }
                }
            }
        }

        function setTableWarnings(){
            var rowIndex = 0;
            if(viewBlock.pagingDisplay){
                rowIndex = me.pageSizeNum * (me.currentPage - 1);
            }
            for(var i = 0; i < me.data.tableWarnings.length; i++){
                for(var j = 0; j < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                    var viewTableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                    if(me.data.tableWarnings[i].objectName == (viewTableCell.cellObject[0]+"___"+viewTableCell.cellObject[1])){
                        $(me.chartID).find(".datagrid-view .datagrid-body").each(function(){
                            $(this).find(".datagrid-btable tr").each(function(){
                                var tdText = $(this).find("td[field="+viewTableCell.columnIndex+"]").text();
                                var warningStyle = getWarningStyle(tdText,me.data.tableWarnings[i].warnings,(rowIndex + Number($(this).attr("datagrid-row-index"))));
                                if(warningStyle.length){
                                    if(warningStyle[warningStyle.length - 1].effectType == 0){
                                        $(this).find("td[field="+viewTableCell.columnIndex+"]").css({
                                            "color": warningStyle[warningStyle.length - 1].color,
                                            "background-color": warningStyle[warningStyle.length - 1].BackgroundColor
                                        });
                                    }else{
                                        $(this).find("td").css({
                                            "color": warningStyle[warningStyle.length - 1].color,
                                            "background-color": warningStyle[warningStyle.length - 1].BackgroundColor
                                        });
                                    }
                                }
                            });
                        });
                        // $(me.chartID).find(".datagrid-view .datagrid-body .datagrid-btable tr").each(function(k){
                        //     var tdText = $(this).find("td[field="+viewTableCell.columnIndex+"]").text();
                        //     var warningStyle = getWarningStyle(tdText,me.data.tableWarnings[i].warnings,(rowIndex + Number($(this).attr("datagrid-row-index"))));
                        //     if(warningStyle.length){
                        //         if(warningStyle[warningStyle.length - 1].effectType == 0){
                        //             $(this).find("td[field="+viewTableCell.columnIndex+"]").css({
                        //                 "color": warningStyle[warningStyle.length - 1].color,
                        //                 "background-color": warningStyle[warningStyle.length - 1].BackgroundColor
                        //             });
                        //         }else{
                        //             $(this).find("td").css({
                        //                 "color": warningStyle[warningStyle.length - 1].color,
                        //                 "background-color": warningStyle[warningStyle.length - 1].BackgroundColor
                        //             });
                        //         }
                        //     }
                        // });
                    }
                }
            }
        }

        function getWarningStyle(compareValue,warnings,rowIndex){
            var styleArr = [];
            for(var i = 0; i < warnings.length; i++){
                if(warnings[i].dataType == 2){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,$BDA.reverseFormatting(compareValue),$BDA.reverseFormatting(me.data.tableBodyData[rowIndex][warnings[i].compareObjectField]),warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,$BDA.reverseFormatting(compareValue),$BDA.reverseFormatting(warnings[i].compareConstants[0]),warnings[i],styleArr);
                    }
                }
                if(warnings[i].dataType == 1){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,new Date(compareValue).getTime(),new Date(me.data.tableBodyData[rowIndex][warnings[i].compareObjectField]).getTime(),warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,new Date(compareValue).getTime(),new Date(Number(warnings[i].compareConstants[0])).getTime(),warnings[i],styleArr);
                    }
                }
                if(warnings[i].dataType == 0){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,compareValue,me.data.tableBodyData[rowIndex][warnings[i].compareObjectField],warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,compareValue,warnings[i].compareConstants[0],warnings[i],styleArr);
                    }
                }
            }
            return styleArr;
        }

        function setCaseStyle(operation,compareValue,warningValue,warnings,styleArr){
            switch(operation){
                case 0:
                    if(compareValue == warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 1:
                    if(compareValue != warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 2:
                    if(compareValue > warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 3:
                    if(compareValue >= warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 4:
                    if(compareValue < warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 5:
                    if(compareValue <= warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 6:
                    if(warnings.compareConstants.indexOf(compareValue+'')!=-1){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 7:
                    if(warnings.compareConstants.indexOf(compareValue+'')==-1){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
            }

        }

        function setWarningStyle(warnings,styleArr){
            var obj = {};
            obj.color = $BDA.csharp2rgba(warnings.color);
            obj.BackgroundColor = $BDA.csharp2rgba(warnings.backgroundColor);
            obj.effectType = warnings.effectType;
            styleArr.push(obj);
            return styleArr;
        }

        function tBodyScroll(speed){
            var speed=speed/30;
            var originalBox = $(me.chartID).find('.datagrid-view .datagrid-body .datagrid-btable');
            var originalBoxHtml = originalBox.html();
            originalBox.html(originalBoxHtml+originalBoxHtml);
            var timeId = null;

            var originalBoxHeight = originalBox.height();
            $(me.chartID).find('.datagrid-view .datagrid-body').css('position','relative');
            originalBox.css('position','absolute');
            var scrollTop = -1;

            function slider(){
                if(originalBox.css('top')==(-parseInt(originalBoxHeight/2)+'px')){
                    originalBox.css('top','0px');
                    scrollTop = -1;
                }
                originalBox.css('top',scrollTop);
                scrollTop--;
            }

            // setInterval()函数的作用是：每隔一段时间，执行该函数里的代码
            clearInterval(timeId);
            timeId = null;
            timeId = setInterval(slider,speed);

            $(me.chartID).find('.datagrid-view .datagrid-body').mouseover(function(){
                // clearInterval()函数的作用是用来清除定时器
                clearInterval(timeId);
                timeId = null;
            });

            $(me.chartID).find('.datagrid-view .datagrid-body').mouseout(function(){
                timeId = setInterval(slider,speed);
            });
        }

        function int2hex(rgbInt,isTrue) {
            var red = (rgbInt >> 16) & 255;
            var green = (rgbInt >> 8) & 255;
            var blue = rgbInt & 255;
            if(isTrue){
                isTrue == 1 ? ((red - 48 >= 0)?(red = red - 48):0):((red + 24 > 255)?255:(red = red + 24));
                isTrue == 1 ? ((green - 48 >= 0)?(green = green - 48):0):((green + 24 > 255)?255:(green = green + 24));
                isTrue == 1 ? ((blue - 48 >= 0)?(blue = blue - 48):0):((blue + 24 > 255)?255:(blue = blue + 24));
            }
            return red+","+green+","+blue;
        }
    };

    this.refreshByLinkage = function(fltHeight){
        this.data = vertivalTableData();
        me.draw(fltHeight);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies){
        this.data = vertivalTableData();
        this.draw(fltHeight, openDrilldown, hierarchies);
    }
}

/*类----水平表*/
function HorizontalTable(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = horizontalTableData();

    function horizontalTableData(){
        var horizontalTable = {};
        var tableHead = viewBlock.viewTableHead;
        var tableBody = viewBlock.viewTableBody;
        var tableFoot = viewBlock.viewTableFoot;

        var leftHead = [];
        for(var i = 0; i < tableHead.viewTableColumns.count; i++){
            var obj = {};
            obj.field = tableHead.viewTableColumns.item(i).columnIndex + "";
            obj.title = "";
            leftHead.push(obj);
        }
        horizontalTable.leftHeadData = leftHead;

        var topHead = [];
        if(viewBlock.blockDataToDraw == null || !viewBlock.blockDataToDraw.length){
            //topHead.push({});
        }else{
            for(var i = leftHead.length; i < viewBlock.blockDataToDraw.length + leftHead.length; i++){
                var obj = {};
                obj.field = i + "";
                obj.title = "";
                topHead.push(obj);
            }
        }
        var footLength = tableFoot.viewTableColumns.count + leftHead.length + topHead.length;
        for(var i = leftHead.length + topHead.length; i < footLength; i++){
            var obj = {};
            obj.field = i + "";
            obj.title = "";
            topHead.push(obj);
        }
        horizontalTable.topHeadData = topHead;

        var tableBodyColumnLength = leftHead.length + topHead.length;
        var tableBodyData = [];
        var tableCell = null;
        var haveTableCellObject = [];
        for(var i = 0; i < tableBody.viewTableColumns.item(0).viewTableCells.count; i++){
            var obj = {};
            haveTableCellObject.push(tableBody.viewTableColumns.item(0).viewTableCells.item(i).cellObject[0]+"___"+tableBody.viewTableColumns.item(0).viewTableCells.item(i).cellObject[1]);
            for(var j = 0; j < tableBodyColumnLength; j++){
                tableCell = null;
                if(j < leftHead.length){
                    tableCell = tableHead.viewTableColumns.item(j).viewTableCells.item(i);
                    if(!tableCell.formatString){
                        if(tableCell.cellObject[3] != 1){
                            obj[j+""] = tableCell.text===null?"":tableCell.text;
                        }else{
                            obj[j+""] = (tableCell.text==null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                        }
                    }else {
                        if(tableCell.cellObject[3] <= 0){
                            obj[j+""] = tableCell.text===null?"":tableCell.text;
                        }else if(tableCell.cellObject[3] == 1){
                            obj[j+""] = (tableCell.text==null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                        }else{
                            obj[j+""] = (tableCell.text==null || tableCell.text==="")?"":$BDA.formatString.number(tableCell.formatString,Number(tableCell.text));
                        }
                    }
                }else if( j < (leftHead.length + viewBlock.blockDataToDraw.length) && viewBlock.blockDataToDraw.length){
                    tableCell = tableBody.viewTableColumns.item(0).viewTableCells.item(i);
                    if(viewBlock.blockDataToDraw == null || !viewBlock.blockDataToDraw.length){
                        obj[j+""] = "";
                    }else{
                        var objectName = tableCell.cellObject[0]+"___"+tableCell.cellObject[1];
                        var tempData = viewBlock.blockDataToDraw[j-leftHead.length][objectName];
                        if(tableCell.cellObject[3] <= 0){
                            obj[j+""] = tempData===null?"":tempData;
                        }else if(tableCell.cellObject[3] == 1){
                            obj[j+""] = tempData&&$BDA.formatString.date(tableCell.formatString,new Date(Number(tempData))=='Invalid Date'?tempData:new Date(Number(tempData)));
                        }else if(tableCell.cellObject[3] == 3){
                            obj[j+""] = tempData?("<img height='" + (parseInt(tableCell.cellTextBox.font.size)) + "' src='/Report/resource/report/custom/img/" + tempData + "'/>"):"";
                        }else{
                            obj[j+""] = (tempData==null || tempData==="")?"":$BDA.formatString.number(tableCell.formatString,Number(tempData));
                        }
                    }
                }else if(j >= (leftHead.length + viewBlock.blockDataToDraw.length)){
                    if(tableFoot.viewTableColumns.count){
                        tableCell = tableFoot.viewTableColumns.item(j - leftHead.length - viewBlock.blockDataToDraw.length).viewTableCells.item(i);
                        if(!tableCell.formatString){
                            if(tableCell.cellObject[3] != 1){
                                obj[j+""] = tableCell.text===null?"":tableCell.text;
                            }else{
                                obj[j+""] = (tableCell.text==null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                            }
                        }else {
                            if(tableCell.cellObject[3] <= 0){
                                obj[j+""] = tableCell.text===null?"":tableCell.text;
                            }else if(tableCell.cellObject[3] == 1){
                                obj[j+""] = (tableCell.text==null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text)));
                            }else{
                                obj[""+j+""] = (tableCell.text==null || tableCell.text==="")?"":$BDA.formatString.number(tableCell.formatString,Number(tableCell.text));
                            }
                        }
                    }
                }
            }

            tableBodyData.push(obj);
        }

        if(viewBlock.blockDataToDraw || viewBlock.blockDataToDraw.length){
            var warningData = $.extend(true,[],tableBodyData);

            var compareObjectName = [];
            for(var key in viewBlock.blockDataToDraw[0]){
                if(haveTableCellObject.indexOf(key) == -1){
                    compareObjectName.push(key);
                }
            }
            for(var i = 0; i < compareObjectName.length; i++){
                var tempObj = {};
                for(var j = 0; j < tableBodyColumnLength; j++){
                    if(j < leftHead.length){
                        tempObj[j+""] = "";
                    }else if(j < (leftHead.length + viewBlock.blockDataToDraw.length)){
                        tempObj[j+""] = viewBlock.blockDataToDraw[j-leftHead.length][compareObjectName[i]];
                    }else{
                        tempObj[j+""] = "";
                    }
                }
                warningData.push(tempObj);
            }
            horizontalTable.warningData = warningData;
        }

        horizontalTable.tableBodyData = tableBodyData;

        var headStyle = [];
        var tempArr = [];
        var mergeHead = [];
        var mergeTempArr = [];
        for(var i = 0; i < tableHead.viewTableColumns.item(0).viewTableCells.count; i++){
            tempArr = [];
            mergeTempArr = [];
            for(var j = 0; j < tableHead.viewTableColumns.count; j++){
                var tableCell = tableHead.viewTableColumns.item(j).viewTableCells.item(i);
                tempArr.push({
                    "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                    "backgroundColor": $BDA.csharp2rgba(tableCell.cellTextBox.backgroundColor),
                    "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                    "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                    "font-family": tableCell.cellTextBox.font.fontFamily,
                    'font-size': tableCell.cellTextBox.font.size/100+"rem",
                    'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                    'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                    'text-decoration': tableCell.cellTextBox.font.underline?'underline':(tableCell.cellTextBox.font.strikeout?'line-through':'none')
                });
                mergeTempArr.push({
                    index: tableCell.rowID,
                    field: j + "",
                    rowspan: tableCell.rowspan,
                    colspan: tableCell.colspan
                });
            }
            headStyle.push(tempArr);
            mergeHead.push(mergeTempArr);
        }
        horizontalTable.tableHeadStyle = headStyle;
        horizontalTable.mergeTableHead = mergeHead;

        var bodyStyle = [];
        for(var i = 0; i < tableBody.viewTableColumns.item(0).viewTableCells.count; i++){
                var tableCell = tableBody.viewTableColumns.item(0).viewTableCells.item(i);
                bodyStyle.push({
                    "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                    "backgroundColor": $BDA.csharp2rgba(tableCell.cellTextBox.backgroundColor),
                    "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                    "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                    "font-family": tableCell.cellTextBox.font.fontFamily,
                    'font-size': tableCell.cellTextBox.font.size/100+"rem",
                    'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                    'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                    'text-decoration': tableCell.cellTextBox.font.underline?'underline':(tableCell.cellTextBox.font.strikeout?'line-through':'none')
                });
            }
        horizontalTable.tableBodyStyle = bodyStyle;

        var footStyle = [];
        var footTempArr = [];
        var mergeFoot = [];
        if(tableFoot.viewTableColumns.count){
            for(var i = 0; i < tableFoot.viewTableColumns.item(0).viewTableCells.count; i++){
                footTempArr = [];
                for(var j = 0; j < tableFoot.viewTableColumns.count; j++){
                    var tableCell = tableFoot.viewTableColumns.item(j).viewTableCells.item(i);
                    footTempArr.push({
                        "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                        "backgroundColor": $BDA.csharp2rgba(tableCell.cellTextBox.backgroundColor),
                        "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                        "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                        "font-family": tableCell.cellTextBox.font.fontFamily,
                        'font-size': tableCell.cellTextBox.font.size/100+"rem",
                        'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                        'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                        'text-decoration': tableCell.cellTextBox.font.underline?'underline':(tableCell.cellTextBox.font.strikeout?'line-through':'none')
                    });
                }
                footStyle.push(footTempArr);
            }

            for(var i = 0; i < tableFoot.viewTableColumns.item(0).viewTableCells.count; i++){
                mergeTempArr = [];
                for(var j = 0; j < tableFoot.viewTableColumns.count; j++){
                    var tableCell = tableFoot.viewTableColumns.item(j).viewTableCells.item(i);
                    mergeTempArr.push({
                        index: tableCell.rowID,
                        field: j + leftHead.length + viewBlock.blockDataToDraw.length + "",
                        rowspan: tableCell.rowspan,
                        colspan: tableCell.colspan
                    });
                }
                mergeFoot.push(mergeTempArr);
            }
        }
        horizontalTable.tableFootStyle = footStyle;
        horizontalTable.mergeTableFoot = mergeFoot;
        horizontalTable.footFieldStart = leftHead.length + viewBlock.blockDataToDraw.length;

        var tableWarnings = [];
        var tempObj = {};
        var isRepeat = false;
        var currentRepeatIndex = 0;
        if(viewBlock.viewTableWarnings && (viewBlock.blockDataToDraw || viewBlock.blockDataToDraw.length)){
            for(var i = 0; i < viewBlock.viewTableWarnings.length; i++){
                tempObj = {};
                if(tableWarnings.length){
                    isRepeat = false;
                    for(var j = 0; j < tableWarnings.length; j++){
                        if(viewBlock.viewTableWarnings[i].objectName == tableWarnings[j].objectName){
                            isRepeat = true;
                            break;
                        }
                    }
                    if(isRepeat){
                        tableWarnings[j].warnings.push(viewBlock.viewTableWarnings[i]);
                    }else{
                        tempObj.objectName = viewBlock.viewTableWarnings[i].objectName;
                        tempObj.warnings = [];
                        tempObj.warnings.push(viewBlock.viewTableWarnings[i]);
                        tableWarnings.push(tempObj);
                    }
                }else{
                    tempObj.objectName = viewBlock.viewTableWarnings[i].objectName;
                    tempObj.warnings = [];
                    tempObj.warnings.push(viewBlock.viewTableWarnings[i]);
                    tableWarnings.push(tempObj);
                }
            }
            for(var i = 0; i < tableWarnings.length; i++){
                for(var j = 0; j < tableWarnings[i].warnings.length; j++){
                    if(tableWarnings[i].warnings[j].compareValueType){
                        isRepeat = false;
                        currentRepeatIndex = null;
                        for(var k = 0; k < tableBody.viewTableColumns.item(0).viewTableCells.count; k++){
                            var tableBodyCell = tableBody.viewTableColumns.item(0).viewTableCells.item(k);
                            if((tableWarnings[i].warnings[j].compareObject[0]+"___"+tableWarnings[i].warnings[j].compareObject[1]) == (tableBodyCell.cellObject[0]+"___"+tableBodyCell.cellObject[1])){
                                isRepeat = true;
                                currentRepeatIndex = tableBodyCell.rowID;
                                break;
                            }
                        }
                        if(isRepeat){
                            tableWarnings[i].warnings[j].compareObjectField = currentRepeatIndex;
                        }else{
                            var columnIndex = 0;
                            for(var key in viewBlock.blockDataToDraw[0]){
                                columnIndex++;
                                if(key == (tableWarnings[i].warnings[j].compareObject[0]+"___"+tableWarnings[i].warnings[j].compareObject[1])){
                                    break;
                                }
                            }
                            tableWarnings[i].warnings[j].compareObjectField = columnIndex - 1;
                        }
                    }
                }
            }
            horizontalTable.tableWarnings = tableWarnings;
        }

        return horizontalTable;
    }

    this.draw = function(fltHeight,openDrilldown,hierachies){

        var userAgent = window.navigator.userAgent;
        var isWebkit = false;
        if(userAgent.indexOf('Chrome') != -1){
            isWebkit = true;
        }
        
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        var tempStr = "10,10,10,10";
        var paddingArr = viewBlock.padding?viewBlock.padding.split(","):tempStr.split(",");
        $(this.chartID).find('.bda-chart-content').css({
            "padding-top": Number($.trim(paddingArr[0]))/100 + "rem",
            "padding-right": Number($.trim(paddingArr[1]))/100 + "rem",
            "padding-bottom": Number($.trim(paddingArr[2]))/100 + "rem",
            "padding-left": Number($.trim(paddingArr[3]))/100 + "rem"
        });

        this.setChartContentHeight(fltHeight);

        var tableHeight = $(this.chartID).find('.bda-chart-content').height();
        var tableWidth = $(this.chartID).find('.bda-chart-content').width();
        var table = document.createElement('table');

        maxWidth();
        setTableWidth(tableWidth,tableHeight);

        deleteTableCellWidth0();

        $(this.chartID).find('.bda-chart-content').html('');

        $(table).css({
            width: tableWidth,
            height: tableHeight
        });

        $(this.chartID).find(".bda-chart-content").append(table);

        $(table).datagrid({
            pageSize: 50,
            url: null,
            remoteSort: false,
            columns: [this.data.topHeadData],
            frozenColumns: [this.data.leftHeadData],
            scrollbarSize: 20,
            striped: false,
            singleSelect: true,
            onLoadSuccess: function () {
                var self = this;

                setStyle();
                if(viewBlock.notShowBorderOfTableCell){
                    $(me.chartID).find("td").css("border",0);
                }
                mergeTDHead(self);
                mergeTDFoot(self);

                if(viewBlock.autoMergeDimensionCells){
                    var tableBodyMergeRows = computeTableMergeRows(viewBlock.viewTableBody);
                    mergeTDForBody(self,tableBodyMergeRows);
                }
                if(openDrilldown){
                    createUnderline();
                }else{
                    reportLink();
                }

                if(viewBlock.viewTableWarnings){
                    setTableWarnings();
                }
            }
        }).datagrid('loadData', this.data.tableBodyData);


        function deleteTableCellWidth0(){
            for(var i = me.data.topHeadData.length - 1; i >= 0; i--){
                if(me.data.topHeadData[i].width == 0){
                    me.data.topHeadData.splice(i,1);
                }
            }
            for(var i = me.data.leftHeadData.length - 1; i >= 0; i--){
                if(me.data.leftHeadData[i].width == 0){
                    me.data.leftHeadData.splice(i,1);
                }
            }
        }

        function computeTableMergeRows(tableBody){
            var arrMergeRows = [], arrMergeRow=[], mergeRow = {}, lastMergeRow = {}, previousIsMerge = true;

            for(var i = 0; i < tableBody.viewTableColumns.item(0).viewTableCells.count; i++){
                arrMergeRow = [];
                if(tableBody.viewTableColumns.item(0).viewTableCells.item(i).cellObject[2] == 0){
                    for(var j = 0; j < viewBlock.blockDataToDraw.length;){
                        mergeRow = {};
                        mergeRow.row = i;
                        mergeRow.colspan = 1;
                        mergeRow.col = me.data.leftHeadData.length + j;
                        var cellText = $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(i).find("td").eq(j).find("div").html();
                        if(arrMergeRows.length == 0){
                            for(var k = j + 1; k < viewBlock.blockDataToDraw.length; k++){
                                j = k;
                                if(cellText == $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(i).find("td").eq(k).find("div").html()){
                                    mergeRow.colspan ++;
                                }else{ break;}
                            }
                        }else{
                            previousIsMerge = false;
                            for(var m = 0; m < arrMergeRows[arrMergeRows.length - 1].length; m++){
                                lastMergeRow = arrMergeRows[arrMergeRows.length - 1][m];
                                if(j + me.data.leftHeadData.length >= lastMergeRow.col && j <= lastMergeRow.col + lastMergeRow.colspan - 2){
                                    previousIsMerge = true;
                                    break;
                                }
                            }
                            if(previousIsMerge){
                                for(var k = j + 1; k < viewBlock.blockDataToDraw.length; k++){
                                    j = k;
                                    if((cellText == $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(i).find('td').eq(k).find('div').html()) &&
                                        (k + me.data.leftHeadData.length >= lastMergeRow.col + 1 && k + me.data.leftHeadData.length <= lastMergeRow.col + lastMergeRow.colspan - 1)){
                                        mergeRow.colspan ++;
                                    }else{ break;}
                                }
                            }else{ j++;}
                        }
                        arrMergeRow.push(mergeRow);
                        if(j == viewBlock.blockDataToDraw.length - 1){ j++;}
                    }
                    arrMergeRows.push(arrMergeRow);
                }
            }

            return arrMergeRows;
        }

        function mergeTDForBody(self,mergeRows){
            /*表体合并行*/
            for(var i=0,len=mergeRows.length;i<len;i++){
                for(var j= 0,jen=mergeRows[i].length;j<jen;j++){
                    if(mergeRows[i][j].colspan > 1){
                        $(self).datagrid('mergeCells',{
                            index: mergeRows[i][j].row,
                            field: mergeRows[i][j].col,
                            rowspan: null,
                            colspan: mergeRows[i][j].colspan
                        });
                    }

                }
            }
        }

        function setStyle(){
            $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').each(function(i){
                $(this).find("td").each(function(j){
                    $(this).css(me.data.tableHeadStyle[i][j]).find("div").css(me.data.tableHeadStyle[i][j]);
                });
            });

            $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').each(function(i){
                $(this).find("td").css(me.data.tableBodyStyle[i]).find("div").css({
                    "font-size": me.data.tableBodyStyle[i]["font-size"]
                });
            });

            $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').each(function(i){
                var tempIndex = 0;
                $(this).find("td").each(function(j){
                    if(Number($(this).attr("field")) >= me.data.footFieldStart){
                        $(this).css(me.data.tableFootStyle[i][tempIndex]).find("div").css(me.data.tableFootStyle[i][tempIndex]);
                        tempIndex++;
                    }
                });
            });
            $(me.chartID).find('tr').each(function(i){
                $(this).css("height",viewBlock.cellHeight/100+"rem");
            });
        }

        function getLength(str,tableBoxType,i,j){
            if(tableBoxType == 0){
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableHead.viewTableColumns.item(i).viewTableCells.item(j).cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableHead.viewTableColumns.item(i).viewTableCells.item(j).cellTextBox.font.size/100+"rem"
                });
                return parseFloat($('.test-length span').html(str || "null").width() + 8);   //8,表头单元格内边距，13，表头排序三角符宽度
            }else if(tableBoxType == 1){
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableBody.viewTableColumns.item(0).viewTableCells.item(j).cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableBody.viewTableColumns.item(0).viewTableCells.item(j).cellTextBox.font.size/100+"rem"
                });
                return parseFloat($('.test-length span').html(str || "null").width() + 8);
            }else{
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableFoot.viewTableColumns.item(i).viewTableCells.item(j).cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableFoot.viewTableColumns.item(i).viewTableCells.item(j).cellTextBox.font.size/100+"rem"
                });
                return parseFloat($('.test-length span').html(str || "null").width() + 8);
            }
        }

        function maxWidth(){
            var tableHeadWidth = computeTableHeadTableCellWidth();
            var tableBodyWidth = computeTableBodyTableCellWidth();
            var tableFootWidth = computeTableFootTableCellWidth();
            var tableWidthArr = tableHeadWidth.concat(tableBodyWidth.concat(tableFootWidth));

            me.data.tableCellWidth = tableWidthArr;
        }

        function computeTableHeadTableCellWidth(){
            var tableColumns = viewBlock.viewTableHead.viewTableColumns;
            var headWidthArr = [];
            var tempArr = [];
            for(var i = 0; i < tableColumns.count; i++){
                if(tableColumns.item(i).viewTableCells.item(0).autoColumnWidth){
                    tempArr = [];
                    for(var j = 0; j < tableColumns.item(i).viewTableCells.count; j++){
                        tempArr.push(getLength(tableColumns.item(i).viewTableCells.item(j).text,0,i,j));
                    }
                    headWidthArr.push(Math.max.apply(Math,tempArr));
                }else{
                    headWidthArr.push(tableColumns.item(i).viewTableCells.item(0).columnWidth * $BDA.tableColumnsWidthRatio);
                }
            }

            return headWidthArr;
        }

        function computeTableBodyTableCellWidth(){
            var tableColumn = viewBlock.viewTableBody.viewTableColumns.item(0);
            var bodyWidthArr = [];
            var tempArr = [];
            for(var i = me.data.leftHeadData.length; i < me.data.leftHeadData.length + viewBlock.blockDataToDraw.length; i++){
                if(tableColumn.viewTableCells.item(0).autoColumnWidth){
                    tempArr = [];
                    for(var j = 0; j < tableColumn.viewTableCells.count; j++){
                        tempArr.push(getLength(me.data.tableBodyData[j][i+""],1,0,j));
                    }
                    bodyWidthArr.push(Math.max.apply(Math,tempArr));
                }else{
                    bodyWidthArr.push(tableColumn.viewTableCells.item(0).columnWidth * $BDA.tableColumnsWidthRatio);
                }
            }
            //if(!bodyWidthArr.length){
            //    bodyWidthArr.push(getLength("null",0,0,0))
            //}

            return bodyWidthArr;
        }

        function computeTableFootTableCellWidth(){
            var tableColumns = viewBlock.viewTableFoot.viewTableColumns;
            var footWidthArr = [];
            var tempArr = [];
            for(var i = 0; i < tableColumns.count; i++){
                if(tableColumns.item(i).viewTableCells.item(0).autoColumnWidth){
                    tempArr = [];
                    for(var j = 0; j < tableColumns.item(i).viewTableCells.count; j++){
                        tempArr.push(getLength(tableColumns.item(i).viewTableCells.item(j).text,2,i,j));
                    }
                    footWidthArr.push(Math.max.apply(Math,tempArr));
                }else{
                    footWidthArr.push(tableColumns.item(i).viewTableCells.item(0).columnWidth * $BDA.tableColumnsWidthRatio);
                }
            }

            return footWidthArr;
        }

        function sumWidth(arry){
            var sumArry = 0;
            for(var i= 0;i<arry.length;i++){
                sumArry += arry[i];
            }
            return sumArry;
        }

        function setTableWidth(tableWidth,tableHeight){
            var currentTableHeight = me.data.tableBodyData.length * viewBlock.cellHeight;
            var maxSumValue = sumWidth(me.data.tableCellWidth);
            //var borderAddedValue = viewBlock.notShowBorderOfTableCell?(me.data.leftHeadData.length + me.data.topHeadData.length):0;
            var borderAddedValue = 0;
            var scrollWidth = isWebkit?10:17;

            if(currentTableHeight<=tableHeight){
                if (tableWidth >= maxSumValue) {
                    tableWidth = tableWidth - (viewBlock.notShowBorderOfTableCell?0:(me.data.leftHeadData.length + me.data.topHeadData.length+1));
                    setNotExceedingWidth(tableWidth,maxSumValue,0,borderAddedValue);
                } else {
                    setExceedWidth();
                }
            }else {
                if ((tableWidth - maxSumValue) >= scrollWidth) {
                    tableWidth = tableWidth - (viewBlock.notShowBorderOfTableCell?0:(me.data.leftHeadData.length + me.data.topHeadData.length+1));
                    setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue);
                } else {
                    setExceedWidth();
                }
            }
        }

        function setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue){
            var averageWidth = parseInt((tableWidth - maxSumValue - scrollWidth + borderAddedValue) / me.data.tableCellWidth.length);

            for (var i = 0; i < me.data.tableCellWidth.length; i++) {
                if(i < viewBlock.viewTableHead.viewTableColumns.count){
                    if(viewBlock.viewTableHead.viewTableColumns.item(i).viewTableCells.item(0).autoColumnWidth){
                        me.data.tableCellWidth[i] += averageWidth;
                    }
                }else if(i >= viewBlock.viewTableHead.viewTableColumns.count && i < viewBlock.viewTableHead.viewTableColumns.count + viewBlock.blockDataToDraw.length){
                    if(viewBlock.viewTableBody.viewTableColumns.item(0).viewTableCells.item(0).autoColumnWidth){
                        me.data.tableCellWidth[i] += averageWidth;
                    }
                }else{
                    if(viewBlock.viewTableFoot.viewTableColumns.count){
                        if(viewBlock.viewTableFoot.viewTableColumns.item(i-(viewBlock.viewTableHead.viewTableColumns.count + viewBlock.blockDataToDraw.length)).viewTableCells.item(0).autoColumnWidth){
                            me.data.tableCellWidth[i] += averageWidth;
                        }
                    }
                }
            }

            var lastTd = tableWidth - sumWidth(me.data.tableCellWidth) - scrollWidth;

            var isAddLastTd = false;
            for(var i = viewBlock.viewTableFoot.viewTableColumns.count - 1; i >= 0; i--){
                if(viewBlock.viewTableFoot.viewTableColumns.item(i).viewTableCells.item(0).autoColumnWidth){
                    me.data.tableCellWidth[me.data.tableCellWidth.length - 1 - (viewBlock.viewTableFoot.viewTableColumns.count - 1 - i)] += lastTd;
                    isAddLastTd = true;
                    break;
                }
            }
            if(!isAddLastTd){
                if(viewBlock.viewTableBody.viewTableColumns.item(0).viewTableCells.item(0).autoColumnWidth){
                    me.data.tableCellWidth[me.data.tableCellWidth.length - 1 - viewBlock.viewTableFoot.viewTableColumns.count] += lastTd;
                    isAddLastTd = true;
                }
            }
            if(!isAddLastTd){
                for(var i = viewBlock.viewTableHead.viewTableColumns.count - 1; i >=0; i--){
                    if(viewBlock.viewTableHead.viewTableColumns.item(i).viewTableCells.item(0).autoColumnWidth){
                        me.data.tableCellWidth[i] += lastTd;
                        break;
                    }
                }
            }

            setExceedWidth();
        }

        function setExceedWidth(){
            for(var i = 0; i < me.data.tableCellWidth.length; i++){
                if(i < me.data.leftHeadData.length){
                    me.data.leftHeadData[i].width = me.data.tableCellWidth[i];
                }else{
                    me.data.topHeadData[i - me.data.leftHeadData.length].width = me.data.tableCellWidth[i];
                }
            }
        }

        function mergeTDHead(self){
            for(var i=0,len=me.data.mergeTableHead.length;i<len;i++){
                for(var j= 0,jen=me.data.mergeTableHead[i].length;j<jen;j++){
                    if(me.data.mergeTableHead[i][j].rowspan > 1 || me.data.mergeTableHead[i][j].colspan > 1){
                        $(self).datagrid('mergeCells',{
                            index: me.data.mergeTableHead[i][j].index,
                            field: me.data.mergeTableHead[i][j].field,
                            rowspan: me.data.mergeTableHead[i][j].rowspan,
                            colspan: me.data.mergeTableHead[i][j].colspan
                        });
                    }

                }
            }
        }

        function mergeTDFoot(self){
            for(var i=0,len=me.data.mergeTableFoot.length;i<len;i++){
                for(var j= 0,jen=me.data.mergeTableFoot[i].length;j<jen;j++){
                    if(me.data.mergeTableFoot[i][j].rowspan > 1 || me.data.mergeTableFoot[i][j].colspan > 1){
                        $(self).datagrid('mergeCells',{
                            index: me.data.mergeTableFoot[i][j].index,
                            field: me.data.mergeTableFoot[i][j].field,
                            rowspan: me.data.mergeTableFoot[i][j].rowspan,
                            colspan: me.data.mergeTableFoot[i][j].colspan
                        });
                    }

                }
            }
        }

        function createUnderline(){
            var tableBodyColumn = viewBlock.viewTableBody.viewTableColumns.item(0);
            for(var i= 0,len=tableBodyColumn.viewTableCells.count;i<len;i++) {
                for (var j = 0, jen = hierachies.length; j < jen; j++) {
                    for (var k = 0, ken = hierachies[j].hierarchyDimensions.length; k < ken; k++) {
                        if ((hierachies[j].hierarchyDimensions[k][0] + "___" + hierachies[j].hierarchyDimensions[k][1]) == (tableBodyColumn.viewTableCells.item(i).cellObject[0] + "___" + tableBodyColumn.viewTableCells.item(i).cellObject[1]) && tableBodyColumn.viewTableCells.item(i).cellObject[0] != 'merge') {
                            $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(i).each(function () {
                                $(this).find('td').each(function () {
                                    if(Number($(this).attr("field")) < me.data.footFieldStart && k < ken - 1){
                                        $(this).addClass('table-open-drilldown').find('div').css('text-decoration', 'underline');
                                        $(this).find('div').hover(function () {
                                            $(this).css('cursor', 'pointer');
                                        }, function () {
                                            $(this).css('cursor', 'default');
                                        });
                                    }

                                });
                            });
                        }else if(tableBodyColumn.viewTableCells.item(i).cellObject[2] == 1){
                            $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(i).each(function () {
                                $(this).find('td').each(function () {
                                    if(Number($(this).attr("field")) < me.data.footFieldStart){
                                        $(this).addClass('table-open-drilldown').find('div').css('text-decoration', 'underline');
                                        $(this).find('div').hover(function () {
                                            $(this).css('cursor', 'pointer');
                                        }, function () {
                                            $(this).css('cursor', 'default');
                                        });
                                    }

                                });
                            });
                        }
                    }
                }
            }
        }

        function reportLink(){
            var tableBody = viewBlock.viewTableBody;
            for(var i = 0; i < tableBody.viewTableColumns.item(0).viewTableCells.count; i++){
                var tableBodyCell=tableBody.viewTableColumns.item(0).viewTableCells.item(i);
                if(typeof openDrilldown=="undefined"&&((tableBodyCell.reportLink&&tableBodyCell.reportLink.reportID) || (tableBodyCell.reportLinks && tableBodyCell.reportLinks.count > 0))){
                    $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(i).find("td").each(function(){
                        $(this).addClass('tableCell-reportLink').css('text-decoration','underline').find('div').hover(function(){
                            $(this).css('cursor','pointer');
                        },function(){
                            $(this).css('cursor','default');
                        });
                    });
                }
            }
        }

        function setTableWarnings(){
            for(var i = 0; i < me.data.tableWarnings.length; i++){
                for(var j = 0; j < viewBlock.viewTableBody.viewTableColumns.item(0).viewTableCells.count; j++){
                    var viewTableCell = viewBlock.viewTableBody.viewTableColumns.item(0).viewTableCells.item(j);
                    var includeColumn = [];
                    if(me.data.tableWarnings[i].objectName == (viewTableCell.cellObject[0]+"___"+viewTableCell.cellObject[1])){
                        $(me.chartID).find(".datagrid-view2 .datagrid-body .datagrid-btable tr").each(function(k){
                            if(k == j){
                                $(this).find("td").each(function(){
                                    var tdText = $(this).text();
                                    var warningStyle = getWarningStyle(tdText,me.data.tableWarnings[i].warnings,$(this).attr("field"));
                                    if(warningStyle.length){
                                        if(warningStyle[warningStyle.length - 1].effectType == 0){
                                            $(this).css({
                                                "color": warningStyle[warningStyle.length - 1].color,
                                                "background-color": warningStyle[warningStyle.length - 1].BackgroundColor
                                            });
                                        }else{
                                            var tempObj = {};
                                            tempObj.field = $(this).attr("field");
                                            tempObj.color = warningStyle[warningStyle.length - 1].color;
                                            tempObj.backgroundColor = warningStyle[warningStyle.length - 1].BackgroundColor;
                                            includeColumn.push(tempObj);
                                        }
                                    }
                                });
                            }
                        });
                        for(var k = 0; k < includeColumn.length; k++){
                            $(me.chartID).find(".datagrid-view2 .datagrid-body .datagrid-btable td[field="+includeColumn[k].field+"]").css({
                                "color":includeColumn[k].color,
                                "background-color": includeColumn[k].backgroundColor
                            });
                        }
                    }
                }
            }
        }

        function getWarningStyle(compareValue,warnings,columnIndex){
            var styleArr = [];
            for(var i = 0; i < warnings.length; i++){
                if(warnings[i].dataType == 2){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,$BDA.reverseFormatting(compareValue),$BDA.reverseFormatting(me.data.warningData[warnings[i].compareObjectField][columnIndex]),warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,$BDA.reverseFormatting(compareValue),$BDA.reverseFormatting(warnings[i].compareConstants[0]),warnings[i],styleArr);
                    }
                }
                if(warnings[i].dataType == 1){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,new Date(compareValue).getTime(),new Date(me.data.warningData[warnings[i].compareObjectField][columnIndex]).getTime(),warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,new Date(compareValue).getTime(),new Date(Number(warnings[i].compareConstants[0])).getTime(),warnings[i],styleArr);
                    }
                }
                if(warnings[i].dataType == 0){
                    if(warnings[i].compareValueType){
                        setCaseStyle(warnings[i].operation,compareValue,me.data.warningData[warnings[i].compareObjectField][columnIndex],warnings[i],styleArr);
                    }else{
                        setCaseStyle(warnings[i].operation,compareValue,warnings[i].compareConstants[0],warnings[i],styleArr);
                    }
                }
            }
            return styleArr;
        }

        function setCaseStyle(operation,compareValue,warningValue,warnings,styleArr){
            switch(operation){
                case 0:
                    if(compareValue == warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 1:
                    if(compareValue != warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 2:
                    if(compareValue > warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 3:
                    if(compareValue >= warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 4:
                    if(compareValue < warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 5:
                    if(compareValue <= warningValue){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 6:
                    if(warnings.compareConstants.indexOf(compareValue+'')!=-1){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
                case 7:
                    if(warnings.compareConstants.indexOf(compareValue+'')==-1){
                        return setWarningStyle(warnings,styleArr);
                    }
                    break;
            }

        }

        function setWarningStyle(warnings,styleArr){
            var obj = {};
            obj.color = $BDA.csharp2rgba(warnings.color);
            obj.BackgroundColor = $BDA.csharp2rgba(warnings.backgroundColor);
            obj.effectType = warnings.effectType;
            styleArr.push(obj);
            return styleArr;
        }
    };

    this.refreshByLinkage=function(fltHeight){
        this.data = horizontalTableData();
        me.draw(fltHeight);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies){
        this.data = horizontalTableData();
        this.draw(fltHeight, openDrilldown, hierarchies);
    }
}

/*类----交叉表*/
function PivotTable(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = pivotTableData();

    function pivotTableData(){
        var PivotTable = {};

        PivotTable.sum = viewBlock.blockDataToDraw?viewBlock.blockDataToDraw.length:0;

        if(!viewBlock.viewVerticalTableBlock){return;}

        var topHeadRows = viewBlock.viewVerticalTableBlock.viewTableHead.viewTableRows;
        var leftHead = viewBlock.rowDimensions;
        var isLastRowTotal = false;
        var topHead = [];

        /*确定top表头最后一行是否有小计、总计*/
        for(var i= topHeadRows.length-1,len=topHeadRows.length;i<len;i++){
            for(var j= 0,jen=topHeadRows[i].viewTableCells.length;j<jen;j++){
                if(topHeadRows[i].viewTableCells[j].text == '小计' || topHeadRows[i].viewTableCells[j].text == '总计'){
                    isLastRowTotal = true;
                }
            }
        }
        PivotTable.isLastRowTotal = isLastRowTotal;

        /*top表头列合并*/
        var mergeTop = [];
        for(var i= 0,len=topHeadRows.length-1;i<len;i++){
            var arr=[];
            for(var j= viewBlock.rowDimensions.length,k=j+1,jen=topHeadRows[i].viewTableCells.length;k<jen;){
                for(var ken=topHeadRows[i].viewTableCells.length;k<ken;){
                    if(topHeadRows[i].viewTableCells[j].text!=topHeadRows[i].viewTableCells[k].text){
                        if (k-j>1){
                            arr.push({index:i,colspan:k-j,field:j+''});
                        }
                        j=k;
                        break;
                    }else{
                        if (i==0){
                            k++;
                            if (k==jen&&k-j>1){
                                arr.push({index:i,colspan:k-j,field:j+''});
                            }
                        }else {
                            if (topHeadRows[i-1].viewTableCells[j].text!=topHeadRows[i-1].viewTableCells[k].text){
                                if (k-j>1){
                                    arr.push({index:i,colspan:k-j,field:j+''});
                                }
                                j=k;
                                break;
                            }else {
                                k++;
                                if (k==jen&&k-j>1){
                                    arr.push({index:i,colspan:k-j,field:j+''});
                                }
                            }
                        }
                    }
                }
            }
            mergeTop.push(arr);
        }

        /*top表头行合并*/
        var mergeTopTr = [];
        for(var i= 0,len=topHeadRows[0].viewTableCells.length;i<len;i++){
            var arr=[];
            var rowspan =0;
            for(var j= 0,k=j+ 1,jen=topHeadRows.length;k<jen;){
                for(var ken=topHeadRows.length;k<ken;){
                    if(topHeadRows[j].viewTableCells[i].text != topHeadRows[k].viewTableCells[i].text){
                        if(k-j>1){
                            rowspan = k-j;
                            arr.push({index:j,title:topHeadRows[j].viewTableCells[i].text,rowspan:rowspan,field:topHeadRows[j].viewTableCells[i].columnIndex});
                            rowspan = 0;
                        }
                        j=k;
                        break;
                    }else{
                        k++;
                        if (k==jen&&k-j>1){
                            arr.push({index:j,title:topHeadRows[j].viewTableCells[i].text,rowspan:k-j,field:topHeadRows[j].viewTableCells[i].columnIndex});
                        }
                    }
                }
            }
            mergeTopTr.push(arr);
        }

        var finalMergeTopTr = [];
        for(var i= 0,len=mergeTopTr.length;i<len;i++){
            for(var j= 0,jen=mergeTopTr[i].length;j<jen;j++){
                if(mergeTopTr[i][j].title == '小计' || mergeTopTr[i][j].title == '总计'){
                    finalMergeTopTr.push(mergeTopTr[i][j]);
                }
            }
        }

        for(var i= 0,len=topHeadRows.length;i<len;i++){
            var rowArry = [];

            for(var j= leftHead.length,jen=topHeadRows[i].viewTableCells.length;j<jen;j++){
                var obj = {};
                var colspan = 0;

                obj.field = topHeadRows[i].viewTableCells[j].columnIndex + '';
                obj.resizable = false;

                if(!topHeadRows[i].viewTableCells[j].formatString){
                    if(topHeadRows[i].viewTableCells[j].cellObject[3] != 1){
                        obj.title = topHeadRows[i].viewTableCells[j].text===null?"":topHeadRows[i].viewTableCells[j].text;
                    }else{
                        obj.title = topHeadRows[i].viewTableCells[j].text&&$BDA.formatString.date(topHeadRows[i].viewTableCells[j].formatString,new Date(Number(topHeadRows[i].viewTableCells[j].text)));
                    }
                }else {
                    if(topHeadRows[i].viewTableCells[j].cellObject[3] <= 0){
                        obj.title = topHeadRows[i].viewTableCells[j].text===null?"":topHeadRows[i].viewTableCells[j].text;
                    }else if(topHeadRows[i].viewTableCells[j].cellObject[3] == 1){
                        obj.title = topHeadRows[i].viewTableCells[j].text&&$BDA.formatString.date(topHeadRows[i].viewTableCells[j].formatString,new Date(Number(topHeadRows[i].viewTableCells[j].text)));
                    }else{
                        obj.title = $BDA.formatString.number(topHeadRows[i].viewTableCells[j].formatString,Number(topHeadRows[i].viewTableCells[j].text) || '');
                    }
                }
                //obj.title = topHeadRows[i].viewTableCells[j].text;

                for(var m= 0,men=finalMergeTopTr.length;m<men;m++){
                    if(i==finalMergeTopTr[m].index && finalMergeTopTr[m].title == obj.title && finalMergeTopTr[m].field == obj.field){
                        obj.rowspan = finalMergeTopTr[m].rowspan;
                    }
                }

                if(i<len-1){
                    if(!i){
                        for(var k= 0,ken=mergeTop[i].length;k<ken;k++){
                            if(obj.field == mergeTop[i][k].field){
                                colspan = mergeTop[i][k].colspan;
                                j=j+colspan-1;
                            }
                        }
                    }else{
                        for(var k= 0,ken=mergeTop[i].length;k<ken;k++){
                            if(obj.field == mergeTop[i][k].field){
                                colspan = mergeTop[i][k].colspan;
                                j=j+colspan-1;
                            }
                        }
                    }
                    obj.colspan = colspan;
                }
                rowArry.push(obj);
            }
            topHead.push(rowArry);
        }

        /*获取到有行合并的单元格*/
        var getRowspanTd = [];

        for(var i= 0,len=topHead.length;i<len;i++){
            for(var j= 0,jen=topHead[i].length;j<jen;j++){
                var obj = {};
                if(topHead[i][j].rowspan){
                    obj.index = i;
                    obj.field = topHead[i][j].field;
                    obj.title = topHead[i][j].title;
                    getRowspanTd.push(obj);
                }
            }
        }

        /*设置一个中转的数组存放去掉重复的数据*/
        var transitionArry = [];
        $.extend(true,transitionArry,topHead);

        for(var i= 0,len=topHead.length;i<len;i++){
            for(var j= 0,jen=topHead[i].length;j<jen;j++){
                for(var k= 0,ken=getRowspanTd.length;k<ken;k++){
                    if((getRowspanTd[k].index != i) && (getRowspanTd[k].field == topHead[i][j].field) && (getRowspanTd[k].title == topHead[i][j].title)){
                        delete transitionArry[i][j];
                    }
                }
            }
        }

        /*去掉为空的数*/
        var finalTopHeadArry = [], finalTopHeadArryUse = [];

        for(var i= 0,len=transitionArry.length;i<len;i++){
            var arry = [];
            for(var j= 0,jen=transitionArry[i].length;j<jen;j++){
                if(typeof(transitionArry[i][j]) != 'undefined'){
                    arry.push(transitionArry[i][j]);
                }
            }
            finalTopHeadArryUse.push(arry);
            finalTopHeadArry.push(arry);
        }

        PivotTable.finalTopHeadArryUse = finalTopHeadArryUse;

        PivotTable.topHeadData = [];
        $.extend(true,PivotTable.topHeadData,finalTopHeadArry);

        /*去掉无用单元格的field*/
        for(var i= 0,len=PivotTable.topHeadData.length-1;i<len;i++){
            for(var j= 0,jen=PivotTable.topHeadData[i].length;j<jen;j++){
                if(isLastRowTotal){
                    if(!PivotTable.topHeadData[i][j].rowspan){
                        delete PivotTable.topHeadData[i][j]['field'];
                    }
                }else{
                    delete PivotTable.topHeadData[i][j]['field'];
                }
            }
        }

        /*获取所有含有field的对象*/
        var fieldObjArry = [];
        for(var i= 0,len=PivotTable.topHeadData.length;i<len;i++){
            for(var j= 0,jen=PivotTable.topHeadData[i].length;j<jen;j++){
                if(PivotTable.topHeadData[i][j].field){
                    fieldObjArry.push(PivotTable.topHeadData[i][j]);
                }
            }
        }

        /*以field的大小来正序*/
        fieldObjArry.sort(function(a,b){
            return parseFloat(a.field)-parseFloat(b.field);
        });

        PivotTable.fieldObjArry = fieldObjArry;

        /*没有列标签*/
        var isNotColumns = false;

        if(!viewBlock.columnDimensions.length){
            isNotColumns = true;
        }
        PivotTable.isNotColumns = isNotColumns;

        /*左边表头*/
        var leftHeadArry = [];

        for(var i= 0,len=viewBlock.rowDimensions.length;i<len;i++){
            var obj = {};
            var currentIndex = 0;
            for(var j= 0,jen=topHeadRows[0].viewTableCells.length;j<jen;j++){
                if(viewBlock.rowDimensions[i][1] == topHeadRows[0].viewTableCells[j].text){
                    currentIndex = topHeadRows[0].viewTableCells[j].columnIndex;
                    if(isNotColumns || viewBlock.showCrossTableHead){
                        obj.title = topHeadRows[0].viewTableCells[j].text;
                    }
                }
            }
            obj.field = currentIndex + '';

            leftHeadArry.push(obj);
        }

        PivotTable.leftHeadData = [];
        PivotTable.leftHeadData.push(leftHeadArry);
        /*end*/

        /*获取表体以及表体数据格式化*/
        var blockDataLength = viewBlock.blockDataToDraw ? viewBlock.blockDataToDraw.length : 0;
        var tBodyCell = viewBlock.viewVerticalTableBlock.viewTableBody.viewTableRows[0].viewTableCells;
        var tBodyData = [];
        for(var i= 0,len=blockDataLength;i<len;i++){
            var obj = {};
            for(var j= 0,jen=tBodyCell.length;j<jen;j++){
                var tempData = viewBlock.blockDataToDraw[i][tBodyCell[j].columnIndex];
                if(tempData == "总计" || tempData == "小计"){
                    obj[tBodyCell[j].columnIndex] = tempData;
                }else{
                    if(!tBodyCell[j].formatString){
                        if(tBodyCell[j].cellObject[3] == 1){
                            obj[tBodyCell[j].columnIndex] = tempData&&$BDA.formatString.date(tBodyCell[j].formatString,new Date(Number(tempData))=='Invalid Date'?tempData:new Date(Number(tempData)));
                        }else{
                            obj[tBodyCell[j].columnIndex] = tempData===null ? '' : tempData;
                        }
                    }else {
                        if(tBodyCell[j].cellObject[3] == 1){
                            obj[tBodyCell[j].columnIndex] = tempData&&$BDA.formatString.date(tBodyCell[j].formatString,new Date(Number(tempData))=='Invalid Date'?tempData:new Date(Number(tempData)));
                        }else if(tBodyCell[j].cellObject[3] == 2){
                            obj[tBodyCell[j].columnIndex] = tempData === null ? '':(tempData===""?"":$BDA.formatString.number(tBodyCell[j].formatString,Number(tempData)));
                        }else{
                            obj[tBodyCell[j].columnIndex] = tempData===null ? '' : tempData;
                        }
                    }
                }
            }
            tBodyData.push(obj);
        }
        PivotTable.tableBodyData = tBodyData;
        PivotTable.isNotHiddenScroll = false;

        return PivotTable;
    }

    this.draw = function(fltHeight){
        $(this.chartID).find('.bda-data').css('display','none');
        
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        var tempStr = "10,10,10,10";
        var paddingArr = viewBlock.padding?viewBlock.padding.split(","):tempStr.split(",");
        $(this.chartID).find('.bda-chart-content').css({
            "padding-top": Number($.trim(paddingArr[0]))/100 + "rem",
            "padding-right": Number($.trim(paddingArr[1]))/100 + "rem",
            "padding-bottom": Number($.trim(paddingArr[2]))/100 + "rem",
            "padding-left": Number($.trim(paddingArr[3]))/100 + "rem"
        });

        this.setChartContentHeight(fltHeight);

        var userAgent = window.navigator.userAgent;
        var isWebkit = false;
        if(userAgent.indexOf('Chrome') != -1){
            isWebkit = true;
        }

        var tableHeight = $(this.chartID).find('.bda-chart-content').height();
        var tableWidth = $(this.chartID).find('.bda-chart-content').width();
        var table = document.createElement('table');

        if(!viewBlock.viewVerticalTableBlock){return;}

        var pageSizeNum = setPageSIze() || 10;
        this.pageSizeNum = pageSizeNum;
        var pageLoaded = true;

        maxWidth();
        setTableWidth(tableWidth);

        $(this.chartID).find('.bda-chart-content').html('');

        $(table).css({
            width: tableWidth,
            height: tableHeight
        });

        $(this.chartID).find(".bda-chart-content").append(table);

        if (viewBlock.pagingDisplay){
            $(table).datagrid({ loadFilter: pagerFilter }).datagrid({
                // pagination: viewBlock.pagingDisplay,	//表示在datagrid设置分页
                pagination: true,	//表示在datagrid设置分页
                pageSize: pageSizeNum,
                pageNumber: 1,	//第几页显示（默认第一页，可以省略）
                pageList: [pageSizeNum, 20, 30, 40, 50],
                url: null,
                frozenColumns: this.data.leftHeadData,
                columns: this.data.topHeadData,
                scrollbarSize: 20,
                striped: $BDA.theme.themeID ? false : true,
                singleSelect: true,
                nowrap: false,
                data: this.data.tableBodyData,
                onLoadSuccess: function () {
                    var self = this;
                    tableSuccess(self);
                }
            });
            $($(table).datagrid("getPager")).pagination({
                showRefresh: false,
            })
        }else{
            $(table).datagrid({
                /*view: scrollview,*/
                pageSize: 50,
                url: null,
                columns: this.data.topHeadData,
                frozenColumns: this.data.leftHeadData,
                scrollbarSize: 20,
                striped: $BDA.theme.themeID ? false : true,
                nowrap: false,
                singleSelect: true,
                onLoadSuccess: function () {
                    var self = this;
                    tableSuccess(self);
                }
            }).datagrid('loadData', this.data.tableBodyData);
        }

        function pagerFilter(data) {
            if (typeof data.length == 'number' && typeof data.splice == 'function') {	// is array
                data = {
                    total: data.length,
                    rows: data
                }
            }
            var dg = $(this);
            var opts = dg.datagrid('options');
            var pager = dg.datagrid('getPager');
            me.currentPage = opts.pageNumber;
            me.pageSizeNum = opts.pageSize;
            pager.pagination({
                onSelectPage: function (pageNum, pageSize) {
                    // if (!pageLoaded) { return; }
                    // pageLoaded = false;
                    opts.pageNumber = pageNum;
                    opts.pageSize = pageSize;
                    pager.pagination('refresh', {
                        pageNumber: pageNum,
                        pageSize: pageSize
                    });
                    dg.datagrid('loadData', data);
                }
            });
            if (!data.originalRows) {
                data.originalRows = (data.rows);
            }
            var start = (opts.pageNumber - 1) * parseInt(opts.pageSize);
            var end = start + parseInt(opts.pageSize);
            data.rows = (data.originalRows.slice(start, end));
            return data;
        }

        function tableSuccess(self){
            var contentHeight = $(me.chartID).find('.datagrid-view2 .datagrid-body').height();
            var currentHeight = $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable').height();

            if ((currentHeight <= contentHeight) && me.data.isNotHiddenScroll) {
                $(me.chartID).find('.datagrid-view2 .datagrid-body').css('overflow-y', 'hidden');
            }

            getLeftMergeRow(self);
            setHeadStyle();

            $(me.chartID).find('.datagrid-view2 .datagrid-body td').css('text-align', 'right');

            if (!viewBlock.showCrossTableHead) {
                hideBorder();
            }

            var leftBody = $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr');
            mergeRowSubtotal(self, leftBody);

            var color = colorConversion(viewBlock.totalBackgroundColor);

            setSubTotalRows(color);
            setSubTotalColumn(color);

            editBorderBug();
        }

        function setPageSIze() {
            var pageSize = 50;
            if (viewBlock.pageRecordCount != -1) {
                pageSize = viewBlock.pageRecordCount;
            } else {
                var bodyHeight = tableHeight - me.data.topHeadData.length * 30;
                bodyHeight = viewBlock.pagingDisplay ? (bodyHeight - 35) : bodyHeight;
                pageSize = parseInt(bodyHeight / 30);
            }
            return pageSize;
        }

        function sumWidth(arry){
            var sumArry = 0;
            for(var i= 0;i<arry.length;i++){
                sumArry += arry[i];
            }
            return sumArry;
        }

        function maxWidth(){
            var leftHead = viewBlock.rowDimensions;
            var topHeadRows = viewBlock.viewVerticalTableBlock.viewTableHead.viewTableRows;

            /*左边部分的宽度*/
            var tableLeftStrlength = [];

            for(var i= 0,len=leftHead.length;i<len;i++){
                var strLength = leftHead[i][1];
                tableLeftStrlength.push(getLength(strLength,true));
            }

            var tableLeftBodyStrlength = [];

            for(var i= 0,len=leftHead.length;i<len;i++){
                var arry = [];
                for(var j= 0,jen=viewBlock.blockDataToDraw.length;j<jen;j++){
                    var strLength = viewBlock.blockDataToDraw[j][i];
                    arry.push(getLength(strLength,true));
                }
                tableLeftBodyStrlength.push(Math.max.apply(Math,arry));
            }

            var maxLeftWidthArry = [];

            for(var i= 0;i<tableLeftBodyStrlength.length;i++){
                var maxValue = Math.max(tableLeftStrlength[i],tableLeftBodyStrlength[i]) + 8;
                maxLeftWidthArry.push(maxValue);
            }

            me.data.maxLeftWidthArry = maxLeftWidthArry;

            for(var i= 0,len=me.data.maxLeftWidthArry.length;i<len;i++){
                me.data.leftHeadData[0][i].width = me.data.maxLeftWidthArry[i];
            }

            /*计算出垂直部分的最大宽度*/
            var tableHeadStrLength = [];

            for(var i= leftHead.length,len=topHeadRows[0].viewTableCells.length;i<len;i++){
                var arry = [];
                for(var j= 0,jen=topHeadRows.length;j<jen;j++){
                    var strLength = topHeadRows[j].viewTableCells[i].text;
                    arry.push(getLength(strLength,true));
                }
                tableHeadStrLength.push(Math.max.apply(Math,arry));
            }

            var tableBodyStrLength = [];

            for(var i= leftHead.length,len = topHeadRows[0].viewTableCells.length;i<len;i++){
                var arry = [];
                for(var j= 0,jen=viewBlock.blockDataToDraw.length;j<jen;j++){
                    var strLength = me.data.tableBodyData[j][i];
                    arry.push(getLength(strLength,false));
                }
                tableBodyStrLength.push(Math.max.apply(Math,arry));
            }

            var maxWidthArry = [];

            for(var i= 0;i<tableBodyStrLength.length;i++){
                var maxValue = Math.max(tableHeadStrLength[i],tableBodyStrLength[i]) + 8;
                maxWidthArry.push(maxValue);
            }

            me.data.maxTopWidth = maxWidthArry;

        }

        function getLength(str,isTableHead){
            if(isTableHead){
                if(str == '小计' || str == '总计'){
                    $('.test-length span').css('font-size',viewBlock.totalFont.size/100+"rem");
                }else{
                    $('.test-length span').css('font-size',viewBlock.tableHeadFont.size/100+"rem");
                }
            }
            return parseFloat($('.test-length span').html(str).width() + 8*$BDA.defaultRatio);
        }

        //function setTableWidth(tableWidth){
        //    var currentTableHeight = (viewBlock.rowDimensions.length || viewBlock.columnDimensions.length)*30 + viewBlock.blockDataToDraw.length*30;
        //    var maxSumValue = sumWidth(me.data.maxTopWidth) || 0;
        //    maxSumValue = maxSumValue?(maxSumValue + me.data.maxTopWidth.length):0;
        //    var maxLeftSum = sumWidth(me.data.maxLeftWidthArry) || 0;
        //    maxLeftSum = maxLeftSum?(maxLeftSum + me.data.maxLeftWidthArry.length + 1):0;
        //    var rightBody = tableWidth - maxLeftSum;
        //
        //    var scrollWidth = isWebkit?10:17;
        //    if(currentTableHeight<=tableHeight) {
        //        if (tableWidth >= (maxLeftSum + maxSumValue)) {
        //            setNotExceedingWidth(tableWidth,rightBody,maxLeftSum,maxSumValue,0);
        //        } else {
        //            setExceedWidth();
        //        }
        //    }else{
        //        if ((tableWidth - maxLeftSum - maxSumValue) >= scrollWidth) {
        //            setNotExceedingWidth(tableWidth,rightBody,maxLeftSum,maxSumValue,scrollWidth);
        //        } else {
        //            setExceedWidth();
        //        }
        //    }
        //}

        function setTableWidth(tableWidth){
            var currentTableHeight = (viewBlock.rowDimensions.length || viewBlock.columnDimensions.length)*30 + viewBlock.blockDataToDraw.length*30;
            var maxSumValue = sumWidth(me.data.maxTopWidth) || 0;
            var maxLeftSum = sumWidth(me.data.maxLeftWidthArry) || 0;
            tableWidth = tableWidth - 1 * $BDA.defaultRatio;
            var rightBody = tableWidth - maxLeftSum;

            var scrollWidth = isWebkit?10:17;
            if(currentTableHeight<=tableHeight) {
                if (tableWidth >= (maxLeftSum + maxSumValue)) {
                    setNotExceedingWidth(tableWidth,rightBody,maxLeftSum,maxSumValue,0);
                } else {
                    setExceedWidth();
                }
            }else{
                if ((tableWidth - maxLeftSum - maxSumValue) >= scrollWidth) {
                    setNotExceedingWidth(tableWidth,rightBody,maxLeftSum,maxSumValue,scrollWidth);
                } else {
                    setExceedWidth();
                }
            }
        }

        //function setNotExceedingWidth(tableWidth,rightBody,maxLeftSum,maxSumValue,scrollWidth){
        //    if (me.data.isNotColumns) {
        //        var averageWidth = parseInt((tableWidth - maxLeftSum - maxSumValue - scrollWidth - me.data.maxTopWidth.length - me.data.leftHeadData[0].length - 1) / (me.data.maxTopWidth.length + me.data.maxLeftWidthArry.length));
        //        var leftTableWidthArry = [];
        //
        //        $.extend(true, leftTableWidthArry, me.data.maxLeftWidthArry);
        //        for (var i = 0, len = leftTableWidthArry.length; i < len; i++) {
        //            me.data.leftHeadData[0][i].width = leftTableWidthArry[i] = leftTableWidthArry[i] + averageWidth;
        //        }
        //
        //        for (var i = 0; i < me.data.maxTopWidth.length; i++) {
        //            me.data.maxTopWidth[i] += averageWidth;
        //        }
        //
        //        var lastTd = tableWidth - (sumWidth(me.data.maxTopWidth) || 0) - (sumWidth(leftTableWidthArry) || 0) - scrollWidth + 1;
        //
        //        me.data.maxTopWidth[me.data.maxTopWidth.length - 1] = me.data.maxTopWidth[me.data.maxTopWidth.length - 1] + lastTd;
        //
        //        for (var i = 0, len = me.data.fieldObjArry.length; i < len; i++) {
        //            me.data.fieldObjArry[i].width = me.data.maxTopWidth[i];
        //        }
        //
        //        for (var i = 0, len = me.data.topHeadData.length; i < len; i++) {
        //            for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
        //                if (me.data.topHeadData[i][j].field) {
        //                    var field = me.data.topHeadData[i][j].field;
        //                    for (var k = 0, ken = me.data.fieldObjArry.length; k < ken; k++) {
        //                        if (field == me.data.fieldObjArry[k].field) {
        //                            me.data.topHeadData[i][j].width = me.data.fieldObjArry[k].width;
        //                        }
        //                    }
        //                }
        //            }
        //        }
        //    } else {
        //        var averageWidth = parseInt((rightBody - maxSumValue - scrollWidth) / me.data.maxTopWidth.length);
        //
        //        for (var i = 0; i < me.data.maxTopWidth.length; i++) {
        //            me.data.maxTopWidth[i] += averageWidth;
        //        }
        //
        //        var lastTd = rightBody - (sumWidth(me.data.maxTopWidth) || 0) - scrollWidth + 1;
        //
        //        me.data.maxTopWidth[me.data.maxTopWidth.length - 1] = me.data.maxTopWidth[me.data.maxTopWidth.length - 1] + lastTd;
        //
        //        if (!me.data.isLastRowTotal) {
        //            if (!viewBlock.viewVerticalTableBlock.viewTableHead.viewTableRows.length && viewBlock.rowDimensions.length) {
        //                for (var i = 0, len = me.data.topHeadData.length; i < len; i++) {
        //                    for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
        //                        me.data.topHeadData[i][j].width = me.data.maxTopWidth[j];
        //                    }
        //                }
        //            } else {
        //                for (var i = me.data.topHeadData.length - 1, len = me.data.topHeadData.length; i < len; i++) {
        //                    for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
        //                        me.data.topHeadData[i][j].width = me.data.maxTopWidth[j];
        //                    }
        //                }
        //            }
        //        } else {
        //            for (var i = 0, len = me.data.fieldObjArry.length; i < len; i++) {
        //                me.data.fieldObjArry[i].width = me.data.maxTopWidth[i];
        //            }
        //
        //            for (var i = 0, len = me.data.topHeadData.length; i < len; i++) {
        //                for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
        //                    if (me.data.topHeadData[i][j].field) {
        //                        var field = me.data.topHeadData[i][j].field;
        //                        for (var k = 0, ken = me.data.fieldObjArry.length; k < ken; k++) {
        //                            if (field == me.data.fieldObjArry[k].field) {
        //                                me.data.topHeadData[i][j].width = me.data.fieldObjArry[k].width;
        //                            }
        //                        }
        //                    }
        //                }
        //            }
        //        }
        //    }
        //}

        function setNotExceedingWidth(tableWidth,rightBody,maxLeftSum,maxSumValue,scrollWidth){
            if (me.data.isNotColumns) {
                var averageWidth = parseInt((tableWidth - maxLeftSum - maxSumValue - scrollWidth) / (me.data.maxTopWidth.length + me.data.maxLeftWidthArry.length));
                var leftTableWidthArry = [];

                $.extend(true, leftTableWidthArry, me.data.maxLeftWidthArry);
                for (var i = 0, len = leftTableWidthArry.length; i < len; i++) {
                    me.data.leftHeadData[0][i].width = leftTableWidthArry[i] = leftTableWidthArry[i] + averageWidth;
                }

                for (var i = 0; i < me.data.maxTopWidth.length; i++) {
                    me.data.maxTopWidth[i] += averageWidth;
                }

                var lastTd = tableWidth - (sumWidth(me.data.maxTopWidth) || 0) - (sumWidth(leftTableWidthArry) || 0) - scrollWidth;

                me.data.maxTopWidth[me.data.maxTopWidth.length - 1] = me.data.maxTopWidth[me.data.maxTopWidth.length - 1] + lastTd;

                for (var i = 0, len = me.data.fieldObjArry.length; i < len; i++) {
                    me.data.fieldObjArry[i].width = me.data.maxTopWidth[i];
                }

                for (var i = 0, len = me.data.topHeadData.length; i < len; i++) {
                    for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
                        if (me.data.topHeadData[i][j].field) {
                            var field = me.data.topHeadData[i][j].field;
                            for (var k = 0, ken = me.data.fieldObjArry.length; k < ken; k++) {
                                if (field == me.data.fieldObjArry[k].field) {
                                    me.data.topHeadData[i][j].width = me.data.fieldObjArry[k].width;
                                }
                            }
                        }
                    }
                }
            } else {
                var averageWidth = parseInt((rightBody - maxSumValue - scrollWidth) / me.data.maxTopWidth.length);

                for (var i = 0; i < me.data.maxTopWidth.length; i++) {
                    me.data.maxTopWidth[i] += averageWidth;
                }

                var lastTd = rightBody - (sumWidth(me.data.maxTopWidth) || 0) - scrollWidth;

                me.data.maxTopWidth[me.data.maxTopWidth.length - 1] = me.data.maxTopWidth[me.data.maxTopWidth.length - 1] + lastTd;

                if (!me.data.isLastRowTotal) {
                    if (!viewBlock.viewVerticalTableBlock.viewTableHead.viewTableRows.length && viewBlock.rowDimensions.length) {
                        for (var i = 0, len = me.data.topHeadData.length; i < len; i++) {
                            for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
                                me.data.topHeadData[i][j].width = me.data.maxTopWidth[j];
                            }
                        }
                    } else {
                        for (var i = me.data.topHeadData.length - 1, len = me.data.topHeadData.length; i < len; i++) {
                            for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
                                me.data.topHeadData[i][j].width = me.data.maxTopWidth[j];
                            }
                        }
                    }
                } else {
                    for (var i = 0, len = me.data.fieldObjArry.length; i < len; i++) {
                        me.data.fieldObjArry[i].width = me.data.maxTopWidth[i];
                    }

                    for (var i = 0, len = me.data.topHeadData.length; i < len; i++) {
                        for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
                            if (me.data.topHeadData[i][j].field) {
                                var field = me.data.topHeadData[i][j].field;
                                for (var k = 0, ken = me.data.fieldObjArry.length; k < ken; k++) {
                                    if (field == me.data.fieldObjArry[k].field) {
                                        me.data.topHeadData[i][j].width = me.data.fieldObjArry[k].width;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }

        function setExceedWidth(){
            if (!me.data.isLastRowTotal) {
                if (!viewBlock.viewVerticalTableBlock.viewTableHead.viewTableRows.length && viewBlock.rowDimensions.length) {
                    for (var i = 0, len = me.data.topHeadData.length; i < len; i++) {
                        me.data.topHeadData[i].width = me.data.maxTopWidth[i];
                    }
                } else {
                    for (var i = me.data.topHeadData.length - 1, len = me.data.topHeadData.length; i < len; i++) {
                        for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
                            me.data.topHeadData[i][j].width = me.data.maxTopWidth[j];
                        }
                    }
                }
            } else {
                for (var i = 0, len = me.data.fieldObjArry.length; i < len; i++) {
                    me.data.fieldObjArry[i].width = me.data.maxTopWidth[i];
                }

                for (var i = 0, len = me.data.topHeadData.length; i < len; i++) {
                    for (var j = 0, jen = me.data.topHeadData[i].length; j < jen; j++) {
                        if (me.data.topHeadData[i][j].field) {
                            var field = me.data.topHeadData[i][j].field;
                            for (var k = 0, ken = me.data.fieldObjArry.length; k < ken; k++) {
                                if (field == me.data.fieldObjArry[k].field) {
                                    me.data.topHeadData[i][j].width = me.data.fieldObjArry[k].width;
                                }
                            }
                        }
                    }
                }
            }
        }

        function getLeftMergeRow(self){
            /*Left表头合并*/
            // var leftHead = [];
            // for(var i= 0,len=viewBlock.rowDimensions.length;i<len-1;i++){
            //     var arr=[];
            //     var rowspan =0;
            //     if(viewBlock.blockDataToDraw){
            //         var currentPageTrLength = $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').length;
            //         for(var j=0,k=j+1,jen=currentPageTrLength;k<jen;) {
            //             for(var ken=currentPageTrLength;k<ken;){
            //                 if ($(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').eq(j).find('td').eq(i).find('div').html()!=$(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').eq(k).find('td').eq(i).find('div').html()){
            //                     if (k-j>1){
            //                         rowspan = k-j;
            //                         arr.push({index:$(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').eq(j).attr('datagrid-row-index'),rowspan:rowspan,field:i+''});
            //                         rowspan = 0;
            //                     }
            //                     j=k;
            //                     break;
            //                 }else{
            //                     k++;
            //                     if (k==jen&&k-j>1){
            //                         arr.push({index:$(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').eq(j).attr('datagrid-row-index'),rowspan:k-j,field:i+''});
            //                     }
            //                 }
            //             }
            //         }
            //         leftHead.push(arr);
            //     }
            // }

            // mergeRow(self,leftHead);
            
            var arrMergeRows = [], arrMergeRow=[], mMergeRow = {}, lastMergeRow = {}, previousIsMerge = true;
            var currentPageTableRowLength = $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').length;
            for(var i = 0; i < viewBlock.rowDimensions.length; i++){
                arrMergeRow=[];
                for(var j = 0; j < currentPageTableRowLength;){
                    mMergeRow = {};
                    mMergeRow.row = Number($(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').eq(j).attr('datagrid-row-index'));
                    mMergeRow.rowspan = 1;
                    mMergeRow.col =i;mMergeRow.rowDomIndex=j;
                    var cellText = $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').eq(j).find('td').eq(i).find('div').html();
                    if(arrMergeRows.length == 0){
                        for(var k = j + 1; k < currentPageTableRowLength; k++){
                            j = k;
                            if (cellText == $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').eq(k).find('td').eq(i).find('div').html()){
                                mMergeRow.rowspan++;
                            }else { break;}
                        }
                    }else {
                        previousIsMerge = false;
                        for(var m = 0; m < arrMergeRows[arrMergeRows.length - 1].length; m++){
                            lastMergeRow = arrMergeRows[arrMergeRows.length - 1][m];
                            if(j >= lastMergeRow.rowDomIndex && j <= lastMergeRow.rowDomIndex + lastMergeRow.rowspan - 2) {
                                previousIsMerge = true;
                                break;
                            }
                        }
                        if(previousIsMerge){
                            for(var k = j + 1; k < currentPageTableRowLength; k++){
                                j = k;
                                if ((cellText == $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').eq(k).find('td').eq(i).find('div').html()) &&
                                    (k >= lastMergeRow.rowDomIndex + 1 && k <= lastMergeRow.rowDomIndex + lastMergeRow.rowspan - 1)){
                                        mMergeRow.rowspan++;
                                }else { break;}
                            }
                        }else { j++; }
                    }
                    arrMergeRow.push(mMergeRow);
                    if(j == currentPageTableRowLength - 1){ j++; }
                }
                arrMergeRows.push(arrMergeRow);
            }

            mergeRow(self,arrMergeRows);
        }

        function mergeRow(self,arry){
            /*左表头合并行*/
            for(var i=0,len=arry.length;i<len;i++){
                for(var j= 0,jen=arry[i].length;j<jen;j++){
                    $(self).datagrid('mergeCells',{
                        index: arry[i][j].rowDomIndex,
                        field: i+"",
                        rowspan: arry[i][j].rowspan
                    });
                }
            }
        }

        function setHeadStyle(){
            if(me.data.isNotColumns){
                $(me.chartID).find('.datagrid-view1 .datagrid-header-row td').each(function(){
                    $(this).css({
                        'background-color': $BDA.theme.currentBackgroundColor||$BDA.csharp2rgba(viewBlock.tableHeadBackgroundColor),
                        'color': $BDA.theme.themeID?"#fff":$BDA.csharp2rgba(viewBlock.tableHeadColor)
                    });
                }).children().each(function(){
                    $(this).css({
                        'color': $BDA.theme.themeID?"#fff":$BDA.csharp2rgba(viewBlock.tableHeadColor),
                        'font-family': viewBlock.tableHeadFont.fontFamily/100+"rem",
                        'font-size': viewBlock.tableHeadFont.size,
                        'font-style': viewBlock.tableHeadFont.italic?'italic':'normal',
                        'font-weight': viewBlock.tableHeadFont.bold?'bold':'normal',
                        'text-decoration': viewBlock.tableHeadFont.underline?'underline':
                            (viewBlock.tableHeadFont.strikeout?'line-through':'none')
                    });
                });

                $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').each(function(){
                    $(this).find('td').each(function(){
                        var rowspan = parseFloat($(this).attr('rowspan')) || 0;

                        if(rowspan>1){
                            $(this).css('background-color',$BDA.theme.currentBackgroundColor||'#ffffff');
                        }
                    });
                });
            }else{
                if(viewBlock.showCrossTableHead){
                    $(me.chartID).find('.datagrid-view1 .datagrid-header-row td').each(function(){
                        $(this).css({
                            'background-color': $BDA.theme.currentBackgroundColor||$BDA.csharp2rgba(viewBlock.tableHeadBackgroundColor),
                            'color': $BDA.theme.themeID?"#fff":$BDA.csharp2rgba(viewBlock.tableHeadColor)
                        });
                    }).children().each(function(){
                        $(this).css({
                            'color': $BDA.theme.themeID?"#fff":$BDA.csharp2rgba(viewBlock.tableHeadColor),
                            'font-family': viewBlock.tableHeadFont.fontFamily,
                            'font-size': viewBlock.tableHeadFont.size/100+"rem",
                            'font-style': viewBlock.tableHeadFont.italic?'italic':'normal',
                            'font-weight': viewBlock.tableHeadFont.bold?'bold':'normal',
                            'text-decoration': viewBlock.tableHeadFont.underline?'underline':
                                (viewBlock.tableHeadFont.strikeout?'line-through':'none')
                        });
                    });
                }

                $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable td').each(function(){
                    $(this).css({
                        'background-color': $BDA.theme.currentBackgroundColor||$BDA.csharp2rgba(viewBlock.tableHeadBackgroundColor),
                        'color': $BDA.theme.themeID?"#fff":$BDA.csharp2rgba(viewBlock.tableHeadColor)
                    });
                }).children().each(function(){
                    $(this).css({
                        'color': $BDA.theme.themeID?"#fff":$BDA.csharp2rgba(viewBlock.tableHeadColor),
                        'font-family': viewBlock.tableHeadFont.fontFamily,
                        'font-size': viewBlock.tableHeadFont.size/100+"rem",
                        'font-style': viewBlock.tableHeadFont.italic?'italic':'normal',
                        'font-weight': viewBlock.tableHeadFont.bold?'bold':'normal',
                        'text-decoration': viewBlock.tableHeadFont.underline?'underline':
                            (viewBlock.tableHeadFont.strikeout?'line-through':'none')
                    });
                });
            }

            $(me.chartID).find('.datagrid-view2 .datagrid-header-row td').each(function(){
                $(this).css({
                    'background-color': $BDA.theme.currentBackgroundColor||$BDA.csharp2rgba(viewBlock.tableHeadBackgroundColor),
                    'color': $BDA.theme.themeID?"#fff":$BDA.csharp2rgba(viewBlock.tableHeadColor)
                });
            }).children().each(function(){
                $(this).css({
                    'color': $BDA.theme.themeID?"#fff":$BDA.csharp2rgba(viewBlock.tableHeadColor),
                    'font-family': viewBlock.tableHeadFont.fontFamily,
                    'font-size': viewBlock.tableHeadFont.size/100+"rem",
                    'font-style': viewBlock.tableHeadFont.italic?'italic':'normal',
                    'font-weight': viewBlock.tableHeadFont.bold?'bold':'normal',
                    'text-decoration': viewBlock.tableHeadFont.underline?'underline':
                        (viewBlock.tableHeadFont.strikeout?'line-through':'none')
                });
            });
        }

        function colorConversion(val) {
            var opacity = ((val >> 24) & 0xFF) + '',
                red = ((val >> 16) & 0xFF) + '',
                green = ((val >> 8) & 0xFF) + '',
                blue = (val & 0xFF) + '';
            return red+',' + green+',' + blue;
        }

        function hideBorder(){
            if(!me.data.isNotColumns){
                if(viewBlock.rowDimensions.length<2){
                    $(me.chartID).find('.datagrid-view1 .datagrid-header .datagrid-htable td').each(function(i){
                        $(this).css({
                            'border-top-color': 'transparent',
                            'border-left-color': 'transparent'
                        });
                    });
                }else{
                    $(me.chartID).find('.datagrid-view1 .datagrid-header .datagrid-htable td').each(function(i) {
                        if (i < (viewBlock.rowDimensions.length - 1)) {
                            $(this).css({
                                'border-top-color': 'transparent',
                                'border-right-color': 'transparent',
                                'border-left-color': 'transparent'
                            });
                        } else {
                            $(this).css('border-top-color', 'transparent');
                        }
                    })
                }
            }
        }

        function mergeRowSubtotal(self,Rows){
            var mergeTdArry = [];
            var mergeTr = Rows;
            for(var i= 0,len=mergeTr.length;i<len;i++){
                var arry = [];
                var colspan =0;

                for(var j= 0,k=j+1,jen=mergeTr.eq(i).find('td').length;k<jen;){
                    for(var ken=mergeTr.eq(i).find('td').length;k<ken;){
                        var currText = mergeTr.eq(i).find('td').eq(j).find('div').html();
                        var nextText = mergeTr.eq(i).find('td').eq(k).find('div').html();

                        if (currText!=nextText){
                            if (k-j>1){
                                colspan = k-j;
                                arry.push({index:i,colspan:colspan,field:j+'',text:currText});
                                colspan = 0;
                            }
                            j=k;
                            break;
                        }else{
                            k++;
                            if (k==jen&&k-j>1){
                                arry.push({index:i,colspan:k-j,field:j+'',text:currText});
                            }
                        }
                    }
                }
                mergeTdArry.push(arry);
            }

            var finalMerge = [], finalMergeTotal = [];
            for(var i= 0,len=mergeTdArry.length;i<len;i++){
                for(var j= 0,jen=mergeTdArry[i].length;j<jen;j++){
                    if(mergeTdArry[i][j].text == '小计'){
                        finalMerge.push(mergeTdArry[i][j]);
                    }else if(mergeTdArry[i][j].text == '总计'){
                        finalMergeTotal.push(mergeTdArry[i][j]);
                    }
                }
            }

            for(var i=0,len=finalMerge.length;i<len;i++){
                $(self).datagrid('mergeCells',{
                    index: finalMerge[i].index,
                    field: finalMerge[i].field,
                    colspan: finalMerge[i].colspan
                });
            }

            for(var i=0,len=finalMergeTotal.length;i<len;i++){
                $(self).datagrid('mergeCells',{
                    index: finalMergeTotal[i].index,
                    field: finalMergeTotal[i].field,
                    colspan: finalMergeTotal[i].colspan
                });
            }
        }

        function setSubTotalRows(color){
            var color = color;
            var setArry = [], setTotalArry = [];

            $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').each(function(){
                $(this).find('td').each(function(){
                    var obj1 = {}, obj2 = {};
                    if($(this).find('div').html()=='小计' || $(this).find('div').html()=='总计'){
                        var colspan = parseFloat($(this).attr('colspan')) || 1;
                        var rowIndex = $(this).parents('tr').attr('datagrid-row-index');
                        obj1.colspan = colspan;
                        obj1.opacity = '';
                        obj2.colspan = colspan;
                        obj2.index = rowIndex;

                        for (var n= 0,nen=setArry.length;n<nen;n++){
                            if (setArry[n].colspan==colspan){
                                break;
                            }
                        }
                        if (n==nen){
                            setArry.push(obj1);
                        }
                        for(var m= 0,men=setTotalArry.length;m<men;m++){
                            if(setTotalArry[m].index == rowIndex){
                                break;
                            }
                        }
                        if(m==men){
                            setTotalArry.push(obj2);
                        }
                    }
                });
            });

            setArry.sort(compare('colspan'));
            for(var i= 0,len=setArry.length;i<len;i++){
                setArry[i].opacity = 0.5-0.1*i;
            }

            $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr').each(function(){
                $(this).find('td').each(function(){
                    if($(this).find('div').html()=='小计' || $(this).find('div').html()=='总计'){
                        var colspan = parseFloat($(this).attr('colspan')) || 1;

                        for(var i= 0,len=setArry.length;i<len;i++){
                            if(colspan == setArry[i].colspan){
                                $(this).css({
                                    'background-color':'rgba('+color+','+setArry[i].opacity+')',
                                    //'background-color':'rgba('+color+','+0.2+')',
                                    'color': $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.totalColor):'#fff',
                                    'font-family': viewBlock.totalFont.fontFamily,
                                    'font-size': viewBlock.totalFont.size/100+"rem",
                                    'font-style': viewBlock.totalFont.italic?'italic':'normal',
                                    'font-weight': viewBlock.totalFont.bold?'bold':'normal',
                                    'text-decoration': viewBlock.totalFont.underline?'underline':
                                        (viewBlock.totalFont.strikeout?'line-through':'none')
                                }).find('div').css({
                                    'color': $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.totalColor):'#fff',
                                    'font-family': viewBlock.totalFont.fontFamily,
                                    'font-size': viewBlock.totalFont.size/100+"rem",
                                    'font-style': viewBlock.totalFont.italic?'italic':'normal',
                                    'font-weight': viewBlock.totalFont.bold?'bold':'normal',
                                    'text-decoration': viewBlock.totalFont.underline?'underline':
                                        (viewBlock.totalFont.strikeout?'line-through':'none')
                                });
                            }
                        }
                    }
                })
            });

            for(var i= 0,len=setTotalArry.length;i<len;i++){
                for(var j= 0,jen=setArry.length;j<jen;j++){
                    if(setTotalArry[i].colspan == setArry[j].colspan){
                        $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr[datagrid-row-index='+setTotalArry[i].index+']').css('background-color','rgba('+color+','+0.2+')').find('td div').css('color',$BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.totalColor):'#fff');
                    }
                }
            }
        }

        function setSubTotalColumn(color){
            var subTotalArry = [];

            /*取得所有含有小计或总计的对象（主要取到对应的field和colspan、rowspan）*/
            for(var i= 0,len=me.data.finalTopHeadArryUse.length;i<len;i++){
                for(var j= 0,jen=me.data.finalTopHeadArryUse[i].length;j<jen;j++){
                    if(me.data.finalTopHeadArryUse[i][j].title == '小计' || me.data.finalTopHeadArryUse[i][j].title == '总计'){
                        subTotalArry.push(me.data.finalTopHeadArryUse[i][j]);
                    }
                }
            }

            var color = color;
            var colorRowspanArry = [];

            /*从页面中获取到小计和总计所对应的rowspan并去掉相等的rowspan*/
            $(me.chartID).find('.datagrid-view2 .datagrid-header .datagrid-htable tr').each(function(){
                $(this).find('td').each(function(){
                    var obj = {};
                    var rowspan = parseFloat($(this).attr('rowspan')) || 0;
                    if($(this).find('div').text() == '小计' || $(this).find('div').text() == '总计'){
                        var rowspan = parseFloat($(this).attr('rowspan')) || 0;
                        var colspan = parseFloat($(this).attr('colspan')) || 1;
                        obj.rowspan = rowspan;
                        obj.opacity = '';
                        for (var n= 0,nen=colorRowspanArry.length;n<nen;n++){
                            if (colorRowspanArry[n].rowspan==rowspan){
                                break;
                            }
                        }
                        if (n==nen){
                            colorRowspanArry.push(obj);
                        }
                    }
                });
            });

            /*对数组进行以rowspan为主的从大到小的排序*/
            colorRowspanArry.sort(compare('rowspan'));

            /*对数组对象的opacity属性进行相对应的设置*/
            for(var i= 0,len=colorRowspanArry.length;i<len;i++){
                colorRowspanArry[i].opacity = 0.5-0.1*i;
            }

            /*设置颜色*/
            for(var i= 0,len=subTotalArry.length;i<len;i++){
                var subColspanLength = subTotalArry[i].colspan || 1;
                for(var j=0,jen=subColspanLength;j<jen;j++){
                    var rowspan = subTotalArry[i].rowspan || 0;
                    var opacity = 0;
                    for(var k= 0,ken=colorRowspanArry.length;k<ken;k++){
                        if(rowspan == colorRowspanArry[k].rowspan){
                            opacity =  colorRowspanArry[k].opacity;
                            break;
                        }
                    }
                    $(me.chartID).find('.datagrid-view2 .datagrid-header .datagrid-htable tr td[field='+((parseFloat(subTotalArry[i].field)+j)+'')+']').css('background-color','rgba('+color+','+opacity+')').children().css({
                        'color': $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.totalColor):'#fff',
                        'font-family': viewBlock.totalFont.fontFamily,
                        'font-size': viewBlock.totalFont.size/100+"rem",
                        'font-style': viewBlock.totalFont.italic?'italic':'normal',
                        'font-weight': viewBlock.totalFont.bold?'bold':'normal',
                        'text-decoration': viewBlock.totalFont.underline?'underline':
                            (viewBlock.totalFont.strikeout?'line-through':'none')
                    });
                    $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr td[field='+((parseFloat(subTotalArry[i].field)+j)+'')+']').css({
                        //'background-color': 'rgba('+color+','+opacity+')',
                        'background-color': 'rgba('+color+','+0.2+')',
                        'color': $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.totalColor):'#fff'
                    });
                }
            }

            $(me.chartID).find('.datagrid-view2 .datagrid-header .datagrid-htable tr').each(function(){
                $(this).find('td').each(function(){
                    if($(this).find('div').text() == '小计' || $(this).find('div').text() == '总计'){
                        var rowspan = parseFloat($(this).attr('rowspan')) || 0;
                        for(var i= 0,len=colorRowspanArry.length;i<len;i++){
                            if(rowspan == colorRowspanArry[i].rowspan){
                                $(this).css('background-color','rgba('+color+','+colorRowspanArry[i].opacity+')').find('div').css({
                                    'color': $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.totalColor):'#fff',
                                    'font-family': viewBlock.totalFont.fontFamily,
                                    'font-size': viewBlock.totalFont.size/100+"rem",
                                    'font-style': viewBlock.totalFont.italic?'italic':'normal',
                                    'font-weight': viewBlock.totalFont.bold?'bold':'normal',
                                    'text-decoration': viewBlock.totalFont.underline?'underline':
                                        (viewBlock.totalFont.strikeout?'line-through':'none')
                                });
                            }
                        }
                    }
                });
            });
        }

        function editBorderBug(){
            var leftTdLength = viewBlock.rowDimensions.length;

            if(leftTdLength>1){
                $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr td:last-child').css('border-width','0 0.01rem 0.01rem 0');
                $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr td:first-child').css('border-left-width','0.01rem');
            }else if(leftTdLength == 1){
                $(me.chartID).find('.datagrid-view1 .datagrid-body .datagrid-btable tr td').css('border-width','0 0.01rem 0.01rem 0.01rem');
            }else if(leftTdLength < 1){
                $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr td:first-child').css('border-left-width','0.01rem');
                $(me.chartID).find('.datagrid-view2 .datagrid-header tr td:first-child').css('border-left-width','0.01rem');
            }
        }

        /*数组对象的排序*/
        function compare(prop) {
            return function (obj1, obj2) {
                var val1 = obj1[prop];
                var val2 = obj2[prop];
                if (!isNaN(Number(val1)) && !isNaN(Number(val2))) {
                    val1 = Number(val1);
                    val2 = Number(val2);
                }
                if (val1 < val2) {
                    return 1;
                } else if (val1 > val2) {
                    return -1;
                } else {
                    return 0;
                }
            }
        }

    };

    this.autoRefresh=function(fltHeight){
        this.data = pivotTableData();
        this.draw(fltHeight);
    }
}

/*类----柱状图*/
function Histogram(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.units = '';
    this.data = assignHistogramData();

    function assignHistogramData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var histogramData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        histogramData.y1 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                histogramData.y1 = viewBlock.y1Measures[i][1];
            }
        }

        histogramData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        histogramData.formatString = viewBlock.y1DataFormat;
        histogramData.haveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        histogramData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){histogramData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1Measure.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){histogramData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);/*当前维度对应的分组维度没有产生值*/
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        histogramData.measuresData = collect(y1Measure);

        histogramData.reportLink = viewBlock.reportLink;

        histogramData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: histogramData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        histogramData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        }

        return histogramData;
    }

    this.draw = function (fltHeight,openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}
        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'column',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {text: null},
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return (this.series.name||'') + (this.series.name?'<br>':'')+ (this.x||'') +(this.x?' : ':'')+ $BDA.formatString.number(me.data.formatString,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.12rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            plotOptions: {
                column: {
                    pointWidth: viewBlock.ChartStyle.barWidth?viewBlock.ChartStyle.barWidth:null,
                    borderWidth: 0,
                    stacking: false,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    colorByPoint: viewBlock.ChartStyle.colorByPoint?true:false,
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.12rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                symbolPadding : 5*$BDA.defaultRatio,
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            series: this.data.measuresData
        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                for(var j = 0; j < pointsList.points.length; j++){
                    var obj = {
                        color: {
                            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                            stops: [
                                [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                            ]
                        }
                    };
                    pointsList.points[j].update(obj);
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----堆积柱状图*/
function AccumulateHistogram(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.units = '';
    this.data = assignHistogramData();

    function assignHistogramData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var histogramData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        histogramData.y1 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                histogramData.y1 = viewBlock.y1Measures[i][1];
            }
        }

        histogramData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        histogramData.formatString = viewBlock.y1DataFormat;
        histogramData.haveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        histogramData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){histogramData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1Measure.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){histogramData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        histogramData.measuresData = collect(y1Measure);

        histogramData.reportLink = viewBlock.reportLink;

        histogramData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: histogramData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        histogramData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return histogramData;
    }

    this.draw = function (fltHeight,openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'column',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return (this.series.name||'') + (this.series.name?'<br>':'')+ (this.x||'') +(this.x?' : ':'')+ $BDA.formatString.number(me.data.formatString,this.y);
                    //return (this.series.name||'') + (this.series.name?' : ':'')+$BDA.formatString.number(me.data.formatString,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            plotOptions: {
                column: {
                    stacking: true,
                    borderWidth: 0,
                    pointWidth: viewBlock.ChartStyle.barWidth ? viewBlock.ChartStyle.barWidth : null,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    colorByPoint: viewBlock.ChartStyle.colorByPoint?true:false,
                    states:{
                        hover:{
                            enabled:false
                        },
                        select:{
                            enabled: false
                        }
                    },
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                symbolPadding : 5*$BDA.defaultRatio,
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        //color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        //color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                //lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            series: this.data.measuresData
        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                for(var j = 0; j < pointsList.points.length; j++){
                    var obj = {
                        color: {
                            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                            stops: [
                                [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                            ]
                        }
                    };
                    pointsList.points[j].update(obj);
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----百分比柱状图*/
function PercentHistogram(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.units = '';
    this.data = assignHistogramData();

    function assignHistogramData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var histogramData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                histogramData.y1 = viewBlock.y1Measures[i][1];
            }
        }

        histogramData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        histogramData.formatString = viewBlock.y1DataFormat;
        histogramData.haveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        histogramData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){histogramData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1Measure.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){histogramData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        histogramData.measuresData = collect(y1Measure);

        histogramData.reportLink = viewBlock.reportLink;

        histogramData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: histogramData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        histogramData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return histogramData;
    }

    this.draw = function (fltHeight,openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'column',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return (this.series.name||'') + (this.series.name?'<br>':'')+ (this.x||'') +(this.x?' : ':'')+ $BDA.formatString.number(me.data.formatString,this.y)+",("+this.percentage.toFixed(2) + "%)";
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            plotOptions: {
                column: {
                    stacking: 'percent',
                    borderWidth: 0,
                    pointWidth: viewBlock.ChartStyle.barWidth ? viewBlock.ChartStyle.barWidth : null,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter: function(){
                            return this.percentage.toFixed(2) + "%";
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    colorByPoint: viewBlock.ChartStyle.colorByPoint?true:false,
                    states:{
                        hover:{
                            enabled:false
                        },
                        select:{
                            enabled: false
                        }
                    },
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID) || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0) || viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID) || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0) || viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            series: this.data.measuresData
        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                for(var j = 0; j < pointsList.points.length; j++){
                    var obj = {
                        color: {
                            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                            stops: [
                                [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                            ]
                        }
                    };
                    pointsList.points[j].update(obj);
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----条形图*/
function BarChart(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.units = '';

    this.data = assignBarchartData();

    function assignBarchartData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var barchartData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                barchartData.y1 = viewBlock.y1Measures[i][1];
            }
        }

        barchartData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        barchartData.formatString = viewBlock.y1DataFormat;
        barchartData.haveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        barchartData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){barchartData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1Measure.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){barchartData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        barchartData.measuresData = collect(y1Measure);

        barchartData.reportLink = viewBlock.reportLink;

        barchartData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: barchartData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?barchartData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        barchartData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:barchartData.haveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?barchartData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return barchartData;
    }

    this.draw = function (fltHeight,openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'bar',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            plotOptions: {
                bar: {
                    pointWidth: viewBlock.ChartStyle.barWidth ? viewBlock.ChartStyle.barWidth : null,
                    stacking: false,
                    borderWidth: 0,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    groupPadding: viewBlock.primaryDimension?0.2:0
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    colorByPoint: viewBlock.ChartStyle.colorByPoint?true:false,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID) || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0) || viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID) || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0) || viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            credits: {
                enabled: false
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return (this.series.name||'') + (this.series.name?'<br>':'')+ (this.x||'') +(this.x?' : ':'')+ $BDA.formatString.number(me.data.formatString,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series:  this.data.measuresData
        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                for(var j = 0; j < pointsList.points.length; j++){
                    var obj = {
                        color: {
                            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                            stops: [
                                [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                            ]
                        }
                    };
                    pointsList.points[j].update(obj);
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignBarchartData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignBarchartData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----堆积条形图*/
function AccumulateBarChart(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.units = '';

    this.data = assignBarchartData();

    function assignBarchartData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var barchartData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        barchartData.y1 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                barchartData.y1 = viewBlock.y1Measures[i][1];
            }
        }

        barchartData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        barchartData.formatString = viewBlock.y1DataFormat;
        barchartData.haveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        barchartData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){barchartData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1Measure.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){barchartData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        barchartData.measuresData = collect(y1Measure);

        barchartData.reportLink = viewBlock.reportLink;

        barchartData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: barchartData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?barchartData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        barchartData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:barchartData.haveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?barchartData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return barchartData;
    }

    this.draw = function (fltHeight,openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'bar',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            plotOptions: {
                bar: {
                    stacking: true,
                    borderWidth: 0,
                    pointWidth: viewBlock.ChartStyle.barWidth ? viewBlock.ChartStyle.barWidth : null,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    colorByPoint: viewBlock.ChartStyle.colorByPoint?true:false,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID) || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0) || viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID) || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0) || viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            credits: {
                enabled: false
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return (this.series.name||'') + (this.series.name?'<br>':'')+ (this.x||'') +(this.x?' : ':'')+ $BDA.formatString.number(me.data.formatString,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series:  this.data.measuresData

        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                for(var j = 0; j < pointsList.points.length; j++){
                    var obj = {
                        color: {
                            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                            stops: [
                                [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                            ]
                        }
                    };
                    pointsList.points[j].update(obj);
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignBarchartData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignBarchartData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----百分比条形图*/
function PercentBarChart(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.units = '';

    this.data = assignBarchartData();

    function assignBarchartData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var barchartData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        barchartData.y1 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                barchartData.y1 = viewBlock.y1Measures[i][1];
            }
        }

        barchartData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        barchartData.formatString = viewBlock.y1DataFormat;
        barchartData.haveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        barchartData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){barchartData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1Measure.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){barchartData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        barchartData.measuresData = collect(y1Measure);

        barchartData.reportLink = viewBlock.reportLink;

        barchartData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: barchartData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?barchartData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        barchartData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:barchartData.haveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?barchartData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return barchartData;
    }

    this.draw = function (fltHeight,openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'bar',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            plotOptions: {
                bar: {
                    stacking: 'percent',
                    borderWidth: 0,
                    pointWidth: viewBlock.ChartStyle.barWidth ? viewBlock.ChartStyle.barWidth : null,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter: function(){
                            return this.percentage.toFixed(2) + "%";
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    colorByPoint: viewBlock.ChartStyle.colorByPoint?true:false,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID) || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0) || viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID) || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0) || viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            credits: {
                enabled: false
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return (this.series.name||'') + (this.series.name?'<br>':'')+ (this.x||'') +(this.x?' : ':'')+ $BDA.formatString.number(me.data.formatString,this.y)+",("+this.percentage.toFixed(2) + "%)";
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series:  this.data.measuresData

        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                for(var j = 0; j < pointsList.points.length; j++){
                    var obj = {
                        color: {
                            linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                            stops: [
                                [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                            ]
                        }
                    };
                    pointsList.points[j].update(obj);
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignBarchartData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignBarchartData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----折线图*/
function LineGraph(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.units = '';
    this.loopTimer = null;
    this.data = assignLineGraphData();

    function assignLineGraphData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var lineGraphData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        lineGraphData.y1 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                lineGraphData.y1=viewBlock.y1Measures[i][1];
            }
        }

        lineGraphData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        lineGraphData.formatString = viewBlock.y1DataFormat;
        lineGraphData.haveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        lineGraphData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){lineGraphData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1Measure.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){lineGraphData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        lineGraphData.measuresData = collect(y1Measure);

        lineGraphData.reportLink = viewBlock.reportLink;

        lineGraphData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: lineGraphData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?lineGraphData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        lineGraphData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:lineGraphData.haveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?lineGraphData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return lineGraphData;
    }

    this.draw = function (fltHeight,openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: viewBlock.ChartStyle.smooth?'spline':'line',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            plotOptions: {
                series: {
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    marker: {
                        radius: 2,
                        symbol:"circle"
                    },
                    states:{
                        hover:{
                            enabled: viewBlock.ChartStyle.carouselTooltip?viewBlock.ChartStyle.carouselTooltip:false
                        },
                        select:{
                            enabled: false
                        }
                    },
                    lineWidth: viewBlock.ChartStyle.lineWidth?viewBlock.ChartStyle.lineWidth*$BDA.defaultRatio:2*$BDA.defaultRatio,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                shared: viewBlock.ChartStyle.carouselTooltip?viewBlock.ChartStyle.carouselTooltip:false,
                enabled: viewBlock.ChartStyle.dataHoverShow,
                //formatter:function(){
                //    if(viewBlock.ChartStyle.carouselTooltip && viewBlock.ChartStyle.carouselTooltip == false){
                //        return this.series.name +'<br>'+ (this.x||'') +(this.x?' : ':'')+$BDA.formatString.number(me.data.formatString,this.y);
                //    }
                //},
                headerFormat: '',
                pointFormatter: function(){
                    if(viewBlock.ChartStyle.carouselTooltip){
                        return "<span style='color:"+this.color+"'>\u25CF</span>"+this.series.name+": <b>"+$BDA.formatString.number(me.data.formatString,this.y)+"</b><br/>";
                    }else{
                        return this.series.name + ": " +$BDA.formatString.number(me.data.formatString,this.y);
                    }
                },
                style: {
                    color: $BDA.theme.themeID?"#F0F0F0":viewBlock.ChartStyle.dataHoverColor?$BDA.csharp2rgba(viewBlock.ChartStyle.dataHoverColor):"#333",
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                },
                backgroundColor: viewBlock.ChartStyle.tooltipBackgroundColor?$BDA.csharp2rgba(viewBlock.ChartStyle.tooltipBackgroundColor):"rgba(247,247,247,0.85)",
                borderColor: viewBlock.ChartStyle.tooltipBorderColor&&viewBlock.ChartStyle.tooltipBorderColor!="null"?$BDA.csharp2rgba(viewBlock.ChartStyle.tooltipBorderColor):null,
                borderWidth: viewBlock.ChartStyle.tooltipBorderWidth?viewBlock.ChartStyle.tooltipBorderWidth:1,
                padding: (viewBlock.ChartStyle.tooltipPadding?viewBlock.ChartStyle.tooltipPadding:8)*$BDA.defaultRatio
            },
            series: this.data.measuresData
        });

        if(viewBlock.ChartStyle.carouselTooltip){
            loop();
        }

        function loop() {
            var activePoint = 0;
            clearInterval(me.loopTimer);
            me.loopTimer = null;
            me.loopTimer = setInterval(function() {
                if (activePoint === me.highchart.series[0].data.length) {
                    activePoint = 0;
                }
                var arr = [];
                for(var i = 0; i < me.highchart.series.length; i++){
                    arr.push(me.highchart.series[i].data[activePoint]);
                }
                me.highchart.tooltip.refresh(arr);
                addPlot(activePoint);
                activePoint++;
            }, viewBlock.ChartStyle.carouselInterval * 1000);
        }
// 通过变量activePoint设置标识区/标识线位置
        function addPlot(activePoint) {
            me.highchart.xAxis[0].removePlotLine();
            me.highchart.xAxis[0].addPlotLine({
                value: activePoint,
                color: '#0DD4F5',
                width: 1,
                dashStyle: "Solid",
                zIndex: 1,
            });
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignLineGraphData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignLineGraphData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----面积图*/
function AreaGraph( strType, strBDAChartID, strTitle , viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.units = '';
    this.loopTimer = null;
    this.data = assignAreaGraphData();

    function assignAreaGraphData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var areaGraphData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        areaGraphData.y1 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                areaGraphData.y1 = viewBlock.y1Measures[i][1];
            }
        }

        areaGraphData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        areaGraphData.formatString = viewBlock.y1DataFormat;
        areaGraphData.haveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        areaGraphData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){areaGraphData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1Measure.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){areaGraphData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        areaGraphData.measuresData = collect(y1Measure);

        areaGraphData.reportLink = viewBlock.reportLink;

        areaGraphData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: areaGraphData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?areaGraphData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        areaGraphData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:areaGraphData.haveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?areaGraphData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return areaGraphData;
    }

    this.draw = function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'area',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            plotOptions: {
                area: {
                    marker: {
                        symbol: 'circle',
                        radius: 0
                    },
                    //fillOpacity: 0.4,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    states:{
                        hover:{
                            enabled: viewBlock.ChartStyle.carouselTooltip?!viewBlock.ChartStyle.carouselTooltip:true,
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    lineWidth: viewBlock.ChartStyle.lineWidth?viewBlock.ChartStyle.lineWidth*$BDA.defaultRatio:2*$BDA.defaultRatio,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                shared: viewBlock.ChartStyle.carouselTooltip?viewBlock.ChartStyle.carouselTooltip:false,
                enabled: viewBlock.ChartStyle.dataHoverShow,
                //formatter:function(){
                //    return this.series.name + '<br>' + (this.x||'') + (this.x?' : ':'')+$BDA.formatString.number(me.data.formatString,this.y);
                //},
                headerFormat: '',
                pointFormatter: function(){
                    if(viewBlock.ChartStyle.carouselTooltip){
                        return "<span style='color:"+this.color+"'>\u25CF</span> "+this.series.name+": <b>"+$BDA.formatString.number(me.data.formatString,this.y)+"</b><br/>";
                    }else{
                        return this.series.name + ": " +$BDA.formatString.number(me.data.formatString,this.y);
                    }
                },
                style: {
                    color: $BDA.theme.themeID?"#F0F0F0":viewBlock.ChartStyle.dataHoverColor?$BDA.csharp2rgba(viewBlock.ChartStyle.dataHoverColor):"#333",
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                },
                backgroundColor: viewBlock.ChartStyle.tooltipBackgroundColor?$BDA.csharp2rgba(viewBlock.ChartStyle.tooltipBackgroundColor):"rgba(247,247,247,0.85)",
                borderColor: viewBlock.ChartStyle.tooltipBorderColor&&viewBlock.ChartStyle.tooltipBorderColor!="null"?$BDA.csharp2rgba(viewBlock.ChartStyle.tooltipBorderColor):null,
                borderWidth: viewBlock.ChartStyle.tooltipBorderWidth?viewBlock.ChartStyle.tooltipBorderWidth:1,
                padding: (viewBlock.ChartStyle.tooltipPadding?viewBlock.ChartStyle.tooltipPadding:8)*$BDA.defaultRatio,
                shape: 'callout'
            },
            series:  this.data.measuresData
        }, function (chart) {
            SetEveryOnePointColor(chart);
        });

        if (viewBlock.ChartStyle.carouselTooltip){
            loop();
        }

        function SetEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                pointsList.update({
                    fillColor: {
                        linearGradient: { x1: 0, y1: 0, x2: 0, y2: 1 },
                        stops: [
                            [0,Highcharts.Color(chart.options.colors[i]).setOpacity(.2).get('rgba')],
                            [1,Highcharts.Color(chart.options.colors[i]).setOpacity(0).get('rgba')]
                        ]
                    }
                });
            }
        }

        function loop() {
            var activePoint = 0;
            clearInterval(me.loopTimer);
            me.loopTimer = null;
            me.loopTimer = setInterval(function() {
                if (me.highchart.series){
                    if (activePoint === me.highchart.series[0].data.length) {
                        activePoint = 0;
                    }
                    var arr = [];
                    for (var i = 0; i < me.highchart.series.length; i++) {
                        arr.push(me.highchart.series[i].data[activePoint]);
                    }
                    me.highchart.tooltip.refresh(arr);
                    addPlot(activePoint);
                    activePoint++;
                }
                
            }, viewBlock.ChartStyle.carouselInterval * 1000);
        }
// 通过变量activePoint设置标识区/标识线位置
        function addPlot(activePoint) {
            me.highchart.xAxis[0].removePlotLine();
            me.highchart.xAxis[0].addPlotLine({
                value: activePoint,
                color: '#0DD4F5',
                width: 1,
                dashStyle: "Solid",
                zIndex: 1
            });
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignAreaGraphData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignAreaGraphData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----柱线图*/
function HistogramLine(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignHistogramData();

    function assignHistogramData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var histogramData = {};
        var isAddMeasureName = false;

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var y2Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        histogramData.y1 = '';
        histogramData.y2 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                histogramData.y1 = viewBlock.y1Measures[i][1];
            }
        }
        for(var i= 0,len=viewBlock.y2Measures.length;i<len;i++){
            y2Measure.push(viewBlock.y2Measures[i][0]+'___'+viewBlock.y2Measures[i][1]);
            if(i==0){
                histogramData.y2 = viewBlock.y2Measures[i][1];
            }
        }
        if(y1Measure.length > 1 || y2Measure.length > 1 || (y1Measure.length&&y2Measure.length)){
            isAddMeasureName = true;
        }

        histogramData.y1DataFormat = viewBlock.y1DataFormat;
        histogramData.y2DataFormat = viewBlock.y2DataFormat;
        histogramData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        histogramData.xAxis = xAxis;
        histogramData.haveNegativeY1 =false;
        histogramData.haveNegativeY2 =false;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis,haveY2){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    if (!haveY2){
                        obj.yAxis = 1;
                        obj.type = 'column';
                    }
                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (!haveY2){
                                    if (blockData[h][yAxis[i]]<0){histogramData.haveNegativeY1=true;}
                                }else {
                                    if (blockData[h][yAxis[i]]<0){histogramData.haveNegativeY2=true;}
                                }
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = isAddMeasureName?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            if (!haveY2){
                                obj.yAxis = 1;
                                obj.type = 'column';
                            }
                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (!haveY2){
                                            if (blockData[k][yAxis[i]]<0){histogramData.haveNegativeY1=true;}
                                        }else {
                                            if (blockData[k][yAxis[i]]<0){histogramData.haveNegativeY2=true;}
                                        }
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        histogramData.measuresData = collect(y1Measure,false).concat(collect(y2Measure,true));

        histogramData.reportLink = viewBlock.reportLink;

        histogramData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: histogramData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        histogramData.yAxisStyle = [{
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegativeY2?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y2:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
            lineColor: viewBlock.ChartStyle.y2ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y2ScaleLineColor):'#ccd6eb',
            opposite: true,
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        },{
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegativeY1?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        }];

        return histogramData;
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart:{
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:[{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegativeY2?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y2:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
                opposite: true,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegativeY1?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            }],
            plotOptions: {
                line: {
                    lineWidth: viewBlock.ChartStyle.lineWidth?viewBlock.ChartStyle.lineWidth:2,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.y2DataFormat,this.y);
                        }
                    }
                },
                column: {
                    colorByPoint: viewBlock.ChartStyle.colorByPoint ? true : false,
                    pointWidth: viewBlock.ChartStyle.barWidth ? viewBlock.ChartStyle.barWidth : null,
                    //stacking: 'normal',
                    borderWidth: 0,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.y1DataFormat,this.y);
                        }
                    }
                },
                series: {
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    dataLabels:{
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.series.name +'<br>'+ (this.x||'') +(this.x?' : ':'')+$BDA.formatString.number(this.point.shapeType=='rect'?me.data.y1DataFormat:me.data.y2DataFormat,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: this.data.measuresData
        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                if(pointsList.options.type && pointsList.options.type.indexOf("column") != -1) {
                    for (var j = 0; j < pointsList.points.length; j++) {
                        var obj = {
                            color: {
                                linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1},
                                stops: [
                                    [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                    [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                                ]
                            }
                        };
                        pointsList.points[j].update(obj);
                    }
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----堆积柱线图*/
function AccumulateHistogramLine(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignHistogramData();

    function assignHistogramData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var histogramData = {};
        var isAddMeasureName = false;

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var y2Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        histogramData.y1 = '';
        histogramData.y2 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                histogramData.y1 = viewBlock.y1Measures[i][1];
            }
        }
        for(var i= 0,len=viewBlock.y2Measures.length;i<len;i++){
            y2Measure.push(viewBlock.y2Measures[i][0]+'___'+viewBlock.y2Measures[i][1]);
            if(i==0){
                histogramData.y2 = viewBlock.y2Measures[i][1];
            }
        }
        if(y1Measure.length > 1 || y2Measure.length > 1 || (y1Measure.length&&y2Measure.length)){
            isAddMeasureName = true;
        }

        histogramData.y1DataFormat = viewBlock.y1DataFormat;
        histogramData.y2DataFormat = viewBlock.y2DataFormat;
        histogramData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        histogramData.xAxis = xAxis;
        histogramData.haveNegativeY1 =false;
        histogramData.haveNegativeY2 =false;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis,haveY2){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    if (!haveY2){
                        obj.yAxis = 1;
                        obj.type = 'column';
                    }
                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (!haveY2){
                                    if (blockData[h][yAxis[i]]<0){histogramData.haveNegativeY1=true;}
                                }else {
                                    if (blockData[h][yAxis[i]]<0){histogramData.haveNegativeY2=true;}
                                }
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = isAddMeasureName?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            if (!haveY2){
                                obj.yAxis = 1;
                                obj.type = 'column';
                            }
                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (!haveY2){
                                            if (blockData[k][yAxis[i]]<0){histogramData.haveNegativeY1=true;}
                                        }else {
                                            if (blockData[k][yAxis[i]]<0){histogramData.haveNegativeY2=true;}
                                        }
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        histogramData.measuresData = collect(y1Measure,false).concat(collect(y2Measure,true));

        histogramData.reportLink = viewBlock.reportLink;

        histogramData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: histogramData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        histogramData.yAxisStyle = [{
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegativeY2?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y2:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
            lineColor: viewBlock.ChartStyle.y2ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y2ScaleLineColor):'#ccd6eb',
            opposite: true,
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        },{
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegativeY1?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        }];

        return histogramData;
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart:{
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:[{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegativeY2?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y2:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
                opposite: true,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegativeY1?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            }],
            plotOptions: {
                line: {
                    lineWidth: viewBlock.ChartStyle.lineWidth?viewBlock.ChartStyle.lineWidth:2,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.y2DataFormat,this.y);
                        }
                    }
                },
                column: {
                    colorByPoint: viewBlock.ChartStyle.colorByPoint ? true : false,
                    pointWidth: viewBlock.ChartStyle.barWidth ? viewBlock.ChartStyle.barWidth : null,
                    stacking: 'normal',
                    borderWidth: 0,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.y1DataFormat,this.y);
                        }
                    }
                },
                series: {
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    dataLabels:{
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.series.name +'<br>'+ (this.x||'') +(this.x?' : ':'')+$BDA.formatString.number(this.point.shapeType=='rect'?me.data.y1DataFormat:me.data.y2DataFormat,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: this.data.measuresData
        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                if(pointsList.options.type && pointsList.options.type.indexOf("column") != -1) {
                    for (var j = 0; j < pointsList.points.length; j++) {
                        var obj = {
                            color: {
                                linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1},
                                stops: [
                                    [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                    [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                                ]
                            }
                        };
                        pointsList.points[j].update(obj);
                    }
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----百分比堆积柱线图*/
function PercentHistogramLine(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignHistogramData();

    function assignHistogramData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var histogramData = {};
        var isAddMeasureName = false;

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1Measure = [];
        var y2Measure = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        histogramData.y1 = '';
        histogramData.y2 = '';
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                histogramData.y1 = viewBlock.y1Measures[i][1];
            }
        }
        for(var i= 0,len=viewBlock.y2Measures.length;i<len;i++){
            y2Measure.push(viewBlock.y2Measures[i][0]+'___'+viewBlock.y2Measures[i][1]);
            if(i==0){
                histogramData.y2 = viewBlock.y2Measures[i][1];
            }
        }
        if(y1Measure.length > 1 || y2Measure.length > 1 || (y1Measure.length&&y2Measure.length)){
            isAddMeasureName = true;
        }

        histogramData.y1DataFormat = viewBlock.y1DataFormat;
        histogramData.y2DataFormat = viewBlock.y2DataFormat;
        histogramData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        histogramData.xAxis = xAxis;
        histogramData.haveNegativeY1 =false;
        histogramData.haveNegativeY2 =false;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis,haveY2){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    if (!haveY2){
                        obj.yAxis = 1;
                        obj.type = 'column';
                    }
                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (!haveY2){
                                    if (blockData[h][yAxis[i]]<0){histogramData.haveNegativeY1=true;}
                                }else {
                                    if (blockData[h][yAxis[i]]<0){histogramData.haveNegativeY2=true;}
                                }
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = isAddMeasureName?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            if (!haveY2){
                                obj.yAxis = 1;
                                obj.type = 'column';
                            }
                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (!haveY2){
                                            if (blockData[k][yAxis[i]]<0){histogramData.haveNegativeY1=true;}
                                        }else {
                                            if (blockData[k][yAxis[i]]<0){histogramData.haveNegativeY2=true;}
                                        }
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        histogramData.measuresData = collect(y1Measure,false).concat(collect(y2Measure,true));

        histogramData.reportLink = viewBlock.reportLink;

        histogramData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: histogramData.xAxis[0],
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        histogramData.yAxisStyle = [{
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegativeY2?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y2:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
            lineColor: viewBlock.ChartStyle.y2ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y2ScaleLineColor):'#ccd6eb',
            opposite: true,
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        },{
            visible: viewBlock.ChartStyle.showTickValue,
            min:histogramData.haveNegativeY1?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?histogramData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        }];

        return histogramData;
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart:{
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis[0],
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:[{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegativeY2?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y2:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
                opposite: true,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegativeY1?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            }],
            plotOptions: {
                line: {
                    lineWidth: viewBlock.ChartStyle.lineWidth?viewBlock.ChartStyle.lineWidth:2,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.y2DataFormat,this.y);
                        }
                    }
                },
                column: {
                    colorByPoint: viewBlock.ChartStyle.colorByPoint ? true : false,
                    pointWidth: viewBlock.ChartStyle.barWidth ? viewBlock.ChartStyle.barWidth : null,
                    stacking: 'percent',
                    borderWidth: 0,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return this.percentage.toFixed(2) + "%";
                            //return $BDA.formatString.number(me.data.y1DataFormat,this.y);
                        }
                    }
                },
                series: {
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    dataLabels: {
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.series.name +'<br>'+ (this.x||'') +(this.x?' : ':'')+$BDA.formatString.number(this.point.shapeType=='rect'?me.data.y1DataFormat:me.data.y2DataFormat,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: this.data.measuresData
        }, function (chart) {
            if(viewBlock.ChartStyle.colorGradual){
                setEveryOnePointColor(chart);
            }
        });

        function setEveryOnePointColor(chart) {
            for(var i = 0; i < chart.series.length; i++){
                var pointsList = chart.series[i];
                if(pointsList.options.type && pointsList.options.type.indexOf("column") != -1) {
                    for (var j = 0; j < pointsList.points.length; j++) {
                        var obj = {
                            color: {
                                linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1},
                                stops: [
                                    [0,Highcharts.Color(pointsList.points[j].series.color).setOpacity(1).get('rgba')],
                                    [1,Highcharts.Color(pointsList.points[j].series.color).setOpacity(0).get('rgba')]
                                ]
                            }
                        };
                        pointsList.points[j].update(obj);
                    }
                }
            }
        }
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignHistogramData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----饼图*/
function PieChart(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.data = assignPieData();
    function assignPieData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var pieData = {};
        var blockData = viewBlock.blockDataToDraw;
        var intLength = blockData.length;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
        }
        pieData.items = [];
        pieData.formatString = viewBlock.y1DataFormat;
        for(var intI = 0; intI < intLength; intI++){
            var item = {};

            item.name = blockData[intI][primaryDimensionName];
            item.y = viewBlock.y1Measures.length?blockData[intI][(viewBlock.y1Measures[0][0]+'___'+viewBlock.y1Measures[0][1])]:null;

            pieData.items.push(item);
        }
        pieData.reportLink = viewBlock.reportLink;

        return pieData;
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies, autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                plotBorderWidth: null,
                pltShadow: false
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            plotOptions:{
                pie:{
                    borderColor: "",
                    // size: "75%",
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        distance: viewBlock.ChartStyle.dataLabel.position*$BDA.defaultRatio,
                        connectorWidth: viewBlock.ChartStyle.connectorWidth?viewBlock.ChartStyle.connectorWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                        formatter: function(){
                            var str = '';

                            if(viewBlock.ChartStyle.dataLabel.showValue){
                                str = $BDA.formatString.number(me.data.formatString,this.y)+'';
                            }
                            if(viewBlock.ChartStyle.dataLabel.showPercentage){
                                str == '' ? str=(Math.round(this.percentage) +'%') : (str = str + ', '+ Math.round(this.percentage) +'%');
                            }
                            if(viewBlock.ChartStyle.dataLabel.showDimension){
                                str == '' ? str = this.key : (str = this.key + ', ' + str);
                            }

                            return str;
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                        /*format: (viewBlock.ChartStyle.legendShow?'':'<b>{point.name}</b>:')+ '{point.percentage:.1f} %'*/
                    },
                    slicedOffset: 5,
                    showInLegend: viewBlock.ChartStyle.legendShow
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                labelFormatter: function () {
                    if(viewBlock.ChartStyle.showDataInLegend){
                        var str = this.name;
                        if(viewBlock.ChartStyle.dataLabel.showPercentage){
                            str = str + " " + Math.round(this.percentage) +'%'
                        }
                        if(viewBlock.ChartStyle.dataLabel.showValue){
                            str = str+"<br><span style='font-size:"+viewBlock.ChartStyle.dataFont.size/100+"rem;font-weight:"+(viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold')+";color:"+$BDA.csharp2rgba(viewBlock.ChartStyle.dataColor)+"'>"+$BDA.formatString.number(me.data.formatString,this.y)+"</span>"
                        }
                        return str;
                    }else{
                        return this.name;
                    }
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter: function(){
                    var str = this.key + ', ' + $BDA.formatString.number(me.data.formatString,this.y) + ', '+ Math.round(this.percentage) +'%';
                    return str;
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: [{
                type:'pie',
                data:this.data.items
            }]
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignPieData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignPieData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----圆环图*/
function Doughnut(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignDoughnutData();

    function Sum() {
        if (!viewBlock.y1Measures.length) {
            return;
        }
        var sum = 0;
        var blockData = viewBlock.blockDataToDraw;
        var intLength = blockData.length;
        var intI = 0;

        for (intI = 0; intI < intLength; intI++) {
            sum += blockData[intI][(viewBlock.y1Measures[0][0] + '___' + viewBlock.y1Measures[0][1])] || 0;
        }
        return sum;
    }

    function assignDoughnutData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var doughnutData = {};
        var blockData = viewBlock.blockDataToDraw;
        var intLength = blockData.length;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
        }
        var intI = 0;

        doughnutData.sum = Sum();
        doughnutData.itemCount = intLength;
        doughnutData.items = [];
        doughnutData.formatString = viewBlock.y1DataFormat;

        for(intI = 0; intI < intLength; intI++){
            var item = {};

            item.name = blockData[intI][primaryDimensionName];
            item.y = viewBlock.y1Measures.length?blockData[intI][(viewBlock.y1Measures[0][0]+'___'+viewBlock.y1Measures[0][1])]:null;
            item.percent = item.y / doughnutData.sum;

            doughnutData.items.push(item);
        }

        doughnutData.reportLink = viewBlock.reportLink;

        return doughnutData;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var chartTitle = assignTitle();
        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                plotBorderWidth: 0,
                plotShadow: false
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                //floating: viewBlock.ChartStyle.subtitleInCircle,
                text: null,
                align: 'center',
                //verticalAlign: 'top',
                style:{
                    color: $BDA.csharp2rgba(viewBlock.subtitleTextBox.color),
                    fontFamily: viewBlock.subtitleTextBox.font.fontFamily,
                    fontSize:  viewBlock.subtitleTextBox.font.size*$BDA.defaultRatio,
                    fontWeight:  viewBlock.subtitleTextBox.font.bold?'bold':'normal',
                    fontStyle: viewBlock.subtitleTextBox.font.italic?'italic':'normal',
                    textDecoration: viewBlock.subtitleTextBox.font.underline?'underline':(viewBlock.subtitleTextBox.font.strikeout?'line-through':'none')
                }
            },
            plotOptions: {
                pie: {
                    borderColor: "",
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        distance: viewBlock.ChartStyle.dataLabel.position*$BDA.defaultRatio,
                        connectorWidth: viewBlock.ChartStyle.connectorWidth?viewBlock.ChartStyle.connectorWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                        formatter: function(){
                            var str = '';

                            if(viewBlock.ChartStyle.dataLabel.showValue){
                                str = $BDA.formatString.number(me.data.formatString,this.y)+'';
                            }
                            if(viewBlock.ChartStyle.dataLabel.showPercentage){
                                str == '' ? str=(Math.round(this.percentage) +'%') : (str = str + ', '+ Math.round(this.percentage) +'%');
                            }
                            if(viewBlock.ChartStyle.dataLabel.showDimension){
                                str == '' ? str = this.key : (str = this.key + ', ' + str);
                            }

                            return str;
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    slicedOffset: 5,
                    showInLegend: viewBlock.ChartStyle.legendShow
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 10*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                itemMarginBottom: 8*$BDA.defaultRatio,
                labelFormatter: function () {
                    if(viewBlock.ChartStyle.showDataInLegend){
                        var str = this.name;
                        if(viewBlock.ChartStyle.dataLabel.showPercentage){
                            str = str + " " + Math.round(this.percentage) +'%'
                        }
                        if(viewBlock.ChartStyle.dataLabel.showValue){
                            str = str+"<br><span style='font-size:"+viewBlock.ChartStyle.dataFont.size/100+"rem;font-weight:"+(viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold')+";color:"+$BDA.csharp2rgba(viewBlock.ChartStyle.dataColor)+"'>"+$BDA.formatString.number(me.data.formatString,this.y)+"</span>"
                        }
                        return str;
                    }else{
                        return this.name;
                    }
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter: function(){
                    var str = (this.key?(this.key + ', '):'') + $BDA.formatString.number(me.data.formatString,this.y) + ', '+ Math.round(this.percentage) +'%';
                    return str;
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: [{
                type:'pie',
                data:this.data.items,
                innerSize: (viewBlock.ChartStyle.innerSize?viewBlock.ChartStyle.innerSize:0.5)*100+"%"
            }]
        }, function (chart) { // on complete
            if(viewBlock.ChartStyle.subtitleInCircle){
                var pie = chart.series[0],
                    left = chart.plotLeft + pie.center[0],
                    brLength = chartTitle.split("<br/>").length - 1,
                    top = chart.plotTop + pie.center[1] - viewBlock.subtitleTextBox.font.size * $BDA.defaultRatio * brLength;
                chart.renderer.text(chartTitle, left, top).attr({ 'text-anchor': 'middle','class': 'render-title','zIndex': '99'}).css({
                    color: $BDA.csharp2rgba(viewBlock.subtitleTextBox.color),
                    fontFamily: viewBlock.subtitleTextBox.font.fontFamily,
                    fontSize:  viewBlock.subtitleTextBox.font.size/100+"rem",
                    fontWeight:  viewBlock.subtitleTextBox.font.bold?'bold':'normal',
                    fontStyle: viewBlock.subtitleTextBox.font.italic?'italic':'normal',
                    textDecoration: viewBlock.subtitleTextBox.font.underline?'underline':(viewBlock.subtitleTextBox.font.strikeout?'line-through':'none')
                }).add();
            }
        });
        $(this.chartID).find(".render-title tspan").attr("dy",15*$BDA.defaultRatio);

        function assignTitle(){
            var centerTitle = "";
            if(!viewBlock.subtitle){return centerTitle;}
            viewBlock.subtitleExpression = $.trim(viewBlock.subtitleExpression);
            if(viewBlock.subtitleExpression.indexOf("=") != -1 && viewBlock.subtitleExpression.indexOf("=") == 0){
                var titleArr = viewBlock.subtitleExpression.split("+");
                titleArr[0] = titleArr[0].substr(1,titleArr[0].length-1);
                $.each(titleArr,function(i){
                    titleArr[i] = $.trim(titleArr[i]);
                    if(titleArr[i].indexOf("[") != -1){
                        titleArr[i] = titleArr[i].replace(/\s*/g,"");
                        var queryName = (titleArr[i].match(/\[(.+?)\]/g))[0];
                        queryName = queryName.substr(1,queryName.length-2);
                        var objcecName = (titleArr[i].match(/\[(.+?)\]/g))[1];
                        objcecName = objcecName.substr(1,objcecName.length-2);
                        if(titleArr[i].indexOf("Linkage(") != -1){
                            for(var j = 0; j < viewBlock.linkageParameters.length; j++){
                                if(queryName == viewBlock.linkageParameters[j].queryName && objcecName == viewBlock.linkageParameters[j].dimensionName){
                                    if(viewBlock.linkageParameters[j].dataType == 1){
                                        titleArr[i] = $BDA.formatString.date("",new Date(viewBlock.linkageParameters[j].dimensionValue));
                                    }else{
                                        titleArr[i] = viewBlock.linkageParameters[j].dimensionValue;
                                    }
                                    break;
                                }
                            }
                        }
                        if(titleArr[i].indexOf("Sum(") != -1){
                            var sum = 0;
                            for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
                                sum += (viewBlock.blockDataToDraw[j][queryName+"___"+objcecName]?viewBlock.blockDataToDraw[j][queryName+"___"+objcecName]:0);
                            }
                            titleArr[i] = $BDA.formatString.number(me.data.formatString,sum)+"";
                        }
                        if(titleArr[i] != "Invalid Date"){
                            if(titleArr[i].indexOf("[") != -1){ titleArr[i] = "";}//linkageParameters没有包含当前参数;
                        }
                    }else{
                        titleArr[i] = titleArr[i].substr(1,titleArr[i].length-2);
                    }
                });
                centerTitle = titleArr.join("");
            }else{
                centerTitle = viewBlock.subtitleExpression;
            }

            return centerTitle;
        }
    };

    this.refreshByLinkage=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignDoughnutData();
        me.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignDoughnutData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----仪表盘*/
function Gauge(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.data = asignGaugeData();

    function asignGaugeData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var gaugeData = {};
        gaugeData.warning = viewBlock.viewGaugeWarning;
        gaugeData.measureName = viewBlock.measure?(viewBlock.measure[0]+'___'+viewBlock.measure[1]):null;
        gaugeData.measureData = viewBlock.blockDataToDraw[0][gaugeData.measureName];
        gaugeData.targetMeasureName = gaugeData.warning.targetMeasure?(gaugeData.warning.targetMeasure[0]+'___'+gaugeData.warning.targetMeasure[1]):null;
        gaugeData.targetMeasureData = viewBlock.blockDataToDraw[0][gaugeData.targetMeasureName];
        gaugeData.formatString = viewBlock.formatString;
        gaugeData.min = 0;
        gaugeData.max = gaugeData.measureData*2;
        gaugeData.plotBands = [];
        gaugeData.color = '';

        if (gaugeData.warning.warningEnabled){
            /*若有警告区间，则修改，min和max,以及plotBands*/
            var intervals = gaugeData.warning.intervals;
            var intervalsLength = intervals.length;
            gaugeData.max = gaugeData.measureData;

            for (var i=0;i<intervalsLength;i++){
                var obj = {
                    from:intervals[i].fromThreshold*(gaugeData.warning.thresholdType?gaugeData.targetMeasureData/100:1),
                    to:intervals[i].endThreshold*(gaugeData.warning.thresholdType?gaugeData.targetMeasureData/100:1),
                    color:$BDA.csharp2rgba(intervals[i].color)
                };
                gaugeData.plotBands.push(obj);
                if (gaugeData.measureData>obj.from&&gaugeData.measureData<obj.to){
                    gaugeData.color = obj.color;
                }
            }

            gaugeData.min = gaugeData.plotBands[0].from;
            if (gaugeData.min>gaugeData.measureData){
                gaugeData.min = gaugeData.measureData;
                gaugeData.plotBands[0].from = gaugeData.min;
                gaugeData.color = gaugeData.plotBands[0].color;
            }

            gaugeData.max = gaugeData.plotBands[intervalsLength-1].to;
            if (gaugeData.max<gaugeData.measureData){
                gaugeData.max = gaugeData.measureData;
                gaugeData.plotBands[intervalsLength-1].to = gaugeData.max;
                gaugeData.color = gaugeData.plotBands[intervalsLength-1].color;
            }
        }
        gaugeData.reportLink = viewBlock.reportLink;

        return gaugeData;
    }

    this.draw = function (fltHeight,openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        $(this.chartID).find(".chart-drill-toolbar").hide();
        this.setChartContentHeight(fltHeight);
        //var screenHeight = fltHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        //$(this.chartID).find(".bda-chart-content").css("height",screenHeight/(100*$BDA.defaultRatio)+"rem");

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'gauge',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null
            },
            title: {
                text: null
            },
            pane: {
                startAngle: -120,
                endAngle: 120
            },
            plotOptions: {
                gauge: {
                    dataLabels: {
                        allowOverlap: true,
                        formatter: function () {
                            return $BDA.formatString.number(me.data.formatString, this.y);
                        }
                    }
                },
                series: {
                    animation: autoRefreshAnimation,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            /* the value axis*/
            yAxis: {
                min: this.data.min,
                max: this.data.max,
                minorTickInterval: 'auto',
                minorTickWidth: 1,
                minorTickLength: 10,
                minorTickPosition: 'inside',
                minorTickColor: '#666',
                tickPixelInterval: 30,
                tickWidth: 2,
                tickPosition: 'inside',
                tickLength: 10,
                tickColor: '#666',
                labels: {
                    step: 2,
                    rotation: 'auto'
                },
                title: {
                    text: null
                },
                plotBands: this.data.plotBands
            },
            series: [{
                name: this.data.measureName?(this.data.measureName).slice((this.data.measureName).indexOf('___')+3):'',
                data: [this.data.measureData],
                tooltip: {
                    enabled: true
                }
            }],
            tooltip:{
                formatter:function(){
                    return (me.data.measureName?(me.data.measureName.slice(me.data.measureName.indexOf('___')+3)+' : '):'')+ $BDA.formatString.number(me.data.formatString,this.y||'')+'<br/>'+
                        (me.data.warning.thresholdType?((me.data.targetMeasureName?me.data.targetMeasureName.slice(me.data.targetMeasureName.indexOf('___')+3) +' : ':'')+ $BDA.formatString.number(me.data.formatString,me.data.targetMeasureData||'')):'');
                }
            }
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = asignGaugeData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = asignGaugeData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----散点图*/
function ScatterPlot(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignData();

    function assignData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var scatter = {};

        var y1MeasureNames = [];
        var y2MeasureNames = [];
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1MeasureNames.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                scatter.y1 = viewBlock.y1Measures[i][1];
            }
        }
        for(var i= 0,len=viewBlock.y2Measures.length;i<len;i++){
            y2MeasureNames.push(viewBlock.y2Measures[i][0]+'___'+viewBlock.y2Measures[i][1]);
            if(i==0){
                scatter.y2 = viewBlock.y2Measures[i][1];
            }
        }
        scatter.y1DataFormat = viewBlock.y1DataFormat;
        scatter.y2DataFormat = viewBlock.y2DataFormat;
        scatter.items = [];
        scatter.XhaveNegative = false;
        scatter.YhaveNegative = false;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        scatter.xAxis = xAxis;
        scatter.dimensionTitle = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(y1MeasureNames,y2MeasureNames){
            var outPut = [];

            if (xAxis.length===1){
                var obj={};
                obj.name = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
                obj.data = [];

                for(var l=0;l<xAxis[0].length;l++){
                    for (var h=0;h<blockData.length;h++){
                        if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                            obj.data.push({
                                x:blockData[h][y1MeasureNames],
                                y : blockData[h][y2MeasureNames]
                            });
                            if (blockData[h][y1MeasureNames]<0){scatter.XhaveNegative = true;}
                            if (blockData[h][y2MeasureNames]<0){scatter.YhaveNegative = true;}
                        }
                    }
                }
                outPut.push(obj);
            }else{
                for(var j=1;j<xAxis.length;j++){
                    for (var m =0;m<xAxis[j].length;m++){
                        var obj={};
                        obj.name = xAxis[j][m];
                        obj.data = [];

                        for (var n=0;n<xAxis[0].length;n++){
                            for (var k=0;k<blockData.length;k++){
                                if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                    &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                    obj.data.push({
                                        x:blockData[k][y1MeasureNames],
                                        y:blockData[k][y2MeasureNames]
                                    });
                                    if (blockData[k][y1MeasureNames]<0){scatter.XhaveNegative = true;}
                                    if (blockData[k][y2MeasureNames]<0){scatter.YhaveNegative = true;}
                                    break;
                                }
                            }
                            k == blockData.length && obj.data.push({x:null,y:null});
                        }
                        outPut.push(obj);
                    }
                }
            }

            return outPut;
        }

        scatter.items = collect(y1MeasureNames[0],y2MeasureNames[0]);

        scatter.reportLink = viewBlock.reportLink;

        scatter.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:scatter.XhaveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?scatter.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.y1ScaleLineWidth||viewBlock.ChartStyle.y1ScaleLineWidth==0)?viewBlock.ChartStyle.y1ScaleLineWidth:1,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        scatter.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:scatter.YhaveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?scatter.y2:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
            lineColor: viewBlock.ChartStyle.y2ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y2ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return scatter;
    }

    function getName(point){
        for (var i= 0,length=me.data.items[0].data.length;i<length;i++){
            if (point.x == me.data.items[point.colorIndex].data[i].x
                &&point.y == me.data.items[point.colorIndex].data[i].y){return i;}
        }
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'scatter',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.XhaveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.y1ScaleLineWidth||viewBlock.ChartStyle.y1ScaleLineWidth==0)?viewBlock.ChartStyle.y1ScaleLineWidth:1,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.YhaveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y2:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            plotOptions: {
                scatter: {
                    marker: {
                        radius: 5*$BDA.defaultRatio,
                        symbol: 'circle'
                    },
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.y1DataFormat,this.x)+'<br>'+
                                $BDA.formatString.number(me.data.y2DataFormat,this.y)
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    var pointName = (typeof me.data.xAxis[0][getName(this.point)]!='undefined')?me.data.xAxis[0][getName(this.point)]:this.series.name;
                    return pointName+'<br>'+
                        me.data.y1+' : '+$BDA.formatString.number(me.data.y1DataFormat,this.x)+'<br>'+
                        me.data.y2+' : '+$BDA.formatString.number(me.data.y2DataFormat,this.y)
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: this.data.items
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----气泡图*/
function BubbleChart(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.data = assignData();

    function assignData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var bubbleData = {};
        bubbleData.items = [];

        var y1MeasureNames = [];
        var y2MeasureNames = [];
        var y3MeasureNames = [];
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1MeasureNames.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                bubbleData.y1 = viewBlock.y1Measures[i][1];
            }
        }
        for(var i= 0,len=viewBlock.y2Measures.length;i<len;i++){
            y2MeasureNames.push(viewBlock.y2Measures[i][0]+'___'+viewBlock.y2Measures[i][1]);
            if(i==0){
                bubbleData.y2 = viewBlock.y2Measures[i][1];
            }
        }
        for(var i= 0,len=viewBlock.y3Measures.length;i<len;i++){
            y3MeasureNames.push(viewBlock.y3Measures[i][0]+'___'+viewBlock.y3Measures[i][1]);
            if(i==0){
                bubbleData.y3 = viewBlock.y3Measures[i][1];
            }
        }
        bubbleData.dimensionsTitle = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        bubbleData.y1DataFormat = viewBlock.y1DataFormat;
        bubbleData.y2DataFormat = viewBlock.y2DataFormat;
        bubbleData.y3DataFormat = viewBlock.y3DataFormat;
        bubbleData.XhaveNegative = false;
        bubbleData.YhaveNegative = false;

        bubbleData.items = [];

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        bubbleData.xAxis = xAxis;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(y1MeasureNames,y2MeasureNames,y3MeasureNames){
            var outPut = [];

            if (xAxis.length===1){
                var obj={};
                obj.name = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
                obj.data = [];

                for(var l=0;l<xAxis[0].length;l++){
                    for (var h=0;h<blockData.length;h++){
                        if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                            obj.data.push({
                                x:blockData[h][y1MeasureNames],
                                y:blockData[h][y2MeasureNames],
                                z:blockData[h][y3MeasureNames]
                            });
                            if (blockData[h][y1MeasureNames]<0){bubbleData.XhaveNegative = true;}
                            if (blockData[h][y2MeasureNames]<0){bubbleData.YhaveNegative = true;}
                        }
                    }
                }
                outPut.push(obj);
            }else{
                for(var j=1;j<xAxis.length;j++){
                    for (var m =0;m<xAxis[j].length;m++){
                        var obj={};
                        obj.name = xAxis[j][m];
                        obj.data = [];

                        for (var n=0;n<xAxis[0].length;n++){
                            for (var k=0;k<blockData.length;k++){
                                if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                    &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                    obj.data.push({
                                        x:blockData[k][y1MeasureNames],
                                        y:blockData[k][y2MeasureNames],
                                        z:blockData[k][y3MeasureNames]
                                    });
                                    if (blockData[k][y1MeasureNames]<0){bubbleData.XhaveNegative = true;}
                                    if (blockData[k][y2MeasureNames]<0){bubbleData.YhaveNegative = true;}
                                    break;
                                }
                            }
                            k == blockData.length && obj.data.push({x:null,y:null,z:null});
                        }
                        outPut.push(obj);
                    }
                }
            }

            return outPut;
        }

        bubbleData.items = collect(y1MeasureNames[0],y2MeasureNames[0],y3MeasureNames[0]);

        bubbleData.reportLink = viewBlock.reportLink;

        bubbleData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:bubbleData.XhaveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?bubbleData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.y1ScaleLineWidth||viewBlock.ChartStyle.y1ScaleLineWidth==0)?viewBlock.ChartStyle.y1ScaleLineWidth:1,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        bubbleData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:bubbleData.YhaveNegative?null:0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?bubbleData.y2:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
            lineColor: viewBlock.ChartStyle.y2ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y2ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return bubbleData;
    }

    function getName(point){
        for (var i= 0,length=me.data.items[0].data.length;i<length;i++){
            if (point.x == me.data.items[point.colorIndex].data[i].x
                &&point.y == me.data.items[point.colorIndex].data[i].y
                &&point.z == me.data.items[point.colorIndex].data[i].z){
                return i;}
        }
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'bubble',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.XhaveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.y1ScaleLineWidth||viewBlock.ChartStyle.y1ScaleLineWidth==0)?viewBlock.ChartStyle.y1ScaleLineWidth:1,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.YhaveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y2:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y2ScaleLineWidth?viewBlock.ChartStyle.y2ScaleLineWidth:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            plotOptions: {
                bubble: {
                    minSize: 8*$BDA.defaultRatio,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.y1DataFormat,this.x)+'<br>'+
                                $BDA.formatString.number(me.data.y2DataFormat,this.y)+'<br>'+
                                $BDA.formatString.number(me.data.y3DataFormat,this.point.z)
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    var pointName = (typeof me.data.xAxis[0][getName(this.point)]!='undefined')?me.data.xAxis[0][getName(this.point)]:this.series.name;
                    return pointName+'<br>'+
                        me.data.y1+' : '+$BDA.formatString.number(me.data.y1DataFormat,this.x)+'<br>'+
                        me.data.y2+' : '+$BDA.formatString.number(me.data.y2DataFormat,this.y)+'<br>'+
                        me.data.y3+' : '+$BDA.formatString.number(me.data.y3DataFormat,this.point.z);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: this.data.items
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----瀑布图*/
function Waterfall(strType,strBDAChartID, strTitle, viewBlock) {
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = waterFallData();

    function Sum() {
        var sum = 0;
        var intLength = viewBlock.blockDataToDraw.length;
        var intI = 0;

        for (intI = 0; intI < intLength; intI++) {
            sum += viewBlock.blockDataToDraw[intI][viewBlock.y1Measures[0]];
        }
        return sum;
    }

    function waterFallData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var waterfallData = {};
        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var y1MeasureNames = [];
        var intLength = blockData.length;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1MeasureNames.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                waterfallData.y1 = viewBlock.y1Measures[i][1];
            }
        }
        waterfallData.dimensionTitle = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        waterfallData.formatString = viewBlock.y1DataFormat;
        waterfallData.haveNegative = false;

        var xAxis = [];

        for (var i=0;i<blockData.length;i++){
            for(var j = 0,jen = xAxis.length; j <jen ; j++){
                if(blockData[i][primaryDimensionName] == xAxis[j]){
                    break;
                }
            }
            j == jen && xAxis.push(blockData[i][primaryDimensionName]);
        }

        waterfallData.xAxis = xAxis;
        waterfallData.xAxis.push('总计');
        waterfallData.sum = Sum();

        waterfallData.items = [];
        for(var intI = 0; intI < intLength; intI++){
            var item = {};

            item.name = blockData[intI][primaryDimensionName];
            item.y = blockData[intI][y1MeasureNames[0]];
            if (item.y<0){waterfallData.haveNegative = true;}

            waterfallData.items.push(item);
        }
        waterfallData.items.push({name: '总计', isIntermediateSum: true, y: waterfallData.sum});

        waterfallData.reportLink = viewBlock.reportLink;

        waterfallData.xAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            categories: waterfallData.xAxis,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?waterfallData.dimensionTitle:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        waterfallData.yAxisStyle = {
            visible: viewBlock.ChartStyle.showTickValue,
            min:waterfallData.haveNegative?null:0,
            title:{
            text : viewBlock.ChartStyle.axisLabelShow?waterfallData.y1:null,
                style:{
                fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return waterfallData;
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'waterfall',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                categories: this.data.xAxis,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTitle:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                visible: viewBlock.ChartStyle.showTickValue,
                min:this.data.haveNegative?null:0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            plotOptions: {
                waterfall: {
                    borderWidth: 0,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.key + ' : '+$BDA.formatString.number(me.data.formatString,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: [{
                name:this.data.y1,
                data:this.data.items
            }]
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = waterFallData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = waterFallData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----雷达图*/
function RadarMap(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = radarData();

    function radarData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var radarMapData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1MeasureNames = [];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;

        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1MeasureNames.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                radarMapData.y1 = viewBlock.y1Measures[i][1];
            }
        }
        radarMapData.formatString = viewBlock.y1DataFormat;

        var xAxis = [];
        xAxis.push(collectXAXis(primaryDimensionName));
        groupDimensionName&&xAxis.push(collectXAXis(groupDimensionName));
        radarMapData.xAxis = xAxis;
        radarMapData.dimensionTitle = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        radarMapData.haveNegative = false;

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                if (xAxis.length===1){
                    var obj={};
                    obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                    obj.data = [];

                    for(var l=0;l<xAxis[0].length;l++){
                        for (var h=0;h<blockData.length;h++){
                            if (xAxis[0][l] == blockData[h][primaryDimensionName]){
                                obj.data.push(blockData[h][yAxis[i]]);
                                if (blockData[h][yAxis[i]]<0){radarMapData.haveNegative = true;}
                            }
                        }
                    }
                    outPut.push(obj);
                }else{
                    for(var j=1;j<xAxis.length;j++){
                        for (var m =0;m<xAxis[j].length;m++){
                            var obj={};
                            obj.name = y1MeasureNames.length>1?(xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3)):xAxis[j][m];
                            obj.data = [];

                            for (var n=0;n<xAxis[0].length;n++){
                                for (var k=0;k<blockData.length;k++){
                                    if(xAxis[0][n] === blockData[k][primaryDimensionName]
                                        &&xAxis[j][m] === blockData[k][groupDimensionName]) {
                                        obj.data.push(blockData[k][yAxis[i]]);
                                        if (blockData[k][yAxis[i]]<0){radarMapData.haveNegative = true;}
                                        break;
                                    }
                                }
                                k == blockData.length && obj.data.push(null);
                            }
                            outPut.push(obj);
                        }
                    }
                }
            }

            return outPut;
        }

        radarMapData.measuresData = collect(y1MeasureNames);

        radarMapData.reportLink = viewBlock.reportLink;

        radarMapData.xAxisStyle = {
            categories: radarMapData.xAxis[0],
            tickmarkPlacement: 'on',
            lineWidth: 0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?radarMapData.dimensionTitle:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }

            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            }
        };

        radarMapData.yAxisStyle = {
            min:radarMapData.haveNegative?null:0,
            gridLineInterpolation: 'polygon',
            lineWidth: 0,
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?radarMapData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            }
        };

        return radarMapData;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                polar: true,
                type: 'line',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            pane: {
                size: '80%'
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                categories: this.data.xAxis[0],
                tickmarkPlacement: 'on',
                lineWidth: 0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTitle:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }

                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                }
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                min:this.data.haveNegative?null:0,
                gridLineInterpolation: 'polygon',
                lineWidth: 0,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                }
            },
            plotOptions: {
                line: {
                    lineWidth: viewBlock.ChartStyle.lineWidth?viewBlock.ChartStyle.lineWidth*$BDA.defaultRatio:2*$BDA.defaultRatio,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.ChartStyle.negativeColor?$BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor):null,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.series.name + ' :<br>' + this.x + ' : '+$BDA.formatString.number(me.data.formatString,this.y)
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: this.data.measuresData
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = radarData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = radarData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----箱线图*/
function BoxPlot(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignData();

    function assignData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}
        var boxPlotData = {};

        return boxPlotData;
    }

    this.draw = function(fltHeight){
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'boxplot'
            },
            title: {
                text: null
            },
            legend: {
                enabled: false
            },
            xAxis: {
                categories: this.dimension.xAxis,
                title:{
                    text : this.dimension.key[0]
                }
            },
            yAxis: me.y2.key.length?[{
                title:{
                    text : this.y1.key[0]
                },
                opposite: true
            },{
                title:{
                    text : this.y2.key[0]
                },
                opposite: true
            }]:{
                title:{
                    text : this.y1.key[0]
                }
            },
            tooltip:{
                formatter:function(){
                    return this.x +' :<br>'+
                        'high : '+$BDA.format(this.point.high)+'<br>'+
                        'Q3 : '+$BDA.format(this.point.q3)+'<br>'+
                        'median : '+$BDA.format(this.point.median)+'<br>'+
                        'Q1 : '+$BDA.format(this.point.q1)+'<br>'+
                        'low : '+$BDA.format(this.point.low)+'<br>'
                }
            },
            series: this.dimension.key.length==1?
                this.y1.yAxis.concat(this.y2.yAxis):
                $BDA.chart.muchDimensions(this.dimension.key,this.blockData,this.y1.key[0])
        });
    };
}

/*类----漏斗图*/
function FunnelPlot(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = funnelData();

    function funnelData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var FunnelPlotData = {};
        var blockData = viewBlock.blockDataToDraw;
        var y1MeasureNames = [];
        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1MeasureNames.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
        }

        FunnelPlotData.formatString = viewBlock.y1DataFormat;
        FunnelPlotData.itemCount = y1MeasureNames.length;
        FunnelPlotData.measuresData = [];

        for(var i = 0;i < y1MeasureNames.length;i++){
            var measure = {name:"", y:0};
            measure.name = y1MeasureNames[i].slice(y1MeasureNames[i].indexOf('___')+3);
            measure.y = blockData[0][y1MeasureNames[i]];
            FunnelPlotData.measuresData.push(measure);
        }

        FunnelPlotData.reportLink = viewBlock.reportLink;

        return FunnelPlotData;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'funnel',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            plotOptions: {
                series: {
                    animation: autoRefreshAnimation,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer',
                    dataLabels: {
                        enabled: viewBlock.ChartStyle.dataShow,
                        distance: viewBlock.ChartStyle.dataLabel.position*$BDA.defaultRatio,
                        connectorWidth: viewBlock.ChartStyle.connectorWidth?viewBlock.ChartStyle.connectorWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                        formatter:function(){
                            return this.key+'：'+$BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    states: {
                        hover: {
                            enabled: false
                        }
                    },
                    neckWidth: '30%',
                    neckHeight: '0%'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.point.name + ' : '+$BDA.formatString.number(me.data.formatString,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: [{data:this.data.measuresData}]
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = funnelData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = funnelData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----极地图*/
function PolarMap(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = polarData();

    function polarData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var polarMapData = {};

        var blockData = viewBlock.blockDataToDraw;
        var dimensions = viewBlock.dimensions;
        var y1Measure = viewBlock.y1Measures;
        var intLength = blockData.length;

        var xAxis = [];

        for (var o=0;o<dimensions.length;o++){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimensions[o]]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimensions[o]]);
            }
            xAxis.push(arr);
        }

        polarMapData.xAxis = xAxis;
        polarMapData.dimensionTitle = dimensions[0];

        var outPut = [];

        for(var j=1;j<xAxis.length;j++){
            for (var m =0;m<xAxis[j].length;m++){
                var obj={};
                obj.name = xAxis[j][m]+yAxis[i].slice(yAxis[i].indexOf('___')+3);
                obj.data = [];
                obj.type = 'spline';
                for (var n=0;n<xAxis[0].length;n++){
                    for (var k=0;k<blockData.length;k++){
                        if(xAxis[0][n] === blockData[k][dimensions[0]]
                            &&xAxis[j][m] === blockData[k][dimensions[j]]) {
                            obj.data.push(blockData[k][y1Measure[0]]);
                            break;
                        }
                    }
                    k == blockData.length && obj.data.push(null);
                }
                outPut.push(obj);
            }
        }
        polarMapData.measuresData = outPut;

        return polarMapData;
    }

    this.draw = function(fltHeight) {
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                polar: true
            },
            title: {
                text: null
            },
            xAxis: {
                tickInterval: 30,
                min: 0,
                max: 360,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTitle:null
                },
                labels: {
                    formatter: function () {
                        return this.value + '°';
                    }
                }
            },
            yAxis:{
                enabled: false,
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.y1MeasureNames[0]:null
                }
            },
            plotOptions: {
                series: {
                    pointStart: 0,
                    pointInterval: 45
                },
                spline:{
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow
                    },
                    connectEnds:false,
                    marker:{
                        radius:2
                    }
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.series.name + ' :<br>'
                        +'X :' + this.x + '<br>'
                        +'Y :' + $BDA.format(this.y);
                }
            },
            series: this.data.measuresData
        });
    };
}

/*类----地图*/
function EchartMap(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.currentDataIndex = 0;
    this.reportLinkData = null;
    this.mapObjectGeoName = null;
    this.drillMapGeoName = null;
    this.geoLevel = viewBlock.geoLevel;
    this.haveChildMap = viewBlock.haveChildMap;
    this.data = assignMapData();

    function assignMapData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var mapData = {};
        mapData.mapCode = viewBlock.mapCode;
        var blockData =  viewBlock.blockDataToDraw;
        var mainMeasureName = viewBlock.mainMeasure?(viewBlock.mainMeasure[0]+'___'+viewBlock.mainMeasure[1]):null;
        var dimension = viewBlock.locationDimension?(viewBlock.locationDimension[0]+'___'+viewBlock.locationDimension[1]):null;
        mapData.blockData = blockData;
        mapData.dimension = dimension;
        mapData.mainMeasureName = mainMeasureName;
        var otherMeasureNames=[];
        for(var i= 0,len=viewBlock.otherMeasures.length;i<len;i++){
            otherMeasureNames.push(viewBlock.otherMeasures[i][0]+'___'+viewBlock.otherMeasures[i][1]);
        }
        mapData.otherMeasureNames = otherMeasureNames;
        mapData.reportLink = viewBlock.reportLink;

        var min = 0,max = 0,rangeData = [];
        mapData.viewGeographyDataCompares = viewBlock.viewGeographyDataCompares;
        for(var i= 0,len=mapData.viewGeographyDataCompares.length;i<len;i++){
            if(mapData.viewGeographyDataCompares[i].objectGeoName == blockData[0][dimension]){
                rangeData.push({name:mapData.viewGeographyDataCompares[i].mapGeoName,value:blockData[0][mainMeasureName]});
            }
        }
        min = max = blockData[0][mainMeasureName];
        for (var i=1;i<blockData.length;i++){
            var currentMeasure = blockData[i][mainMeasureName];
            min >= currentMeasure&&(min = currentMeasure);
            max < currentMeasure&&(max = currentMeasure);
            for(var j= 0,jen=mapData.viewGeographyDataCompares.length;j<jen;j++){
                if(mapData.viewGeographyDataCompares[j].objectGeoName == blockData[i][dimension]){
                    rangeData.push({name:mapData.viewGeographyDataCompares[j].mapGeoName,value:blockData[i][mainMeasureName]});
                }
            }
        }
        min > 0&&(min=0);
        mapData.min = min;
        mapData.max = max;
        mapData.rangeData = rangeData;

        var pieces = [];
        if(viewBlock.mapLegend && viewBlock.mapLegend.legendRanges.length != 0){
            for(var i = 0; i < viewBlock.mapLegend.legendRanges.length; i++){
                var tempObj = {};
                if(viewBlock.mapLegend.legendRanges[i].start){
                    tempObj.gt = Number(viewBlock.mapLegend.legendRanges[i].start);
                }
                if(viewBlock.mapLegend.legendRanges[i].end){
                    tempObj.lte = Number(viewBlock.mapLegend.legendRanges[i].end);
                }
                if(viewBlock.mapLegend.legendRanges[i].label){
                    tempObj.label = viewBlock.mapLegend.legendRanges[i].label;
                }
                tempObj.color = 'rgb('+int2hex(viewBlock.mapLegend.legendRanges[i].color,false)+')';
                pieces.push(tempObj);
            }
        }

        mapData.pieces = pieces;
        mapData.defaultColor = $BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence,true);
        return mapData;

        function int2hex(rgbInt,isTrue) {
            var red = (rgbInt >> 16) & 255;
            var green = (rgbInt >> 8) & 255;
            var blue = rgbInt & 255;
            if(isTrue){
                isTrue == 1 ? ((red - 48 >= 0)?(red = red - 48):0):((red + 24 > 255)?255:(red = red + 24));
                isTrue == 1 ? ((green - 48 >= 0)?(green = green - 48):0):((green + 24 > 255)?255:(green = green + 24));
                isTrue == 1 ? ((blue - 48 >= 0)?(blue = blue - 48):0):((blue + 24 > 255)?255:(blue = blue + 24));
            }
            return red+","+green+","+blue;
        }
    }

    this.draw = function (fltHeight,openDrilldown) {
        this.setChartContentHeight(fltHeight);
        $(this.chartID).find('.bda-map-content').remove();
        $(this.chartID).find('.bda-chart-content').css('padding','10px').append('<div class="bda-map-content"></div>');

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        ajaxTools.request('../mapResource/'+ viewBlock.mapCode + '.json',"","get", function(data,status,jqXHR){
            viewBlock.mapData = data;
            load(viewBlock.mapData);
        }, function(){});

        function load(mapData){
            echarts.registerMap(me.data.mapCode, mapData);
            var mapChart = echarts.init($(me.chartID).find('.bda-map-content')[0]);
            mapChart.setOption({
                series:[{
                    type: 'map',
                    mapType: me.data.mapCode,
                    data:me.data.rangeData,
                    itemStyle: {
                        normal: {
                            areaColor: $BDA.csharp2rgba(viewBlock.mapDefaultColor),
                            borderColor: $BDA.csharp2rgba(viewBlock.mapBorderColor),
                            borderWidth: viewBlock.mapBorderWidth
                        },
                        emphasis: {
                            areaColor: $BDA.csharp2rgba(viewBlock.mapHoverColor),
                            borderColor: $BDA.csharp2rgba(viewBlock.mapBorderColor),
                            borderWidth: viewBlock.mapBorderWidth
                        }
                    },
                    label: {
                        normal: {
                            textStyle: {
                                fontSize: 12*$BDA.defaultRatio,
                            }
                        }
                    },
                }],
                //visualMap: me.data.pieces.length?me.data.visualMap:{},
                visualMap: {
                    show: me.data.pieces.length?true:false,
                    type: 'piecewise',
                    min: me.data.min,
                    max: me.data.max,
                    x: viewBlock.mapLegend?((viewBlock.mapLegend.legendPosition == 0 || viewBlock.mapLegend.legendPosition == 3)?'left':'right'):'left',
                    y: viewBlock.mapLegend?((viewBlock.mapLegend.legendPosition == 0 || viewBlock.mapLegend.legendPosition == 1)?'top':'bottom'):'bottom',
                    pieces: me.data.pieces,
                    color: $BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence,true),
                    textStyle: {
                        color: $BDA.theme.themeID==0?(viewBlock.mapLegend?$BDA.csharp2rgba(viewBlock.mapLegend.fontColor):'#333'):'#d2d2d2'
                    },
                    textGap: 5
                },
                tooltip:{
                    show:true,
                    textStyle: {
                        fontSize: 14*$BDA.defaultRatio
                    },
                    formatter:function(map){
                        var currentObj = {},str = '';
                        for (var i=0,len=me.data.blockData.length;i<len;i++){
                            var currentDimension = '';
                            for(var j= 0,jen=me.data.viewGeographyDataCompares.length;j<jen;j++){
                                if(me.data.blockData[i][me.data.dimension] == me.data.viewGeographyDataCompares[j].objectGeoName){
                                    currentDimension = me.data.viewGeographyDataCompares[j].mapGeoName;
                                    break;
                                }
                            }
                            if (map.name && (map.name == currentDimension)){
                                currentObj = me.data.blockData[i];
                                break;
                            }
                        }
                        for (var key in currentObj){
                            str+= key.slice(key.indexOf('___')+3) +' : '+currentObj[key]+'<br/>';
                        }
                        return str;
                    }
                }
            });
            /*报表链接获取目标对象*/
            mapChart.on('click', function (params) {
                var name = params.name;
                var currentObjectGeoName = '';
                me.reportLinkData = null;
                me.mapObjectGeoName = null;
                me.drillMapGeoName = null;
                for(var i=0;i<me.data.viewGeographyDataCompares.length;i++){
                    if(name == me.data.viewGeographyDataCompares[i].mapGeoName){
                        currentObjectGeoName = me.data.viewGeographyDataCompares[i].objectGeoName;
                        break;
                    }
                }

                if((openDrilldown && me.haveChildMap) || viewBlock.linkage){
                    me.mapObjectGeoName = currentObjectGeoName;
                    me.drillMapGeoName = name;
                    return;
                }else{
                    for(var i=0;i<me.data.blockData.length;i++){
                        if (typeof openDrilldown == 'undefined' && currentObjectGeoName == me.data.blockData[i][me.data.dimension] && (me.data.reportLink || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0))){
                            me.reportLinkData = me.data.blockData[i];
                            return;
                        }
                    }
                }
            });
        }


    };

    this.refreshByLinkage=function(fltHeight){
        this.data = assignMapData();
        me.draw(fltHeight);
    }

    this.autoRefresh=function(fltHeight, openDrilldown){
        this.data = assignMapData();
        this.draw(fltHeight, openDrilldown);
    }
}

/*类----Label*/
function Label(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.draw = function(fltHeight){
        $(this.chartID).find('h3').css('display','none');
        $(this.chartID).find('.bda-chart-box').css('padding',0);
        this.setChartContentHeight(fltHeight);

        $(this.chartID).find('.bda-label-content').remove();
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-label-content"></div>');
        var contentWidth = $(this.chartID).find('.bda-chart-content').width();
        var screenHeight = fltHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        screenHeight = screenHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        $(this.chartID).find(".bda-chart-content").css("height",screenHeight/(100*$BDA.defaultRatio)+"rem");

        var titleArr = null;
        viewBlock.labelContent = viewBlock.labelContent!=null?viewBlock.labelContent:"";
        if(viewBlock.labelContent.indexOf("=") != -1 && viewBlock.labelContent.indexOf("=") == 0){
            titleArr = viewBlock.labelContent.split("+");
            titleArr[0] = titleArr[0].substr(1,titleArr[0].length-1);
            $.each(titleArr,function(i){
                titleArr[i] = $.trim(titleArr[i]);
                if(titleArr[i].indexOf("[") != -1){
                    titleArr[i] = titleArr[i].replace(/\s*/g,"");
                    var queryName = (titleArr[i].match(/\[(.+?)\]/g))[0];
                    queryName = queryName.substr(1,queryName.length-2);
                    var objcecName = (titleArr[i].match(/\[(.+?)\]/g))[1];
                    objcecName = objcecName.substr(1,objcecName.length-2);
                    if(titleArr[i].indexOf("Linkage(") != -1){
                        for(var j = 0; j < viewBlock.linkageParameters.length; j++){
                            if(queryName == viewBlock.linkageParameters[j].queryName && objcecName == viewBlock.linkageParameters[j].dimensionName){
                                if(viewBlock.linkageParameters[j].dataType == 1){
                                    titleArr[i] = $BDA.formatString.date("",new Date(viewBlock.linkageParameters[j].dimensionValue));
                                }else{
                                    titleArr[i] = viewBlock.linkageParameters[j].dimensionValue;
                                }
                                break;
                            }
                        }
                    }
                    if(titleArr[i].indexOf("Sum(") != -1){
                        var sum = 0;
                        for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
                            sum += (viewBlock.blockDataToDraw[j][queryName+"___"+objcecName]?viewBlock.blockDataToDraw[j][queryName+"___"+objcecName]:0);
                        }
                        titleArr[i] = $BDA.formatString.number($BDA.getFormatType(viewBlock,queryName+"___"+objcecName),sum) + "";
                    }
                    if(titleArr[i] != "Invalid Date"){
                        if(titleArr[i].indexOf("[") != -1){ titleArr[i] = "";}//linkageParameters没有包含当前参数;
                    }
                }else{
                    titleArr[i] = titleArr[i].substr(1,titleArr[i].length-2);
                }
            });
            $(me.chartID).find('.bda-label-content').html((viewBlock.labelContent?titleArr.join("").replace(/\r\n/g,'<br/>'):""));
        }else{
            $(me.chartID).find('.bda-label-content').html((viewBlock.labelContent?viewBlock.labelContent.replace(/\r\n/g,'<br/>'):""));
        }

        $(me.chartID).find('.bda-label-content').css({
            'width': contentWidth,
            'height': screenHeight/(100*$BDA.defaultRatio)+"rem",
            'display': 'table-cell',
            //'padding': '0 15px',
            'border-radius': viewBlock.labelTextBox.borderRadius.replace(/\,/g,'px ') + 'px',
            'background-color': $BDA.csharp2rgba(viewBlock.labelTextBox.backgroundColor),
            'text-align': viewBlock.labelTextBox.textAlign=='0'?'left':(viewBlock.labelTextBox.textAlign=='1'?'center':'right'),
            'color': $BDA.csharp2rgba(viewBlock.labelTextBox.color),
            'font-family': viewBlock.labelTextBox.font.fontFamily,
            'font-size': viewBlock.labelTextBox.font.size/100+"rem",
            'font-style': viewBlock.labelTextBox.font.italic?'italic':'normal',
            'font-weight': viewBlock.labelTextBox.font.bold?'bold':'normal',
            'text-decoration': viewBlock.labelTextBox.font.underline?'underline':
                (viewBlock.labelTextBox.font.strikeout?'line-through':'none'),
            'vertical-align': viewBlock.labelTextBox.verticalAlign=='0'?'top':(viewBlock.labelTextBox.verticalAlign=='1'?'middle':'bottom')
        });
        $(me.chartID).find('.bda-bgcolor').css('border-radius',viewBlock.labelTextBox.borderRadius.replace(/\,/g,'px ') + 'px');
        if (viewBlock.reportLink || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0)){
            $(me.chartID).find('.bda-label-content').css("cursor","pointer");
        }
    }

    this.refreshByLinkage = function(fltHeight){
        this.draw(fltHeight);
    }

    this.autoRefresh=function(fltHeight){
        this.draw(fltHeight);
    }
}

/*类----可缩放时间轴的折线图*/
function ScalableLineGraph(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignScalableLineGraphData();

    function assignScalableLineGraphData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var scalableLineGraphData = {};
        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var y1Measure = [];
        scalableLineGraphData.y1 = '';

        for(var i= 0,len=viewBlock.y1Measures.length;i<len;i++){
            y1Measure.push(viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]);
            if(i==0){
                scalableLineGraphData.y1 = viewBlock.y1Measures[i][1];
            }
        }

        scalableLineGraphData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        scalableLineGraphData.formatString = viewBlock.y1DataFormat;
        scalableLineGraphData.haveNegative = false;

        function collect(yAxis){
            var outPut = [];

            for (var i=0;i<yAxis.length;i++){
                var obj={};
                obj.name = yAxis[i].slice(yAxis[i].indexOf('___')+3);
                obj.data = [];

                for (var j=0;j<blockData.length;j++){
                    var arr = [];
                    arr.push(blockData[j][primaryDimensionName]);
                    arr.push(blockData[j][yAxis[i]]);
                    obj.data.push(arr);
                    if (blockData[j][yAxis[i]]<0){scalableLineGraphData.haveNegative = true;}
                }
                outPut.push(obj);
            }
            return outPut;
        }

        scalableLineGraphData.measuresData = collect(y1Measure);
        scalableLineGraphData.reportLink = null;

        scalableLineGraphData.xAxisStyle = {
            type: 'datetime',
            dateTimeLabelFormats: {
                millisecond: '%H:%M:%S.%L',
                second: '%H:%M:%S',
                minute: '%H:%M',
                hour: '%H:%M',
                day: '%m-%d',
                week: '%m-%d',
                month: '%Y-%m',
                year: '%Y'
            },
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?scalableLineGraphData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        scalableLineGraphData.yAxisStyle = {
            title: {
                text: viewBlock.ChartStyle.axisLabelShow?scalableLineGraphData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            min: scalableLineGraphData.haveNegative?null:0,
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        return scalableLineGraphData;
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type: 'area',
                zoomType: 'x',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                spacingTop: 10*$BDA.defaultRatio
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            subtitle: {
                text: null
            },
            xAxis: $BDA.theme.themeID==0?this.data.xAxisStyle:{
                type: 'datetime',
                dateTimeLabelFormats: {
                    millisecond: '%H:%M:%S.%L',
                    second: '%H:%M:%S',
                    minute: '%H:%M',
                    hour: '%H:%M',
                    day: '%m-%d',
                    week: '%m-%d',
                    month: '%Y-%m',
                    year: '%Y'
                },
                title:{
                    text : viewBlock.ChartStyle.axisLabelShow?this.data.dimensionTilte:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    enabled: viewBlock.primaryDimension?true:false,
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            yAxis: $BDA.theme.themeID==0?this.data.yAxisStyle:{
                title: {
                    text: viewBlock.ChartStyle.axisLabelShow?this.data.y1:null,
                    style:{
                        fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                    }
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                    }
                },
                min: this.data.haveNegative?null:0,
                lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            },
            tooltip: {
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.series.name + '<br>' + ($BDA.formatString.date("",new Date(this.x))||'') + (this.x?' : ':'')+$BDA.formatString.number(me.data.formatString,this.y);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            plotOptions: {
                area: {
                    fillColor: {
                        linearGradient: {
                            x1: 0,
                            y1: 0,
                            x2: 0,
                            y2: 1
                        },
                        stops: [
                            [0, Highcharts.getOptions().colors[0]],
                            [1, Highcharts.Color(Highcharts.getOptions().colors[0]).setOpacity(0).get('rgba')]
                        ]
                    },
                    marker: {
                        radius: 2
                    },
                    lineWidth: 1*$BDA.defaultRatio,
                    states: {
                        hover: {
                            lineWidth: 1*$BDA.defaultRatio
                        }
                    },
                    threshold: null,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter:function(){
                            return $BDA.formatString.number(me.data.formatString,this.y);
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                series:{
                    animation: autoRefreshAnimation,
                    negativeColor: viewBlock.negativeColor?$BDA.csharp2rgba(viewBlock.negativeColor):null
                }
            },
            series: this.data.measuresData
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignScalableLineGraphData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignScalableLineGraphData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----可调整数据范围的曲线图*/
function AdjustableLineGraph(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignAdjustableLineGraphData();

    function assignAdjustableLineGraphData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var adjustableLineGraphData = {};
        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        adjustableLineGraphData.primaryDimensionName = primaryDimensionName;
        adjustableLineGraphData.y1 = '';
        adjustableLineGraphData.startDate = new Date($BDA.formatString.date('',new Date(blockData[0][primaryDimensionName]))).setHours(0,0,0,0);
        adjustableLineGraphData.endData = blockData[blockData.length-1][primaryDimensionName];
        adjustableLineGraphData.haveNegative = false;
        adjustableLineGraphData.y1 = viewBlock.y1Measures.length?viewBlock.y1Measures[0][1]:'';

        var measureData = [];
        for(var i = adjustableLineGraphData.startDate; i <= adjustableLineGraphData.endData; i+=86400000){
            var dayMeasureData = 0;

            for(var j = 0; j < blockData.length; j++){
                if(i <= blockData[j][primaryDimensionName] && blockData[j][primaryDimensionName] < i+86400000){
                    if(viewBlock.y1Measures.length){
                        dayMeasureData += blockData[j][viewBlock.y1Measures[0][0]+'___'+viewBlock.y1Measures[0][1]];
                    }
                }
            }
            if(dayMeasureData < 0){adjustableLineGraphData.haveNegative = true;}
            measureData.push(dayMeasureData);
        }
        adjustableLineGraphData.dimensionTilte = viewBlock.primaryDimension?viewBlock.primaryDimension[1]:'';
        adjustableLineGraphData.formatString = viewBlock.y1DataFormat;

        adjustableLineGraphData.measureData = measureData;
        adjustableLineGraphData.detailEndDate = (blockData.length > 14)?(new Date(blockData[blockData.length-15][primaryDimensionName])):(new Date(blockData[0][primaryDimensionName]));
        adjustableLineGraphData.masterStartDate = new Date(blockData[0][primaryDimensionName]);
        adjustableLineGraphData.masterEndDate = new Date(blockData[blockData.length-1][primaryDimensionName]);

        adjustableLineGraphData.xAxisStyle = {
            type: 'datetime',
            dateTimeLabelFormats: {
                millisecond: '%H:%M:%S.%L',
                second: '%H:%M:%S',
                minute: '%H:%M',
                hour: '%H:%M',
                day: '%m-%d',
                week: '%m-%d',
                month: '%Y-%m',
                year: '%Y'
            },
            title:{
                text : viewBlock.ChartStyle.axisLabelShow?adjustableLineGraphData.dimensionTilte:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                enabled: viewBlock.primaryDimension?true:false,
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
            lineColor: viewBlock.ChartStyle.xScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.xScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
        };

        adjustableLineGraphData.yAxisStyle = {
            title: {
                text: viewBlock.ChartStyle.axisLabelShow?adjustableLineGraphData.y1:null,
                style:{
                    fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):"#666",
                    fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                }
            },
            labels:{
                style:{
                    fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                    color: viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):"#666",
                    fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                }
            },
            min: adjustableLineGraphData.haveNegative?null:0,
            lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
            lineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb',
            gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
            tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
            //maxZoom: 0.1
        };

        adjustableLineGraphData.labels = {
            style:{
                fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
            }
        };

        return adjustableLineGraphData;
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var detailChart = "";
        var container =  $(this.chartID).find(".bda-chart-content");
        var detailContainer = null;
        var masterContainer = null;

        // 创建详细数据图
        function createDetail(masterChart) {
            var detailData = [];
            var detailStart = Date.UTC(me.data.detailEndDate.getFullYear(),me.data.detailEndDate.getMonth(),me.data.detailEndDate.getDate());
            Highcharts.each(masterChart.series[0].data, function(d) {
                if(d.x >= detailStart) {
                    detailData.push(d.y);
                }
            });
            detailChart = Highcharts.chart(detailContainer, {
                chart: {
                    marginBottom: 40*$BDA.defaultRatio,
                    reflow: true,
                    marginLeft: 80*$BDA.defaultRatio,
                    marginRight: 20*$BDA.defaultRatio,
                    backgroundColor: 'rgba(0,0,0,0)',
                    plotBackgroundColor: null
                    //style: {
                    //    position: 'absolute'
                    //}
                },
                colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
                credits: {
                    enabled: false
                },
                title: {
                    text: null
                },
                subtitle: {
                    text: null
                },
                xAxis: $BDA.theme.themeID==0?me.data.xAxisStyle:{
                    type: 'datetime',
                    dateTimeLabelFormats: {
                        millisecond: '%H:%M:%S.%L',
                        second: '%H:%M:%S',
                        minute: '%H:%M',
                        hour: '%H:%M',
                        day: '%m-%d',
                        week: '%m-%d',
                        month: '%Y-%m',
                        year: '%Y'
                    },
                    title:{
                        text : viewBlock.ChartStyle.axisLabelShow?me.data.dimensionTilte:null,
                        style:{
                            fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                            fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    labels:{
                        enabled: viewBlock.primaryDimension?true:false,
                        style:{
                            fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                            fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    lineWidth: (viewBlock.ChartStyle.xScaleLineWidth || viewBlock.ChartStyle.xScaleLineWidth==0)?viewBlock.ChartStyle.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                    gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                    tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
                },
                yAxis: $BDA.theme.themeID==0?me.data.yAxisStyle:{
                    title: {
                        text: viewBlock.ChartStyle.axisLabelShow?me.data.y1:null,
                        style:{
                            fontFamily: viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100',
                            fontStyle: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    labels:{
                        style:{
                            fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                            fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    min: me.data.haveNegative?null:0,
                    lineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                    gridLineWidth: viewBlock.ChartStyle.showGridLine?1*$BDA.defaultRatio:0,
                    tickWidth: viewBlock.ChartStyle.showTick?1*$BDA.defaultRatio:0
                    //maxZoom: 0.1
                },
                tooltip: {
                    formatter: function () {
                        var point = this.points[0];
                        return point.series.name + '<br>' + ($BDA.formatString.date("",new Date(point.x))||'') + (point.x?' : ':'')+$BDA.formatString.number(me.data.formatString,point.y);
                    },
                    style: {
                        fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                    },
                    shared: true
                },
                legend: {
                    enabled: false,
                    itemHoverStyle:{
                        color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                    },
                    itemStyle: {
                        color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                        fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                        fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                    },
                    layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                    align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                    verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
                },
                plotOptions: {
                    series: {
                        animation: autoRefreshAnimation,
                        negativeColor: viewBlock.negativeColor?$BDA.csharp2rgba(viewBlock.negativeColor):null,
                        dataLabels:{
                            enabled: viewBlock.ChartStyle.dataShow,
                            formatter:function(){
                                return $BDA.formatString.number(me.data.formatString,this.y);
                            },
                            style: {
                                fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                                fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                                fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                                fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                                textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                            }
                        },
                        marker: {
                            enabled: false,
                            states: {
                                hover: {
                                    enabled: true,
                                    radius: 3
                                }
                            }
                        }
                    }
                },
                series: [{
                    name: me.data.y1,
                    pointStart: detailStart,
                    pointInterval: 24 * 3600 * 1000,
                    data: detailData
                }]
            });
        }

        // 创建导航图
        function createMaster() {
            return Highcharts.chart(masterContainer, {
                chart: {
                    reflow: true,
                    borderWidth: 0,
                    backgroundColor: 'rgba(0,0,0,0)',
                    plotBackgroundColor: null,
                    marginLeft: 50*$BDA.defaultRatio,
                    marginRight: 20*$BDA.defaultRatio,
                    zoomType: 'x',
                    events: {
                        // listen to the selection event on the master chart to update the
                        // extremes of the detail chart
                        selection: function (event) {
                            var extremesObject = event.xAxis[0],
                                min = extremesObject.min,
                                max = extremesObject.max,
                                detailData = [],
                                xAxis = this.xAxis[0];
                            Highcharts.each(this.series[0].data, function(d) {
                                if(d.x > min && d.x < max) {
                                    detailData.push([d.x, d.y]);
                                }
                            });
                            // move the plot bands to reflect the new detail span
                            xAxis.removePlotBand('mask-before');
                            xAxis.addPlotBand({
                                id: 'mask-before',
                                from: Date.UTC(me.data.masterStartDate.getFullYear(),me.data.masterStartDate.getMonth(),me.data.masterStartDate.getDate()),
                                to: min,
                                color: 'rgba(0, 0, 0, 0.2)'
                            });
                            xAxis.removePlotBand('mask-after');
                            xAxis.addPlotBand({
                                id: 'mask-after',
                                from: max,
                                to: Date.UTC(me.data.masterEndDate.getFullYear(), me.data.masterEndDate.getMonth(), me.data.masterEndDate.getDate()),
                                color: 'rgba(0, 0, 0, 0.2)'
                            });
                            detailChart.series[0].setData(detailData);
                            return false;
                        }
                    }
                },
                colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
                title: {
                    text: null
                },
                xAxis: {
                    type: 'datetime',
                    dateTimeLabelFormats: {
                        millisecond: '%H:%M:%S.%L',
                        second: '%H:%M:%S',
                        minute: '%H:%M',
                        hour: '%H:%M',
                        day: '%m-%d',
                        week: '%m-%d',
                        month: '%Y-%m',
                        year: '%Y'
                    },
                    showLastTickLabel: true,
                    maxZoom: 14 * 24 * 3600000, // fourteen days
                    plotBands: [{
                        id: 'mask-before',
                        from: Date.UTC(me.data.masterStartDate.getFullYear(), me.data.masterStartDate.getMonth(), me.data.masterStartDate.getDate()),
                        to: Date.UTC(me.data.detailEndDate.getFullYear(), me.data.detailEndDate.getMonth(), me.data.detailEndDate.getDate()),
                        color: 'rgba(0, 0, 0, 0.2)'
                    }],
                    title: {
                        text: null
                    },
                    labels: $BDA.theme.themeID == 0 ? me.data.labels : {}
                },
                yAxis: {
                    gridLineWidth: 0,
                    labels: {
                        enabled: false
                    },
                    title: {
                        text: null
                    },
                    min: 0,
                    showFirstLabel: false
                },
                tooltip: {
                    formatter: function () {
                        return false;
                    }
                },
                legend: {
                    enabled: false
                },
                credits: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        animation: autoRefreshAnimation,
                        fillColor: {
                            linearGradient: [0, 0, 0, 70],
                            stops: [
                                [0, Highcharts.getOptions().colors[0]],
                                [1, 'rgba(255,255,255,0)']
                            ]
                        },
                        lineWidth: 1,
                        marker: {
                            enabled: false
                        },
                        shadow: false,
                        states: {
                            hover: {
                                lineWidth: 1
                            }
                        },
                        enableMouseTracking: false
                    }
                },
                series: [{
                    type: 'area',
                    name: 'USD to EUR',
                    pointInterval: 24 * 3600 * 1000,
                    pointStart: Date.UTC(me.data.masterStartDate.getFullYear(), me.data.masterStartDate.getMonth(), me.data.masterStartDate.getDate()),
                    data: me.data.measureData
                }],
                exporting: {
                    enabled: false
                }
            }, function (masterChart) {
                createDetail(masterChart);
            });
        }
        /*
         * 创建 detailContainer 并 append 到 container 中
         */

        var contentHeight = $(this.chartID).find(".bda-chart-content").height();
        detailContainer = document.createElement('div');
        detailContainer.style.height = (contentHeight - (100 * $BDA.defaultRatio))/(100* $BDA.defaultRatio) + 'rem';
        detailContainer.style.width = '100%';
        container.append(detailContainer);
        /*
         * 创建 masterContainer 并 append 到 container 中
         */
        masterContainer = document.createElement('div');
        masterContainer.style.position = 'absolute';
        masterContainer.style.top = (contentHeight - (100 * $BDA.defaultRatio))/(100* $BDA.defaultRatio) + 'rem';
        masterContainer.style.height = "1rem";
        masterContainer.style.width = '100%';
        container.append(masterContainer);
        /*
         * 开始创建导航图，详细的图是在导航图的回调函数中创建的
         * 代码入口
         */
        createMaster();

    }

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignAdjustableLineGraphData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignAdjustableLineGraphData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----可变换宽度的环形图*/
function VariablePie(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.highchart = null;
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.data = assignVariablePieData();

    function assignVariablePieData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var pieData = {};
        var blockData = viewBlock.blockDataToDraw;
        var intLength = blockData.length;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
        }
        pieData.items = [];
        pieData.y1MeasureName = viewBlock.y1Measures.length?viewBlock.y1Measures[0][1]:'';
        pieData.y2MeasureName = viewBlock.y2Measures.length?viewBlock.y2Measures[0][1]:'';
        pieData.y1DataFormat = viewBlock.y1DataFormat;
        pieData.y2DataFormat = viewBlock.y2DataFormat;

        for(var intI = 0; intI < intLength; intI++){
            var item = {};

            item.name = blockData[intI][primaryDimensionName];
            if(viewBlock.y1Measures.length && !viewBlock.y2Measures.length){
                item.y = blockData[intI][(viewBlock.y1Measures[0][0]+'___'+viewBlock.y1Measures[0][1])];
            }
            if(!viewBlock.y1Measures.length && viewBlock.y2Measures.length){
                item.y = blockData[intI][(viewBlock.y2Measures[0][0]+'___'+viewBlock.y2Measures[0][1])];
            }
            if(viewBlock.y1Measures.length && viewBlock.y2Measures.length){
                item.y = blockData[intI][(viewBlock.y1Measures[0][0]+'___'+viewBlock.y1Measures[0][1])];
                item.z = blockData[intI][(viewBlock.y2Measures[0][0]+'___'+viewBlock.y2Measures[0][1])];
            }

            pieData.items.push(item);
        }
        pieData.reportLink = viewBlock.reportLink;

        return pieData;
    }

    this.draw = function (fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type:'variablepie',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                plotBorderWidth: null,
                pltShadow: false
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            plotOptions:{
                series: {
                    slicedOffset: 5,
                    animation: autoRefreshAnimation,
                    dataLabels:{
                        enabled: viewBlock.ChartStyle.dataShow,
                        distance: viewBlock.ChartStyle.dataLabel.position*$BDA.defaultRatio,
                        connectorWidth: viewBlock.ChartStyle.connectorWidth?viewBlock.ChartStyle.connectorWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                            fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    showInLegend: viewBlock.ChartStyle.legendShow,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend: {
                enabled: viewBlock.ChartStyle.legendShow,
                itemHoverStyle:{
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):"#FFF"
                },
                symbolPadding : 5*$BDA.defaultRatio,
                itemStyle: {
                    color: $BDA.theme.themeID==0?$BDA.csharp2rgba(viewBlock.ChartStyle.legendColor):($BDA.theme.themeID==1?"#A0A0A0":"#E0E0E3"),
                    fontFamily: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.legendFont?viewBlock.ChartStyle.legendFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.legendFont?(viewBlock.ChartStyle.legendFont.underline?'underline':(viewBlock.ChartStyle.legendFont.strikeout?'line-through':'none')):'none'
                },
                layout: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'horizontal':'vertical',
                align: (viewBlock.ChartStyle.legendPosition==0 || viewBlock.ChartStyle.legendPosition==2)?'center':(viewBlock.ChartStyle.legendPosition==1?'right':'left'),
                verticalAlign: (viewBlock.ChartStyle.legendPosition==1 || viewBlock.ChartStyle.legendPosition==3)?'middle':(viewBlock.ChartStyle.legendPosition==0?'top':'bottom')
            },
            tooltip:{
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter: function(){
                    var strKey = '<span style="color:'+this.color+'">\u25CF'+this.key + '：</span><br/>';
                    var strY1 = me.data.y1MeasureName?('<span style="color:'+this.color+'">'+ me.data.y1MeasureName + '：' + $BDA.formatString.number(me.data.y1DataFormat,this.point.y) + '</span><br/>'):'';
                    var strY2 = me.data.y2MeasureName?('<span style="color:'+this.color+'">'+ me.data.y2MeasureName + '：' + $BDA.formatString.number(me.data.y2DataFormat,this.point.z)+'</span>'):'';
                    return strKey+strY1+strY2;
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: [{
                minPointSize: 10,
                innerSize: '20%',
                zMin: 0,
                name: 'countries',
                data:this.data.items
            }]
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignVariablePieData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignVariablePieData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----活动图*/
function PercentDoughnut(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.highchart = {};

    this.data = assignActivityData();

    function assignActivityData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var activityData = {};
        var blockData = viewBlock.blockDataToDraw;
        var intLength = blockData.length;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+"___"+viewBlock.primaryDimension[1]):null;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        activityData.reportLink = viewBlock.reportLink;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
        }

        activityData.dimension = collectXAXis(primaryDimensionName);

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        var min = 0, max = 0;
        var dataObject = {};
        var arr = [];
        activityData.formatString = viewBlock.y1DataFormat;
        activityData.measuresData = [];

        if(!viewBlock.primaryDimension){
            for(var i = 0; i < viewBlock.y1Measures.length; i++){
                max = 0;
                min = 0;
                dataObject = {};
                arr = [];
                var obj = {};
                obj.name = viewBlock.y1Measures[i][1];
                obj.dataName = viewBlock.y1Measures[i][1];
                obj.radius = '100%';
                obj.innerRadius = '100%';
                for(var j = 0; j < intLength; j++){
                    obj.y = blockData[j][viewBlock.y1Measures[i][0]+"___"+viewBlock.y1Measures[i][1]];
                }
                if(viewBlock.ChartStyle.viewScaleMaxValues[i].thresholdType == 0){
                    max = viewBlock.ChartStyle.viewScaleMaxValues[i].maxValue;
                }else{
                    for(var j = 0; j < intLength; j++){
                        if(max < blockData[j][viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[0]+"___"+viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[1]]){
                            max =  blockData[j][viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[0]+"___"+viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[1]];
                        }
                        if(min > blockData[j][viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[0]+"___"+viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[1]]){
                            min =  blockData[j][viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[0]+"___"+viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[1]];
                        }
                    }
                    max = max * viewBlock.ChartStyle.viewScaleMaxValues[i].times;
                }

                if(obj.y < min){
                    min = obj.y;
                }
                arr.push(obj);
                dataObject.min = min;
                dataObject.max = max;
                dataObject.data = arr;
                activityData.measuresData.push(dataObject);
            }
        }

        if(viewBlock.primaryDimension){
            for(var i = 0; i < viewBlock.y1Measures.length; i++){
                min = 0;
                max = 0;
                dataObject = {};
                arr = [];
                for(var j = 0; j < activityData.dimension.length; j++){
                    var obj = {};
                    obj.name = ((viewBlock.y1Measures.length > 1)?(activityData.dimension[j]+viewBlock.y1Measures[i][1]):activityData.dimension[i]);
                    obj.dataName = activityData.dimension[j];
                    obj.radius = '100%';
                    obj.innerRadius = '100%';
                    for(var k = 0; k < intLength; k++){
                        if(blockData[k][primaryDimensionName] == activityData.dimension[j]){
                            for(var key in blockData[k]){
                                if(key == (viewBlock.y1Measures[i][0]+"___"+viewBlock.y1Measures[i][1])){
                                    obj.y = blockData[k][viewBlock.y1Measures[i][0]+"___"+viewBlock.y1Measures[i][1]];
                                    break;
                                }
                            }
                            break;
                        }
                    }

                    if(obj.y < min){
                        min = obj.y;
                    }
                    arr.push(obj);
                }
                if(viewBlock.ChartStyle.viewScaleMaxValues[i].thresholdType == 0){
                    max = viewBlock.ChartStyle.viewScaleMaxValues[i].maxValue;
                }else{
                    for(var j = 0; j < intLength; j++){
                        if(max < blockData[j][viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[0]+"___"+viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[1]]){
                            max = blockData[j][viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[0]+"___"+viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[1]];
                        }
                        if(min > blockData[j][viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[0]+"___"+viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[1]]){
                            min = blockData[j][viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[0]+"___"+viewBlock.ChartStyle.viewScaleMaxValues[i].targetMeasure[1]];
                        }
                    }
                    max = max * viewBlock.ChartStyle.viewScaleMaxValues[i].times;
                }
                dataObject.min = min;
                dataObject.max = max;
                dataObject.data = arr;
                activityData.measuresData.push(dataObject);
            }
        }

        return activityData;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.highchart = {};
        $(this.chartID).find(".bda-chart-box").css('padding-top',0);
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var activityRowHeight = parseInt(parseInt($(this.chartID).find(".bda-chart-content").height()) / me.data.measuresData.length);
        for(var i = 0; i < me.data.measuresData.length; i++){
            $(this.chartID).find('.bda-chart-content').append('<div class="bda-activity-row bda-activity-row'+i+'" style="overflow: hidden; height: '+activityRowHeight/(100*$BDA.defaultRatio)+'rem"></div>');
            var activityColumnWidth = parseInt(parseInt($(this.chartID).find(".bda-chart-content").width() - 1) / me.data.measuresData[i].data.length);
            var borderWidth = ((activityRowHeight>=activityColumnWidth)?activityColumnWidth:activityRowHeight) * 0.085;
            for(var j = 0; j < me.data.measuresData[i].data.length; j++){
                var activityColumn = "";
                activityColumn = document.createElement('div');
                $(activityColumn).css({
                    "float": 'left',
                    "width": activityColumnWidth + 'px',
                    "height": activityRowHeight/(100*$BDA.defaultRatio)+'rem'
                });
                activityColumn.className = 'highchart-block';
                activityColumn.id = 'highchart'+i+j;
                drawHighchart(activityColumn,me.data.measuresData[i],i,j,borderWidth,activityColumnWidth,activityRowHeight);
                $(this.chartID).find('.bda-chart-content .bda-activity-row'+i).append(activityColumn);
            }
        }


        function drawHighchart(element,columnData,rowIndex,columnIndex,borderWidth,columnWidth,rowHeight){
            me.highchart['highchart'+rowIndex+columnIndex] = Highcharts.chart(element, {
                chart: {
                    type: 'solidgauge',
                    //marginTop: 0,
                    //marginLeft: 10*$BDA.defaultRatio,
                    backgroundColor: 'rgba(0,0,0,0)',
                    plotBackgroundColor: null,
                    spacing: 0
                },
                title: {
                    text: null,
                    style: {
                        fontSize: '0.12rem',
                        textOutline: "0 0 contrast"
                    }
                },
                tooltip: {
                    enabled: false,
                    borderWidth: 0,
                    backgroundColor: 'none',
                    shadow: false,
                    style: {
                        fontSize: borderWidth/100 + 'rem'
                    },
                    //pointFormat: '{series.name}<br><span style="color: {point.color}; font-weight: bold">{point.y}</span>',
                    positioner: function (labelWidth,labelHeight) {
                        //console.log(this);
                        //debugger;
                        //return {
                        //    x: columnWidth / 2 - labelWidth / 2,
                        //    y: rowHeight / 2 - labelHeight / 2 + 10
                        //};
                    }
                },
                pane: {
                    startAngle: 0,
                    endAngle: 360,
                    background: [{ // Track for Move
                        outerRadius: '110%',
                        innerRadius: '90%',
                        backgroundColor: Highcharts.Color(int2hex(viewBlock.ChartStyle.colorSequence[rowIndex])).setOpacity(0.3).get(),
                        borderWidth: 0
                    }]
                },
                yAxis: {
                    min: columnData.min,
                    max: columnData.max,
                    lineWidth: 0,
                    tickPositions: []
                },
                plotOptions: {
                    solidgauge: {
                        borderWidth: borderWidth/(100*$BDA.defaultRatio) + 'rem',
                        dataLabels: {
                            enabled: true,
                            useHTML: true,
                            formatter:function(){
                                var str = "";
                                var dataFontFamily = viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif';
                                var dataFontSize = viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem';
                                var dataFontWeight = viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold';
                                var dataFontStyle = viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal';
                                var dataTextDecoration = viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none';

                                str = '<span style="font-family:'+dataFontFamily+';font-size: '+dataFontSize+';font-weight:'+dataFontWeight+';font-style:'+dataFontStyle+';text-decoration:'+dataTextDecoration+';">'+$BDA.formatString.number(me.data.formatString,this.y)+'</span>';
                                if(viewBlock.ChartStyle.axisLabelShow){
                                    var fontFamily = viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif';
                                    var fontSize = viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size/100+'rem':'0.11rem';
                                    var fontWeight = viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100';
                                    var fontStyle = viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.italic?'italic':'normal'):'normal';
                                    var textDecoration = viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.underline?'underline':(viewBlock.ChartStyle.axisLabelFont.strikeout?'line-through':'none')):'none';
                                    str = str+'<br><span style="font-family:'+fontFamily+';font-size: '+fontSize+';font-weight:'+fontWeight+';font-style:'+fontStyle+';text-decoration:'+textDecoration+';">'+this.series.name+'</span>';

                                }
                                return str;
                            },
                            inside: true,
                            align: 'center',
                            verticalAlign: 'top',
                            borderWidth: 0,
                            //x: 0,
                            //y: 5,
                            zIndex: 99,
                            style: {
                                color: int2hex(viewBlock.ChartStyle.colorSequence[rowIndex]),
                                textOutline:"none"
                            }
                        },
                        linecap: 'round',
                        stickyTracking: false
                    },
                    series: {
                        animation: autoRefreshAnimation,
                        states:{
                            hover:{
                                enabled:true
                            },
                            select:{
                                enabled: false
                            }
                        },
                        allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((me.data.reportLink&&me.data.reportLink.reportID) || (viewBlock.reportLinks&&(viewBlock.reportLinks.count > 0)) ||viewBlock.linkage)),
                        cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((me.data.reportLink&&me.data.reportLink.reportID) || (viewBlock.reportLinks&&(viewBlock.reportLinks.count > 0)) ||viewBlock.linkage)))&&'pointer'
                    }
                },
                series: [{
                    name: columnData.data[columnIndex].dataName,
                    borderColor: int2hex(viewBlock.ChartStyle.colorSequence[rowIndex]),
                    data: [{
                        color: int2hex(viewBlock.ChartStyle.colorSequence[rowIndex]),
                        radius: '100%',
                        innerRadius: '100%',
                        y: columnData.data[columnIndex].y
                    }]
                }]
            });
        }

        function int2hex(rgbInt) {
            var red = (rgbInt >> 16) & 255;
            var green = (rgbInt >> 8) & 255;
            var blue = rgbInt & 255;
            return "#" + ((1 << 24) + (red << 16) + (green << 8) + blue).toString(16).slice(1);
        }
        $(this.chartID).find(".highchart-block").each(function(){
            $(this).find('.highcharts-data-labels').css({
                'left': '50%',
                'top': '50%',
                'margin-top': -$(this).find('.highcharts-data-labels .highcharts-label > span').height()/2,
                'margin-left': -$(this).find('.highcharts-data-labels .highcharts-label > span').width()/2
            }).find(".highcharts-label").css({
                'left': 0,
                'top': 0
            }).children("span").css({
                'left': 0,
                'top': 0,
                'text-align': 'center'
            });
        });

    }

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignActivityData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignActivityData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----子弹图*/
function BulletChart(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.highchart = {};

    this.data = assignBulletData();

    function getLength(str,size){
        $('.test-length span').css('font-size',size);
        return parseFloat($('.test-length span').html(str).width() + 20);
    }

    function assignBulletData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var bulletData = {};
        var blockData = viewBlock.blockDataToDraw;
        var intLength = blockData.length;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        bulletData.reportLink = viewBlock.reportLink;

        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
        }

        bulletData.dimension = collectXAXis(primaryDimensionName);

        function collectXAXis(dimension){
            var arr=[];
            for (var p=0;p<blockData.length;p++){
                for (var d=0;d<arr.length;d++){
                    if (arr[d] == blockData[p][dimension]){
                        break;
                    }
                }
                d == arr.length && arr.push(blockData[p][dimension]);
            }
            return arr;
        }

        bulletData.measuresData = [];
        bulletData.y1DataFormat = viewBlock.y1DataFormat;
        if(!viewBlock.primaryDimension){
            for(var i = 0; i < viewBlock.y1Measures.length; i++){
                var targetValue = 0;
                var obj = {};
                obj.name = viewBlock.y1Measures[i][1];
                obj.unit = viewBlock.viewBulletWarnings[i].unit;
                obj.color = $BDA.csharp2rgba(viewBlock.viewBulletWarnings[i].color);
                obj.data = [];
                obj.warningInterval = [];

                for(var j = 0; j < intLength; j++){
                    var arr = [];
                    var tempObj = {};
                    var tempDataObj = {};
                    tempDataObj.data = [];
                    tempObj.y = blockData[j][viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]];
                    if(viewBlock.viewBulletWarnings[i].thresholdType == 0){
                        tempObj.target = viewBlock.viewBulletWarnings[i].targetValue;
                    }else if(viewBlock.viewBulletWarnings[i].thresholdType == 1){
                        for(var k = 0; k < intLength; k++){
                            tempObj.target = blockData[k][viewBlock.viewBulletWarnings[i].targetMeasure[0]+"___"+viewBlock.viewBulletWarnings[i].targetMeasure[1]];
                            break;
                        }
                    }
                    targetValue = tempObj.target;
                    tempDataObj.name = viewBlock.y1Measures[i][1];
                    arr.push(tempObj);
                    tempDataObj.data = arr;
                    obj.data.push(tempDataObj);
                }

                for(var j = 0; j < viewBlock.viewBulletWarnings[i].intervals.length; j++){
                    var tempObj = {};
                    if(viewBlock.viewBulletWarnings[i].thresholdType == 0){
                        tempObj.from = viewBlock.viewBulletWarnings[i].intervals[j].fromThreshold;
                        tempObj.to = (j==viewBlock.viewBulletWarnings[i].intervals.length-1)?'9e9':viewBlock.viewBulletWarnings[i].intervals[j].endThreshold;
                        tempObj.color = $BDA.csharp2rgba(viewBlock.viewBulletWarnings[i].intervals[j].color);
                    }else if(viewBlock.viewBulletWarnings[i].thresholdType == 1){
                        tempObj.from = (viewBlock.viewBulletWarnings[i].intervals[j].fromThreshold/100)*targetValue;
                        tempObj.to = (viewBlock.viewBulletWarnings[i].intervals[j].endThreshold/100)*targetValue;
                        tempObj.color = $BDA.csharp2rgba(viewBlock.viewBulletWarnings[i].intervals[j].color);
                    }
                    obj.warningInterval.push(tempObj);
                }
                bulletData.measuresData.push(obj);
            }
        }

        if(viewBlock.primaryDimension){
            for(var i = 0; i < viewBlock.y1Measures.length; i++){
                for(var j = 0; j < bulletData.dimension.length; j++){
                    var targetValue = 0;
                    var obj = {};
                    obj.name = viewBlock.y1Measures.length>1?(bulletData.dimension[j]+viewBlock.y1Measures[i][1]):bulletData.dimension[j];
                    obj.unit = viewBlock.viewBulletWarnings[i].unit;
                    obj.color = $BDA.csharp2rgba(viewBlock.viewBulletWarnings[i].color);
                    obj.data = [];
                    obj.warningInterval = [];
                    for(var k = 0; k < intLength; k++){
                        if(bulletData.dimension[j] == blockData[k][primaryDimensionName]){
                            var tempObj = {};
                            var arr = [];
                            var tempDataObj = {};
                            tempDataObj.data = [];
                            tempObj.y = blockData[k][viewBlock.y1Measures[i][0]+'___'+viewBlock.y1Measures[i][1]];
                            if(viewBlock.viewBulletWarnings[i].thresholdType == 0){
                                tempObj.target = viewBlock.viewBulletWarnings[i].targetValue;
                            }else if(viewBlock.viewBulletWarnings[i].thresholdType == 1){
                                for(var m = 0; m < intLength; m++){
                                    for(var key in blockData[m]){
                                        if(blockData[m][key] ==bulletData.dimension[j]){
                                            tempObj.target = blockData[m][viewBlock.viewBulletWarnings[i].targetMeasure[0]+"___"+viewBlock.viewBulletWarnings[i].targetMeasure[1]];
                                            break;
                                        }
                                    }
                                }
                            }
                            targetValue = tempObj.target;
                            arr.push(tempObj);
                            tempDataObj.data = arr;
                            tempDataObj.name = bulletData.dimension[j];
                            obj.data.push(tempDataObj);
                        }
                    }
                    for(var k = 0; k < viewBlock.viewBulletWarnings[i].intervals.length; k++){
                        var tempObj = {};
                        if(viewBlock.viewBulletWarnings[i].thresholdType == 0){
                            tempObj.from = viewBlock.viewBulletWarnings[i].intervals[k].fromThreshold;
                            tempObj.to = viewBlock.viewBulletWarnings[i].intervals[k].endThreshold;
                            tempObj.color = $BDA.csharp2rgba(viewBlock.viewBulletWarnings[i].intervals[k].color);
                        }else if(viewBlock.viewBulletWarnings[i].thresholdType == 1){
                            tempObj.from = (viewBlock.viewBulletWarnings[i].intervals[k].fromThreshold/100)*targetValue;
                            tempObj.to = (viewBlock.viewBulletWarnings[i].intervals[k].endThreshold/100)*targetValue;
                            tempObj.color = $BDA.csharp2rgba(viewBlock.viewBulletWarnings[i].intervals[k].color);
                        }
                        obj.warningInterval.push(tempObj);
                    }
                    bulletData.measuresData.push(obj);
                }
            }
        }

        var labelsWidthArr = [];
        for(var i = 0; i < bulletData.measuresData.length; i++){
            var strWidth = getLength(bulletData.measuresData[i].name,(viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size+'px':'11px'));
            labelsWidthArr.push(strWidth);
        }
        var marginLeft = Math.max.apply(null,labelsWidthArr);
        bulletData.marginLeft = marginLeft;

        return bulletData;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.highchart = {};
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0 || viewBlock.y1Measures.length == 0){return;}

        var bulletRowHeight = $(this.chartID).find(".bda-chart-content").height() / me.data.measuresData.length;
        var bulletWidth = $(this.chartID).find(".bda-chart-content").width();

        for(var i = 0; i < this.data.measuresData.length; i++){
            var bulletColumn = "";
            bulletColumn = document.createElement('div');
            bulletColumn.style.height = (bulletRowHeight>=85?85:bulletRowHeight)/100+'rem';
            bulletColumn.style.width = bulletWidth/(100*$BDA.defaultRatio)+"rem";
            bulletColumn.className = 'highchart-block';
            bulletColumn.id = 'highchart'+i;
            drawHighchart(bulletColumn,me.data.measuresData[i],i);
            $(this.chartID).find('.bda-chart-content').append(bulletColumn);
        }

        function drawHighchart(element,measureData,index){
            me.highchart['highchart'+index] = Highcharts.chart(element, {
                chart: {
                    inverted: true,
                    marginLeft: me.data.marginLeft*$BDA.defaultRatio,
                    type: 'bullet',
                    backgroundColor: 'rgba(0,0,0,0)',
                    plotBackgroundColor: null
                },
                title: {
                    text: null
                },
                xAxis: {
                    categories: ['<span class="hc-cat-title">'+measureData.name+'</span><br>'+measureData.unit],
                    labels:{
                        style:{
                            fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                            fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                        }
                    }
                },
                legend: {
                    enabled: false
                },
                plotOptions: {
                    series: {
                        animation: autoRefreshAnimation,
                        dataLabels:{
                            enabled: viewBlock.ChartStyle.dataShow,
                            formatter:function(){
                                return $BDA.formatString.number(me.data.y1DataFormat,this.y);
                            },
                            style: {
                                fontFamily: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                                fontSize: viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size/100+'rem':'0.11rem',
                                fontWeight: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold',
                                fontStyle: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.italic?'italic':'normal'):'normal',
                                textDecoration: viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')):'none'
                            }
                        },
                        pointPadding: 0.25,
                        borderWidth: 0,
                        color: measureData.color,
                        targetOptions: {
                            width: '200%'
                        },
                        allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((me.data.reportLink&&me.data.reportLink.reportID) || (viewBlock.reportLinks&&(viewBlock.reportLinks.count > 0)) ||viewBlock.linkage)),
                        cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((me.data.reportLink&&me.data.reportLink.reportID) || (viewBlock.reportLinks&&(viewBlock.reportLinks.count > 0)) ||viewBlock.linkage)))&&'pointer'
                    }
                },
                yAxis: {
                    plotBands: measureData.warningInterval,
                    labels: {
                        enabled: viewBlock.ChartStyle.showScale,
                        style:{
                            fontFamily: viewBlock.ChartStyle.scaleFont?((viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.scaleFont?viewBlock.ChartStyle.scaleFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.bold?'bold':'100'):'100',
                            fontStyle: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.scaleFont?(viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    title: null,
                    gridlineWidth: viewBlock.ChartStyle.y1ScaleLineWidth?viewBlock.ChartStyle.y1ScaleLineWidth*$BDA.defaultRatio:0,
                    gridLineColor: viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#ccd6eb'
                },
                series: measureData.data,
                tooltip: {
                    enabled: viewBlock.ChartStyle.dataHoverShow,
                    pointFormatter: function(){
                        return '<b>'+$BDA.formatString.number(me.data.y1DataFormat,this.y)+'</b>（目标值'+$BDA.formatString.number(me.data.y1DataFormat,this.target)+'）';
                    },
                    style: {
                        fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                    }
                }
            });
        }
    }

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignBulletData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignBulletData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类---折叠表格*/
function FoldingTable(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = foldingTableData();

    function foldingTableData(){
        if(viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var foldingTable = {};
        var blockData = [];
        var measuesNameArr = [];
        var changeMeasuresNameArr = [];
        for(var i = 0; i < viewBlock.foldingMeasures.count; i++){
            measuesNameArr.push(viewBlock.foldingMeasures.item(i).measureObject[0] + "___" + viewBlock.foldingMeasures.item(i).measureObject[1]);
            changeMeasuresNameArr.push("name"+(i+1));
        }
        $.extend(true,blockData,viewBlock.blockDataToDraw);
        for(var i = 0; i < blockData.length; i++){
            for(var key in blockData[i]){
                for(var j = 0; j < measuesNameArr.length; j++){
                    if(key == measuesNameArr[j]){
                        blockData[i]["name"+(j+1)] = blockData[i][key];
                        delete blockData[i][key];
                    }
                }
            }
        }

        var dimensionNameArr = [];
        for (var i = 0; i < viewBlock.dimensions.count; i++){
            dimensionNameArr.push(viewBlock.dimensions.item(i).dimensionObject[0] + "___" + viewBlock.dimensions.item(i).dimensionObject[1]);
        }

        foldingTable.formatString = {};
        for(var i = 0; i < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; i++){
            if(viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i].cellObject[2]==1){
                foldingTable.formatString["name"+i] = viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i].formatString;
            }
        }

        var setWidthBlockData = [];
        $.extend(true,setWidthBlockData,blockData);

        var setWidthHashTables = [];
        for (var i = 0; i < viewBlock.dimensions.count; i++){
            var hashTable = new HashTable();
            setWidthHashTables.push(hashTable);
        }

        foldingTable.tableHeadStyle = [];
        foldingTable.tableHead = [];
        for(var i = 0; i < viewBlock.viewTableHead.viewTableRows.length; i++){
            var tableRow = [];
            for(var j = 0; j < viewBlock.viewTableHead.viewTableRows[i].viewTableCells.length; j++){
                var tableCell = viewBlock.viewTableHead.viewTableRows[i].viewTableCells[j];
                if(tableCell.colspan && tableCell.rowspan){
                    var tempObj = {};
                    if(tableCell.colspan==1){
                        tempObj.field = "name"+j;
                    }
                    if(!tableCell.formatString){
                        if(tableCell.cellObject[3] != 1){
                            tempObj.title = tableCell.text===null?"":tableCell.text;
                        }else{
                            tempObj.title = (!isNaN(tableCell.text))?$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text))):tableCell.text;
                        }
                    }else {
                        if(tableCell.cellObject[3] <= 0){
                            tempObj.title = tableCell.text===null?"":tableCell.text;
                        }else if(tableCell.cellObject[3] == 1){
                            tempObj.title = (!isNaN(tableCell.text))?$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text))):tableCell.text;
                        }else{
                            tempObj.title = $BDA.formatString.number(tableCell.formatString,(!isNaN(tableCell.text))?(Number(tableCell.text) || ''):(tableCell.text || ''));
                        }
                    }
                    tempObj.colspan = tableCell.colspan;
                    tempObj.rowspan = tableCell.rowspan;
                    foldingTable.tableHeadStyle.push({
                        "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                        "backgroundColor": $BDA.csharp2rgba(tableCell.cellTextBox.backgroundColor),
                        "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                        "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                        "font-family": tableCell.cellTextBox.font.fontFamily,
                        'font-size': tableCell.cellTextBox.font.size/100+"rem",
                        'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                        'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                        'text-decoration': tableCell.cellTextBox.font.underline?'underline':
                            (tableCell.cellTextBox.font.strikeout?'line-through':'none')
                    })
                    tableRow.push(tempObj);
                }
            }

            foldingTable.tableHead.push(tableRow);
        }

        var id = 1;
        foldingTable.tableBodyData = [];
        var hashTables = [];
        for (var i = 0; i < viewBlock.dimensions.count; i++){
            var hashTable = new HashTable();
            hashTables.push(hashTable);
        }

        for(var row = 0; row < blockData.length; row++){
            var rowDimensions = [];
            var col = 0;
            var oldKeyList = "";
            var keyList = "";
            for(var key in blockData[row]){
                var colValue = blockData[row][key];
                if(col < dimensionNameArr.length){
                    keyList += "_"+colValue;
                    if(hashTables[col].containsKey(keyList)){
                        rowDimensions.push(hashTables[col].getValue(keyList));
                    }else {
                        var jObject = {};
                        jObject.id = id++;
                        if (viewBlock.dimensions.item(col).dimensionObject[3]==1){
                            jObject["name"+0] = $BDA.formatString.date(viewBlock.foldingDimensionFormatStrings[col],new Date(colValue));
                        } else if (viewBlock.dimensions.item(col).dimensionObject[3]==2){
                            jObject["name"+0] = $BDA.formatString.number(viewBlock.foldingDimensionFormatStrings[col],colValue);
                        }else{
                            jObject["name"+0] = colValue===null?"":colValue;
                        }
                        for(var i = 0; i < changeMeasuresNameArr.length; i++){
                            jObject[changeMeasuresNameArr[i]+"unformated"] = 0;
                            jObject[changeMeasuresNameArr[i]] = 0;
                        }
                        if(col == 0){
                            foldingTable.tableBodyData.push(jObject);
                        }else {
                            var parentNode = hashTables[col - 1].getValue(oldKeyList);
                            if(!parentNode.children){
                                parentNode.children = [];
                                parentNode.state = "closed";
                            }
                            parentNode.children.push(jObject);
                        }
                        hashTables[col].add(keyList,jObject);
                        rowDimensions.push(jObject);
                    }
                    oldKeyList += "_"+colValue;
                }else {
                    var colValue = blockData[row][key];
                    for(var i = 0; i < rowDimensions.length; i++){
                        rowDimensions[i][key+"unformated"] += colValue;
                        rowDimensions[i][key] = $BDA.formatString.number(foldingTable.formatString[key],rowDimensions[i][key+"unformated"]);
                    }
                }
                col++;
            }
        }

        var tempObject = {};
        var measureValue = 0;
        tempObject.id = id;
        var expressionCell = [];
        for(var i = 0; i < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; i++){
            if(i==0){
                tempObject['name'+i] = '总计';
            }else{
                var tableCell = viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i];
                var valueIsExist = false;
                var expression = [];
                if(tableCell.cellObject[4] && tableCell.cellObject[5] && tableCell.cellObject[4] == "true"){
                    expressionCell.push("name"+tableCell.columnIndex);
                    expression = getExpression(tableCell.cellObject[5]);
                    for(var j = 0; j < expression.length; j++){
                        if(expression[j].indexOf("___") != -1){
                            var tableBodyKey = 0;
                            valueIsExist = false;
                            for(var k = 0; k < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; k++){
                                var tableBodyCell = viewBlock.viewTableBody.viewTableRows[0].viewTableCells[k];
                                if((tableBodyCell.cellObject[0]+"___"+tableBodyCell.cellObject[1]) == expression[j]){
                                    valueIsExist = true;
                                    tableBodyKey = tableBodyCell.columnIndex;
                                    break;
                                }
                            }
                            if(valueIsExist){
                                expression[j] = "name"+tableBodyKey;
                            }
                        }
                    }
                }
                measureValue = 0;
                for(var j = 0; j < foldingTable.tableBodyData.length; j++){
                    measureValue += foldingTable.tableBodyData[j]['name'+i+'unformated'];
                }
                if(valueIsExist){
                    tempObject['name'+i] = expression;
                }else{
                    tempObject['name'+i] = $BDA.formatString.number(foldingTable.formatString['name'+i],measureValue)
                    tempObject['name'+i+'unformated'] = measureValue
                }
            }
        }
        for(var key in tempObject){
            if(expressionCell.indexOf(key) != -1){
                for(var i = 0; i < tempObject[key].length; i++){
                    if(tempObject[key][i].indexOf("name") != -1){
                        tempObject[key][i] = "("+tempObject[tempObject[key][i]+'unformated']+")";
                    }
                }
                tempObject[key] = $BDA.formatString.number(foldingTable.formatString[key],eval(tempObject[key].join("")));
            }
        }
        if(viewBlock.rowTotal){
            foldingTable.tableBodyData.push(tempObject);
        }

        function getExpression(str){
            var reg = new RegExp("\\][.]\\[", "g");
            var newStr = str.replace(reg, "___");
            var tempArr = [];
            var isStar = false;
            var tempStr = "";
            for(var i = 0; i < newStr.length;i++){
                if(newStr[i] == "["){
                    isStar = true;
                    tempStr = "";
                    continue;
                }
                if(newStr[i] == "]"){
                    isStar = false;
                    tempArr.push(tempStr);
                    continue;
                }
                if(isStar){
                    tempStr += newStr[i];
                    continue;
                }
                if(!isStar){
                    tempArr.push(newStr[i]);
                    continue;
                }
            }
            return tempArr;
        }

        for(var i = 0; i < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; i++){
            var tableCell = viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i];
            if(tableCell.cellObject[4] && tableCell.cellObject[5] && tableCell.cellObject[4] == "true"){
                var expression = getExpression(tableCell.cellObject[5]);
                var valueIsExist = false;
                for(var j = 0; j < expression.length; j++){
                    if(expression[j].indexOf("___") != -1){
                        var tableBodyKey = 0;
                        valueIsExist = false;
                        for(var k = 0; k < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; k++){
                            var tableBodyCell = viewBlock.viewTableBody.viewTableRows[0].viewTableCells[k];
                            if((tableBodyCell.cellObject[0]+"___"+tableBodyCell.cellObject[1]) == expression[j]){
                                valueIsExist = true;
                                tableBodyKey = tableBodyCell.columnIndex;
                                break;
                            }
                        }
                        if(valueIsExist){
                            expression[j] = "name"+tableBodyKey;
                        }
                    }
                }
                if(valueIsExist){
                    for(var j = 0; j < foldingTable.tableBodyData.length; j++){
                        if(foldingTable.tableBodyData[j].children){
                            var finalExpression = $.extend(true,[],expression);
                            for(var key in foldingTable.tableBodyData[j]){
                                if(key == ("name"+i)){
                                    var tempArr = $.extend(true,[],expression);
                                    for(var k = 0; k < expression.length; k++){
                                        if(expression[k].indexOf("name") != -1){
                                            tempArr[k] = "("+foldingTable.tableBodyData[j][tempArr[k]+'unformated']+")";
                                        }
                                    }
                                    foldingTable.tableBodyData[j][key] = $BDA.formatString.number(foldingTable.formatString[key],eval(tempArr.join("")))
                                }
                            }
                            childrenExpression(foldingTable.tableBodyData[j].children,finalExpression);
                        }
                    }
                }
            }
        }

        function childrenExpression(childrenTableBodyData,expression){
            for(var j = 0; j < childrenTableBodyData.length; j++){
                if(childrenTableBodyData[j].children){
                    var finalExpression = $.extend(true,[],expression);
                    for(var key in childrenTableBodyData[j]){
                        if(key == ("name"+i)){
                            var tempArr = $.extend(true,[],expression);
                            for(var k = 0; k < expression.length; k++){
                                if(expression[k].indexOf("name") != -1){
                                    tempArr[k] = "("+childrenTableBodyData[j][tempArr[k]+'unformated']+")";
                                }
                            }
                            childrenTableBodyData[j][key] = $BDA.formatString.number(foldingTable.formatString[key],eval(tempArr.join("")))
                        }
                    }
                    childrenExpression(childrenTableBodyData[j].children,finalExpression);
                }
            }
        }
        
        return foldingTable;

        function HashTable() {
            var size = 0;
            var entry = new Object();
            this.add = function (key, value) {
                if (!this.containsKey(key)) {
                    size++;
                }
                entry[key] = value;
            }
            this.getValue = function (key) {
                return this.containsKey(key) ? entry[key] : null;
            }
            this.remove = function (key) {
                if (this.containsKey(key) && (delete entry[key])) {
                    size--;
                }
            }
            this.containsKey = function (key) {
                return (key in entry);
            }
            this.containsValue = function (value) {
                for (var prop in entry) {
                    if (entry[prop] == value) {
                        return true;
                    }
                }
                return false;
            }
            this.getValues = function () {
                var values = new Array();
                for (var prop in entry) {
                    values.push(entry[prop]);
                }
                return values;
            }
            this.getKeys = function () {
                var keys = new Array();
                for (var prop in entry) {
                    keys.push(prop);
                }
                return keys;
            }
            this.getSize = function () {
                return size;
            }
            this.clear = function () {
                size = 0;
                entry = new Object();
            }
        }
    }

    this.draw = function(fltHeight,openDrilldown,hierachies){
        $(this.chartID).find('.bda-data').css('display','none');
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        var tempStr = "10,10,10,10";
        var paddingArr = viewBlock.padding?viewBlock.padding.split(","):tempStr.split(",");
        $(this.chartID).find('.bda-chart-content').css({
            "padding-top": Number($.trim(paddingArr[0]))/100 + "rem",
            "padding-right": Number($.trim(paddingArr[1]))/100 + "rem",
            "padding-bottom": Number($.trim(paddingArr[2]))/100 + "rem",
            "padding-left": Number($.trim(paddingArr[3]))/100 + "rem"
        });

        this.setChartContentHeight(fltHeight);

        if(viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var userAgent = window.navigator.userAgent;
        var isWebkit = false;
        if(userAgent.indexOf('Chrome') != -1){
            isWebkit = true;
        }

        var tableHeight = $(this.chartID).find('.bda-chart-content').height();
        var tableWidth = $(this.chartID).find('.bda-chart-content').width();
        var table = document.createElement('table');

        $(this.chartID).find('.bda-chart-content').html('');

        $(table).css({
            width: tableWidth,
            height: tableHeight
        });

        $(this.chartID).find(".bda-chart-content").append(table);
        $(table).treegrid({
            url:null,
            //fitColumns: true,
            idField:'id',
            treeField:'name0',
            rowStyler: function(){
                return "height:"+(((viewBlock.bodyHeight || viewBlock.bodyHeight==0)?viewBlock.bodyHeight:30)/100+'rem');
            },
            columns:this.data.tableHead,
            onLoadSuccess: function(){
                setBodyStyle();

                var indexType = viewBlock.tableStyle?viewBlock.tableStyle:0;
                setBorderType(indexType);

                var currentTableWidth = $(me.chartID).find(".datagrid-view2 table.datagrid-htable").width();
                var scrollWidth = isWebkit?10:17;
                //var currentTableHeight = me.data.tableHead.length * viewBlock.headHeight + me.data.tableBodyData.length * viewBlock.bodyHeight;
                if(tableWidth - currentTableWidth > scrollWidth){
                    //scrollWidth = currentTableHeight<=tableHeight?0:scrollWidth;
                    setWidth(scrollWidth,indexType);
                }
            }
        }).treegrid('loadData', this.data.tableBodyData);

        $(this.chartID).find('.datagrid-header-row td').each(function(i){
            $(this).css(me.data.tableHeadStyle[i]);
        }).children().each(function(i){
            $(this).css(me.data.tableHeadStyle[i]);
        });

        if ($BDA.theme.themeID){
            $(this.chartID).find('.datagrid-header-row td').each(function(){
                $(this).css({
                    "background-color":$BDA.theme.currentBackgroundColor,
                    "color":"#fff"
                });
            }).find('div,span').each(function(){
                $(this).css({
                    "background-color":$BDA.theme.currentBackgroundColor,
                    "color":"#fff"
                });
            });
        }

        function setBorderType(type){
            if(viewBlock.tableStyleColor && !$BDA.theme.themeID){
                $(me.chartID).find(".datagrid-view2 td").css({
                    "border-color": "rgba("+int2hex(viewBlock.tableStyleColor,2)+",.3)"
                });
            }
            switch (type){
                case 0:
                    break;
                case 1:
                    $(me.chartID).find("td").each(function(){
                        if($(this).attr("field") != "name"+(viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length-1)){
                            $(this).css({
                                "border-right": 0
                            });
                        }
                    });
                    break;
                case 2:
                    $(me.chartID).find("td").each(function(){
                        $(this).css({
                            "border-right": 0,
                            "border-left": 0
                        });
                    });
                    $(me.chartID).find(".datagrid-view2 .datagrid-body td").each(function(){
                        $(this).css({
                            "border-right": 0,
                            "border-left": 0,
                            "border-bottom":  0
                        });
                    });
                    break;
                case 3:
                    $(me.chartID).find("td").each(function(){
                        $(this).css({
                            "border-right": 0,
                            "border-left": 0
                        });
                    });
                    $(me.chartID).find(".datagrid-view2 .datagrid-body td").each(function(){
                        $(this).css({
                            "border-right": 0,
                            "border-left": 0,
                            "border-bottom":  0
                        });
                    });
                    $(me.chartID).find(".datagrid-view2 .datagrid-header-inner td").each(function(){
                        $(this).css({
                            "border-top": 0
                        });
                    });
                    break;
            }
        }

        function sumWidth(arry){
            var sumArry = 0;
            for(var i= 0;i<arry.length;i++){
                sumArry += arry[i];
            }
            return sumArry;
        }

        function setWidth(scrollWidth,indexType){
            var borderTypeWidth = indexType?(indexType==1?2:0):(viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length + 1);
            var widthArr = [];
            $(me.chartID).find(".datagrid-view2 .datagrid-body").children(".datagrid-btable").find("tr").eq(0).find("td").each(function(){
                widthArr.push($(this).width());
            });
            var averageWidth = Math.floor((tableWidth - scrollWidth - borderTypeWidth*$BDA.defaultRatio - sumWidth(widthArr))/viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length);
            for(var i = 0; i < widthArr.length; i++){
                widthArr[i] = parseInt(widthArr[i]+averageWidth);
            }
            widthArr[widthArr.length-1] = tableWidth - scrollWidth - borderTypeWidth*$BDA.defaultRatio - sumWidth(widthArr) + widthArr[widthArr.length-1];

            $(me.chartID).find("tr td").find("div").css("width","100%");
            for(var i = 0; i < widthArr.length; i++){
                $(me.chartID).find("tr td[field=name"+i+"]").find("div").css("width",widthArr[i]);
            }
        }

        function setBodyStyle(){
            $(me.chartID).find('.datagrid-view2 .datagrid-header-inner td').each(function(i){
                $(this).css(me.data.tableHeadStyle[i]).find(".datagrid-cell span:first-child").css(me.data.tableHeadStyle[i]);
            });
            /*表头行高*/
            $(me.chartID).find('tr.datagrid-header-row').css({
                "height": (viewBlock.headHeight || viewBlock.headHeight == 0)?viewBlock.headHeight/100+"rem":0.30+"rem"
            });
            $(me.chartID).find(".datagrid-header").css({
                "height": ((viewBlock.headHeight || viewBlock.headHeight == 0)?viewBlock.headHeight*$BDA.defaultRatio:30*$BDA.defaultRatio)*viewBlock.viewTableHead.viewTableRows.length
            });
            $(me.chartID).find("table.datagrid-htable").css({
                "height": ((viewBlock.headHeight || viewBlock.headHeight == 0)?viewBlock.headHeight*$BDA.defaultRatio:30*$BDA.defaultRatio)*viewBlock.viewTableHead.viewTableRows.length
            });
            var bodyHeight = $(me.chartID).find(".datagrid-view").height();
            $(me.chartID).find(".datagrid-body").css({
                "height": (bodyHeight - (((viewBlock.headHeight || viewBlock.headHeight == 0)?viewBlock.headHeight*$BDA.defaultRatio:30*$BDA.defaultRatio)*viewBlock.viewTableHead.viewTableRows.length))
            });

            var tableCells = viewBlock.viewTableBody.viewTableRows[0].viewTableCells;
            $(me.chartID).find(".datagrid-view2 .datagrid-body tr").each(function(){
                $(this).find("td").each(function(i){
                    if($(this).attr("field") == "name"+i){
                        $(this).css({
                            "color": $BDA.csharp2rgba(tableCells[i].cellTextBox.color),
                            "backgroundColor": $BDA.csharp2rgba(tableCells[i].cellTextBox.backgroundColor),
                            "textAlign": tableCells[i].cellTextBox.textAlign=='0'?'left':(tableCells[i].cellTextBox.textAlign=='1'?'center':'right'),
                            "verticalAlign": tableCells[i].cellTextBox.verticalAlign=='0'?'top':(tableCells[i].cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                            "font-family": tableCells[i].cellTextBox.font.fontFamily,
                            'font-style': tableCells[i].cellTextBox.font.italic?'italic':'normal',
                            'font-weight': tableCells[i].cellTextBox.font.bold?'bold':'normal'
                        }).find("div,.tree-title").css({
                            'font-size': tableCells[i].cellTextBox.font.size/100+"rem",
                            'text-decoration': tableCells[i].cellTextBox.font.underline?'underline':
                                (tableCells[i].cellTextBox.font.strikeout?'line-through':'none')
                        });
                    }
                });
            });

        }

        function int2hex(rgbInt,isTrue) {
            var red = (rgbInt >> 16) & 255;
            var green = (rgbInt >> 8) & 255;
            var blue = rgbInt & 255;
            if(isTrue){
                isTrue == 1 ? ((red - 48 >= 0)?(red = red - 48):0):((red + 24 > 255)?255:(red = red + 24));
                isTrue == 1 ? ((green - 48 >= 0)?(green = green - 48):0):((green + 24 > 255)?255:(green = green + 24));
                isTrue == 1 ? ((blue - 48 >= 0)?(blue = blue - 48):0):((blue + 24 > 255)?255:(blue = blue + 24));
            }
            return red+","+green+","+blue;
        }
    }

    this.refreshByLinkage=function(fltHeight){
        this.data = foldingTableData();
        me.draw(fltHeight);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = foldingTableData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----轮播图*/
function WheelFrame(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.draw = function(fltHeight, openDrilldown){
        $(this.chartID).find('h3').css('display','none');
        $(this.chartID).find('.bda-chart-box').css('padding',0);
        this.setChartContentHeight(fltHeight);

        $(this.chartID).find('.bda-picture-content').remove();
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-picture-content" id="'+viewBlock.blockID+'"></div>');
        var contentWidth = $(this.chartID).find('.bda-chart-content').width();
        var contentHeight = fltHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        contentHeight = contentHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        $(this.chartID).find('.bda-chart-content').css('height',contentHeight/(100*$BDA.defaultRatio)+"rem");
        $(me.chartID).find('.bda-picture-content').css({
            'width': "100%",
            'height': contentHeight/(100*$BDA.defaultRatio)+"rem"
        });
        var min = Math.min(contentHeight,contentWidth);
        if(viewBlock.images.length){
            for(var i = 0; i < viewBlock.images.length; i++){
                var uLi = document.createElement("li");
                if(viewBlock.showCircleImage){
                    var htmlStr = '<li style="height:'+contentHeight+'px; width:'+contentWidth+'px; display: table-cell; text-align: center; vertical-align: middle; margin-top:'+(contentHeight-min)/2+'px;"><img src="/Report/'+viewBlock.images[i].imageURL+'" width="'+min+'" height="'+min+'" style="border-radius: 50%;"></li>';
                    $('#'+viewBlock.blockID).append(htmlStr);
                }else{
                    var style = "border-radius:"+viewBlock.imageRadius.replace(/\,/g,'px ') +"px; height:"+contentHeight+"px;background-image:url('/Report/"+viewBlock.images[i].imageURL+"');background-position:center top; background-repeat:no-repeat;background-size:"+(viewBlock.tileMode?(viewBlock.tileMode == 1?'auto':'contain'):'100% 100%');
                    uLi.style.cssText = style;
                    $('#'+viewBlock.blockID).append(uLi);
                }
            }
            $('#'+viewBlock.blockID).lightSlider({
                item:1,
                slideMargin: 0,
                speed:500,
                pause:viewBlock.carouselInterval*1000,
                auto:viewBlock.carouselInterval?true:false,
                loop:true
            });
        }
        if (viewBlock.reportLink || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0)){
            $(this.chartID).find('.bda-chart-content').hover(function(){
                $(this).css('cursor','pointer');
            });
        }
    }

    this.refreshByLinkage=function(){
        return;
    }

    this.autoRefresh=function(fltHeight, openDrilldown){
        this.draw(fltHeight, openDrilldown);
    }
}

/*类----词云图*/
function WordCloud(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.highchart = null;

    this.data = assignWordCloudData();

    function assignWordCloudData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var wordCloudData = {};
        var blockData = viewBlock.blockDataToDraw;
        var intLength = blockData.length;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
        }
        wordCloudData.measuresData = [];
        wordCloudData.formatString = viewBlock.y1DataFormat;
        wordCloudData.measureName = viewBlock.y1Measures.length?viewBlock.y1Measures[0][1]:"";
        for(var intI = 0; intI < intLength; intI++){
            var item = {};

            item.name = blockData[intI][primaryDimensionName];
            item.weight = viewBlock.y1Measures.length?blockData[intI][(viewBlock.y1Measures[0][0]+'___'+viewBlock.y1Measures[0][1])]:null;

            wordCloudData.measuresData.push(item);
        }
        wordCloudData.reportLink = viewBlock.reportLink;

        return wordCloudData;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}
        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0],{
            chart: {
                type:'wordcloud',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                plotBorderWidth: null,
                pltShadow: false
            },
            colors: $BDA.theme.themeID==0?(viewBlock.ChartStyle.colorSequence.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" "):$BDA.theme.defaultTheme.colors):($BDA.theme.themeID==1?$BDA.theme.highcharts[0].colors:$BDA.theme.highcharts[1].colors),
            title: {
                text: null
            },
            plotOptions:{
                series: {
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    animation: autoRefreshAnimation,
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            tooltip: {
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter:function(){
                    return this.key + '<br>' + (me.data.measureName?(me.data.measureName+' :  '+$BDA.formatString.number(me.data.formatString,this.point.weight)):'');
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: [{
                //type: 'wordcloud',
                data: this.data.measuresData
            }]
        });
    }

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignWordCloudData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignWordCloudData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----水波图*/
function WaterWaveChart(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;
    var requestID = null;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = waterWaveData();

    function waterWaveData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}
        var blockData = viewBlock.blockDataToDraw;
        var waterWaveData = {};
        waterWaveData.measureName = viewBlock.y1Measures[0][1];

        for(var i = 0; i < viewBlock.y1Measures.length; i++){
            for(var j = 0; j < blockData.length; j++){
                waterWaveData.data = blockData[j][viewBlock.y1Measures[i][0]+"___"+viewBlock.y1Measures[i][1]];
            }
        }
        waterWaveData.reportLink = viewBlock.reportLink;

        return waterWaveData;
    }

    this.draw = function(fltHeight, openDrilldown){
        if(requestID){
            cancelAnimationFrame(requestID);
            requestID = null;
        }
        $(this.chartID).find(".chart-drill-toolbar").hide();
        var canvasChange = $(me.chartID).find("canvas")[0];
        if(canvasChange){
            canvasChange.getContext("2d").clearRect(0,0,0,0);
        }
        $(this.chartID).find(".bda-chart-content").html("").css("padding","20px");
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var contentWidth = $(this.chartID).find(".bda-chart-content").width();
        var contentHeight = $(this.chartID).find(".bda-chart-content").height();
        var waterWaveSize = Math.min(contentWidth,contentHeight);
        $(this.chartID).find(".bda-chart-content").html('<canvas width="'+waterWaveSize+'" height="'+waterWaveSize+'">当前浏览器不支持canvas 请升级！</canvas>');
        $(this.chartID).find("canvas").css({
            "margin-left": (contentWidth-waterWaveSize)/2,
            "margin-top": (contentHeight-waterWaveSize)/2
        });
        drawWaterWave();

        if(viewBlock.reportLink || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0)){
            $(this.chartID).find('.bda-chart-content').hover(function(){
                $(this).css('cursor','pointer');
            });
        }

        function drawWaterWave(){
            var waveColor = viewBlock.ChartStyle.y1ScaleLineColor?$BDA.csharp2rgba(viewBlock.ChartStyle.y1ScaleLineColor):'#1c86d1';
            var canvas = $(me.chartID).find("canvas")[0];
            var ctx = canvas.getContext("2d");
            var waterValue = me.data.data;
            var oW = canvas.width;
            var oH = canvas.height;
            var lineWidth = 2; // 线宽
            var r = (oW / 2); // 大半径
            var cR = r;
            ctx.beginPath();
            //ctx.lineWidth = lineWidth;

            // 水波动画初始参数
            var axisLength = 2 * r; // Sin 图形长度
            var unit = axisLength / 5; // 波浪宽
            var range = .2; // 浪幅
            var nowrange = range;
            var xoffset = 0; // x 轴偏移量
            var data = waterValue; // 数据量
            var sp = 0; // 周期偏移量
            var nowdata = 0;
            var waveupsp = 0.005; // 水波上涨速度

            // 圆动画初始参数
            var arcStack = []; // 圆栈
            var bR = r - 8 * lineWidth;
            var soffset = -(Math.PI / 2); // 圆动画起始位置
            var circleLock = true; // 起始动画锁

            // 获取圆动画轨迹点集
            for (var i = soffset; i < soffset + 2 * Math.PI; i += 1 / (8 * Math.PI)) {
                arcStack.push([
                    r + bR * Math.cos(i),
                    r + bR * Math.sin(i)
                ]);
            }
            // 圆起始点
            var cStartPoint = arcStack.shift();
            ctx.strokeStyle = waveColor;
            ctx.moveTo(cStartPoint[0], cStartPoint[1]);
            // 开始渲染
            render();

            function drawSine() {
                ctx.beginPath();
                ctx.save();
                var Stack = []; // 记录起始点和终点坐标
                for (var i = xoffset; i <= xoffset + axisLength; i += 20 / axisLength) {
                    var x = sp + (xoffset + i) / unit;
                    var y = Math.sin(x) * nowrange;
                    var dx = i;
                    var dy = 2 * cR * (1 - nowdata) + (r - cR) - (unit * y);
                    ctx.lineTo(dx, dy);
                    Stack.push([dx, dy]);
                }
                // 获取初始点和结束点
                var startP = Stack[0];
                var endP = Stack[Stack.length - 1];
                ctx.lineTo(xoffset + axisLength, oW);
                ctx.lineTo(xoffset, oW);
                ctx.lineTo(startP[0], startP[1]);
                var gradient = ctx.createLinearGradient(0, 0, 0, oH);
                gradient.addColorStop(0, '#ffffff');
                gradient.addColorStop(1, waveColor);
                ctx.fillStyle = gradient;
                ctx.fill();
                ctx.restore();
            }

            function drawText() {
                var size = 0.4 * cR;
                var dataFontFamily = viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif';
                var dataFontSize = viewBlock.ChartStyle.dataFont?viewBlock.ChartStyle.dataFont.size:'24';
                var dataFontWeight = viewBlock.ChartStyle.dataFont?(viewBlock.ChartStyle.dataFont.bold?'bold':'100'):'bold';

                ctx.font = dataFontWeight+' ' + dataFontSize*$BDA.defaultRatio+"px " +dataFontFamily;
                var txt = (nowdata.toFixed(2) * 100).toFixed(0) + '%';
                var fonty = r + size / 2;
                var fontx = r - size * 0.8;
                ctx.fillStyle = viewBlock.ChartStyle.scaleColor?$BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor):'rgba(0,0,0,.85)';
                ctx.textAlign = 'center';
                ctx.fillText(txt, r + 5, r+(dataFontSize?dataFontSize:size)/2);

                var labelsFontFamily = viewBlock.ChartStyle.axisLabelFont?((viewBlock.ChartStyle.axisLabelFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.axisLabelFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif';
                var labelsFontSize = viewBlock.ChartStyle.axisLabelFont?viewBlock.ChartStyle.axisLabelFont.size:'14';
                var labelsFontWeight = viewBlock.ChartStyle.axisLabelFont?(viewBlock.ChartStyle.axisLabelFont.bold?'bold':'100'):'100';
                ctx.font = labelsFontWeight+ ' ' +labelsFontSize*$BDA.defaultRatio+"px " +labelsFontFamily;
                var measureName = me.data.measureName;
                ctx.fillStyle = viewBlock.ChartStyle.axisLabelColor?$BDA.csharp2rgba(viewBlock.ChartStyle.axisLabelColor):'rgba(0,0,0,.45)';
                ctx.textAlign = 'center';
                ctx.fillText(measureName, r+5, r-(labelsFontSize?labelsFontSize:size));
            }

            //灰色圆圈
            function grayCircle() {
                ctx.beginPath();
                ctx.lineWidth = 2;
                ctx.strokeStyle = waveColor;
                ctx.arc(r, r, cR-2, 0, 2 * Math.PI);
                ctx.stroke();
                ctx.restore();
                ctx.beginPath();
            }

            //裁剪中间水圈
            function clipCircle() {
                ctx.beginPath();
                ctx.arc(r, r, r -4, 0, 2 * Math.PI, 1);
                ctx.clip();
            }

            //渲染canvas
            function render() {
                ctx.clearRect(0, 0, oW, oH);
                grayCircle();
                clipCircle();
                data = waterValue;
                if (data >= 0.85) {
                    if (nowrange > range / 4) {
                        var t = range * 0.01;
                        nowrange -= t;
                    }
                } else if (data <= 0.1) {
                    if (nowrange < range * 1.5) {
                        var t = range * 0.01;
                        nowrange += t;
                    }
                } else {
                    if (nowrange <= range) {
                        var t = range * 0.01;
                        nowrange += t;
                    }
                    if (nowrange >= range) {
                        var t = range * 0.01;
                        nowrange -= t;
                    }
                }
                if ((data - nowdata) > 0) {
                    nowdata += waveupsp;
                }
                if ((data - nowdata) < 0) {
                    nowdata -= waveupsp
                }
                sp += 0.07;
                drawSine();
                drawText();
                requestID = requestAnimationFrame(render)
            }
        }
    }

    this.refreshByLinkage=function(fltHeight){
        this.data = waterWaveData();
        me.draw(fltHeight);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = waterWaveData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----合计表*/
function TotalTable(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;
    
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = totalTableData();

    function totalTableData(){
        if(viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var totalTableData = {};

        totalTableData.tableHeadStyle = [];
        totalTableData.tableHead = [];
        for(var i = 0; i < viewBlock.viewTableHead.viewTableRows.length; i++){
            var tableRow = [];
            for(var j = 0; j < viewBlock.viewTableHead.viewTableRows[i].viewTableCells.length; j++){
                var tableCell = viewBlock.viewTableHead.viewTableRows[i].viewTableCells[j];
                var tempObj = {};
                if(tableCell.colspan && tableCell.rowspan){
                    if(tableCell.colspan==1){
                        tempObj.field = j+'';
                    }
                    if(!tableCell.formatString){
                        if(tableCell.cellObject[3] != 1){
                            tempObj.title = tableCell.text===null?"":tableCell.text;
                        }else{
                            tempObj.title = (!isNaN(tableCell.text))?$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text))):tableCell.text;
                        }
                    }else {
                        if(tableCell.cellObject[3] <= 0){
                            tempObj.title = tableCell.text===null?"":tableCell.text;
                        }else if(tableCell.cellObject[3] == 1){
                            tempObj.title = (!isNaN(tableCell.text))?$BDA.formatString.date(tableCell.formatString,new Date(Number(tableCell.text))):tableCell.text;
                        }else{
                            tempObj.title = $BDA.formatString.number(tableCell.formatString,(!isNaN(tableCell.text))?(Number(tableCell.text) || ''):(tableCell.text || ''));
                        }
                    }
                    tempObj.colspan = tableCell.colspan;
                    tempObj.rowspan = tableCell.rowspan;
                    totalTableData.tableHeadStyle.push({
                        "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                        "backgroundColor": $BDA.csharp2rgba(tableCell.cellTextBox.backgroundColor),
                        "verticalAlign": tableCell.cellTextBox.verticalAlign=='0'?'top':(tableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                        "textAlign": tableCell.cellTextBox.textAlign=='0'?'left':(tableCell.cellTextBox.textAlign=='1'?'center':'right'),
                        "font-family": tableCell.cellTextBox.font.fontFamily,
                        'font-size': tableCell.cellTextBox.font.size/100+"rem",
                        'font-style': tableCell.cellTextBox.font.italic?'italic':'normal',
                        'font-weight': tableCell.cellTextBox.font.bold?'bold':'normal',
                        'text-decoration': tableCell.cellTextBox.font.underline?'underline':
                            (tableCell.cellTextBox.font.strikeout?'line-through':'none')
                    });
                    tableRow.push(tempObj);
                }
            }

            totalTableData.tableHead.push(tableRow);
        }

        var nodeRoot = new Node();
        nodeRoot.name = 'root';
        nodeRoot.depth = 0;
        var tempFoldingDimensionObjectArr = [];
        for (var i = 0; i < viewBlock.dimensions.count; i++){
            tempFoldingDimensionObjectArr.push(viewBlock.dimensions.item(i).dimensionObject);
        }
        var tempMeasures = [];
        for(var i = 0; i < viewBlock.foldingMeasures.count; i++){
            tempMeasures.push(viewBlock.foldingMeasures.item(i).measureObject);
        }
        var dimensionAndMeasures = tempFoldingDimensionObjectArr.concat(tempMeasures);
        for(var i = 0; i < dimensionAndMeasures.length; i++){
            if (i < viewBlock.dimensions.count){
                nodeRoot.values.push("");
            }else{
                nodeRoot.values.push(0);
            }
        }

        var rowNodes = [];
        for(var row = 0; row < viewBlock.blockDataToDraw.length; row++){
            rowNodes = [];
            rowNodes.push(nodeRoot);
            for(var col = 0; col < dimensionAndMeasures.length; col++){
                var viewTableCell = dimensionAndMeasures[col];
                if (col < viewBlock.dimensions.count){
                    rowNodes.push(rowNodes[rowNodes.length-1].getOrCreateChildNode(viewBlock.blockDataToDraw[row][viewTableCell[0]+"___"+viewTableCell[1]]));
                }else{
                    for(var i = 0; i < rowNodes.length; i++){
                        rowNodes[i].values[col] += (viewBlock.blockDataToDraw[row][viewTableCell[0]+"___"+viewTableCell[1]] || 0);
                    }
                }
            }
        }

        var measuresData = JSON.parse(print(nodeRoot));

        removeNoHaveAggregate(measuresData);
        addAggregateRow(measuresData);
        deleteOriginalTotal(measuresData);
        setAggregate(measuresData);
        setAggregateSort(measuresData);

        var aggregateArr = getAggregate(measuresData);
        totalTableData.aggregateArr = aggregateArr;


        for(var i = 0; i < measuresData.length; i++){
            if (measuresData[i].aggregateRow){
                for(var j = 0; j < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; j++){
                    var tableCell = viewBlock.viewTableBody.viewTableRows[0].viewTableCells[j];
                    var cellKey = tableCell.cellObject[0]+'___'+tableCell.cellObject[1];
                    if(tableCell.cellObject[4] && tableCell.cellObject[5] && tableCell.cellObject[4] == "true"){
                        var expression = getExpression(tableCell.cellObject[5]);
                        var valueIsExist = true;
                        for(var k = 0; k < expression.length; k++){
                            if(expression[k].indexOf("___") != -1){
                                valueIsExist = true;
                                if(measuresData[i][expression[k]] || measuresData[i][expression[k]]==0){
                                    expression[k] = "("+measuresData[i][expression[k]]+")";
                                    continue;
                                }else{
                                    valueIsExist = false;
                                    continue;
                                }
                            }
                        }
                        if(valueIsExist){
                            measuresData[i][cellKey] = eval(expression.join(""));
                        }
                    }
                }
            }
        }

        function getExpression(str){
            var reg = new RegExp("\\][.]\\[", "g");
            var newStr = str.replace(reg, "___");
            var tempArr = [];
            var isStar = false;
            var tempStr = "";
            for(var i = 0; i < newStr.length;i++){
                if(newStr[i] == "["){
                    isStar = true;
                    tempStr = "";
                    continue;
                }
                if(newStr[i] == "]"){
                    isStar = false;
                    tempArr.push(tempStr);
                    continue;
                }
                if(isStar){
                    tempStr += newStr[i];
                    continue;
                }
                if(!isStar){
                    tempArr.push(newStr[i]);
                    continue;
                }
            }
            return tempArr;
        }

        totalTableData.measures = [];

        for(var i = 0; i < measuresData.length; i++){
            var tempObj = {};
            for(var j = 0; j < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; j++){
                var tableCell = viewBlock.viewTableBody.viewTableRows[0].viewTableCells[j];
                for(var key in measuresData[i]){
                    if(key == (tableCell.cellObject[0]+'___'+tableCell.cellObject[1])){
                        if(measuresData[i][key] == "小计" || measuresData[i][key] == "总计"){
                            tempObj[j+''] = measuresData[i][key];
                        }else{
                            if(tableCell.cellObject[3] == 1){
                                tempObj[j+''] = $BDA.formatString.date(tableCell.formatString,new Date(measuresData[i][key]));
                            }else if(tableCell.cellObject[3] == 2){
                                tempObj[j+''] = $BDA.formatString.number(tableCell.formatString,measuresData[i][key]);
                            }else{
                                tempObj[j+''] = measuresData[i][key];
                            }
                        }
                    }
                }
            }
            totalTableData.measures.push(tempObj);
        }

        return totalTableData;

        function print(root){
            var jsonArray = [];
            for(var child in root.children){
                print1(root.children[child],jsonArray);
            }
            jsonArray.push(root.toJsonObject());
            return JSON.stringify(jsonArray);
        }

        function print1(node,jArray){
            for(var child in node.children){
                print1(node.children[child],jArray);
            }
            //if(node.children.length != 1){
                jArray.push(node.toJsonObject());
            //}
        }

        function Node(){
            this.name = "";
            this.depth = 0;
            this.values = [];
            this.children = [];

            this.toJsonObject = function(){
                var tempObj = {};
                var isTrue = false;
                for(var i = 0; i < dimensionAndMeasures.length; i++){
                    if (i < viewBlock.dimensions.count){
                        if(isTrue){
                            tempObj[dimensionAndMeasures[i][0]+'___'+dimensionAndMeasures[i][1]] = tempObj[dimensionAndMeasures[i-1][0]+'___'+dimensionAndMeasures[i - 1][1]];
                        }else{
                            if(this.depth == 0 && i == 0){
                                tempObj[dimensionAndMeasures[i][0]+'___'+dimensionAndMeasures[i][1]] = '总___计';
                                tempObj["initialRow"] = true;
                                isTrue = true;
                            }else if(i == this.depth){
                                tempObj[dimensionAndMeasures[i][0] + '___' + dimensionAndMeasures[i][1]] = '小___计';
                                tempObj["initialRow"] = true;
                                isTrue = true
                            }else{
                                tempObj[dimensionAndMeasures[i][0]+'___'+dimensionAndMeasures[i][1]] = this.values[i];
                            }
                        }

                    }else{
                        tempObj[dimensionAndMeasures[i][0]+'___'+dimensionAndMeasures[i][1]] = this.values[i];
                    }
                }

                return tempObj;
            }

            this.getOrCreateChildNode = function(nodeName){
                for(var i = 0; i < this.children.length; i++){
                    if(this.children[i].name == nodeName){
                        return this.children[i];
                    }
                }
                var newChild = new Node();
                newChild.name = nodeName;
                newChild.depth = this.depth + 1;

                for(var i = 0; i < this.values.length; i++){
                    if (i < viewBlock.dimensions.count){
                        newChild.values.push(this.values[i]);
                    }else{
                        newChild.values.push(0);
                    }
                }
                newChild.values[newChild.depth - 1] = nodeName;
                this.children.push(newChild);
                return newChild;
            }
        }
    }

    function removeNoHaveAggregate(measuresData){
        var tempDimensionArr = [];
        for (var i = 0; i < viewBlock.dimensions.count; i++) {
            var foldingDimension = viewBlock.dimensions.item(i);
            var dimensionName = foldingDimension.dimensionObject[0] + "___" + foldingDimension.dimensionObject[1];
            tempDimensionArr.push(dimensionName);
            if (!foldingDimension.aggregate) {
                deleteAggregateRow(dimensionName, tempDimensionArr, measuresData);
            }
        }
    }

    function deleteAggregateRow(dimensionName,dimensionArr,measuresData){
        for (var i = measuresData.length - 1; i >= 0; i--){
            for(var item in measuresData[i]){
                if(item == dimensionName){
                    var index = judgeEqual(dimensionName,dimensionArr);
                    if(index == 0){
                        if(measuresData[i][item] == "总计"){
                            measuresData.splice(i,1);
                        }
                    }else if(index > 0){
                        var lastName = dimensionArr[index-1];
                        if (measuresData[i][item] == "小计" && measuresData[i][lastName] != "小计") {
                            measuresData.splice(i, 1);
                        }
                    }
                }
            }
        }
    }

    function judgeEqual(key,dimensionArr){
        for(var i = 0; i < dimensionArr.length; i++){
            if(key == dimensionArr[i]){
                return i;
            }
        }
        return -1;
    }

    function addAggregateRow(measuresData) {
        var tempDimensionArr = [];
        for (var i = 0; i < viewBlock.dimensions.count; i++) {
            var foldingDimension = viewBlock.dimensions.item(i);
            var dimensionName = foldingDimension.dimensionObject[0] + "___" + foldingDimension.dimensionObject[1];
            tempDimensionArr.push(dimensionName);
            if(foldingDimension.aggregate){
                for (var j = 0; j < viewBlock.aggregateLines.count; j++) {
                    var aggregateLine = viewBlock.aggregateLines.item(j);
                    var prevName = tempDimensionArr.length > 1 ? tempDimensionArr[tempDimensionArr.length - 2] : "";
                    newRowToData(i, j, dimensionName, measuresData, prevName, aggregateLine);
                }
            }
        }
    }

    function newRowToData(index, rowIndex, dimensionName, measuresData, prevName, aggregateLine){
        for(var i = 0; i < measuresData.length; i++){
            if (index == 0) {
                if (measuresData[i].isSkip) { continue; }
                if (measuresData[i]["initialRow"] && measuresData[i][dimensionName] == "总___计"){
                    var addObject = $.extend(true, {}, measuresData[i]);
                    addObject.isSkip = true;
                    addObject.aggregateRow = true;
                    addObject.dimensionIndex = index;
                    addObject.initialRow = false;
                    addObject.aggregateIndex = rowIndex;
                    for(var key in addObject){
                        if (addObject[key] == "小___计" || addObject[key] == "总___计") {
                            addObject[key] = aggregateLine.totalLabel;
                        }
                    }
                    measuresData.splice(i + rowIndex + 1, 0, addObject);
                }
            }else{
                if (prevName) {
                    if (measuresData[i][prevName] == "小___计") { continue; }
                }
                if (measuresData[i][dimensionName] == "小___计" && measuresData[i]["initialRow"] && !measuresData[i].isSkip) {
                    var addObject = $.extend(true, {}, measuresData[i]);
                    addObject.isSkip = true;
                    addObject.aggregateRow = true;
                    addObject.initialRow = false;
                    addObject.dimensionIndex = index;
                    addObject.aggregateIndex = rowIndex;
                    for (var key in addObject) {
                        if (addObject[key] == "小___计" || addObject[key] == "总___计") {
                            addObject[key] = aggregateLine.subtotalLabel;
                        }
                    }
                    measuresData.splice(i + rowIndex + 1, 0, addObject);
                }
            }
        }
    }

    function deleteOriginalTotal(measuresData) {
        for (var i = measuresData.length - 1; i >= 0; i--) {
            if (measuresData[i].initialRow) {
                measuresData.splice(i, 1);
            }
        }
    }

    function setAggregate(measuresData) {
        var measuresNameArr = [];
        for (var i = 0; i < viewBlock.foldingMeasures.count; i++) {
            measuresNameArr.push((viewBlock.foldingMeasures.item(i).measureObject[0] + "___" + viewBlock.foldingMeasures.item(i).measureObject[1]));
        }
        for (var i = 0; i < viewBlock.dimensions.count; i++) {
            var foldingDimension = viewBlock.dimensions.item(i);
            if (foldingDimension.aggregate){
                var measureValueObj = resetObj(measuresNameArr);
                var count = 0;
                for(var j = 0; j < measuresData.length; j++){
                    if (measuresData[j].dimensionIndex == i && measuresData[j].aggregateRow){
                        for (var k = 0; k < viewBlock.aggregateLines.count; k++) {
                            if (measuresData[j].aggregateIndex == k) {
                                for(var m = 0; m < viewBlock.foldingMeasures.count; m++){
                                    var foldingMeasure = viewBlock.foldingMeasures.item(m);
                                    var measureName = foldingMeasure.measureObject[0] + "___" + foldingMeasure.measureObject[1];
                                    if (foldingMeasure.aggregateFunctions[k] == null){
                                        measuresData[j][measureName] = "";
                                    }
                                    if (foldingMeasure.aggregateFunctions[k] == "avg") {
                                        measuresData[j][measureName] = measuresData[j][measureName] / measureValueObj[measureName].count;
                                    }
                                    if (foldingMeasure.aggregateFunctions[k] == "max") {
                                        measuresData[j][measureName] = measureValueObj[measureName].max;
                                    }
                                    if (foldingMeasure.aggregateFunctions[k] == "min") {
                                        measuresData[j][measureName] = measureValueObj[measureName].min;
                                    }
                                    if (foldingMeasure.aggregateFunctions[k] == "count") {
                                        measuresData[j][measureName] = measureValueObj[measureName].count;
                                    }
                                }
                            }
                        }
                        if (measuresData[j].aggregateIndex == viewBlock.aggregateLines.count - 1) {
                            measureValueObj = resetObj(measuresNameArr);
                            count = 0;
                        }
                    } else {
                        count++;
                        for (var k = 0; k < measuresNameArr.length; k++) {
                            if (measureValueObj.isFirst) {
                                measureValueObj[measuresNameArr[k]].max = measuresData[j][measuresNameArr[k]];
                                measureValueObj[measuresNameArr[k]].min = measuresData[j][measuresNameArr[k]];
                            }else{
                                if (measureValueObj[measuresNameArr[k]].max < measuresData[j][measuresNameArr[k]]) {

                                    measureValueObj[measuresNameArr[k]].max = measuresData[j][measuresNameArr[k]];
                                }
                                if (measureValueObj[measuresNameArr[k]].min > measuresData[j][measuresNameArr[k]]) {
                                    measureValueObj[measuresNameArr[k]].min = measuresData[j][measuresNameArr[k]];
                                }
                            }
                            measureValueObj[measuresNameArr[k]].sum += measuresData[j][measuresNameArr[k]];
                            measureValueObj[measuresNameArr[k]].count = count;
                        }
                        if(measureValueObj.isFirst){
                            measureValueObj.isFirst = false;
                        }
                    }

                }
            }
        }
    }

    function resetObj(measuresNameArr){
        var tempObj = {};
        for (var i = 0; i < measuresNameArr.length; i++){
            tempObj[measuresNameArr[i]] = {};
            tempObj[measuresNameArr[i]].sum = 0;
            tempObj[measuresNameArr[i]].max = 0;
            tempObj[measuresNameArr[i]].min = 0;
            tempObj[measuresNameArr[i]].count = 0;
        }
        tempObj.isFirst = true;
        return tempObj;
    }

    function getAggregate(measuresData){
        var tempArr = [];
        for (var i = 0; i < measuresData.length; i++){
            if (measuresData[i].aggregateRow){
                var tempObj = {};
                tempObj.rowIndex = i;
                tempObj.totalLabel = viewBlock.aggregateLines.item(measuresData[i].aggregateIndex).totalLabel;
                tempObj.subtotalLabel = viewBlock.aggregateLines.item(measuresData[i].aggregateIndex).subtotalLabel;
                tempArr.push(tempObj);
            }
        }
        return tempArr;
    }

    function setAggregateSort(measuresData) {
        for (var i = 0; i < viewBlock.dimensions.count; i++) {
            var foldingDimension = viewBlock.dimensions.item(i);
            if (foldingDimension.aggregatePosition) {
                var sortRangArr = getSortObj(i, measuresData);
                sortMeasuresData(i, sortRangArr, measuresData);
            }
        }
    }

    function getSortObj(index, measuresData) {
        var tempArr = [];
        var tempObj = initObj();
        for (var i = 0; i < measuresData.length; i++) {
            if (measuresData[i].dimensionIndex == index) {
                if (!tempObj.isStart) {
                    tempObj.isStart = true;
                    tempObj.start = i;
                    tempObj.rang += 1;
                } else if (tempObj.isStart) {
                    tempObj.rang += 1;
                }
            } else {
                if (tempObj.isInsert && !measuresData[i]["aggregateRow"] && measuresData[i]["aggregateRow"] != false) {
                    tempObj.insertIndex = i;
                    tempObj.isInsert = false;
                }
                if (tempObj.isStart) {
                    tempArr.push(tempObj);
                    tempObj = initObj();
                    if (!measuresData[i]["aggregateRow"] && measuresData[i]["aggregateRow"] != false) {
                        tempObj.insertIndex = i;
                        tempObj.isInsert = false;
                    }
                }
            }
            if (i == (measuresData.length - 1) && tempObj.isStart) {
                tempArr.push(tempObj);
            }
        }
        return tempArr;
    }

    function initObj() {
        var tempObj = {
            start: 0,
            rang: 0,
            insertIndex: 0,
            isInsert: true,
            isStart: false
        };
        return tempObj;
    }

    function sortMeasuresData(index, sortRangArr, measuresData) {
        for (var i = 0; i < sortRangArr.length; i++) {
            var tempArr = [];
            for (var j = sortRangArr[i].start; j < (sortRangArr[i].start + sortRangArr[i].rang); j++) {
                tempArr.push(measuresData[j]);
            }
            measuresData.splice(sortRangArr[i].start, sortRangArr[i].rang);
            for (var j = 0; j < tempArr.length; j++) {
                measuresData.splice((sortRangArr[i].insertIndex + j), 0, tempArr[j]);
            }
        }
    }

    this.draw = function(fltHeight){
        $(this.chartID).find('.bda-data').css('display','none');
        
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        var tempStr = "10,10,10,10";
        var paddingArr = viewBlock.padding?viewBlock.padding.split(","):tempStr.split(",");
        $(this.chartID).find('.bda-chart-content').css({
            "padding-top": Number($.trim(paddingArr[0]))/100 + "rem",
            "padding-right": Number($.trim(paddingArr[1]))/100 + "rem",
            "padding-bottom": Number($.trim(paddingArr[2]))/100 + "rem",
            "padding-left": Number($.trim(paddingArr[3]))/100 + "rem"
        });
        this.setChartContentHeight(fltHeight);

        if(viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var userAgent = window.navigator.userAgent;
        var isWebkit = false;
        if(userAgent.indexOf('Chrome') != -1){
            isWebkit = true;
        }

        var tableHeight = $(this.chartID).find('.bda-chart-content').height();
        var tableWidth = $(this.chartID).find('.bda-chart-content').width();
        var table = document.createElement('table');

        var pageSizeNum = setPageSIze() || 10;
        this.pageSizeNum = pageSizeNum;
        
        maxWidth();
        setTableWidth(tableWidth);
        $(this.chartID).find('.bda-chart-content').html('');

        deleteTableCellWidth0();

        $(table).css({
            width: tableWidth,
            height: tableHeight
        });

        $(this.chartID).find(".bda-chart-content").append(table);

        if (viewBlock.pagingDisplay) {
            $(table).datagrid({ loadFilter: pagerFilter }).datagrid({
                pagination: true,	//表示在datagrid设置分页
                pageSize: pageSizeNum,
                pageNumber: 1,	//第几页显示（默认第一页，可以省略）
                pageList: [pageSizeNum, 20, 30, 40, 50],
                url: null,
                remoteSort: false,
                columns: this.data.tableHead,
                scrollbarSize: 20,
                striped: true,
                singleSelect: true,
                data: this.data.measures,
                onLoadSuccess: function () {
                    var self = this;
                    setBodyStyle();
                    getMergeRow(self);
                    mergeRowSubtotal(self);
                    setTotalRows();
                }
            });
            $($(table).datagrid("getPager")).pagination({
                showRefresh: false,
            })
        } else {
            var datagridObj = {
                pageSize: 50,
                url: null,
                columns: me.data.tableHead,
                scrollbarSize: 17,
                striped: true,
                singleSelect: true,
                rowStyler: function () {
                    return "height:" + viewBlock.bodyHeight / 100 + "rem";
                },
                onLoadSuccess: function () {
                    var self = this;
                    setBodyStyle();
                    getMergeRow(self);
                    mergeRowSubtotal(self);
                    setTotalRows();
                }
            };
            if (this.data.measures.length > 100) {
                datagridObj.view = scrollview;
            }

            $(table).datagrid(datagridObj).datagrid('loadData', this.data.measures);
        }

        $(this.chartID).find('.datagrid-header-row td').each(function(i){
            $(this).css(me.data.tableHeadStyle[i]);
        }).children().each(function(i){
            $(this).css(me.data.tableHeadStyle[i]);
        });

        if ($BDA.theme.themeID){
            $(this.chartID).find('.datagrid-header-row td').each(function(){
                $(this).css({
                    "background-color":$BDA.theme.currentBackgroundColor,
                    "color":"#fff"
                });
            }).children().each(function(){
                $(this).css({
                    "background-color":$BDA.theme.currentBackgroundColor,
                    "color":"#fff"
                });
            });
        }
        
        function setPageSIze() {
            var pageSize = 50;
            if (viewBlock.pageRecordCount != -1) {
                pageSize = viewBlock.pageRecordCount;
            } else {
                var bodyHeight = tableHeight - me.data.tableHead.length * viewBlock.headHeight;
                bodyHeight = viewBlock.pagingDisplay ? (bodyHeight - 35) : bodyHeight;
                pageSize = viewBlock.bodyHeight ? parseInt(bodyHeight / viewBlock.bodyHeight) : 50;
            }
            return pageSize;
        }

        function pagerFilter(data) {
            if (typeof data.length == 'number' && typeof data.splice == 'function') {	// is array
                data = {
                    total: data.length,
                    rows: data
                }
            }
            var dg = $(this);
            var opts = dg.datagrid('options');
            var pager = dg.datagrid('getPager');
            me.currentPage = opts.pageNumber;
            me.pageSizeNum = opts.pageSize;
            pager.pagination({
                onSelectPage: function (pageNum, pageSize) {
                    opts.pageNumber = pageNum;
                    opts.pageSize = pageSize;
                    pager.pagination('refresh', {
                        pageNumber: pageNum,
                        pageSize: pageSize
                    });
                    dg.datagrid('loadData', data);
                }
            });
            if (!data.originalRows) {
                data.originalRows = (data.rows);
            }
            var start = (opts.pageNumber - 1) * parseInt(opts.pageSize);
            var end = start + parseInt(opts.pageSize);
            data.rows = (data.originalRows.slice(start, end));
            return data;
        }

        function getLength(str, isHead, i, j) {
            if (isHead) {
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableHead.viewTableRows[j].viewTableCells[i].cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableHead.viewTableRows[j].viewTableCells[i].cellTextBox.font.size/100+"rem"
                });
                return parseFloat($('.test-length span').html(str).width() + 12);   //8,表头单元格内边距，13，表头排序三角符宽度
            } else {
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i].cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i].cellTextBox.font.size/100+"rem"
                });
                return parseFloat($('.test-length span').html(str).width() + 12);
            }
        }

        function sumWidth(arry){
            var sumArry = 0;
            for(var i= 0;i<arry.length;i++){
                sumArry += arry[i];
            }
            return sumArry;
        }

        function maxWidth(){
            var tableHeadStrLength = computeTableHeadTableCellWidth();
            var tableBodyStrLength = computeTableBodyTableCellWidth();
            var tableCellMaxWidthArray = [];
            var maxValue = 0;

            for(var i= 0;i<tableBodyStrLength.length;i++){
                maxValue = Math.max(tableHeadStrLength[i],tableBodyStrLength[i]);
                tableCellMaxWidthArray.push(maxValue);
            }

            me.data.maxTopWidth = tableCellMaxWidthArray;
        }

        function computeTableHeadTableCellWidth(){
            var tableHead = viewBlock.viewTableHead;
            var tableHeadStrLength = [];
            var array = [];
            var tableCell = null;
            for(var i = 0; i < tableHead.viewTableRows[0].viewTableCells.length; i++){
                array = [];
                tableCell = tableHead.viewTableRows[0].viewTableCells[i];
                // if(tableCell.colspan > 1){
                //     array.push(0);
                // }else{
                    if(tableCell.autoColumnWidth){
                        for(var j= 0,jen=tableHead.viewTableRows.length;j<jen;j++){
                            if(tableHead.viewTableRows[j].viewTableCells[i].colspan > 1){
                                array.push(0);
                            }else{
                                var strLength = tableHead.viewTableRows[j].viewTableCells[i].text;
                                array.push(getLength(strLength,true,i,j)+1);
                            }
                        }
                    }else{
                        array.push(tableCell.columnWidth * $BDA.tableColumnsWidthRatio);
                    }
                // }

                tableHeadStrLength.push(Math.max.apply(Math,array));
            }
            return tableHeadStrLength;
        }

        function computeTableBodyTableCellWidth(){
            var tableBodyStrLength = [];
            var tableBody = viewBlock.viewTableBody;
            var array = [];
            var tableCell = null;
            for(var i = 0; i < tableBody.viewTableRows[0].viewTableCells.length; i++){
                array = [];
                tableCell = tableBody.viewTableRows[0].viewTableCells[i];
                if(tableCell.autoColumnWidth){
                    for(var j= 0,jen= me.data.measures.length;j<jen;j++){
                        var strLength = me.data.measures[j][i];
                        array.push(getLength(strLength,false,i));
                    }
                }else{
                    array.push(tableCell.columnWidth * $BDA.tableColumnsWidthRatio);
                }
                tableBodyStrLength.push(Math.max.apply(Math,array));
            }

            return tableBodyStrLength;
        }

        function deleteTableCellWidth0(){
            for(var i = 0; i < me.data.tableHead.length; i++){
                for(var j = me.data.tableHead[i].length - 1; j >= 0; j--){
                    if(me.data.tableHead[i][j].width == 0){
                        me.data.tableHead[i].splice(j,1);
                    }
                }
            }
        }

        function setTableWidth(tableWidth){
            var headHeight = (viewBlock.headHeight?viewBlock.headHeight:30)*$BDA.defaultRatio;
            var bodyHeight = (viewBlock.bodyHeight?viewBlock.bodyHeight:30)*$BDA.defaultRatio;
            var currentTableHeight = me.data.tableHead.length * headHeight + me.data.measures.length * bodyHeight;
            var maxSumValue = sumWidth(me.data.maxTopWidth);
            var indexType = viewBlock.tableStyle?viewBlock.tableStyle:0;
            var borderAddedValue = 0;
            var scrollWidth = isWebkit?10:17;

            //switch (indexType){
            //    case 0:
            //        break;
            //    case 1:
            //        maxSumValue = maxSumValue - viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length + 2;
            //        borderAddedValue = viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length - 2;
            //        break;
            //    case 2:
            //    case 3:
            //        maxSumValue = maxSumValue - viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length;
            //        borderAddedValue = viewBlock.viewTableBody.viewTableRows.item[0].viewTableCells.length
            //        break;
            //}

            switch (indexType){
                case 0:
                    tableWidth = tableWidth - (viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length)*$BDA.defaultRatio;
                    break;
                case 1:
                    tableWidth = tableWidth - 1*$BDA.defaultRatio;
                    break;
                case 2:
                case 3:
                    break;
            }

            if(currentTableHeight<=tableHeight){
                if (tableWidth >= maxSumValue) {
                    setNotExceedingWidth(tableWidth,maxSumValue,0,borderAddedValue);
                } else {
                    setExceedWidth();
                }
                me.data.isNotHiddenScroll = true;
            }else {
                if ((tableWidth - maxSumValue) >= scrollWidth) {
                    setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue);
                } else {
                    setExceedWidth();
                }
            }
        }

        function setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue){
            var averageWidth = parseInt((tableWidth - maxSumValue - scrollWidth) / me.data.maxTopWidth.length);

            for (var i = 0; i < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; i++) {
                if(viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i].autoColumnWidth){
                    me.data.maxTopWidth[i] += averageWidth;
                }
            }

            //var lastTd = tableWidth - sumWidth(me.data.maxTopWidth) - (borderAddedValue?0:1) - scrollWidth + borderAddedValue;
            var lastTd = tableWidth - sumWidth(me.data.maxTopWidth) - scrollWidth;

            for(var i = viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length - 1; i >= 0; i--){
                if(viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i].autoColumnWidth){
                    me.data.maxTopWidth[i] += lastTd;
                    break;
                }
            }

            setExceedWidth();
        }

        function setExceedWidth(){
            for (var i = 0, len = me.data.tableHead.length; i < len; i++) {
                for (var j = 0, jen = me.data.tableHead[i].length; j < jen; j++) {
                    if (me.data.tableHead[i][j].field) {
                        var field = me.data.tableHead[i][j].field;
                        for (var k = 0, ken = me.data.maxTopWidth.length; k < ken; k++) {
                            if (field == k) {
                                me.data.tableHead[i][j].width = me.data.maxTopWidth[k];
                            }
                        }
                    }
                }
            }
        }

        function setBodyStyle(){
            if(viewBlock.tableStyleColor && !$BDA.theme.themeID){
                $(me.chartID).find(".datagrid-view2 td").css({
                    "border-color": "rgba("+int2hex(viewBlock.tableStyleColor,2)+",.3)"
                });
            }

            /*表头行高*/
            $(me.chartID).find('tr.datagrid-header-row').css({
                "height": (viewBlock.headHeight || viewBlock.headHeight == 0)?viewBlock.headHeight*$BDA.defaultRatio:30*$BDA.defaultRatio
            });
            $(me.chartID).find(".datagrid-header").css({
                "height": ((viewBlock.headHeight || viewBlock.headHeight == 0)?viewBlock.headHeight*$BDA.defaultRatio:30*$BDA.defaultRatio)*viewBlock.viewTableHead.viewTableRows.length
            });
            $(me.chartID).find("table.datagrid-htable").css({
                "height": ((viewBlock.headHeight || viewBlock.headHeight == 0)?viewBlock.headHeight*$BDA.defaultRatio:30*$BDA.defaultRatio)*viewBlock.viewTableHead.viewTableRows.length
            });
            var bodyHeight = $(me.chartID).find(".datagrid-view").height();
            $(me.chartID).find(".datagrid-body").css({
                "height": (bodyHeight - (((viewBlock.headHeight || viewBlock.headHeight == 0)?viewBlock.headHeight*$BDA.defaultRatio:30*$BDA.defaultRatio)*viewBlock.viewTableHead.viewTableRows.length))
            });

            var tableCells = viewBlock.viewTableBody.viewTableRows[0].viewTableCells;
            $(me.chartID).find(".datagrid-view2 .datagrid-body tr").each(function(){
                $(this).find("td").each(function(i){
                    if($(this).attr("field") == i){
                        $(this).css({
                            "color": $BDA.csharp2rgba(tableCells[i].cellTextBox.color),
                            "backgroundColor": $BDA.csharp2rgba(tableCells[i].cellTextBox.backgroundColor),
                            "textAlign": tableCells[i].cellTextBox.textAlign=='0'?'left':(tableCells[i].cellTextBox.textAlign=='1'?'center':'right'),
                            "verticalAlign": tableCells[i].cellTextBox.verticalAlign=='0'?'top':(tableCells[i].cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                            "font-family": tableCells[i].cellTextBox.font.fontFamily,
                            'font-style': tableCells[i].cellTextBox.font.italic?'italic':'normal',
                            'font-weight': tableCells[i].cellTextBox.font.bold?'bold':'normal'
                        }).find("div").css({
                            'font-size': tableCells[i].cellTextBox.font.size/100+"rem",
                            'text-decoration': tableCells[i].cellTextBox.font.underline?'underline':
                                (tableCells[i].cellTextBox.font.strikeout?'line-through':'none')
                        });
                    }
                });
            });

        }

        function getMergeRow(self){
            var bodyMerge = [];
            for (var i = 0, len = viewBlock.dimensions.count;i<len-1;i++){
                var arr=[];
                var rowspan =0;
                if(viewBlock.blockDataToDraw){
                    var currentPageTrLength = $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').length;
                    for(var j=0,k=j+1,jen=currentPageTrLength;k<jen;) {
                        for(var ken=currentPageTrLength;k<ken;){
                            if ($(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(j).find('td').eq(i).find('div').html()!=$(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(k).find('td').eq(i).find('div').html()){
                                if (k-j>1){
                                    rowspan = k-j;
                                    arr.push({index:$(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(j).attr('datagrid-row-index'),rowspan:rowspan,field:i+''});
                                    rowspan = 0;
                                }
                                j=k;
                                break;
                            }else{
                                k++;
                                if (k==jen&&k-j>1){
                                    arr.push({index:$(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').eq(j).attr('datagrid-row-index'),rowspan:k-j,field:i+''});
                                }
                            }
                        }
                    }
                    bodyMerge.push(arr);
                }
            }
            mergeRow(self,bodyMerge);
        }

        function mergeRow(self,arry){
            for(var i=0,len=arry.length;i<len;i++){
                for(var j= 0,jen=arry[i].length;j<jen;j++){
                    $(self).datagrid('mergeCells',{
                        index: arry[i][j].index,
                        field: arry[i][j].field,
                        rowspan: arry[i][j].rowspan
                    });
                }
            }
        }

        function mergeRowSubtotal(self){
            var mergeTdArry = [];
            var mergeTr = $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr');
            mergeTr.each(function(){
                var rowIndex = Number($(this).attr("datagrid-row-index"));
                for(var i = 0; i < me.data.aggregateArr.length; i++){
                    if (me.data.aggregateArr[i].rowIndex == rowIndex){
                        var startField = 0, colspan = 1, isStart = true;
                        $(this).find("td").each(function(){
                            var currText = $(this).find('div').html();
                            if (currText == me.data.aggregateArr[i].subtotalLabel || currText == me.data.aggregateArr[i].totalLabel){
                                if(isStart){
                                    startField = $(this).attr("field");
                                    isStart = false;
                                }else{
                                    colspan++;
                                }
                            }
                        });
                        mergeTdArry.push({index: rowIndex, colspan: colspan, field: startField});
                    }
                }
            });

            for(var i = 0; i < mergeTdArry.length; i++){
                $(self).datagrid('mergeCells', {
                    index: mergeTdArry[i].index,
                    field: mergeTdArry[i].field,
                    colspan: mergeTdArry[i].colspan
                });
            }
        }

        function setTotalRows(){
            $(me.chartID).find('.datagrid-view2 .datagrid-body .datagrid-btable tr').each(function () {
                var rowIndex = Number($(this).attr("datagrid-row-index"));
                for (var i = 0; i < me.data.aggregateArr.length; i++) {
                    if (me.data.aggregateArr[i].rowIndex == rowIndex) {
                        $(this).css({
                            'background-color': 'rgba(' + int2hex(viewBlock.tableStyleColor) + ', .2)'
                        });
                    }
                }
            });
        }

        function int2hex(rgbInt,isTrue) {
            var red = (rgbInt >> 16) & 255;
            var green = (rgbInt >> 8) & 255;
            var blue = rgbInt & 255;
            if(isTrue){
                isTrue == 1 ? ((red - 48 >= 0)?(red = red - 48):0):((red + 24 > 255)?255:(red = red + 24));
                isTrue == 1 ? ((green - 48 >= 0)?(green = green - 48):0):((green + 24 > 255)?255:(green = green + 24));
                isTrue == 1 ? ((blue - 48 >= 0)?(blue = blue - 48):0):((blue + 24 > 255)?255:(blue = blue + 24));
            }
            return red+","+green+","+blue;
        }

    }

    this.refreshByLinkage=function(fltHeight){
        this.data = totalTableData();
        me.draw(fltHeight);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = totalTableData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----迷你图*/
function SparkLine(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignSparkLineData();

    function assignSparkLineData(){
        if(viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var sparkLineData = {};
        sparkLineData.tableHead = [];
        sparkLineData.tableHeadStyle = [];

        for(var i = 0; i < viewBlock.viewTableHead.viewTableRows.count; i++){
            var tableRow = [];
            for(var j = 0; j < viewBlock.viewTableHead.viewTableRows.item(i).viewTableCells.count; j++){
                var viewTableCell = viewBlock.viewTableHead.viewTableRows.item(i).viewTableCells.item(j);
                if(viewTableCell.rowspan && viewTableCell.colspan){
                    var tempObj = {};
                    if(viewTableCell.colspan == 1){
                        tempObj.field = j+'';
                    }
                    if(!viewTableCell.formatString){
                        if(viewTableCell.cellObject[3] != 1){
                            tempObj.title = viewTableCell.text===null?"":viewTableCell.text;
                        }else{
                            tempObj.title = (!isNaN(viewTableCell.text))?$BDA.formatString.date(viewTableCell.formatString,new Date(Number(viewTableCell.text))):viewTableCell.text;
                        }
                    }else {
                        if(viewTableCell.cellObject[3] <= 0){
                            tempObj.title = viewTableCell.text===null?"":viewTableCell.text;
                        }else if(viewTableCell.cellObject[3] == 1){
                            tempObj.title = (!isNaN(viewTableCell.text))?$BDA.formatString.date(viewTableCell.formatString,new Date(Number(viewTableCell.text))):viewTableCell.text;
                        }else{
                            tempObj.title = $BDA.formatString.number(viewTableCell.formatString,(!isNaN(viewTableCell.text))?(Number(viewTableCell.text) || ''):(viewTableCell.text || ''));
                        }
                    }
                    tempObj.colspan = viewTableCell.colspan;
                    tempObj.rowspan = viewTableCell.rowspan;
                    sparkLineData.tableHeadStyle.push({
                        "color": $BDA.csharp2rgba(viewTableCell.cellTextBox.color),
                        "backgroundColor": $BDA.csharp2rgba(viewTableCell.cellTextBox.backgroundColor),
                        "verticalAlign": viewTableCell.cellTextBox.verticalAlign=='0'?'top':(viewTableCell.cellTextBox.verticalAlign=='1'?'middle':'bottom'),
                        "textAlign": viewTableCell.cellTextBox.textAlign=='0'?'left':(viewTableCell.cellTextBox.textAlign=='1'?'center':'right'),
                        "fontFamily": viewTableCell.cellTextBox.font.fontFamily,
                        'fontSize': viewTableCell.cellTextBox.font.size/100+"rem",
                        'fontStyle': viewTableCell.cellTextBox.font.italic?'italic':'normal',
                        'fontWeight': viewTableCell.cellTextBox.font.bold?'bold':'normal',
                        'textDecoration': viewTableCell.cellTextBox.font.underline?'underline':
                            (viewTableCell.cellTextBox.font.strikeout?'line-through':'none')
                    });
                    tableRow.push(tempObj);
                }
            }
            sparkLineData.tableHead.push(tableRow);
        }

        var dimensionsArr = [];
        sparkLineData.sparklineFormatString = [];
        sparkLineData.sparklineWidth = [];
        sparkLineData.sparklineIndex = 0;
        sparkLineData.sparkLinesArr = [];
        for(var i = 0; i < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++){
            var viewTableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i);
            if(!viewTableCell.viewSparkline && viewTableCell.cellObject[2] == 0){
                dimensionsArr.push(viewTableCell.cellObject);
            }
            if(viewTableCell.viewSparkline){
                sparkLineData.sparklineFormatString.push(viewTableCell.formatString);
                sparkLineData.sparklineIndex++;
                sparkLineData.sparklineWidth.push(viewTableCell.columnWidth);
                sparkLineData.sparkLinesArr.push(viewTableCell.viewSparkline);
            }
        }

        var blockData = [];
        var dimensionValues = [];
        for(var i = 0; i < viewBlock.blockDataToDraw.length; i++){
            var tempObj = {};
            var tempDimensionObj = {};
            for(var j = 0; j < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                var viewTableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                var key = viewTableCell.cellObject[0]+'___'+viewTableCell.cellObject[1];
                if(!viewTableCell.viewSparkline){
                    if(viewBlock.blockDataToDraw[i][key] == null){
                        tempObj[viewTableCell.columnIndex] = '';
                    }else{
                        if(viewTableCell.cellObject[3] == 1){
                            tempObj[viewTableCell.columnIndex] = $BDA.formatString.date(viewTableCell.formatString,new Date(viewBlock.blockDataToDraw[i][key]));
                        }else if(viewTableCell.cellObject[3] == 2){
                            tempObj[viewTableCell.columnIndex] = $BDA.formatString.number(viewTableCell.formatString,viewBlock.blockDataToDraw[i][key]);
                        }else{
                            tempObj[viewTableCell.columnIndex] = viewBlock.blockDataToDraw[i][key]===null?"":viewBlock.blockDataToDraw[i][key];
                        }
                    }
                }
                if(viewTableCell.cellObject[2] == 0){
                    tempDimensionObj[key] = viewBlock.blockDataToDraw[i][key];
                }
            }
            dimensionValues.push(tempDimensionObj);
            blockData.push(tempObj);
        }

        sparkLineData.sparkLinesDimensions = [];
        for(var i = 0; i < blockData.length; i++){
            for(var j = 0; j < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                var viewTableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                var key = viewTableCell.cellObject[0]+'___'+viewTableCell.cellObject[1];
                if(viewTableCell.viewSparkline){
                    var tempObj = getSparkline(viewTableCell.viewSparkline,dimensionValues[i])
                    blockData[i][viewTableCell.columnIndex] = tempObj.currentData;
                    if(viewTableCell.viewSparkline.dimension[3] == 1){
                        for(var k = 0; k < tempObj.currentDimension.length; k++){
                            tempObj.currentDimension[k] = $BDA.formatString.date("",new Date(tempObj.currentDimension[k]))
                        }
                    }
                    sparkLineData.sparkLinesDimensions.push(tempObj.currentDimension);
                }
            }
        }

        sparkLineData.bodyData = blockData;

        return sparkLineData;

        function getSparkline(sparkline,dimensionValues){
            var tempSparklineData = [];
            $.extend(true,tempSparklineData,sparkline.sparklineData);

            for (var i = 0; i < dimensionsArr.length; i++){
                var key = dimensionsArr[i][0]+'___'+dimensionsArr[i][1];
                for (var j = tempSparklineData.length-1; j >= 0; j--){
                    if (tempSparklineData[j][key] != dimensionValues[key]){
                        tempSparklineData.splice(j,1);
                    }
                }
            }

            var currentData = [];
            var currentDimension = [];
            for(var i = 0; i < tempSparklineData.length; i++){
                currentData.push(tempSparklineData[i][sparkline.measure[0]+'___'+sparkline.measure[1]]);
                currentDimension.push(tempSparklineData[i][sparkline.dimension[0]+'___'+sparkline.dimension[1]]);
            }
            var obj = {};
            obj.currentData = currentData;
            obj.currentDimension = currentDimension;
            return obj;
        }
    }

    this.draw = function(fltHeight,openDrilldown){
        $(this.chartID).find(".bda-chart-content").html("");
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        var tempStr = "10,10,10,10";
        var paddingArr = viewBlock.padding?viewBlock.padding.split(","):tempStr.split(",");
        $(this.chartID).find('.bda-chart-content').css({
            "padding-top": Number($.trim(paddingArr[0]))/100 + "rem",
            "padding-right": Number($.trim(paddingArr[1]))/100 + "rem",
            "padding-bottom": Number($.trim(paddingArr[2]))/100 + "rem",
            "padding-left": Number($.trim(paddingArr[3]))/100 + "rem"
        });

        this.setChartContentHeight(fltHeight);
        if(viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var userAgent = window.navigator.userAgent;
        var isWebkit = false;
        if(userAgent.indexOf('Chrome') != -1){
            isWebkit = true;
        }
        var divBoxHeight = $(this.chartID).find('.bda-chart-content').height();
        var divBoxWidth = $(this.chartID).find('.bda-chart-content').width();

        maxWidth();
        setTableWidth(divBoxWidth,divBoxHeight);

        var table = document.createElement('table');
        $(table).attr('id','table-sparkline'+viewBlock.blockID);
        var tableHead = document.createElement('thead');
        for(var i = 0; i < this.data.tableHead.length; i++){
            var tr = document.createElement('tr');
            $(tr).css({
                'height': viewBlock.headHeight*$BDA.defaultRatio,
                'border-top-width': '0.02rem',
                'border-bottom-width': '0.02rem',
                'border-top-style': 'solid',
                'border-top-color': "rgb("+int2hex(viewBlock.tableStyleColor,2)+")",
                'border-bottom-style': 'solid',
                'border-bottom-color': "rgb("+int2hex(viewBlock.tableStyleColor,2)+")"
            });
            for(var j = 0; j < this.data.tableHead[i].length; j++){
                var th = document.createElement('th');
                var tempDiv = document.createElement('div');
                $(th).attr('rowspan',this.data.tableHead[i][j].rowspan);
                $(th).attr('colspan',this.data.tableHead[i][j].colspan);
                if(this.data.tableHead[i][j].field || this.data.tableHead[i][j].field == 0){
                    $(th).attr('field',this.data.tableHead[i][j].field);
                    $(th).attr('width',this.data.tableHead[i][j].width);
                    $(tempDiv).css({
                        'height': viewBlock.headHeight*$BDA.defaultRatio,
                        'line-height': viewBlock.headHeight*$BDA.defaultRatio+'px',
                        "width": me.data.maxTopWidth[j],
                        "overflow": "hidden",
                        "white-space": "nowrap",
                        "box-size": "border-box",
                        "padding": me.data.maxTopWidth[j]?"0 0.05rem":0
                    });
                }
                $(th).css({
                    'height': viewBlock.headHeight*$BDA.defaultRatio,
                    "color": this.data.tableHeadStyle[j].color,
                    "backgroundColor": this.data.tableHeadStyle[j].backgroundColor,
                    "textAlign": this.data.tableHeadStyle[j].textAlign,
                    "verticalAlign": this.data.tableHeadStyle[j].verticalAlign,
                    "font-family": this.data.tableHeadStyle[j].fontFamily,
                    'font-size': this.data.tableHeadStyle[j].fontSize,
                    'font-style': this.data.tableHeadStyle[j].fontStyle,
                    'font-weight': this.data.tableHeadStyle[j].fontWeight,
                    'text-decoration': this.data.tableHeadStyle[j].textDecoration
                });
                tempDiv.innerHTML = this.data.tableHead[i][j].title;
                //th.innerHTML = this.data.tableHead[i][j].title;
                th.appendChild(tempDiv);
                tr.appendChild(th);
            }
            tableHead.appendChild(tr);
        }
        table.appendChild(tableHead);

        var tableBody = document.createElement('tbody');
        $(tableBody).attr('id','tbody-sparkline'+viewBlock.blockID);

        for(var i = 0; i < this.data.bodyData.length; i++){
            var tr = document.createElement('tr');
            $(tr).css({
                'height': viewBlock.bodyHeight*$BDA.defaultRatio,
                'border-bottom-width': '0.01rem',
                'border-bottom-style': 'solid',
                'border-bottom-color': "rgb("+int2hex(viewBlock.tableStyleColor,2)+")"
            });
            $(tr).attr('datagrid-row-index',i);
            for(var j = 0; j < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; j++){
                var viewTableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(j);
                var td = document.createElement('td');
                var tempDiv = document.createElement('div');
                $(td).attr('field', viewTableCell.columnIndex);
                if (viewTableCell.viewSparkline && me.data.maxTopWidth[j] && viewBlock.bodyHeight) {
                    var chartStr = viewTableCell.viewSparkline.chartID == 10 ? ';line' : (viewTableCell.viewSparkline.chartID == 11 ? ';area' : ';column');
                    var dataStr = this.data.bodyData[i][viewTableCell.columnIndex].join(',');
                    $(td).attr('data-sparkline', dataStr + chartStr);
                } else {
                    tempDiv.innerHTML = this.data.bodyData[i][viewTableCell.columnIndex];
                    //td.innerHTML = this.data.bodyData[i][viewTableCell.columnIndex];
                    td.appendChild(tempDiv);
                    $(td).css({
                        "color": $BDA.csharp2rgba(viewTableCell.cellTextBox.color),
                        'height': viewBlock.bodyHeight*$BDA.defaultRatio,
                        "backgroundColor": $BDA.csharp2rgba(viewTableCell.cellTextBox.backgroundColor),
                        "verticalAlign": viewTableCell.cellTextBox.verticalAlign == '0' ? 'top' : (viewTableCell.cellTextBox.verticalAlign == '1' ? 'middle' : 'bottom'),
                        "textAlign": viewTableCell.cellTextBox.textAlign == '0' ? 'left' : (viewTableCell.cellTextBox.textAlign == '1' ? 'center' : 'right'),
                        "fontFamily": viewTableCell.cellTextBox.font.fontFamily,
                        'fontSize': viewTableCell.cellTextBox.font.size/100+"rem",
                        'fontStyle': viewTableCell.cellTextBox.font.italic ? 'italic' : 'normal',
                        'fontWeight': viewTableCell.cellTextBox.font.bold ? 'bold' : 'normal',
                        'textDecoration': viewTableCell.cellTextBox.font.underline ? 'underline' :
                            (viewTableCell.cellTextBox.font.strikeout ? 'line-through' : 'none')
                    }).find("div").css({
                        "width": me.data.maxTopWidth[j],
                        'height': viewBlock.bodyHeight*$BDA.defaultRatio,
                        'line-height': viewBlock.bodyHeight*$BDA.defaultRatio+'px',
                        "overflow": "hidden",
                        "white-space": "nowrap",
                        "box-size": "border-box",
                        "padding": me.data.maxTopWidth[j]?"0 0.05rem":0
                    });
                }
                tr.appendChild(td);
            }
            tableBody.appendChild(tr);
        }
        table.appendChild(tableBody);
        $(table).css('width',sumWidth(me.data.maxTopWidth));

        var divBox = document.createElement('div');
        $(divBox).css({
            'width': divBoxWidth,
            'height': divBoxHeight,
            'overflow': 'auto'
        });
        divBox.appendChild(table);
        $(this.chartID).find(".bda-chart-content").append(divBox);

        Highcharts.SparkLine = function (a, b, c) {
            var hasRenderToArg = typeof a === 'string' || a.nodeName,
                options = arguments[hasRenderToArg ? 1 : 0],
                defaultOptions = {
                    chart: {
                        renderTo: (options.chart && options.chart.renderTo) || this,
                        backgroundColor: null,
                        borderWidth: 0,
                        type: options.chart.type,
                        margin: [2*$BDA.defaultRatio, 0, 2*$BDA.defaultRatio, 0],
                        width: options.chart.width,
                        height: options.chart.height,
                        style: {
                            overflow: 'visible'
                        },
                        // small optimalization, saves 1-2 ms each sparkline
                        skipClone: true
                    },
                    title: {
                        text: ''
                    },
                    credits: {
                        enabled: false
                    },
                    xAxis: {
                        categories: options.chart.categories,
                        labels: {
                            enabled: false
                        },
                        title: {
                            text: null
                        },
                        startOnTick: false,
                        endOnTick: false,
                        lineWidth: options.chart.showAxis?1*$BDA.defaultRatio:0,
                        tickPositions: []
                    },
                    yAxis: {
                        endOnTick: false,
                        startOnTick: false,
                        labels: {
                            enabled: false
                        },
                        title: {
                            text: null
                        },
                        gridLineWidth: options.chart.showAxis?1*$BDA.defaultRatio:0,
                        tickPositions: [0]
                    },
                    legend: {
                        enabled: false
                    },
                    tooltip: {
                        hideDelay: 0,
                        outside: true,
                        shared: true
                    },
                    plotOptions: {
                        series: {
                            animation: false,
                            lineWidth: 1,
                            shadow: false,
                            states: {
                                hover: {
                                    lineWidth: 1*$BDA.defaultRatio
                                }
                            },
                            marker: {
                                radius: 1,
                                states: {
                                    hover: {
                                        radius: 2
                                    }
                                }
                            },
                            fillOpacity: 0.25
                        },
                        column: {
                            negativeColor: '#910000',
                            borderColor: 'silver'
                        }
                    }
                };
            options = Highcharts.merge(defaultOptions, options);
            return hasRenderToArg ?
                new Highcharts.Chart(a, options, c) :
                new Highcharts.Chart(options, b);
        };

        var $tds = $(this.chartID).find('td[data-sparkline]');

        if(!openDrilldown && openDrilldown!=false){
            reportLink();
        }
        doChunk();

        function doChunk() {
            var len = $tds.length,
                $td,
                stringdata,
                arr,
                data,
                chart;
            for (var i = 0; i < len; i += 1) {
                $td = $($tds[i]);
                stringdata = $td.data('sparkline');
                if(!stringdata){break;}
                arr = stringdata.split(';');
                data = $.map(arr[0].split(','), parseFloat);
                chart = {};
                if (arr[1]) {
                    chart.type = arr[1];
                    chart.width = me.data.sparklineWidth[i%me.data.sparklineIndex];
                    chart.height = (viewBlock.bodyHeight*$BDA.defaultRatio);
                    chart.showAxis = me.data.sparkLinesArr[i%me.data.sparklineIndex].showAxis;
                    chart.categories = me.data.sparkLinesDimensions[i];
                }
                $td.highcharts('SparkLine', {
                    series: [{
                        data: data,
                        pointStart: 0
                    }],
                    tooltip: {
                        //pointFormat: '<b>{point.y}</b>'
                        formatter:function(){
                            return this.x+': '+$BDA.formatString.number(me.data.sparklineFormatString[i%me.data.sparklineIndex],this.y);
                        },
                    },
                    chart: chart
                });
            }
        }

        function getLength(str,isHead,i,j){
            if(isHead){
                $('.test-length span').css({
                    'font-family': viewBlock.viewTableHead.viewTableRows.item(j).viewTableCells.item(i).cellTextBox.font.fontFamily,
                    'font-size': viewBlock.viewTableHead.viewTableRows.item(j).viewTableCells.item(i).cellTextBox.font.size/100+"rem"
                });
                return parseInt($('.test-length span').html(str).width() + 5);   //8,表头单元格内边距，13，表头排序三角符宽度
            }else{
                $('.test-length span').css({
                    'font-family':viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).cellTextBox.font.fontFamily,
                    'font-size':viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).cellTextBox.font.size/100+"rem"
                });
                return parseInt($('.test-length span').html(str).width() + 5);
            }
        }

        function sumWidth(arry){
            var sumArry = 0;
            for(var i= 0;i<arry.length;i++){
                sumArry += arry[i];
            }
            return sumArry;
        }

        function maxWidth(){
            var tableHeadStrLength = computeTableHeadTableCellWidth();
            var tableBodyStrLength = computeTableBodyTableCellWidth();
            var tableCellMaxWidthArray = [];
            var maxValue = 0;

            for(var i= 0;i<tableBodyStrLength.length;i++){
                maxValue = Math.max(tableHeadStrLength[i],tableBodyStrLength[i]);
                tableCellMaxWidthArray.push(maxValue);
            }

            me.data.maxTopWidth = tableCellMaxWidthArray;
        }

        function computeTableHeadTableCellWidth(){
            var tableHead = viewBlock.viewTableHead;
            var tableHeadStrLength = [];
            var array = [];
            var tableCell = null;
            for(var i = 0; i < tableHead.viewTableRows.item(0).viewTableCells.count; i++){
                array = [];
                tableCell = tableHead.viewTableRows.item(0).viewTableCells.item(i);
                // if(tableCell.colspan > 1){
                //     array.push(0);
                // }else{
                    if(tableCell.autoColumnWidth && !tableCell.viewSparkline){
                        for(var j= 0,jen=tableHead.viewTableRows.count;j<jen;j++){
                            if(tableHead.viewTableRows.item(j).viewTableCells.item(i).colspan > 1){
                                array.push(0);
                            }else{
                                var strLength = tableHead.viewTableRows.item(j).viewTableCells.item(i).text;
                                array.push(getLength(strLength,true,i,j)+1);
                            }
                        }
                    }else if(tableCell.viewSparkline){
                        array.push(tableCell.columnWidth*$BDA.tableColumnsWidthRatio);
                    }else{
                        array.push(tableCell.columnWidth*$BDA.tableColumnsWidthRatio);
                    }
                // }

                tableHeadStrLength.push(Math.max.apply(Math,array));
            }
            return tableHeadStrLength;
        }

        function computeTableBodyTableCellWidth(){
            var tableBodyStrLength = [];
            var tableBody = viewBlock.viewTableBody;
            var array = [];
            var tableCell = null;
            for(var i = 0; i < tableBody.viewTableRows.item(0).viewTableCells.count; i++){
                array = [];
                tableCell = tableBody.viewTableRows.item(0).viewTableCells.item(i);
                if(tableCell.autoColumnWidth && !tableCell.viewSparkline){
                    for(var j= 0,jen= me.data.bodyData.length;j<jen;j++){
                        var strLength = me.data.bodyData[j][i];
                        array.push(getLength(strLength,false,i));
                    }
                }else if(tableCell.viewSparkline){
                    array.push(tableCell.columnWidth*$BDA.tableColumnsWidthRatio);
                }else{
                    array.push(tableCell.columnWidth*$BDA.tableColumnsWidthRatio);
                }
                tableBodyStrLength.push(Math.max.apply(Math,array));
            }

            return tableBodyStrLength;
        }

        function setTableWidth(tableWidth,tableHeight){
            var headHeight = (viewBlock.headHeight?viewBlock.headHeight:30)*$BDA.defaultRatio;
            var bodyHeight = (viewBlock.bodyHeight?viewBlock.bodyHeight:30)*$BDA.defaultRatio;
            var currentTableHeight = me.data.tableHead.length * headHeight + me.data.bodyData.length * bodyHeight;
            var maxSumValue = sumWidth(me.data.maxTopWidth);
            var borderAddedValue = 0;
            var scrollWidth = isWebkit?10:17;

            if(currentTableHeight<=tableHeight){
                if (tableWidth >= maxSumValue) {
                    setNotExceedingWidth(tableWidth,maxSumValue,0,borderAddedValue);
                } else {
                    setExceedWidth();
                }
                me.data.isNotHiddenScroll = true;
            }else {
                if ((tableWidth - maxSumValue) >= scrollWidth) {
                    setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue);
                } else {
                    setExceedWidth();
                }
            }
        }

        function setNotExceedingWidth(tableWidth,maxSumValue,scrollWidth,borderAddedValue){
            var averageWidth = parseInt((tableWidth - maxSumValue - scrollWidth) / me.data.maxTopWidth.length);

            for (var i = 0; i < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++) {
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).autoColumnWidth){
                    me.data.maxTopWidth[i] += averageWidth;
                }
            }

            var lastTd = tableWidth - sumWidth(me.data.maxTopWidth) - (borderAddedValue?0:1) - scrollWidth + borderAddedValue;

            for(var i = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count - 1; i >= 0; i--){
                if(viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).autoColumnWidth){
                    me.data.maxTopWidth[i] += lastTd;
                    break;
                }
            }

            setExceedWidth();
        }

        function setExceedWidth(){
            for (var i = 0, len = me.data.tableHead.length; i < len; i++) {
                for (var j = 0, jen = me.data.tableHead[i].length; j < jen; j++) {
                    if (me.data.tableHead[i][j].field) {
                        var field = me.data.tableHead[i][j].field;
                        for (var k = 0, ken = me.data.maxTopWidth.length; k < ken; k++) {
                            if (field == k) {
                                me.data.tableHead[i][j].width = me.data.maxTopWidth[k];
                            }
                        }
                    }
                }
            }

            me.data.sparklineWidth = [];
            for (var i = 0; i < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++) {
                if (viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i).viewSparkline) {
                    me.data.sparklineWidth.push(me.data.maxTopWidth[i]);
                }
            }
        }

        function reportLink(){
            var tableBody = viewBlock.viewTableBody;
            for(var i= 0,len=tableBody.viewTableRows.item(0).viewTableCells.count;i<len;i++){
                var tableBodyCell=tableBody.viewTableRows.item(0).viewTableCells.item(i);
                if ((tableBodyCell.reportLink && tableBodyCell.reportLink.reportID) || (tableBodyCell.reportLinks && tableBodyCell.reportLinks.count > 0)){
                    $(me.chartID).find('tr').each(function(){
                        $(this).find('td[field='+i+']').addClass('tableCell-reportLink').css('text-decoration','underline').hover(function(){$(this).css('cursor','pointer');},
                                function(){$(this).css('cursor','default');});
                    });
                }
            }
        }

        function int2hex(rgbInt,isTrue) {
            var red = (rgbInt >> 16) & 255;
            var green = (rgbInt >> 8) & 255;
            var blue = rgbInt & 255;
            if(isTrue){
                isTrue == 1 ? ((red - 48 >= 0)?(red = red - 48):0):((red + 24 > 255)?255:(red = red + 24));
                isTrue == 1 ? ((green - 48 >= 0)?(green = green - 48):0):((green + 24 > 255)?255:(green = green + 24));
                isTrue == 1 ? ((blue - 48 >= 0)?(blue = blue - 48):0):((blue + 24 > 255)?255:(blue = blue + 24));
            }
            return red+","+green+","+blue;
        }
    }

    this.refreshByLinkage=function(fltHeight){
        return;
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignSparkLineData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----散点地图*/
function ScatterMap(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.currentDataIndex = 0;
    this.reportLinkData = null;
    this.mapObjectGeoName = null;
    this.drillMapGeoName = null;
    this.geoLevel = viewBlock.geoLevel;
    this.haveChildMap = viewBlock.haveChildMap;
    this.data = assignScatterMapData();

    function assignScatterMapData(){
        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var mapData = {};
        mapData.mapCode = viewBlock.mapCode;
        var blockData =  viewBlock.blockDataToDraw;
        var mainMeasureName = viewBlock.mainMeasure?(viewBlock.mainMeasure[0]+'___'+viewBlock.mainMeasure[1]):null;
        var dimension = viewBlock.locationDimension?(viewBlock.locationDimension[0]+'___'+viewBlock.locationDimension[1]):null;
        mapData.blockData = blockData;
        mapData.dimension = dimension;
        mapData.mainMeasureName = mainMeasureName;
        var otherMeasureNames=[];
        for(var i= 0,len=viewBlock.otherMeasures.length;i<len;i++){
            otherMeasureNames.push(viewBlock.otherMeasures[i][0]+'___'+viewBlock.otherMeasures[i][1]);
        }
        mapData.otherMeasureNames = otherMeasureNames;
        mapData.reportLink = viewBlock.reportLink;

        var min = 0,max = 0,rangeData = [];
        var total = 0;
        mapData.viewGeographyDataCompares = viewBlock.viewGeographyDataCompares;
        for(var i= 0,len=mapData.viewGeographyDataCompares.length;i<len;i++){
            var tempArr = [];
            if(mapData.viewGeographyDataCompares[i].objectGeoName == blockData[0][dimension]){
                total += blockData[0][mainMeasureName];
                $.extend(true,tempArr,mapData.viewGeographyDataCompares[i].coordinate);
                tempArr.push(blockData[0][mainMeasureName]);
                rangeData.push({name:mapData.viewGeographyDataCompares[i].mapGeoName,value:tempArr});
            }
        }
        min = max = blockData[0][mainMeasureName];
        for (var i=1;i<blockData.length;i++){
            var tempArr = [];
            var currentMeasure = blockData[i][mainMeasureName];
            min >= currentMeasure&&(min = currentMeasure);
            max < currentMeasure&&(max = currentMeasure);
            for(var j= 0,jen=mapData.viewGeographyDataCompares.length;j<jen;j++){
                if(mapData.viewGeographyDataCompares[j].objectGeoName == blockData[i][dimension]){
                    total += blockData[i][mainMeasureName];
                    $.extend(true,tempArr,mapData.viewGeographyDataCompares[j].coordinate);
                    tempArr.push(blockData[i][mainMeasureName]);
                    rangeData.push({name:mapData.viewGeographyDataCompares[j].mapGeoName,value:tempArr});
                    break;
                }
            }
        }
        min > 0&&(min=0);
        mapData.min = min;
        mapData.max = max;
        mapData.rangeData = rangeData;

        mapData.averageValue = total/blockData.length;

        var pieces = [];
        if(viewBlock.mapLegend && viewBlock.mapLegend.legendRanges.length != 0){
            for(var i = 0; i < viewBlock.mapLegend.legendRanges.length; i++){
                var tempObj = {};
                if(viewBlock.mapLegend.legendRanges[i].start){
                    tempObj.gt = Number(viewBlock.mapLegend.legendRanges[i].start);
                }
                if(viewBlock.mapLegend.legendRanges[i].end){
                    tempObj.lte = Number(viewBlock.mapLegend.legendRanges[i].end);
                }
                if(viewBlock.mapLegend.legendRanges[i].label){
                    tempObj.label = viewBlock.mapLegend.legendRanges[i].label;
                }
                tempObj.color = 'rgb('+int2hex(viewBlock.mapLegend.legendRanges[i].color,false)+')';
                pieces.push(tempObj);
            }
        }

        mapData.pieces = pieces;
        mapData.defaultColor = $BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence,true);
        return mapData;

        function int2hex(rgbInt,isTrue) {
            var red = (rgbInt >> 16) & 255;
            var green = (rgbInt >> 8) & 255;
            var blue = rgbInt & 255;
            if(isTrue){
                isTrue == 1 ? ((red - 48 >= 0)?(red = red - 48):0):((red + 24 > 255)?255:(red = red + 24));
                isTrue == 1 ? ((green - 48 >= 0)?(green = green - 48):0):((green + 24 > 255)?255:(green = green + 24));
                isTrue == 1 ? ((blue - 48 >= 0)?(blue = blue - 48):0):((blue + 24 > 255)?255:(blue = blue + 24));
            }
            return red+","+green+","+blue;
        }
    }

    this.draw = function (fltHeight,openDrilldown) {
        this.setChartContentHeight(fltHeight);
        $(this.chartID).find('.bda-map-content').remove();
        $(this.chartID).find('.bda-chart-content').css('padding','10px').append('<div class="bda-map-content"></div>');

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        ajaxTools.request('../mapResource/'+ viewBlock.mapCode + '.json',"","get", function(data,status,jqXHR){
            viewBlock.mapData = data;
            load(viewBlock.mapData);
        }, function(){});

        function load(mapData){
            echarts.registerMap(me.data.mapCode, mapData);
            var mapChart = echarts.init($(me.chartID).find('.bda-map-content')[0]);
            mapChart.setOption({
                series:[{
                    type: 'scatter',
                    coordinateSystem: 'geo',
                    data: me.data.rangeData,
                    symbol: $BDA.scatterMapSymbolType(viewBlock.symbolType),
                    symbolSize: viewBlock.symbolSizeFixed?viewBlock.symbolSize:function(val){
                        return val[2] * viewBlock.symbolSize / me.data.averageValue;
                    },
                    label: {
                        normal: {
                            show: false
                        },
                        emphasis: {
                            show: false
                        }
                    },
                    itemStyle: {
                        normal: {
                            areaColor: $BDA.csharp2rgba(viewBlock.mapDefaultColor),
                            borderColor: $BDA.csharp2rgba(viewBlock.mapBorderColor),
                            borderWidth: viewBlock.mapBorderWidth,
                            color: $BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence,true)[0]
                        },
                        emphasis: {
                            areaColor: $BDA.csharp2rgba(viewBlock.mapHoverColor),
                            borderColor: $BDA.csharp2rgba(viewBlock.mapBorderColor),
                            borderWidth: viewBlock.mapBorderWidth
                        }
                    }
                    //itemStyle: {
                    //    normal: {
                    //        color: $BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence,true)[0]
                    //    },
                    //    emphasis: {
                    //        borderColor: '#000',
                    //        borderWidth: 1
                    //    }
                    //}
                }],
                geo: {
                    map: me.data.mapCode,
                    label: {
                        emphasis: {
                            show: false
                        }
                    },
                    itemStyle: {
                        normal: {
                            areaColor: $BDA.csharp2rgba(viewBlock.mapDefaultColor)
                        },
                        emphasis: {
                            areaColor: $BDA.csharp2rgba(viewBlock.mapHoverColor)
                        }
                    }
                },
                visualMap: {
                    show: me.data.pieces.length?true:false,
                    type: 'piecewise',
                    min: me.data.min,
                    max: me.data.max,
                    x: viewBlock.mapLegend?((viewBlock.mapLegend.legendPosition == 0 || viewBlock.mapLegend.legendPosition == 3)?'left':'right'):'left',
                    y: viewBlock.mapLegend?((viewBlock.mapLegend.legendPosition == 0 || viewBlock.mapLegend.legendPosition == 1)?'top':'bottom'):'bottom',
                    pieces: me.data.pieces,
                    color: me.data.pieces.length?$BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence,true):[],
                    textStyle: {
                        color: viewBlock.mapLegend?$BDA.csharp2rgba(viewBlock.mapLegend.fontColor):'#333'
                    },
                    textGap: 5
                },
                tooltip:{
                    show:true,
                    textStyle: {
                        fontSize: 14*$BDA.defaultRatio
                    },
                    formatter:function(map){
                        var currentObj = {},str = '';
                        for (var i=0,len=me.data.blockData.length;i<len;i++){
                            var currentDimension = '';
                            for(var j= 0,jen=me.data.viewGeographyDataCompares.length;j<jen;j++){
                                if(me.data.blockData[i][me.data.dimension] == me.data.viewGeographyDataCompares[j].objectGeoName){
                                    currentDimension = me.data.viewGeographyDataCompares[j].mapGeoName;
                                    break;
                                }
                            }
                            if (map.name && (map.name == currentDimension)){
                                currentObj = me.data.blockData[i];
                                break;
                            }
                        }
                        for (var key in currentObj){
                            str+= key.slice(key.indexOf('___')+3) +' : '+currentObj[key]+'<br/>';
                        }
                        return str;
                    }
                }
            });
            /*报表链接获取目标对象*/
            mapChart.on('click', function (params) {
                var name = params.name;
                var currentObjectGeoName='';
                me.reportLinkData = null;
                me.mapObjectGeoName = null;
                me.drillMapGeoName = null;
                for(var i=0;i<me.data.viewGeographyDataCompares.length;i++){
                    if(name == me.data.viewGeographyDataCompares[i].mapGeoName){
                        currentObjectGeoName = me.data.viewGeographyDataCompares[i].objectGeoName;
                        break;
                    }
                }

                if((openDrilldown && me.haveChildMap) || viewBlock.linkage){
                    me.mapObjectGeoName = currentObjectGeoName;
                    me.drillMapGeoName = name;
                    return
                }else{
                    for(var i=0;i<me.data.blockData.length;i++){
                        if (typeof openDrilldown == 'undefined' && currentObjectGeoName == me.data.blockData[i][me.data.dimension] && (me.data.reportLink || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0))){
                            me.reportLinkData = me.data.blockData[i];
                            return;
                        }
                    }
                }
            });
        }
    };

    this.refreshByLinkage=function(fltHeight){
        this.data = assignScatterMapData();
        me.draw(fltHeight);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignScatterMapData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }

}

/*类----自由单元格*/
function FreeCell(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.draw = function(fltHeight,openDrilldown){
        $(this.chartID).find('h3').css('display','none');
        $(this.chartID).find('.bda-chart-box').css('padding',0);
        this.setChartContentHeight(fltHeight);

        $(this.chartID).find('.bda-label-content').remove();
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-label-content"></div>');
        var contentWidth = $(this.chartID).find('.bda-chart-content').width();
        var contentHeight = $(this.chartID).find('.bda-chart-content').height();
        var screenHeight = fltHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        screenHeight = screenHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        $(this.chartID).find(".bda-chart-content").css("height",screenHeight/(100*$BDA.defaultRatio)+"rem");

        $(me.chartID).find('.bda-label-content').css({
            'width': contentWidth,
            'height': screenHeight/(100*$BDA.defaultRatio)+"rem"
        });
        $(me.chartID).find('.bda-bgcolor').css('border-radius',viewBlock.labelTextBox.borderRadius.replace(/\,/g,'px ') + 'px');
        $(me.chartID).find('.bda-label-content').append('<div class="text-content"></div>');
        $(me.chartID).find('.text-content').css({
            'width': contentWidth,
            'height': screenHeight/(100*$BDA.defaultRatio)+"rem",
            'display': (viewBlock.textScroll&&viewBlock.scrollDirection==1)?'block':'table-cell',
            //'padding': '0 15px',
            'border-radius': viewBlock.labelTextBox.borderRadius.replace(/\,/g,'px ') + 'px',
            'background-color': $BDA.csharp2rgba(viewBlock.labelTextBox.backgroundColor),
            'text-align': viewBlock.labelTextBox.textAlign=='0'?'left':(viewBlock.labelTextBox.textAlign=='1'?'center':'right'),
            'color': $BDA.csharp2rgba(viewBlock.labelTextBox.color),
            'font-family': viewBlock.labelTextBox.font.fontFamily,
            'font-size': viewBlock.labelTextBox.font.size/100+"rem",
            'font-style': viewBlock.labelTextBox.font.italic?'italic':'normal',
            'font-weight': viewBlock.labelTextBox.font.bold?'bold':'normal',
            'text-decoration': viewBlock.labelTextBox.font.underline?'underline':
                (viewBlock.labelTextBox.font.strikeout?'line-through':'none'),
            'vertical-align': viewBlock.labelTextBox.verticalAlign=='0'?'top':(viewBlock.labelTextBox.verticalAlign=='1'?'middle':'bottom'),
            'word-break': 'break-word',
            'white-space': (viewBlock.textScroll&&viewBlock.scrollDirection==0)?'nowrap':'normal',
            'word-wrap': 'break-word'
        });

        if(viewBlock.freeCellType == 0){
            $(me.chartID).find('.text-content').text(viewBlock.labelContent);
        }
        if(viewBlock.freeCellType == 1){
            var labelIframe = "<iframe name='labelIframe"+viewBlock.blockID+"' class='labelIframe' frameborder='no' scrolling='auto' width='100%' height='100%' allowtransparency='true' src=''></iframe>";
            $(me.chartID).find('.text-content').html(labelIframe);
            window.open(viewBlock.labelContent,'labelIframe'+viewBlock.blockID);
        }
        if(viewBlock.freeCellType == 2){
            $(me.chartID).find('.text-content').html(viewBlock.labelContent);
        }
        if(viewBlock.freeCellType == 3){
            var str = '';
            if(viewBlock.blockDataToDraw){
                if(viewBlock.blockDataToDraw.length>1){
                    str = '#MultiValue';
                }
                if(viewBlock.blockDataToDraw.length==1){
                    str = viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+'___'+viewBlock.dataObject[1]];
                    if(viewBlock.dataObject[3] == 0){
                        str = viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+'___'+viewBlock.dataObject[1]];
                    }
                    if(viewBlock.dataObject[3] == 1){
                        str = $BDA.formatString.date(viewBlock.formatString||"",new Date(viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+'___'+viewBlock.dataObject[1]]));
                    }
                    if(viewBlock.dataObject[3] == 2){
                        str = $BDA.formatString.number(viewBlock.formatString||"", viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+'___'+viewBlock.dataObject[1]]);
                    }
                }
            }
            $(me.chartID).find('.text-content').html(str);
        }
        if(viewBlock.freeCellType == 4){
            if(viewBlock.dataObject && viewBlock.dataObject[3] == 4){
                var labelImage = "<img width='100%' height='100%' src='data:image/png;base64,"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"' />";
            }else if(viewBlock.dataObject && viewBlock.dataObject[3] == 3){
                var labelImage = "<img width='100%' height='100%' src='"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"' />";
            }else{
                var labelImage = "<img width='100%' height='100%' src='"+viewBlock.labelContent+"' />";
            }
            $(me.chartID).find('.text-content').html(labelImage);
        }

        if(viewBlock.textScroll && viewBlock.freeCellType != 1){
            textBoxScroll(viewBlock.scrollTimePerPx);
        }

        function textBoxScroll(speed){
            var speed=speed;
            var timeId = null;
            if(viewBlock.scrollDirection==0){
                if($(me.chartID).find('.text-content').width()<=contentWidth){
                    $(me.chartID).find('.text-content').css('width',contentWidth);
                    $(me.chartID).find('.bda-label-content').css('width',contentWidth*2);
                }else{
                    $(me.chartID).find('.bda-label-content').css('width',$(me.chartID).find('.text-content').width()*2);
                }
                var originalBox = $(me.chartID).find('.bda-label-content');
                var originalBoxHtml = originalBox.html();
                originalBox.html(originalBoxHtml+originalBoxHtml);

                var originalBoxHeight = originalBox.height();
                var originalBoxWidth = $(me.chartID).find('.text-content').width();
                $(me.chartID).find('.bda-chart-content').css('position','relative');
                originalBox.css('position','absolute');
                var scrollTop = -1;
            }
            if(viewBlock.scrollDirection==1){
                $(me.chartID).find('.text-content').css('width',contentWidth);
                if($(me.chartID).find('.text-content').height()<=(contentHeight+10)){
                    $(me.chartID).find('.text-content').css('height',contentHeight+10);
                    $(me.chartID).find('.bda-label-content').css('height',(contentHeight+10)*2);
                }else{
                    $(me.chartID).find('.bda-label-content').css('height',$(me.chartID).find('.text-content').height()*2);
                }
                var originalBox = $(me.chartID).find('.bda-label-content');
                var originalBoxHtml = originalBox.html();
                originalBox.html(originalBoxHtml+originalBoxHtml);

                var originalBoxHeight = originalBox.height()*2;
                var originalBoxWidth = $(me.chartID).find('.text-content').width();
                $(me.chartID).find('.bda-chart-content').css('position','relative');
                originalBox.css('position','absolute');
                var scrollTop = -1;
            }
            function slider(){
                if(viewBlock.scrollDirection==0){
                    if(originalBox.css('left')==(-parseInt($(me.chartID).find('.bda-label-content').width()/2)+'px')){
                        originalBox.css('left','0px');
                        scrollTop = -1;
                    }
                    originalBox.css('left',scrollTop);
                    scrollTop--;
                }
                if(viewBlock.scrollDirection==1){
                    if(originalBox.css('top')==(-parseInt($(me.chartID).find('.bda-label-content').height()/2)+'px')){
                        originalBox.css('top','0px');
                        scrollTop = -1;
                    }
                    originalBox.css('top',scrollTop);
                    scrollTop--;
                }
            }

            // setInterval()函数的作用是：每隔一段时间，执行该函数里的代码
            timeId = setInterval(slider,speed);

            $(me.chartID).find('.bda-chart-content').mouseover(function(){
                // clearInterval()函数的作用是用来清除定时器
                clearInterval(timeId);
            });

            $(me.chartID).find('.bda-chart-content').mouseout(function(){
                timeId = setInterval(slider,speed);
            });
        }
    }

    this.refreshByLinkage=function(fltHeight){
        return;
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----时间*/
function DateTimeControl(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;
    var timer = null;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.draw = function(fltHeight,openDrilldown){
        $(this.chartID).find('h3').css('display','none');
        $(this.chartID).find('.bda-chart-box').css('padding',0);
        this.setChartContentHeight(fltHeight);

        $(this.chartID).find('.bda-label-content').remove();
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-label-content"></div>');
        var contentWidth = $(this.chartID).find('.bda-chart-content').width();
        var screenHeight = fltHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        screenHeight = screenHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        $(this.chartID).find(".bda-chart-content").css("height",screenHeight/(100*$BDA.defaultRatio)+"rem");

        clearInterval(timer);
        timer = null;
        timer = setInterval(function(){
            var today = new Date();
            var str = $BDA.formatString.date(viewBlock.dateTimeFormatString,today);
            $(me.chartID).find('.bda-label-content').text(str);
        },1000);

        $(me.chartID).find('.bda-label-content').css({
            'width': contentWidth,
            'height': screenHeight/(100*$BDA.defaultRatio)+"rem",
            'display': 'table-cell',
            //'padding': '0 15px',
            'border-radius': viewBlock.labelTextBox.borderRadius.replace(/\,/g,'px ') + 'px',
            'background-color': $BDA.csharp2rgba(viewBlock.labelTextBox.backgroundColor),
            'text-align': viewBlock.labelTextBox.textAlign=='0'?'left':(viewBlock.labelTextBox.textAlign=='1'?'center':'right'),
            'color': $BDA.csharp2rgba(viewBlock.labelTextBox.color),
            'font-family': viewBlock.labelTextBox.font.fontFamily,
            'font-size': viewBlock.labelTextBox.font.size/100+"rem",
            'font-style': viewBlock.labelTextBox.font.italic?'italic':'normal',
            'font-weight': viewBlock.labelTextBox.font.bold?'bold':'normal',
            'text-decoration': viewBlock.labelTextBox.font.underline?'underline':
                (viewBlock.labelTextBox.font.strikeout?'line-through':'none'),
            'vertical-align': viewBlock.labelTextBox.verticalAlign=='0'?'top':(viewBlock.labelTextBox.verticalAlign=='1'?'middle':'bottom')
        });
        $(me.chartID).find('.bda-bgcolor').css('border-radius',viewBlock.labelTextBox.borderRadius.replace(/\,/g,'px ') + 'px');

    }

    this.refreshByLinkage=function(fltHeight){
        return;
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----矩形树图*/
function TreeMap(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.highchart = null;
    this.data = assignTreeMapData();

    function assignTreeMapData(){
        if (!(viewBlock.primaryDimension || viewBlock.groupDimension) && !viewBlock.y1Measures.length){return;}

        var treeMapData = {};

        var blockData = viewBlock.blockDataToDraw;
        var primaryDimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]):null;
        var groupDimensionName = viewBlock.groupDimension?(viewBlock.groupDimension[0]+'___'+viewBlock.groupDimension[1]):null;
        var y1MeasureName = viewBlock.y1Measures[0][0]+'___'+viewBlock.y1Measures[0][1];
        var primaryDimensionDataType = viewBlock.primaryDimension?viewBlock.primaryDimension[3]:null;
        var groupDimensionDataType = viewBlock.groupDimension?viewBlock.groupDimension[3]:null;
        var formatString = viewBlock.y1DataFormat;

        for (var i=0,len=blockData.length;i<len;i++){
            if (primaryDimensionDataType == 1){
                blockData[i][primaryDimensionName] = $BDA.formatString.date('',new Date(blockData[i][primaryDimensionName]));
            }
            if (groupDimensionDataType == 1){
                blockData[i][groupDimensionName] = $BDA.formatString.date('',new Date(blockData[i][groupDimensionName]));
            }
        }
        var treeMapColor = $BDA.theme.themeID == 0 ? (viewBlock.ChartStyle.colorSequence.length ? $BDA.intColorArrayToStringHex(viewBlock.ChartStyle.colorSequence).split(" ") : $BDA.theme.defaultTheme.colors) : ($BDA.theme.themeID == 1 ? $BDA.theme.highcharts[0].colors : $BDA.theme.highcharts[1].colors)

        treeMapData.measuresData = [];

        if(viewBlock.primaryDimension && viewBlock.groupDimension){
            treeMapData.measuresData = assignHaveTwoDimensionAndMeasureData(blockData,primaryDimensionName,groupDimensionName,y1MeasureName,treeMapColor);
        }

        if(viewBlock.primaryDimension && !viewBlock.groupDimension){
            treeMapData.measuresData = assignOnlyPrimaryDimensionAndMeasureData(blockData,primaryDimensionName,y1MeasureName,treeMapColor);
        }

        if(!viewBlock.primaryDimension && viewBlock.groupDimension){
            treeMapData.measuresData = assignOnlyGroupDimensionAndMeasureData(blockData,groupDimensionName,y1MeasureName,treeMapColor);
        }

        treeMapData.formatString = formatString;
        treeMapData.reportLink = viewBlock.reportLink;

        return treeMapData;
    }

    function assignHaveTwoDimensionAndMeasureData(blockData,primaryDimensionName,groupDimensionName,y1MeasureName,treeMapColor){
        var measureData = [];
        var primaryDimensionArr = [];

        for(var i = 0; i < blockData.length; i++){
            if(primaryDimensionArr.indexOf(blockData[i][primaryDimensionName]) == -1){
                primaryDimensionArr.push(blockData[i][primaryDimensionName]);
            }
        }

        var primaryDimensionObjArr = [];
        var tempObj = {};
        for(var i = 0; i < primaryDimensionArr.length; i++){
            tempObj = {};
            tempObj.id = "primaryDimension"+i;
            tempObj.name = primaryDimensionArr[i];
            tempObj.color = treeMapColor[(i%treeMapColor.length)];
            primaryDimensionObjArr.push(tempObj);
        }

        var measureArr = [];
        for(var i = 0; i < primaryDimensionObjArr.length; i++){
            for(var j = 0; j < blockData.length; j++){
                if(primaryDimensionObjArr[i].name == blockData[j][primaryDimensionName]){
                    tempObj = {};
                    tempObj.name = blockData[j][groupDimensionName];
                    tempObj.parent = primaryDimensionObjArr[i].id;
                    tempObj.value = blockData[j][y1MeasureName];
                    measureArr.push(tempObj);
                }
            }
        }
        measureData = primaryDimensionObjArr.concat(measureArr);

        return measureData;
    }

    function assignOnlyPrimaryDimensionAndMeasureData(blockData,primaryDimensionName,y1MeasureName,treeMapColor){
        var measureArr = [];
        var tempObj = {};
        for(var i = 0; i < blockData.length; i++){
            tempObj = {};
            tempObj.name = blockData[i][primaryDimensionName];
            tempObj.value = blockData[i][y1MeasureName];
            tempObj.color = treeMapColor[(i%treeMapColor.length)];
            measureArr.push(tempObj);
        }

        return measureArr;
    }

    function assignOnlyGroupDimensionAndMeasureData(blockData,groupDimensionName,y1MeasureName,treeMapColor){
        var measureArr = [];
        var tempObj = {};
        for(var i = 0; i < blockData.length; i++){
            tempObj = {};
            tempObj.name = blockData[i][groupDimensionName];
            tempObj.value = blockData[i][y1MeasureName];
            tempObj.color = treeMapColor[(i%treeMapColor.length)];
            measureArr.push(tempObj);
        }

        return measureArr;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation) {
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if (!(viewBlock.primaryDimension || viewBlock.groupDimension) && !viewBlock.y1Measures.length){return;}

        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0], {
            chart: {
                type: "treemap",
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null,
                plotBorderWidth: null,
                pltShadow: false
            },
            title: {
                text: null
            },
            plotOptions: {
                treemap:{
                    layoutAlgorithm: 'stripes',
                    alternateStartingDirection: true,
                    levels: [{
                        level: 1,
                        layoutAlgorithm: 'sliceAndDice',
                        dataLabels: {
                            enabled: viewBlock.ChartStyle.dataShow,
                            align: 'left',
                            verticalAlign: 'top'
                        }
                    }],
                },
                series:{
                    animation: autoRefreshAnimation,
                    dataLabels: {
                        enabled: viewBlock.ChartStyle.dataShow,
                        formatter: function(){
                            return this.key+(viewBlock.ChartStyle.dataShow?(" : "+$BDA.formatString.number(me.data.formatString,this.point.value)):"");
                        },
                        style: {
                            fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                            fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                            fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                            fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                            textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                        }
                    },
                    states:{
                        hover:{
                            enabled:true
                        },
                        select:{
                            enabled: false
                        }
                    },
                    allowPointSelect:openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)),
                    cursor:(openDrilldown||(typeof openDrilldown=="undefined"&&((this.data.reportLink&&this.data.reportLink.reportID)||(viewBlock.reportLinks&&(viewBlock.reportLinks.count>0))||viewBlock.linkage)))&&'pointer'
                }
            },
            legend:{
                enabled: false
            },
            tooltip: {
                enabled: viewBlock.ChartStyle.dataHoverShow,
                formatter: function(){
                    return this.key +' :  '+$BDA.formatString.number(me.data.formatString,this.point.value);
                },
                style: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.ChartStyle.dataHoverFont?viewBlock.ChartStyle.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont?(viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            series: [{
                data: this.data.measuresData
            }]
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignTreeMapData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    };

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignTreeMapData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----报表容器*/
function ReportContainer(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.containerIndex = 0;

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation,promptFilters){
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        this.setChartContentHeight(fltHeight);
        $(this.chartID).find(".bda-chart-content").html("");
        var screenWidth = $(this.chartID).find(".bda-chart-content").width();
        var screenHeight = fltHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        screenHeight = screenHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        $(this.chartID).find(".bda-chart-content").css("height",screenHeight/(100*$BDA.defaultRatio)+"rem");
        if(viewBlock.reportID){
            var iframe = "<iframe allowTransparency='true' name='reportContainer"+this.containerIndex+"' class='reportContainer"+this.containerIndex+"' src='' frameborder='no' scrolling='auto' width='"+screenWidth+"' height='"+screenHeight+"' allowtransparency='true'></iframe>";
            var str = "<div class='report-container current-container' reportid="+viewBlock.reportID+" style='height: 100%;'>"+iframe+"</div>";
            $(this.chartID).find(".bda-chart-content").html(str);
            var url = ajaxTools.basePath+"/Report/report_front_end/jsp/report.jsp"+"?token="+ajaxTools.authorization+"&reportID="+viewBlock.reportID+"&deviceTypeID="+ajaxTools.deviceTypeID+"&themeID="+$BDA.theme.themeID+"&queryTimeOut="+ajaxTools.queryTimeOut;
            var tempObj = {};
            for(var i = 0; i < viewBlock.reportLinkFilters.length; i++){
                if(viewBlock.reportLinkFilters[i].valueType == 3){
                    tempObj[viewBlock.reportLinkFilters[i].prompt] = null;
                }
                if(viewBlock.reportLinkFilters[i].valueType == 2){
                    tempObj[viewBlock.reportLinkFilters[i].prompt] = viewBlock.reportLinkFilters[i].valueExpression;
                }
                if(viewBlock.reportLinkFilters[i].valueType == 0){
                    for(var j = 0; j < promptFilters.count; j++){
                        if(promptFilters.item(j).prompt == viewBlock.reportLinkFilters[i].valueExpression){
                            tempObj[viewBlock.reportLinkFilters[i].prompt] = promptFilters.item(j).selectedValues;
                        }
                    }
                }
            }
            var parameters = encodeURIComponent(JSON.stringify(tempObj));
            url = url+"&parameters="+parameters;
            $(this.chartID).find(".current-container .reportContainer"+this.containerIndex).attr("src",url);
            this.containerIndex++;
        }
    }

    this.openNewURL = function(url,blockID,isClearIframe){
        if(isClearIframe){
            $(this.chartID).find(".bda-chart-content").html("");
            this.containerIndex = 0;
        }else{
            $(this.chartID).find(".bda-chart-content .report-container").removeClass("current-container");
        }
        var screenWidth = $(this.chartID).find(".bda-chart-content").width();
        var screenHeight = $(this.chartID).find(".bda-chart-content").height();
        var iframe = "<iframe allowTransparency='true' name='reportContainer"+this.containerIndex+"' class='reportContainer"+this.containerIndex+"' src='' frameborder='no' scrolling='auto' width='"+screenWidth+"' height='"+screenHeight+"' allowtransparency='true'></iframe>";
        var str = "<div class='report-container current-container' blockID="+blockID+" style='height: 100%;'>"+iframe+"</div>";
        $(this.chartID).find(".bda-chart-content").append(str);
        $(this.chartID).find(".current-container .reportContainer"+this.containerIndex).attr("src",url);
        this.containerIndex++;
    }

    this.refreshByLinkage=function(fltHeight){
        return;
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation,promptFilters){
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation,promptFilters);
    }
}

/*类----按钮*/
function BDAButton(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation,promptFilters){
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        this.setChartContentHeight(fltHeight);
        var screenHeight = fltHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        screenHeight = screenHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        $(this.chartID).find(".bda-chart-content").css("height",screenHeight/(100*$BDA.defaultRatio)+"rem");
        $(this.chartID).find(".bda-chart-content").css("width","100%").html("").html("<div class='bda-button-content'></div>");
        var str = "";
        if(viewBlock.contentType == 0){
            if(viewBlock.icon){
                str = "<img src='/Report/"+viewBlock.icon.imageURL+"' style='width: "+viewBlock.textBox.font.size/100+"rem; height: "+viewBlock.textBox.font.size/100+"rem;'>";
                if(viewBlock.iconLocation == 0){
                    str = str + "<span style='display: inline-block; margin-left: 0.05rem; vertical-align: middle;'>"+viewBlock.text+"</span>";
                }
                if(viewBlock.iconLocation == 1){
                    str = str + "<br><span style='display: inline-block;'>"+viewBlock.text+"</span>";
                }
                if(viewBlock.iconLocation == 2){
                    str = "<span style='display: inline-block; margin-right: 0.05rem; vertical-align: middle;'>"+viewBlock.text+"</span>"+str;
                }
                if(viewBlock.iconLocation == 3){
                    str = "<span style='display: inline-block;'>"+viewBlock.text+"</span><br>" + str;
                }
            }else{
                str = "<span style='display: inline-block;'>"+viewBlock.text+"</span>";
            }
            $(this.chartID).find(".bda-button-content").html(str);
        }else if(viewBlock.contentType == 1){
            if(viewBlock.image){
                $(this.chartID).find(".bda-button-content").css({
                    'background-image': "url('/Report/"+viewBlock.image.imageURL+"')",
                    'background-position': "center center",
                    'background-repeat': "no-repeat",
                    'background-size': "100% 100%"
                });
            }else if(viewBlock.imageDataObject && viewBlock.imageDataObject[3] == 4 && viewBlock.blockDataToDraw.length){
                var str = "<img src='data:image/png;base64,"+viewBlock.blockDataToDraw[0][viewBlock.imageDataObject[0]+"___"+viewBlock.imageDataObject[1]]+"' width='100%' height='100%'>";
                $(this.chartID).find(".bda-button-content").html(str);
            }
        }
        var contentWidth = $(this.chartID).find('.bda-chart-content').width();
        var borderWidth = String(viewBlock.borderWidth).indexOf(",") != -1 ? viewBlock.borderWidth.split(","):[viewBlock.borderWidth,viewBlock.borderWidth,viewBlock.borderWidth,viewBlock.borderWidth];
        var borderColor = String(viewBlock.borderColor).indexOf(",") != -1 ? viewBlock.borderColor.split(","):[viewBlock.borderColor,viewBlock.borderColor,viewBlock.borderColor,viewBlock.borderColor];
        $(this.chartID).find(".bda-button-content").css({
            'width': contentWidth + "px",
            'height': screenHeight/(100*$BDA.defaultRatio)+"rem",
            'display': 'table-cell',
            'border-top-width': borderWidth[0]+"px",
            'border-right-width': borderWidth[1]+"px",
            'border-bottom-width': borderWidth[2]+"px",
            'border-left-width': borderWidth[3]+"px",
            'border-top-color': $BDA.csharp2rgba(borderColor[0]),
            'border-right-color': $BDA.csharp2rgba(borderColor[1]),
            'border-bottom-color': $BDA.csharp2rgba(borderColor[2]),
            'border-left-color': $BDA.csharp2rgba(borderColor[3]),
            'border-style': 'solid',
            // 'border-radius': viewBlock.textBox.borderRadius.replace(/\,/g,'px ') + 'px',
            'background-color': $BDA.csharp2rgba(viewBlock.textBox.backgroundColor),
            'text-align': viewBlock.textBox.textAlign=='0'?'left':(viewBlock.textBox.textAlign=='1'?'center':'right'),
            'color': $BDA.csharp2rgba(viewBlock.textBox.color),
            'font-family': viewBlock.textBox.font.fontFamily,
            'font-size': viewBlock.textBox.font.size/100+"rem",
            'font-style': viewBlock.textBox.font.italic?'italic':'normal',
            'font-weight': viewBlock.textBox.font.bold?'bold':'normal',
            'text-decoration': viewBlock.textBox.font.underline?'underline':
                (viewBlock.textBox.font.strikeout?'line-through':'none'),
            'vertical-align': viewBlock.textBox.verticalAlign=='0'?'top':(viewBlock.textBox.verticalAlign=='1'?'middle':'bottom')
        });
        // $(this.chartID).find(".bda-bgcolor").css({
        //     'border-radius': viewBlock.textBox.borderRadius.replace(/\,/g,'px ') + 'px'
        // });
        $(this.chartID).attr("groupname","group_"+viewBlock.groupName);
        var selectBorderWidth = String(viewBlock.selectedBorderWidth).indexOf(",") != -1 ? viewBlock.selectedBorderWidth.split(","):[viewBlock.selectedBorderWidth,viewBlock.selectedBorderWidth,viewBlock.selectedBorderWidth,viewBlock.selectedBorderWidth];
        var selectBorderColor = String(viewBlock.selectedBorderColor).indexOf(",") != -1 ? viewBlock.selectedBorderColor.split(","):[viewBlock.selectedBorderColor,viewBlock.selectedBorderColor,viewBlock.selectedBorderColor,viewBlock.selectedBorderColor];
        if(viewBlock.defaultSelected){
            $(this.chartID).attr("defaultSelected","true").find(".bda-button-content").css({
                'border-top-width': selectBorderWidth[0]+"px",
                'border-right-width': selectBorderWidth[1]+"px",
                'border-bottom-width': selectBorderWidth[2]+"px",
                'border-left-width': selectBorderWidth[3]+"px",
                'border-top-color': $BDA.csharp2rgba(selectBorderColor[0]),
                'border-right-color': $BDA.csharp2rgba(selectBorderColor[1]),
                'border-bottom-color': $BDA.csharp2rgba(selectBorderColor[2]),
                'border-left-color': $BDA.csharp2rgba(selectBorderColor[3]),
                'border-style': 'solid',
                // 'border-radius': viewBlock.textBox.borderRadius.replace(/\,/g,'px ') + 'px',
                'background-color': $BDA.csharp2rgba(viewBlock.selectedTextBox.backgroundColor),
                'text-align': viewBlock.selectedTextBox.textAlign=='0'?'left':(viewBlock.selectedTextBox.textAlign=='1'?'center':'right'),
                'color': $BDA.csharp2rgba(viewBlock.selectedTextBox.color),
                'font-family': viewBlock.selectedTextBox.font.fontFamily,
                'font-size': viewBlock.selectedTextBox.font.size/100+"rem",
                'font-style': viewBlock.selectedTextBox.font.italic?'italic':'normal',
                'font-weight': viewBlock.selectedTextBox.font.bold?'bold':'normal',
                'text-decoration': viewBlock.selectedTextBox.font.underline?'underline':
                    (viewBlock.selectedTextBox.font.strikeout?'line-through':'none'),
                'vertical-align': viewBlock.selectedTextBox.verticalAlign=='0'?'top':(viewBlock.selectedTextBox.verticalAlign=='1'?'middle':'bottom')
            });
            if(viewBlock.selectedImage){
                $(this.chartID).attr("defaultSelected","true").find(".bda-button-content").css({
                   "background-image": "url('/Report/"+viewBlock.selectedImage.imageURL+"')",
                   "background-repeat": 'no-repeat',
                   "background-position": 'center top',
                   "background-size": '100% 100%',
                });
            }

            // $(this.chartID).find(".bda-bgcolor").css({
            //     'border-radius': viewBlock.textBox.borderRadius.replace(/\,/g,'px ') + 'px'
            // });
        }
        if(viewBlock.carousel){
            $(this.chartID).attr("carousel","true");
        }
        $(this.chartID).attr("selectedIndex",viewBlock.selectedIndex);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----图片框*/
function PictureBox(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.draw = function(fltHeight, openDrilldown){
        $(this.chartID).find('h3').css('display','none');
        $(this.chartID).find('.bda-chart-box').css('padding',0);
        this.setChartContentHeight(fltHeight);

        $(this.chartID).find('.bda-picture-content').remove();
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-picture-content" id="'+viewBlock.blockID+'"></div>');
        var contentWidth = $(this.chartID).find('.bda-chart-box').width();
        var contentHeight = fltHeight - parseFloat($(this.chartID).css("padding-top")) - parseFloat($(this.chartID).css("padding-bottom"));
        contentHeight = contentHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        $(this.chartID).find('.bda-chart-content').css('height',contentHeight/(100*$BDA.defaultRatio)+"rem");
        $(me.chartID).find('.bda-picture-content').css({
            'width': contentWidth+"px",
            'height': contentHeight/(100*$BDA.defaultRatio)+"rem",
            'text-align': 'center',
            'vertical-align': 'middle',
            'display': 'table-cell'
        });
        if(viewBlock.images.length == 1 || viewBlock.dataObject){
            var min = Math.min(contentHeight,contentWidth);
            var str = "";
            if(viewBlock.dataObject && viewBlock.dataObject[3] == 4 && viewBlock.blockDataToDraw.length){
                if(viewBlock.showCircleImage){
                    str = "<img src='data:image/png;base64,"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"' width='"+min+"' height='"+min+"' style='border-radius: 50%'>";
                }else{
                    // var str = "<img src='data:image/png;base64,"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"' width='100%' height='100%' style='border-radius: "+viewBlock.imageRadius.replace(/\,/g,'px ') + "px'>";
                    $(me.chartID).find('.bda-picture-content').css({
                        "background-image": "url(data:image/png;base64,"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+")",
                        "background-repeat": "no-repeat",
                        "background-position": "center center",
                        "background-size": viewBlock.tileMode?(viewBlock.tileMode == 1?"auto":"contain"):"100% 100%",
                        "border-radius": (viewBlock.imageRadius?viewBlock.imageRadius.replace(/\,/g,'px '):0)+"px"
                    });
                }
            }else if(viewBlock.dataObject && viewBlock.dataObject[3] == 3 && viewBlock.blockDataToDraw.length){
                if(viewBlock.showCircleImage){
                    if(viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]].indexOf("http://") != -1 || viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]].indexOf("https://") != -1){
                        str = "<img src='"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"' width='"+min+"' height='"+min+"' style='border-radius: 50%'>";
                    }else{
                        str = "<img src='/Report/resource/report/custom/img/"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"' width='"+min+"' height='"+min+"' style='border-radius: 50%'>";
                    }
                }else{
                    if(viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]].indexOf("http://") != -1 || viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]].indexOf("https://") != -1){
                        // var str = "<img src='"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"' width='100%' height='100%' style='border-radius: "+viewBlock.imageRadius.replace(/\,/g,'px ') + "px'>";
                        $(me.chartID).find('.bda-picture-content').css({
                            "background-image": "url('"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"')",
                            "background-repeat": "no-repeat",
                            "background-position": "center center",
                            "background-size": viewBlock.tileMode?(viewBlock.tileMode == 1?"auto":"contain"):"100% 100%",
                            "border-radius": (viewBlock.imageRadius?viewBlock.imageRadius.replace(/\,/g,'px '):0)+"px"
                        });
                    }else{
                        // var str = "<img src='/Report/resource/report/custom/img/"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"' width='100%' height='100%' style='border-radius: "+viewBlock.imageRadius.replace(/\,/g,'px ') + "px'>";
                        $(me.chartID).find('.bda-picture-content').css({
                            "background-image": "url('/Report/resource/report/custom/img/"+viewBlock.blockDataToDraw[0][viewBlock.dataObject[0]+"___"+viewBlock.dataObject[1]]+"')",
                            "background-repeat": "no-repeat",
                            "background-position": "center center",
                            "background-size": viewBlock.tileMode?(viewBlock.tileMode == 1?"auto":"contain"):"100% 100%",
                            "border-radius": (viewBlock.imageRadius?viewBlock.imageRadius.replace(/\,/g,'px '):0)+"px"
                        });
                    }
                }
            }else{
                if(viewBlock.images.length > 0){
                    if(viewBlock.showCircleImage){
                        str = "<img src='/Report/"+viewBlock.images[0].imageURL+"' width='"+min+"' height='"+min+"' style='border-radius: 50%'>";
                    }else{
                        // var str = "<img src='/Report/"+viewBlock.images[0].imageURL+"' width='100%' height='100%' style='border-radius: "+(viewBlock.imageRadius?viewBlock.imageRadius.replace(/\,/g,'px '):0)+ "px'>";
                        $(me.chartID).find('.bda-picture-content').css({
                            "background-image": "url('/Report/"+viewBlock.images[0].imageURL+"')",
                            "background-repeat": "no-repeat",
                            "background-position": "center center",
                            "background-size": viewBlock.tileMode?(viewBlock.tileMode == 1?"auto":"contain"):"100% 100%",
                            "border-radius": (viewBlock.imageRadius?viewBlock.imageRadius.replace(/\,/g,'px '):0)+"px"
                        });
                    }
                }
            }
            $(me.chartID).find('.bda-picture-content').html(str);
        }
        if(viewBlock.reportLink || (viewBlock.reportLinks && viewBlock.reportLinks.count > 0)){
            $(this.chartID).find('.bda-chart-content').hover(function(){
                $(this).css('cursor','pointer');
            });
        }
    }

    this.refreshByLinkage=function(){
        return;
    }

    this.autoRefresh=function(fltHeight, openDrilldown){
        this.draw(fltHeight, openDrilldown);
    }
}

/*类----简单条形图*/
function SimpleBarChart(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.echartSelectName = null;
    this.reportLinkData = null;
    this.data = assignSimpleBarChart();

    function assignSimpleBarChart(){
        if(viewBlock.blockDataToDraw.length == 0){ return;}

        var simpleBarChart = {};
        var dimensionName = viewBlock.primaryDimension?(viewBlock.primaryDimension[0]+"___"+viewBlock.primaryDimension[1]):"";
        var measureName = viewBlock.y1Measures.length?(viewBlock.y1Measures[0][0]+"___"+viewBlock.y1Measures[0][1]):"";
        var dimensions = [];
        for(var i = 0; i < viewBlock.blockDataToDraw.length; i++){
            if($.inArray(viewBlock.blockDataToDraw[i][dimensionName],dimensions) == -1){
                dimensions.push(viewBlock.blockDataToDraw[i][dimensionName]);
            }
        }
        simpleBarChart.dimensions = dimensions;

        var measures = [];
        for(var i = 0; i < dimensions.length; i++){
            for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
                if(dimensions[i] == viewBlock.blockDataToDraw[j][dimensionName]){
                    measures.push(viewBlock.blockDataToDraw[j][measureName]);
                    break;
                }
            }
        }
        simpleBarChart.measures = measures;
        simpleBarChart.formatString = viewBlock.y1DataFormat;

        return simpleBarChart;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-content").html("");
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-map-content"></div>');
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var mapChart = echarts.init($(this.chartID).find('.bda-map-content')[0]);
        mapChart.setOption({
            grid: {
                left: '2%',
                right: '10%',
                bottom: '0',
                top: '0',
                containLabel: true
            },
            xAxis: [{
                show: false,
            },{
                show: false,
            }],
            yAxis: {
                type: 'category',
                inverse: true,
                show: false
            },
            tooltip: {
                show: viewBlock.ChartStyle.dataHoverShow,
                trigger: 'item', 
                formatter: function(data) {
                    return me.data.dimensions[data.dataIndex] + ": " +$BDA.formatString.number(me.data.formatString,me.data.measures[data.dataIndex]);
                },
                textStyle: {
                    fontFamily: viewBlock.ChartStyle.dataHoverFont.fontFamily,
                    fontSize: viewBlock.ChartStyle.dataHoverFont.size * $BDA.defaultRatio,
                    fontWeight: viewBlock.ChartStyle.dataHoverFont.bold?'bold':'100',
                    fontStyle: viewBlock.ChartStyle.dataHoverFont.italic?'italic':'normal',
                    textDecoration: viewBlock.ChartStyle.dataHoverFont.underline?'underline':(viewBlock.ChartStyle.dataHoverFont.strikeout?'line-through':'none')
                },
                confine: true
            },
            series: [
                {
                    show: true,
                    type: 'bar',
                    barGap: '-100%',
                    barWidth: viewBlock.ChartStyle.barWidth * $BDA.defaultRatio,
                    z: 2,
                    itemStyle: {
                        normal: {
                            barBorderRadius: viewBlock.ChartStyle.barWidth * $BDA.defaultRatio,
                            color: function(params){
                                if(viewBlock.ChartStyle.colorByPoint){
                                    if(params.value < 0 && viewBlock.ChartStyle.negativeColor){
                                        return $BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor);
                                    }else{
                                        return $BDA.csharp2rgba(viewBlock.ChartStyle.colorSequence[params.dataIndex % viewBlock.ChartStyle.colorSequence.length]);
                                    }
                                }else{
                                    if(params.value < 0 && viewBlock.ChartStyle.negativeColor){
                                        return $BDA.csharp2rgba(viewBlock.ChartStyle.negativeColor);
                                    }else{
                                        return $BDA.csharp2rgba(viewBlock.ChartStyle.colorSequence[0]);
                                    }
                                }
                            }
                        }
                    },
                    label: {
                        normal: {
                            show: viewBlock.ChartStyle.dataShow,
                            textStyle: {
                                color: $BDA.csharp2rgba(viewBlock.ChartStyle.dataColor),
                                fontFamily: viewBlock.ChartStyle.dataFont.fontFamily,
                                fontSize: viewBlock.ChartStyle.dataFont.size*$BDA.defaultRatio,
                                fontWeight: viewBlock.ChartStyle.dataFont.bold?'bold':'100',
                                fontStyle: viewBlock.ChartStyle.dataFont.italic?'italic':'normal',
                                textDecoration: viewBlock.ChartStyle.dataFont.underline?'underline':(viewBlock.ChartStyle.dataFont.strikeout?'line-through':'none')
                            },
                            position: 'right',
                            formatter: function(data) {
                                return $BDA.formatString.number(me.data.formatString,me.data.measures[data.dataIndex]);
                            }
                        }
                    },
                    data: me.data.measures,
                },
                {
                    show: true,
                    type: 'bar',
                    barGap: '-100%',
                    barWidth: viewBlock.ChartStyle.barWidth * $BDA.defaultRatio,
                    xAxisIndex: 1, //代表使用第二个X轴刻度
                    itemStyle: {
                        normal: {
                            color: 'transparent'
                        }
                    },
                    label: {
                        normal: {
                            show: viewBlock.ChartStyle.axisLabelShow,
                            position: [0,-(viewBlock.ChartStyle.axisLabelFont.size)*$BDA.defaultRatio*1.18],
                            //position: [0,0],
                            textStyle: {
                                color: $BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor),
                                fontFamily: (viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily,
                                fontSize: viewBlock.ChartStyle.scaleFont.size*$BDA.defaultRatio,
                                fontWeight: viewBlock.ChartStyle.scaleFont.bold?'bold':'100',
                                fontStyle: viewBlock.ChartStyle.scaleFont.italic?'italic':'normal',
                                textDecoration: viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')
                            },
                            formatter: function(data) {
                                return me.data.dimensions[data.dataIndex];
                            }
                        }
                    },
                    data: me.data.measures
                }
            ]
        });

        if ((typeof openDrilldown == "undefined") && !(this.data.reportLink && this.data.reportLink.reportID) && !(viewBlock.reportLinks && viewBlock.reportLinks.count > 0) && !viewBlock.linkage || openDrilldown == false) {
            $(this.chartID).find('.bda-chart-content .bda-map-content canvas').css("cursor", "default");
        }

        mapChart.on('click', function (params) {
            me.echartSelectName = me.data.dimensions[params.dataIndex];
            for(var i = 0; i < viewBlock.blockDataToDraw.length; i++){
                for(var key in viewBlock.blockDataToDraw[i]){
                    if(viewBlock.blockDataToDraw[i][key] == me.data.dimensions[params.dataIndex]){
                        me.reportLinkData = viewBlock.blockDataToDraw[i];
                        return;
                    }
                }
            }
        });
    }

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignSimpleBarChart();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignSimpleBarChart();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----设备实时状态图*/
function EquipmentRealTimeStatusChart(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignEquipmentRealTimeStatusChart();
    var timerObj = {};

    function assignEquipmentRealTimeStatusChart(){
        if (viewBlock.blockDataToDraw.length == 0){return;}
        var equipmentStatusChart = {};
        var titleText = viewBlock.blockDataToDraw[0][viewBlock.equipmentDimension[0]+'___'+viewBlock.equipmentDimension[1]];
        var dataList = [];
        for(var i = 0; i < viewBlock.measures.length; i++){
            var obj = {};
            obj.name = viewBlock.measures[i][1];
            obj.value = viewBlock.blockDataToDraw[0][viewBlock.measures[i][0]+'___'+viewBlock.measures[i][1]];
            dataList.push(obj);
        }
        var statusValue = viewBlock.blockDataToDraw[0][viewBlock.statusDimension[0]+'___'+viewBlock.statusDimension[1]];

        var boxStyle = {};
        var iconName = '';
        if(!isNaN(statusValue)){
            statusValue = Number(statusValue);
        }
        if(statusValue == viewBlock.runningStyle.statusDimensionValue){
            boxStyle.borderColor = viewBlock.runningStyle.borderColor;
            boxStyle.equipmentNameColor = viewBlock.runningStyle.equipmentNameColor;
            boxStyle.flashing = viewBlock.runningStyle.flashing;
            iconName = 'yunxingzhong';
        }else if(statusValue == viewBlock.idleStyle.statusDimensionValue){
            boxStyle.borderColor = viewBlock.idleStyle.borderColor;
            boxStyle.equipmentNameColor = viewBlock.idleStyle.equipmentNameColor;
            boxStyle.flashing = viewBlock.idleStyle.flashing;
            iconName = 'kongxian';
        }else if(statusValue == viewBlock.warningStyle.statusDimensionValue){
            boxStyle.borderColor = viewBlock.warningStyle.borderColor;
            boxStyle.equipmentNameColor = viewBlock.warningStyle.equipmentNameColor;
            boxStyle.flashing = viewBlock.warningStyle.flashing;
            iconName = 'baojing';
        }else if(statusValue == viewBlock.breakdownStyle.statusDimensionValue){
            boxStyle.borderColor = viewBlock.breakdownStyle.borderColor;
            boxStyle.equipmentNameColor = viewBlock.breakdownStyle.equipmentNameColor;
            boxStyle.flashing = viewBlock.breakdownStyle.flashing;
            iconName = 'guzhang';
        }

        equipmentStatusChart.titleText = titleText;
        equipmentStatusChart.dataList = dataList;
        equipmentStatusChart.boxStyle = boxStyle;
        equipmentStatusChart.iconName = iconName;

        return equipmentStatusChart;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        $(this.chartID).find(".bda-chart-content").html("");
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-equipment-content"></div>');
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw.length == 0){return;}
        $(this.chartID).find("h3 span").text(this.data.titleText);
        var listBox = document.createElement('ul');
        for(var i = 0; i < this.data.dataList.length; i++){
            var li = document.createElement('li');
            for(var key in this.data.dataList[i]){
                var span = document.createElement('span');
                span.className = key+'';
                span.innerHTML = this.data.dataList[i][key];
                if(key == 'name'){
                    $(span).css({
                        "display": 'inline-block',
                        "height": viewBlock.labelTextBox.height/100+'rem',
                        "line-height": viewBlock.labelTextBox.height/100+'rem',
                        "padding": '0 0.1rem',
                        "overflow": 'hidden',
                        "white-space": 'nowrap',
                        "text-overflow": 'ellipsis',
                        "color": $BDA.csharp2rgba(viewBlock.labelTextBox.color),
                        "textAlign": viewBlock.labelTextBox.textAlign=='0'?'left':(viewBlock.labelTextBox.textAlign=='1'?'center':'right'),
                        "verticalAlign": viewBlock.labelTextBox.verticalAlign=='0'?'top':(viewBlock.labelTextBox.verticalAlign=='1'?'middle':'bottom'),
                        "font-family": viewBlock.labelTextBox.fontFamily,
                        'font-size': viewBlock.labelTextBox.font.size/100+"rem",
                        'font-style': viewBlock.labelTextBox.font.italic?'italic':'normal',
                        'font-weight': viewBlock.labelTextBox.font.bold?'bold':'normal',
                        'text-decoration': viewBlock.labelTextBox.font.underline?'underline':
                            (viewBlock.labelTextBox.font.strikeout?'line-through':'none')
                    });
                }else{
                    $(span).css({
                        "display": 'inline-block',
                        "height": viewBlock.valueTextBox.height/100+'rem',
                        "line-height": viewBlock.valueTextBox.height/100+'rem',
                        "padding": '0 0.1rem',
                        "overflow": 'hidden',
                        "white-space": 'nowrap',
                        "text-overflow": 'ellipsis',
                        "color": $BDA.csharp2rgba(viewBlock.valueTextBox.color),
                        "textAlign": viewBlock.valueTextBox.textAlign=='0'?'left':(viewBlock.valueTextBox.textAlign=='1'?'center':'right'),
                        "verticalAlign": viewBlock.valueTextBox.verticalAlign=='0'?'top':(viewBlock.valueTextBox.verticalAlign=='1'?'middle':'bottom'),
                        "font-family": viewBlock.valueTextBox.fontFamily,
                        'font-size': viewBlock.valueTextBox.font.size/100+"rem",
                        'font-style': viewBlock.valueTextBox.font.italic?'italic':'normal',
                        'font-weight': viewBlock.valueTextBox.font.bold?'bold':'normal',
                        'text-decoration': viewBlock.valueTextBox.font.underline?'underline':
                            (viewBlock.valueTextBox.font.strikeout?'line-through':'none')
                    });
                }
                li.appendChild(span);
            }
            listBox.appendChild(li);
        }
        $(this.chartID).find('.bda-equipment-content').append(listBox);

        var iconStr = '<span class="equipment-icon"><i class="iconfont icont-'+this.data.iconName+'"></i></span>';
        $(this.chartID).find(".bda-bgcolor").append(iconStr);
        $(this.chartID).find(".equipment-icon").css('color',ajaxTools.deviceTypeID<2?($BDA.theme.currentBackgroundColor?"#d2d2d2":"#333"):($BDA.theme.currentBackgroundColor?(viewBlock.customColorApplyOtherThemes?$BDA.csharp2rgba(viewBlock.titleTextBox.color):'#d2d2d2'):$BDA.csharp2rgba(viewBlock.titleTextBox.color)));
        
        var borderWidth = String(viewBlock.borderWidth).indexOf(",") != -1 ? viewBlock.borderWidth.split(","):[viewBlock.borderWidth,viewBlock.borderWidth,viewBlock.borderWidth,viewBlock.borderWidth];
        var borderColor = String(viewBlock.borderColor).indexOf(",") != -1 ? viewBlock.borderColor.split(","):[viewBlock.borderColor,viewBlock.borderColor,viewBlock.borderColor,viewBlock.borderColor];
        $(this.chartID).find(".bda-bgcolor").css({
            "border-radius": viewBlock.borderRadius.replace(/\,/g,'px ') + 'px',
            'border-top-width': borderWidth[0]+"px",
            'border-right-width': borderWidth[1]+"px",
            'border-bottom-width': borderWidth[2]+"px",
            'border-left-width': borderWidth[3]+"px",
            'border-top-color': $BDA.csharp2rgba(borderColor[0]),
            'border-right-color': $BDA.csharp2rgba(borderColor[1]),
            'border-bottom-color': $BDA.csharp2rgba(borderColor[2]),
            'border-left-color': $BDA.csharp2rgba(borderColor[3]),
            "border-style": 'solid'
        });

        var boxWidth = $(this.chartID).find('.bda-chart-content')[0].getBoundingClientRect().width - (Number(borderWidth[1])+Number(borderWidth[3]));
        var nameMaxWidth = 0, valueMaxWidth = 0;
        $(this.chartID).find(".bda-equipment-content li").each(function(){
            if(parseInt($(this).find('.name').width()) > nameMaxWidth){
                nameMaxWidth = parseInt($(this).find('.name').width());
            }
            if(parseInt($(this).find('.value').width()) > valueMaxWidth){
                valueMaxWidth = parseInt($(this).find('.value').width());
            }
        });
        var averageWidth = 0;
        if(boxWidth >= (nameMaxWidth + valueMaxWidth)){
            averageWidth = parseInt((parseInt(boxWidth) - parseInt((nameMaxWidth + valueMaxWidth)))/2);
            nameMaxWidth += averageWidth;
            valueMaxWidth += averageWidth;
        }else{
            averageWidth = (nameMaxWidth + valueMaxWidth) - boxWidth;
            nameMaxWidth = parseInt(nameMaxWidth - averageWidth);
        }
        $(this.chartID).find(".bda-equipment-content li span.name").css("width",nameMaxWidth);
        $(this.chartID).find(".bda-equipment-content li span.value").css("width",valueMaxWidth);
        $(this.chartID).find(".equipment-icon").css({
            'top': '0.05rem',
            'right': '0.05rem'
        }).find("i").css("font-size",0.3+'rem');

        clearInterval(timerObj[viewBlock.blockID]);
        timerObj[viewBlock.blockID] = null;
        timerObj.time = 1;
        if(me.data.boxStyle.equipmentNameColor){
            $(me.chartID).find("h3").css('color',$BDA.csharp2rgba(me.data.boxStyle.equipmentNameColor));
            $(me.chartID).find(".equipment-icon").css('color',$BDA.csharp2rgba(me.data.boxStyle.equipmentNameColor));
        }
        if(this.data.boxStyle.flashing){
            timerObj[viewBlock.blockID] = setInterval(function(){
                if($(me.chartID).find(".bda-bgcolor").hasClass("current-equipment")){
                    var borderColor = String(viewBlock.borderColor).indexOf(",") != -1 ? viewBlock.borderColor.split(","):[viewBlock.borderColor,viewBlock.borderColor,viewBlock.borderColor,viewBlock.borderColor];
                    $(me.chartID).find(".bda-bgcolor").removeClass("current-equipment").css({
                        'border-top-color': $BDA.csharp2rgba(borderColor[0]),
                        'border-right-color': $BDA.csharp2rgba(borderColor[1]),
                        'border-bottom-color': $BDA.csharp2rgba(borderColor[2]),
                        'border-left-color': $BDA.csharp2rgba(borderColor[3])
                    });
                }else{
                    $(me.chartID).find(".bda-bgcolor").addClass("current-equipment").css({
                        'border-top-color': $BDA.csharp2rgba(me.data.boxStyle.borderColor),
                        'border-right-color': $BDA.csharp2rgba(me.data.boxStyle.borderColor),
                        'border-bottom-color': $BDA.csharp2rgba(me.data.boxStyle.borderColor),
                        'border-left-color': $BDA.csharp2rgba(me.data.boxStyle.borderColor)
                    });
                }
            },timerObj.time*1000);
        }

    }

    this.refreshByLinkage=function(fltHeight){
        return;
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignEquipmentRealTimeStatusChart();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----简单甘特图*/
function SimpleGanttChart(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.highchart = null;
    this.data = assignSimpleGanttChart();

    function assignSimpleGanttChart(){
        if(!viewBlock.jobDimension || !viewBlock.startDate || !viewBlock.endDate || viewBlock.blockDataToDraw.length == 0){return;}
        var simpleGanttChart = {};
        var yCategories = [];
        for(var i = 0; i < viewBlock.blockDataToDraw.length; i++){
            if(yCategories.indexOf(viewBlock.blockDataToDraw[i][viewBlock.jobDimension[0]+'___'+viewBlock.jobDimension[1]]) == -1){
                yCategories.push(viewBlock.blockDataToDraw[i][viewBlock.jobDimension[0]+'___'+viewBlock.jobDimension[1]]);
            }
        }

        var dataList = [];
        var pointStartDate = 0;
        for(var i = 0; i < yCategories.length; i++){
            for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
                if(viewBlock.blockDataToDraw[j][viewBlock.jobDimension[0]+'___'+viewBlock.jobDimension[1]] == yCategories[i]){
                    var obj = {};
                    if(!pointStartDate || viewBlock.blockDataToDraw[j][viewBlock.startDate[0]+'___'+viewBlock.startDate[1]] < pointStartDate){
                        pointStartDate = viewBlock.blockDataToDraw[j][viewBlock.startDate[0]+'___'+viewBlock.startDate[1]];
                    }
                    var startDate = new Date(viewBlock.blockDataToDraw[j][viewBlock.startDate[0]+'___'+viewBlock.startDate[1]]);
                    var endDate = new Date(viewBlock.blockDataToDraw[j][viewBlock.endDate[0]+'___'+viewBlock.endDate[1]]);
                    obj.x = Date.UTC(startDate.getFullYear(), startDate.getMonth(), startDate.getDate());
                    obj.x2 = Date.UTC(endDate.getFullYear(), endDate.getMonth(), endDate.getDate());
                    obj.y = i;
                    if(viewBlock.completeness){
                        var partialFill = viewBlock.blockDataToDraw[j][viewBlock.completeness[0]+'___'+viewBlock.completeness[1]];
                        obj.partialFill = partialFill;
                    }
                    if(viewBlock.statusDimension){
                        if(!isNaN(viewBlock.blockDataToDraw[j][viewBlock.statusDimension[0]+'___'+viewBlock.statusDimension[1]])){
                            if(Number(viewBlock.blockDataToDraw[j][viewBlock.statusDimension[0]+'___'+viewBlock.statusDimension[1]]) == viewBlock.delayedDimensionValue){
                                obj.color = $BDA.csharp2rgba(viewBlock.delayedColor);
                            }
                            if(Number(viewBlock.blockDataToDraw[j][viewBlock.statusDimension[0]+'___'+viewBlock.statusDimension[1]]) == viewBlock.ontimeDimensionValue){
                                obj.color = $BDA.csharp2rgba(viewBlock.ontimeColor);
                            }
                        }else{
                            if(viewBlock.blockDataToDraw[j][viewBlock.statusDimension[0]+'___'+viewBlock.statusDimension[1]] == viewBlock.delayedDimensionValue){
                                obj.color = $BDA.csharp2rgba(viewBlock.delayedColor);
                            }
                            if(viewBlock.blockDataToDraw[j][viewBlock.statusDimension[0]+'___'+viewBlock.statusDimension[1]] == viewBlock.ontimeDimensionValue){
                                obj.color = $BDA.csharp2rgba(viewBlock.ontimeColor);
                            }
                        }
                    }
                    dataList.push(obj);
                }
            }
        }
        simpleGanttChart.yCategories = yCategories;
        simpleGanttChart.dataList = dataList;
        simpleGanttChart.pointStartDate = new Date(pointStartDate);

        return simpleGanttChart;
    }

    this.draw = function(fltHeight){
        $(this.chartID).find(".bda-chart-content").html("");
        this.setChartContentHeight(fltHeight);

        if(!viewBlock.jobDimension || !viewBlock.startDate || !viewBlock.endDate || viewBlock.blockDataToDraw.length == 0){return;}
        this.highchart = Highcharts.chart($(this.chartID).find(".bda-chart-content")[0], {
            chart: {
                type: 'xrange',
                backgroundColor: 'rgba(0,0,0,0)',
                plotBackgroundColor: null
            },
            title: {
                text: null
            },
            xAxis: {
                type: 'datetime',
                title: {
                    text: null
                },
                labels:{
                    style:{
                        fontFamily: viewBlock.scaleFont?((viewBlock.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.scaleFont?viewBlock.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.scaleFont?(viewBlock.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.scaleFont?(viewBlock.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.scaleFont?(viewBlock.scaleFont.underline?'underline':(viewBlock.scaleFont.strikeout?'line-through':'none')):'none',
                        color: viewBlock.scaleColor?$BDA.csharp2rgba(viewBlock.scaleColor):"#666"
                    },
                    formatter: function(){
                        return $BDA.ganttDateFormat(viewBlock.scaleFormat,new Date(this.value));
                    }
                },
                maxPadding: 0,
                lineWidth: (viewBlock.xScaleLineWidth || viewBlock.xScaleLineWidth==0)?viewBlock.xScaleLineWidth*$BDA.defaultRatio:1*$BDA.defaultRatio,
                gridLineWidth: viewBlock.showGridLine?1*$BDA.defaultRatio:0,
                tickWidth: viewBlock.showTick?1*$BDA.defaultRatio:0,
                minTickInterval: 24*3600*1000,
                tickPixelInterval: 50
            },
            yAxis: {
                title: {
                    text: null
                },
                labels:{
                    enabled: true,
                    style:{
                        fontFamily: viewBlock.scaleFont?((viewBlock.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.scaleFont.fontFamily):'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.scaleFont?viewBlock.scaleFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.scaleFont?(viewBlock.scaleFont.bold?'bold':'100'):'100',
                        fontStyle: viewBlock.scaleFont?(viewBlock.scaleFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.scaleFont?(viewBlock.scaleFont.underline?'underline':(viewBlock.scaleFont.strikeout?'line-through':'none')):'none',
                        color: viewBlock.scaleColor?$BDA.csharp2rgba(viewBlock.scaleColor):"#666"
                    }
                },
                lineWidth: viewBlock.y1ScaleLineWidth?viewBlock.y1ScaleLineWidth*$BDA.defaultRatio:0,
                gridLineWidth: 0,
                tickWidth: viewBlock.showTick?1*$BDA.defaultRatio:0,
                categories: this.data.yCategories,
                reversed: true
            },
            tooltip: {
                enabled: viewBlock.dataHoverShow,
                formatter:function(){
                    return this.yCategory + '<br>'+ $BDA.formatString.date('YYYY/MM/dd',new Date(this.x))+' - '+$BDA.formatString.date('YYYY/MM/dd',new Date(this.x2));
                },
                style: {
                    fontFamily: viewBlock.dataHoverFont?viewBlock.dataHoverFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.dataHoverFont?viewBlock.dataHoverFont.size/100+'rem':'0.11rem',
                    fontWeight: viewBlock.dataHoverFont?(viewBlock.dataHoverFont.bold?'bold':'100'):'100',
                    fontStyle: viewBlock.dataHoverFont?(viewBlock.dataHoverFont.italic?'italic':'normal'):'normal',
                    textDecoration: viewBlock.dataHoverFont?(viewBlock.dataHoverFont.underline?'underline':(viewBlock.dataHoverFont.strikeout?'line-through':'none')):'none'
                }
            },
            legend:{
                enabled: false
            },
            series: [{
                borderColor: "",
                pointWidth: viewBlock.barWidth*$BDA.defaultRatio,
                data: this.data.dataList,
                dataLabels: {
                    enabled: true,
                    style: {
                        fontFamily: viewBlock.dataFont?viewBlock.dataFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                        fontSize: viewBlock.dataFont?viewBlock.dataFont.size/100+'rem':'0.11rem',
                        fontWeight: viewBlock.dataFont?(viewBlock.dataFont.bold?'bold':'100'):'bold',
                        fontStyle: viewBlock.dataFont?(viewBlock.dataFont.italic?'italic':'normal'):'normal',
                        textDecoration: viewBlock.dataFont?(viewBlock.dataFont.underline?'underline':(viewBlock.dataFont.strikeout?'line-through':'none')):'none'
                    }
                }
            }]
        });
    };

    this.refreshByLinkage=function(fltHeight){
        return;
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignSimpleGanttChart();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----象形条形图*/
function PictorialBar(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.echartSelectName = null;
    this.reportLinkData = null;
    this.data = assignPictorialBar();

    function assignPictorialBar(){
        if (viewBlock.blockDataToDraw.length == 0){return;}
        var pictorialBar = {};
        var categories = [];
        for(var i = 0; i < viewBlock.blockDataToDraw.length; i++){
            if(categories.indexOf(viewBlock.blockDataToDraw[i][viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]]) == -1){
                categories.push(viewBlock.blockDataToDraw[i][viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]]);
            }
        }
        var dataList = [];
        var maxData = [];
        for(var i = 0; i < categories.length; i++){
            for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
                if(categories[i] == viewBlock.blockDataToDraw[j][viewBlock.primaryDimension[0]+'___'+viewBlock.primaryDimension[1]]){
                    if(viewBlock.y1Measures.length){
                        var obj = {};
                        obj.value = viewBlock.blockDataToDraw[j][viewBlock.y1Measures[0][0]+'___'+viewBlock.y1Measures[0][1]];
                        if(viewBlock.y2Measures.length){
                            maxData.push(viewBlock.blockDataToDraw[j][viewBlock.y2Measures[0][0]+'___'+viewBlock.y2Measures[0][1]])
                        }
                        dataList.push(obj);
                    }
                }
            }
        }

        pictorialBar.categories = categories;
        pictorialBar.dataList = dataList;
        pictorialBar.maxData = maxData;
        pictorialBar.picture = viewBlock.ChartStyle.picture?("image:///Report/"+viewBlock.ChartStyle.picture.imageURL):null;
        pictorialBar.series = [{
            type: 'pictorialBar',
            barGap: '-100%',
            symbol: pictorialBar.picture,
            symbolRepeat: 'fixed',
            symbolClip: true,
            symbolSize: viewBlock.ChartStyle.barWidth*$BDA.defaultRatio,
            data: pictorialBar.dataList,
            z: 10
        },{
            type: 'pictorialBar',
            //barGap: '-100%',
            itemStyle: {
                normal: {
                    opacity: 0.2
                }
            },
            animationDuration: 0,
            symbolRepeat: 'fixed',
            symbol: pictorialBar.picture,
            symbolSize: viewBlock.ChartStyle.barWidth*$BDA.defaultRatio,
            data: pictorialBar.maxData,
            z: 5
        }];

        if(viewBlock.ChartStyle.scalePosition==1){
            pictorialBar.series.push({
                show: true,
                type: 'bar',
                // xAxisIndex: 1, //代表使用第二个X轴刻度
                barGap: '-100%',
                barWidth: viewBlock.ChartStyle.barWidth*$BDA.defaultRatio,
                itemStyle: {
                    normal: {
                        barBorderRadius: 200,
                        color: 'transparent', //rgba(22,203,115,0.05) 数据条柱状图的填充颜色,, 一开始我的有一点点背景颜色
                    }
                },
                label: {
                    normal: {
                        show: viewBlock.ChartStyle.axisLabelShow,
                        position: [0,-(viewBlock.ChartStyle.scaleFont.size)*$BDA.defaultRatio*1.18],
                        //position: [0,0],
                        //position: [0,-(viewBlock.ChartStyle.barWidth/2+viewBlock.ChartStyle.scaleFont.size)*$BDA.defaultRatio*1.18],
                        textStyle: {
                            color: $BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor),
                            fontFamily: (viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily,
                            fontSize: viewBlock.ChartStyle.scaleFont.size*$BDA.defaultRatio,
                            fontWeight: viewBlock.ChartStyle.scaleFont.bold?'bold':'100',
                            fontStyle: viewBlock.ChartStyle.scaleFont.italic?'italic':'normal',
                            textDecoration: viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')
                        },
                        formatter: function(data) {
                            return pictorialBar.categories[data.dataIndex];
                        }
                    }
                },
                data: pictorialBar.dataList
            });
        }

        return pictorialBar;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        $(this.chartID).find(".bda-chart-content").html("");
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-map-content"></div>');
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var mapChart = echarts.init($(this.chartID).find('.bda-map-content')[0]);
        mapChart.setOption({
            tooltip: {
                show: viewBlock.ChartStyle.dataHoverShow,
                confine: true,
                formatter: function(params){
                    return me.data.categories[params.dataIndex]+':'+$BDA.formatString.number(viewBlock.y1DataFormat, me.data.dataList[params.dataIndex].value);
                }
            },
            xAxis: {
                splitLine: {
                    show: false
                },
                axisLine: {
                    show: false
                },
                axisLabel: {
                    show: false
                },
                axisTick: {
                    show: false
                }
            },
            yAxis: {
                type: 'category',
                data: viewBlock.ChartStyle.scalePosition==0?me.data.categories:[],
                show: viewBlock.ChartStyle.scalePosition==0?true:false,
                inverse: true,
                axisLabel: {
                    show: viewBlock.ChartStyle.axisLabelShow,
                    textStyle: {
                        color: $BDA.csharp2rgba(viewBlock.ChartStyle.scaleColor),
                        fontFamily: (viewBlock.ChartStyle.scaleFont.fontFamily=='微软雅黑')?'Microsoft Yahei':viewBlock.ChartStyle.scaleFont.fontFamily,
                        fontSize: viewBlock.ChartStyle.scaleFont.size*$BDA.defaultRatio,
                        fontWeight: viewBlock.ChartStyle.scaleFont.bold?'bold':'100',
                        fontStyle: viewBlock.ChartStyle.scaleFont.italic?'italic':'normal',
                        textDecoration: viewBlock.ChartStyle.scaleFont.underline?'underline':(viewBlock.ChartStyle.scaleFont.strikeout?'line-through':'none')
                    }
                },
                axisTick: {show: false},
                axisLine: {show: false},
            },
            grid: {
                //top: 'center',
                //left: 10,
                //right: 10
                left: '2%',
                right: '2%',
                bottom: '0',
                top: '0',
                containLabel: true
            },
            series: me.data.series
        });

        if ((typeof openDrilldown == "undefined") && !(this.data.reportLink && this.data.reportLink.reportID) && !(viewBlock.reportLinks && viewBlock.reportLinks.count > 0) && !viewBlock.linkage || openDrilldown == false) {
            $(this.chartID).find('.bda-chart-content .bda-map-content canvas').css("cursor", "default");
        }

        mapChart.on('click', function (params) {
            me.echartSelectName = me.data.categories[params.dataIndex];
            for(var i = 0; i < viewBlock.blockDataToDraw.length; i++){
                for(var key in viewBlock.blockDataToDraw[i]){
                    if(viewBlock.blockDataToDraw[i][key] == me.data.categories[params.dataIndex]){
                        me.reportLinkData = viewBlock.blockDataToDraw[i];
                        return;
                    }
                }
            }
        });
    };

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignPictorialBar();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignPictorialBar();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----设备运行状态图*/
function EquipmentRunningStatusChart(strType,strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignEquipmentRunningStatusChartData();

    function assignEquipmentRunningStatusChartData(){
        if(viewBlock.blockDataToDraw.length == 0){return;}
        var equipmentRunningStatusChart = {};
        var categories = [];
        for(var i = 0; i < viewBlock.blockDataToDraw.length; i++){
            if(categories.indexOf(viewBlock.blockDataToDraw[i][viewBlock.equipmentDimension[0]+'___'+viewBlock.equipmentDimension[1]]) == -1){
                categories.push(viewBlock.blockDataToDraw[i][viewBlock.equipmentDimension[0]+'___'+viewBlock.equipmentDimension[1]]);
            }
        }
        equipmentRunningStatusChart.categories = categories;

        var statuses = [];
        var obj = {};
        obj.name = viewBlock.runningStyle.statusDimensionValue;
        obj.color = viewBlock.runningStyle.borderColor;
        statuses.push(obj);
        obj = {};
        obj.name = viewBlock.idleStyle.statusDimensionValue;
        obj.color = viewBlock.idleStyle.borderColor;
        statuses.push(obj);
        obj = {};
        obj.name = viewBlock.warningStyle.statusDimensionValue;
        obj.color = viewBlock.warningStyle.borderColor;
        statuses.push(obj);
        obj = {};
        obj.name = viewBlock.breakdownStyle.statusDimensionValue;
        obj.color = viewBlock.breakdownStyle.borderColor;
        statuses.push(obj);
        equipmentRunningStatusChart.statuses = statuses;

        
        var statusLegend = [];
        for(var i = 0; i < statuses.length; i++){
            var obj = {};
            obj.name = statuses[i].name;
            obj.textStyle = {
                color: $BDA.csharp2rgba(statuses[i].color)
            };
            statusLegend.push(obj);
        }
        equipmentRunningStatusChart.statusLegend = statusLegend;

        var dataMeasures = [];
        var minTime = new Date().getTime();
        for(var i = 0; i < categories.length; i++){
            for(var j = 0; j < viewBlock.blockDataToDraw.length; j++){
                if(viewBlock.blockDataToDraw[j][viewBlock.equipmentDimension[0]+'___'+viewBlock.equipmentDimension[1]] == categories[i]){
                    for(var k = 0; k < statuses.length; k++){
                        if(viewBlock.blockDataToDraw[j][viewBlock.statusDimension[0]+'___'+viewBlock.statusDimension[1]] == statuses[k].name){
                            if(viewBlock.blockDataToDraw[j][viewBlock.fromDateDimension[0]+'___'+viewBlock.fromDateDimension[1]]<minTime){
                                minTime = viewBlock.blockDataToDraw[j][viewBlock.fromDateDimension[0]+'___'+viewBlock.fromDateDimension[1]];
                            }
                            dataMeasures.push({
                                name: statuses[k].name,
                                value: [
                                    i,
                                    viewBlock.blockDataToDraw[j][viewBlock.fromDateDimension[0]+'___'+viewBlock.fromDateDimension[1]],
                                    viewBlock.blockDataToDraw[j][viewBlock.toDateDimension[0]+'___'+viewBlock.toDateDimension[1]],
                                    viewBlock.blockDataToDraw[j][viewBlock.toDateDimension[0]+'___'+viewBlock.toDateDimension[1]] - viewBlock.blockDataToDraw[j][viewBlock.fromDateDimension[0]+'___'+viewBlock.fromDateDimension[1]]
                                ],
                                itemStyle: {
                                    normal: {
                                        color: $BDA.csharp2rgba(statuses[k].color)
                                    }
                                }
                            });
                        }
                    }
                }
            }
        }
        equipmentRunningStatusChart.data = dataMeasures;
        equipmentRunningStatusChart.minTime = minTime;

        return equipmentRunningStatusChart;
    }

    this.draw = function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        $(this.chartID).find(".bda-chart-box").css("padding-top",0);
        $(this.chartID).find(".bda-chart-content").html("");
        $(this.chartID).find('.bda-chart-content').append('<div class="bda-map-content"></div>');
        this.setChartContentHeight(fltHeight);

        if (viewBlock.blockDataToDraw == null || viewBlock.blockDataToDraw.length == 0){return;}

        var mapChart = echarts.init($(this.chartID).find('.bda-map-content')[0]);
        mapChart.setOption({
            tooltip: {
                formatter: function (params) {
                    //console.log(params);
                    var continueTime = params.value[3]
                    if(viewBlock.timeUnit==0){
                        continueTime = continueTime+"毫秒";
                    }
                    if(viewBlock.timeUnit==1){
                        continueTime = continueTime/1000+"秒";
                    }
                    if(viewBlock.timeUnit==2){
                        continueTime = Math.floor((continueTime/(60*1000))*100)/100+"分钟";
                    }
                    if(viewBlock.timeUnit==3){
                        continueTime = Math.floor((continueTime/(3600*1000))*100)/100+"小时";
                    }
                    if(viewBlock.timeUnit==4){
                        continueTime = Math.floor((continueTime/(24*3600*1000))*100)/100+"天";
                    }

                    var str = '状态：'+params.name+'<br>'
                        +'持续时间：'+continueTime+'<br>'
                        +'起始时间：'+$BDA.formatString.date('YYYY-MM-dd HH:mm',new Date(params.value[1]))+'<br>'
                        +'结束时间：'+$BDA.formatString.date('YYYY-MM-dd HH:mm',new Date(params.value[2]))+'<br>';
                    //return params.marker + params.name + ': ' + params.value[3] + ' ms';
                    return str;
                }
            },
            dataZoom: [{
                type: 'slider',
                filterMode: 'weakFilter',
                showDataShadow: false,
                // top: 400,
                height: 10,
                borderColor: 'transparent',
                backgroundColor: '#e2e2e2',
                handleIcon: 'M10.7,11.9H9.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4h1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7v-1.2h6.6z M13.3,22H6.7v-1.2h6.6z M13.3,19.6H6.7v-1.2h6.6z', // jshint ignore:line
                handleSize: 20,
                handleStyle: {
                    shadowBlur: 6,
                    shadowOffsetX: 1,
                    shadowOffsetY: 2,
                    shadowColor: '#aaa'
                },
                labelFormatter: ''
            }, {
                type: 'inside',
                filterMode: 'weakFilter'
            }],
            grid: {
                top: 0
            },
            xAxis: {
                min: me.data.minTime,
                //minInterval: 3600 * 1000,
                axisLine: {
                    lineStyle: {
                        width: viewBlock.xScaleLineWidth,
                        color: $BDA.csharp2rgba(viewBlock.xScaleLineColor)
                    }
                },
                axisTick: {
                    lineStyle: {
                        width: viewBlock.showTick?1:0,
                        color: $BDA.csharp2rgba(viewBlock.xScaleLineColor)
                    } 
                },
                splitLine: {
                    show: viewBlock.showGridLine
                },
                scale: true,
                axisLabel: {
                    show: viewBlock.showScale,
                    fontFamily: viewBlock.scaleFont?viewBlock.scaleFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.scaleFont?viewBlock.scaleFont.size*$BDA.defaultRatio:12*$BDA.defaultRatio,
                    fontWeight: viewBlock.scaleFont?(viewBlock.scaleFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.scaleFont?(viewBlock.scaleFont.italic?'italic':'normal'):'normal',
                    color: viewBlock.scaleColor?$BDA.csharp2rgba(viewBlock.scaleColor):'#333',
                    formatter: function (val) {
                        return $BDA.formatString.date('HH:mm',new Date(val));
                    }
                },
            },
            yAxis: {
                data: me.data.categories,
                axisLine: {
                    lineStyle: {
                        width: viewBlock.y1ScaleLineWidth,
                        color: $BDA.csharp2rgba(viewBlock.y1ScaleLineColor)
                    }
                },
                axisTick: {
                    lineStyle: {
                        width: 1,
                        color: $BDA.csharp2rgba(viewBlock.xScaleLineColor)
                    } 
                },
                axisLabel: {
                    show: viewBlock.showScale,
                    fontFamily: viewBlock.scaleFont?viewBlock.scaleFont.fontFamily:'"Lucida Grande", "Lucida Sans Unicode", Arial, Helvetica, sans-serif',
                    fontSize: viewBlock.scaleFont?viewBlock.scaleFont.size*$BDA.defaultRatio:12*$BDA.defaultRatio,
                    fontWeight: viewBlock.scaleFont?(viewBlock.scaleFont.bold?'bold':'100'):'bold',
                    fontStyle: viewBlock.scaleFont?(viewBlock.scaleFont.italic?'italic':'normal'):'normal',
                    color: viewBlock.scaleColor?$BDA.csharp2rgba(viewBlock.scaleColor):'#333',
                },
            },
            series: [{
                type: 'custom',
                renderItem: renderItem,
                itemStyle: {
                    opacity: 0.8
                },
                encode: {
                    x: [1, 2],
                    y: 0
                },
                data: me.data.data
            }]
        });

        function renderItem(params, api) {
            var categoryIndex = api.value(0);
            var start = api.coord([api.value(1), categoryIndex]);
            var end = api.coord([api.value(2), categoryIndex]);
            var height = api.size([0, 1])[1] * 0.6;
        
            var rectShape = echarts.graphic.clipRectByRect({
                x: start[0],
                y: start[1] - height / 2,
                width: end[0] - start[0],
                height: height
            }, {
                x: params.coordSys.x,
                y: params.coordSys.y,
                width: params.coordSys.width,
                height: params.coordSys.height
            });
        
            return rectShape && {
                type: 'rect',
                shape: rectShape,
                style: api.style()
            };
        }

        mapChart.on('click', function (params) {
            var name = params.name;
        });
    }

    this.refreshByLinkage=function(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignEquipmentRunningStatusChartData();
        me.draw(fltHeight,openDrilldown, hierarchies,autoRefreshAnimation);
    }

    this.autoRefresh=function(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation){
        this.data = assignEquipmentRunningStatusChartData();
        this.draw(fltHeight, openDrilldown, hierarchies,autoRefreshAnimation);
    }
}

/*类----tab控件*/
function TabControl(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;
    var timer = null;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';

    this.draw = function(fltHeight){
        this.setChartContentHeight(fltHeight);
        $(this.chartID).find(".tab-wrap").on("click",".tab-button-box",function(){
            if(!$(this).hasClass("current-this")){
                $(me.chartID).find(".tab-button-box").each(function(i){
                    if($(this).hasClass("current-this")){
                        $(this).css({
                            "background-image": viewBlock.tabHeads[i].backgroundImage?("url('/Report/"+viewBlock.tabHeads[i].backgroundImage.imageURL+"')"):"none",
                            "background-color": $BDA.csharp2rgba(viewBlock.tabHeads[i].backgroundColor),
                            "color": $BDA.csharp2rgba(viewBlock.tabHeads[i].textColor),
                            "border-color": $BDA.csharp2rgba(viewBlock.tabHeads[i].borderColor)
                        });
                    }
                });
                $(this).addClass("current-this").siblings(".tab-button-box").removeClass("current-this");
                var currentIndex = Number($(this).attr("data-index"));
                $(this).css({
                    "background-image": viewBlock.tabHeads[currentIndex].selectedBackgroundImage?("url('/Report/"+viewBlock.tabHeads[currentIndex].selectedBackgroundImage.imageURL+"')"):"none",
                    "background-color": $BDA.csharp2rgba(viewBlock.tabHeads[currentIndex].selectedBackgroundColor),
                    "color": $BDA.csharp2rgba(viewBlock.tabHeads[currentIndex].selectedTextColor),
                    "border-color": $BDA.csharp2rgba(viewBlock.tabHeads[currentIndex].selectedBorderColor)
                });
                var self = this;
                $(me.chartID).find(".tab-content-box").each(function(){
                    if($(this).attr("data-index") == $(self).attr("data-index")){
                        $(this).css({
                            "visibility": "visible",
                            "z-index": 12
                        }).siblings(".tab-content-box").css({
                            "visibility": "hidden",
                            "z-index": 10
                        });
                    }
                });
            }
        });

        if(viewBlock.tabHeadLayoutStyle == 0){
            var topBoxWidth = $(this.chartID).find(".tab-wrap .tab-top").width();
            var buttonsWidth = 0;
            $(this.chartID).find(".tab-wrap .tab-button-box").each(function(){
                buttonsWidth += $(this).outerWidth();
            });
            if((topBoxWidth - buttonsWidth) >= 0){
                $(this.chartID).find(".tab-wrap .tab-button-box").each(function(){
                    $(this).css("margin-left",(topBoxWidth - buttonsWidth)/(viewBlock.tabHeads.length + 1)+"px")
                });
            }
        }

        clearInterval(timer);
        timer = null;
        if(viewBlock.carousel){
            carouselTab();

            $(this.chartID).hover(function(){
                clearInterval(timer);
                timer = null;
            },function(){
                carouselTab();
            });
        }
    }

    function carouselTab(){
        timer = setInterval(function(){
            var currentIndex = Number($(me.chartID).find(".tab-wrap .current-this").attr("data-index"));
            if(currentIndex == (viewBlock.tabHeads.length - 1)){
                currentIndex = currentIndex%(viewBlock.tabHeads.length - 1)
            }else{
                currentIndex++;
            }
            $(me.chartID).find(".tab-wrap .tab-button-box").eq(currentIndex).click();
        },viewBlock.carouselInterval*1000);
    }

    this.refreshByLinkage = function(fltHeight){
        return;
    }

    this.autoRefresh=function(fltHeight){
        return;
    }
}

/**类----自由表格 */
function FreeTable(strType, strBDAChartID, strTitle, viewBlock){
    var me = this;

    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = assignFreeTableData();

    function assignFreeTableData(){
        var freeTableData = {};

        var tableRowData = [];
        var tableCellStyle = [];
        var tableCellDivStyle = [];
        var borderWidthArr = [];
        var bodyData = [];
        var mergeData = [];
        for(var i = 0; i < viewBlock.viewTableRows.count; i++){
            var tempArr = [];
            var tdStyleArr = [];
            var divStyleArr = [];
            var tempBodyObj = {};
            var rowMergeArr = [];
            for(var j = 0; j < viewBlock.viewTableRows.item(i).viewTableCells.count; j++){
                var tableCell = viewBlock.viewTableRows.item(i).viewTableCells.item(j);
                var tempMergeObj = {};

                if(tableCell.cellObject[3] == 3){
                    if(tableCell.text != null && (tableCell.text.indexOf("http://") != -1 || tableCell.text.indexOf("https://") != -1)){
                        tempBodyObj[tableCell.columnIndex+""] = "<img height='"+(parseInt(tableCell.cellTextBox.font.size)*$BDA.defaultRatio)+"' src='"+ tableCell.text +"'/>";
                    }else {
                        tempBodyObj[tableCell.columnIndex+""] = "<img height='" + (parseInt(tableCell.cellTextBox.font.size) * $BDA.defaultRatio) + "' src='/Report/resource/report/custom/img/" + tableCell.text + "'/>";
                    }
                }else if(tableCell.cellObject[3] == 4){
                    tempBodyObj[tableCell.columnIndex+""] = "<img height='" + (parseInt(tableCell.cellTextBox.font.size) * $BDA.defaultRatio) + "' src='data:image/png;base64," + tableCell.text + "'/>";
                }else{
                    if (!tableCell.formatString) {
                        if (tableCell.cellObject[3] != 1) {
                            tempBodyObj[tableCell.columnIndex+""] = tableCell.text===null?"":tableCell.text;
                        } else {
                            tempBodyObj[tableCell.columnIndex+""] = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString, new Date(Number(tableCell.text)));
                        }
                    } else {
                        if (tableCell.cellObject[3] <= 0) {
                            tempBodyObj[tableCell.columnIndex+""] = tableCell.text===null?"":tableCell.text;
                        } else if (tableCell.cellObject[3] == 1) {
                            tempBodyObj[tableCell.columnIndex+""] = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.date(tableCell.formatString, new Date(Number(tableCell.text)));
                        } else {
                            tempBodyObj[tableCell.columnIndex+""] = (tableCell.text===null || tableCell.text==="")?"":$BDA.formatString.number(tableCell.formatString, tableCell.text);
                        }
                    }
                }
                
                if(tableCell.rowspan && tableCell.colspan){
                    tempMergeObj.rowIndex = i;
                    tempMergeObj.field = tableCell.columnIndex+"";
                    tempMergeObj.colspan = tableCell.colspan;
                    tempMergeObj.rowspan = tableCell.rowspan;
                    
                    rowMergeArr.push(tempMergeObj);
                }
                if(tableCell.autoColumnWidth || (!tableCell.autoColumnWidth && tableCell.columnWidth != 0)){
                    var colorArr = ["#eee","#eee","#eee","#eee"];
                    var widthArr = [0,0,0,0];
                    if(tableCell.borderColor){
                        colorArr = tableCell.borderColor.split(",");
                    }
                    if(tableCell.borderWidth){
                        widthArr = tableCell.borderWidth.split(",");
                    }
                    tdStyleArr.push({
                        "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                        "backgroundColor": $BDA.csharp2rgba(tableCell.cellTextBox.backgroundColor),
                        "textAlign": tableCell.cellTextBox.textAlign == '0' ? 'left' : (tableCell.cellTextBox.textAlign == '1' ? 'center' : 'right'),
                        "verticalAlign": tableCell.cellTextBox.verticalAlign == '0' ? 'top' : (tableCell.cellTextBox.verticalAlign == '1' ? 'middle' : 'bottom'),
                        "font-family": tableCell.cellTextBox.font.fontFamily,
                        'font-size': tableCell.cellTextBox.font.size,
                        'font-style': tableCell.cellTextBox.font.italic ? 'italic' : 'normal',
                        'font-weight': tableCell.cellTextBox.font.bold ? 'bold' : 'normal',
                        'text-decoration': tableCell.cellTextBox.font.underline ? 'underline' :
                            (tableCell.cellTextBox.font.strikeout ? 'line-through' : 'none'),
                        'border-width': tableCell.borderWidth?tableCell.borderWidth.replace(/\,/g,'px ') + 'px':'1px',
                        'border-color': $BDA.csharp2rgba(Number(colorArr[0]))+" "+$BDA.csharp2rgba(Number(colorArr[1]))+" "+$BDA.csharp2rgba(Number(colorArr[2]))+" "+$BDA.csharp2rgba(Number(colorArr[3])),
                        'border-style': 'solid',
                        'border-radius': tableCell.borderRadius?tableCell.borderRadius.replace(/\,/g,'px ') + 'px':'0',
                    });
                    divStyleArr.push({
                        "color": $BDA.csharp2rgba(tableCell.cellTextBox.color),
                        "font-family": tableCell.cellTextBox.font.fontFamily,
                        'font-size': tableCell.cellTextBox.font.size,
                        'font-style': tableCell.cellTextBox.font.italic ? 'italic' : 'normal',
                        'font-weight': tableCell.cellTextBox.font.bold ? 'bold' : 'normal'
                    });
                    // tempArr.push(tempObj);
                }
            }
            tableRowData.push(tempArr);
            tableCellStyle.push(tdStyleArr);
            tableCellDivStyle.push(divStyleArr);
            bodyData.push(tempBodyObj);
            mergeData.push(rowMergeArr);
        }

        var headData = [];
        for(var i = 0; i < viewBlock.viewTableRows.item(0).viewTableCells.count; i++){
            var tableCell = viewBlock.viewTableRows.item(0).viewTableCells.item(i);
            headData.push({
                field: tableCell.columnIndex+"",
                title: ""
            });

        }
        for(var i = 0; i < viewBlock.viewTableRows.item(0).viewTableCells.count; i++){
            var tempArr = [];
            for(var j = 0; j < viewBlock.viewTableRows.count; j++){
                var tableCell = viewBlock.viewTableRows.item(j).viewTableCells.item(i);
                if(tableCell.autoColumnWidth || (!tableCell.autoColumnWidth && tableCell.columnWidth != 0)){
                    var widthArr = [0,0,0,0];
                    if(tableCell.borderWidth){
                        widthArr = tableCell.borderWidth.split(",");
                    }
                    tempArr.push(Number(widthArr[1])+Number(widthArr[3]));
                }
            }
            borderWidthArr.pus