(function($,window){
    var document = window.document,
        navigator = window.navigator,
        DEVICE_HEIGHT = document.documentElement.clientHeight;

    var $BDA = {
        DEVICE_HEIGHT:DEVICE_HEIGHT,   /*默认高度*/
        defaultRatio: 1,
        tableColumnsWidthRatio: 1,
        useComputerStyleForMobile: 0,
        chart:{},                      /*图形相关*/
        dynamic:{},                    /*动态生成方法*/
        deviceTypeID:{},                 /*设备系统类型*/
        JS2Other:{},                   /*JS和其他语言的交互*/
        loading:{},                    /*loading界面*/
        message:{},                    /*信息提示框*/
        formatString:{}                /*格式化字符串*/
    };

    // Array.prototype.insert = function (index, arr) {
    //     this.splice.apply(this, [index, 0].concat(arr));
    //     return this;
    // };

    $BDA.setHtmlFontSize = function(isDrillDown,report, viewBlock){
        var clientWidth = document.documentElement.clientWidth || document.body.clientWidth;
        var clientHeight = document.documentElement.clientHeight || document.body.clientHeight;
        var proportion = 1;
        var widthProportion = 1;
        var heightProportion = 1;

        $BDA.tableColumnsWidthRatio = widthProportion = clientWidth / report.reportSettings.pageWidth;
        heightProportion = clientHeight / report.reportSettings.pageHeight;

        if(isDrillDown){
            for(var i = 0; i<report.pcPages.count; i++){
                if(report.pcPages.item(i).pageID == viewBlock.blockLayouts[2].pageID){
                    $BDA.tableColumnsWidthRatio = widthProportion = clientWidth / (report.reportSettings.pageWidth/report.pcPages.item(i).columns * viewBlock.blockLayouts[2].width);
                    heightProportion = clientHeight / (report.reportSettings.pageHeight / report.pcPages.item(i).rows * viewBlock.blockLayouts[2].height);
                }
            }
        }

        $BDA.defaultRatio = proportion = Math.min(widthProportion, heightProportion);
        document.documentElement.style.fontSize = proportion * 100 + "px";
    };

    /*千位符*/
    $BDA.format = function(num){
        if (typeof num === "undefined") return num;
        if (typeof num === 'string') return num;
        if(!num)return num;
        var isNegativeNumber = false;
        if(num<0){
            isNegativeNumber = true;
            num = Math.abs(num);
        }
        var str = (num||0).toString(), result='',floatPart='',intPart= str;
        var scalingPosition = str.indexOf('.'); /*小数点位置*/
        if(scalingPosition!=-1){
            intPart = str.slice(0,scalingPosition);
            floatPart = str.slice(scalingPosition);
        }
        while (intPart.length > 3) {
            result = ',' + intPart.slice(-3) + result;
            intPart = intPart.slice(0, intPart.length - 3);
        }
        if (intPart) { result = intPart + result + floatPart; }
        if(isNegativeNumber){
            result = -result;
        }
        return result;
    };

    /*C#颜色转换rgba*/
    $BDA.csharp2rgba = function(val) {
        var opacity = ((val >> 24) & 0xFF) + '',
            red = ((val >> 16) & 0xFF) + '',
            green = ((val >> 8) & 0xFF) + '',
            blue = (val & 0xFF) + '';
        return 'rgba(' + red+',' + green+',' + blue+','+(parseInt(opacity.slice(-3))/255).toFixed(2)+')';
    };

    $BDA.newChart = function(strChartType,strChartID,title,viewBlock) {
        switch (strChartType) {
            case 0:
                return new TileChart(strChartType, strChartID, title, viewBlock);
            case 1:
                return new VerticalTable(strChartType, strChartID, title, viewBlock);
            case 2:
                return new HorizontalTable(strChartType, strChartID, title, viewBlock);
            case 3:
                return new PivotTable(strChartType, strChartID, title, viewBlock);
            case 4:
                return new Histogram(strChartType, strChartID, title, viewBlock);
            case 5:
                return new AccumulateHistogram(strChartType, strChartID, title, viewBlock);
            case 6:
                return new PercentHistogram(strChartType, strChartID, title, viewBlock);
            case 7:
                return new BarChart(strChartType, strChartID, title, viewBlock);
            case 8:
                return new AccumulateBarChart(strChartType, strChartID, title, viewBlock);
            case 9:
                return new PercentBarChart(strChartType, strChartID, title, viewBlock);
            case 10:
                return new LineGraph(strChartType, strChartID, title, viewBlock);
            case 11:
                return new AreaGraph(strChartType, strChartID, title, viewBlock);
            case 12:
                return new HistogramLine(strChartType, strChartID, title, viewBlock);
            case 13:
                return new PieChart(strChartType, strChartID, title, viewBlock);
            case 14:
                return new Doughnut(strChartType, strChartID, title, viewBlock);
            case 15:
                return new Gauge(strChartType, strChartID, title, viewBlock);
            case 16:
                return new ScatterPlot(strChartType, strChartID, title, viewBlock);
            case 17:
                return new BubbleChart(strChartType, strChartID, title, viewBlock);
            case 18:
                return new Waterfall(strChartType, strChartID, title, viewBlock);
            case 19:
                return new RadarMap(strChartType, strChartID, title, viewBlock);
            case 20:
                return new BoxPlot(strChartType, strChartID, title, viewBlock);
            case 21:
                return new FunnelPlot(strChartType, strChartID, title, viewBlock);
            case 22:
                return new PolarMap(strChartType, strChartID, title, viewBlock);
            case 23:
                return new EchartMap(strChartType, strChartID, title, viewBlock);
            case 24:
                return new AccumulateHistogramLine(strChartType, strChartID, title, viewBlock);
            case 25:
                return new PercentHistogramLine(strChartType, strChartID, title, viewBlock);
            case 26:
                return new Label(strChartType, strChartID, title, viewBlock);
            case 27:
                return new ScalableLineGraph(strChartType, strChartID, title, viewBlock);
            case 28:
                return new AdjustableLineGraph(strChartType, strChartID, title, viewBlock);
            case 29:
                return new VariablePie(strChartType, strChartID, title, viewBlock);
            case 30:
                return new PercentDoughnut(strChartType, strChartID, title, viewBlock);
            case 31:
                return new BulletChart(strChartType, strChartID, title, viewBlock);
            case 32:
                return new FoldingTable(strChartType, strChartID, title, viewBlock);
            case 34:
                return new WheelFrame(strChartType, strChartID, title, viewBlock);
            case 35:
                return new WordCloud(strChartType, strChartID, title, viewBlock);
            case 36:
                return new WaterWaveChart(strChartType, strChartID, title, viewBlock);
            case 37:
                return new TotalTable(strChartType, strChartID, title, viewBlock);
            case 38:
                return new SparkLine(strChartType,strChartID, title, viewBlock);
            case 39:
                return new ScatterMap(strChartType,strChartID, title, viewBlock);
            case 40:
                return new FreeCell(strChartType,strChartID, title, viewBlock);
            case 41:
                return new DateTimeControl(strChartType,strChartID, title, viewBlock);
            case 42:
                return new TreeMap(strChartType,strChartID, title, viewBlock);
            case 43:
                return new ReportContainer(strChartType,strChartID, title, viewBlock);
            case 44:
                return new BDAButton(strChartType,strChartID, title, viewBlock);
            case 45:
                return new PictureBox(strChartType,strChartID, title, viewBlock);
            case 46:
                return new SimpleBarChart(strChartType,strChartID, title, viewBlock);
            case 47:
                return new EquipmentRealTimeStatusChart(strChartType,strChartID, title, viewBlock);
            case 48:
                return new SimpleGanttChart(strChartType,strChartID, title, viewBlock);
            case 49:
                return new PictorialBar(strChartType,strChartID, title, viewBlock);
            case 50:
                return new EquipmentRunningStatusChart(strChartType,strChartID, title, viewBlock);
            case 51:
                return new TabControl(strChartType,strChartID, title, viewBlock);
            case 52:
                return new FreeTable(strChartType,strChartID, title, viewBlock);
            case 53:
                return new ProgressBar(strChartType, strChartID, title, viewBlock);
        }
    }

    $BDA.getGraphKinds = function(chartID){
        switch (chartID){
            case 0 : return 'tile';
            case 1 : return 'verticalTable';
            case 2 : return 'horizontalTable';
            case 3 : return 'pivotTable';
            case 4 :
            case 5 :
            case 6 : return 'column';
            case 7 :
            case 8 :
            case 9 : return 'bar';
            case 10 : return 'line';
            case 11 : return 'area';
            case 12 : return 'xy';
            case 13 : return 'pie';
            case 14 : return 'donut';
            case 15 : return 'gauge';
            case 16 : return 'scatter';
            case 17 : return 'bubble';
            case 18 : return 'waterfall';
            case 19 : return 'radar';
            case 20 : return 'boxPlot';
            case 21 : return 'funnel';
            case 22 : return 'polar';
            case 23 : return 'map';
            case 24 : return 'xy';
            case 25 : return 'xy';
            case 26 : return 'label';
            case 27 : return 'area';
            case 28 : return 'area';
            case 29 : return 'rose';
            case 30 : return 'percentDoughnut';
            case 31 : return 'bullet';
            case 32 : return 'foldingTable';
            case 34 : return 'wheelFrame';
            case 35 : return 'wordCloud';
            case 36 : return 'waterWave';
            case 37 : return 'totalTable';
            case 38 : return 'sparkLine';
            case 39 : return 'scatterMap';
            case 40 : return 'freeCell';
            case 41 : return 'dateTimeControl';
            case 42 : return 'treeMap';
            case 43 : return 'reportContainer';
            case 44 : return 'BDAButton';
            case 45 : return 'pictureBox';
            case 46 : return 'simpleBarChart';
            case 47 : return 'equipmentRealTimeStatusChart';
            case 48 : return 'simpleGanttChart';
            case 49 : return 'pictorialBar';
            case 50 : return 'equipmentRunningStatusChart';
            case 51 : return 'tabControl';
            case 52 : return 'freeTable';
            case 53 : return 'progressBar';
        }
    }

    $BDA.getFormatType = function(viewBlock,key){
        var chartID = viewBlock.chartID;
        var formatType = "";
        if(chartID != 44 && chartID != 43 && chartID != 41 && chartID != 40 && chartID != 34 && chartID != 26 && chartID != 0 && chartID != 23 && chartID != 39){
            if(chartID == 1 || chartID == 38){
                for(var i = 0; i < viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.count; i++){
                    var tableCell = viewBlock.viewTableBody.viewTableRows.item(0).viewTableCells.item(i);
                    if((tableCell.cellObject[0]+"___"+tableCell.cellObject[1]) == key){
                        formatType = tableCell.formatString || "";
                        return formatType;
                    }
                }
            }else if(chartID == 32 || chartID == 37){
                for(var i = 0; i < viewBlock.viewTableBody.viewTableRows[0].viewTableCells.length; i++){
                    var tableCell = viewBlock.viewTableBody.viewTableRows[0].viewTableCells[i];
                    if((tableCell.cellObject[0]+"___"+tableCell.cellObject[1]) == key){
                        formatType = tableCell.formatString || "";
                        return formatType;
                    }
                }
            }else if(chartID == 2){
                for(var i = 0; i < viewBlock.viewTableBody.viewTableColumns.item(0).viewTableCells.count; i++){
                    var tableCell = viewBlock.viewTableBody.viewTableColumns.item(0).viewTableCells.item(i);
                    if((tableCell.cellObject[0]+"___"+tableCell.cellObject[1]) == key){
                        formatType = tableCell.formatString || "";
                        return formatType;
                    }
                }
            }else if(chartID == 3){
                for(var i = 0; i < viewBlock.viewVerticalTableBlock.viewTableBody.viewTableRows[0].viewTableCells.length; i++){
                    var tableCell = viewBlock.viewVerticalTableBlock.viewTableBody.viewTableRows[0].viewTableCells[i];
                    if((tableCell.cellObject[0]+"___"+tableCell.cellObject[1]) == key){
                        formatType = tableCell.formatString || "";
                        return formatType;
                    }
                }
            }else if(chartID == 15){
                formatType = viewBlock.formatString || "";
                return formatType;
            }else{
                for(var i = 0; i < viewBlock.y1Measures.length; i++){
                    if((viewBlock.y1Measures[i][0]+"___"+viewBlock.y1Measures[i][1]) == key){
                        formatType = viewBlock.y1DataFormat || "";
                        return formatType;
                    }
                }
                for(var i = 0; i < viewBlock.y2Measures.length; i++){
                    if((viewBlock.y2Measures[i][0]+"___"+viewBlock.y2Measures[i][1]) == key){
                        formatType = viewBlock.y2DataFormat || "";
                        return formatType;
                    }
                }
                for(var i = 0; i < viewBlock.y3Measures.length; i++){
                    if((viewBlock.y3Measures[i][0]+"___"+viewBlock.y3Measures[i][1]) == key){
                        formatType = viewBlock.y3DataFormat || "";
                        return formatType;
                    }
                }
            }
        }
    }

    $BDA.ganttDateFormat = function(type,value){
        if(type == 0){
            var day = value.getDate()<10?('0'+value.getDate()):value.getDate()
           return value.getMonth()+1+'-'+day;
        }
        if(type == 1){
            return value.getMonth()+1+'月';
        }
        if(type == 2){
            var quarter = 1;
            if(value.getMonth()+1 < 4){
                quarter = 1;
            }else if(value.getMonth()+1 < 7){
                quarter = 2;
            }else if(value.getMonth()+1 < 10){
                quarter = 3;
            }else{
                quarter = 4;
            }
            return value.getFullYear()+'-'+quarter;
        }
        if(type == 3){
            return value.getFullYear()+'年';
        }
        if(type == 4){
            var date = value.getDate();
            var month = value.getMonth() < 9 ? ('0'+value.getMonth()):value.getMonth();
            var year = value.getFullYear();
            return year+'-'+month+'-'+date;
        }
    }

    /*将动态生成方法扩展至$BDA.dynamic上*/
    $.extend($BDA.dynamic,{
        /*生成页面结构------行*/
        createPage : function(target, page){
            for (var i = 0, rowLength = page.length; i < rowLength; i++) {
                var element = document.createElement('div');
                element.className = "row rowIndex" + i;
                element.id = page[i].pageID;
                element.setAttribute('data-rows',page[i].rows);
                element.setAttribute('data-columns',page[i].columns);
                if(page[i].pageImage){
                    element.style.backgroundImage = 'url("/Report/'+page[i].pageImage.imageURL+'")';
                    element.style.backgroundRepeat = 'no-repeat';
                    element.style.backgroundPosition = 'center top';
                    element.style.backgroundSize = '100% 100%';
                    element.style.backgroundColor = 'rgba(0,0,0,0)';
                }
                if(page[i].backgroundColor && $BDA.theme.themeID==0){
                    element.style.backgroundColor = $BDA.csharp2rgba(page[i].backgroundColor);
                }
                target.append(element);
            }
        },
        /*生成每一行的图表*/
        createBlock:function(viewBlocks, deviceTypeID, customLayoutForMobile){
            for (var i = 0, rowLength = viewBlocks.count; i < rowLength; i++) {
                if(viewBlocks.item(i).blockLayouts[deviceTypeID].pageID && !viewBlocks.item(i).blockLayouts[deviceTypeID].containerID) {
                    var element = document.createElement('div');
                    element.className = 'bda-chart ' + $BDA.getGraphKinds(viewBlocks.item(i).chartID);
                    element.id = 'bda-chart' + i;
                    element.setAttribute("data-blockid", viewBlocks.item(i).blockID);
                    if(viewBlocks.item(i).chartID != 51){
                        element.innerHTML = this.blockXML();
                    }else{
                        element.innerHTML = "<div class='bda-bgcolor tab-wrap'></div>";
                    }

                    var tempStr = "4,6,4,6"
                    var marginBlock = viewBlocks.item(i).margin ? viewBlocks.item(i).margin.split(",") : tempStr.split(",");
                    if (deviceTypeID != 2) {
                        $(element).css({
                            "margin-top": (marginBlock[0]>0?marginBlock[0]:0) + "px",
                            "padding-right": (marginBlock[1]>0?marginBlock[1]:0) + "px",
                            "margin-bottom": (marginBlock[2]>0?marginBlock[2]:0) + "px",
                            "padding-left": (marginBlock[3]>0?marginBlock[3]:0) + "px"
                        });
                    }
                    if (deviceTypeID == 2) {
                        $(element).css({
                            "margin-top": (marginBlock[0]>0?marginBlock[0]*$BDA.defaultRatio:0) + "px",
                            "padding-right": marginBlock[1]*$BDA.defaultRatio + "px",
                            "margin-bottom": (marginBlock[2]>0?marginBlock[2]*$BDA.defaultRatio:0) + "px",
                            "padding-left": marginBlock[3]*$BDA.defaultRatio + "px"
                        });
                    }
                    if (viewBlocks.item(i).backgroundImage) {
                        $(element).find('.bda-bgcolor').css({
                            "background-image": 'url("/Report/' + viewBlocks.item(i).backgroundImage.imageURL + '")',
                            "background-repeat": 'no-repeat',
                            "background-position": 'center top',
                            "background-size": '100% 100%'
                        });
                    }
                    if (viewBlocks.item(i).backgroundColor && $BDA.theme.themeID == 0) {
                        $(element).find('.bda-bgcolor').css({
                            "background-color": $BDA.csharp2rgba(viewBlocks.item(i).backgroundColor)
                        });
                    }
                    if (viewBlocks.item(i).backgroundColorTransparent) {
                        $(element).find('.bda-bgcolor').css({
                            "background-color": "rgba(0,0,0,0)"
                        });
                    }
                    this[deviceTypeID == 0 ? 'mobileStyle' : 'elseStyle'](element, viewBlocks.item(i), deviceTypeID, customLayoutForMobile);
                }
            }
        },
        tabXML:function(viewBlocks,deviceTypeID){
            for(var i = 0; i < viewBlocks.count; i++){
                if(viewBlocks.item(i).chartID == 51 && viewBlocks.item(i).blockLayouts[deviceTypeID].pageID){
                    var me = this;
                    $(".bda-chart").each(function(){
                        if($(this).attr("data-blockid") == viewBlocks.item(i).blockID){
                            me.createTabColumnAndRow(viewBlocks.item(i),$(this).find(".tab-wrap"));
                        }
                    });
                }
            }
        },
        createTabColumnAndRow:function(viewBlock,elementBox){
            $(elementBox).html("<div class='tab-top'></div><div class='tab-bottom'></div>");
            $(elementBox).find(".tab-top").css({
                "display": "table-cell",
                "vertical-align": "middle",
                "position": "absolute",
                "top": viewBlock.tabHeadLocation == 0?0:"auto",
                "left": 0,
                "right": 0,
                "bottom": viewBlock.tabHeadLocation == 1?0:"auto",
                "padding": viewBlock.tabHeadPadding.replace(/\,/g,'px ') + 'px'
            });
            for(var i = 0; i < viewBlock.tabHeads.length; i++){
                var element = document.createElement('div');
                element.setAttribute('data-index',i);
                var str = "";
                if(viewBlock.tabHeads[i].icon){
                    str = "<img src='/Report/"+viewBlock.tabHeads[i].icon.imageURL+"' style='width: "+viewBlock.tabHeads[i].textFont.size/100+"rem; height: "+viewBlock.tabHeads[i].textFont.size/100+"rem; vertical-align: middle;'>";
                }
                $(element).css({
                    "background-color": $BDA.csharp2rgba(viewBlock.tabHeads[i].backgroundColor),
                    "background-image": viewBlock.tabHeads[i].backgroundImage?('url(/Report/'+viewBlock.tabHeads[i].backgroundImage.imageURL+')'):"none",
                    "background-repeat": "no-repeat",
                    "background-position": "center center",
                    "background-size": "100% 100%",
                    "width": viewBlock.tabHeads[i].width/100 + "rem",
                    "height": viewBlock.tabHeads[i].height/100 + "rem",
                    "cursor": "pointer",
                    "font-family": viewBlock.tabHeads[i].textFont.fontFamily,
                    "font-size": viewBlock.tabHeads[i].textFont.size/100 + "rem",
                    "color": $BDA.csharp2rgba(viewBlock.tabHeads[i].textColor),
                    "overflow": "hidden",
                    "display": "inline-block",
                    "vertical-align": "middle",
                    "box-sizing": "content-box"
                });
                if(ajaxTools.deviceTypeID == 2){
                    $(element).css({
                        "border-width": viewBlock.tabHeads[i].borderWidth.replace(/\,/g,'px ') + 'px',
                        "border-color": $BDA.csharp2rgba(viewBlock.tabHeads[i].borderColor),
                        "border-style": "solid"
                    });
                    if(i==0){
                        $(element).css({
                            "border-color": $BDA.csharp2rgba(viewBlock.tabHeads[i].selectedBorderColor)
                        });
                    }
                }
                if((viewBlock.tabHeads[i].icon && (viewBlock.tabHeads[i].iconLocation == 0 || viewBlock.tabHeads[i].iconLocation == 2)) || !viewBlock.tabHeads[i].icon){
                   $(element).css({
                       "line-height": viewBlock.tabHeads[i].height/100 + "rem",
                   });
                }
                if(i == 0){
                    element.className = "current-this tab-button-box tab-button" + i;
                    $(element).css({
                        "background-image": viewBlock.tabHeads[i].selectedBackgroundImage?('url("/Report/'+viewBlock.tabHeads[i].selectedBackgroundImage.imageURL+'")'):"none",
                        "background-color": $BDA.csharp2rgba(viewBlock.tabHeads[i].selectedBackgroundColor),
                        "color": $BDA.csharp2rgba(viewBlock.tabHeads[i].selectedTextColor)
                    });
                }else{
                    element.className = "tab-button-box tab-button" + i;
                }
                if(viewBlock.tabHeads[i].icon){
                    if(viewBlock.tabHeads[i].iconLocation == 0){
                        str = str + "<span style='display: inline-block; vertical-align: top; margin-left: 0.05rem'>"+viewBlock.tabHeads[i].text+"</span>";
                    }
                    if(viewBlock.tabHeads[i].iconLocation == 1){
                        str = "<div style='display: table-cell; width:"+viewBlock.tabHeads[i].width/100+"rem; height: "+viewBlock.tabHeads[i].height/100+"rem; vertical-align: middle;'>" + str + "<br><span style='display: inline-block; vertical-align: top;'>"+viewBlock.tabHeads[i].text+"</span></div>";
                        
                    }
                    if(viewBlock.tabHeads[i].iconLocation == 2){
                        str = "<span style='display: inline-block; vertical-align: top; margin-right: 0.05rem'>"+viewBlock.tabHeads[i].text+"</span>"+str;
                    }
                    if(viewBlock.tabHeads[i].iconLocation == 3){
                        str = "<div style='display: table-cell; width:"+viewBlock.tabHeads[i].width/100+"rem; height: "+viewBlock.tabHeads[i].height/100+"rem; vertical-align: middle;'><span style='display: inline-block; vertical-align: top;'>"+viewBlock.tabHeads[i].text+"</span><br>" + str + "</div>";
                        
                    }
                }else{
                    str = "<span style='display: inline-block; vertical-align: top;'>"+viewBlock.tabHeads[i].text+"</span>";
                }
                element.innerHTML = str;
                $(elementBox).find(".tab-top").append(element);
                if(ajaxTools.deviceTypeID != 2){
                    var stempArr = viewBlock.tabHeads[i].borderWidth.split(",");
                    $(element).find("span").css({
                        "height": viewBlock.tabHeads[i].height/100+"rem",
                        "line-height": viewBlock.tabHeads[i].height/100+"rem",
                        "border-width": viewBlock.tabHeads[i].borderWidth.replace(/\,/g,'px ') + 'px',
                        "border-color": $BDA.csharp2rgba(viewBlock.tabHeads[i].borderColor),
                        "border-style": "solid"
                    });
                    if(i==0){
                        $(element).find("span").css({
                            "border-color": $BDA.csharp2rgba(viewBlock.tabHeads[i].selectedBorderColor)
                        });
                    }
                }
            }
            var tabButtonHeight = $(elementBox).find(".tab-top").outerHeight();
            for(var i = 0; i < viewBlock.tabBodys.length; i++){
                var element = document.createElement('div');
                element.className = "tab-content-box tab-content" + i;
                element.setAttribute('data-index',i);
                element.setAttribute('data-column',viewBlock.tabBodys[i].columns);
                element.setAttribute('data-row',viewBlock.tabBodys[i].rows);
                element.style.position = "absolute";
                if(viewBlock.tabHeadLocation == 0){
                    element.style.top = tabButtonHeight+"px";
                    element.style.bottom = 0;
                }else if(viewBlock.tabHeadLocation == 1){
                    element.style.top = 0;
                    element.style.bottom = tabButtonHeight+"px";
                }
                element.style.right = 0;
                element.style.left = 0;
                if(i==0){
                    element.style.visibility = "visibility";
                    element.style.zIndex = 12;
                }else{
                    element.style.visibility = "hidden";
                    element.style.zIndex = 10;
                }
                $(elementBox).find(".tab-bottom").append(element);
            }
        },
        mobileStyle:function(element,viewBlock,deviceTypeID,customLayoutForMobile){
            var parentElement = $('#' + viewBlock.blockLayouts[deviceTypeID].pageID);
            if (customLayoutForMobile == 1) {
                $(element).css({
                    position: 'absolute',
                    width: (viewBlock.blockLayouts[deviceTypeID].width / parentElement.attr('data-columns')) * 100 + '%',
                    height: (viewBlock.blockLayouts[deviceTypeID].height / parentElement.attr('data-rows')) * 100 + '%',
                    left: (viewBlock.blockLayouts[deviceTypeID].left / parentElement.attr('data-columns')) * 100 + '%',
                    top: (viewBlock.blockLayouts[deviceTypeID].top / parentElement.attr('data-rows')) * 100 + '%',
                    zIndex: viewBlock.blockLayouts[deviceTypeID].zIndex
                });
            } else {
                $(element).css({
                    "width": (viewBlock.blockLayouts[deviceTypeID].width / parentElement.attr('data-columns')) * 100 + '%',
                    "height": (viewBlock.blockLayouts[deviceTypeID].height / parentElement.attr('data-rows')) * DEVICE_HEIGHT
                });
            }
            parentElement.append(element);
        },
        elseStyle:function(element,viewBlock,deviceTypeID){
            var parentElement = $('#'+viewBlock.blockLayouts[deviceTypeID].pageID);
            $(element).css({
                position : 'absolute',
                width : (viewBlock.blockLayouts[deviceTypeID].width / parentElement.attr('data-columns'))*100 + '%',
                height : (viewBlock.blockLayouts[deviceTypeID].height / parentElement.attr('data-rows'))*100 + '%',
                left : (viewBlock.blockLayouts[deviceTypeID].left / parentElement.attr('data-columns'))*100 + '%',
                top : (viewBlock.blockLayouts[deviceTypeID].top / parentElement.attr('data-rows'))*100 + '%',
                zIndex : viewBlock.blockLayouts[deviceTypeID].zIndex
            });
            parentElement.append(element);
        },
        createTabContentBlock:function(viewBlocks, deviceTypeID){
            for (var i = 0, rowLength = viewBlocks.count; i < rowLength; i++) {
                if(viewBlocks.item(i).blockLayouts[deviceTypeID].containerID) {
                    var element = document.createElement('div');
                    element.className = 'bda-chart ' + $BDA.getGraphKinds(viewBlocks.item(i).chartID);
                    element.id = 'bda-chart' + i;
                    element.setAttribute("data-blockid", viewBlocks.item(i).blockID);
                    element.innerHTML = this.blockXML();
                    var tempStr = "4,6,4,6"
                    var marginBlock = viewBlocks.item(i).margin ? viewBlocks.item(i).margin.split(",") : tempStr.split(",");
                    if (deviceTypeID != 2) {
                        $(element).css({
                            "margin-top": (marginBlock[0]>0?marginBlock[0]:0) + "px",
                            "padding-right": (marginBlock[1]>0?marginBlock[1]:0) + "px",
                            "margin-bottom": (marginBlock[2]>0?marginBlock[2]:0) + "px",
                            "padding-left": (marginBlock[3]>0?marginBlock[3]:0) + "px"
                        });
                    }
                    if (deviceTypeID == 2) {
                        $(element).css({
                            "margin-top": (marginBlock[0]>0?marginBlock[0]*$BDA.defaultRatio:0) + "px",
                            "padding-right": marginBlock[1]*$BDA.defaultRatio + "px",
                            "margin-bottom": (marginBlock[2]>0?marginBlock[2]*$BDA.defaultRatio:0) + "px",
                            "padding-left": marginBlock[3]*$BDA.defaultRatio + "px"
                        });
                    }
                    if (viewBlocks.item(i).backgroundImage) {
                        $(element).find('.bda-bgcolor').css({
                            "background-image": 'url("/Report/' + viewBlocks.item(i).backgroundImage.imageURL + '")',
                            "background-repeat": 'no-repeat',
                            "background-position": 'center top',
                            "background-size": '100% 100%'
                        });
                    }
                    if (viewBlocks.item(i).backgroundColor && $BDA.theme.themeID == 0) {
                        $(element).find('.bda-bgcolor').css({
                            "background-color": $BDA.csharp2rgba(viewBlocks.item(i).backgroundColor)
                        });
                    }
                    if (viewBlocks.item(i).backgroundColorTransparent) {
                        $(element).find('.bda-bgcolor').css({
                            "background-color": "rgba(0,0,0,0)"
                        });
                    }
                    this.tabStyle(element, viewBlocks.item(i), deviceTypeID);
                }
            }
        },
        tabStyle:function(element,viewBlock,deviceTypeID){
            var tabChartBlockID = viewBlock.blockLayouts[deviceTypeID].containerID;
            $(".bda-chart").each(function(){
                if($(this).attr("data-blockid") == tabChartBlockID){
                    $(this).find(".tab-content-box").each(function(){
                        if($(this).attr("data-index") == viewBlock.blockLayouts[deviceTypeID].containerIndex){
                            var contentWidth = parseInt($(this).attr("data-column"));
                            var contentHeight = parseInt($(this).attr("data-row"));
                            $(element).css({
                                position : 'absolute',
                                width : (viewBlock.blockLayouts[deviceTypeID].width / contentWidth)*100 + '%',
                                height : (viewBlock.blockLayouts[deviceTypeID].height / contentHeight)*100 + '%',
                                left : (viewBlock.blockLayouts[deviceTypeID].left / contentWidth)*100 + '%',
                                top : (viewBlock.blockLayouts[deviceTypeID].top / contentHeight)*100 + '%',
                                zIndex : viewBlock.blockLayouts[deviceTypeID].zIndex
                            });
                            $(this).append(element);
                            return false;
                        }
                    });
                    return false;
                }
            });
        },
        /*图表的页面元素模板*/
        blockXML: function () {
            return '<div class="bda-bgcolor bda-boxShadow">\
                        <div class="chart-link-toolbar">\
                            <span></span>\
                        </div>\
                        <div class="chart-drill-toolbar">\
                            <span></span>\
                        </div>\
                        <h3><span></span></h3>\
                        <h5><span></span></h5>\
                        <div class="bda-data">\
                            <p><span class="bda-dimension"></span><span class="bda-measure"></span></p>\
                            <p><span class="bda-grouping"></span><span class="bda-extensive-measure"></span></p>\
                        </div>\
                        <div class="bda-chart-box">\
                            <div class="bda-pointer"></div>\
                            <div class="bda-chart-content"></div>\
                        </div>\
                        <div class="bda-remark"></div>\
                    </div>';
        },
        creatDrillDownBlockHtml: function(){
            return '<div class="drill-page">\
                <div class="col-xs-12 col-sm-4 col-lg-4 bda-chart drill-chart">\
                <div class="bda-bgcolor">\
                <h3><span></span></h3>\
                <h5><span></span></h5>\
                <span class="drill-forward"></span>\
                <span class="drill-backward"></span>\
                <span class="drill-change-chart"></span>\
                <span class="drill-exit drill-close-pc"></span>\
                <span class="drill-exit drill-close-mobile">\
                <img src="../img/drill-close.png" class="moblie-close">\
                </span>\
                <div class="bda-data">\
                <p><span class="bda-dimension"></span><span class="bda-measure"></span></p>\
                <p><span class="bda-grouping"></span><span class="bda-extensive-measure"></span></p>\
                </div>\
                <div class="bda-chart-box">\
                <div class="bda-pointer"></div>\
                <div class="bda-chart-content"></div>\
                </div>\
                </div>\
                </div>\
                </div>'
        },
        /**
         * 移动端
         */
        mobile: {
            /*生成过滤器中----过滤条件list*/
            createFilterList: function (list) {
                for (var i = 0, str = '', len = list.length; i < len; i++) {
                    str += '<li data-index="'+i+'">\
                    <span class="entry-content">\
                        <span class="select-content">请选择</span>\
                        <span class="prompt-content">' + (list[i].prompt?list[i].prompt:"") + '</span>\
                    </span>\
                </li>';
                }
                return str;
            }
        },
        /**
         * pc端
         */
        pc: {
            /*过滤器----head*/
            createFilterHead: function (data) {
                for (var i = 0, str = '', len = data.length; i < len; i++) {
                    str += '<li class="filter-pc-li" data-index="' + i + '"><span>' + data[i].prompt + '</span><span class="filter-header-content"></span></li>'
                }
                return str;
            },
            /*过滤器----body*/
            createFilterBody: function (data, obj) {
                for (var i = 0, str = '', len = data.length; i < len; i++) {
                    if(data[i][obj.valueObjectName]){
                        str += '<li class="filter-pc-li" title="'+(obj.dataType?(obj.dataType==1?$BDA.formatString.date(obj.formatString,new Date(data[i][obj.valueObjectName])):$BDA.formatString.number(obj.formatString,data[i][obj.valueObjectName])):data[i][obj.valueObjectName])+'" data-value="' + data[i][obj.valueObjectName] + '">' + (obj.dataType?(obj.dataType==1?$BDA.formatString.date(obj.formatString,new Date(data[i][obj.valueObjectName])):$BDA.formatString.number(obj.formatString,data[i][obj.valueObjectName])):data[i][obj.valueObjectName]) + '</li>';
                    }else{
                        str += '<li class="filter-pc-li" data-value=""></li>';
                    }
                }
                return str;
            }
        }
    });

    /*将设备型号扩展至$BDA.deviceTypeID*/
    $.extend($BDA.deviceTypeID,{         /*默认均为false*/
        win: false,
        mac: false,
        /*移动设备*/
        IOS: false,
        Android: false,
        isMobile:false,
        isPad:false,
        check:function(deviceTypeID){
            var self = this;
            var ua = navigator.userAgent;
            var platform = navigator.platform;
            function systemType(){
                if(/Android/i.test(ua)){
                    self.Android = true;
                }
                if(/iPhone|iPad/i.test(ua)){
                    self.IOS = true;
                }
            }

            if(deviceTypeID==0){
                this.isMobile = true;
                systemType();
            }else if(deviceTypeID == 1) {
                this.isPad = true;
                systemType();
            }else if(deviceTypeID ==2){
                this.win = platform.indexOf('Win') == 0;
                this.mac = platform.indexOf('Mac') == 0;
            }
        }
    });

    /*JS和其他语言的交互*/
    $.extend($BDA.JS2Other,{
        bar:function(showOrHide){
            if($BDA.deviceTypeID.isMobile) {
                if($BDA.deviceTypeID.IOS&&window.webkit){                   /*IOS*/
                    try{
                        window.webkit.messageHandlers[showOrHide == 'show'?'showBar':'hideBar'].postMessage(null);
                    }catch (e){}
                    try{
                        window.webkit.messageHandlers[showOrHide == 'show'?'onFilterWindowClose':'onFilterWindowLoad'].postMessage(null);
                    }catch (e){}
                }else if($BDA.deviceTypeID.Android&&window.Android){         /*Android*/
                    try{
                        Android[showOrHide == 'show'?'showBar':'hideBar']();
                    }catch (e){}
                    try{
                        Android[showOrHide == 'show'?'onFilterWindowClose':'onFilterWindowLoad']();
                    }catch (e){}
                }
            }else{
                if($BDA.deviceTypeID.mac&&window.webkit){             /*mac机*/
                    window.webkit.messageHandlers[showOrHide == 'show'?'showIndicator':'hideIndicator'].postMessage(null);
                }
            }
        },
        show:function(){
            this.bar('show');
        },
        hide:function(){
            this.bar('hide');
        }
    });

    /*loading界面*/
    $.extend($BDA.loading,{
        open:function(){
            $('.page-loading').css('display','block');
        },
        close:function(){
            $('.page-loading').css('display','none');
        }
    });

    /*信息提示框*/
    $.extend($BDA.message,{
        open: function (strTitle,str) {
            if(str){
                $('.page-msg').css('display','block').find('.page-msg-content div p').html(str||'');
                $('.page-msg').find("h3 .msg-title").html(strTitle || "");
            }else{
                $('.page-msg').css('display','block').find('.page-msg-content div p').html(strTitle||'');
            }
            var msgCurrentHeight =  $('.page-msg .page-msg-content div p').height();
            var msgMaxHeight = Math.floor($(window).height() * 0.8) - 18 - 45;/*18为上内边距 45为下内边距*/
            if(msgCurrentHeight>msgMaxHeight){
                $('.page-msg-content div p').css({
                    'height': msgMaxHeight,
                    'overflow-y':'auto'
                });
            }
        },
        close: function () {
            $('.page-msg').css('display','none').find('.page-msg-content div p').html('');
            $('.page-msg-content div').removeAttr('style');
        }
    });
    /*关闭信息提示框事件*/
    $('.page-msg button').click($BDA.message.close);
    $('.page-msg span').click($BDA.message.close);

    /* BASE64 互转*/
    $BDA.Base64 = function(){

        /* private property*/
        var _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

        /* public method for encoding*/
        this.encode = function (input) {
            var output = "";
            var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
            var i = 0;
            input = _utf8_encode(input);
            while (i < input.length) {
                chr1 = input.charCodeAt(i++);
                chr2 = input.charCodeAt(i++);
                chr3 = input.charCodeAt(i++);
                enc1 = chr1 >> 2;
                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                enc4 = chr3 & 63;
                if (isNaN(chr2)) {
                    enc3 = enc4 = 64;
                } else if (isNaN(chr3)) {
                    enc4 = 64;
                }
                output = output +
                    _keyStr.charAt(enc1) + _keyStr.charAt(enc2) +
                    _keyStr.charAt(enc3) + _keyStr.charAt(enc4);
            }
            return output;
        };

        /* public method for decoding*/
        this.decode = function (input) {
            var output = "";
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = _keyStr.indexOf(input.charAt(i++));
                enc2 = _keyStr.indexOf(input.charAt(i++));
                enc3 = _keyStr.indexOf(input.charAt(i++));
                enc4 = _keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
            output = _utf8_decode(output);
            return output;
        };

        /* private method for UTF-8 encoding*/
        function _utf8_encode(string) {
            string = string.replace(/\r\n/g,"\n");
            var utftext = "";
            for (var n = 0; n < string.length; n++) {
                var c = string.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                } else if((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                } else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }

            }
            return utftext;
        }

        /* private method for UTF-8 decoding*/
        function _utf8_decode(utftext) {
            var string = "";
            var i = 0;
            var c = 0, c3 = 0, c2 = 0;
            while ( i < utftext.length ) {
                c = utftext.charCodeAt(i);
                if (c < 128) {
                    string += String.fromCharCode(c);
                    i++;
                } else if((c > 191) && (c < 224)) {
                    c2 = utftext.charCodeAt(i+1);
                    string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                    i += 2;
                } else {
                    c2 = utftext.charCodeAt(i+1);
                    c3 = utftext.charCodeAt(i+2);
                    string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                    i += 3;
                }
            }
            return string;
        }
    };

    /* 判断点在闭合多边形内*/
    $BDA.pointInsidePolygon = function(point, vs)  {
        var x = point[0], y = point[1];
        var inside = false;

        for (var i = 0, j = vs.length - 1; i < vs.length; j = i++) {
            var xi = vs[i][0], yi = vs[i][1];
            var xj = vs[j][0], yj = vs[j][1];
            var intersect = ((yi > y) != (yj > y)) && (x < (xj - xi) * (y - yi) / (yj - yi) + xi);
            if (intersect) inside = !inside;
        }

        return inside;
    };

    /*将格式化字符串方法添加至$BDA.formatString*/
    $.extend($BDA.formatString,{
        number : function(type,num){
            if (!type){return num;}
            if (num == null){return "";}
            if (typeof num === "undefined") return num;
            if (typeof num === 'string') return num;
            var decimalDigits = 0;       /* 小数位数*/
            var isNegative = false;

            if(type == '###0'){
                return num;
            }
            if(type.indexOf('E') != -1){
                if(type.indexOf('.') != -1){
                    decimalDigits = type.indexOf('E') - type.indexOf('.')-1;
                    num = num.toExponential(decimalDigits);
                }else{
                    num = num.toExponential();
                }
                return num;
            }
            if(num <= 0){
                isNegative = true;
                num = Math.abs(num);
            }
            if(type.indexOf('%') != -1){
                num = num * 100;
            }
            if(type.indexOf('.') != -1){
                decimalDigits = type.length - type.indexOf('.')-1;
                if(type.indexOf('%') != -1){
                    num = num.toFixed(decimalDigits-1);
                }else{
                    num = num.toFixed(decimalDigits);
                }
            }
            if(type.indexOf(',') != -1){
                var decimalString = "";

                num = num.toString();
                if(num.indexOf('.') != -1){
                    decimalString = num.substring(num.indexOf('.'));
                    num = num.substring(0,num.indexOf('.'));
                }
                var intString = num.toString(), result = '';
                while (intString.length > 3) {
                    result = ',' + intString.slice(-3) + result;
                    intString = intString.slice(0, intString.length - 3);
                }
                if (intString) { result = intString + result; }
                num = result + decimalString;

            }
            if(isNegative && num != 0){
                num = "-" + num;
            }
            if(type.indexOf('%') != -1){
                num = num + "%";
            }
            return num;
        },
        date : function(type,date){
            if (typeof date == 'string') return date;
            if(date == 'Invalid Date') return date;
            if (!date)return date;
            if (type == ''){
                return this.formatDay('YYYY-MM-dd',date);
            }else {
                if (type.indexOf('YYYY')!=-1&&type.indexOf('mm')!=-1){
                    var hourIndex = (type.indexOf('h') == -1?type.indexOf('H'):type.indexOf('h'));
                    var a = this.formatDay(type.slice(0,hourIndex),date);
                    var b = this.formatTime(type.slice(hourIndex),date);
                    return this.formatDay(type.slice(0,hourIndex),date)+this.formatTime(type.slice(hourIndex),date);
                }else{
                    if (type.indexOf('YYYY')!=-1){
                        return this.formatDay(type,date);
                    }else if (type.indexOf('mm')!=-1){
                        return this.formatTime(type,date);
                    }
                }
            }
            return date;
        },
        formatDay:function(type,date){
            var z ={
                Y:date.getFullYear(),
                M:date.getMonth()+1,
                d:date.getDate()
            };
            return type.replace(/(Y+|M+|d+)/g,function(v) {
                var a = (v.length>1?"0":"")+z[v.slice(-1)];
                var b = a.slice(-(v.length>2?v.length:2));
                return ((v.length>1?"0":"")+z[v.slice(-1)]).slice(-(v.length>2?v.length:2))
            });
        },
        formatTime:function(type,date){
            var z ={
                H:date.getHours(),
                h:date.getHours()%12,
                m:date.getMinutes(),
                s:date.getSeconds(),
                aa:['AM','PM']
            };
            return type.replace(/(H+|h+|m+|s+|aa)/g,function(v) {
                if (v=='aa'){
                    return z.aa[z.H>=12?1:0]
                }else{
                    var a = ((v.length>1?"0":"")+z[v.slice(-1)]);
                    var b = a.slice(-(v.length>2?v.length:2))
                    return ((v.length>1?"0":"")+z[v.slice(-1)]).slice(-(v.length>2?v.length:2));
                }
            });
        }
    });

    $BDA.reverseFormatting = function(val){
        if (typeof val==='number') return val;
        if(!val)return val;
        if(val.indexOf(',') != -1){
            var reverseVal = val.replace(/,/g,'');
            if(val.indexOf('%') != -1){
                reverseVal = parseFloat(reverseVal)/100;
            }
            return parseFloat(reverseVal);
        }else if(val.indexOf('%') != -1){
            return (parseFloat(val)/100);
        }else{
            return parseFloat(val);
        }
    };

    $BDA.intColorArrayToStringHex = function(colorArray,isTrue){
        var hexColorsArray = [];
        for(var i = 0; i < colorArray.length; i++){
            var red = (colorArray[i] >> 16) & 255;
            var green = (colorArray[i] >> 8) & 255;
            var blue = colorArray[i] & 255;

            hexColorsArray.push("rgb("+red+','+green+','+blue+")");
        }
        if(isTrue){
            return hexColorsArray;
        }else{
            return hexColorsArray.join(' ');
        }
    }

    $BDA.scatterMapSymbolType = function(symbolType){
        symbolType = symbolType || 0;
        switch (symbolType){
            case 0:
                return 'circle';
                break;
            case 1:
                return 'rect';
                break;
            case 2:
                return 'roundRect';
                break;
            case 3:
                return 'triangle';
                break;
            case 4:
                return 'diamond';
                break;
            case 5:
                return 'pin';
                break;
            case 6:
                return 'arrow';
                break;
        }
    }

    $BDA.set__proto__ = function(object){
        if("".__proto__ == String.prototype){
            object.prototype.__proto__ = Chart.prototype;
        }else{
            object.prototype = Chart.prototype;
        }
    };

    $BDA.setAll__proto__=function(){
        var allChart = [TileChart,VerticalTable,HorizontalTable,PivotTable,Histogram,AccumulateHistogram,PercentHistogram,
            BarChart,AccumulateBarChart,PercentBarChart,LineGraph,AreaGraph,HistogramLine,PieChart,Doughnut,
            Gauge,ScatterPlot,BubbleChart,Waterfall,RadarMap,RadarMap,FunnelPlot,FunnelPlot,PolarMap,EchartMap,
            AccumulateHistogramLine,PercentHistogramLine,Label,ScalableLineGraph,AdjustableLineGraph,VariablePie,
            PercentDoughnut,BulletChart,WheelFrame,WordCloud,WaterWaveChart,FoldingTable,TotalTable,SparkLine,ScatterMap,FreeCell,DateTimeControl,TreeMap,ReportContainer,BDAButton,PictureBox,
            SimpleBarChart, EquipmentRealTimeStatusChart, SimpleGanttChart, PictorialBar, EquipmentRunningStatusChart, TabControl, FreeTable, ProgressBar];
        for (var i=0;i<allChart.length;i++){
            $BDA.set__proto__(allChart[i]);
        }
    };

    //保存主题样式
    $BDA.theme = {};
    //themeID枚举
    $BDA.theme.themeIDs = [0,1,2];
    $BDA.theme.themeID = 0;
    $BDA.theme.currentBackgroundColor = null;
    $BDA.theme.highcharts = [
        {
            colors: "#DDDF0D #55BF3B #DF5353 #7798BF #aaeeee #ff0066 #eeaaee #55BF3B #DF5353 #7798BF #aaeeee".split(" "),
            chart: {
                backgroundColor: "#003271",
                borderColor: "#003271",
                borderWidth: 0,
                className: "dark-container",
                plotBackgroundColor: "#003271",
                plotBorderColor: "#003271",
                plotBorderWidth: 0
            },
            title: {
                style: {
                    color: "#C0C0C0"
                    //font: 'bold 16px "Trebuchet MS", Verdana, sans-serif'
                }
            },
            subtitle: {style: {color: "#666666", font: 'bold 12px "Trebuchet MS", Verdana, sans-serif'}},
            xAxis: {
                gridLineColor: "#333333",
                gridLineWidth: 1,
                labels: {style: {color: "#A0A0A0"}},
                lineColor: "#A0A0A0",
                tickWidth: 1,
                title: {
                    style: {
                        color: "#CCC",
                        fontWeight: "bold",
                        fontSize: "12px",
                        fontFamily: "Trebuchet MS, Verdana, sans-serif"
                    }
                }
            },
            yAxis: {
                gridLineColor: "#333333",
                labels: {style: {color: "#A0A0A0"}},
                lineColor: "#A0A0A0",
                minorTickInterval: null,
                tickColor: "#A0A0A0",
                tickWidth: 1,
                title: {
                    style: {
                        color: "#CCC",
                        fontWeight: "bold",
                        fontSize: "12px",
                        fontFamily: "Trebuchet MS, Verdana, sans-serif"
                    }
                }
            },
            tooltip: {backgroundColor: "rgba(0, 0, 0, 0.75)", style: {color: "#F0F0F0"}},
            toolbar: {itemStyle: {color: "silver"}},
            plotOptions: {
                line: {dataLabels: {color: "#e1e1e1"}, marker: {lineColor: "#333"}},
                spline: {marker: {lineColor: "#333"}},
                column:{dataLabels: {color: "#e1e1e1"},borderColor: "#003271"},
                pie:{dataLabels: {color: "#e1e1e1"},borderColor: "#003271"},
                bar:{dataLabels: {color: "#e1e1e1"},borderColor: "#003271"},
                area:{dataLabels: {color: "#e1e1e1"},borderColor: "#003271"},
                gauge: {
                    dial: {backgroundColor: '#fff'},
                    dataLabels:{color: "#e1e1e1",backgroundColor: '#003271'},
                    pivot:{backgroundColor: '#fff'}
                },
                scatter:{dataLabels: {color: "#e1e1e1"},borderColor: "#003271",marker: {lineColor: "#333"}},
                bubble:{dataLabels: {color: "#e1e1e1"},borderColor: "#003271"},
                waterfall:{dataLabels: {color: "#e1e1e1"},borderColor: "#003271"},
                funnel:{dataLabels: {color: "#e1e1e1"},borderColor: "#003271"}
            },
            legend: {
                itemStyle: { color: "#A0A0A0"},
                itemHoverStyle: {color: "#FFF"},
                itemHiddenStyle: {color: "#444"}
            },
            credits: {style: {color: "#666"}},
            labels: {style: {color: "#CCC"}},
            navigation: {
                buttonOptions: {
                    symbolStroke: "#DDDDDD",
                    hoverSymbolStroke: "#FFFFFF",
                    theme: {
                        fill: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4, "#606060"], [.6, "#333333"]]},
                        stroke: "#000000"
                    }
                }
            },
            rangeSelector: {
                buttonTheme: {
                    fill: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4, "#888"], [.6, "#555"]]},
                    stroke: "#000000",
                    style: {color: "#CCC", fontWeight: "bold"},
                    states: {
                        hover: {
                            fill: {
                                linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4,
                                    "#BBB"], [.6, "#888"]]
                            }, stroke: "#000000", style: {color: "white"}
                        },
                        select: {
                            fill: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.1, "#000"], [.3, "#333"]]},
                            stroke: "#000000",
                            style: {color: "yellow"}
                        }
                    }
                }, inputStyle: {backgroundColor: "#333", color: "silver"}, labelStyle: {color: "silver"}
            },
            navigator: {
                handles: {backgroundColor: "#666", borderColor: "#AAA"},
                outlineColor: "#CCC",
                maskFill: "rgba(16, 16, 16, 0.5)",
                series: {color: "#7798BF", lineColor: "#A6C7ED"}
            },
            scrollbar: {
                barBackgroundColor: {
                    linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4,
                        "#888"], [.6, "#555"]]
                },
                barBorderColor: "#CCC",
                buttonArrowColor: "#CCC",
                buttonBackgroundColor: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4, "#888"], [.6, "#555"]]},
                buttonBorderColor: "#CCC",
                rifleColor: "#FFF",
                trackBackgroundColor: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[0, "#000"], [1, "#333"]]},
                trackBorderColor: "#666"
            },
            legendBackgroundColor: "rgba(0, 0, 0, 0.5)",
            background2: "rgb(35, 35, 70)",
            dataLabelsColor: "#444",
            textColor: "#C0C0C0",
            maskColor: "rgba(255,255,255,0.3)",
            pane: {
                background:{
                    backgroundColor: '#003271'
                }
            }
        },
        {
            colors: "#2b908f #90ee7e #f45b5b #7798BF #aaeeee #ff0066 #eeaaee #55BF3B #DF5353 #7798BF #aaeeee".split(" "),
            chart: {
                backgroundColor: "#222",
                style: {fontFamily: "'Unica One', sans-serif"},
                plotBorderColor: "#222"
            },
            title: {
                style: {
                    color: "#E0E0E3",
                    textTransform: "uppercase"
                    //fontSize: "20px"
                }
            },
            subtitle: {style: {color: "#E0E0E3", textTransform: "uppercase"}},
            xAxis: {
                gridLineColor: "#707073",
                labels: {style: {color: "#E0E0E3"}},
                lineColor: "#707073",
                minorGridLineColor: "#505053",
                tickColor: "#707073",
                title: {style: {color: "#A0A0A3"}}
            },
            yAxis: {
                gridLineColor: "#707073",
                labels: {style: {color: "#E0E0E3"}},
                lineColor: "#707073",
                minorGridLineColor: "#505053",
                tickColor: "#707073",
                tickWidth: 1,
                title: {style: {color: "#A0A0A3"}}
            },
            tooltip: {backgroundColor: "rgba(0, 0, 0, 0.85)", style: {color: "#F0F0F0"}},
            plotOptions: {
                line: {dataLabels: {color: "#B0B0B3"}, marker: {lineColor: "#333"}},
                spline: {marker: {lineColor: "#333"}},
                column:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                pie:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                bar:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                area:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                gauge: {
                    dial: {backgroundColor: '#fff'},
                    dataLabels:{color: "#B0B0B3",backgroundColor: '#222'},
                    pivot:{backgroundColor: '#fff'}
                },
                scatter:{dataLabels: {color: "#B0B0B3"},borderColor: "#222",marker: {lineColor: "#333"}},
                bubble:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                waterfall:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                funnel:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"}
            },
            legend: {itemStyle: {color: "#E0E0E3"}, itemHoverStyle: {color: "#FFF"}, itemHiddenStyle: {color: "#606063"}},
            credits: {style: {color: "#666"}},
            labels: {style: {color: "#707073"}},
            drilldown: {activeAxisLabelStyle: {color: "#F0F0F3"}, activeDataLabelStyle: {color: "#F0F0F3"}},
            navigation: {
                buttonOptions: {
                    symbolStroke: "#DDDDDD",
                    theme: {fill: "#505053"}
                }
            },
            rangeSelector: {
                buttonTheme: {
                    fill: "#505053",
                    stroke: "#000000",
                    style: {color: "#CCC"},
                    states: {
                        hover: {fill: "#707073", stroke: "#000000", style: {color: "white"}},
                        select: {fill: "#000003", stroke: "#000000", style: {color: "white"}}
                    }
                },
                inputBoxBorderColor: "#505053",
                inputStyle: {backgroundColor: "#333", color: "silver"},
                labelStyle: {color: "silver"}
            },
            navigator: {
                handles: {backgroundColor: "#666", borderColor: "#AAA"},
                outlineColor: "#CCC",
                maskFill: "rgba(255,255,255,0.1)",
                series: {color: "#7798BF", lineColor: "#A6C7ED"},
                xAxis: {gridLineColor: "#505053"}
            },
            scrollbar: {
                barBackgroundColor: "#808083",
                barBorderColor: "#808083",
                buttonArrowColor: "#CCC",
                buttonBackgroundColor: "#606063",
                buttonBorderColor: "#606063",
                rifleColor: "#FFF",
                trackBackgroundColor: "#404043",
                trackBorderColor: "#404043"
            },
            legendBackgroundColor: "rgba(0, 0, 0, 0.5)",
            background2: "#505053",
            dataLabelsColor: "#B0B0B3",
            textColor: "#C0C0C0",
            contrastTextColor: "#F0F0F3",
            maskColor: "rgba(255,255,255,0.3)",
            pane: {
                background:{
                    backgroundColor: '#222'
                }
            }
        }
    ];
    $BDA.theme.defaultTheme = {
        colors: "#7cb5ec #434348 #90ed7d #f7a35c #8085e9 #f15c80 #e4d354 #2b908f #f45b5b #91e8e1".split(" ")
    }

    window.$BDA = $BDA;

})($,window);