function Report(reportID,basePath){
    this.reportID = reportID;
    this.basePath = basePath;
    this.domain = this.basePath + '/Report/reports/';
    this.uri = '/reportView';
    this.viewBusinessObjectHierarchies = {};
    this.reportView = {};
    this.charts = new Charts();
    /*暂定默认值*/
    this.pcPages = new PcPages();
    this.padPages = new PadPages();
    this.mobilePages = new MobilePages();
    this.viewBlocks = [];
    this.viewVerticalTableBlocks = new ViewVerticalTableBlocks();
    this.viewPivotTableBlocks = new ViewPivotTableBlocks();
    this.viewChartBlocks = new ViewChartBlocks();
    this.viewTileBlocks = new ViewTileBlocks();
    this.viewGaugeBlocks = new ViewGaugeBlocks();
    this.viewMapBlocks = new ViewMapBlocks();
    this.viewLabelBlocks = new ViewLabelBlocks();

    this.getReport = function(obj,deviceTypeID,succ){
        var me=this;
        var data = analogData;
        $BDA.loading.open();
        $BDA.loading.close();
        me.reportView = data.property;
        me.viewBusinessObjectHierarchies = data.property.viewBusinessObjectHierarchies;
        me.pcPages.getPages(data.property.pcPages) ;
        me.padPages.getPages(data.property.padPages) ;
        me.mobilePages.getPages(data.property.mobilePages) ;

        me.viewChartBlocks.getViewChartBlocks(data.property.viewChartBlocks);
        me.viewVerticalTableBlocks.getViewVerticalTableBlocks(data.property.viewVerticalTableBlocks);
        me.viewPivotTableBlocks.getViewPivotTableBlocks(data.property.viewPivotTableBlocks);
        me.viewTileBlocks.getViewTileBlocks(data.property.viewTileBlocks);
        me.viewGaugeBlocks.getViewGaugeBlocks(data.property.viewGaugeBlocks);
        me.viewMapBlocks.getViewMapBlocks(data.property.viewMapBlocks);
        me.viewLabelBlocks.getViewLabelBlocks(data.property.viewLabelBlocks);

        var pages = me[deviceTypeID==0?'mobilePages':deviceTypeID==1?'padPages':'pcPages'].aryPages;
        var arr = me.viewChartBlocks.aryViewChartBlocks.concat(
            me.viewVerticalTableBlocks.aryViewVerticalTableBlocks.concat(
                me.viewTileBlocks.aryViewTileBlocks.concat(
                    me.viewGaugeBlocks.aryViewGaugeBlocks.concat(
                        me.viewMapBlocks.aryViewMapBlocks.concat(
                            me.viewPivotTableBlocks.aryViewPivotTableBlocks.concat(
                                me.viewLabelBlocks.aryViewLabelBlocks
                            )
                        )
                    )
                )
            )
        );
        for (var i = 0,len = pages.length;i < len;i++){
            var blocksOfcurrentPage = [];
            for (var j = 0,jen = arr.length;j < jen;j++){
                if (pages[i].pageID === arr[j].blockLayouts[deviceTypeID].pageID){
                    blocksOfcurrentPage.push(arr[j]);
                }
            }
            var ken = blocksOfcurrentPage.length-1;
            if (ken == 0 ){
                me.viewBlocks.push(blocksOfcurrentPage[0])
            }else {
                for (var k = 0;k < ken;k++){
                    for (var n = k+1,nen = blocksOfcurrentPage.length;n < nen;n++){
                        var layout_k = blocksOfcurrentPage[k].blockLayouts[deviceTypeID],
                            layout_n = blocksOfcurrentPage[n].blockLayouts[deviceTypeID];
                        if (layout_k.top*12+layout_k.left>layout_n.top*12+layout_n.left){
                            blocksOfcurrentPage[k] = [blocksOfcurrentPage[n],blocksOfcurrentPage[n]=blocksOfcurrentPage[k]][0];
                        }
                    }
                }
                me.viewBlocks = me.viewBlocks.concat(blocksOfcurrentPage);
            }
        }
        me.charts.getCharts(me.viewBlocks);

        /*如果MapBlock个数不为0并且echarts未加载过，则加载echarts框架*/
        if (me.viewMapBlocks.count&&!window.echarts){
            $.getScript('../js/echarts.min.js',(function(str,textStatus){
                if(textStatus == 'success'){
                    var script = document.createElement('script');
                    script.type = "text/javascript";
                    script.innerHTML = str;
                    document.body.appendChild(script);
                    succ();
                }
            }));
        }else {
            succ();
        }
    };
}

/*类---chart*/
function Chart(strType, strBDAChartID, strTitle, viewBlock, colors){
    this.type = strType;
    this.chartID = strBDAChartID || '';
    this.title = strTitle || '';
    this.data = {sum: 0, itemCount: 0, items: []};
    this.colors = colors || {};
}

Chart.prototype = {
    draw : function(){},
    move : function(fltX, fltY){},
    touchStart : function(fltX, fltY){},
    touchMove : function(fltX, fltY){},
    touchEnd : function(){},
    changeDimension : function(){},
    changeMeasure : function(){},
    changeGrouping : function(){},
    selectChart : function(){
        $(this.chartID).addClass("bda-chart-selected"); /*选中*/
    },
    unSelectChart : function(){
        $(this.chartID).removeClass("bda-chart-selected");  /*除去选中*/
    },
    setChartTitleContent : function(){
        $(this.chartID).find('h3 span').html(this.viewBlock.title||'');
    },
    setChartTitleStyle : function(length){
        var titleTextBox = this.viewBlock.titleTextBox;
        $(this.chartID).find('h3').css({
            'height':length>0?'40px':titleTextBox.height,
            'background-color': $BDA.cNet2rgba(titleTextBox.backgroundColor) || '#FFFFFF',
            'color': $BDA.cNet2rgba(titleTextBox.color) || '#7d7d7d',
            'font-family': titleTextBox.font.fontFamily || 'Arial',
            'font-size': (titleTextBox.font.size >40)?'40px': titleTextBox.font.size,
            'font-weight': titleTextBox.font.bold?'bold':'normal',
            'font-style': titleTextBox.font.italic?'italic':'normal',
            'text-decoration': titleTextBox.font.underline?'underline':(titleTextBox.font.strikeout?'line-through':'none'),
            'text-align': titleTextBox.textAlign == "0"?'left':(titleTextBox.textAlign == "1"?'center':'right'),
            'border-radius': titleTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
        });
        $(this.chartID).find('.chart-drill-toolbar').css({
            'width':titleTextBox.height*0.8,
            'height':titleTextBox.height*0.8
        }).find('span').css({
            'width':titleTextBox.height*0.8,
            'height':titleTextBox.height*0.8,
            'background-size':titleTextBox.height*0.6
        });
        $(this.chartID).find('.chart-link-toolbar').css({
            'width':titleTextBox.height*0.8,
            'height':titleTextBox.height*0.8
        }).find('span').css({
            'width':titleTextBox.height*0.8,
            'height':titleTextBox.height*0.8,
            'background-size':titleTextBox.height*0.6
        });
        if (titleTextBox.adjustWidthAccordingToText){
            $(this.chartID).find('h3').css({
                'background-color': '#FFFFFF',
                'border-radius': 0
            }).find('span').css({
                'background-color': $BDA.cNet2rgba(titleTextBox.backgroundColor),
                'border-radius': titleTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
            });
        }
        if($BDA.theme.currentBackgroundColor){
            $(this.chartID).find('h3').css({
                'background-color': $BDA.theme.currentBackgroundColor,
                'color': "#fff"
            });
        }
    },
    setChartSubtitleContent:function(){
        if (!this.viewBlock.subtitle)return;
        $(this.chartID).find('h5').css('display','block').find('span').html(this.viewBlock.subtitle||'');
    },
    setChartSubtitleStyle:function(){
        if (!this.viewBlock.subtitle)return;
        var subtitleTextBox = this.viewBlock.subtitleTextBox;
        $(this.chartID).find('h5').css({
            'height': subtitleTextBox.height,
            'background-color': $BDA.cNet2rgba(subtitleTextBox.backgroundColor) || '#FFFFFF',
            'color': $BDA.cNet2rgba(subtitleTextBox.color) || '#7d7d7d',
            'font-family': subtitleTextBox.font.fontFamily || 'Arial',
            'font-size': subtitleTextBox.font.size || '12px',
            'font-weight': subtitleTextBox.font.bold?'bold':'normal',
            'font-style': subtitleTextBox.font.italic?'italic':'normal',
            'text-decoration': subtitleTextBox.font.underline?'underline':(subtitleTextBox.font.strikeout?'line-through':'none'),
            'text-align': subtitleTextBox.textAlign == "0"?'left':(subtitleTextBox.textAlign == "1"?'center':'right'),
            'border-radius': subtitleTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
        });
        if (subtitleTextBox.adjustWidthAccordingToText){
            $(this.chartID).find('h5').css({
                'background-color': '#FFFFFF',
                'border-radius': 0
            }).find('span').css({
                'background-color': $BDA.cNet2rgba(subtitleTextBox.backgroundColor),
                'border-radius': subtitleTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
            });
        }
        if($BDA.theme.currentBackgroundColor){
            $(this.chartID).find('h5').css({
                'background-color': $BDA.theme.currentBackgroundColor,
                'color': "#fff"
            });
        }
    },
    setChartMarkContent : function(){
        if (!this.viewBlock.remark)return;
        $(this.chartID).find('.bda-remark').html(this.viewBlock.remark.replace(/\r\n/g,'<br/>')).css('display','block');
    },
    setChartMarkStyle : function(){
        if (this.viewBlock.remark){
            var remarkTextBox = this.viewBlock.remarkTextBox;
            $(this.chartID).find('.bda-remark').css({
                'background-color': $BDA.cNet2rgba(remarkTextBox.backgroundColor) || '#FFFFFF',
                'font-family': remarkTextBox.font.fontFamily || 'Arial',
                'font-size': remarkTextBox.font.size || '12px',
                'font-weight': remarkTextBox.font.bold?'bold':'normal',
                'font-style': remarkTextBox.font.italic?'italic':'normal',
                'text-decoration': remarkTextBox.font.underline?'underline':(remarkTextBox.font.strikeout?'line-through':'none'),
                'color': $BDA.cNet2rgba(remarkTextBox.color) || '#7d7d7d',
                'border-top':'1px solid #ddd',
                'margin': '0 10px',
                'padding': '5px 0',
                'border-radius': remarkTextBox.borderRadius.replace(/\,/g,'px ') + 'px'
            })
        }
        if($BDA.theme.currentBackgroundColor){
            $(this.chartID).find('.bda-remark').css({
                'background-color': $BDA.theme.currentBackgroundColor,
                'color': "#fff",
                'border-top':'1px solid #fff'
            });
        }
    },
    setChartContentHeight : function(fltHeight){
        var fltChartContentWidth = parseFloat($(this.chartID).find(".bda-chart-box").width());
        var fltChartHeight = fltHeight - parseFloat($(this.chartID).css("margin-top")) - parseFloat($(this.chartID).css("margin-bottom"));
        var fltTitleHeight = $(this.chartID).find("h3").height();
        var jqueryH5 = $(this.chartID).find("h5");
        var fltSubtitleHeight = jqueryH5.height()*(jqueryH5.css("display") == "none"?0:1);
        var fltMarkHeight = $(this.chartID).find(".bda-remark").height()?($(this.chartID).find(".bda-remark").height()+11):0;
        if ($(this.chartID).find(".bda-data").css("display") == "none"){
            var fltDataHeight = 0;
        }else {
            var fltDataHeight = parseFloat($(this.chartID).find(".bda-data").css("height"));
        }
        var fltChartBoxPaddingTop = parseFloat($(this.chartID).find(".bda-chart-box").css("padding-top"));
        var fltChartContentHeight = fltChartHeight - fltTitleHeight - fltSubtitleHeight - fltDataHeight - fltChartBoxPaddingTop-fltMarkHeight;
        if (this.type == "pie"){
            fltChartContentHeight = Math.min(fltChartContentHeight, fltChartContentWidth)
        }

        $(this.chartID).css("height", fltChartHeight);
        $(this.chartID).find(".bda-chart-content").css("height", fltChartContentHeight);
    }
};

function Charts(){
    this.count = 0;
    this.dicCharts = {};
    this.aryCharts = [];

    this.add = function (chart) {
        this.aryCharts.push(chart);
        this.dicCharts['_' + chart.chartID]=chart;

        this.count = this.aryCharts.length;
    };
    this.remove = function (chart) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryCharts[i].chartID==chart.chartID){
                k=i;
                break;
            }
        }
        this.aryCharts.splice(k,1);
        delete this.dicCharts['_' + chart.chartID];

        this.count=this.aryCharts.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryCharts[indexOrKey];
        }else{
            return this.dicCharts[indexOrKey];
        }
    };
    this.getCharts = function (viewBlocks) {
        for(var intI = 0; intI < viewBlocks.length; intI++ ){
            var chart = $BDA.chart.newChart( viewBlocks[intI].chartID,'#bda-chart'+intI, viewBlocks[intI].title, viewBlocks[intI]);
            this.add(chart);
        }
    };
}

/*类---块*/
function Block(options){
    this.queryIDs = options.queryIDs;
    this.blockID = options.blockID;
    this.chartID = options.chartID;
    this.blockLayouts = options.blockLayouts;
    this.blockData = options.blockData;
    this.reportLink = options.reportLink;
}

/*类---标题*/
function BlockTitle(options){
    this.title = options.title;
    this.titleTextBox = options.titleTextBox;
}

/*类---副标题*/
function Subtitle(options){
    this.subtitle = options.subtitle;
    this.subtitleTextBox = options.subtitleTextBox;
}

/*类---标记区*/
function Mark(options){
    this.remark = options.remark;
    this.remarkTextBox = options.remarkTextBox;
}

/*类---图形块*/   //options
function ViewChartBlock(options){

    Block.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.primaryDimension = options.primaryDimension;
    this.groupDimension = options.groupDimension;
    this.y1Measures = options.y1Measures;
    this.y2Measures = options.y2Measures;
    this.y3Measures = options.y3Measures;
    this.y1DataFormat = options.y1DataFormat;
    this.y2DataFormat = options.y2DataFormat;
    this.y3DataFormat = options.y3DataFormat;
}

function ViewChartBlocks(){
    this.count = 0;
    this.dicViewChartBlocks = {};
    this.aryViewChartBlocks = [];

    this.add = function (block) {
        this.aryViewChartBlocks.push(block);
        this.dicViewChartBlocks[block.blockID]=block;

        this.count = this.aryViewChartBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewChartBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewChartBlocks.splice(k,1);
        delete this.dicViewChartBlocks[block.blockID];

        this.count=this.aryViewChartBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewChartBlocks[indexOrKey];
        }else{
            return this.dicViewChartBlocks[indexOrKey];
        }
    };
    this.getViewChartBlocks = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewChartBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

function ChartStyle(options){
    this.legendShow = options.legendShow;
    this.legendPosition = options.legendPosition;
    this.dataShow = options.dataShow;
    this.dataHoverShow = options.dataHoverShow;
    this.axisLabelShow = options.axisLabelShow;
}

/*类---表格块*/
function ViewVerticalTableBlock(options){

    Block.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.viewTableHead = options.viewTableHead;
    this.viewTableBody = options.viewTableBody;
    this.viewTableFoot = options.viewTableFoot;
    this.viewTableWarnings = options.viewTableWarnings;
    this.autoMergeDimensionCells = options.autoMergeDimensionCells;
    this.showColumnBarForMeasure = options.showColumnBarForMeasure;
    this.positiveColumnBarColor = options.positiveColumnBarColor;
    this.negativeColumnBarColor = options.negativeColumnBarColor;
    this.notShowBorderOfDetailTableCell = options.notShowBorderOfDetailTableCell;
    this.columnBarMaxLength = options.columnBarMaxLength;
    this.tBodyScrolling = options.tBodyScrolling;
    this.scrollTimePerLine = options.scrollTimePerLine;
}

function ViewVerticalTableBlocks(){
    this.count = 0;
    this.dicViewVerticalTableBlocks = {};
    this.aryViewVerticalTableBlocks = [];

    this.add = function (block) {
        this.aryViewVerticalTableBlocks.push(block);
        this.dicViewVerticalTableBlocks[block.blockID]=block;

        this.count = this.aryViewVerticalTableBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewVerticalTableBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewVerticalTableBlocks.splice(k,1);
        delete this.dicViewVerticalTableBlocks[block.blockID];

        this.count=this.aryViewVerticalTableBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewVerticalTableBlocks[indexOrKey];
        }else{
            return this.dicViewVerticalTableBlocks[indexOrKey];
        }
    };
    this.getViewVerticalTableBlocks = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewVerticalTableBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

/*类---透视表*/
function ViewPivotTableBlock(options){
    Block.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.rowDimensions = options.rowDimensions;
    this.columnDimensions = options.columnDimensions;
    this.viewVerticalTableBlock = options.viewVerticalTableBlock;
    this.showCrossTableHead = options.showCrossTableHead;
    this.totalBackgroundColor = options.totalBackgroundColor;
    this.totalColor = options.totalColor;
    this.totalFont = options.totalFont;
    this.tableHeadBackgroundColor = options.tableHeadBackgroundColor;
    this.tableHeadColor = options.tableHeadColor;
    this.tableHeadFont = options.tableHeadFont;
}

function ViewPivotTableBlocks(){
    this.count = 0;
    this.dicViewPivotTableBlocks = {};
    this.aryViewPivotTableBlocks = [];

    this.add = function (block) {
        this.aryViewPivotTableBlocks.push(block);
        this.dicViewPivotTableBlocks[block.blockID]=block;

        this.count = this.aryViewPivotTableBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewPivotTableBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewPivotTableBlocks.splice(k,1);
        delete this.dicViewPivotTableBlocks[block.blockID];

        this.count=this.aryViewPivotTableBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewPivotTableBlocks[indexOrKey];
        }else{
            return this.dicViewPivotTableBlocks[indexOrKey];
        }
    };
    this.getViewPivotTableBlocks = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewPivotTableBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

/*类---磁贴块*/
function ViewTileBlock(options){

    Block.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.formatString = options.formatString;
    this.measure1 = options.measure1;
    this.measure2 = options.measure2;
    this.measure3 = options.measure3;
    this.measure4 = options.measure4;
    this.measure5 = options.measure5;
    this.measure6 = options.measure6;
    this.measure7 = options.measure7;
    this.alert2 = options.alert2;
    this.alert3 = options.alert3;
    this.alert4 = options.alert4;
    this.alert5 = options.alert5;
    this.alert6 = options.alert6;
    this.alert7 = options.alert7;
    this.label2 = options.label2;
    this.label3 = options.label3;
    this.label4 = options.label4;
    this.label5 = options.label5;
    this.label6 = options.label6;
    this.label7 = options.label7;
    this.textBox1 = options.textBox1;
    this.textBox2 = options.textBox2;
    this.textBox3 = options.textBox3;
    this.textBox4 = options.textBox4;
    this.textBox5 = options.textBox5;
    this.textBox6 = options.textBox6;
    this.textBox7 = options.textBox7;
}

function ViewTileBlocks(){
    this.count = 0;
    this.dicViewTileBlocks = {};
    this.aryViewTileBlocks = [];

    this.add = function (block) {
        this.aryViewTileBlocks.push(block);
        this.dicViewTileBlocks[block.blockID]=block;

        this.count = this.aryViewTileBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewTileBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewTileBlocks.splice(k,1);
        delete this.dicViewTileBlocks[block.blockID];

        this.count=this.aryViewTileBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewTileBlocks[indexOrKey];
        }else{
            return this.dicViewTileBlocks[indexOrKey];
        }
    };
    this.getViewTileBlocks = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewTileBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

/*类---仪表盘块*/
function ViewGaugeBlock(options){

    Block.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.formatString = options.formatString;
    this.measure = options.measure;
    this.viewGaugeWarning = options.viewGaugeWarning;
}

function ViewGaugeBlocks(){
    this.count = 0;
    this.dicViewGaugeBlocks = {};
    this.aryViewGaugeBlocks = [];

    this.add = function (block) {
        this.aryViewGaugeBlocks.push(block);
        this.dicViewGaugeBlocks[block.blockID]=block;

        this.count = this.aryViewGaugeBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewGaugeBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewGaugeBlocks.splice(k,1);
        delete this.dicViewGaugeBlocks[block.blockID];

        this.count=this.aryViewGaugeBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewGaugeBlocks[indexOrKey];
        }else{
            return this.dicViewGaugeBlocks[indexOrKey];
        }
    };
    this.getViewGaugeBlocks = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewGaugeBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

/*类---地图块*/
function ViewMapBlock(options){

    Block.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.formatString = options.formatString;
    this.mapCode = options.mapCode;
    this.parentID = options.parentID;
    this.mainMeasure = options.mainMeasure;
    this.otherMeasures = options.otherMeasures;
    this.locationDimension = options.locationDimension;
    this.viewGeographyDataCompares = options.viewGeographyDataCompares;
    this.geoLevel = options.geoLevel;
    this.haveChildMap = options.haveChildMap;
}

function ViewMapBlocks(){
    this.count = 0;
    this.dicViewMapBlocks = {};
    this.aryViewMapBlocks = [];

    this.add = function (block) {
        this.aryViewMapBlocks.push(block);
        this.dicViewMapBlocks[block.blockID]=block;

        this.count = this.aryViewMapBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewMapBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewMapBlocks.splice(k,1);
        delete this.dicViewMapBlocks[block.blockID];

        this.count=this.aryViewMapBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewMapBlocks[indexOrKey];
        }else{
            return this.dicViewMapBlocks[indexOrKey];
        }
    };
    this.getViewMapBlocks = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewMapBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

function ViewLabelBlock(options){
    Block.call(this,options);
    BlockTitle.call(this,options);
    Subtitle.call(this,options);
    Mark.call(this,options);

    this.labelContent = options.labelContent;
    this.labelTextBox = options.labelTextBox;
}

function ViewLabelBlocks(){
    this.count = 0;
    this.dicViewLabelBlocks = {};
    this.aryViewLabelBlocks = [];

    this.add = function (block) {
        this.aryViewLabelBlocks.push(block);
        this.dicViewLabelBlocks[block.blockID]=block;

        this.count = this.aryViewLabelBlocks.length;
    };
    this.remove = function (block) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryViewLabelBlocks[i].blockID==block.blockID){
                k=i;
                break;
            }
        }
        this.aryViewLabelBlocks.splice(k,1);
        delete this.dicViewLabelBlocks[block.blockID];

        this.count=this.aryViewLabelBlocks.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryViewLabelBlocks[indexOrKey];
        }else{
            return this.dicViewLabelBlocks[indexOrKey];
        }
    };
    this.getViewLabelBlocks = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var block = new ViewLabelBlock(data[intI]);
            block.ChartStyle = new ChartStyle(data[intI]);
            this.add(block);
        }
    };
}

/*类---Page*/
function Page(options){
    this.pageID = options.pageID;
    this.rows = options.rows;
    this.columns = options.columns;
}

function PcPages(){
    this.count = 0;
    this.dicPages = {};
    this.aryPages = [];

    this.add = function (page) {
        this.aryPages.push(page);
        this.dicPages[page.pageID]=page;

        this.count = this.aryPages.length;
    };
    this.remove = function (page) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPages[i].pageID==page.pageID){
                k=i;
                break;
            }
        }
        this.aryPages.splice(k,1);
        delete this.dicPages[page.pageID];

        this.count=this.aryPages.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPages[indexOrKey];
        }else{
            return this.dicPages[indexOrKey];
        }
    };
    this.getPages = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var page = new Page(data[intI]);
            this.add(page);
        }
    };
}

function PadPages(){
    this.count = 0;
    this.dicPages = {};
    this.aryPages = [];

    this.add = function (page) {
        this.aryPages.push(page);
        this.dicPages[page.pageID]=page;

        this.count = this.aryPages.length;
    };
    this.remove = function (page) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPages[i].pageID==page.pageID){
                k=i;
                break;
            }
        }
        this.aryPages.splice(k,1);
        delete this.dicPages[page.pageID];

        this.count=this.aryPages.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPages[indexOrKey];
        }else{
            return this.dicPages[indexOrKey];
        }
    };
    this.getPages = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var page = new Page(data[intI]);
            this.add(page);
        }
    };
}

function MobilePages(){
    this.count = 0;
    this.dicPages = {};
    this.aryPages = [];

    this.add = function (page) {
        this.aryPages.push(page);
        this.dicPages[page.pageID]=page;

        this.count = this.aryPages.length;
    };
    this.remove = function (page) {
        for(var i= 0,len=this.count,k;i<len;i++){
            if(this.aryPages[i].pageID==page.pageID){
                k=i;
                break;
            }
        }
        this.aryPages.splice(k,1);
        delete this.dicPages[page.pageID];

        this.count=this.aryPages.length;
    };
    this.item = function (indexOrKey) {
        if(typeof indexOrKey == 'number'){
            return this.aryPages[indexOrKey];
        }else{
            return this.dicPages[indexOrKey];
        }
    };
    this.getPages = function (data) {
        for(var intI = 0; intI < data.length; intI++ ){
            var page = new Page(data[intI]);
            this.add(page);
        }
    };
}