(function($,$BDA,window,undefined){
    $BDA.setAll__proto__();
    $('.page-msg,.filter-page,.filter-page-pc,.drill-page').removeAttr('style');
    var document = window.document;
    var reportID = 0,filterObj={},deviceTypeID= 0,basePath = '';

    $BDA.theme.themeID&&($BDA.theme.currentBackgroundColor = $BDA.theme.themeID == 1?"#003271":"#222");

    var report = new Report(reportID,basePath);

    var fltDeviceWidth = window.screen.width;
    var fltDeviceHeight = window.screen.height;
    var fltClientWidth = document.documentElement.clientWidth;
    var fltClientHeight = document.documentElement.clientHeight;

    var fltDefaultClientHeightPercent = 0.5;
    var fltChartDefaultHeight = fltClientHeight * fltDefaultClientHeightPercent;
    var fltMagnifyClientHeightPercent = 0.75;
    var fltChartMagnifyHeight = fltClientHeight * fltMagnifyClientHeightPercent;
    var fltChartVSHeight = fltClientWidth;
    var hasSelected = false;

    var landscapeWidth = 0;

    var strChartID = '#bda-chartID';
    var chart = new Chart();
    var intChartIndex = -1;

    var fltOffX = 0;
    var fltOffY = 0;
    var fltOffTop = 0;
    var fltMarginLeft = 0;
    var blnIsLandScape = false;
    var intDefaultLandscapeChartID = -1;
    var drillList = [];

    report.getReport(filterObj,deviceTypeID,function(){
        initStructure(report,deviceTypeID);
        initCharts(fltChartDefaultHeight);
        chartInterface($('.container'));
    });

    function initStructure(report,deviceTypeID){
        $BDA.dynamic.createRow($('.rotation'),report[deviceTypeID==0?'mobilePages':'padPages'].aryPages);
        $BDA.dynamic.createChart(report.viewBlocks,deviceTypeID,fltClientHeight);

        deviceTypeID!=0&&$('.row').css('height',fltClientHeight);
        setReportTheme();
    }

    function setReportTheme(){
        $BDA.theme.themeID&&Highcharts.setOptions($BDA.theme.highcharts[$BDA.theme.themeID-1]);
        if ($BDA.theme.themeID == 1){
            $("body,.filter-page,.drill-page,.bda-chart").addClass("theme-darkBlue");
            $('.drill-close-mobile img').attr('src','../img/drill-close-white.png');
        }else if ($BDA.theme.themeID == 2){
            $("body,.filter-page,.drill-page,.bda-chart").addClass("theme-pearlBlack");
            $('.drill-close-mobile img').attr('src','../img/drill-close-white.png');
        }
    }

    function initCharts(fltChartHeight){
        var intLength = report.charts.count;
        if(deviceTypeID==1){
            $('.bda-chart').css('padding','0 6px');
        }
        for (var intI = 0; intI < intLength; intI++){
            chart = report.charts.aryCharts[intI];
            strChartID = '#bda-chart' + intI;
            fltOffX = parseFloat($(strChartID).find(".bda-chart-box").offset().left);
            fltOffY = parseFloat($(strChartID).find(".bda-chart-box").offset().top) + parseFloat($(strChartID).find(".bda-chart-box").css("paddingTop"));

            if(intI != intDefaultLandscapeChartID){
                drawBlock(deviceTypeID==0&&report.charts.count!=1?fltChartHeight:$(strChartID).height());
            }
        }
        if (deviceTypeID==0&&report.charts.count==1){
            chart.selectChart();
            if (chart.type ==1||chart.type==2||chart.type==3){
                $(chart.chartID).find('.chart-link-toolbar').css('display','none');
            }else{
                $(chart.chartID).find('.chart-drill-toolbar span').css('background-image','url(../img/magnify-'+($BDA.theme.themeID?'white':'blue')+'.png)');
                $(chart.chartID).find('.chart-link-toolbar span').css('background-image','url(../img/link-'+(chart.viewBlock.reportLink?($BDA.theme.themeID?'white':'blue'):'gray')+'.png)');
            }
        }
    }

    function drawBlock(height,openDrilldown,hierarchies){
        chart.setChartTitleContent();
        chart.setChartTitleStyle(drillList.length);
        chart.setChartSubtitleContent();
        chart.setChartSubtitleStyle();
        chart.setChartMarkContent();
        chart.setChartMarkStyle();
        chart.draw(height,openDrilldown,hierarchies);
    }

    function chartInterface(jqueryElement){
        jqueryElement.find(".bda-chart .bda-dimension").click(function(e){
            if($(this).parents('.bda-chart').hasClass("bda-chart-selected")){
                chart.changeDimension();
                e.stopPropagation();
            }
        });

        jqueryElement.find(".bda-chart .bda-measure").click(function(e){
            if ($(this).parents('.bda-chart').hasClass("bda-chart-selected")){
                chart.changeMeasure();
                e.stopPropagation();
            }
        });

        jqueryElement.find(".bda-chart .bda-grouping").click(function(e){
            if($(this).parents('.bda-chart').hasClass("bda-chart-selected")){
                if($(this).parents('.bda-chart').hasClass("averageLine")){
                    chart.selecteAverageLine();
                }else{
                    chart.changeGrouping();
                    e.stopPropagation();
                }
            }
        });

        jqueryElement.find(".bda-chart-content").each(function(){
            this.addEventListener("touchstart", function(e){
                if ($(this).parents(".bda-chart").hasClass("bda-chart-selected")){
                    chart.touchStart( e.touches[0].pageX - (blnIsLandScape?0:fltOffX), e.touches[0].pageY - fltOffY);
                    e.stopPropagation();
                }
            });
        });

        jqueryElement.find(".bda-chart-content").each(function(){
            this.addEventListener("touchmove", function (e) {
                if ($(this).parents(".bda-chart").hasClass("bda-chart-selected")) {
                    if (e.targetTouches.length == 1) {
                        chart.touchMove(e.touches[0].pageX - (blnIsLandScape ? 0 : fltOffX), e.touches[0].pageY - fltOffY);
                        e.stopPropagation();
                    }
                }
            });
        });

        jqueryElement.find(".bda-chart-content").each(function(){
            this.addEventListener("touchend", function (e) {
                if ($(this).parents(".bda-chart").hasClass("bda-chart-selected")) {
                    chart.touchEnd(e);
                    e.stopPropagation();
                }
            });
        });
    }

})($,$BDA,window);