/**
 * Created by Administrator on 2017/2/28.
 */
function Color(colorID, colorValue){
    this.colorID = colorID || 0;
    this.colorValue = colorValue || '';
};

function Colors(){
    me = this;
    this.count = 0;
    this.dicColors = {};
    this.aryColors = [];

    if(typeof this.add!='function') {
        Colors.prototype.add = function (color) {
            this.aryColors.push(color);  //unshift 返回值即为新数组的长度
            var newKey='_'+color.colorID;
            this.dicColors[newKey]=color;

            this.count = this.aryColors.length;
        }
        Colors.prototype.remove = function (color) {
            for(var i= 0,len=this.count,k;i<this.count;i++){
                if(this.aryColors[i].colorID==color.colorID){
                    k=i;
                    break;
                }
            }
            this.aryColors.splice(k,1);
            delete this.dicColors['_'+colorID];

            this.count=this.aryColors.length;
        }
        Colors.prototype.item = function (indexOrKey) {
            if(typeof indexOrKey=='number'){
                return this.aryColors[indexOrKey];
            }else{
                return this.dicColors[indexOrKey];
            }
        }

        Colors.prototype.getAll = function () {
            var colorsJson = {"data":[
                {colorID:0, colorValue:"#32557e"},
                {colorID:1, colorValue:"#803331"},
                {colorID:2, colorValue:"#677d39"},
                {colorID:3, colorValue:"#54416b"},
                {colorID:4, colorValue:"#2f7284"},
                {colorID:5, colorValue:"#a6632c"},
                {colorID:6, colorValue:"#39608e"},
                {colorID:7, colorValue:"#39759e"},
                {colorID:8, colorValue:"#39908e"},
                {colorID:9, colorValue:"#5f4979"},
                {colorID:10, colorValue:"#368195"},
                {colorID:11, colorValue:"#ba7032"},
                {colorID:12, colorValue:"#40699c"},
                {colorID:13, colorValue:"#40699c"},
                {colorID:14, colorValue:"#7f9a48"},
                {colorID:15, colorValue:"#695185"},
                {colorID:16, colorValue:"#3c8da3"},
                {colorID:17, colorValue:"#cc7b38"},
                {colorID:18, colorValue:"#4572a7"},
                {colorID:19, colorValue:"#aa4643"},
                {colorID:20, colorValue:"#89a54e"},
                {colorID:21, colorValue:"#71588f"},
                {colorID:22, colorValue:"#4198af"},
                {colorID:23, colorValue:"#db843d"},
                {colorID:24, colorValue:"#4a7ab2"},
                {colorID:25, colorValue:"#b54b48"},
                {colorID:26, colorValue:"#92b154"},
                {colorID:27, colorValue:"#795e99"},
                {colorID:28, colorValue:"#46a2bb"},
                {colorID:29, colorValue:"#e98d42"},
                {colorID:30, colorValue:"#4f81bd"},
                {colorID:31, colorValue:"#c0504d"},
                {colorID:32, colorValue:"#9bbb59"},
                {colorID:33, colorValue:"#8064a2"},
                {colorID:34, colorValue:"#4bacc6"},
                {colorID:35, colorValue:"#f79646"},
                {colorID:36, colorValue:"#7696c6"},
                {colorID:37, colorValue:"#c87674"},
                {colorID:38, colorValue:"#aac47b"},
                {colorID:39, colorValue:"#9582b0"},
                {colorID:40, colorValue:"#73b8cd"},
                {colorID:41, colorValue:"#f8a671"},
                {colorID:42, colorValue:"#93a9cf"},
                {colorID:43, colorValue:"#d19392"},
                {colorID:44, colorValue:"#b9cd96"},
                {colorID:45, colorValue:"#a99bbd"},
                {colorID:46, colorValue:"#91c3d5"},
                {colorID:47, colorValue:"#f9b590"},
                {colorID:48, colorValue:"#aabad7"},
                {colorID:49, colorValue:"#d9aaa9"},
                {colorID:50, colorValue:"#c6d6ac"},
                {colorID:51, colorValue:"#bab0c9"},
                {colorID:52, colorValue:"#a9cedc"},
                {colorID:53, colorValue:"#fac3a8"},
                {colorID:54, colorValue:"#bcc8df"},
                {colorID:55, colorValue:"#e0bcbc"},
                {colorID:56, colorValue:"#d1debe"},
                {colorID:57, colorValue:"#c8c0d4"},
                {colorID:58, colorValue:"#bbd7e3"},
                {colorID:59, colorValue:"#fbcfba"}
            ]};

            fillProperties(colorsJson);
        }

        function fillProperties(colorsJson){
            var intI = 0;
            var intLength = colorsJson.data.length || 0;

            for(intI = 0; intI < intLength; intI++ ){
                var color = new Color(colorsJson.data[intI].colorID, colorsJson.data[intI].colorValue);
                me.add(color);
            }
        }
    }
}
