(function(window,$,undefined){
    var document = window.document,
        navigator = window.navigator,
        DEVICE_HEIGHT = document.documentElement.clientHeight;

    var $BDA = {
        DEVICE_HEIGHT:DEVICE_HEIGHT,   /*默认高度*/
        chart:{},                      /*图形相关*/
        dynamic:{},                    /*动态生成方法*/
        deviceTypeID:{},                 /*设备系统类型*/
        JS2Other:{},                   /*JS和其他语言的交互*/
        loading:{},                    /*loading界面*/
        message:{},                    /*信息提示框*/
        request:{},                    /*http请求*/
        formatString:{}                /*格式化字符串*/
    };
    /*千位符*/
    $BDA.format = function(num){
        var str = (num||0).toString(), result='',floatPart='',intPart= str;
        var scalingPosition = str.indexOf('.'); /*小数点位置*/
        if(scalingPosition!=-1){
            intPart = str.slice(0,scalingPosition);
            floatPart = str.slice(scalingPosition);
        }
        while (intPart.length > 3) {
            result = ',' + intPart.slice(-3) + result;
            intPart = intPart.slice(0, intPart.length - 3);
        }
        if (intPart) { result = intPart + result + floatPart; }
        return result;
    };

    /*C#颜色转换rgba*/
    $BDA.cNet2rgba = function(val) {
        var opacity = ((val >> 24) & 0xFF) + '',
            red = ((val >> 16) & 0xFF) + '',
            green = ((val >> 8) & 0xFF) + '',
            blue = (val & 0xFF) + '';
        return 'rgba(' + red+',' + green+',' + blue+','+(parseInt(opacity.slice(-3))/255).toFixed(2)+')';
    };

    /*图形种类大全*/
    $.extend($BDA.chart,{
        /*图形种类ID 对应 type*/
        graphKinds:function(chartID){
            switch (chartID){
                case 0 : return 'tile';
                case 1 : return 'verticalTable';
                case 2 : return 'horizentalTable';
                case 3 : return 'pivotTable';
                case 4 :
                case 5 :
                case 6 : return 'column';
                case 7 :
                case 8 :
                case 9 : return 'bar';
                case 10 : return 'line';
                case 11 : return 'area';
                case 12 : return 'xy';
                case 13 : return 'pie';
                case 14 : return 'donut';
                case 15 : return 'gauge';
                case 16 : return 'scatter';
                case 17 : return 'bubble';
                case 18 : return 'waterfall';
                case 19 : return 'radar';
                case 20 : return 'boxPlot';
                case 21 : return 'funnel';
                case 22 : return 'polar';
                case 23 : return 'map';
                case 24 : return 'xy';
                case 25 : return 'xy';
                case 26 : return 'label';
            }
        },
        newChart:function(strChartType,strChartID,title,viewBlock){
            switch (strChartType){
                case 0:
                    return new TileChart(strChartType,strChartID,title,viewBlock);
                case 1:
                    return new VerticalTable(strChartType,strChartID,title,viewBlock);
                case 2:
                    return new HorizentalTable(strChartType,strChartID,title,viewBlock);
                case 3:
                    return new PivotTable(strChartType,strChartID,title,viewBlock);
                case 4:
                    return new Histogram(strChartType,strChartID,title,viewBlock);
                case 5:
                    return new AccumulateHistogram(strChartType,strChartID,title,viewBlock);
                case 6:
                    return new PercentHistogram(strChartType,strChartID,title,viewBlock);
                case 7:
                    return new BarChart(strChartType,strChartID,title,viewBlock);
                case 8:
                    return new AccumulateBarChart(strChartType,strChartID,title,viewBlock);
                case 9:
                    return new PercentBarChart(strChartType,strChartID,title,viewBlock);
                case 10:
                    return new LineGraph(strChartType,strChartID,title,viewBlock);
                case 11:
                    return new AreaGraph(strChartType,strChartID,title,viewBlock);
                case 12:
                    return new HistogramLine(strChartType,strChartID,title,viewBlock);
                case 13:
                    return new PieChart(strChartType,strChartID,title,viewBlock);
                case 14:
                    return new Doughnut(strChartType,strChartID,title,viewBlock);
                case 15:
                    return new Gauge(strChartType,strChartID,title,viewBlock);
                case 16:
                    return new ScatterPlot(strChartType,strChartID,title,viewBlock);
                case 17:
                    return new BubbleChart(strChartType,strChartID,title,viewBlock);
                case 18:
                    return new Waterfall(strChartType,strChartID,title,viewBlock);
                case 19:
                    return new RadarMap(strChartType,strChartID,title,viewBlock);
                case 20:
                    return new BoxPlot(strChartType,strChartID,title,viewBlock);
                case 21:
                    return new FunnelPlot(strChartType,strChartID,title,viewBlock);
                case 22:
                    return new PolarMap(strChartType,strChartID,title,viewBlock);
                case 23:
                    return new Map(strChartType,strChartID,title,viewBlock);
                case 24:
                    return new AccumulateHistogramLine(strChartType,strChartID,title,viewBlock);
                case 25:
                    return new PercentHistogramLine(strChartType,strChartID,title,viewBlock);
                case 26:
                    return new Label(strChartType,strChartID,title,viewBlock);
            }
        }
    });

    /*将动态生成方法扩展至$BDA.dynamic上*/
    $.extend($BDA.dynamic,{
        /*生成页面结构------行*/
        createRow : function(target,page){
            for (var i = 0, rowLength = page.length; i < rowLength; i++) {
                var element = document.createElement('div');
                element.className = "row row" + i;
                element.id = page[i].pageID;
                element.setAttribute('data-rows',page[i].rows);
                element.setAttribute('data-columns',page[i].columns);
                target.append(element);
            }
        },
        /*生成每一行的图表*/
        createChart:function(viewBlocks,deviceTypeID,clientHeight){
            for (var i = 0, rowLength = viewBlocks.length; i < rowLength; i++) {
                var element = document.createElement('div');
                element.className = 'bda-chart ' + $BDA.chart.graphKinds(viewBlocks[i].chartID);
                element.id = 'bda-chart' + i;
                element.innerHTML = this.chartXML();
                this[deviceTypeID == 0?'mobileStyle':'elseStyle'](element,viewBlocks[i],deviceTypeID,clientHeight);
            }
        },
        mobileStyle:function(element,viewBlock,deviceTypeID,clientHeight){
            var parentElement = $('#'+viewBlock.blockLayouts[deviceTypeID].pageID);
            $(element).css({
                "width": (viewBlock.blockLayouts[deviceTypeID].width / parentElement.attr('data-columns'))*100 + '%',
                "height": (viewBlock.blockLayouts[deviceTypeID].height / parentElement.attr('data-rows'))*clientHeight
            });
            parentElement.append(element);
        },
        elseStyle:function(element,viewBlock,deviceTypeID){
            var parentElement = $('#'+viewBlock.blockLayouts[deviceTypeID].pageID);
            $(element).css({
                position : 'absolute',
                width : (viewBlock.blockLayouts[deviceTypeID].width / parentElement.attr('data-columns'))*100 + '%',
                height : (viewBlock.blockLayouts[deviceTypeID].height / parentElement.attr('data-rows'))*100 + '%',
                left : (viewBlock.blockLayouts[deviceTypeID].left / parentElement.attr('data-columns'))*100 + '%',
                top : (viewBlock.blockLayouts[deviceTypeID].top / parentElement.attr('data-rows'))*100 + '%'
            });
            parentElement.append(element);
        },
        /*图表的页面元素模板*/
        chartXML: function () {
            return '<div class="bda-bgcolor">\
                        <div class="chart-link-toolbar">\
                            <span></span>\
                        </div>\
                        <div class="chart-drill-toolbar">\
                            <span></span>\
                        </div>\
                        <h3><span></span></h3>\
                        <h5><span></span></h5>\
                        <div class="bda-data">\
                            <p><span class="bda-dimension"></span><span class="bda-measure"></span></p>\
                            <p><span class="bda-grouping"></span><span class="bda-extensive-measure"></span></p>\
                        </div>\
                        <div class="bda-chart-box">\
                            <div class="bda-pointer"></div>\
                            <div class="bda-chart-content"></div>\
                        </div>\
                        <div class="bda-remark"></div>\
                    </div>';
        },
        /**
         * 移动端
         */
        mobile: {
            /*生成过滤器中----过滤条件list*/
            createFilterList: function (list) {
                for (var i = 0, str = '', len = list.length; i < len; i++) {
                    str += '<li data-index="'+i+'">\
                    <span class="entry-content">\
                        <span class="select-content">请选择</span>\
                        <span class="prompt-content">' + list[i].prompt + '</span>\
                    </span>\
                </li>';
                }
                return str;
            }
        },
        /**
         * pc端
         */
        pc: {
            /*过滤器----head*/
            createFilterHead: function (data) {
                for (var i = 0, str = '', len = data.length; i < len; i++) {
                    str += '<li data-index="' + i + '"><span>' + data[i].prompt + '</span><span class="filter-header-content"></span></li>'
                }
                return str;
            },
            /*过滤器----body*/
            createFilterBody: function (data, key) {
                for (var i = 0, str = '', len = data.length; i < len; i++) {
                    str += '<li data-value="' + (data[i][key] || '') + '">' + (data[i][key] || '') + '</li>';
                }
                return str;
            }
        }
    });

    /*将设备型号扩展至$BDA.deviceTypeID*/
    $.extend($BDA.deviceTypeID,{         /*默认均为false*/
        win: false,
        mac: false,
        /*移动设备*/
        IOS: false,
        Android: false,
        isMobile:false,
        isPad:false,
        check:function(deviceTypeID){
            var self = this;
            var ua = navigator.userAgent;
            var platform = navigator.platform;
            function systemType(){
                if(/Android/i.test(ua)){
                    self.Android = true;
                }
                if(/iPhone|iPad/i.test(ua)){
                    self.IOS = true;
                }
            }

            if(deviceTypeID==0){
                this.isMobile = true;
                systemType();
            }else if(deviceTypeID == 1) {
                this.isPad = true;
                systemType();
            }else if(deviceTypeID ==2){
                this.win = platform.indexOf('Win') == 0;
                this.mac = platform.indexOf('Mac') == 0;
            }
        }
    });

    /*JS和其他语言的交互*/
    $.extend($BDA.JS2Other,{
        bar:function(showOrHide){
            if($BDA.deviceTypeID.isMobile) {
                if($BDA.deviceTypeID.IOS&&window.webkit){                   /*IOS*/
                    window.webkit.messageHandlers[showOrHide == 'show'?'showBar':'hideBar'].postMessage(null);
                }else if($BDA.deviceTypeID.Android&&window.Android){         /*Android*/
                    Android[showOrHide == 'show'?'showBar':'hideBar']();
                }
            }else{
                if($BDA.deviceTypeID.mac&&window.webkit){             /*mac机*/
                    window.webkit.messageHandlers[showOrHide == 'show'?'showIndicator':'hideIndicator'].postMessage(null);
                }
            }
        },
        show:function(){
            this.bar('show');
        },
        hide:function(){
            this.bar('hide');
        }
    });

    /*loading界面*/
    $.extend($BDA.loading,{
        open:function(){
            $('.page-loading').css('display','block');
        },
        close:function(){
            $('.page-loading').css('display','none');
        }
    });

    /*信息提示框*/
    $.extend($BDA.message,{
        open: function (str) {
            $('.page-msg').css('display','block').find('.page-msg-content div p').html(str||'');
            var msgCurrentHeight =  $('.page-msg .page-msg-content div p').height();
            var msgMaxHeight = Math.floor($(window).height() * 0.8) - 18 - 45;/*18为上内边距 45为下内边距*/
            if(msgCurrentHeight>msgMaxHeight){
                $('.page-msg-content div').css({
                    'height': msgMaxHeight,
                    'overflow-y':'auto'
                });
            }
        },
        close: function () {
            $('.page-msg').css('display','none').find('.page-msg-content div p').html('');
            $('.page-msg-content div').removeAttr('style');
        }
    });
    /*关闭信息提示框事件*/
    $('.page-msg button').click($BDA.message.close);
    $('.page-msg span').click($BDA.message.close);

    /*将http请求扩展至$BDA.request*/
    $.extend($BDA.request,{
        Authorization:'',
        publicRequest:function(url,obj,succCallback){
            $.ajax({
                type: 'GET',
                url: url ,
                dataType: 'json',
                timeout:60000,
                traditional:true,
                headers:{
                    'Content-Type': 'application/x-www-form-urlencoded',
                    Authorization : this.Authorization
                },
                data: obj,
                async:true,
                context: this,
                /*请求成功回调*/
                success: function(data,status,jqXHR){
                    succCallback(data,status,jqXHR);
                },
                /*请求失败回调*/
                error:function(XHR,textStatus){
                    if(textStatus == 'timeout'){
                        $BDA.loading.close();
                        $BDA.message.open('连接超时');
                        return;
                    }
                    if(textStatus == 'error'){
                        $BDA.loading.close();
                        if(!window.navigator.onLine){
                            $BDA.message.open('网络链接不可用');
                        }else if(XHR.responseText){
                            $BDA.message.open(XHR.status +' : '+ JSON.parse(XHR.responseText).error);
                        }else{
                            $BDA.message.open('error');
                        }
                    }
                }
            }).then();
        }
    });

    /* BASE64 互转*/
    $BDA.Base64 = function(){

        /* private property*/
        var _keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

        /* public method for encoding*/
        this.encode = function (input) {
            var output = "";
            var chr1, chr2, chr3, enc1, enc2, enc3, enc4;
            var i = 0;
            input = _utf8_encode(input);
            while (i < input.length) {
                chr1 = input.charCodeAt(i++);
                chr2 = input.charCodeAt(i++);
                chr3 = input.charCodeAt(i++);
                enc1 = chr1 >> 2;
                enc2 = ((chr1 & 3) << 4) | (chr2 >> 4);
                enc3 = ((chr2 & 15) << 2) | (chr3 >> 6);
                enc4 = chr3 & 63;
                if (isNaN(chr2)) {
                    enc3 = enc4 = 64;
                } else if (isNaN(chr3)) {
                    enc4 = 64;
                }
                output = output +
                    _keyStr.charAt(enc1) + _keyStr.charAt(enc2) +
                    _keyStr.charAt(enc3) + _keyStr.charAt(enc4);
            }
            return output;
        };

        /* public method for decoding*/
        this.decode = function (input) {
            var output = "";
            var chr1, chr2, chr3;
            var enc1, enc2, enc3, enc4;
            var i = 0;
            input = input.replace(/[^A-Za-z0-9\+\/\=]/g, "");
            while (i < input.length) {
                enc1 = _keyStr.indexOf(input.charAt(i++));
                enc2 = _keyStr.indexOf(input.charAt(i++));
                enc3 = _keyStr.indexOf(input.charAt(i++));
                enc4 = _keyStr.indexOf(input.charAt(i++));
                chr1 = (enc1 << 2) | (enc2 >> 4);
                chr2 = ((enc2 & 15) << 4) | (enc3 >> 2);
                chr3 = ((enc3 & 3) << 6) | enc4;
                output = output + String.fromCharCode(chr1);
                if (enc3 != 64) {
                    output = output + String.fromCharCode(chr2);
                }
                if (enc4 != 64) {
                    output = output + String.fromCharCode(chr3);
                }
            }
            output = _utf8_decode(output);
            return output;
        };

        /* private method for UTF-8 encoding*/
        function _utf8_encode(string) {
            string = string.replace(/\r\n/g,"\n");
            var utftext = "";
            for (var n = 0; n < string.length; n++) {
                var c = string.charCodeAt(n);
                if (c < 128) {
                    utftext += String.fromCharCode(c);
                } else if((c > 127) && (c < 2048)) {
                    utftext += String.fromCharCode((c >> 6) | 192);
                    utftext += String.fromCharCode((c & 63) | 128);
                } else {
                    utftext += String.fromCharCode((c >> 12) | 224);
                    utftext += String.fromCharCode(((c >> 6) & 63) | 128);
                    utftext += String.fromCharCode((c & 63) | 128);
                }

            }
            return utftext;
        }

        /* private method for UTF-8 decoding*/
        function _utf8_decode(utftext) {
            var string = "";
            var i = 0;
            var c = c1 = c2 = 0;
            while ( i < utftext.length ) {
                c = utftext.charCodeAt(i);
                if (c < 128) {
                    string += String.fromCharCode(c);
                    i++;
                } else if((c > 191) && (c < 224)) {
                    c2 = utftext.charCodeAt(i+1);
                    string += String.fromCharCode(((c & 31) << 6) | (c2 & 63));
                    i += 2;
                } else {
                    c2 = utftext.charCodeAt(i+1);
                    c3 = utftext.charCodeAt(i+2);
                    string += String.fromCharCode(((c & 15) << 12) | ((c2 & 63) << 6) | (c3 & 63));
                    i += 3;
                }
            }
            return string;
        }
    };

    /* 判断点在闭合多边形内*/
    $BDA.pointInsidePolygon = function(point, vs)  {

        var x = point[0], y = point[1];

        var inside = false;

        for (var i = 0, j = vs.length - 1; i < vs.length; j = i++) {

            var xi = vs[i][0], yi = vs[i][1];

            var xj = vs[j][0], yj = vs[j][1];

            var intersect = ((yi > y) != (yj > y)) && (x < (xj - xi) * (y - yi) / (yj - yi) + xi);

            if (intersect) inside = !inside;
        }

        return inside;
    };

    /*将格式化字符串方法添加至$BDA.formatString*/
    $.extend($BDA.formatString,{
        formatThousand : function(num){
            var str = (num||0).toString(), result='',floatPart='',intPart= str;
            var scalingPosition = str.indexOf('.'); /*小数点位置*/
            if(scalingPosition!=-1){
                intPart = str.slice(0,scalingPosition);
                floatPart = str.slice(scalingPosition);
            }
            while (intPart.length > 3) {
                result = ',' + intPart.slice(-3) + result;
                intPart = intPart.slice(0, intPart.length - 3);
            }
            if (intPart) { result = intPart + result + floatPart; }
            return result;
        },
        number : function(type,num){
            if (!type){return num;}
            if (typeof num === "undefined") return num;
            if (typeof num === 'string') return num;
            var decimalDigits = 0;       /* 小数位数*/
            if (type == '###0'){
                return num.toFixed(0);
            }else if (type.indexOf('.')!=-1&&type.indexOf(',')==-1&&type.indexOf('%')==-1&&type.indexOf('E')==-1){
                return num.toFixed(type.length-type.indexOf('.')-1);
            }else if (type.indexOf('%')!=-1){
                if (type.indexOf('.')!=-1){
                    decimalDigits = type.length-1 - type.indexOf('.')-1;
                }else{
                    return num*100 + '%';
                }
                if (type.indexOf(',')!=-1){
                    return this.formatThousand((100*num).toFixed(decimalDigits))+'%';
                }else{
                    return (num*100).toFixed(decimalDigits)+'%';
                }
            }else if (type.indexOf(',')!=-1){
                if (type.indexOf('.')!=-1){
                    decimalDigits = type.length - type.indexOf('.')-1;
                    return this.formatThousand(num.toFixed(decimalDigits));
                }else{
                    return this.formatThousand(num);
                }
            }else if (type.indexOf('E')!=-1){
                if (type.indexOf('.') != -1){
                    decimalDigits = type.indexOf('E') - type.indexOf('.')-1;
                    return num.toExponential(decimalDigits);
                }else {
                    return num.toExponential();
                }
            }
            return num;
        },
        date : function(type,date){
            if (typeof date == 'string') return date;
            if (!date)return date;
            if (type == ''){
                return this.formatDay('YYYY-MM-dd',date);
            }else {
                if (type.indexOf('YYYY')!=-1&&type.indexOf('mm')!=-1){
                    var hourIndex = type.indexOf('h');
                    return this.formatDay(type.slice(0,hourIndex),date)+this.formatTime(type.slice(hourIndex),date);
                }else{
                    if (type.indexOf('YYYY')!=-1){
                        return this.formatDay(type,date);
                    }else if (type.indexOf('mm')!=-1){
                        return this.formatTime(type,date);
                    }
                }
            }
            return date;
        },
        formatDay:function(type,date){
            var z ={
                Y:date.getFullYear(),
                M:date.getMonth()+1,
                d:date.getDate()
            };
            return type.replace(/(Y+|M+|d+)/g,function(v) {
                return ((v.length>1?"0":"")+z[v.slice(-1)]).slice(-(v.length>2?v.length:2))
            });
        },
        formatTime:function(type,date){
            var z ={
                H:date.getHours(),
                h:date.getHours()%12,
                m:date.getMinutes(),
                s:date.getSeconds(),
                aa:['AM','PM']
            };
            return type.replace(/(H+|h+|m+|s+|aa)/g,function(v) {
                if (v=='aa'){
                    return z.aa[z.H>=12?1:0]
                }else{
                    return ((v.length>1?"0":"")+z[v.slice(-1)]).slice(-(v.length>2?v.length:2));
                }
            });
        }
    });

    $BDA.reverseFormatting = function(val){
        if (typeof val=='number') return val;
        if(val.indexOf(',') != -1){
            var reverseVal = val.replace(/,/g,'');
            if(val.indexOf('%') != -1){
                reverseVal = reverseVal/100;
            }
            return parseFloat(reverseVal);
        }else if(val.indexOf('%') != -1){
            return (parseFloat(val)/100);
        }else{
            return parseFloat(val);
        }
    };

    $BDA.set__proto__ = function(object){
        if("".__proto__ == String.prototype){
            object.prototype.__proto__ = Chart.prototype;
        }else{
            object.prototype = Chart.prototype;
        }
    };

    //pc 设置所有图形子类的prototype --> Chart.prototype
    $BDA.setAll__proto__=function(){
        var allChart = [TileChart,VerticalTable,PivotTable,Histogram,AccumulateHistogram,PercentHistogram,
            BarChart,AccumulateBarChart,PercentBarChart,LineGraph,AreaGraph,HistogramLine,PieChart,Doughnut,
            Gauge,ScatterPlot,BubbleChart,Waterfall,RadarMap,RadarMap,FunnelPlot,FunnelPlot,PolarMap,Map,
            AccumulateHistogramLine,PercentHistogramLine,Label];
        for (var i=0;i<allChart.length;i++){
            $BDA.set__proto__(allChart[i]);
        }
    };

    //保存主题样式
    $BDA.theme = {};
    //themeID枚举
    $BDA.theme.themeIDs = [0,1,2];
    $BDA.theme.themeID = 0;
    $BDA.theme.currentBackgroundColor = null;
    $BDA.theme.highcharts = [
        {
            colors: "#DDDF0D #55BF3B #DF5353 #7798BF #aaeeee #ff0066 #eeaaee #55BF3B #DF5353 #7798BF #aaeeee".split(" "),
            chart: {
                backgroundColor: "#003271",
                borderColor: "#003271",
                borderWidth: 2,
                className: "dark-container",
                plotBackgroundColor: "#003271",
                plotBorderColor: "#003271",
                plotBorderWidth: 1
            },
            title: {
                style: {
                    color: "#C0C0C0",
                    font: 'bold 16px "Trebuchet MS", Verdana, sans-serif'
                }
            },
            subtitle: {style: {color: "#666666", font: 'bold 12px "Trebuchet MS", Verdana, sans-serif'}},
            xAxis: {
                gridLineColor: "#333333",
                gridLineWidth: 1,
                labels: {style: {color: "#A0A0A0"}},
                lineColor: "#A0A0A0",
                tickWidth: 1,
                title: {
                    style: {
                        color: "#CCC",
                        fontWeight: "bold",
                        fontSize: "12px",
                        fontFamily: "Trebuchet MS, Verdana, sans-serif"
                    }
                }
            },
            yAxis: {
                gridLineColor: "#333333",
                labels: {style: {color: "#A0A0A0"}},
                lineColor: "#A0A0A0",
                minorTickInterval: null,
                tickColor: "#A0A0A0",
                tickWidth: 1,
                title: {
                    style: {
                        color: "#CCC",
                        fontWeight: "bold",
                        fontSize: "12px",
                        fontFamily: "Trebuchet MS, Verdana, sans-serif"
                    }
                }
            },
            tooltip: {backgroundColor: "rgba(0, 0, 0, 0.75)", style: {color: "#F0F0F0"}},
            toolbar: {itemStyle: {color: "silver"}},
            plotOptions: {
                line: {dataLabels: {color: "#CCC"}, marker: {lineColor: "#333"}},
                spline: {marker: {lineColor: "#333"}},
                column:{dataLabels: {color: "#CCC"},borderColor: "#003271"},
                pie:{dataLabels: {color: "#CCC"},borderColor: "#003271"},
                bar:{dataLabels: {color: "#CCC"},borderColor: "#003271"},
                area:{dataLabels: {color: "#CCC"},borderColor: "#003271"},
                gauge: {
                    dial: {backgroundColor: '#fff'},
                    dataLabels:{color: "#CCC",backgroundColor: '#003271'},
                    pivot:{backgroundColor: '#fff'}
                },
                scatter:{dataLabels: {color: "#CCC"},borderColor: "#003271",marker: {lineColor: "#333"}},
                bubble:{dataLabels: {color: "#CCC"},borderColor: "#003271"},
                waterfall:{dataLabels: {color: "#CCC"},borderColor: "#003271"},
                funnel:{dataLabels: {color: "#CCC"},borderColor: "#003271"}
            },
            legend: {
                itemStyle: {font: "9pt Trebuchet MS, Verdana, sans-serif", color: "#A0A0A0"},
                itemHoverStyle: {color: "#FFF"},
                itemHiddenStyle: {color: "#444"}
            },
            credits: {style: {color: "#666"}},
            labels: {style: {color: "#CCC"}},
            navigation: {
                buttonOptions: {
                    symbolStroke: "#DDDDDD",
                    hoverSymbolStroke: "#FFFFFF",
                    theme: {
                        fill: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4, "#606060"], [.6, "#333333"]]},
                        stroke: "#000000"
                    }
                }
            },
            rangeSelector: {
                buttonTheme: {
                    fill: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4, "#888"], [.6, "#555"]]},
                    stroke: "#000000",
                    style: {color: "#CCC", fontWeight: "bold"},
                    states: {
                        hover: {
                            fill: {
                                linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4,
                                    "#BBB"], [.6, "#888"]]
                            }, stroke: "#000000", style: {color: "white"}
                        },
                        select: {
                            fill: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.1, "#000"], [.3, "#333"]]},
                            stroke: "#000000",
                            style: {color: "yellow"}
                        }
                    }
                }, inputStyle: {backgroundColor: "#333", color: "silver"}, labelStyle: {color: "silver"}
            },
            navigator: {
                handles: {backgroundColor: "#666", borderColor: "#AAA"},
                outlineColor: "#CCC",
                maskFill: "rgba(16, 16, 16, 0.5)",
                series: {color: "#7798BF", lineColor: "#A6C7ED"}
            },
            scrollbar: {
                barBackgroundColor: {
                    linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4,
                        "#888"], [.6, "#555"]]
                },
                barBorderColor: "#CCC",
                buttonArrowColor: "#CCC",
                buttonBackgroundColor: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[.4, "#888"], [.6, "#555"]]},
                buttonBorderColor: "#CCC",
                rifleColor: "#FFF",
                trackBackgroundColor: {linearGradient: {x1: 0, y1: 0, x2: 0, y2: 1}, stops: [[0, "#000"], [1, "#333"]]},
                trackBorderColor: "#666"
            },
            legendBackgroundColor: "rgba(0, 0, 0, 0.5)",
            background2: "rgb(35, 35, 70)",
            dataLabelsColor: "#444",
            textColor: "#C0C0C0",
            maskColor: "rgba(255,255,255,0.3)",
            pane: {
                background:{
                    backgroundColor: '#003271'
                }
            }
        },
        {
            colors: "#2b908f #90ee7e #f45b5b #7798BF #aaeeee #ff0066 #eeaaee #55BF3B #DF5353 #7798BF #aaeeee".split(" "),
            chart: {
                backgroundColor: "#222",
                style: {fontFamily: "'Unica One', sans-serif"},
                plotBorderColor: "#222"
            },
            title: {style: {color: "#E0E0E3", textTransform: "uppercase", fontSize: "20px"}},
            subtitle: {style: {color: "#E0E0E3", textTransform: "uppercase"}},
            xAxis: {
                gridLineColor: "#707073",
                labels: {style: {color: "#E0E0E3"}},
                lineColor: "#707073",
                minorGridLineColor: "#505053",
                tickColor: "#707073",
                title: {style: {color: "#A0A0A3"}}
            },
            yAxis: {
                gridLineColor: "#707073",
                labels: {style: {color: "#E0E0E3"}},
                lineColor: "#707073",
                minorGridLineColor: "#505053",
                tickColor: "#707073",
                tickWidth: 1,
                title: {style: {color: "#A0A0A3"}}
            },
            tooltip: {backgroundColor: "rgba(0, 0, 0, 0.85)", style: {color: "#F0F0F0"}},
            plotOptions: {
                line: {dataLabels: {color: "#B0B0B3"}, marker: {lineColor: "#333"}},
                spline: {marker: {lineColor: "#333"}},
                column:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                pie:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                bar:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                area:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                gauge: {
                    dial: {backgroundColor: '#fff'},
                    dataLabels:{color: "#B0B0B3",backgroundColor: '#222'},
                    pivot:{backgroundColor: '#fff'}
                },
                scatter:{dataLabels: {color: "#B0B0B3"},borderColor: "#222",marker: {lineColor: "#333"}},
                bubble:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                waterfall:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"},
                funnel:{dataLabels: {color: "#B0B0B3"},borderColor: "#222"}
            },
            legend: {itemStyle: {color: "#E0E0E3"}, itemHoverStyle: {color: "#FFF"}, itemHiddenStyle: {color: "#606063"}},
            credits: {style: {color: "#666"}},
            labels: {style: {color: "#707073"}},
            drilldown: {activeAxisLabelStyle: {color: "#F0F0F3"}, activeDataLabelStyle: {color: "#F0F0F3"}},
            navigation: {
                buttonOptions: {
                    symbolStroke: "#DDDDDD",
                    theme: {fill: "#505053"}
                }
            },
            rangeSelector: {
                buttonTheme: {
                    fill: "#505053",
                    stroke: "#000000",
                    style: {color: "#CCC"},
                    states: {
                        hover: {fill: "#707073", stroke: "#000000", style: {color: "white"}},
                        select: {fill: "#000003", stroke: "#000000", style: {color: "white"}}
                    }
                },
                inputBoxBorderColor: "#505053",
                inputStyle: {backgroundColor: "#333", color: "silver"},
                labelStyle: {color: "silver"}
            },
            navigator: {
                handles: {backgroundColor: "#666", borderColor: "#AAA"},
                outlineColor: "#CCC",
                maskFill: "rgba(255,255,255,0.1)",
                series: {color: "#7798BF", lineColor: "#A6C7ED"},
                xAxis: {gridLineColor: "#505053"}
            },
            scrollbar: {
                barBackgroundColor: "#808083",
                barBorderColor: "#808083",
                buttonArrowColor: "#CCC",
                buttonBackgroundColor: "#606063",
                buttonBorderColor: "#606063",
                rifleColor: "#FFF",
                trackBackgroundColor: "#404043",
                trackBorderColor: "#404043"
            },
            legendBackgroundColor: "rgba(0, 0, 0, 0.5)",
            background2: "#505053",
            dataLabelsColor: "#B0B0B3",
            textColor: "#C0C0C0",
            contrastTextColor: "#F0F0F3",
            maskColor: "rgba(255,255,255,0.3)",
            pane: {
                background:{
                    backgroundColor: '#222'
                }
            }
        }
    ];

    window.$BDA = $BDA;

})(window,$);