/*
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the LICENSE
 * file in the root directory of this source tree.
 */
// @Generated by gentest/gentest.rb from gentest/fixtures/YGFlexWrapTest.html

#include <gtest/gtest.h>
#include <yoga/Yoga.h>

TEST(YogaTest, wrap_column) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexWrap(root, YGWrapWrap);
  YGNodeStyleSetHeight(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 30);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 30);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 30);
  YGNodeInsertChild(root, root_child3, 3);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child3));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child3));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_row) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root, YGWrapWrap);
  YGNodeStyleSetWidth(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 30);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 30);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 30);
  YGNodeInsertChild(root, root_child3, 3);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child3));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child3));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_row_align_items_flex_end) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetAlignItems(root, YGAlignFlexEnd);
  YGNodeStyleSetFlexWrap(root, YGWrapWrap);
  YGNodeStyleSetWidth(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 10);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 20);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 30);
  YGNodeInsertChild(root, root_child3, 3);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child3));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child3));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_row_align_items_center) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetAlignItems(root, YGAlignCenter);
  YGNodeStyleSetFlexWrap(root, YGWrapWrap);
  YGNodeStyleSetWidth(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 10);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 20);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 30);
  YGNodeInsertChild(root, root_child3, 3);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(5, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child3));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(5, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child3));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, flex_wrap_children_with_min_main_overriding_flex_basis) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root, YGWrapWrap);
  YGNodeStyleSetWidth(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexBasis(root_child0, 50);
  YGNodeStyleSetMinWidth(root_child0, 55);
  YGNodeStyleSetHeight(root_child0, 50);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexBasis(root_child1, 50);
  YGNodeStyleSetMinWidth(root_child1, 55);
  YGNodeStyleSetHeight(root_child1, 50);
  YGNodeInsertChild(root, root_child1, 1);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(55, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(55, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child1));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(45, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(55, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(45, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(55, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child1));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, flex_wrap_wrap_to_child_height) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root_child0, YGFlexDirectionRow);
  YGNodeStyleSetAlignItems(root_child0, YGAlignFlexStart);
  YGNodeStyleSetFlexWrap(root_child0, YGWrapWrap);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child0, 100);
  YGNodeInsertChild(root_child0, root_child0_child0, 0);

  const YGNodeRef root_child0_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child0_child0, 100);
  YGNodeStyleSetHeight(root_child0_child0_child0, 100);
  YGNodeInsertChild(root_child0_child0, root_child0_child0_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 100);
  YGNodeStyleSetHeight(root_child1, 100);
  YGNodeInsertChild(root, root_child1, 1);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child0_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child1));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child0_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child1));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, flex_wrap_align_stretch_fits_one_row) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root, YGWrapWrap);
  YGNodeStyleSetWidth(root, 150);
  YGNodeStyleSetHeight(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 50);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 50);
  YGNodeInsertChild(root, root_child1, 1);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetHeight(root_child1));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetHeight(root_child1));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_reverse_row_align_content_flex_start) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root, YGWrapWrapReverse);
  YGNodeStyleSetWidth(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 10);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 20);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 40);
  YGNodeInsertChild(root, root_child3, 3);

  const YGNodeRef root_child4 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child4, 30);
  YGNodeStyleSetHeight(root_child4, 50);
  YGNodeInsertChild(root, root_child4, 4);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_reverse_row_align_content_center) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetAlignContent(root, YGAlignCenter);
  YGNodeStyleSetFlexWrap(root, YGWrapWrapReverse);
  YGNodeStyleSetWidth(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 10);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 20);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 40);
  YGNodeInsertChild(root, root_child3, 3);

  const YGNodeRef root_child4 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child4, 30);
  YGNodeStyleSetHeight(root_child4, 50);
  YGNodeInsertChild(root, root_child4, 4);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_reverse_row_single_line_different_size) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root, YGWrapWrapReverse);
  YGNodeStyleSetWidth(root, 300);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 10);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 20);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 40);
  YGNodeInsertChild(root, root_child3, 3);

  const YGNodeRef root_child4 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child4, 30);
  YGNodeStyleSetHeight(root_child4, 50);
  YGNodeInsertChild(root, root_child4, 4);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(300, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(90, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(120, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(300, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(270, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(240, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(210, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(180, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_reverse_row_align_content_stretch) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetAlignContent(root, YGAlignStretch);
  YGNodeStyleSetFlexWrap(root, YGWrapWrapReverse);
  YGNodeStyleSetWidth(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 10);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 20);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 40);
  YGNodeInsertChild(root, root_child3, 3);

  const YGNodeRef root_child4 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child4, 30);
  YGNodeStyleSetHeight(root_child4, 50);
  YGNodeInsertChild(root, root_child4, 4);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_reverse_row_align_content_space_around) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root, YGFlexDirectionRow);
  YGNodeStyleSetAlignContent(root, YGAlignSpaceAround);
  YGNodeStyleSetFlexWrap(root, YGWrapWrapReverse);
  YGNodeStyleSetWidth(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 10);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 20);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 40);
  YGNodeInsertChild(root, root_child3, 3);

  const YGNodeRef root_child4 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child4, 30);
  YGNodeStyleSetHeight(root_child4, 50);
  YGNodeInsertChild(root, root_child4, 4);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_reverse_column_fixed_size) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetAlignItems(root, YGAlignCenter);
  YGNodeStyleSetFlexWrap(root, YGWrapWrapReverse);
  YGNodeStyleSetWidth(root, 200);
  YGNodeStyleSetHeight(root, 100);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 30);
  YGNodeStyleSetHeight(root_child0, 10);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child1, 30);
  YGNodeStyleSetHeight(root_child1, 20);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 30);
  YGNodeStyleSetHeight(root_child2, 30);
  YGNodeInsertChild(root, root_child2, 2);

  const YGNodeRef root_child3 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child3, 30);
  YGNodeStyleSetHeight(root_child3, 40);
  YGNodeInsertChild(root, root_child3, 3);

  const YGNodeRef root_child4 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child4, 30);
  YGNodeStyleSetHeight(root_child4, 50);
  YGNodeInsertChild(root, root_child4, 4);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(170, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(170, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(170, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(170, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(140, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(10, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(20, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetHeight(root_child2));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child3));
  ASSERT_FLOAT_EQ(60, YGNodeLayoutGetTop(root_child3));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child3));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child3));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child4));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child4));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetWidth(root_child4));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetHeight(root_child4));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrapped_row_within_align_items_center) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetAlignItems(root, YGAlignCenter);
  YGNodeStyleSetWidth(root, 200);
  YGNodeStyleSetHeight(root, 200);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root_child0, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root_child0, YGWrapWrap);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child0, 150);
  YGNodeStyleSetHeight(root_child0_child0, 80);
  YGNodeInsertChild(root_child0, root_child0_child0, 0);

  const YGNodeRef root_child0_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child1, 80);
  YGNodeStyleSetHeight(root_child0_child1, 80);
  YGNodeInsertChild(root_child0, root_child0_child1, 1);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(160, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child1));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(160, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(120, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child1));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrapped_row_within_align_items_flex_start) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetAlignItems(root, YGAlignFlexStart);
  YGNodeStyleSetWidth(root, 200);
  YGNodeStyleSetHeight(root, 200);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root_child0, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root_child0, YGWrapWrap);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child0, 150);
  YGNodeStyleSetHeight(root_child0_child0, 80);
  YGNodeInsertChild(root_child0, root_child0_child0, 0);

  const YGNodeRef root_child0_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child1, 80);
  YGNodeStyleSetHeight(root_child0_child1, 80);
  YGNodeInsertChild(root_child0, root_child0_child1, 1);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(160, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child1));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(160, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(120, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child1));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrapped_row_within_align_items_flex_end) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetAlignItems(root, YGAlignFlexEnd);
  YGNodeStyleSetWidth(root, 200);
  YGNodeStyleSetHeight(root, 200);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root_child0, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root_child0, YGWrapWrap);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child0, 150);
  YGNodeStyleSetHeight(root_child0_child0, 80);
  YGNodeInsertChild(root_child0, root_child0_child0, 0);

  const YGNodeRef root_child0_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child1, 80);
  YGNodeStyleSetHeight(root_child0_child1, 80);
  YGNodeInsertChild(root_child0, root_child0_child1, 1);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(160, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child1));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(160, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(150, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(120, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0_child1));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrapped_column_max_height) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetJustifyContent(root, YGJustifyCenter);
  YGNodeStyleSetAlignContent(root, YGAlignCenter);
  YGNodeStyleSetAlignItems(root, YGAlignCenter);
  YGNodeStyleSetFlexWrap(root, YGWrapWrap);
  YGNodeStyleSetWidth(root, 700);
  YGNodeStyleSetHeight(root, 500);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0, 100);
  YGNodeStyleSetHeight(root_child0, 500);
  YGNodeStyleSetMaxHeight(root_child0, 200);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetMargin(root_child1, YGEdgeLeft, 20);
  YGNodeStyleSetMargin(root_child1, YGEdgeTop, 20);
  YGNodeStyleSetMargin(root_child1, YGEdgeRight, 20);
  YGNodeStyleSetMargin(root_child1, YGEdgeBottom, 20);
  YGNodeStyleSetWidth(root_child1, 200);
  YGNodeStyleSetHeight(root_child1, 200);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 100);
  YGNodeStyleSetHeight(root_child2, 100);
  YGNodeInsertChild(root, root_child2, 2);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(700, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(250, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(250, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(420, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child2));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(700, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(350, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(300, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(250, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(180, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child2));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrapped_column_max_height_flex) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetJustifyContent(root, YGJustifyCenter);
  YGNodeStyleSetAlignContent(root, YGAlignCenter);
  YGNodeStyleSetAlignItems(root, YGAlignCenter);
  YGNodeStyleSetFlexWrap(root, YGWrapWrap);
  YGNodeStyleSetWidth(root, 700);
  YGNodeStyleSetHeight(root, 500);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexGrow(root_child0, 1);
  YGNodeStyleSetFlexShrink(root_child0, 1);
  YGNodeStyleSetFlexBasisPercent(root_child0, 0);
  YGNodeStyleSetWidth(root_child0, 100);
  YGNodeStyleSetHeight(root_child0, 500);
  YGNodeStyleSetMaxHeight(root_child0, 200);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexGrow(root_child1, 1);
  YGNodeStyleSetFlexShrink(root_child1, 1);
  YGNodeStyleSetFlexBasisPercent(root_child1, 0);
  YGNodeStyleSetMargin(root_child1, YGEdgeLeft, 20);
  YGNodeStyleSetMargin(root_child1, YGEdgeTop, 20);
  YGNodeStyleSetMargin(root_child1, YGEdgeRight, 20);
  YGNodeStyleSetMargin(root_child1, YGEdgeBottom, 20);
  YGNodeStyleSetWidth(root_child1, 200);
  YGNodeStyleSetHeight(root_child1, 200);
  YGNodeInsertChild(root, root_child1, 1);

  const YGNodeRef root_child2 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child2, 100);
  YGNodeStyleSetHeight(root_child2, 100);
  YGNodeInsertChild(root, root_child2, 2);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(700, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(300, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(180, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(250, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(180, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(300, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(400, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child2));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(700, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(300, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(180, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(250, YGNodeLayoutGetLeft(root_child1));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetTop(root_child1));
  ASSERT_FLOAT_EQ(200, YGNodeLayoutGetWidth(root_child1));
  ASSERT_FLOAT_EQ(180, YGNodeLayoutGetHeight(root_child1));

  ASSERT_FLOAT_EQ(300, YGNodeLayoutGetLeft(root_child2));
  ASSERT_FLOAT_EQ(400, YGNodeLayoutGetTop(root_child2));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetWidth(root_child2));
  ASSERT_FLOAT_EQ(100, YGNodeLayoutGetHeight(root_child2));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_nodes_with_content_sizing_overflowing_margin) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root, 500);
  YGNodeStyleSetHeight(root, 500);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root_child0, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root_child0, YGWrapWrap);
  YGNodeStyleSetWidth(root_child0, 85);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeInsertChild(root_child0, root_child0_child0, 0);

  const YGNodeRef root_child0_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child0_child0, 40);
  YGNodeStyleSetHeight(root_child0_child0_child0, 40);
  YGNodeInsertChild(root_child0_child0, root_child0_child0_child0, 0);

  const YGNodeRef root_child0_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetMargin(root_child0_child1, YGEdgeRight, 10);
  YGNodeInsertChild(root_child0, root_child0_child1, 1);

  const YGNodeRef root_child0_child1_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child1_child0, 40);
  YGNodeStyleSetHeight(root_child0_child1_child0, 40);
  YGNodeInsertChild(root_child0_child1, root_child0_child1_child0, 0);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(85, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child1));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child1_child0));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(415, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(85, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(80, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(45, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child0_child0));

  ASSERT_FLOAT_EQ(35, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child1));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child1_child0));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}

TEST(YogaTest, wrap_nodes_with_content_sizing_margin_cross) {
  const YGConfigRef config = YGConfigNew();

  const YGNodeRef root = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root, 500);
  YGNodeStyleSetHeight(root, 500);

  const YGNodeRef root_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetFlexDirection(root_child0, YGFlexDirectionRow);
  YGNodeStyleSetFlexWrap(root_child0, YGWrapWrap);
  YGNodeStyleSetWidth(root_child0, 70);
  YGNodeInsertChild(root, root_child0, 0);

  const YGNodeRef root_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeInsertChild(root_child0, root_child0_child0, 0);

  const YGNodeRef root_child0_child0_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child0_child0, 40);
  YGNodeStyleSetHeight(root_child0_child0_child0, 40);
  YGNodeInsertChild(root_child0_child0, root_child0_child0_child0, 0);

  const YGNodeRef root_child0_child1 = YGNodeNewWithConfig(config);
  YGNodeStyleSetMargin(root_child0_child1, YGEdgeTop, 10);
  YGNodeInsertChild(root_child0, root_child0_child1, 1);

  const YGNodeRef root_child0_child1_child0 = YGNodeNewWithConfig(config);
  YGNodeStyleSetWidth(root_child0_child1_child0, 40);
  YGNodeStyleSetHeight(root_child0_child1_child0, 40);
  YGNodeInsertChild(root_child0_child1, root_child0_child1_child0, 0);
  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionLTR);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(90, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child1));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child1_child0));

  YGNodeCalculateLayout(root, YGUndefined, YGUndefined, YGDirectionRTL);

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetWidth(root));
  ASSERT_FLOAT_EQ(500, YGNodeLayoutGetHeight(root));

  ASSERT_FLOAT_EQ(430, YGNodeLayoutGetLeft(root_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0));
  ASSERT_FLOAT_EQ(70, YGNodeLayoutGetWidth(root_child0));
  ASSERT_FLOAT_EQ(90, YGNodeLayoutGetHeight(root_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child0));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child0_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child0_child0));

  ASSERT_FLOAT_EQ(30, YGNodeLayoutGetLeft(root_child0_child1));
  ASSERT_FLOAT_EQ(50, YGNodeLayoutGetTop(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child1));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child1));

  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetLeft(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(0, YGNodeLayoutGetTop(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetWidth(root_child0_child1_child0));
  ASSERT_FLOAT_EQ(40, YGNodeLayoutGetHeight(root_child0_child1_child0));

  YGNodeFreeRecursive(root);

  YGConfigFree(config);
}
