/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *
 * @flow
 * @format
 */

const CONSTANTS = {
  ALIGN_COUNT: 8,
  ALIGN_AUTO: 0,
  ALIGN_FLEX_START: 1,
  ALIGN_CENTER: 2,
  ALIGN_FLEX_END: 3,
  ALIGN_STRETCH: 4,
  ALIGN_BASELINE: 5,
  ALIGN_SPACE_BETWEEN: 6,
  ALIGN_SPACE_AROUND: 7,

  DIMENSION_COUNT: 2,
  DIMENSION_WIDTH: 0,
  DIMENSION_HEIGHT: 1,

  DIRECTION_COUNT: 3,
  DIRECTION_INHERIT: 0,
  DIRECTION_LTR: 1,
  DIRECTION_RTL: 2,

  DISPLAY_COUNT: 2,
  DISPLAY_FLEX: 0,
  DISPLAY_NONE: 1,

  EDGE_COUNT: 9,
  EDGE_LEFT: 0,
  EDGE_TOP: 1,
  EDGE_RIGHT: 2,
  EDGE_BOTTOM: 3,
  EDGE_START: 4,
  EDGE_END: 5,
  EDGE_HORIZONTAL: 6,
  EDGE_VERTICAL: 7,
  EDGE_ALL: 8,

  EXPERIMENTAL_FEATURE_COUNT: 1,
  EXPERIMENTAL_FEATURE_WEB_FLEX_BASIS: 0,

  FLEX_DIRECTION_COUNT: 4,
  FLEX_DIRECTION_COLUMN: 0,
  FLEX_DIRECTION_COLUMN_REVERSE: 1,
  FLEX_DIRECTION_ROW: 2,
  FLEX_DIRECTION_ROW_REVERSE: 3,

  JUSTIFY_COUNT: 6,
  JUSTIFY_FLEX_START: 0,
  JUSTIFY_CENTER: 1,
  JUSTIFY_FLEX_END: 2,
  JUSTIFY_SPACE_BETWEEN: 3,
  JUSTIFY_SPACE_AROUND: 4,
  JUSTIFY_SPACE_EVENLY: 5,

  LOG_LEVEL_COUNT: 6,
  LOG_LEVEL_ERROR: 0,
  LOG_LEVEL_WARN: 1,
  LOG_LEVEL_INFO: 2,
  LOG_LEVEL_DEBUG: 3,
  LOG_LEVEL_VERBOSE: 4,
  LOG_LEVEL_FATAL: 5,

  MEASURE_MODE_COUNT: 3,
  MEASURE_MODE_UNDEFINED: 0,
  MEASURE_MODE_EXACTLY: 1,
  MEASURE_MODE_AT_MOST: 2,

  NODE_TYPE_COUNT: 2,
  NODE_TYPE_DEFAULT: 0,
  NODE_TYPE_TEXT: 1,

  OVERFLOW_COUNT: 3,
  OVERFLOW_VISIBLE: 0,
  OVERFLOW_HIDDEN: 1,
  OVERFLOW_SCROLL: 2,

  POSITION_TYPE_COUNT: 2,
  POSITION_TYPE_RELATIVE: 0,
  POSITION_TYPE_ABSOLUTE: 1,

  PRINT_OPTIONS_COUNT: 3,
  PRINT_OPTIONS_LAYOUT: 1,
  PRINT_OPTIONS_STYLE: 2,
  PRINT_OPTIONS_CHILDREN: 4,

  UNIT_COUNT: 4,
  UNIT_UNDEFINED: 0,
  UNIT_POINT: 1,
  UNIT_PERCENT: 2,
  UNIT_AUTO: 3,

  WRAP_COUNT: 3,
  WRAP_NO_WRAP: 0,
  WRAP_WRAP: 1,
  WRAP_WRAP_REVERSE: 2,
};

export type Yoga$JustifyContent =
  | typeof CONSTANTS.JUSTIFY_CENTER
  | typeof CONSTANTS.JUSTIFY_FLEX_END
  | typeof CONSTANTS.JUSTIFY_FLEX_START
  | typeof CONSTANTS.JUSTIFY_SPACE_AROUND
  | typeof CONSTANTS.JUSTIFY_SPACE_BETWEEN
  | typeof CONSTANTS.JUSTIFY_SPACE_EVENLY;

export type Yoga$Align =
  | typeof CONSTANTS.ALIGN_AUTO
  | typeof CONSTANTS.ALIGN_BASELINE
  | typeof CONSTANTS.ALIGN_CENTER
  | typeof CONSTANTS.ALIGN_FLEX_END
  | typeof CONSTANTS.ALIGN_FLEX_START
  | typeof CONSTANTS.ALIGN_SPACE_AROUND
  | typeof CONSTANTS.ALIGN_SPACE_BETWEEN
  | typeof CONSTANTS.ALIGN_STRETCH;

export type Yoga$FlexDirection =
  | typeof CONSTANTS.FLEX_DIRECTION_COLUMN
  | typeof CONSTANTS.FLEX_DIRECTION_COLUMN_REVERSE
  | typeof CONSTANTS.FLEX_DIRECTION_COUNT
  | typeof CONSTANTS.FLEX_DIRECTION_ROW
  | typeof CONSTANTS.FLEX_DIRECTION_ROW_REVERSE;

export type Yoga$Direction =
  | typeof CONSTANTS.DIRECTION_INHERIT
  | typeof CONSTANTS.DIRECTION_LTR
  | typeof CONSTANTS.DIRECTION_RTL;

export type Yoga$FlexWrap =
  | typeof CONSTANTS.WRAP_NO_WRAP
  | typeof CONSTANTS.WRAP_WRAP
  | typeof CONSTANTS.WRAP_WRAP_REVERSE;

export type Yoga$Edge =
  | typeof CONSTANTS.EDGE_LEFT
  | typeof CONSTANTS.EDGE_TOP
  | typeof CONSTANTS.EDGE_RIGHT
  | typeof CONSTANTS.EDGE_BOTTOM
  | typeof CONSTANTS.EDGE_START
  | typeof CONSTANTS.EDGE_END
  | typeof CONSTANTS.EDGE_HORIZONTAL
  | typeof CONSTANTS.EDGE_VERTICAL
  | typeof CONSTANTS.EDGE_ALL;

export type Yoga$Display =
  | typeof CONSTANTS.DISPLAY_FLEX
  | typeof CONSTANTS.DISPLAY_NONE;

export type Yoga$Unit =
  | typeof CONSTANTS.UNIT_AUTO
  | typeof CONSTANTS.UNIT_PERCENT
  | typeof CONSTANTS.UNIT_POINT
  | typeof CONSTANTS.UNIT_UNDEFINED;

export type Yoga$Overflow =
  | typeof CONSTANTS.OVERFLOW_HIDDEN
  | typeof CONSTANTS.OVERFLOW_SCROLL
  | typeof CONSTANTS.OVERFLOW_VISIBLE;

export type Yoga$PositionType =
  | typeof CONSTANTS.POSITION_TYPE_ABSOLUTE
  | typeof CONSTANTS.POSITION_TYPE_RELATIVE;

export type Yoga$ExperimentalFeature = typeof CONSTANTS.EXPERIMENTAL_FEATURE_WEB_FLEX_BASIS;

module.exports = CONSTANTS;
