/**
 * Copyright (c) Facebook, Inc. and its affiliates.
 *
 * This source code is licensed under the MIT license found in the LICENSE
 * file in the root directory of this source tree.
 */
// @Generated by gentest/gentest.rb from gentest/fixtures/YGFlexWrapTest.html

using System;
using NUnit.Framework;

namespace Facebook.Yoga
{
    [TestFixture]
    public class YGFlexWrapTest
    {
        [Test]
        public void Test_wrap_column()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.Wrap = YogaWrap.Wrap;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 30;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 30;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 30;
            root.Insert(3, root_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(60f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(30f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(30f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(30f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child2.LayoutX);
            Assert.AreEqual(60f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(30f, root_child3.LayoutX);
            Assert.AreEqual(0f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(30f, root_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(60f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(30f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(30f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(30f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(30f, root_child1.LayoutHeight);

            Assert.AreEqual(30f, root_child2.LayoutX);
            Assert.AreEqual(60f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(0f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(30f, root_child3.LayoutHeight);
        }

        [Test]
        public void Test_wrap_row()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 30;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 30;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 30;
            root.Insert(3, root_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(60f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(30f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(0f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(30f, root_child1.LayoutHeight);

            Assert.AreEqual(60f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(30f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(30f, root_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(60f, root.LayoutHeight);

            Assert.AreEqual(70f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(30f, root_child0.LayoutHeight);

            Assert.AreEqual(40f, root_child1.LayoutX);
            Assert.AreEqual(0f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(30f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(70f, root_child3.LayoutX);
            Assert.AreEqual(30f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(30f, root_child3.LayoutHeight);
        }

        [Test]
        public void Test_wrap_row_align_items_flex_end()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.FlexEnd;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 10;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 30;
            root.Insert(3, root_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(60f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(20f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(10f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(60f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(30f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(30f, root_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(60f, root.LayoutHeight);

            Assert.AreEqual(70f, root_child0.LayoutX);
            Assert.AreEqual(20f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(40f, root_child1.LayoutX);
            Assert.AreEqual(10f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(70f, root_child3.LayoutX);
            Assert.AreEqual(30f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(30f, root_child3.LayoutHeight);
        }

        [Test]
        public void Test_wrap_row_align_items_center()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignItems = YogaAlign.Center;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 10;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 30;
            root.Insert(3, root_child3);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(60f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(10f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(5f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(60f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(30f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(30f, root_child3.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(60f, root.LayoutHeight);

            Assert.AreEqual(70f, root_child0.LayoutX);
            Assert.AreEqual(10f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(40f, root_child1.LayoutX);
            Assert.AreEqual(5f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(0f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(70f, root_child3.LayoutX);
            Assert.AreEqual(30f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(30f, root_child3.LayoutHeight);
        }

        [Test]
        public void Test_flex_wrap_children_with_min_main_overriding_flex_basis()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.FlexBasis = 50;
            root_child0.MinWidth = 55;
            root_child0.Height = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.FlexBasis = 50;
            root_child1.MinWidth = 55;
            root_child1.Height = 50;
            root.Insert(1, root_child1);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(55f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(55f, root_child1.LayoutWidth);
            Assert.AreEqual(50f, root_child1.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(45f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(55f, root_child0.LayoutWidth);
            Assert.AreEqual(50f, root_child0.LayoutHeight);

            Assert.AreEqual(45f, root_child1.LayoutX);
            Assert.AreEqual(50f, root_child1.LayoutY);
            Assert.AreEqual(55f, root_child1.LayoutWidth);
            Assert.AreEqual(50f, root_child1.LayoutHeight);
        }

        [Test]
        public void Test_flex_wrap_wrap_to_child_height()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);

            YogaNode root_child0 = new YogaNode(config);
            root_child0.FlexDirection = YogaFlexDirection.Row;
            root_child0.AlignItems = YogaAlign.FlexStart;
            root_child0.Wrap = YogaWrap.Wrap;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.Width = 100;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child0_child0 = new YogaNode(config);
            root_child0_child0_child0.Width = 100;
            root_child0_child0_child0.Height = 100;
            root_child0_child0.Insert(0, root_child0_child0_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 100;
            root_child1.Height = 100;
            root.Insert(1, root_child1);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(200f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(100f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(100f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(100f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(100f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(100f, root_child0_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(100f, root_child1.LayoutY);
            Assert.AreEqual(100f, root_child1.LayoutWidth);
            Assert.AreEqual(100f, root_child1.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(200f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(100f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(100f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(100f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(100f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(100f, root_child0_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(100f, root_child1.LayoutY);
            Assert.AreEqual(100f, root_child1.LayoutWidth);
            Assert.AreEqual(100f, root_child1.LayoutHeight);
        }

        [Test]
        public void Test_flex_wrap_align_stretch_fits_one_row()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 150;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 50;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 50;
            root.Insert(1, root_child1);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(150f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(0f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(0f, root_child1.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(150f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(100f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(50f, root_child0.LayoutWidth);
            Assert.AreEqual(0f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child1.LayoutX);
            Assert.AreEqual(0f, root_child1.LayoutY);
            Assert.AreEqual(50f, root_child1.LayoutWidth);
            Assert.AreEqual(0f, root_child1.LayoutHeight);
        }

        [Test]
        public void Test_wrap_reverse_row_align_content_flex_start()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.Wrap = YogaWrap.WrapReverse;
            root.Width = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 10;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 40;
            root.Insert(3, root_child3);

            YogaNode root_child4 = new YogaNode(config);
            root_child4.Width = 30;
            root_child4.Height = 50;
            root.Insert(4, root_child4);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(80f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(70f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(60f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(60f, root_child2.LayoutX);
            Assert.AreEqual(50f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(30f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(80f, root.LayoutHeight);

            Assert.AreEqual(70f, root_child0.LayoutX);
            Assert.AreEqual(70f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(40f, root_child1.LayoutX);
            Assert.AreEqual(60f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(50f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(70f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(40f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);
        }

        [Test]
        public void Test_wrap_reverse_row_align_content_center()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignContent = YogaAlign.Center;
            root.Wrap = YogaWrap.WrapReverse;
            root.Width = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 10;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 40;
            root.Insert(3, root_child3);

            YogaNode root_child4 = new YogaNode(config);
            root_child4.Width = 30;
            root_child4.Height = 50;
            root.Insert(4, root_child4);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(80f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(70f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(60f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(60f, root_child2.LayoutX);
            Assert.AreEqual(50f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(30f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(80f, root.LayoutHeight);

            Assert.AreEqual(70f, root_child0.LayoutX);
            Assert.AreEqual(70f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(40f, root_child1.LayoutX);
            Assert.AreEqual(60f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(50f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(70f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(40f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);
        }

        [Test]
        public void Test_wrap_reverse_row_single_line_different_size()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.Wrap = YogaWrap.WrapReverse;
            root.Width = 300;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 10;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 40;
            root.Insert(3, root_child3);

            YogaNode root_child4 = new YogaNode(config);
            root_child4.Width = 30;
            root_child4.Height = 50;
            root.Insert(4, root_child4);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(300f, root.LayoutWidth);
            Assert.AreEqual(50f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(40f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(30f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(60f, root_child2.LayoutX);
            Assert.AreEqual(20f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(90f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(120f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(300f, root.LayoutWidth);
            Assert.AreEqual(50f, root.LayoutHeight);

            Assert.AreEqual(270f, root_child0.LayoutX);
            Assert.AreEqual(40f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(240f, root_child1.LayoutX);
            Assert.AreEqual(30f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(210f, root_child2.LayoutX);
            Assert.AreEqual(20f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(180f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(150f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);
        }

        [Test]
        public void Test_wrap_reverse_row_align_content_stretch()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignContent = YogaAlign.Stretch;
            root.Wrap = YogaWrap.WrapReverse;
            root.Width = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 10;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 40;
            root.Insert(3, root_child3);

            YogaNode root_child4 = new YogaNode(config);
            root_child4.Width = 30;
            root_child4.Height = 50;
            root.Insert(4, root_child4);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(80f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(70f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(60f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(60f, root_child2.LayoutX);
            Assert.AreEqual(50f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(30f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(80f, root.LayoutHeight);

            Assert.AreEqual(70f, root_child0.LayoutX);
            Assert.AreEqual(70f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(40f, root_child1.LayoutX);
            Assert.AreEqual(60f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(50f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(70f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(40f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);
        }

        [Test]
        public void Test_wrap_reverse_row_align_content_space_around()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.FlexDirection = YogaFlexDirection.Row;
            root.AlignContent = YogaAlign.SpaceAround;
            root.Wrap = YogaWrap.WrapReverse;
            root.Width = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 10;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 40;
            root.Insert(3, root_child3);

            YogaNode root_child4 = new YogaNode(config);
            root_child4.Width = 30;
            root_child4.Height = 50;
            root.Insert(4, root_child4);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(80f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(70f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child1.LayoutX);
            Assert.AreEqual(60f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(60f, root_child2.LayoutX);
            Assert.AreEqual(50f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(30f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(100f, root.LayoutWidth);
            Assert.AreEqual(80f, root.LayoutHeight);

            Assert.AreEqual(70f, root_child0.LayoutX);
            Assert.AreEqual(70f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(40f, root_child1.LayoutX);
            Assert.AreEqual(60f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(10f, root_child2.LayoutX);
            Assert.AreEqual(50f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(70f, root_child3.LayoutX);
            Assert.AreEqual(10f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(40f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);
        }

        [Test]
        public void Test_wrap_reverse_column_fixed_size()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.Center;
            root.Wrap = YogaWrap.WrapReverse;
            root.Width = 200;
            root.Height = 100;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 30;
            root_child0.Height = 10;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.Width = 30;
            root_child1.Height = 20;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 30;
            root_child2.Height = 30;
            root.Insert(2, root_child2);

            YogaNode root_child3 = new YogaNode(config);
            root_child3.Width = 30;
            root_child3.Height = 40;
            root.Insert(3, root_child3);

            YogaNode root_child4 = new YogaNode(config);
            root_child4.Width = 30;
            root_child4.Height = 50;
            root.Insert(4, root_child4);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(200f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(170f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(170f, root_child1.LayoutX);
            Assert.AreEqual(10f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(170f, root_child2.LayoutX);
            Assert.AreEqual(30f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(170f, root_child3.LayoutX);
            Assert.AreEqual(60f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(140f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(200f, root.LayoutWidth);
            Assert.AreEqual(100f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(30f, root_child0.LayoutWidth);
            Assert.AreEqual(10f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child1.LayoutX);
            Assert.AreEqual(10f, root_child1.LayoutY);
            Assert.AreEqual(30f, root_child1.LayoutWidth);
            Assert.AreEqual(20f, root_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child2.LayoutX);
            Assert.AreEqual(30f, root_child2.LayoutY);
            Assert.AreEqual(30f, root_child2.LayoutWidth);
            Assert.AreEqual(30f, root_child2.LayoutHeight);

            Assert.AreEqual(0f, root_child3.LayoutX);
            Assert.AreEqual(60f, root_child3.LayoutY);
            Assert.AreEqual(30f, root_child3.LayoutWidth);
            Assert.AreEqual(40f, root_child3.LayoutHeight);

            Assert.AreEqual(30f, root_child4.LayoutX);
            Assert.AreEqual(0f, root_child4.LayoutY);
            Assert.AreEqual(30f, root_child4.LayoutWidth);
            Assert.AreEqual(50f, root_child4.LayoutHeight);
        }

        [Test]
        public void Test_wrapped_row_within_align_items_center()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.Center;
            root.Width = 200;
            root.Height = 200;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.FlexDirection = YogaFlexDirection.Row;
            root_child0.Wrap = YogaWrap.Wrap;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.Width = 150;
            root_child0_child0.Height = 80;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child1 = new YogaNode(config);
            root_child0_child1.Width = 80;
            root_child0_child1.Height = 80;
            root_child0.Insert(1, root_child0_child1);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(200f, root.LayoutWidth);
            Assert.AreEqual(200f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(200f, root_child0.LayoutWidth);
            Assert.AreEqual(160f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(150f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1.LayoutX);
            Assert.AreEqual(80f, root_child0_child1.LayoutY);
            Assert.AreEqual(80f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child1.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(200f, root.LayoutWidth);
            Assert.AreEqual(200f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(200f, root_child0.LayoutWidth);
            Assert.AreEqual(160f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(150f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(120f, root_child0_child1.LayoutX);
            Assert.AreEqual(80f, root_child0_child1.LayoutY);
            Assert.AreEqual(80f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child1.LayoutHeight);
        }

        [Test]
        public void Test_wrapped_row_within_align_items_flex_start()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.FlexStart;
            root.Width = 200;
            root.Height = 200;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.FlexDirection = YogaFlexDirection.Row;
            root_child0.Wrap = YogaWrap.Wrap;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.Width = 150;
            root_child0_child0.Height = 80;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child1 = new YogaNode(config);
            root_child0_child1.Width = 80;
            root_child0_child1.Height = 80;
            root_child0.Insert(1, root_child0_child1);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(200f, root.LayoutWidth);
            Assert.AreEqual(200f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(200f, root_child0.LayoutWidth);
            Assert.AreEqual(160f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(150f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1.LayoutX);
            Assert.AreEqual(80f, root_child0_child1.LayoutY);
            Assert.AreEqual(80f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child1.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(200f, root.LayoutWidth);
            Assert.AreEqual(200f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(200f, root_child0.LayoutWidth);
            Assert.AreEqual(160f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(150f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(120f, root_child0_child1.LayoutX);
            Assert.AreEqual(80f, root_child0_child1.LayoutY);
            Assert.AreEqual(80f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child1.LayoutHeight);
        }

        [Test]
        public void Test_wrapped_row_within_align_items_flex_end()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.AlignItems = YogaAlign.FlexEnd;
            root.Width = 200;
            root.Height = 200;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.FlexDirection = YogaFlexDirection.Row;
            root_child0.Wrap = YogaWrap.Wrap;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0_child0.Width = 150;
            root_child0_child0.Height = 80;
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child1 = new YogaNode(config);
            root_child0_child1.Width = 80;
            root_child0_child1.Height = 80;
            root_child0.Insert(1, root_child0_child1);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(200f, root.LayoutWidth);
            Assert.AreEqual(200f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(200f, root_child0.LayoutWidth);
            Assert.AreEqual(160f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(150f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1.LayoutX);
            Assert.AreEqual(80f, root_child0_child1.LayoutY);
            Assert.AreEqual(80f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child1.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(200f, root.LayoutWidth);
            Assert.AreEqual(200f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(200f, root_child0.LayoutWidth);
            Assert.AreEqual(160f, root_child0.LayoutHeight);

            Assert.AreEqual(50f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(150f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(120f, root_child0_child1.LayoutX);
            Assert.AreEqual(80f, root_child0_child1.LayoutY);
            Assert.AreEqual(80f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(80f, root_child0_child1.LayoutHeight);
        }

        [Test]
        public void Test_wrapped_column_max_height()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.JustifyContent = YogaJustify.Center;
            root.AlignContent = YogaAlign.Center;
            root.AlignItems = YogaAlign.Center;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 700;
            root.Height = 500;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.Width = 100;
            root_child0.Height = 500;
            root_child0.MaxHeight = 200;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.MarginLeft = 20;
            root_child1.MarginTop = 20;
            root_child1.MarginRight = 20;
            root_child1.MarginBottom = 20;
            root_child1.Width = 200;
            root_child1.Height = 200;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 100;
            root_child2.Height = 100;
            root.Insert(2, root_child2);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(700f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(250f, root_child0.LayoutX);
            Assert.AreEqual(30f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(200f, root_child0.LayoutHeight);

            Assert.AreEqual(200f, root_child1.LayoutX);
            Assert.AreEqual(250f, root_child1.LayoutY);
            Assert.AreEqual(200f, root_child1.LayoutWidth);
            Assert.AreEqual(200f, root_child1.LayoutHeight);

            Assert.AreEqual(420f, root_child2.LayoutX);
            Assert.AreEqual(200f, root_child2.LayoutY);
            Assert.AreEqual(100f, root_child2.LayoutWidth);
            Assert.AreEqual(100f, root_child2.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(700f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(350f, root_child0.LayoutX);
            Assert.AreEqual(30f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(200f, root_child0.LayoutHeight);

            Assert.AreEqual(300f, root_child1.LayoutX);
            Assert.AreEqual(250f, root_child1.LayoutY);
            Assert.AreEqual(200f, root_child1.LayoutWidth);
            Assert.AreEqual(200f, root_child1.LayoutHeight);

            Assert.AreEqual(180f, root_child2.LayoutX);
            Assert.AreEqual(200f, root_child2.LayoutY);
            Assert.AreEqual(100f, root_child2.LayoutWidth);
            Assert.AreEqual(100f, root_child2.LayoutHeight);
        }

        [Test]
        public void Test_wrapped_column_max_height_flex()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.JustifyContent = YogaJustify.Center;
            root.AlignContent = YogaAlign.Center;
            root.AlignItems = YogaAlign.Center;
            root.Wrap = YogaWrap.Wrap;
            root.Width = 700;
            root.Height = 500;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.FlexGrow = 1;
            root_child0.FlexShrink = 1;
            root_child0.FlexBasis = 0.Percent();
            root_child0.Width = 100;
            root_child0.Height = 500;
            root_child0.MaxHeight = 200;
            root.Insert(0, root_child0);

            YogaNode root_child1 = new YogaNode(config);
            root_child1.FlexGrow = 1;
            root_child1.FlexShrink = 1;
            root_child1.FlexBasis = 0.Percent();
            root_child1.MarginLeft = 20;
            root_child1.MarginTop = 20;
            root_child1.MarginRight = 20;
            root_child1.MarginBottom = 20;
            root_child1.Width = 200;
            root_child1.Height = 200;
            root.Insert(1, root_child1);

            YogaNode root_child2 = new YogaNode(config);
            root_child2.Width = 100;
            root_child2.Height = 100;
            root.Insert(2, root_child2);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(700f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(300f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(180f, root_child0.LayoutHeight);

            Assert.AreEqual(250f, root_child1.LayoutX);
            Assert.AreEqual(200f, root_child1.LayoutY);
            Assert.AreEqual(200f, root_child1.LayoutWidth);
            Assert.AreEqual(180f, root_child1.LayoutHeight);

            Assert.AreEqual(300f, root_child2.LayoutX);
            Assert.AreEqual(400f, root_child2.LayoutY);
            Assert.AreEqual(100f, root_child2.LayoutWidth);
            Assert.AreEqual(100f, root_child2.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(700f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(300f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(100f, root_child0.LayoutWidth);
            Assert.AreEqual(180f, root_child0.LayoutHeight);

            Assert.AreEqual(250f, root_child1.LayoutX);
            Assert.AreEqual(200f, root_child1.LayoutY);
            Assert.AreEqual(200f, root_child1.LayoutWidth);
            Assert.AreEqual(180f, root_child1.LayoutHeight);

            Assert.AreEqual(300f, root_child2.LayoutX);
            Assert.AreEqual(400f, root_child2.LayoutY);
            Assert.AreEqual(100f, root_child2.LayoutWidth);
            Assert.AreEqual(100f, root_child2.LayoutHeight);
        }

        [Test]
        public void Test_wrap_nodes_with_content_sizing_overflowing_margin()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.Width = 500;
            root.Height = 500;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.FlexDirection = YogaFlexDirection.Row;
            root_child0.Wrap = YogaWrap.Wrap;
            root_child0.Width = 85;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child0_child0 = new YogaNode(config);
            root_child0_child0_child0.Width = 40;
            root_child0_child0_child0.Height = 40;
            root_child0_child0.Insert(0, root_child0_child0_child0);

            YogaNode root_child0_child1 = new YogaNode(config);
            root_child0_child1.MarginRight = 10;
            root_child0.Insert(1, root_child0_child1);

            YogaNode root_child0_child1_child0 = new YogaNode(config);
            root_child0_child1_child0.Width = 40;
            root_child0_child1_child0.Height = 40;
            root_child0_child1.Insert(0, root_child0_child1_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(85f, root_child0.LayoutWidth);
            Assert.AreEqual(80f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1.LayoutX);
            Assert.AreEqual(40f, root_child0_child1.LayoutY);
            Assert.AreEqual(40f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child1_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child1_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child1_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(415f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(85f, root_child0.LayoutWidth);
            Assert.AreEqual(80f, root_child0.LayoutHeight);

            Assert.AreEqual(45f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child0_child0.LayoutHeight);

            Assert.AreEqual(35f, root_child0_child1.LayoutX);
            Assert.AreEqual(40f, root_child0_child1.LayoutY);
            Assert.AreEqual(40f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child1_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child1_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child1_child0.LayoutHeight);
        }

        [Test]
        public void Test_wrap_nodes_with_content_sizing_margin_cross()
        {
            YogaConfig config = new YogaConfig();

            YogaNode root = new YogaNode(config);
            root.Width = 500;
            root.Height = 500;

            YogaNode root_child0 = new YogaNode(config);
            root_child0.FlexDirection = YogaFlexDirection.Row;
            root_child0.Wrap = YogaWrap.Wrap;
            root_child0.Width = 70;
            root.Insert(0, root_child0);

            YogaNode root_child0_child0 = new YogaNode(config);
            root_child0.Insert(0, root_child0_child0);

            YogaNode root_child0_child0_child0 = new YogaNode(config);
            root_child0_child0_child0.Width = 40;
            root_child0_child0_child0.Height = 40;
            root_child0_child0.Insert(0, root_child0_child0_child0);

            YogaNode root_child0_child1 = new YogaNode(config);
            root_child0_child1.MarginTop = 10;
            root_child0.Insert(1, root_child0_child1);

            YogaNode root_child0_child1_child0 = new YogaNode(config);
            root_child0_child1_child0.Width = 40;
            root_child0_child1_child0.Height = 40;
            root_child0_child1.Insert(0, root_child0_child1_child0);
            root.StyleDirection = YogaDirection.LTR;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(0f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(70f, root_child0.LayoutWidth);
            Assert.AreEqual(90f, root_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1.LayoutX);
            Assert.AreEqual(50f, root_child0_child1.LayoutY);
            Assert.AreEqual(40f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child1_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child1_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child1_child0.LayoutHeight);

            root.StyleDirection = YogaDirection.RTL;
            root.CalculateLayout();

            Assert.AreEqual(0f, root.LayoutX);
            Assert.AreEqual(0f, root.LayoutY);
            Assert.AreEqual(500f, root.LayoutWidth);
            Assert.AreEqual(500f, root.LayoutHeight);

            Assert.AreEqual(430f, root_child0.LayoutX);
            Assert.AreEqual(0f, root_child0.LayoutY);
            Assert.AreEqual(70f, root_child0.LayoutWidth);
            Assert.AreEqual(90f, root_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child0.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child0_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child0_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child0_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child0_child0.LayoutHeight);

            Assert.AreEqual(30f, root_child0_child1.LayoutX);
            Assert.AreEqual(50f, root_child0_child1.LayoutY);
            Assert.AreEqual(40f, root_child0_child1.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child1.LayoutHeight);

            Assert.AreEqual(0f, root_child0_child1_child0.LayoutX);
            Assert.AreEqual(0f, root_child0_child1_child0.LayoutY);
            Assert.AreEqual(40f, root_child0_child1_child0.LayoutWidth);
            Assert.AreEqual(40f, root_child0_child1_child0.LayoutHeight);
        }

    }
}
