<%@ page contentType="text/html;charset=UTF-8"%>
<%@ include file="/WEB-INF/views/modules/cms/front/include/taglib.jsp"%>
<!DOCTYPE html>
<html>
<head>
	<title>${category.name}</title>
	<meta name="decorator" content="cms_default_${site.theme}"/>
	<meta name="description" content="${category.description}" />
	<meta name="keywords" content="${category.keywords}" />
	<%@include file="/WEB-INF/views/modules/cms/front/include/head.jsp" %>
	<link href="${ctxStaticView}/cms/front/theme.css" type="text/css" rel="stylesheet" />
</head>
<body>
	<%@ include file="/WEB-INF/views/modules/cms/front/themes/basic/layouts/default_head.jsp"%>
	<div class="row">
	   <div class="span2">
	   	 <h4>栏目列表</h4>
		 <ol style="list-style-type: none;">
		 	<cms:frontCategoryList categoryList="${categoryList}"/>
		 </ol>
		 <h4>推荐阅读</h4>
		 <ol  style="list-style-type: none;">
		 	<cms:frontArticleHitsTop category="${category}"/>
		 </ol>
	   </div>
	   <div class="span10">
		 <ul class="breadcrumb">
		    <cms:frontCurrentPosition category="${category}"/>
		 </ul>
	   </div>
       <div class="span10">
		  <h4>${category.name}</h4>
		  <c:if test="${category.module eq 'article'}">
			<ul><c:forEach items="${page.list}" var="article">
				<li>
					<img src="<c:if test="${empty article.image || article.image eq null}">/staticViews/cms/images/info.png</c:if><c:if test="${!empty article.image && article.image ne null}">${article.image}</c:if>" style="width: 100%;height: auto">
					<span class="pull-right"><fmt:formatDate value="${article.updateDate}" pattern="yyyy.MM.dd"/></span>
					<a href="${article.url}" style="color:${article.color}">${fns:abbr(article.title,96)}</a></li>
			</c:forEach></ul>
			<div class="pagination">${page.getPageHtml()}</div>
			<script type="text/javascript">
				function page(n,s){
					location="${ctx}/list-${category.id}${urlSuffix}?pageNo="+n+"&pageSize="+s;
				}
			</script>
		  </c:if>
		  <c:if test="${category.module eq 'link'}">
			<ul><c:forEach items="${page.list}" var="link">
				<li><a href="${link.href}" target="_blank" style="color:${link.color}"><c:out value="${link.title}" /></a></li>
			</c:forEach></ul>
		  </c:if>
  	  </div>
   </div>
	<%@ include file="/WEB-INF/views/modules/cms/front/themes/basic/layouts/default_footer.jsp"%>
</body>
</html>