;;;=========================================================================
;;;      ִ/ת(ļҳ) HZCOVERT.LSP
;;;-------------------------------------------------------------------------
;;; ԴأȨԭߣԴȪֻ޸ĵ
;;;=========================================================================
;;; ע1)ļԴȪƵsys\librayļУÿûԵã
;;;     2)֤תϢȷģУ
;;;
;;; 2019/5/17


(defun c:j2f()
    (princ "\n****ļת(ļҳ)")
    (hzCharConvert nil)
)

(defun c:f2j()
    (princ "\n****ķת(ļҳ)")
    (hzCharConvert t)
)

(princ "\n===========================================")
(princ "\n ִ/ת(ļҳ)")
(princ "\n     ת: j2f  ת: f2j")
(princ "\n===========================================")




(defun hzCharConvert (IsRev / SimpleCharSet TraditionalCharSet Text:CharConvert cmdfun)

(defun cmdfun (IsRev / i sel ent obj txt AcDoc dxf typ)
  (if (setq sel (ssget '((0 . "*TEXT,INSERT,ATTDEF"))))
    (progn
      (setq AcDoc (vla-get-ActiveDocument (vlax-get-acad-object)))
      (vla-StartUndoMark AcDoc)
      (setq i 0)
      (repeat (sslength sel)
        (setq ent (ssname sel i))
        (setq dxf (entget ent))
        (setq obj (vlax-ename->vla-object ent))
        (setq Typ (cdr (assoc 0 dxf)))
        (cond
          ( (vlax-property-available-p obj 'textstring)
            (setq txt (vla-get-TextString obj))
            (vla-put-textstring obj (Text:CharConvert txt IsRev))
            (if (= Typ "ATTDEF")
              (progn
                (setq txt (vla-get-tagstring obj))
                (vla-put-tagstring obj (Text:CharConvert txt IsRev))
              )
            )
          )
          ( (= Typ "INSERT")
            (foreach Att (vlax-invoke obj 'GetAttributes)
              (setq txt (vla-get-tagstring Att))
              (vla-put-tagstring Att (Text:CharConvert txt IsRev))
              (setq txt (vla-get-textstring Att))
              (vla-put-textstring Att (Text:CharConvert txt IsRev))
            )
          )
        )
        (setq i (1+ i))
      )
      (vla-EndUndoMark AcDoc)
      (vlax-release-object AcDoc)
      (princ "\nת!У")
    )
  )
  (princ)
)



;;;=============================================================
;;; ܣַͷַת
;;; 룺ַ
;;; תַ
;;;=============================================================
(defun Text:CharConvert (text IsRev / Index NewTxt Str From to)
  (if IsRev
    (setq From TraditionalCharset
          To SimpleCharSet
    )
    (setq From SimpleCharSet
          To TraditionalCharset
    )
  )
  (setq NewTxt "")
  (while (/= text "")
    (setq str (substr text 1 1))
    (if (> (ascii str) 128)
      (progn
        (setq str (substr text 1 2))
        (setq text (substr text 3))
        (if (setq index (VL-POSITION str From))
          (setq str (nth index To))
        )
      )
      (setq str (substr text 1 1)
            text (substr text 2)
      )
    )
    (setq newtxt (strcat newtxt str))
  )
  newtxt
)



(setq
  SimpleCharSet
  (mapcar
    'vl-list->string
    '(
        (205 242)(211 235)(179 243)(215 168)(210 181)(180 212)(182 171)(203 191)(182 170)(193 189)(209 207)(201 165)(184 246)(227 220)(183 225)(193 217)(206 170)(192 246)(190 217)(195 180)
        (210 229)(206 218)(192 214)(199 199)(207 176)(207 231)(202 233)(194 242)(194 210)(213 249)(211 218)(191 247)(212 198)(216 168)(209 199)(178 250)(196 182)(199 215)(217 244)(129 143)
        (210 218)(189 246)(180 211)(194 216)(178 214)(210 199)(195 199)(188 219)(214 218)(211 197)(187 239)(187 225)(216 241)(201 161)(206 176)(180 171)(201 203)(216 246)(194 215)(216 247)
        (206 177)(216 249)(204 229)(211 224)(211 182)(217 221)(207 192)(194 194)(189 196)(213 236)(178 224)(199 200)(191 235)(217 173)(217 175)(217 182)(217 177)(217 178)(193 169)(217 179)
        (188 243)(213 174)(199 227)(217 204)(217 205)(217 199)(179 165)(217 206)(217 207)(180 162)(217 208)(182 249)(182 210)(217 240)(181 179)(192 188)(185 216)(208 203)(215 200)(209 248)
        (202 222)(217 230)(196 218)(184 212)(178 225)(208 180)(190 252)(197 169)(218 163)(183 235)(179 229)(190 246)(191 246)(182 179)(190 187)(198 224)(193 185)(193 232)(188 245)(180 213)
        (193 221)(188 184)(183 239)(217 236)(198 190)(191 173)(187 247)(219 202)(212 228)(219 187)(187 174)(193 245)(212 242)(184 213)(180 180)(201 190)(177 240)(132 105)(216 217)(185 244)
        (216 219)(216 220)(188 193)(185 208)(189 163)(176 254)(190 231)(200 176)(176 236)(206 241)(219 189)(182 175)(192 248)(190 162)(192 205)(202 198)(209 171)(219 194)(132 214)(212 200)
        (216 208)(216 209)(199 248)(210 189)(187 170)(208 173)(181 165)(194 244)(194 172)(194 177)(206 212)(206 192)(200 180)(218 225)(179 167)(204 252)(192 250)(192 247)(209 185)(209 225)
        (216 199)(178 222)(207 225)(216 201)(207 195)(179 248)(190 199)(216 203)(207 216)(178 206)(133 165)(133 166)(203 171)(183 162)(177 228)(208 240)(181 254)(210 182)(186 197)(204 190)
        (223 180)(211 245)(186 243)(207 197)(194 192)(194 240)(223 196)(182 214)(204 253)(198 244)(206 226)(223 188)(223 189)(197 187)(223 191)(223 194)(212 177)(223 195)(199 186)(206 216)
        (211 189)(223 199)(193 252)(223 204)(223 208)(223 229)(223 212)(207 204)(223 223)(207 236)(209 198)(223 213)(223 216)(223 217)(223 220)(187 169)(223 224)(223 226)(223 230)(211 180)
        (223 233)(134 121)(223 235)(134 124)(223 239)(223 240)(187 189)(223 252)(223 245)(216 196)(223 249)(196 246)(134 170)(134 174)(208 165)(197 231)(224 182)(224 183)(224 191)(186 199)
        (224 200)(208 234)(224 211)(214 246)(224 224)(224 232)(207 249)(224 235)(205 197)(212 176)(180 209)(206 167)(224 240)(185 250)(205 188)(212 178)(202 165)(219 219)(179 161)(219 224)
        (187 181)(191 233)(188 225)(204 179)(219 222)(176 211)(206 235)(183 216)(215 185)(194 162)(219 226)(219 228)(192 221)(191 209)(219 240)(219 209)(181 230)(219 235)(136 153)(136 155)
        (219 238)(219 241)(219 245)(219 247)(219 246)(219 254)(219 251)(199 181)(182 233)(137 71)(199 189)(215 179)(201 249)(191 199)(186 248)(137 215)(180 166)(177 184)(184 180)(185 187)
        (205 183)(191 228)(188 208)(182 225)(222 198)(219 188)(183 220)(189 177)(176 194)(215 177)(184 190)(194 232)(229 252)(229 253)(230 163)(230 169)(189 170)(194 166)(230 171)(230 172)
        (189 191)(230 174)(211 233)(230 180)(230 181)(139 79)(211 164)(230 191)(201 244)(230 193)(230 200)(230 201)(230 205)(230 214)(203 239)(209 167)(194 207)(196 254)(177 166)(202 181)
        (179 232)(201 243)(207 220)(185 172)(191 237)(177 246)(199 222)(182 212)(209 176)(181 188)(202 217)(189 171)(182 251)(179 190)(210 162)(222 207)(202 172)(190 161)(178 227)(140 193)
        (204 235)(189 236)(202 244)(194 197)(229 240)(211 236)(203 234)(198 241)(225 171)(184 218)(225 173)(225 174)(225 176)(181 186)(193 235)(212 192)(225 180)(191 249)(141 78)(225 187)
        (207 191)(141 105)(225 189)(225 191)(194 205)(225 192)(225 193)(141 129)(213 184)(225 201)(141 194)(225 206)(225 208)(225 213)(225 219)(185 174)(219 207)(177 210)(203 167)(202 166)
        (224 248)(213 202)(193 177)(214 196)(180 248)(214 161)(176 239)(224 252)(224 253)(224 254)(195 221)(225 165)(184 201)(178 162)(185 227)(215 175)(199 236)(194 174)(226 208)(191 226)
        (211 166)(195 237)(197 211)(183 207)(142 246)(226 222)(191 170)(210 236)(198 250)(213 197)(195 214)(229 242)(205 228)(181 175)(199 191)(185 233)(181 177)(194 188)(143 166)(209 229)
        (179 185)(190 182)(225 226)(211 249)(210 228)(226 227)(211 199)(226 233)(187 179)(204 172)(203 203)(226 228)(226 230)(226 234)(226 235)(193 175)(215 220)(237 161)(226 248)(193 181)
        (191 210)(182 241)(226 250)(226 251)(226 253)(226 252)(196 213)(227 162)(212 195)(237 168)(208 252)(227 165)(195 245)(190 170)(190 229)(178 210)(179 205)(177 185)(227 171)(178 209)
        (181 172)(185 223)(237 170)(227 179)(183 223)(227 180)(212 184)(201 229)(145 92)(227 192)(237 175)(192 193)(227 193)(237 176)(234 167)(207 183)(234 168)(213 189)(234 175)(187 167)
        (212 250)(198 203)(199 164)(214 180)(192 169)(222 209)(201 168)(209 239)(200 197)(184 167)(197 215)(222 210)(191 217)(194 213)(199 192)(187 164)(177 168)(181 163)(196 226)(194 163)
        (188 240)(211 181)(192 185)(197 161)(178 166)(212 241)(185 210)(214 191)(194 206)(146 165)(206 206)(204 162)(208 174)(196 211)(181 178)(222 216)(213 245)(188 183)(187 211)(146 166)
        (192 204)(203 240)(188 241)(187 187)(181 183)(190 221)(196 237)(194 176)(222 226)(214 192)(181 167)(178 244)(222 232)(222 234)(192 191)(222 236)(178 243)(184 233)(194 167)(189 193)
        (208 175)(201 227)(222 243)(176 218)(210 161)(177 247)(204 175)(222 252)(179 197)(196 236)(223 162)(223 163)(223 165)(203 211)(212 220)(181 208)(193 178)(202 253)(213 171)(236 181)
        (182 183)(213 182)(182 207)(206 222)(190 201)(202 177)(191 245)(149 68)(234 188)(214 231)(149 111)(207 212)(189 250)(201 185)(207 254)(234 202)(212 206)(234 205)(212 221)(234 211)
        (212 253)(202 245)(198 211)(187 250)(201 177)(212 211)(200 168)(204 245)(192 180)(209 238)(232 191)(189 220)(188 171)(185 185)(232 200)(202 224)(212 230)(232 192)(232 197)(232 199)
        (199 185)(183 227)(232 201)(185 241)(196 251)(232 223)(232 217)(213 164)(177 234)(213 187)(232 206)(232 208)(182 176)(232 211)(232 221)(192 184)(202 247)(198 220)(209 249)(232 239)
        (232 240)(232 226)(232 227)(232 229)(181 181)(232 231)(199 197)(232 235)(232 237)(189 176)(215 174)(195 206)(151 131)(151 133)(188 236)(232 249)(233 164)(232 252)(232 253)(233 161)
        (205 214)(194 165)(233 173)(233 180)(233 181)(233 183)(152 150)(188 247)(233 196)(233 198)(186 225)(233 201)(211 163)(233 205)(179 247)(233 214)(233 218)(233 220)(233 221)(187 182)
        (236 163)(197 183)(188 223)(233 226)(233 228)(178 208)(233 230)(233 231)(233 233)(233 235)(197 185)(187 217)(236 177)(177 207)(177 208)(213 177)(235 167)(235 170)(198 248)(199 226)
        (235 178)(235 181)(187 227)(186 186)(206 219)(204 192)(208 218)(237 179)(185 181)(195 187)(227 227)(197 189)(193 164)(194 217)(178 215)(155 104)(227 237)(187 166)(155 109)(197 162)
        (192 225)(237 180)(227 241)(227 242)(227 248)(208 186)(198 195)(212 243)(227 254)(189 224)(200 247)(205 221)(228 164)(199 179)(189 172)(189 189)(228 165)(155 184)(215 199)(178 226)
        (228 171)(188 195)(228 175)(155 186)(187 235)(228 176)(197 168)(228 177)(155 187)(205 191)(211 191)(204 206)(192 212)(228 181)(193 176)(228 182)(206 208)(155 233)(187 193)(181 211)
        (200 243)(189 167)(213 199)(201 172)(181 237)(212 168)(228 203)(215 213)(228 194)(189 165)(228 197)(211 230)(228 201)(201 248)(206 194)(211 206)(205 229)(202 170)(192 163)(189 166)
        (228 211)(156 190)(228 228)(185 246)(214 205)(228 217)(228 220)(194 250)(228 222)(194 203)(192 196)(194 208)(177 245)(204 178)(156 249)(228 237)(228 235)(228 236)(228 242)(206 171)
        (199 177)(228 243)(192 189)(228 254)(177 244)(229 176)(195 240)(181 198)(193 233)(212 214)(178 211)(236 190)(194 175)(236 192)(236 191)(236 193)(181 227)(193 182)(179 227)(203 184)
        (192 195)(204 254)(214 242)(209 204)(183 179)(201 213)(236 199)(187 226)(204 204)(189 253)(200 200)(187 192)(236 203)(236 226)(236 209)(236 206)(236 214)(176 174)(210 175)(235 185)
        (234 243)(199 163)(206 254)(182 191)(234 241)(215 180)(225 238)(225 239)(211 204)(177 183)(225 243)(170 65)(196 252)(182 192)(207 193)(202 168)(225 246)(213 248)(211 252)(225 248)
        (225 253)(193 212)(226 168)(226 164)(214 237)(195 168)(226 172)(207 215)(204 161)(231 225)(171 95)(171 96)(194 234)(231 226)(187 183)(207 214)(171 111)(231 244)(231 235)(231 229)
        (183 169)(231 231)(171 154)(231 245)(172 81)(231 246)(203 246)(199 237)(209 254)(232 168)(232 175)(232 172)(232 182)(206 205)(234 177)(181 231)(187 173)(179 169)(238 180)(179 235)
        (240 220)(193 198)(197 177)(240 221)(209 241)(240 223)(180 175)(183 232)(240 229)(240 226)(211 184)(190 183)(209 247)(240 233)(240 236)(187 190)(240 239)(179 213)(240 247)(175 125)
        (240 249)(240 252)(177 241)(204 177)(241 171)(241 168)(241 174)(209 162)(241 178)(241 179)(176 168)(214 229)(241 228)(213 181)(209 206)(188 224)(184 199)(181 193)(197 204)(237 238)
        (237 246)(177 128)(215 197)(213 246)(237 249)(237 250)(194 247)(214 245)(189 195)(237 182)(183 175)(191 243)(237 184)(194 235)(215 169)(237 186)(209 226)(237 191)(237 194)(237 195)
        (192 249)(180 161)(179 110)(185 232)(203 182)(237 204)(237 205)(179 125)(179 126)(200 183)(188 239)(176 173)(237 211)(237 215)(188 238)(237 219)(237 222)(192 241)(181 116)(236 242)
        (236 245)(181 187)(187 246)(217 247)(194 187)(236 248)(192 235)(205 186)(184 209)(214 214)(187 253)(179 198)(187 224)(182 140)(239 249)(203 176)(246 213)(206 200)(240 163)(199 238)
        (199 212)(199 207)(210 164)(180 220)(206 209)(191 250)(241 188)(241 192)(202 250)(190 186)(243 198)(203 241)(177 202)(243 200)(188 227)(193 253)(243 214)(214 254)(243 217)(201 184)
        (185 89)(243 221)(179 239)(199 169)(188 242)(185 130)(243 229)(243 230)(243 234)(194 225)(243 236)(243 239)(243 241)(194 168)(192 186)(192 233)(243 253)(244 165)(217 225)(192 224)
        (244 204)(244 208)(244 207)(212 193)(183 224)(193 184)(244 214)(244 215)(189 244)(244 234)(230 249)(190 192)(230 250)(186 236)(230 251)(207 203)(230 252)(212 188)(188 182)(230 253)
        (230 254)(188 205)(200 210)(206 179)(231 161)(192 128)(180 191)(231 162)(201 180)(184 217)(196 201)(192 129)(215 221)(194 218)(183 215)(214 189)(206 198)(183 196)(192 130)(192 131)
        (197 166)(231 163)(207 223)(231 164)(231 165)(231 166)(193 183)(215 233)(201 240)(207 184)(214 175)(214 213)(231 167)(176 237)(231 168)(231 169)(201 220)(210 239)(190 173)(231 170)
        (176 243)(200 222)(189 225)(231 171)(200 198)(192 132)(231 172)(187 230)(184 248)(209 164)(231 173)(194 231)(190 248)(189 202)(205 179)(231 174)(231 175)(190 238)(208 229)(192 133)
        (203 231)(204 208)(188 204)(231 176)(188 168)(208 247)(231 177)(192 134)(208 248)(231 178)(231 179)(180 194)(231 180)(231 181)(201 254)(206 172)(195 224)(231 183)(177 193)(179 241)
        (192 135)(231 184)(231 185)(215 219)(213 192)(231 186)(194 204)(215 186)(231 187)(231 188)(231 189)(188 234)(195 229)(192 194)(231 190)(231 191)(188 169)(192 136)(231 192)(231 193)
        (231 182)(182 208)(231 194)(192 137)(231 195)(231 196)(187 186)(181 222)(194 198)(177 224)(231 197)(212 181)(231 198)(184 191)(231 200)(231 199)(183 236)(192 138)(231 201)(178 248)
        (231 202)(231 203)(231 204)(231 205)(231 206)(231 207)(231 208)(211 167)(203 245)(231 209)(231 210)(231 211)(231 212)(201 201)(231 213)(231 214)(231 215)(231 216)(231 217)(189 201)
        (231 218)(243 191)(205 248)(194 222)(183 163)(176 213)(238 188)(238 191)(244 199)(207 219)(199 204)(193 153)(193 154)(241 236)(241 239)(203 202)(179 220)(196 244)(193 251)(214 176)
        (241 247)(193 170)(241 249)(180 207)(203 224)(179 166)(183 244)(235 201)(201 246)(214 215)(213 205)(208 178)(181 168)(202 164)(235 202)(235 203)(235 205)(235 214)(189 186)(194 246)
        (235 218)(212 224)(198 234)(196 212)(197 167)(217 245)(189 197)(205 209)(235 225)(193 179)(192 176)(235 231)(196 78)(235 241)(196 229)(235 239)(235 240)(204 218)(235 247)(197 72)
        (211 223)(244 175)(189 162)(178 213)(244 181)(188 232)(209 222)(220 179)(210 213)(189 218)(216 194)(220 188)(206 223)(194 171)(220 202)(206 173)(220 194)(220 200)(220 201)(178 212)
        (220 209)(203 213)(220 220)(198 187)(190 165)(220 215)(220 224)(220 227)(220 228)(188 235)(190 163)(188 246)(199 81)(188 212)(220 233)(220 234)(220 241)(220 246)(220 249)(181 180)
        (200 217)(187 231)(220 254)(220 253)(211 171)(221 161)(221 163)(221 165)(210 241)(221 164)(221 166)(221 167)(210 169)(221 176)(221 175)(192 179)(193 171)(221 170)(221 171)(221 178)
        (187 241)(221 181)(211 168)(221 186)(221 187)(200 91)(194 220)(211 169)(211 170)(221 211)(207 244)(200 248)(180 208)(221 219)(221 222)(189 175)(221 228)(192 182)(188 187)(221 241)
        (221 247)(221 246)(221 235)(199 190)(221 252)(221 254)(176 170)(222 173)(212 204)(222 180)(222 187)(222 186)(194 178)(194 199)(208 233)(179 230)(242 176)(242 177)(203 228)(207 186)
        (242 178)(202 180)(210 207)(194 236)(178 207)(242 186)(242 185)(185 198)(242 195)(242 201)(194 249)(213 221)(242 204)(242 205)(242 207)(242 211)(205 201)(206 207)(192 175)(211 172)
        (242 229)(178 245)(208 171)(242 247)(242 238)(206 133)(242 253)(207 93)(208 198)(207 206)(178 185)(179 196)(217 242)(176 192)(244 193)(208 132)(205 224)(207 174)(209 66)(215 176)
        (241 201)(209 84)(241 205)(241 207)(191 227)(241 208)(241 218)(241 220)(241 223)(210 91)(188 251)(185 219)(211 95)(185 230)(195 217)(202 211)(234 232)(192 192)(190 245)(234 233)
        (234 234)(234 235)(211 96)(234 236)(234 237)(234 238)(234 239)(245 252)(180 165)(246 163)(212 128)(211 254)(204 220)(218 165)(188 198)(182 169)(184 188)(200 207)(188 165)(218 166)
        (218 167)(204 214)(200 195)(218 168)(198 253)(209 181)(210 233)(209 182)(188 199)(215 154)(189 178)(187 228)(218 169)(218 170)(209 200)(218 171)(208 237)(182 239)(194 219)(215 155)
        (203 207)(183 237)(201 232)(183 195)(190 247)(214 164)(218 172)(218 173)(198 192)(215 231)(202 182)(215 156)(213 169)(203 223)(213 239)(218 174)(214 223)(180 202)(218 176)(218 175)
        (215 157)(210 235)(218 177)(218 178)(218 179)(202 212)(218 180)(202 171)(218 181)(218 182)(179 207)(214 239)(218 183)(187 176)(181 174)(218 184)(218 185)(185 238)(209 175)(210 232)
        (218 186)(184 195)(207 234)(178 239)(218 187)(218 188)(215 158)(189 235)(206 220)(211 239)(218 189)(206 243)(218 190)(211 213)(187 229)(218 191)(203 181)(203 208)(218 192)(199 235)
        (214 238)(218 193)(197 181)(182 193)(218 194)(183 204)(191 206)(218 195)(218 196)(203 173)(218 197)(181 247)(218 198)(193 194)(215 187)(218 199)(204 184)(210 234)(196 177)(218 200)
        (181 253)(187 209)(218 201)(208 179)(218 202)(218 203)(206 189)(218 204)(218 205)(218 206)(178 247)(218 209)(218 207)(209 232)(218 208)(195 213)(218 210)(215 160)(218 211)(218 212)
        (218 213)(208 187)(210 165)(176 249)(218 214)(199 171)(218 215)(189 247)(195 161)(218 216)(218 217)(195 253)(204 183)(218 218)(218 219)(192 190)(198 215)(218 220)(218 221)(199 180)
        (218 222)(218 223)(185 200)(216 107)(177 180)(213 234)(184 186)(218 79)(185 177)(178 198)(212 240)(207 205)(176 220)(213 203)(187 245)(214 202)(183 183)(204 176)(198 182)(177 225)
        (185 186)(214 252)(185 225)(183 161)(188 250)(234 218)(234 219)(204 249)(185 243)(234 220)(180 251)(195 179)(183 209)(186 216)(234 221)(212 244)(234 222)(188 214)(187 223)(234 223)
        (193 222)(194 184)(212 223)(215 202)(234 224)(234 225)(234 228)(234 226)(234 227)(201 222)(184 179)(182 196)(234 229)(202 234)(201 205)(180 205)(218 80)(218 81)(226 217)(197 226)
        (234 230)(192 181)(218 82)(215 184)(234 231)(215 172)(200 252)(216 211)(216 205)(212 222)(218 83)(212 249)(201 196)(211 174)(184 211)(218 87)(213 212)(184 207)(199 247)(244 245)
        (245 187)(212 190)(245 196)(245 197)(245 200)(188 249)(219 81)(245 206)(245 207)(245 209)(245 210)(211 187)(179 236)(215 217)(245 217)(245 220)(245 230)(245 231)(245 233)(180 218)
        (245 239)(245 242)(199 251)(179 181)(212 254)(185 236)(208 249)(222 97)(233 237)(215 170)(233 238)(194 214)(200 237)(186 228)(233 239)(233 240)(233 241)(214 225)(233 242)(233 243)
        (233 245)(233 244)(233 246)(233 247)(199 225)(233 248)(212 216)(233 249)(189 206)(222 98)(233 250)(233 251)(189 207)(233 252)(184 168)(193 190)(233 253)(177 178)(187 212)(185 245)
        (233 254)(222 99)(234 161)(234 162)(234 163)(183 248)(188 173)(222 100)(202 228)(224 206)(212 175)(207 189)(213 183)(234 164)(213 222)(234 165)(180 199)(177 231)(177 232)(177 223)
        (193 201)(180 239)(199 168)(185 253)(194 245)(212 203)(187 185)(213 226)(189 248)(212 182)(206 165)(193 172)(179 217)(229 199)(229 201)(188 163)(202 202)(209 161)(209 183)(181 221)
        (229 206)(194 223)(210 197)(210 163)(181 203)(218 247)(218 249)(211 202)(215 222)(218 254)(193 218)(211 244)(219 167)(219 163)(219 166)(214 163)(219 169)(219 170)(212 199)(181 166)
        (212 205)(225 78)(189 180)(245 166)(245 167)(196 240)(202 205)(192 239)(226 160)(188 248)(246 199)(246 201)(238 197)(238 198)(213 235)(182 164)(238 200)(238 199)(238 201)(238 202)
        (199 165)(238 203)(238 204)(232 149)(183 176)(181 246)(238 205)(238 207)(232 150)(238 206)(232 151)(184 198)(238 208)(238 209)(182 219)(179 174)(214 211)(196 198)(177 181)(184 214)
        (238 211)(238 212)(212 191)(199 213)(190 251)(206 217)(185 179)(238 214)(238 213)(238 216)(238 215)(197 165)(238 217)(238 218)(199 174)(238 219)(199 175)(238 220)(178 167)(238 221)
        (238 222)(238 223)(238 224)(238 225)(215 234)(238 226)(238 227)(188 216)(238 228)(211 203)(204 250)(178 172)(193 229)(238 229)(199 166)(195 173)(238 230)(238 231)(238 232)(238 233)
        (238 235)(238 236)(232 153)(238 237)(238 238)(238 239)(238 240)(238 242)(238 244)(238 243)(232 156)(238 245)(205 173)(194 193)(238 246)(238 247)(238 248)(213 161)(238 249)(207 179)
        (238 250)(238 251)(232 157)(238 252)(238 253)(238 254)(239 162)(184 245)(195 250)(239 163)(239 164)(189 194)(210 191)(178 249)(239 165)(239 166)(239 167)(210 248)(239 168)(214 253)
        (239 169)(198 204)(232 158)(239 170)(239 171)(193 180)(239 172)(207 250)(203 248)(239 174)(239 173)(179 250)(185 248)(239 175)(239 176)(208 226)(239 177)(239 178)(183 230)(208 191)
        (239 179)(239 180)(239 181)(200 241)(204 224)(239 182)(239 183)(239 184)(239 185)(239 186)(213 224)(180 237)(195 170)(232 159)(239 190)(239 191)(232 160)(206 253)(239 192)(194 224)
        (180 184)(215 182)(189 245)(207 199)(239 195)(239 194)(239 196)(182 167)(188 252)(190 226)(195 204)(239 197)(239 198)(233 65)(239 199)(239 207)(239 200)(239 201)(239 202)(199 194)
        (239 241)(182 205)(239 203)(233 66)(239 204)(239 205)(182 198)(195 190)(239 206)(233 67)(239 210)(213 242)(233 68)(239 211)(196 247)(239 212)(196 248)(239 213)(239 214)(184 228)
        (176 247)(239 215)(233 70)(239 218)(239 219)(239 221)(233 71)(239 222)(190 181)(239 225)(239 223)(239 224)(233 72)(239 226)(239 227)(193 205)(239 228)(239 229)(239 230)(239 231)
        (239 232)(239 233)(239 234)(239 235)(239 236)(192 216)(233 73)(239 237)(193 173)(239 238)(239 239)(239 240)(233 74)(207 226)(179 164)(195 197)(227 197)(201 193)(227 198)(234 92)
        (177 213)(206 202)(180 179)(200 242)(227 199)(207 208)(227 200)(188 228)(227 201)(227 202)(195 198)(213 162)(196 214)(185 235)(206 197)(227 203)(195 246)(227 204)(234 93)(183 167)
        (184 243)(186 210)(227 205)(227 206)(212 196)(227 207)(234 94)(227 208)(209 203)(227 209)(227 210)(227 211)(227 212)(209 214)(227 213)(178 251)(192 187)(227 214)(234 95)(192 171)
        (227 215)(227 216)(227 217)(234 96)(227 218)(227 219)(234 97)(182 211)(209 244)(210 245)(213 243)(189 215)(188 202)(194 189)(194 164)(179 194)(218 234)(201 194)(218 237)(212 201)
        (207 213)(203 230)(210 254)(193 165)(246 193)(196 209)(179 251)(246 197)(246 168)(206 237)(246 171)(195 185)(246 176)(246 166)(190 178)(216 204)(247 178)(247 179)(247 181)(247 185)
        (206 164)(200 205)(237 130)(186 171)(232 184)(232 185)(232 186)(212 207)(210 179)(182 165)(199 234)(241 252)(207 238)(203 179)(208 235)(231 239)(205 231)(185 203)(182 217)(241 253)
        (176 228)(203 204)(241 254)(212 164)(194 173)(193 236)(198 196)(190 177)(242 161)(188 213)(239 70)(242 162)(242 163)(239 71)(242 164)(210 195)(198 181)(239 72)(205 199)(242 165)
        (239 73)(211 177)(191 197)(204 226)(239 74)(242 166)(242 167)(209 213)(182 238)(242 168)(242 169)(181 223)(242 170)(242 171)(239 75)(178 252)(242 172)(242 173)(200 167)(183 231)
        (239 114)(239 115)(236 169)(236 170)(236 171)(239 116)(236 172)(239 117)(239 118)(198 174)(236 173)(236 174)(183 201)(247 207)(247 208)(240 151)(188 162)(240 152)(226 188)(226 189)
        (226 190)(226 191)(226 192)(226 193)(183 185)(210 251)(189 164)(202 206)(177 165)(203 199)(240 153)(226 194)(182 252)(200 196)(226 195)(240 154)(240 155)(189 200)(240 156)(177 253)
        (226 196)(240 157)(182 246)(226 197)(196 217)(240 158)(240 159)(226 198)(207 218)(185 221)(226 199)(192 161)(240 160)(226 200)(178 246)(241 64)(226 201)(241 65)(193 243)(226 202)
        (226 203)(194 248)(226 204)(226 205)(226 206)(194 237)(212 166)(205 212)(209 177)(179 219)(199 253)(243 82)(178 181)(194 191)(230 224)(202 187)(230 225)(230 226)(190 212)(230 227)
        (215 164)(205 213)(230 229)(188 221)(230 228)(230 230)(230 231)(194 238)(243 83)(189 190)(230 232)(194 230)(186 167)(230 233)(243 84)(230 234)(179 210)(209 233)(243 85)(243 86)
        (191 165)(230 235)(198 239)(230 236)(230 237)(243 87)(243 88)(230 238)(198 173)(230 239)(243 89)(201 167)(230 240)(230 241)(230 242)(229 185)(230 243)(230 244)(194 226)(230 245)
        (230 246)(214 232)(230 247)(243 90)(230 248)(247 195)(247 197)(247 198)(247 222)(247 202)(247 203)(211 227)(247 129)(247 130)(246 207)(247 131)(194 179)(246 208)(247 133)(246 209)
        (246 210)(246 211)(246 212)(247 134)(247 135)(246 214)(247 136)(177 171)(246 215)(247 137)(246 216)(246 217)(246 218)(247 138)(246 219)(246 220)(247 139)(247 140)(247 141)(247 142)
        (246 221)(246 222)(207 202)(247 143)(246 223)(246 224)(246 225)(246 226)(246 227)(246 228)(192 240)(246 229)(246 230)(246 231)(246 232)(246 233)(247 144)(246 234)(247 145)(246 235)
        (246 236)(247 146)(246 237)(246 238)(246 239)(246 240)(246 241)(246 242)(246 243)(246 244)(190 168)(247 147)(246 245)(246 246)(246 247)(246 248)(247 148)(247 149)(247 150)(247 151)
        (247 152)(200 250)(246 249)(246 250)(246 251)(246 252)(247 153)(247 154)(246 253)(246 254)(247 161)(247 162)(247 163)(247 164)(247 165)(247 155)(247 156)(247 166)(247 167)(247 168)
        (177 238)(247 169)(247 170)(247 171)(247 158)(247 172)(247 173)(193 219)(247 174)(247 159)(247 160)(247 175)(248 64)(196 241)(240 175)(188 166)(240 176)(195 249)(251 92)(197 184)
        (209 187)(251 93)(240 177)(240 178)(240 179)(240 180)(240 181)(209 188)(251 94)(209 236)(251 95)(240 183)(240 182)(212 167)(251 96)(205 210)(240 184)(240 186)(240 185)(240 187)
        (240 188)(251 97)(251 98)(184 235)(240 189)(186 232)(251 99)(240 190)(240 191)(190 233)(240 192)(182 236)(240 193)(240 194)(240 195)(240 196)(200 181)(240 197)(240 198)(251 100)
        (240 199)(197 244)(251 101)(240 200)(251 102)(251 103)(251 104)(240 201)(251 105)(240 202)(247 189)(240 203)(240 204)(240 205)(251 107)(240 206)(251 108)(251 109)(251 110)(251 111)
        (240 207)(186 215)(251 112)(240 208)(240 209)(240 210)(240 211)(240 212)(240 213)(240 214)(240 216)(251 114)(211 165)(240 215)(251 115)(240 217)(251 116)(245 186)(194 243)(244 239)
        (187 198)(217 228)(252 100)(247 242)(247 245)(246 188)(246 189)(252 133)(246 190)(216 187)(247 250)(247 254)(198 235)(236 180)(179 221)(246 179)(253 134)(253 135)(246 180)(193 228)
        (246 181)(246 182)(246 183)(246 184)(246 185)(246 186)(200 163)(246 187)(193 250)(185 168)(237 232)(185 234)(214 190)(214 198)(215 201)(214 187)(192 239)(207 181)(183 182)(203 201)
        (195 187)(179 162)(179 162)(196 214)(195 230)(215 188)(214 211)(177 240)(207 208)(184 201)(190 161)(212 224)(198 180)
    )
  )
)
(setq
  TraditionalCharSet
  (mapcar
    'vl-list->string
    '(
        (200 102)(197 99)(225 104)(140 163)(152 73)(133 178)(150 124)(189 122)(129 71)(131 201)(135 192)(134 202)(130 128)(227 221)(216 83)(197 82)(158 233)(251 144)(197 101)(252 78)
        (193 120)(158 245)(152 183)(134 204)(193 149)(224 108)(149 248)(217 73)(129 121)(160 142)(236 182)(204 157)(235 133)(129 131)(129 134)(174 97)(174 128)(211 72)(210 67)(135 190)
        (131 124)(131 72)(143 196)(129 246)(130 125)(131 120)(130 131)(131 114)(177 138)(131 158)(226 183)(149 254)(130 248)(130 227)(130 165)(130 247)(130 251)(130 116)(130 144)(130 225)
        (130 206)(129 208)(243 119)(240 78)(130 242)(131 76)(130 98)(130 72)(131 101)(130 201)(130 200)(131 83)(131 126)(131 138)(131 122)(130 82)(131 137)(131 176)(130 122)(131 171)
        (131 128)(130 249)(131 65)(130 244)(131 69)(131 102)(131 148)(131 175)(131 134)(131 166)(131 174)(131 186)(131 182)(131 188)(252 104)(204 109)(234 80)(197 100)(198 157)(240 66)
        (171 70)(135 207)(131 200)(140 249)(131 212)(140 145)(220 138)(222 114)(137 86)(241 84)(208 110)(155 81)(155 114)(131 246)(156 81)(156 68)(155 246)(156 82)(156 112)(156 144)
        (132 67)(142 215)(248 80)(248 68)(145 123)(132 80)(147 244)(154 235)(232 143)(198 99)(132 157)(132 162)(132 116)(132 130)(132 147)(132 104)(132 101)(132 125)(132 113)(132 163)
        (132 165)(132 146)(132 169)(132 142)(132 166)(132 131)(132 161)(132 241)(222 107)(132 213)(132 234)(132 211)(132 238)(132 197)(132 218)(132 221)(132 236)(195 205)(132 227)(132 242)
        (133 81)(133 84)(133 94)(225 116)(200 65)(133 102)(134 206)(217 117)(177 82)(251 117)(197 80)(208 108)(133 115)(142 132)(143 83)(143 100)(149 209)(133 150)(137 186)(133 146)
        (133 135)(142 250)(142 251)(133 152)(143 66)(143 78)(142 253)(143 80)(191 104)(133 162)(236 97)(236 94)(235 112)(176 108)(215 131)(148 162)(175 66)(200 126)(204 150)(154 85)
        (135 92)(187 110)(225 225)(135 152)(133 206)(134 225)(134 119)(135 141)(194 160)(134 162)(133 199)(135 96)(135 210)(135 73)(135 179)(134 104)(134 84)(134 74)(134 220)(134 232)
        (212 129)(134 85)(135 181)(135 147)(135 122)(223 184)(135 106)(251 121)(223 201)(237 145)(134 161)(135 125)(135 94)(134 244)(135 130)(135 87)(135 136)(135 157)(135 129)(134 209)
        (135 79)(134 223)(135 90)(134 164)(134 238)(134 114)(134 190)(186 244)(135 75)(134 221)(135 202)(253 109)(135 211)(135 99)(135 91)(135 138)(135 68)(135 191)(135 203)(224 192)
        (135 134)(135 117)(135 194)(135 218)(135 163)(197 252)(135 204)(214 111)(136 70)(136 64)(135 232)(135 250)(135 247)(135 248)(136 68)(136 65)(194 125)(137 191)(136 246)(218 230)
        (137 196)(137 75)(136 212)(137 175)(137 200)(137 206)(137 93)(137 158)(137 139)(137 197)(137 197)(137 192)(137 190)(137 168)(136 115)(136 215)(137 124)(136 186)(137 161)(137 179)
        (137 78)(136 223)(137 80)(137 95)(136 229)(137 124)(136 157)(137 113)(137 153)(137 207)(160 157)(137 209)(194 149)(154 164)(137 216)(137 218)(204 142)(130 228)(209 125)(137 242)
        (238 94)(213 70)(138 65)(138 90)(138 89)(138 74)(138 94)(170 132)(138 87)(138 121)(139 68)(139 140)(139 179)(139 158)(139 130)(138 153)(203 75)(138 228)(139 73)(139 198)
        (139 201)(140 68)(138 202)(139 122)(139 185)(139 189)(139 235)(139 200)(139 240)(139 139)(139 220)(139 229)(139 212)(139 223)(140 79)(140 87)(140 92)(140 142)(140 154)(140 141)
        (140 153)(140 143)(145 151)(140 109)(140 146)(217 101)(140 139)(140 166)(140 164)(140 167)(137 219)(140 162)(160 150)(137 109)(136 242)(140 192)(140 198)(177 77)(140 211)(140 218)
        (140 207)(140 195)(140 217)(140 210)(140 213)(142 90)(154 113)(216 77)(141 231)(141 143)(141 115)(142 83)(141 185)(141 117)(142 88)(142 91)(141 150)(142 104)(142 71)(142 70)
        (141 123)(142 65)(141 254)(141 152)(142 110)(141 247)(141 136)(142 77)(141 228)(142 86)(141 244)(141 163)(141 226)(188 185)(142 112)(236 150)(142 128)(142 197)(142 155)(142 159)
        (142 174)(142 164)(186 159)(142 195)(142 167)(142 172)(142 205)(142 206)(142 190)(142 189)(131 231)(210 76)(142 214)(129 75)(143 86)(199 102)(145 99)(143 93)(143 84)(142 236)
        (145 170)(143 82)(253 139)(143 85)(143 70)(143 91)(233 95)(174 144)(151 137)(143 136)(143 155)(143 134)(143 157)(143 151)(143 138)(154 119)(174 148)(228 155)(143 167)(143 169)
        (143 216)(143 189)(143 198)(182 82)(145 155)(145 212)(145 110)(144 247)(145 209)(145 66)(145 90)(145 147)(145 89)(144 157)(144 237)(145 122)(191 130)(145 187)(145 171)(145 217)
        (145 169)(144 186)(145 81)(145 195)(144 240)(144 197)(144 192)(144 193)(144 130)(144 226)(145 210)(145 97)(145 145)(243 64)(145 214)(145 75)(145 205)(145 118)(144 220)(145 77)
        (145 132)(145 84)(156 161)(145 67)(145 141)(145 124)(238 138)(145 216)(145 128)(226 240)(145 191)(145 208)(145 172)(145 223)(145 226)(145 242)(145 234)(145 240)(145 236)(145 244)
        (188 153)(147 228)(146 76)(136 204)(148 85)(146 208)(146 223)(147 80)(148 95)(147 225)(146 129)(147 187)(147 184)(146 224)(147 140)(215 111)(136 243)(147 250)(148 77)(148 110)
        (146 254)(147 237)(148 114)(148 81)(147 220)(147 241)(146 236)(147 180)(148 129)(146 233)(147 235)(147 233)(146 182)(147 207)(147 245)(147 215)(146 234)(148 68)(147 93)(147 205)
        (147 198)(147 112)(147 236)(147 81)(147 118)(147 254)(147 211)(147 239)(147 157)(148 83)(147 219)(147 189)(147 165)(147 171)(148 136)(147 229)(148 118)(148 82)(147 167)(148 135)
        (148 121)(148 122)(148 100)(148 91)(147 117)(148 80)(148 130)(148 116)(147 206)(148 102)(148 88)(148 93)(148 120)(148 92)(148 128)(148 179)(148 191)(148 181)(253 83)(148 204)
        (244 89)(148 216)(148 224)(159 111)(197 102)(149 114)(149 231)(149 170)(149 210)(149 131)(149 238)(239 64)(149 120)(149 241)(149 212)(149 207)(149 158)(149 159)(149 186)(149 225)
        (132 158)(208 103)(152 227)(153 67)(154 162)(235 115)(153 224)(151 108)(129 237)(151 238)(152 113)(130 220)(152 79)(152 139)(152 186)(152 208)(151 151)(153 192)(151 103)(151 150)
        (152 140)(151 247)(151 110)(153 153)(153 142)(153 102)(151 100)(150 197)(152 203)(151 163)(153 177)(153 201)(151 157)(153 190)(153 181)(153 218)(152 228)(151 171)(152 211)(153 232)
        (151 168)(151 191)(152 239)(152 69)(153 110)(152 129)(152 242)(152 229)(153 117)(152 170)(152 182)(137 244)(153 132)(151 174)(153 122)(153 244)(152 161)(153 179)(152 160)(153 229)
        (153 69)(152 199)(153 236)(153 194)(153 176)(153 206)(153 120)(153 145)(153 137)(153 189)(153 77)(153 123)(153 209)(153 193)(153 187)(153 169)(153 180)(186 153)(153 95)(154 103)
        (154 101)(154 87)(154 158)(154 123)(154 145)(154 136)(154 140)(154 154)(154 151)(154 155)(154 170)(154 167)(221 158)(174 133)(148 192)(154 214)(154 208)(154 218)(154 226)(154 228)
        (154 229)(154 232)(143 161)(157 104)(155 64)(156 171)(155 176)(223 101)(156 207)(155 93)(158 150)(157 97)(158 114)(156 83)(156 230)(156 116)(156 191)(156 251)(157 240)(157 244)
        (156 73)(157 205)(158 123)(158 111)(158 84)(158 97)(157 138)(157 201)(155 220)(157 141)(158 162)(184 68)(155 209)(156 92)(157 123)(157 178)(156 157)(156 219)(157 225)(156 121)
        (157 210)(157 250)(158 103)(157 73)(156 134)(157 71)(157 226)(157 161)(157 248)(137 84)(156 165)(157 253)(157 179)(156 90)(157 105)(157 172)(156 117)(156 221)(156 111)(156 236)
        (157 153)(157 190)(157 113)(157 173)(157 213)(156 89)(156 79)(157 110)(158 94)(157 117)(157 198)(157 79)(158 99)(157 66)(156 216)(223 91)(158 179)(157 241)(157 162)(158 82)
        (157 115)(157 85)(157 167)(157 76)(156 254)(158 185)(158 151)(157 77)(158 93)(158 86)(158 69)(158 180)(158 73)(158 169)(157 203)(158 69)(158 117)(158 116)(158 135)(158 72)
        (157 147)(158 122)(158 145)(158 124)(158 108)(158 174)(156 231)(159 244)(236 96)(158 196)(160 78)(159 172)(160 116)(159 245)(159 152)(159 205)(252 99)(159 146)(159 235)(160 113)
        (160 128)(159 78)(160 84)(159 159)(159 169)(159 253)(159 238)(160 90)(160 67)(160 97)(159 225)(159 168)(160 70)(160 99)(159 143)(186 253)(193 239)(144 219)(160 148)(160 169)
        (160 211)(160 191)(160 222)(160 217)(143 138)(160 238)(171 69)(170 119)(170 113)(170 78)(251 131)(170 158)(170 159)(170 154)(170 77)(170 123)(170 156)(170 98)(170 122)(170 115)
        (170 157)(171 67)(171 74)(171 77)(216 105)(216 136)(206 111)(171 73)(171 72)(173 94)(173 109)(172 132)(172 148)(172 124)(173 104)(172 70)(172 154)(173 116)(172 122)(171 107)
        (172 109)(173 135)(173 99)(172 113)(173 92)(173 73)(172 141)(173 130)(172 142)(173 97)(173 118)(173 139)(173 145)(174 89)(174 84)(235 138)(174 139)(149 179)(217 220)(174 160)
        (176 88)(175 159)(175 145)(176 79)(175 131)(243 156)(175 143)(175 130)(176 146)(229 237)(176 98)(175 100)(176 87)(175 123)(176 65)(175 136)(176 66)(176 86)(176 68)(175 148)
        (175 142)(175 155)(176 84)(176 99)(176 97)(176 96)(176 93)(176 95)(176 100)(196 159)(176 125)(176 153)(176 151)(177 75)(251 125)(177 79)(201 119)(177 73)(177 80)(178 103)
        (177 123)(178 148)(214 248)(177 160)(178 65)(178 128)(178 109)(178 154)(179 67)(180 137)(181 92)(181 86)(180 88)(180 97)(180 117)(179 140)(179 142)(180 94)(181 90)(181 97)
        (181 91)(181 65)(179 129)(206 249)(180 84)(179 136)(180 147)(180 111)(180 153)(180 95)(251 124)(181 75)(180 131)(180 126)(137 65)(239 224)(157 76)(182 89)(182 66)(182 91)
        (181 157)(182 92)(181 156)(183 65)(181 147)(182 85)(235 120)(182 100)(182 146)(183 78)(183 101)(183 81)(183 120)(183 118)(183 132)(182 144)(183 100)(183 128)(183 119)(184 70)
        (184 96)(184 91)(184 71)(184 90)(184 67)(184 81)(184 93)(184 77)(216 81)(184 130)(186 86)(185 83)(185 80)(185 97)(185 123)(187 92)(187 101)(186 66)(186 96)(186 89)
        (186 154)(185 126)(187 73)(186 158)(186 134)(187 85)(186 106)(186 68)(187 88)(187 106)(186 132)(186 141)(186 136)(186 116)(187 64)(187 104)(187 102)(187 91)(188 101)(238 144)
        (182 105)(188 103)(188 99)(187 155)(188 83)(188 90)(188 82)(240 102)(190 111)(191 123)(244 233)(188 109)(188 117)(188 116)(188 113)(192 119)(188 118)(188 115)(188 137)(188 119)
        (192 107)(188 111)(188 120)(190 149)(188 139)(188 135)(188 131)(188 132)(188 134)(190 86)(188 123)(188 140)(191 118)(190 93)(188 138)(188 136)(188 121)(188 143)(188 159)(188 133)
        (188 126)(188 130)(190 128)(189 67)(189 88)(188 155)(190 154)(189 77)(188 157)(188 154)(191 151)(189 75)(191 85)(189 79)(189 69)(189 73)(189 66)(192 91)(189 155)(189 72)
        (189 137)(189 113)(189 89)(189 102)(192 64)(189 120)(189 87)(192 76)(189 111)(189 107)(189 123)(189 106)(189 94)(189 103)(189 121)(189 142)(189 139)(189 129)(192 67)(189 148)
        (189 151)(189 100)(192 94)(189 144)(191 131)(190 119)(190 99)(190 120)(192 109)(190 95)(190 112)(190 98)(190 121)(190 105)(192 75)(190 83)(190 100)(190 82)(191 135)(190 73)
        (190 84)(190 94)(190 74)(190 67)(190 96)(190 85)(190 71)(190 89)(190 108)(190 126)(190 124)(190 125)(190 146)(192 124)(190 159)(190 152)(190 131)(191 90)(192 68)(190 140)
        (190 69)(190 132)(190 156)(190 128)(190 151)(191 80)(190 143)(190 134)(191 124)(190 142)(190 135)(190 137)(191 78)(191 96)(191 100)(191 98)(191 112)(191 92)(191 99)(192 112)
        (191 114)(191 79)(191 86)(192 95)(191 126)(191 122)(191 119)(192 116)(191 115)(191 138)(191 137)(192 105)(191 157)(191 152)(191 149)(237 92)(192 96)(192 82)(192 81)(192 85)
        (192 121)(192 155)(190 87)(193 95)(193 80)(193 84)(193 96)(193 98)(193 117)(193 119)(194 78)(194 80)(194 69)(194 103)(194 101)(194 150)(144 117)(194 153)(195 64)(194 154)
        (194 156)(194 147)(194 152)(194 148)(195 67)(196 99)(196 119)(196 100)(196 73)(196 91)(195 155)(195 123)(196 145)(132 217)(150 86)(196 76)(197 70)(195 132)(196 122)(195 125)
        (196 146)(243 118)(196 154)(196 88)(196 147)(197 76)(196 95)(195 147)(196 84)(196 152)(197 68)(225 90)(196 115)(253 124)(196 129)(236 116)(196 101)(242 118)(196 156)(197 78)
        (221 155)(197 156)(197 158)(197 147)(198 65)(198 68)(216 87)(198 72)(203 135)(185 157)(193 100)(203 71)(202 143)(204 74)(201 144)(200 148)(203 158)(199 123)(200 79)(201 110)
        (198 114)(204 75)(153 148)(204 79)(199 111)(204 100)(202 92)(137 76)(159 166)(192 79)(199 71)(203 93)(203 82)(199 118)(202 129)(201 156)(202 119)(203 67)(203 106)(202 142)
        (152 115)(200 157)(156 238)(160 206)(159 201)(202 110)(203 124)(201 112)(202 97)(202 123)(200 135)(200 146)(203 142)(201 87)(201 137)(200 82)(201 143)(201 80)(200 110)(203 87)
        (171 64)(202 126)(172 147)(250 76)(201 148)(204 69)(204 125)(206 158)(160 73)(191 77)(202 146)(203 95)(202 91)(202 114)(202 137)(202 89)(202 86)(203 123)(203 69)(204 121)
        (202 154)(230 118)(242 135)(203 78)(204 96)(204 65)(204 64)(204 73)(204 78)(203 146)(233 194)(204 92)(204 148)(145 93)(204 147)(207 120)(205 65)(207 108)(235 109)(206 114)
        (207 138)(206 103)(207 129)(206 155)(208 81)(207 150)(205 152)(208 77)(207 160)(207 124)(208 85)(207 85)(205 144)(207 117)(206 135)(207 147)(205 145)(206 129)(207 158)(207 137)
        (207 88)(207 115)(207 144)(207 78)(207 148)(207 81)(207 92)(208 68)(225 133)(227 149)(209 97)(210 114)(208 150)(210 92)(139 150)(209 139)(210 109)(210 117)(210 85)(209 98)
        (210 100)(209 130)(209 158)(210 99)(209 157)(210 77)(210 64)(210 104)(191 139)(210 119)(210 138)(211 94)(210 141)(210 142)(210 146)(210 149)(210 151)(211 91)(211 88)(211 74)
        (210 160)(211 93)(211 67)(211 68)(211 77)(211 80)(211 85)(211 120)(211 124)(211 122)(215 132)(215 117)(214 96)(211 133)(211 139)(211 134)(211 135)(213 74)(215 73)(211 147)
        (211 143)(211 145)(215 140)(211 152)(211 153)(211 150)(215 104)(211 141)(211 155)(211 149)(214 118)(214 77)(214 142)(212 110)(211 160)(212 71)(212 83)(211 158)(213 147)(212 75)
        (212 65)(214 83)(212 79)(212 76)(212 69)(215 67)(212 98)(212 88)(212 117)(212 123)(215 82)(212 119)(212 112)(212 86)(212 92)(212 103)(214 97)(212 126)(212 120)(212 116)
        (212 118)(215 103)(212 114)(213 69)(213 67)(212 135)(212 159)(212 138)(212 145)(212 156)(213 92)(213 68)(212 150)(212 146)(213 81)(212 141)(212 143)(212 142)(212 131)(212 132)
        (213 138)(212 147)(212 148)(212 140)(213 159)(212 130)(215 112)(213 93)(213 95)(213 90)(213 86)(213 96)(213 97)(213 84)(213 100)(213 78)(213 102)(213 98)(213 79)(213 136)
        (214 84)(213 140)(214 90)(215 120)(213 142)(213 117)(213 110)(213 134)(213 152)(213 108)(213 148)(213 123)(213 126)(213 143)(213 129)(213 114)(213 132)(213 120)(214 92)(214 82)
        (213 153)(214 101)(214 71)(214 67)(214 111)(214 93)(214 94)(214 64)(214 73)(214 88)(215 139)(214 74)(214 79)(214 86)(214 66)(214 105)(213 155)(213 154)(214 131)(215 149)
        (214 113)(214 120)(214 123)(214 114)(213 158)(214 116)(214 107)(214 148)(214 153)(214 134)(215 118)(214 135)(215 84)(215 80)(215 83)(215 142)(215 86)(215 72)(215 151)(215 108)
        (215 100)(215 143)(183 89)(216 114)(216 144)(216 145)(216 147)(216 146)(216 149)(216 148)(216 159)(217 116)(148 161)(217 126)(216 155)(217 124)(216 156)(216 157)(216 154)(217 72)
        (217 143)(217 65)(216 158)(217 69)(217 118)(217 83)(217 66)(217 78)(217 70)(217 76)(217 74)(217 81)(217 77)(217 82)(217 79)(217 92)(217 151)(217 90)(217 86)(217 68)
        (217 85)(217 84)(218 69)(217 89)(217 87)(218 66)(217 103)(217 99)(217 108)(217 100)(217 120)(217 128)(253 86)(218 72)(217 112)(217 110)(218 70)(217 107)(217 115)(217 114)
        (217 121)(217 135)(217 136)(217 152)(217 142)(217 141)(217 144)(217 145)(218 73)(215 147)(217 154)(217 155)(217 160)(218 65)(218 77)(218 88)(218 119)(218 115)(218 133)(218 142)
        (220 79)(220 83)(219 132)(219 149)(220 86)(219 96)(220 74)(220 69)(219 139)(220 93)(220 81)(219 120)(220 80)(219 153)(220 87)(220 85)(220 98)(219 152)(220 88)(220 102)
        (220 107)(220 103)(220 124)(220 135)(220 136)(220 137)(220 142)(220 141)(220 144)(222 68)(220 151)(221 134)(220 155)(222 90)(221 77)(221 86)(222 95)(221 83)(221 84)(221 87)
        (220 160)(221 70)(222 93)(221 85)(221 112)(221 89)(221 100)(221 101)(222 73)(221 99)(221 98)(221 96)(221 94)(221 109)(221 111)(221 118)(221 130)(221 133)(221 120)(221 129)
        (221 121)(221 136)(221 122)(221 119)(221 143)(221 151)(221 139)(221 156)(221 148)(222 92)(222 64)(221 160)(221 154)(222 65)(222 72)(222 79)(222 111)(222 113)(222 112)(223 133)
        (223 124)(223 95)(223 119)(223 94)(223 126)(223 92)(223 128)(223 64)(223 77)(223 104)(223 96)(223 66)(223 116)(223 131)(222 159)(219 69)(223 109)(223 120)(223 100)(223 102)
        (223 138)(223 137)(223 122)(223 98)(224 135)(224 151)(224 119)(224 93)(224 117)(224 146)(224 143)(244 100)(224 83)(224 80)(224 148)(224 141)(224 105)(225 66)(224 121)(224 144)
        (225 106)(225 119)(225 117)(225 137)(225 135)(225 132)(225 140)(209 89)(238 210)(232 98)(232 142)(231 89)(225 143)(225 144)(225 152)(225 148)(225 147)(225 149)(225 145)(226 81)
        (226 84)(226 65)(225 159)(226 108)(226 67)(225 158)(229 123)(226 83)(229 144)(226 79)(226 93)(226 125)(226 98)(226 129)(226 103)(226 110)(230 82)(226 99)(228 94)(228 147)
        (226 107)(226 106)(232 128)(154 74)(226 120)(230 117)(227 94)(226 130)(226 91)(226 128)(226 94)(226 111)(226 90)(226 149)(229 88)(227 96)(227 81)(226 146)(192 143)(226 142)
        (227 79)(226 152)(226 147)(227 88)(232 141)(227 102)(227 103)(226 155)(226 154)(226 153)(232 70)(227 75)(226 143)(232 112)(227 85)(227 84)(226 139)(227 67)(227 66)(227 71)
        (226 148)(232 73)(227 111)(228 68)(227 153)(227 115)(228 66)(228 101)(228 121)(231 116)(227 135)(232 75)(227 126)(228 88)(228 72)(227 159)(230 122)(229 142)(227 143)(227 138)
        (228 98)(228 65)(227 148)(231 102)(227 140)(227 120)(227 147)(227 116)(227 145)(229 80)(228 67)(227 113)(227 158)(231 80)(227 124)(231 124)(228 64)(227 121)(227 156)(232 84)
        (231 132)(228 129)(228 111)(229 110)(228 136)(230 156)(231 72)(228 78)(230 105)(228 135)(228 123)(228 122)(229 129)(228 134)(228 126)(231 110)(228 83)(228 115)(228 104)(228 92)
        (228 141)(231 152)(231 153)(228 74)(228 82)(228 90)(228 117)(228 124)(229 72)(228 157)(230 78)(229 101)(229 94)(229 87)(228 152)(229 75)(229 95)(229 97)(229 100)(232 140)
        (229 78)(229 70)(229 92)(229 118)(228 159)(228 158)(229 85)(229 86)(230 73)(228 143)(229 105)(229 79)(229 155)(229 125)(229 124)(231 73)(230 74)(229 138)(229 154)(230 64)
        (230 82)(229 145)(230 125)(229 150)(230 68)(230 88)(229 131)(230 86)(231 85)(230 116)(230 159)(230 130)(230 110)(230 107)(232 135)(231 157)(230 135)(230 147)(230 121)(230 128)
        (230 94)(230 132)(230 103)(231 83)(231 77)(230 160)(231 97)(231 79)(231 82)(231 67)(230 151)(230 155)(231 66)(231 134)(232 145)(231 130)(231 104)(232 117)(231 133)(232 124)
        (231 146)(232 137)(231 106)(231 139)(232 90)(232 68)(232 71)(232 67)(231 160)(232 79)(232 100)(232 115)(232 110)(232 130)(233 76)(233 84)(233 86)(233 87)(233 90)(233 92)
        (233 93)(134 150)(234 74)(233 99)(233 157)(233 101)(233 98)(233 103)(233 104)(233 96)(144 158)(233 108)(244 91)(233 124)(194 132)(234 89)(233 125)(233 130)(234 71)(233 121)
        (233 119)(233 117)(233 128)(244 98)(233 134)(233 129)(234 65)(233 147)(233 142)(233 139)(244 93)(233 148)(233 146)(233 144)(233 145)(234 85)(234 64)(233 152)(234 84)(233 159)
        (233 160)(234 72)(234 68)(234 70)(234 73)(234 82)(234 88)(234 160)(234 150)(234 142)(234 135)(235 65)(235 72)(234 145)(235 93)(234 144)(234 128)(234 132)(234 159)(235 69)
        (235 85)(235 83)(235 91)(235 96)(235 104)(235 121)(235 114)(215 135)(236 90)(236 70)(236 86)(252 113)(236 92)(236 110)(236 111)(236 118)(237 94)(237 88)(237 100)(237 120)
        (237 102)(237 103)(237 104)(237 110)(237 116)(237 121)(237 119)(237 141)(237 147)(237 148)(237 149)(237 153)(237 151)(237 152)(237 154)(237 156)(238 66)(238 153)(238 68)(237 160)
        (238 67)(237 158)(238 64)(238 65)(239 66)(238 73)(238 72)(238 105)(238 82)(238 97)(238 99)(238 77)(157 125)(159 226)(238 87)(238 85)(238 108)(238 95)(238 106)(238 104)
        (238 101)(183 102)(238 119)(238 125)(238 132)(238 128)(238 133)(238 129)(238 126)(239 68)(238 148)(238 141)(238 139)(238 151)(192 104)(238 157)(238 158)(239 65)(239 69)(239 76)
        (239 94)(239 81)(239 82)(239 83)(239 90)(239 92)(239 96)(239 95)(239 100)(239 104)(239 106)(239 106)(239 119)(240 139)(240 144)(239 125)(240 135)(239 128)(240 104)(239 130)
        (240 113)(239 131)(239 132)(239 134)(239 136)(239 139)(240 84)(239 151)(239 150)(239 149)(239 152)(239 141)(240 68)(240 136)(240 65)(239 157)(240 69)(239 156)(240 70)(239 158)
        (240 71)(240 76)(240 73)(240 78)(240 72)(240 75)(240 82)(240 81)(240 87)(240 94)(240 108)(240 129)(240 107)(240 116)(240 146)(240 118)(240 120)(240 111)(240 115)(240 125)
        (240 126)(240 122)(240 128)(240 130)(240 150)(241 82)(241 83)(241 87)(241 90)(241 89)(242 140)(241 95)(241 103)(243 72)(241 122)(241 130)(241 134)(241 128)(241 120)(242 124)
        (241 118)(241 132)(241 119)(241 123)(243 65)(241 126)(242 148)(193 82)(241 151)(242 156)(242 145)(241 152)(241 148)(241 137)(243 81)(243 80)(242 71)(242 158)(242 72)(241 159)
        (242 69)(242 85)(242 84)(242 83)(242 75)(242 82)(242 147)(242 137)(242 95)(242 115)(242 106)(242 125)(242 92)(242 136)(242 116)(242 113)(242 126)(242 138)(242 133)(242 139)
        (242 150)(243 69)(243 75)(243 76)(243 74)(243 116)(243 121)(243 120)(244 87)(244 124)(244 117)(244 126)(244 128)(244 135)(244 156)(244 141)(244 148)(244 153)(244 159)(245 69)
        (245 71)(246 84)(247 124)(245 79)(245 87)(245 86)(245 78)(245 85)(247 99)(245 81)(245 84)(245 113)(245 94)(245 119)(245 110)(245 98)(245 106)(246 102)(245 96)(247 100)
        (247 113)(245 111)(245 114)(245 126)(245 156)(247 92)(245 134)(247 126)(246 150)(246 158)(245 142)(246 136)(246 156)(245 133)(245 143)(245 140)(245 122)(246 97)(245 151)(245 155)
        (246 78)(245 154)(246 79)(246 69)(246 72)(246 75)(246 65)(246 70)(246 84)(245 160)(246 76)(246 89)(246 88)(245 153)(247 97)(246 108)(246 115)(247 108)(246 91)(246 147)
        (246 103)(246 119)(247 123)(246 113)(246 118)(246 109)(246 101)(247 70)(246 99)(246 133)(252 129)(246 146)(246 141)(246 138)(246 142)(246 132)(246 129)(246 152)(247 66)(247 76)
        (247 77)(246 160)(246 154)(247 73)(247 64)(247 90)(247 88)(247 91)(247 86)(247 115)(247 104)(247 107)(247 103)(248 66)(248 70)(235 117)(248 83)(248 81)(248 79)(250 116)
        (248 102)(250 73)(248 100)(248 99)(248 129)(249 133)(251 82)(248 134)(248 123)(248 132)(248 111)(248 124)(248 122)(248 120)(248 138)(248 114)(250 131)(250 118)(248 141)(248 142)
        (248 160)(248 146)(249 64)(248 157)(251 91)(248 153)(249 77)(249 80)(251 90)(249 78)(249 93)(249 90)(249 79)(250 145)(249 89)(249 94)(249 111)(249 145)(249 103)(250 65)
        (249 108)(249 105)(249 107)(249 135)(249 136)(249 116)(250 137)(249 150)(249 159)(249 152)(250 88)(250 92)(250 66)(250 70)(250 103)(250 95)(250 79)(250 86)(250 87)(250 94)
        (250 89)(250 81)(250 115)(251 87)(250 112)(250 119)(250 141)(250 132)(250 144)(250 150)(250 152)(251 68)(250 151)(251 73)(251 76)(251 88)(251 85)(251 122)(251 156)(251 159)
        (252 83)(252 90)(252 115)(252 116)(252 111)(252 119)(252 120)(252 123)(252 131)(236 138)(253 66)(253 79)(253 82)(253 87)(253 88)(253 90)(253 91)(253 93)(253 101)(253 103)
        (253 95)(253 102)(253 98)(253 108)(253 114)(253 112)(253 120)(253 125)(253 136)(253 143)(253 144)(253 148)(213 73)(209 117)(218 209)(235 98)(209 101)(130 83)(185 160)(243 160)
        (131 211)(135 159)(135 76)(244 92)(252 73)(156 202)(231 138)(143 149)(233 102)(199 172)(131 141)(197 75)(222 213)
    )
  )
)
(cmdfun IsRev)
)
(princ)