let ws=null,heartbeatEr,heartbeatErTime=0,client_id='';
openSocket();
function openSocket() {
	if ("WebSocket" in window)
	{
		if(!_config.message_address)return;
	   	ws = new WebSocket(_config.message_address);
	   	if(vm.userInfo.id){
		   	ws.onopen = function()
		   	{
		      	ws.send(socketMsg('login',{uid:vm.userInfo.id}));
				if (heartbeatEr)
			   		clearInterval(heartbeatEr);
			   	createHeartbeat();
		   	};
		   	ws.onmessage = function (evt)
		   	{
		      var ret = JSON.parse(evt.data);
		      switch(ret.type){
		      	case 'loginSuccess':
		      		client_id=ret.client_id;
		      		vm.sendGet({url:'/joinMessageGroup/'+ret.client_id});
		      		break;
		      	case 'outLogin':
		      		ws.close();
		      		vm.userInfo={id:0,nickname:'',headimg:''};
		      		break;
		      	case 'orderPaySuccess':
		      		if (typeof vm.orderPaySuccess === 'function')
		      			vm.orderPaySuccess(ret.data);
		      		break;
		      	case 'sendSiteMsg':
		      		if (typeof vm.showSiteMsg === 'function')
		      			vm.showSiteMsg(ret.data);
		      		break;
		      	case 'sendClientMsg':
		      		if (typeof vm.showClientMsg === 'function')
		      			vm.showClientMsg(ret.data);
		      		break;
		      	case 'authFail':
			   		clearInterval(heartbeatEr);
		      		break;
		      	default:
		      		// console.log(ret);
		      		break;
		      }
		   	};
		}else{
		   	ws.onopen = function()
		   	{
		      	ws.send(socketQrMsg('qrlogin'));
				if (heartbeatEr)
			   		clearInterval(heartbeatEr);
			   	createHeartbeat();
		   	};
		   	ws.onmessage = function (evt)
		   	{
		      var ret = JSON.parse(evt.data);
		      switch(ret.type){
		      	case 'loginSuccess':
		      		vm.loginTabs.qrlogin=ret.client_id;
		      		vm.qrloginImgUrl='/loginQrcode?scheme='+ret.client_id+'&time='+(new Date()).getTime();
		      		break;
		      	case 'scanQrSuccess':
		      		vm.loginTabs.scanQrSuccess=true;
		      		break;
		      	case 'qrloginSuccess':
		      		vm.sendGet({url:'/qrlogin/'+ret.data.client_id+'/'+ret.client_id},function(ret){
		      			if(ret){
		      				if(ret.code===0){
     							return window.location.reload();
		      				}else{
		      					XYBase.error(ret.msg);
		      				}
		      			}
		      			setTimeout(function(){
     						window.location.reload();
		      			},1500);
		      		});
		      		break;
		      	default:
		      		// console.log(ret);
		      		break;
		      }
		   	};
		}
	   	ws.onclose = function()
	   	{
	   	};
	}
}
function closeSocket() {
	ws.close();
}
function p(obj) {
	heartbeatErTime=0;
	return JSON.stringify(obj);
}
function socketMsg(type,msg) {
	let Data={
		token:vm.userInfo.token,
		type:type,
		msg:msg
	};
	return p(Data);
}
function socketQrMsg(type,msg) {
	let Data={
		type:type,
		msg:msg
	};
	return p(Data);
}
function createHeartbeat(){
	heartbeatEr=setInterval(function(){
		if (heartbeatErTime*1000>=10000){
			heartbeatErTime=0;
			switch(true){
				case ws.readyState == ws.CONNECTING:
				break;
				case ws.readyState == ws.OPEN:
			    	ws.send(p({type:"ping"}));
				break;
				case ws.readyState == ws.CLOSING:
				break;
				case ws.readyState == ws.CLOSED:
		     		openSocket();
				break;
			}
		}else{
			heartbeatErTime++;
		}
	},1000);
}