let IMServer,IMvm;
IMServer={
	ws:null,
	heartbeatEr:null,
	heartbeatErTime:0,
	key:_config.im_key,
	token:_config.im_token,
	openIm() {
		if ("WebSocket" in window && IMvm.userInfo.id
	   		&&IMServer.key 
	   		&&IMServer.token)
		{
		   	IMServer.ws = new WebSocket(_config.im_url);
		   	IMServer.ws.onopen = function()
		   	{
		   		if (!IMServer.key || !IMServer.token)
		   			return IMServer.ws.close();
		      	IMServer.ws.send(IMServer.socketMsg('login'));
			   	IMServer.createHeartbeat();
		   	};
		   	IMServer.ws.onmessage = function (evt)
		   	{
		      var ret = JSON.parse(evt.data);
		      switch(ret.type){
		      	case 'loginSuccess':
		      		IMvm.is_online=true;
		      		IMvm.getContactsList();
		      		break;
		      	case 'outLogin':
		      		IMServer.ws.close();
		      		IMvm.userInfo={id:0,nickname:'',headimg:''};
		      		break;
		      	case 'authFail':
					if (IMServer.heartbeatEr)
				   		clearInterval(IMServer.heartbeatEr);
		      		break;
		      	case 'ping':
		      		IMvm.is_online=true;
		      		break;
		      	case 'getContactsList':
		      		IMvm.contacts=ret.data;
					IMServer.sendImMessage('getUnreadMsg',{messageid:0});
		      		break;
		      	case 'receiveIMM':
		      		if (!IMvm.win)
		      			IMvm.showImNotifyMsg(ret.data);
					IMServer.sendImMessage('getUnreadMsg',{messageid:ret.data.messageid});
					IMServer.sendImMessage('getUnreadMsg',{messageid:0});
		      		IMvm.sendImMessageSuccess(ret.data);
		      		break;
		      	case 'sendIMM':
					IMServer.sendImMessage('getUnreadMsg',{messageid:ret.data.messageid});
					IMServer.sendImMessage('getUnreadMsg',{messageid:0});
		      		IMvm.sendImMessageSuccess(ret.data);
		      		break;
		      	case 'getHistoryMsg':
		      		IMvm.setHistoryMsg(ret.data);
		      		break;
		      	case 'UnreadCount':
		      		IMvm.setUnreadCount(ret.data);
		      		break;
		      	case 'UserOnline':
		      		IMvm.setUserOnline(ret.data,1);
		      		break;
		      	case 'UserOffline':
		      		IMvm.setUserOnline(ret.data,0);
		      		break;
		      	case 'setWithdrawMsg':
		      		IMvm.setMessageWithdraw(ret.data);
		      		break;
		      	case 'exchangeError':
		      		IMvm.msg(ret.data.err);
		      		break;
		      	case 'acceptExchangeDataSuccess':
		      		IMvm.acceptExchangeDataSuccess(ret.data);
		      		break;
		      	case 'refuseExchangeDataSuccess':
		      		IMvm.refuseExchangeDataSuccess(ret.data);
		      		break;
		      	default:
		      		// console.log(ret);
		      		break;
		      }
		   	};
		   	IMServer.ws.onclose = function(){
	      		IMvm.is_online=false;
		   	};
		   	IMServer.ws.onerror = function(){
	      		IMvm.is_online=false;
			   	IMServer.createHeartbeat();
		   	};
		}
	},
	closeIm() {
		IMServer.ws.close();
	},
	p(obj) {
		heartbeatErTime=0;
		return JSON.stringify(obj);
	},
	socketMsg(type,msg) {
		let Data={
			key:IMServer.key,
			type:type,
			token:IMServer.token,
			data:msg
		};
		return IMServer.p(Data);
	},
	sendImMessage(type,data){
		if (IMServer.ws.readyState == IMServer.ws.OPEN){
	     	IMServer.ws.send(IMServer.socketMsg(type,data));
		}else{
			IMvm.showNowImStatusMsg();
		}
	},
	createHeartbeat(){
		if (IMServer.heartbeatEr)
	   		clearInterval(IMServer.heartbeatEr);
		IMServer.heartbeatEr=setInterval(function(){
			if (IMServer.heartbeatErTime*1000>=10000){
				IMServer.heartbeatErTime=0;
				switch(true){
					case IMServer.ws.readyState == IMServer.ws.CONNECTING:
					break;
					case IMServer.ws.readyState == IMServer.ws.OPEN:
				    	IMServer.ws.send(IMServer.p({type:"ping"}));
					break;
					case IMServer.ws.readyState == IMServer.ws.CLOSING:
					break;
					case IMServer.ws.readyState == IMServer.ws.CLOSED:
			     		IMServer.openIm();
					break;
				}
			}else{
				IMServer.heartbeatErTime++;
			}
		},1000);
	}
};
IMvm=new Vue({
	el:'#IM',
	data:{
		win:false,
		userInfo:UserInfo,
		is_online:false,
		is_full_screen:false,
		UploadImImg:false,
		UploadImImgProgress:0,
		loadingLayer:null,
		setting:{
			show:false,
			is_enter_send:1,
		},
		form:{
			msg:''
		},
		unread_count:0,
		toUser:{
			contacts_index:null,
			id:null,
			uid:null,
			touid:null,
			jobs_id:null,
			nickname:'',
			headimg:'',
			last_msg:{},
			is_online:0,
			unread_count:0
		},
		contacts:[],
		historyMsgPage:{
			status:0,
			per_page:1,
			total:0,
			page:1
		},
		historyMsg:[],
		viewer:{
			index:null,
			scale:1,
			rotate:0,
			isDown:false,
			is_screen:true
		},
		tools:{
			mobile:{
				show:false,
				status:0,
				err:'',
				exchange_id:0,
				data:{
					name:'',
					mobile:''
				},
			},
			wechat:{
				show:false,
				status:0,
				err:'',
				exchange_id:0,
				data:{
					name:'',
					wechat:''
				},
			},
			resume:{
				show:false,
				status:0,
				err:'',
				exchange_id:0,
				data:{
					name:'',
					resume:''
				},
			},
			uninterested:{
				show:false
			}
		},
		showEmotion:false,
		emotion:[
		    {name: "Expression_1",text: "[微笑]"},
		    {name: "Expression_2",text: "[撇嘴]"},
		    {name: "Expression_3",text: "[色]"},
		    {name: "Expression_4",text: "[发呆]"},
		    {name: "Expression_5",text: "[得意]"},
		    {name: "Expression_6",text: "[流泪]"},
		    {name: "Expression_7",text: "[害羞]"},
		    {name: "Expression_8",text: "[闭嘴]"},
		    {name: "Expression_9",text: "[睡]"},
		    {name: "Expression_10",text: "[大哭]"},
		    {name: "Expression_11",text: "[尴尬]"},
		    {name: "Expression_12",text: "[发怒]"},
		    {name: "Expression_13",text: "[调皮]"},
		    {name: "Expression_14",text: "[呲牙]"},
		    {name: "Expression_15",text: "[惊讶]"},
		    {name: "Expression_16",text: "[难过]"},
		    {name: "Expression_17",text: "[酷]"},
		    {name: "Expression_18",text: "[冷汗]"},
		    {name: "Expression_19",text: "[抓狂]"},
		    {name: "Expression_20",text: "[吐]"},
		    {name: "Expression_21",text: "[偷笑]"},
		    {name: "Expression_22",text: "[愉快]"},
		    {name: "Expression_23",text: "[白眼]"},
		    {name: "Expression_24",text: "[傲慢]"},
		    {name: "Expression_25",text: "[饥饿]"},
		    {name: "Expression_26",text: "[困]"},
		    {name: "Expression_27",text: "[恐惧]"},
		    {name: "Expression_28",text: "[流汗]"},
		    {name: "Expression_29",text: "[憨笑]"},
		    {name: "Expression_30",text: "[悠闲]"},
		    {name: "Expression_31",text: "[奋斗]"},
		    {name: "Expression_32",text: "[咒骂]"},
		    {name: "Expression_33",text: "[疑问]"},
		    {name: "Expression_34",text: "[嘘]"},
		    {name: "Expression_35",text: "[晕]"},
		    {name: "Expression_36",text: "[疯了]"},
		    {name: "Expression_37",text: "[衰]"},
		    {name: "Expression_38",text: "[骷髅]"},
		    {name: "Expression_39",text: "[敲打]"},
		    {name: "Expression_40",text: "[再见]"},
		    {name: "Expression_41",text: "[擦汗]"},
		    {name: "Expression_42",text: "[抠鼻]"},
		    {name: "Expression_43",text: "[鼓掌]"},
		    {name: "Expression_44",text: "[糗大了]"},
		    {name: "Expression_45",text: "[坏笑]"},
		    {name: "Expression_46",text: "[左哼哼]"},
		    {name: "Expression_47",text: "[右哼哼]"},
		    {name: "Expression_48",text: "[哈欠]"},
		    {name: "Expression_49",text: "[鄙视]"},
		    {name: "Expression_50",text: "[委屈]"},
		    {name: "Expression_51",text: "[快哭了]"},
		    {name: "Expression_52",text: "[阴险]"},
		    {name: "Expression_53",text: "[亲亲]"},
		    {name: "Expression_54",text: "[吓]"},
		    {name: "Expression_55",text: "[可怜]"},
		    {name: "Expression_56",text: "[菜刀]"},
		    {name: "Expression_57",text: "[西瓜]"},
		    {name: "Expression_58",text: "[啤酒]"},
		    {name: "Expression_59",text: "[篮球]"},
		    {name: "Expression_60",text: "[乒乓]"},
		    {name: "Expression_61",text: "[咖啡]"},
		    {name: "Expression_62",text: "[饭]"},
		    {name: "Expression_63",text: "[猪头]"},
		    {name: "Expression_64",text: "[玫瑰]"},
		    {name: "Expression_65",text: "[凋谢]"},
		    {name: "Expression_66",text: "[嘴唇]"},
		    {name: "Expression_67",text: "[爱心]"},
		    {name: "Expression_68",text: "[心碎]"},
		    {name: "Expression_69",text: "[蛋糕]"},
		    {name: "Expression_70",text: "[闪电]"},
		    {name: "Expression_71",text: "[炸弹]"},
		    {name: "Expression_72",text: "[刀]"},
		    {name: "Expression_73",text: "[足球]"},
		    {name: "Expression_74",text: "[瓢虫]"},
		    {name: "Expression_75",text: "[便便]"},
		    {name: "Expression_76",text: "[月亮]"},
		    {name: "Expression_77",text: "[太阳]"},
		    {name: "Expression_78",text: "[礼物]"},
		    {name: "Expression_79",text: "[拥抱]"},
		    {name: "Expression_80",text: "[强]"},
		    {name: "Expression_81",text: "[弱]"},
		    {name: "Expression_82",text: "[握手]"},
		    {name: "Expression_83",text: "[胜利]"},
		    {name: "Expression_84",text: "[抱拳]"},
		    {name: "Expression_85",text: "[勾引]"},
		    {name: "Expression_86",text: "[拳头]"},
		    {name: "Expression_87",text: "[差劲]"},
		    {name: "Expression_88",text: "[爱你]"},
		    {name: "Expression_89",text: "[NO]"},
		    {name: "Expression_90",text: "[OK]"},
		    {name: "Expression_91",text: "[爱情]"},
		    {name: "Expression_92",text: "[飞吻]"},
		    {name: "Expression_93",text: "[跳跳]"},
		    {name: "Expression_94",text: "[发抖]"},
		    {name: "Expression_95",text: "[怄火]"},
		    {name: "Expression_96",text: "[转圈]"},
		    {name: "Expression_97",text: "[磕头]"},
		    {name: "Expression_98",text: "[回头]"},
		    {name: "Expression_99",text: "[跳绳]"},
		    {name: "Expression_100",text: "[投降]"},
		    {name: "Expression_101",text: "[激动]"},
		    {name: "Expression_102",text: "[街舞]"},
		    {name: "Expression_103",text: "[献吻]"},
		    {name: "Expression_104",text: "[左太极]"},
		    {name: "Expression_105",text: "[右太极]"}
		]
	},
	watch:{
	},
	created(){
		for (var i = 0; i <= this.emotion.length; i++) {
			if (this.emotion[i]) {
				this.emotion[i].url='//'+window.location.host+'/static/plugin/XYCms/emotion/'+this.emotion[i].name+'.png';
				this.emotion[i].regexps=new RegExp('\\'+this.emotion[i].text,"g");
			}
		}
	},
	methods:{
    	getViewerStyle(){
    		var style={
    			transform:'scale('+this.viewer.scale+') rotate('+this.viewer.rotate+'deg)'
    		};
    		if (this.viewer.is_screen) {
    			style.maxHeight='100%';
    			style.maxWidth='100%';
    		}
    		return style;
    	},
    	closeImageViewer(){
    		document.body.style='';
    		this.viewer.index=null;
    	},
    	openImageViewer(index){
    		document.body.style="overflow: hidden;";
    		this.viewer.index=index;
    		this.viewer.scale=1;
    		this.viewer.rotate=0;
    		this.viewer.is_screen=true;
    	},
    	viewerMousewheel(event){
    		if (event.deltaY>0) {
    			if (this.viewer.scale<=0.2)return;
    			this.viewer.scale=this.viewer.scale-0.02;
    		}else{
    			this.viewer.scale=this.viewer.scale+0.02;
    		}
    	},
    	viewerZoomOut(){
    		if (this.viewer.scale<=0.3)return;
   			this.viewer.scale=this.viewer.scale-0.2;
    	},
		viewerZoomIn(){
   			this.viewer.scale=this.viewer.scale+0.2;
		},
    	viewerIsScreen(index){
    		this.viewer.scale=1;
    		this.viewer.rotate=0;
    		this.viewer.is_screen= !this.viewer.is_screen;
    	},
    	viewerRotateLeft(){
    		this.viewer.rotate=this.viewer.rotate-90;
    	},
		viewerRotateRight(){
    		this.viewer.rotate=this.viewer.rotate+90;
		},
		viewerNext(){
			var index=this.viewer.index+1;
			while(this.historyMsg[index]&&this.historyMsg[index].content.msg_type!=='img'){
				index=index+1;
			}
			if (this.historyMsg[index])
				this.viewer.index=index;
		},
		viewerPrev(){
			var index=this.viewer.index-1;
			while(this.historyMsg[index]&&this.historyMsg[index].content.msg_type!=='img'){
				index=index-1;
			}
			if (this.historyMsg[index])
				this.viewer.index=index;
		},
		insertEmotion(val){
			this.showEmotion=false;
			this.form.msg=this.form.msg+val;
			if (this.$refs.ImMessageFormMsg)
				this.$refs.ImMessageFormMsg.focus();
		},
	    encodeHtml:function(str){
		    if (str) {
		    	str = str.replace(/&/g,"&amp;");
	 			str = str.replace(/</g,"&lt;");
	 			str = str.replace(/>/g,"&gt;");
	 			str = str.replace(/ /g,"&nbsp;");
				str = str.replace(/\'/g,"&#39;");
				str = str.replace(/\"/g,"&quot;");
		    	str = str.replace(/\n/g, '<br/>');
				let _this=this;
				for (var i = 0; i < _this.emotion.length; i++){
					str = str.replace(_this.emotion[i].regexps,'<img src="'+_this.emotion[i].url+'" class="face-icon" alt=""/>');
				}
		        return str;
		    }else{
		        return '';
		    }
	    },
		settingItem(set,val){
			this.setting.show=false;
			this.setting[set]=val;
		},
		openImWin(){
			if (!IMServer.ws)return;
			this.win=true;
			this.showEmotion=false;
			let _this=this;
			setTimeout(function() {
				if (_this.$refs.ImMessageFormMsg)
					_this.$refs.ImMessageFormMsg.focus();
			},300);
			this.showNowImStatusMsg();
		},
		showNowImStatusMsg(){
			switch(true){
				case IMServer.ws.readyState == IMServer.ws.CONNECTING:
				this.msg('正在连接服务器...');
				break;
				case IMServer.ws.readyState == IMServer.ws.OPEN:
				break;
				case IMServer.ws.readyState == IMServer.ws.CLOSING:
				this.msg('您已离线');
				break;
				case IMServer.ws.readyState == IMServer.ws.CLOSED:
				this.msg('您已离线，等待重连或刷新页面');
				break;
			}
		},
		showImNotifyMsg(message){
			let contacts=null,contactsIndex=null,_this=this;
			for (var i = 0; i < this.contacts.length; i++) {
				if (this.contacts[i].id===message.messageid) {
					contacts=this.contacts[i];
					contactsIndex=i;
					break;
				}
			}
			if (contacts) {
				let messageText='';
				switch(message.content.msg_type){
		            case 'exchange_mobile':
		            	messageText='[互换电话]';
		                break;
		            case 'exchange_wechat':
		            	messageText='[互换微信]';
		                break;
		            case 'resume':
		            	messageText='[在线简历]';
		                break;
		            case 'img':
		            	messageText='[图片]';
		                break;
					default:
						messageText=message.content.msg;
						break;
				}		        
				this.$notify({
		          title: contacts.to_nickname,
		          message: messageText,
		          position: 'bottom-right',
		          iconClass:'el-icon-chat-dot-round',
		          onClick:function(){
		          	_this.win=true;
		          	_this.setGetHistoryMsg(contacts,contactsIndex);
		          }
		        });
			}
		},
		/*消息提示*/
		msg(msg) {
			this.$message({type: 'info', duration:2000, message: msg });
		},
		success(msg) {
			this.$message({type: 'success', duration:2000, message: msg });
		},
		warning(msg) {
			this.$message({type: 'warning', duration:2000, message: msg });
		},
		error(msg) {
			this.$message({type: 'error', duration:2000, message: msg });
		},
		setFullScreen(){
			this.is_full_screen= !this.is_full_screen;
		},
		setGetHistoryMsg(val,index){
			IMServer.sendImMessage('clearUnreadMsg',{messageid:val.id});
			IMServer.sendImMessage('getUnreadMsg',{messageid:0});
			if (this.toUser.id===val.id)return;
			this.toUser=val;
			this.toUser.contacts_index=index;
			this.historyMsg=[];
			let _this=this;
			setTimeout(function() {
				if (_this.$refs.ImMessageFormMsg)
					_this.$refs.ImMessageFormMsg.focus();
			},300);
			this.historyMsgPage.page=1;
			this.historyMsgPage.status=1;
			IMServer.sendImMessage('getHistoryMsg',{messageid:val.id,page:this.historyMsgPage.page});
		},
		ImMessageFormMsgEnter(event){
			if (this.setting.is_enter_send) {
				if (!event.shiftKey){
					if (event.preventDefault) event.preventDefault();
        			else window.event.returnValue = false;
					if (!this.form.msg.replace(/\s+/g, "")) {
						this.form.msg='';
					}else{
						this.form.msg=this.form.msg.replace(/^\n+|\n+$/g,"");
						this.sendMessage();
					}
				}
			}else if (event.ctrlKey)
				this.sendMessage();
		},
		sendMessage(){
			let _ = this.form.msg;
			this.form.msg='';
			let msgData= {
				messageid:this.toUser.id,
				touid:this.toUser.touid,
				senduid:this.userInfo.id,
				content:{
					msg_type:'text',
					msg:_
				}
			}
			IMServer.sendImMessage('clearUnreadMsg',{messageid:this.toUser.id});
			IMServer.sendImMessage('sendIMM',msgData);
		},
		getUploadImImgData(){
			let obj={
				key:IMServer.key,
				uid:IMServer.token.uid,
				time:IMServer.token.time,
				token:IMServer.token.token
			}
			return obj;
		},
		handleUploadImImgSuccess(res, file) {
			let _this=this;
			if(res){
				if(res.code === 0){
					_this.sendImgMessage(res.data.path);
				}else this.UploadImImg='图片发送失败：'+res.msg;
			}else this.UploadImImg='图片发送失败：网络错误！';
			setTimeout(function(){
				_this.UploadImImg=false;
			},1000);
		},
		sendImgMessage(img){
			let msgData= {
				messageid:this.toUser.id,
				touid:this.toUser.touid,
				senduid:this.userInfo.id,
				content:{
					msg_type:'img',
					msg:img
				}
			}
			if (this.toUser.touid===this.userInfo.id) {
				msgData.touid=this.toUser.uid;
				msgData.senduid=this.userInfo.id;
			}
			IMServer.sendImMessage('sendIMM',msgData);
		},
		handleUploadImImgError(res, file) {
			this.UploadImImg='图片发送失败：网络错误！';
			let _this=this;
			setTimeout(function(){
				_this.UploadImImg=false;
			},1000);
		},
		handleUploadImImgProgress(event, file, fileList) {
			this.UploadImImgProgress=event.percent;
		},
		handleUploadImImgBefore(file) {
			this.UploadImImg=true;
		},
		handleUploadImImgDragover (e) {
          e.preventDefault()
        },
        handleUploadImImgDrop (e) {
          e.preventDefault()
          const file = e.dataTransfer.files[0];
          if (!file) return;
          this.handleUploadImImgAjax(file);
        },
        handleUploadImImgPaste(event){
	      const items = (event.clipboardData || window.clipboardData).items;
	      let file = null;
	      for (let i = 0; i < items.length; i++) {
	        if (items[i].type.indexOf("image") !== -1) {
	          file = items[i].getAsFile();
	          break;
	        }
	      }
	      if (!file)return;
          this.handleUploadImImgAjax(file);
        },
        handleUploadImImgAjax(file){
          let _this=this;
          let data = new FormData()
          data.append('file',file);
          let D=_this.getUploadImImgData();
          for (x in D) {
	          data.append(x,D[x]);
          }
          $.ajax({
          	url:_config.im_upload_file_url+'uploadFiles',
          	type:'POST',
          	data:data,
          	dataType:'json',
	        processData:false,
	        contentType:false,
          	error:function(err) {
          		_this.handleUploadImImgError(err,file);
          	},
          	success:function(ret) {
          		_this.handleUploadImImgSuccess(ret,file);
          	}
          });
        },
		sendImMessageSuccess(val){
			if (!val.id)return;
			if (val.messageid===this.toUser.id){
				this.historyMsgPage.total++;
				this.historyMsg.push(val);
				this.contacts[this.toUser.contacts_index].last_msg=val;
				let _this=this;
				setTimeout(function() {
					_this.$refs.ImMessageList.scrollTo(0,_this.$refs.ImMessageList.scrollHeight);
				},300);
			}else{
				for (var i = 0; i < this.contacts.length; i++) {
					if (this.contacts[i].id===val.messageid) {
						this.contacts[i].last_msg=val;
						break;
					}
				}
			}
		},
		applyToUserContacts(Contacts){
			Contacts.send={
				nickname:this.userInfo.nickname,
				headimg:this.userInfo.headimg
			};
			if (this.loadingLayer)return;
			this.loadingLayer=this.$loading({
	          lock: true,
	          text: 'Loading...',
	          spinner: 'el-icon-loading',
	          customClass:'xy-el-loading',
	          background: 'rgba(255,255,255,0.8)'
	        });
	        var _this=this;
	        vm.sendPost({
	        	url:'/im/createContacts',
	        	data:Contacts
	        },function(ret){
      			_this.loadingLayer.close();
      			_this.loadingLayer=null;
        		if(ret){
        			if(ret.code===0){
		      			_this.openImWin();
			      		if (!ret.data.id)
			      			return _this.msg('创建联系人失败，请重试');
			      		if(!_this.userInfo.id){
			      			window.location.reload();
			      		}
			      		let add=true;
			      		for (var i = 0; i < _this.contacts.length; i++) {
			      			if(_this.contacts[i].id===ret.data.id){
				      			add=false;
				      			break;
			      			}
			      		}
			      		if (add)
			      			_this.contacts.unshift(ret.data);
		      			if (_this.toUser.id!==ret.data.id)
		      				_this.setGetHistoryMsg(ret.data,0);
        			}else{
	        			_this.msg(ret.msg);
	        		}
        		}
	        })
		},
		getContactsList(){
			IMServer.sendImMessage('getContactsList');
		},
		setHistoryMsg(rows) {
			this.historyMsgPage.status=0;
			for (var i = 0; i < rows.pageData.length; i++) {
				if(rows.messageid===this.toUser.id)
		      		this.historyMsg.unshift(rows.pageData[i]);
			}
			if (this.historyMsgPage.page===1) {
				this.historyMsgPage.total=rows.total;
				this.historyMsgPage.per_page=rows.per_page;
				let _this=this;
				setTimeout(function() {
					_this.$refs.ImMessageList.scrollTo(0,_this.$refs.ImMessageList.scrollHeight);
				},300);
			}
		},
		getHistoryMsg() {
			if (this.historyMsgPage.page>this.historyMsgPage.per_page)return;
			this.historyMsgPage.page++;
			this.historyMsgPage.status=1;
			IMServer.sendImMessage('getHistoryMsg',{messageid:this.toUser.id,page:this.historyMsgPage.page});
		},
		setUnreadCount(val){
			if (val.messageid) {
				for (var i = 0; i < this.contacts.length; i++) {
					if (this.contacts[i].id===val.messageid) {
						this.contacts[i].unread_count=val.unread_count;
						break;
					}
				}
			}else{
				this.unread_count=val.unread_count;
			}
		},
		setUserOnline(val,is_online){
			for (var i = 0; i < this.contacts.length; i++) {
				if (this.contacts[i].touid===val.uid) {
					this.contacts[i].is_online=is_online;
					break;
				}
			}
		},
		sendMessageWithdraw(val){
			IMServer.sendImMessage('setWithdrawMsg',val);
		},
		setMessageWithdraw(val){
			if (val.messageid===this.toUser.id) {
				for (var i = 0; i < this.historyMsg.length; i++) {
					if (this.historyMsg[i].id===val.id) {
						this.historyMsg[i].withdraw=1;
						if (this.contacts[this.toUser.contacts_index].last_msg 
							&& this.contacts[this.toUser.contacts_index].last_msg.id===val.id)
							this.contacts[this.toUser.contacts_index].last_msg.withdraw=1;
						break;
					}
				}
			}else{
				for (var i = 0; i < this.contacts.length; i++) {
					if (this.contacts[i].id===val.messageid) {
						if (this.contacts[index].last_msg 
							&& this.contacts[index].last_msg.id===val.id)
							this.contacts[index].last_msg.withdraw=1;
						break;
					}
				}
			}
		},
		toolsMobileShow(exchange_id){
			if (this.tools.mobile.data.mobile) {
				this.tools.mobile.show=true;
			}else{
				if (this.tools.mobile.status===2)return;
				this.tools.mobile.status=2;
				this.tools.mobile.err='';
				if (exchange_id)
					this.tools.mobile.exchange_id=exchange_id;
				else
					this.tools.mobile.exchange_id=0;
				let _this=this;
				vm.sendGet({
					url:'/im/getIMDataInfo',
					data:{
						type:'mobile'
					}
				},function(ret){
					_this.tools.mobile.status=0;
					_this.tools.mobile.show=true;
					if (ret) {
						if (ret.code === 0) {
							_this.tools.mobile.status=1;
							_this.tools.mobile.data.name=ret.data.name;
							_this.tools.mobile.data.mobile=ret.data.mobile;
						}else{
							_this.tools.mobile.err=ret.msg;
						}
					}
				});
			}
		},
		toolsWechatShow(exchange_id){
			if (this.tools.wechat.data.wechat) {
				this.tools.wechat.show=true;
			}else{
				if (this.tools.wechat.status===2)return;
				this.tools.wechat.status=2;
				this.tools.wechat.err='';
				if (exchange_id)
					this.tools.wechat.exchange_id=exchange_id;
				else
					this.tools.wechat.exchange_id=0;
				let _this=this;
				vm.sendGet({
					url:'/im/getIMDataInfo',
					data:{
						type:'wechat'
					}
				},function(ret){
					_this.tools.wechat.status=0;
					_this.tools.wechat.show=true;
					if (ret) {
						if (ret.code === 0) {
							_this.tools.wechat.status=1;
							_this.tools.wechat.data.name=ret.data.name;
							_this.tools.wechat.data.wechat=ret.data.wechat;
						}else{
							_this.tools.wechat.err=ret.msg;
						}
					}
				});
			}
		},
		toolsResumeShow(exchange_id){
			if (this.tools.resume.data.id) {
				this.tools.resume.show=true;
			}else{
				if (this.tools.resume.status===2)return;
				this.tools.resume.status=2;
				this.tools.resume.err='';
				if (exchange_id)
					this.tools.resume.exchange_id=exchange_id;
				else
					this.tools.resume.exchange_id=0;
				let _this=this;
				vm.sendGet({
					url:'/im/getIMDataInfo',
					data:{
						type:'resume'
					}
				},function(ret){
					_this.tools.resume.status=0;
					_this.tools.resume.show=true;
					if (ret) {
						if (ret.code === 0) {
							_this.tools.resume.status=1;
							_this.tools.resume.data=ret.data;
						}else{
							_this.tools.resume.err=ret.msg;
						}
					}
				});
			}
		},
		toolsMobileExchange() {
			this.tools.mobile.show=false;
			let msgData= {
				messageid:this.toUser.id,
				touid:this.toUser.touid,
				senduid:this.userInfo.id,
				content:{
					msg_type:'exchange_mobile',
					exchange_id:this.tools.mobile.exchange_id,
					data:this.tools.mobile.data
				}
			}
			this.tools.mobile.exchange_id=0;
			IMServer.sendImMessage('clearUnreadMsg',{messageid:this.toUser.id});
			if (msgData.content.exchange_id) {
				IMServer.sendImMessage('acceptExchangeMobile',msgData);
			}else{
				IMServer.sendImMessage('sendIMM',msgData);
			}
		},
		acceptExchangeDataSuccess(val){
			if (val.messageid===this.toUser.id) {
				for (var i = 0; i < this.historyMsg.length; i++) {
					if (parseInt(this.historyMsg[i].id)===val.exchange_id) {
						this.historyMsg[i].content.msg=val.content;
						break;
					}
				}
			}
		},
		toolsWechatExchange() {
			this.tools.wechat.show=false;
			let msgData= {
				messageid:this.toUser.id,
				touid:this.toUser.touid,
				senduid:this.userInfo.id,
				content:{
					msg_type:'exchange_wechat',
					exchange_id:this.tools.wechat.exchange_id,
					data:this.tools.wechat.data
				}
			}
			this.tools.wechat.exchange_id=0;
			IMServer.sendImMessage('clearUnreadMsg',{messageid:this.toUser.id});
			if (msgData.content.exchange_id) {
				IMServer.sendImMessage('acceptExchangeWechat',msgData);
			}else{
				IMServer.sendImMessage('sendIMM',msgData);
			}
		},
		toolsResumeExchange() {
			this.tools.resume.show=false;
			let resume={
				id:this.tools.resume.data.id,
				name:this.tools.resume.data.name,
				sex:this.tools.resume.data.sex,
				age:this.tools.resume.data.age,
				educational_background:this.tools.resume.data.educational_background,
				work_experience_time:this.tools.resume.data.work_experience_time
			};
			let msgData= {
				messageid:this.toUser.id,
				touid:this.toUser.touid,
				senduid:this.userInfo.id,
				content:{
					msg_type:'resume',
					data:resume
				}
			}
			this.tools.resume.exchange_id=0;
			IMServer.sendImMessage('clearUnreadMsg',{messageid:this.toUser.id});
			IMServer.sendImMessage('sendIMM',msgData);
		},
		refuseMobileExchange(exchange_id) {
			let msgData= {
				messageid:this.toUser.id,
				touid:this.toUser.touid,
				senduid:this.userInfo.id,
				content:{
					exchange_id:exchange_id,
				}
			}
			this.tools.mobile.exchange_id=0;
			IMServer.sendImMessage('clearUnreadMsg',{messageid:this.toUser.id});
			IMServer.sendImMessage('refuseExchangeMobile',msgData);
		},
		refuseWechatExchange(exchange_id) {
			let msgData= {
				messageid:this.toUser.id,
				touid:this.toUser.touid,
				senduid:this.userInfo.id,
				content:{
					exchange_id:exchange_id,
				}
			}
			this.tools.wechat.exchange_id=0;
			IMServer.sendImMessage('clearUnreadMsg',{messageid:this.toUser.id});
			IMServer.sendImMessage('refuseExchangeWechat',msgData);
		},
		refuseExchangeDataSuccess(val){
			if (val.messageid===this.toUser.id) {
				for (var i = 0; i < this.historyMsg.length; i++) {
					if (parseInt(this.historyMsg[i].id)===val.exchange_id) {
						this.historyMsg[i].content.msg=val.content;
						break;
					}
				}
			}
		},
		deliveryResume(){
			let _this=this;
			vm.sendGet({
				url:'/im/getIMDataInfo',
				data:{
					type:'deliveryResume',
					id:_this.toUser.jobs_id,
					uid:_this.toUser.touid
				}
			},function(ret){
				if (ret) {
					if (ret.code === 0) {
						_this.success(ret.msg);
					}else{
						_this.msg(ret.msg);
					}
				}
			});
		},
		addBodyStyle(fla){
			if (document.body.scrollHeight<document.documentElement.clientHeight)return;
			if (fla) {
	    		// document.body.style="overflow: hidden;padding-right:17px;";
	    		// this.$refs.IMWIN.style="right:17px;";
			}else{
	    		// document.body.style="";
	    		if (!this.win) {
		    		this.$refs.IMWIN.style="display:none;";
	    		}else{
		    		this.$refs.IMWIN.style="";
	    		}
			}
		}
	}
});
IMServer.openIm();
