/*
*	Unknown
*	v1.0
*/
'use strict';
const XYBase={
	config:{
	  VueEl:'#app',
	  system_network_error:'服务器繁忙，请稍后再试',
	  weekText:['星期日','星期一','星期二','星期三','星期四','星期五','星期六'],
	  imageMime:['image/png','image/jpg','image/jpeg','image/gif'],
	},
	pattern:{
	  mobile : /^1[3456789]\d{9}$/,
	  email : /^([a-zA-Z]|[0-9])(\w|\-)+@[a-zA-Z0-9]+\.([a-zA-Z]{2,4})$/,
	},
	/*Cookie操作*/
	getCookie(name){
		if(!window.localStorage) return null;
		var value=window.localStorage.getItem(name);
		if(value){
		  return value;
		}else{
		  return null;
		}
	},
	setCookie(name,value){
		if(!window.localStorage) return false;
		window.localStorage.setItem(name,value);
	    return this.getCookie(name)!=null;
	},
	delCookie(name){
		if(!window.localStorage) return false;
		window.localStorage.removeItem(name);
		return this.getCookie(name)==null;
	},
	/*Cookie操作*/
    conGetHtml:function(str){
      if (str) {
        return str.replace(/\n/g, '<br/>');
      }else{
        return '';
      }
    },

	/*消息提示*/
	msg(msg) {
		vm.$message({type: 'info', duration:2000, message: msg });
	},
	success(msg) {
		vm.$message({type: 'success', duration:2000, message: msg });
	},
	warning(msg) {
		vm.$message({type: 'warning', duration:2000, message: msg });
	},
	error(msg) {
		vm.$message({type: 'error', duration:2000, message: msg });
	},
	openloading() {
		return vm.$loading({
	          lock: false,
	          text: 'Loading...',
	          spinner: 'el-icon-loading',
	          customClass:'xy-el-loading',
	          background: 'rgba(255,255,255,0.8)'
	        });
	},
	/*消息提示*/
	number_format(number, decimals, dec_point, thousands_sep) {
	    /*
	    * 参数说明：
	    * number：要格式化的数字
	    * decimals：保留几位小数
	    * dec_point：小数点符号
	    * thousands_sep：千分位符号
	    * */
	    number = (number + '').replace(/[^0-9+-Ee.]/g, '');
	    var n = !isFinite(+number) ? 0 : +number,
	        prec = !isFinite(+decimals) ? 0 : Math.abs(decimals),
	        sep = (typeof thousands_sep === 'undefined') ? ',' : thousands_sep,
	        dec = (typeof dec_point === 'undefined') ? '.' : dec_point,
	        s = '',
	        toFixedFix = function (n, prec) {
	            var k = Math.pow(10, prec);
	            return '' + Math.ceil(n * k) / k;
	        };
	  
	    s = (prec ? toFixedFix(n, prec) : '' + Math.round(n)).split('.');
	    var re = /(-?\d+)(\d{3})/;
	    while (re.test(s[0])) {
	        s[0] = s[0].replace(re, "$1" + sep + "$2");
	    }
	  
	    if ((s[1] || '').length < prec) {
	        s[1] = s[1] || '';
	        s[1] += new Array(prec - s[1].length + 1).join('0');
	    }
	    return s.join(dec);
	},
	PrefixZero(num, n) {
	    return (Array(n).join(0) + num).slice(-n);
	},
	Date:{
		getMStoYear(time_stamp){
			if (time_stamp) {
			    var time=new Date().getTime();
			    var time1=time_stamp;
			    if (typeof time1 != 'number')
			    	time1=new Date(time1).getTime();
			    if (time1>0) {
				    time=parseInt(time-time1);
				    return parseInt(time/(3600*24*365*1000));
			    }else return time_stamp;
			}else return time_stamp;
		},
		date(format,time_stamp){
		    var time=new Date().getTime();
			if (time_stamp) time=time_stamp;
			var dateObj=new Date(time);
			format=format.replace(/Y/g, dateObj.getFullYear());
			format=format.replace(/m/g, XYBase.PrefixZero(dateObj.getMonth()+1,2));
			format=format.replace(/d/g, XYBase.PrefixZero(dateObj.getDate(),2));
			format=format.replace(/H/g, XYBase.PrefixZero(dateObj.getHours(),2));
			format=format.replace(/i/g, XYBase.PrefixZero(dateObj.getMinutes(),2));
			format=format.replace(/s/g, XYBase.PrefixZero(dateObj.getSeconds(),2));
			return format
		},
		getDatetoDay(time_stamp){
			if (time_stamp) {
			    var time=new Date().getTime();
			    var time1=time_stamp;
			    if (typeof time1 != 'number')
			    	time1=new Date(time1).getTime();
			    if (time1>0) {
				    time=parseInt(time1-time);
				    return parseInt(time/(3600*24*1000));
			    }else return time_stamp;
			}else return time_stamp;
		},
		getStoTime(s,format){
		  var leave1=s%(24*3600);
		  var hours=Math.floor(leave1/3600);
		  var leave2=leave1%3600;
		  var minutes=Math.floor(leave2/60);
		  var leave3=leave2%60;
		  var seconds=Math.round(leave3);
		  if (format) {
		  	if (hours){
				format=format.replace(/H/g, XYBase.PrefixZero(hours,2));
		  	}else{
				format=format.replace(/H小时/g,'');
		  	}
		  	if (minutes){
				format=format.replace(/i/g, XYBase.PrefixZero(minutes,2));
		  	}else{
				format=format.replace(/i分/g,'');
		  	}
			format=format.replace(/s/g, XYBase.PrefixZero(seconds,2));
			return format
		  }else{
			  return {h:XYBase.PrefixZero(hours,2),m:XYBase.PrefixZero(minutes,2),s:XYBase.PrefixZero(seconds,2)};
		  }
		},
	},
	/*控制页面展示*/
	view:{
		mask:true,
		message_count:0,
		message_count_er:null,
	},
	/*控制页面展示*/
	loginTabs:{
		nav:'username',
		loginWin:false,
		qrlogin:'',
		qrloginImgUrl:'',
		scanQrSuccess:false,
		is_imgcode:_config.is_imgcode,
		is_imgcode_back:_config.is_imgcode,
		captcha_type:_config.captcha_type,
		btn:{
			loading:false,
			submit:true,
			getVcode:true,
			getVcodeText:'获取验证码',
			vcodeTimeIntervalId:null,
			vcodeDefaultTime:_config.vcodeDefaultTime,
			vcodeTime:_config.vcodeDefaultTime
		},
		form:{
			username:'',
			password:'',
			cache:'',
			vcode:'',
			tsec:null,
			imgcode:''
		}
	},
	/*反馈控制台*/
	feedback:{
		win:false,
		btn:{
			loading:false,
		},
		data:{
			id:0
		},
		form:{
			type:1,
			alias_id:'',
			contacts:'',
			content:'',
		},
        rules: {
          type: [
            { required: true, message: '请选择反馈类型', trigger: 'change' },
          ],
          contacts: [
            { required: true, message: '请输入联系方式', trigger: 'blur' },
          ],
          content: [
            { required: true, message: '请输入反馈内容', trigger: 'blur' },
          ],
        }
	},
	/*支付控制台*/
	buy:{
		view:false,
		pay_status:'',
		title:'',
		stitle:'',
		showJobsList:false,
		showCoupon:false,
		showSelectedJobs:false,
		ajax:false,
		orderTimeEr:null,
		score:0,
		proportion_price:0,
		price:0,
		score_price:0,
		coupon_price:0,
		orderInfo:{
			otrade:'',
			url:'',
			time:0,
		},
		form:{
			otrade:'',
			alias_id:'',
			value:'',
			type:'',
			pay_type:'',
			selected_coupon:[],
			score:0,
		},
		selected_coupon:[],
		search_coupon:{
			ajax:'more',
			status:1,
			page:1
		},
		coupon_not:[],
		coupon:[],
		listData:[],
		data:{},
		data1:{}
	},
	/*监听页面数据变化*/
	viewWatch:{
		handler(val,oldVal){
		},
		deep:true
	},
	loginTabsWatch:{
		handler(val,oldVal){
			if (!val.btn.vcodeTimeIntervalId && val.form.username){
				if(XYBase.pattern.mobile.test(val.form.username) 
					|| XYBase.pattern.email.test(val.form.username)){
					val.btn.getVcode=false;
				}else val.btn.getVcode=true;
			}else val.btn.getVcode=true;
			if (val.nav === 'username') {
				if ((XYBase.pattern.mobile.test(val.form.username) 
					|| XYBase.pattern.email.test(val.form.username))
					&& val.form.password) {
					val.btn.submit=false;
				}else val.btn.submit=true;
			}else{
				if ((XYBase.pattern.mobile.test(val.form.username) 
					|| XYBase.pattern.email.test(val.form.username))
					&& val.form.vcode) {
					val.btn.submit=false;
				}else val.btn.submit=true;
			}
			if (val.loginWin) {
				$('body').addClass('el-popup-parent--hidden').attr('style','padding-right:17px;');
			}else{
				$('body').removeClass('el-popup-parent--hidden').attr('style','');
			}
			if(val.nav=='vcode'){
				val.is_imgcode=1;
			}else{
				val.is_imgcode=val.is_imgcode_back;
			}
		},
		deep:true
	},
	/*初始化页面*/
	created(_this,callback){
		_this.view.mask=false;
		_this.getCaptcha();
		if (typeof callback=='function')
			callback();
		_this.createGetUnreadMessage();
	},
	/*公共函数*/
	methods(obj) {
		var baseObj={
			closeLoginWin(){
				this.loginTabs.nav='username';
				this.loginTabs.loginWin=false;
			},
			createGetUnreadMessage(){
				var _this=this;
				if(_this.userInfo.id){
					_this.getUnreadMessage();
					_this.view.message_count_er=setInterval(function(){
						_this.getUnreadMessage();
					},60000);
				}
			},
			getUnreadMessage(){
				var _this=this;
				_this.sendGet({
					url:'/getUnreadMessage',
					error:function(){},
					success:function(ret){
						if(ret){
							if(ret.code===0){
								_this.view.message_count=ret.data.message_count
								if(_this.view.message_count>0){
									_this.$notify.info({
							          title: '消息提示',
							          message: '您有'+_this.view.message_count+'条未读消息，点击查看',
							          position: 'bottom-right',
							          onClick:function(){
							          	window.open('/user/myMessage');
							          }
							        });
								}
							}
						}
					}
				})
			},
			sendSearch(){
				if (!this.search.key)return;
				switch(this.search.type){
					case 1:
					window.open('/jobs?key='+this.search.key);
					break;
					case 2:
					window.open('/resume?key='+this.search.key);
					break;
					case 3:
					window.open('/company?key='+this.search.key);
					break;
				}
			},
			sendVcode(Data,btnData,callback){
				if (!Data.username)
					return XYBase.warning('请输入账号');
				if(!XYBase.pattern.mobile.test(Data.username) 
					&& !XYBase.pattern.email.test(Data.username))
					return XYBase.warning('请输入正确的账号');
				if (btnData.vcodeTimeIntervalId) return;
				if (XYBase.pattern.mobile.test(Data.username))
					Data.is_username_type='mobile';
				if (XYBase.pattern.email.test(Data.username))
					Data.is_username_type='email';
					Data.type=_config.action;
				$.ajax({
					url:'/getVcode',
					type:'post',
					data:Data,
					dataType:'json',
					error:function(err){
						if (typeof callback=='function')callback();
						XYBase.error(XYBase.config.system_network_error);
					},
					success:function(ret){
						if (typeof callback=='function')callback(ret);
						if (ret) {
							if (ret.code === 0) {
								Data.vcode='';
								btnData.vcodeTimeIntervalId=setInterval(function(){
									btnData.vcodeTime--;
									if (btnData.vcodeTime) {
										btnData.getVcode=true;
										btnData.getVcodeText=btnData.vcodeTime+'s';
									}else{
										clearInterval(btnData.vcodeTimeIntervalId);
										btnData.vcodeTimeIntervalId=null;
										btnData.getVcode=false;
										btnData.vcodeTime=btnData.vcodeDefaultTime;
										btnData.getVcodeText='获取验证码';
									}
								},1000);
								XYBase.success(ret.msg);
							}else{
								XYBase.msg(ret.msg);
							}
						}else{
							XYBase.error(XYBase.config.system_network_error);
						}
					}
				});
			},
			getVcode(){
				var _this=this;
				var Data=_this.loginTabs.form,
					btnData=_this.loginTabs.btn;
					if(this.loginTabs.is_imgcode){
						switch(this.loginTabs.captcha_type){
							case 1:
								if (CaptchaResultObj)
		          				Data.geetest=CaptchaResultObj.getValidate();
							break
							case 2:
								if (CaptchaResultObj)
		          				Data.vaptcha=CaptchaResultObj.getToken();
							break
						}
					}
					_this.sendVcode(Data,btnData);
			},
			verificationVcode(Data,callback){
				if (!Data.username)
					return XYBase.warning('请输入账号');

				if(!XYBase.pattern.mobile.test(Data.username) 
					&& !XYBase.pattern.email.test(Data.username))
					return XYBase.warning('请输入正确的账号');

				if (!Data.vcode)
					return XYBase.warning('请输入验证码');

				if (XYBase.pattern.mobile.test(Data.username))
					Data.is_username_type='mobile';
				if (XYBase.pattern.email.test(Data.username))
					Data.is_username_type='email';
					Data.type=_config.action;
				if(this.loginTabs.is_imgcode){
					switch(this.loginTabs.captcha_type){
						case 1:
							if (CaptchaResultObj)
	          				Data.geetest=CaptchaResultObj.getValidate();
						break
						case 2:
							if (CaptchaResultObj)
	          				Data.vaptcha=CaptchaResultObj.getToken();
						break
					}
				}
				$.ajax({
					url:'/verificationVcode',
					type:'post',
					data:Data,
					dataType:'json',
					error:function(err){
						if (typeof callback=='function')callback();
						XYBase.error(XYBase.config.system_network_error);
					},
					success:function(ret){
						if (typeof callback=='function')callback(ret);
						if (ret) {
							if (ret.code === 0) {
							}else{
								XYBase.msg(ret.msg);
							}
						}else{
							XYBase.error(XYBase.config.system_network_error);
						}
					}
				});
			},
			login(){
				var _this=this;
				var Data=_this.loginTabs.form,
					url='/login',
					is_login=true;
				if (this.loginTabs.nav!='username'){
					url='/login/vcode';
					is_login=false;
				}
				if (!Data.username)
					return XYBase.warning('请输入账号');
				if(!XYBase.pattern.mobile.test(Data.username) 
					&& !XYBase.pattern.email.test(Data.username))
					return XYBase.warning('请输入正确的账号');
				if (is_login) {
					if (!Data.password)
						return XYBase.warning('请输入密码');
				}else{
					if (!Data.vcode)
						return XYBase.warning('请输入验证码');
				}
				if (XYBase.pattern.mobile.test(Data.username))
					Data.is_username_type='mobile';
				if (XYBase.pattern.email.test(Data.username))
					Data.is_username_type='email';
				if(this.loginTabs.is_imgcode){
					switch(this.loginTabs.captcha_type){
						case 1:
							if (CaptchaResultObj)
	          				Data.geetest=CaptchaResultObj.getValidate();
						break
						case 2:
							if (CaptchaResultObj)
	          				Data.vaptcha=CaptchaResultObj.getToken();
						break
					}
				}

				this.loginTabs.btn.loading=true;
				$.ajax({
					url:url,
					type:'post',
					data:Data,
					dataType:'json',
					error:function(err){
						_this.loginTabs.btn.loading=false;
						XYBase.error(XYBase.config.system_network_error);
					},
					success:function(ret){
						_this.loginTabs.btn.loading=false;
						if (ret) {
							if (ret.code === 0) {
								_this.loginTabs.is_imgcode=0;
								_this.loginTabs.is_imgcode_back=0;
								_this.loginTabs.loginWin=false;
								UserInfo=ret.data;
								_this.userInfo=ret.data;
								if(typeof openSocket==='function')
									openSocket();
								if(typeof IMServer.openIm==='function')
									IMServer.openIm();
								if (!_this.view.message_count_er)
									_this.createGetUnreadMessage();
		          			}else if(ret.code === 1001){
		          				_this.loginTabs.is_imgcode=1;
		          				_this.loginTabs.is_imgcode_back=1;
		          				XYBase.msg(ret.msg);
							}else{
								XYBase.msg(ret.msg);
							}
						}else{
							XYBase.error(XYBase.config.system_network_error);
						}
		          		_this.getCaptcha();
					}
				});
			},
			getTimeoutCaptcha(){
				var _this=this;
				setTimeout(function(){
					_this.getCaptcha();
				},500);
			},
		    getCaptcha(){
		    	var _this=this;
				if(this.loginTabs.is_imgcode){
					switch(this.loginTabs.captcha_type){
						case 1:
							this.getGeeTestParam();
						break;
						case 2:
				        this.$nextTick(_ => {
					      	$(".vaptchaContainer").each(function(k,v){
					      		if($(v).is(":visible")){
									vaptcha({
									    vid: _config.captchavaptcha,
									    type: 'click',
									    container: v,
									}).then(function (vaptchaObj) {
										CaptchaResultObj=vaptchaObj;
									    vaptchaObj.render();
									})
					      		}
					      	})
				        });
						break;
						case 4:
					        this.$nextTick(_ => {
					        	this.loginTabs.form.tsec=null;
						      	$(".TencentCaptchaEl").each(function(k,v){
						      		if($(v).is(":visible")){
										new TencentCaptcha(v);
						      		}
						      	})
					        });
						break;
						default:
				        this.$nextTick(_ => {
							$('.captcha').attr('src','/captcha?t='+(new Date()).getTime());
							this.loginTabs.form.imgcode='';
							this.$forceUpdate()
				        });
					}
				}
		    },
		    getGeeTestParam(){
				$.ajax({
				    url: "/captcha?t=" + (new Date()).getTime(), // 加随机数防止缓存
				    type: "get",
				    dataType: "json",
				    success: function (data) {
				        initGeetest({
				            gt: data.gt,
				            challenge: data.challenge,
				            new_captcha: data.new_captcha,
				            offline: !data.success,
				            product: "float",
				            width: "100%"
				        },vm.GeeTestHandler);
				    }
				});
		    },
		    GeeTestHandler(captchaObj){
		      	var _this=this;
		      	CaptchaResultObj=captchaObj;
		      	$(".GeeTestCaptcha").html('');
		      	$(".GeeTestCaptcha").each(function(k,v){
		      		if($(v).is(":visible")){
			    		captchaObj.appendTo(v);
		      		}
		      	})
			    captchaObj.onReady(function () {
			    });
		    },
		    TencentCaptchaCallback(res){
				if(res.ret === 0){
		      		CaptchaResultObj=res;
		      		if(this.registerTabs)
		      			this.registerTabs.form.tsec=res;
		      		this.loginTabs.form.tsec=res;
				}
		    },
			outLogin(){
				var _this=this;
				_this.$confirm('您确定要注销登录吗？', '提示', {
			          confirmButtonText: '注销',
			          cancelButtonText: '取消',
			          type: 'warning'
			        }).then(() => {
			        	const loading=XYBase.openloading();
			        	_this.sendGet({
			        		url:'/outLogin'
			        	},function(ret){
							loading.close();
			        		if (ret) {
			        			if (ret.code==0) {
									_this.userInfo={id:0,nickname:'',headimg:''};
									if (typeof IMvm==='object')
										IMvm.userInfo={id:0,nickname:'',headimg:''};
									if(typeof closeSocket==='function')
										closeSocket();
			        				if(_this.view.message_count_er){
			        					clearInterval(_this.view.message_count_er);
			        					_this.view.message_count_er=null;
			        				}
			        			}else{
									XYBase.error(ret.msg);
			        			}
			        		}
			        	})
			        }).catch(() => {
			        	XYBase.msg('已取消');
			        });
			},
			signInToday(){
				var _this=this;
	        	const loading=XYBase.openloading();
	        	_this.sendGet({
	        		url:'/user/score/signInToday'
	        	},function(ret){
					loading.close();
	        		if (ret) {
	        			if (ret.code==0) {
							_this.userInfo.sign_in_status=1;
							_this.userInfo.score=_this.userInfo.score+ret.data.score;
							if (typeof _this.updateScoreTask=='function')
								_this.updateScoreTask();
	        			}else{
							XYBase.error(ret.msg);
	        			}
	        		}
	        	})
			},
			goToPersonal(){
				var _this=this;
				_this.$confirm('您确定要切换到个人用户吗？', '提示', {
			          confirmButtonText: '切换',
			          cancelButtonText: '取消',
			          type: 'warning'
			        }).then(() => {
			        	const loading=XYBase.openloading();
			        	_this.sendGet({
			        		url:'/user/goToPersonal'
			        	},function(ret){
							loading.close();
			        		if (ret) {
								if(ret.code == 0){
									window.location.reload();
								}else{
									XYBase.error(ret.msg);
								}
			        		}
			        	})
			        }).catch(() => {
			        	XYBase.msg('已取消');
			        });
			},
			goToCompany(){
				var _this=this;
				_this.$confirm('您确定要切换到企业用户吗？', '提示', {
			          confirmButtonText: '切换',
			          cancelButtonText: '取消',
			          type: 'warning'
			        }).then(() => {
			        	const loading=XYBase.openloading();
			        	_this.sendGet({
			        		url:'/user/goToCompany'
			        	},function(ret){
							loading.close();
			        		if (ret) {
								if(ret.code == 0){
									window.location.reload();
								}else{
									XYBase.error(ret.msg);
								}
			        		}
			        	})
			        }).catch(() => {
			        	XYBase.msg('已取消');
			        });
			},
			refreshResume(){
				var _this=this;
	        	const loading=XYBase.openloading();
	        	_this.sendGet({
	        		url:'/user/resume/setResumeRefreshTime'
	        	},function(ret){
					loading.close();
	        		if (ret) {
						if(ret.code == 0){
							XYBase.success(ret.msg);
						}else{
							XYBase.msg(ret.msg);
						}
	        		}
	        	})
			},
			getHtml(str){
		        return str?str.replace(/\n/g, '<br/>'):'';
			},
			initRequest(type,httpConfig,callback){
				var _this=this;
				return Object.assign({
					url:'',
					type:type,
					data:{},
					dataType:'json',
					error:function(err){
						XYBase.error(XYBase.config.system_network_error);
						if (typeof callback=='function') callback();
					},
					success:function(ret){
						if (ret) {
							if (ret.code === -20000) {
								_this.loginTabs.loginWin=true;
								callback();
							}else{
								if (typeof callback=='function') callback(ret);
							}
						}else{
							XYBase.error(XYBase.config.system_network_error);
							if (typeof callback=='function') callback(ret);
						}
					}
				},httpConfig);
			},
			sendPost(httpConfig,callback){
				$.ajax(this.initRequest('POST',httpConfig,callback));
			},
			sendGet(httpConfig,callback){
				$.ajax(this.initRequest('GET',httpConfig,callback));
			},
			toggleJobsCollection(row,index){
				var _this=this;
				if (row.is_collection) {
					_this.$confirm('确定要取消收藏吗？', '提示', {
						dangerouslyUseHTMLString:true,
			          	confirmButtonText: '确定',
			          	cancelButtonText: '取消',
			          	type: 'warning'
			        }).then(() => {
			        	_this.sendGet({
			        		url:'/jobs/toggleJobsCollection/'+row.id
			        	},function(ret){
			        		if (ret) {
			        			if (ret.code === 0) {
			        				row.is_collection=0;
			        			}else{
			        				XYBase.msg(ret.msg);
			        			}
			        		}
			        	});
			        }).catch(() => {
			        });
				}else{
		        	_this.sendGet({
		        		url:'/jobs/toggleJobsCollection/'+row.id
		        	},function(ret){
		        		if (ret) {
		        			if (ret.code === 0) {
		        				row.is_collection=1;
		        			}else{
		        				XYBase.msg(ret.msg);
		        			}
		        		}
		        	});
				}
			},
			toggleCompanyCollection(row,index){
				var _this=this;
				if (row.is_collection) {
					_this.$confirm('确定要取消关注吗？', '提示', {
						dangerouslyUseHTMLString:true,
			          	confirmButtonText: '确定',
			          	cancelButtonText: '取消',
			          	type: 'warning'
			        }).then(() => {
			        	_this.sendGet({
			        		url:'/company/toggleCompanyCollection/'+row.id
			        	},function(ret){
			        		if (ret) {
			        			if (ret.code === 0) {
			        				row.is_collection=0;
			        			}else{
			        				XYBase.msg(ret.msg);
			        			}
			        		}
			        	});
			        }).catch(() => {
			        });
				}else{
		        	_this.sendGet({
		        		url:'/company/toggleCompanyCollection/'+row.id
		        	},function(ret){
		        		if (ret) {
		        			if (ret.code === 0) {
		        				row.is_collection=1;
		        			}else{
		        				XYBase.msg(ret.msg);
		        			}
		        		}
		        	});
				}
			},
			toggleResumeCollection(row,index){
				var _this=this;
				if (row.is_collection) {
					_this.$confirm('确定要取消关注吗？', '提示', {
						dangerouslyUseHTMLString:true,
			          	confirmButtonText: '确定',
			          	cancelButtonText: '取消',
			          	type: 'warning'
			        }).then(() => {
			        	_this.sendGet({
			        		url:'/resume/toggleResumeCollection/'+row.id
			        	},function(ret){
			        		if (ret) {
			        			if (ret.code === 0) {
			        				row.is_collection=0;
			        			}else{
			        				XYBase.msg(ret.msg);
			        			}
			        		}
			        	});
			        }).catch(() => {
			        });
				}else{
		        	_this.sendGet({
		        		url:'/resume/toggleResumeCollection/'+row.id
		        	},function(ret){
		        		if (ret) {
		        			if (ret.code === 0) {
		        				row.is_collection=1;
		        			}else{
		        				XYBase.msg(ret.msg);
		        			}
		        		}
		        	});
				}
			},
			deliveryResume(row,data){
				var _this=this;
				const loading=XYBase.openloading();
				if (!data)
					data={};
				data.confirm=_this.confirm;
				_this.sendGet({
					url:'/deliveryResume/'+row.id,
					data:data
				},function(ret) {
		        	_this.confirm=0;
					loading.close();
					if (ret) {
						if (ret.code === 0) {
							row.is_delivery=1;
							XYBase.success(ret.msg);
						}else if(ret.code === 200){
							_this.$confirm(ret.msg, '提示', {
								dangerouslyUseHTMLString:true,
					          	confirmButtonText: '确定',
					          	cancelButtonText: '取消',
					          	type: 'warning'
					        }).then(() => {
					        	_this.confirm=1;
					        	_this.deliveryResume(row);
					        }).catch(() => {
					        });
						}else if(ret.code === -600){
							_this.$confirm(ret.msg, '提示', {
					          confirmButtonText: '去完善',
					          cancelButtonText: '取消',
					          type: 'warning'
					        }).then(() => {
					        	window.open('/user');
					        }).catch(() => {
					        	XYBase.msg('已取消');
					        });
						}else{
							XYBase.msg(ret.msg);
						}
					}
				});
			},
			orderPaySuccess(val) {
				if (!this.hasOwnProperty('buy'))
					return ;
				if (val.otrade===this.buy.orderInfo.otrade)
					this.buy.pay_status='success';
				if (this.buy.orderTimeEr)
					clearInterval(this.buy.orderTimeEr);
			},
			setPayType(type){
				this.buy.form.pay_type=type;
				this.buy.orderInfo.otrade='';
				this.buy.orderInfo.url='';
			},
			generateOrderInfo(){
				if (this.buy.ajax)return;
				if (!this.buy.form.pay_type)return XYBase.msg('请选择支付方式');
				this.buy.ajax=true;
				this.buy.orderInfo.otrade='';
				this.buy.orderInfo.url='';
				var _this=this;
				_this.sendPost({
					url:'/pay/generateOrderInfo',
					data:_this.buy.form
				},function(ret) {
					_this.buy.ajax=false;
					if (ret) {
						if (ret.code === 0) {
							if (_this.buy.orderTimeEr)
		   						clearInterval(_this.buy.orderTimeEr);
							_this.buy.orderTimeEr=setInterval(function(){
								if (_this.buy.orderInfo.time<=0){
		   							clearInterval(_this.buy.orderTimeEr);
		   							_this.buy.orderTimeEr=null;
		   							_this.buy.orderInfo={
										otrade:'',
										url:'',
										time:0,
									}
									_this.buy.form.pay_type='';
								}
								_this.buy.orderInfo.time--;
							},1000);
							_this.clearCoupon();
							return _this.buy.orderInfo=ret.data;
						}else if(ret.code === 10000){
							_this.buy.orderInfo.otrade=ret.data.otrade;
							_this.buy.pay_status='success';
							_this.clearCoupon();
						}else{
							XYBase.msg(ret.msg);
						}
					}
					_this.buy.form.pay_type='';
				});
			},
			closeNewBuy(){
	    		document.body.style="";
	    		this.buy.view=false;
	    		this.buy.showJobsList=false;
	    		this.buy.showCoupon=false;
	    		this.buy.showSelectedJobs=false;
	    		this.buy.title='';
	    		this.buy.stitle='';
	    		this.buy.form.pay_type='';
	    		this.buy.form.alias_id='';
	    		this.buy.form.type='';
	    		this.buy.form.value='';
					this.buy.orderInfo.otrade='';
					this.buy.orderInfo.url='';
					this.buy.pay_status='';
					this.buy.coupon_price=0;
					this.buy.selected_coupon=[];
					this.buy.form.selected_coupon=[];
	    		this.buy.listData=[];
	    		this.buy.data={};
	    		this.buy.data1={};
			},
			clearCoupon(){
	    	this.buy.showCoupon=false;
				this.buy.coupon_not=[];
				this.buy.coupon=[];
				this.buy.selected_coupon=[];
				this.buy.form.selected_coupon=[];
				this.buy.search_coupon.ajax='more';
				this.buy.search_coupon.page=1;
			},
			buyListDataCurrent(val){
				this.buy.data=val;
	    	this.buy.form.alias_id=val.id;
				this.buy.orderInfo.otrade='';
				this.buy.orderInfo.url='';
				if (this.userInfo.company_vip_level>0) {
					this.buy.price=val.discount.vip>0?val.price*(val.discount.vip/100):val.price;
				}else{
					this.buy.price=val.discount.ordinary>0?val.price*(val.discount.ordinary/100):val.price;
				}
				this.getScoreOrderPrice();
				this.changeCouon();
				if (this.buy.orderTimeEr)
					clearInterval(this.buy.orderTimeEr);
			},
			buyListJobsDataCurrent(val){
				this.buy.data1=val;
	    		this.buy.form.value=val.id;
	    		this.buy.showJobsList=false;
				this.buy.orderInfo.otrade='';
				this.buy.orderInfo.url='';
				if (this.buy.orderTimeEr)
					clearInterval(this.buy.orderTimeEr);
			},
			getScoreOrderPrice(){
				var price=this.buy.price;
				if (this.buy.form.score) {
					var scorePrice=this.userInfo.score/this.xy_score.recharge_rate;
					var price1= Math.floor(price);
					if (this.xy_score.is_integer) {
						//可以低多少钱
						let proportion_price=parseInt(price1*(this.xy_score.proportion/100));
						if (scorePrice>=proportion_price) {
							this.buy.proportion_price=proportion_price.toFixed(2);
							this.buy.score=parseInt(this.xy_score.recharge_rate*proportion_price);
							price=(price-proportion_price).toFixed(2);
						}else{
							this.buy.proportion_price=scorePrice.toFixed(2);
							this.buy.score=parseInt(this.buy.proportion_price*this.xy_score.recharge_rate);
							price=(price-this.buy.proportion_price).toFixed(2);
						}
					}else{
						//可以低多少钱
						let proportion_price=price1*(this.xy_score.proportion/100);
						if (scorePrice>=proportion_price) {
							this.buy.proportion_price=proportion_price.toFixed(2);
							this.buy.score=parseInt(this.xy_score.recharge_rate*proportion_price);
							price=(price-proportion_price).toFixed(2);
						}else{
							this.buy.proportion_price=scorePrice.toFixed(2);
							this.buy.score=parseInt(scorePrice*this.xy_score.recharge_rate);
							price=(price-scorePrice).toFixed(2);
						}

					}
				}
				this.buy.score_price=price;
			},
			setPriceScoreChange(){
				this.buy.score=0;
				this.buy.proportion_price=0;
				this.buy.orderInfo.otrade='';
				this.buy.orderInfo.url='';
				this.getScoreOrderPrice();
			},
			useCoupon(val){
				var index=this.buy.form.selected_coupon.indexOf(val.alias);
				if (index!==-1) {
					this.buy.selected_coupon.splice(index,1);
					this.buy.form.selected_coupon.splice(index,1);
					this.changeCouon();
				}else{
					if (this.hasCouponIsUse(val))return;
					if (this.buy.form.selected_coupon.length&&!val.superposition){
						for (var x in this.buy.selected_coupon) {
							if (!this.buy.selected_coupon[x].superposition){
								this.buy.selected_coupon.splice(x,1);
								this.buy.form.selected_coupon.splice(x,1);
								break;
							}
						}
					}
					this.buy.selected_coupon.push(val);
					this.buy.form.selected_coupon.push(val.alias);
					this.changeCouon();
				}
			},
			changeCouon(){
				var coupon_price=0;
				for (var x in this.buy.selected_coupon) {
					if(this.buy.selected_coupon[x].type){
						coupon_price+=this.buy.score_price-parseFloat((this.buy.score_price*(this.buy.selected_coupon[x].discount/100)).toFixed(2));
					}else{
						coupon_price+=this.buy.selected_coupon[x].price;
					}
				}
				this.buy.coupon_price=parseFloat(coupon_price.toFixed(2));
			},
			hasCouponIsUse(val){
				if (val.alias_type.length&&val.alias_type.indexOf(this.buy.form.type)===-1){
					return true;
				}
				if (val.satisfy_price>this.buy.price){
					return true;
				}
				if (val.vip_level>this.userInfo.company_vip_level){
					return true;
				}
				return false;
			},
			showCoupon(){
				this.buy.showCoupon= !this.buy.showCoupon;
			},
			getCoupon(){
				var _this=this;
				if(_this.buy.search_coupon.ajax=='loading'
					||_this.buy.search_coupon.ajax=='noMore')return;
				_this.buy.search_coupon.ajax='loading';
				_this.sendGet({
					url:'/user/vip/coupon',
					data:_this.buy.search_coupon
				},function(ret) {
					if (ret) {
						if (ret.code === 0) {
							if (ret.data.last_page>ret.data.current_page) {
								_this.buy.search_coupon.ajax='more';
								_this.buy.search_coupon.page++;
							}else{
								_this.buy.search_coupon.ajax='noMore';
							}
							for (var i = 0; i < ret.data.data.length; i++) {
								ret.data.data[i].has_use=_this.hasCouponIsUse(ret.data.data[i]);
								if (ret.data.data[i].has_use) {
									_this.buy.coupon_not.push(ret.data.data[i]);
								}else{
									_this.buy.coupon.push(ret.data.data[i]);
								}
							}
						}else{
							_this.buy.search_coupon.ajax='noMore';
						}
					}
				});
			},
			showSiteMsg(message){
		        this.$notify.info({
		          title: message.title,
		          message: message.desc,
		          position: 'bottom-right',
		          onClick:function(){
		          	window.location.href='/user/myMessage';
		          }
		        });
			},
			showClientMsg(message){
		        this.$notify.info({
		          title: message.title,
		          message: message.desc,
		          position: 'bottom-right'
		        });
			},
			submitFeedbackForm:function(formName) {
				var _this=this;
				var D=_this.feedback.form;
				_this.$refs[formName].validate((valid) => {
				  if (valid) {
					const loading = XYBase.openloading();
					_this.sendPost({
						url:'/feedback',
						data:D,
					},function(ret){
				        loading.close();
				        if (ret) {
							if(ret.code == 0){
								_this.$refs[formName].resetFields();
								_this.feedback.data={id:0};
								_this.feedback.win=false;
								XYBase.success(ret.msg);
							}else{
								XYBase.msg(ret.msg);
							}
				        }
					});
				  } else {
					return XYBase.warning('请先把表单填写完整。');
				  }
				});
			},
			refreshCompanyJobsRefreshTime(){
				const loading = XYBase.openloading();
				this.sendGet({
					url:'/user/jobs/setCompanyJobsRefreshTime'
				},function(ret){
			        loading.close();
					if(ret){
						if(ret.code===0){
							XYBase.success(ret.msg);
						}else{
							XYBase.msg(ret.msg);
						}
					}
				});
			},
		};
		return Object.assign(baseObj,obj);
	}
}
if (window.location.protocol.toLowerCase()==='https')Push.Permission.request();
