<?php
namespace applepay;
use helper\URL;
class ApplePay{
    public static function checkPayInfo($D)
    {
        if (strlen($D['transactionReceipt'])<20)
            return ['status'=>0,'msg'=>'非法参数'];
        $result=json_decode(self::sendData($D),true);
        if(intval($result['status'])==21007){
            $D['sandbox']=1;
            $result=json_decode(self::sendData($D),true);
        }
        if(intval($result['status'])===0){
            return ['status'=>1,'data'=>$result['receipt']];
        }else{
            return ['status'=>0,'msg'=>'支付参数验证失败：'.$result['status']];
        }
    }
    public static function sendData($D)
    {
        $data=json_encode(['receipt-data'=>$D['transactionReceipt']]);
        //正式购买地址 沙盒购买地址
        $url_buy     = 'https://buy.itunes.apple.com/verifyReceipt';
        $url_sandbox = 'https://sandbox.itunes.apple.com/verifyReceipt';
        $url = isset($D['sandbox'])&&$D['sandbox'] ? $url_sandbox : $url_buy;
        $result=URL::post($url,$data);
        return $result;
    }
}
