<?php
namespace XYCms;
use think\facade\Cache;
use think\Exception;
use helper\URL;
class Im{
    private $_key='';
    private $_secret='';
    private $_url='https://open.xycms.com/im/';
    /**
     * 构造函数，
     * 读取配置
     */
    function __construct()
    {
        $this->_key         =   Cache::get('xy_xycms.key');
        $this->_secret      =   Cache::get('xy_xycms.secret');
        $this->_time        =   time();
        if (!$this->_key)
            throw new Exception('应用KEY不能为空');
        if (!$this->_secret)
            throw new Exception('应用Secret不能为空');
    }
    public function createContacts($D)
    {
        $this->_signature       =   md5($this->_key.$this->_time.$this->_secret);
        $data=[
            'key'                   =>  $this->_key,
            'time'                  =>  $this->_time,
            'signature'             =>  $this->_signature,
            'data'                  =>  $D
        ];
        $ret=URL::post($this->_url.'createContacts',json_encode($data));
        $results=empty($ret)?null:json_decode($ret,true);
        if ($results&&isset($results['code'])){
            if ($results['code']==0)
                return $results['data'];
            throw new Exception($results['msg'].'['.$results['code'].']');
        }
        throw new Exception('创建失败，请重试');
    }
    public function getContacts($D)
    {
        $this->_signature       =   md5($this->_key.$this->_time.$this->_secret);
        $data=[
            'key'                   =>  $this->_key,
            'time'                  =>  $this->_time,
            'signature'             =>  $this->_signature,
            'data'                  =>  $D
        ];
        $ret=URL::post($this->_url.'getContacts',json_encode($data));
        $results=empty($ret)?null:json_decode($ret,true);
        if ($results&&isset($results['code'])){
            if ($results['code']==0)
                return $results['data'];
            throw new Exception($results['msg'].'['.$results['code'].']');
        }
        throw new Exception('创建失败，请重试');
    }
    public function blackContacts($D)
    {
        $this->_signature       =   md5($this->_key.$this->_time.$this->_secret);
        $data=[
            'key'                   =>  $this->_key,
            'time'                  =>  $this->_time,
            'signature'             =>  $this->_signature,
            'data'                  =>  $D
        ];
        $ret=URL::post($this->_url.'blackContacts',json_encode($data));
        $results=empty($ret)?null:json_decode($ret,true);
        if ($results&&isset($results['code'])){
            if ($results['code']==0)
                return $results['data'];
            throw new Exception($results['msg'].'['.$results['code'].']');
        }
        throw new Exception('创建失败，请重试');
    }
    public function cancelBlackContacts($D)
    {
        $this->_signature       =   md5($this->_key.$this->_time.$this->_secret);
        $data=[
            'key'                   =>  $this->_key,
            'time'                  =>  $this->_time,
            'signature'             =>  $this->_signature,
            'data'                  =>  $D
        ];
        $ret=URL::post($this->_url.'cancelBlackContacts',json_encode($data));
        $results=empty($ret)?null:json_decode($ret,true);
        if ($results&&isset($results['code'])){
            if ($results['code']==0)
                return $results['data'];
            throw new Exception($results['msg'].'['.$results['code'].']');
        }
        throw new Exception('创建失败，请重试');
    }
}