<?php
namespace XYCms;
use app\common\model\WechatTemplate as WechatTemplateModel;
use think\facade\Cache;
use think\Exception;
use helper\URL;
use GetuiApi\GTClient;
use GetuiApi\request\push\GTPushRequest;
use GetuiApi\request\push\GTPushMessage;
use GetuiApi\request\push\GTNotification;
use GetuiApi\request\push\GTPushChannel;
use GetuiApi\request\push\ios\GTIos;
use GetuiApi\request\push\ios\GTAps;
use GetuiApi\request\push\ios\GTAlert;
use GetuiApi\request\push\android\GTAndroid;
use GetuiApi\request\push\android\GTUps;
use GetuiApi\request\push\android\GTThirdNotification;
/**
 * APP消息推送类
 * @Renloong
 * 2018/09/28
 */
class AppPush{
	private $is_send=true;
	private $BaseUrl='https://restapi.getui.com';
	private $appid='';
	private $key='';
	private $app_secret='';
	private $MasterSecret='';
	private $_access_token='';
	private $devices_id='';
	private $request_id='';
	private $Data=[];
	/**
	 * 构造函数，
	 * 读取配置
	 */
	public function __construct()
	{
		$this->appid=Cache::get('xy_getui.appid');
		$this->key=Cache::get('xy_getui.key');
		$this->app_secret=Cache::get('xy_getui.app_secret');
		$this->MasterSecret=Cache::get('xy_getui.ms');
	}
	public function setDevicesId($devices_id)
	{
		$this->devices_id=$devices_id;
        return $this;
	}
	public function setRequestId($request_id)
	{
		$this->request_id=$request_id;
        return $this;
	}
	public function setData($Data)
	{
		$this->Data=$Data;
        return $this;
	}
	/**
	 * 初始化
	 */
	public function send()
	{
	    $api = new GTClient($this->BaseUrl,$this->key, $this->appid,$this->MasterSecret);
	    //设置推送参数
	    $push = new GTPushRequest();
	    $push->setRequestId($this->request_id);
	    $message = new GTPushMessage();
	    $notify = new GTNotification();
	    $notify->setTitle($this->Data['title']);
	    $notify->setBody($this->Data['title']);
    	$notify->setPayload($this->Data['payload']);
	    $notify->setClickType("payload");
	    $message->setNotification($notify);
	    $push->setPushMessage($message);
	    $push->setCid($this->devices_id);
    	$pushChannel = new GTPushChannel();
	    //ios
	    $ios = new GTIos();
	    $ios->setType("notify");
	    $ios->setAutoBadge("1");
	    $ios->setPayload($this->Data['payload']);
	    $ios->setApnsCollapseId($this->request_id);
	    //aps设置
	    $aps = new GTAps();
	    $aps->setContentAvailable(0);
	    $alert = new GTAlert();
	    $alert->setTitle($this->Data['title']);
	    $alert->setBody($this->Data['content']);
	    $aps->setAlert($alert);
    	$ios->setAps($aps);
    	$pushChannel->setIos($ios);
	    //安卓
	    $android = new GTAndroid();
	    $ups = new GTUps();
	    $thirdNotification = new GTThirdNotification();
	    $thirdNotification->setTitle($this->Data['title']);
	    $thirdNotification->setBody($this->Data['content']);
	    $thirdNotification->setClickType(GTThirdNotification::CLICK_TYPE_PAYLOAD);
	    $thirdNotification->setPayload($this->Data['payload']);
	    $thirdNotification->setNotifyId($this->request_id);
	    $ups->setNotification($thirdNotification);
	    $android->setUps($ups);
	    $pushChannel->setAndroid($android);
    	$push->setPushChannel($pushChannel);
	    $result = $api->pushApi()->pushToSingleByCid($push);
	}
}