
-- ----------------------------
-- Table structure for xy_wechat_template
-- ----------------------------
DROP TABLE IF EXISTS `xy_wechat_template`;
CREATE TABLE `xy_wechat_template`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `number` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `tplid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `first` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `first_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `remark` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `remark_color` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `item_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `url` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `status` tinyint(1) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `alias`(`alias`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 17 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '微信-推送模板' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_wechat_template
-- ----------------------------
INSERT INTO `xy_wechat_template` VALUES (3, 'DeliveryResume', 'OPENTM205704066', '职位申请通知', '', '尊敬{u.nickname}，用户{name}向您发布的{title}职位投递了简历。', '#343434', '感谢您选择{webname}。 您可点击“查看详情”取消订阅此类型的通知。', '#343434', '[{\"title\":\"求职者\",\"value\":\"name\",\"color\":\"#343434\"},{\"title\":\"学历\",\"value\":\"educational_background\",\"color\":\"#343434\"},{\"title\":\"工作经验\",\"value\":\"work_experience\",\"color\":\"#343434\"},{\"title\":\"工作地点\",\"value\":\"area_city\",\"color\":\"#343434\"},{\"title\":\"需求薪资\",\"value\":\"salary\",\"color\":\"#343434\"}]', '', 1);
INSERT INTO `xy_wechat_template` VALUES (4, 'JobsExamine', 'OPENTM204819096', '职位审核提醒', '', '尊敬的{u.nickname}您好，您发布的职位信息审核{status}。', '#343434', '感谢您选择{webname}。 您可点击“查看详情”取消订阅此类型的通知。', '#343434', '[{\"title\":\"职位名称\",\"value\":\"title\",\"color\":\"#343434\"},{\"title\":\"审核结果\",\"value\":\"status\",\"color\":\"#343434\"},{\"title\":\"原因\",\"value\":\"msg\",\"color\":\"#343434\"}]', '', 1);
INSERT INTO `xy_wechat_template` VALUES (5, 'InviteAnInterview', 'OPENTM406932965', '面试通知', '', '{u.nickname}您好，您收到一份面试邀请，请登陆查看。', '#343434', '{remarks}\n记得准时参加哦~', '#343434', '[{\"title\":\"职位\",\"value\":\"{{keyword1.DATA}}\",\"color\":\"#343434\"},{\"title\":\"时间\",\"value\":\"{{keyword2.DATA}}\",\"color\":\"#343434\"},{\"title\":\"地点\",\"value\":\"{{keyword3.DATA}}\",\"color\":\"#343434\"}]', '', 1);
INSERT INTO `xy_wechat_template` VALUES (6, 'PaySuccess', 'OPENTM405840870', '会员消费提醒', '', '您好，您有一笔新的消费提醒！', '#343434', '感谢您对{webname}的支持！', '#343434', '[{\"title\":\"用户名\",\"value\":\"nickname\",\"color\":\"#343434\"},{\"title\":\"支付金额\",\"value\":\"oprice\",\"color\":\"#343434\"},{\"title\":\"消费类型\",\"value\":\"otitle\",\"color\":\"#343434\"},{\"title\":\"支付方式\",\"value\":\"pay_type\",\"color\":\"#343434\"},{\"title\":\"支付时间\",\"value\":\"pay_time\",\"color\":\"#343434\"}]', '', 1);
INSERT INTO `xy_wechat_template` VALUES (8, 'IMMessage', 'OPENTM401531258', '意向沟通提醒', '', '您好，您收到一个意向沟通提醒，请查看。', '#343434', '期待再次为您服务。', '#343434', '[{\"title\":\"姓名\",\"value\":\"nickname\",\"color\":\"#343434\"},{\"title\":\"适合意向\",\"value\":\"jobs_name\",\"color\":\"#343434\"},{\"title\":\"联系时间\",\"value\":\"time\",\"color\":\"#343434\"}]', '', 1);
INSERT INTO `xy_wechat_template` VALUES (9, 'SystemWarning', 'OPENTM413424353', '系统预警通知', '', '全能守夜人', '#343434', '请尽快处理', '#343434', '[{\"title\":\"预警类别\",\"value\":\"level\",\"color\":\"#343434\"},{\"title\":\"预警范围\",\"value\":\"range\",\"color\":\"#343434\"},{\"title\":\"发布时间\",\"value\":\"time\",\"color\":\"#343434\"},{\"title\":\"预警内容\",\"value\":\"msg\",\"color\":\"#343434\"}]', '', 1);
INSERT INTO `xy_wechat_template` VALUES (14, 'RealNameNotice', 'OPENTM417959522', '实名认证审核结果通知', '', '{hi_text}，实名审核{status}，请登陆查看。', '#343434', '如有疑问，请联系客服。', '#343434', '[{\"title\":\"审核状态\",\"value\":\"status\",\"color\":\"#343434\"},{\"title\":\"审核时间\",\"value\":\"time\",\"color\":\"#343434\"}]', '', 1);
INSERT INTO `xy_wechat_template` VALUES (15, 'ResumeExamine', 'OPENTM201786390', '简历审核结果通知', '', '你好！您的简历审核结果如下，敬请留意！', '#343434', '如有疑问，请联系客服。', '#343434', '[{\"title\":\"简历名称\",\"value\":\"name\",\"color\":\"#343434\"},{\"title\":\"审核时间\",\"value\":\"time\",\"color\":\"#343434\"},{\"title\":\"审核结果\",\"value\":\"status\",\"color\":\"#343434\"},{\"title\":\"审核原因\",\"value\":\"msg\",\"color\":\"#343434\"}]', '', 1);
INSERT INTO `xy_wechat_template` VALUES (16, 'SendOffer', 'OPENTM417124632', ' offer确认通知', '', '亲爱的{u.nickname} ,您的offer信息如下：', '#343434', '如有变动，请联系HR专员。', '#343434', '[{\"title\":\"候选人\",\"value\":\"name\",\"color\":\"#343434\"},{\"title\":\"职位\",\"value\":\"jobs_name\",\"color\":\"#343434\"},{\"title\":\"公司\",\"value\":\"company_name\",\"color\":\"#343434\"}]', '', 1);
