
-- ----------------------------
-- Table structure for xy_website_template
-- ----------------------------
DROP TABLE IF EXISTS `xy_website_template`;
CREATE TABLE `xy_website_template`  (
  `id` int(0) UNSIGNED NOT NULL AUTO_INCREMENT,
  `alias` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `desc` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL,
  `content` text CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL,
  `status` tinyint(1) NULL DEFAULT 1,
  PRIMARY KEY (`id`) USING BTREE,
  UNIQUE INDEX `alias`(`alias`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 32 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '站内信-推送模板' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of xy_website_template
-- ----------------------------
INSERT INTO `xy_website_template` VALUES (19, 'PaySuccess', '订单支付成功', '订单支付成功', '您的订单：{otitle}(订单号{otrade})已成功支付', '<p style=\"text-align: center;\">\n    您的订单：{otitle}(订单号{otrade})已成功支付。\n</p>', 1);
INSERT INTO `xy_website_template` VALUES (22, 'JobsExamine', '职位审核结果', '职位审核结果', '{hi_text}，您发布的职位{jobs_name}，{status}审核。', '<p>{hi_text}，您发布的职位{title}，{status}审核。</p>', 1);
INSERT INTO `xy_website_template` VALUES (23, 'DeliveryResume', '职位申请通知', '职位申请通知', '{nickname}恭喜您！有求职者申请了您发布的职位：{title}，请查看。', '<p>{u.nickname}恭喜您！有求职者申请了您发布的职位：{title}，请查看。</p>', 1);
INSERT INTO `xy_website_template` VALUES (25, 'InviteAnInterview', '邀请面试', '邀请面试', '{nickname}恭喜您！{company_name}邀请您面试：{jobs_name}职位！请及时查看。', '<p>{u.nickname}恭喜您！{company_name}邀请您面试：{jobs_name}职位！请及时查看。</p>', 1);
INSERT INTO `xy_website_template` VALUES (27, 'ComapnyVipExpire', '企业会员到期提醒', '企业会员到期提醒', '{company_name}：您的套餐{company_vip}将于{company_vip_time}到期，请及时续费。', '<p>\n    {company_name}：您的套餐{company_vip}将于{company_vip_time}到期，请及时续费。\n</p>', 1);
INSERT INTO `xy_website_template` VALUES (28, 'ResumeExamine', '简历审核结果', '简历审核结果', '{hi_text}，您的简历审核{status}，请登陆查看。', '<p>{hi_text}，您的简历审核{status}，请登陆查看。</p>', 1);
INSERT INTO `xy_website_template` VALUES (30, 'RealNameNotice', '实名结果通知', '实名结果通知', '{hi_text}，您的{id_type}{name}审核{status}。', '<p>{hi_text}，您的{id_type}{name}审核{status}。</p>', 1);
INSERT INTO `xy_website_template` VALUES (31, 'SendOffer', 'offer确认通知', 'offer确认通知', '', '<p style=\"box-sizing: border-box; margin-top: 0px; margin-bottom: 1rem; color: rgb(96, 98, 102); font-family: -apple-system, BlinkMacSystemFont, &quot;Segoe UI&quot;, Roboto, &quot;Helvetica Neue&quot;, Arial, &quot;Noto Sans&quot;, sans-serif, &quot;Apple Color Emoji&quot;, &quot;Segoe UI Emoji&quot;, &quot;Segoe UI Symbol&quot;, &quot;Noto Color Emoji&quot;; font-size: 14px; white-space: normal; background-color: rgba(255, 255, 255, 0.294);\"><span style=\"box-sizing: border-box; background-color: rgba(255, 255, 255, 0.05);\">亲爱的{name}，恭喜您收到了来自{company_name}的offer，请及时登录网站查看。</span></p>', 1);
